<?php

namespace Tests\Browser\Modules\Setup;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\Setup\Entities\State;
use Tests\DuskTestCase;

class StateTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $states = State::where('id', '>', 4121)->pluck('id');
        State::destroy($states);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/setup/location/state')
                    ->assertSee('State List');
        });
    }

    public function test_for_create_state(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#name', 'test-state')
                ->click('#create_form > div > div > div:nth-child(2) > div > div')
                ->click('#create_form > div > div > div:nth-child(2) > div > div > ul > li:nth-child(2)')
                ->click('#create_form > div > div > div.col-xl-12 > div > ul > li:nth-child(2) > label > span')
                ->click('#create_form > div > div > div.col-lg-12.text-center > div > button')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!');
        });
    }

    public function test_for_validate_create(){
        $this->browse(function (Browser $browser) {
            $browser->click('#create_form > div > div > div.col-lg-12.text-center > div > button')
                ->waitForTextIn('#error_name', 'The name field is required.',25)
                ->waitForTextIn('#error_country', 'The country field is required.', 25);
                
        });
    }

    public function test_for_edit_state(){
        $this->test_for_create_state();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#allData > tbody', 25)
                ->type('#allData_filter > label > input[type=search]', 'test-state')
                ->pause(10000)
                ->assertSeeIn('#allData > tbody > tr > td:nth-child(2)', 'test-state')
                ->click('#allData > tbody > tr > td:nth-child(5) > div > button')
                ->click('#allData > tbody > tr > td:nth-child(5) > div > div > a')
                ->waitFor('#edit_form', 25)
                ->type('#name', 'test-state-edit')
                ->click('#edit_form > div > div > div:nth-child(3) > div > div')
                ->click('#edit_form > div > div > div:nth-child(3) > div > div > ul > li:nth-child(3)')
                ->click('#edit_form > div > div > div.col-xl-12 > div > ul > li:nth-child(1) > label > span')
                ->click('#edit_form > div > div > div.col-lg-12.text-center > div > button')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_validate_edit_state(){
        $this->test_for_create_state();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#allData > tbody', 25)
                ->type('#allData_filter > label > input[type=search]', 'test-state')
                ->pause(10000)
                ->assertSeeIn('#allData > tbody > tr > td:nth-child(2)', 'test-state')
                ->click('#allData > tbody > tr > td:nth-child(5) > div > button')
                ->click('#allData > tbody > tr > td:nth-child(5) > div > div > a')
                ->waitFor('#edit_form', 25)
                ->type('#name', '')
                ->click('#edit_form > div > div > div.col-lg-12.text-center > div > button')
                ->waitForTextIn('#error_name', 'The name field is required.',25);
        });
    }

    public function test_for_status_change(){
        $this->test_for_create_state();
        $this->browse(function (Browser $browser) {
            $browser->waitFor('#allData > tbody', 25)
                ->type('#allData_filter > label > input[type=search]', 'test-state')
                ->pause(10000)
                ->assertSeeIn('#allData > tbody > tr > td:nth-child(2)', 'test-state')
                ->click('#allData > tbody > tr > td:nth-child(4) > label > div')
                ->pause(5000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');

        });        
    }
}
