<?php

namespace Tests\Browser\Modules\OrderManage;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Laravel\Dusk\Browser;
use Modules\OrderManage\Entities\CancelReason;
use Tests\DuskTestCase;

class CancelReasonTest extends DuskTestCase
{

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $reasons = CancelReason::pluck('id');
        CancelReason::destroy($reasons);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/ordermanage/cancel-reason')
                ->assertSee('Cancel Reason');
        });
    }

    public function test_for_create_reason(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#processForm > div > div > div:nth-child(1) > div > input', 'test reason')
                ->type('#processForm > div > div > div:nth-child(2) > div > textarea', 'test reason description')
                ->click('#processForm > div > div > div.col-lg-12.text-center > button')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Added successfully!');

        });
    }

    public function test_for_validate_create_form(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#processForm > div > div > div:nth-child(1) > div > input', '')
                ->type('#processForm > div > div > div:nth-child(2) > div > textarea', '')
                ->click('#processForm > div > div > div.col-lg-12.text-center > button')
                ->waitForTextIn('#name_create_error', 'The name field is required.', 25)
                ->assertSeeIn('#name_create_error','The name field is required.')
                ->assertSeeIn('#description_create_error','The description field is required.');

        });
    }


    public function test_for_edit_reason(){
        $this->test_for_create_reason();
        $this->browse(function (Browser $browser) {
            $browser->pause(8000)
                ->click('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > div > a.dropdown-item.edit_reason')
                ->waitForText('Edit cancel reason', 25)
                ->type('#processEditForm > div > div > div.col-xl-12 > div > input', 'test reason edit')
                ->type('#processEditForm > div > div > div:nth-child(3) > div > textarea', 'test reason des edit')
                ->click('#processEditForm > div > div > div.col-lg-12.text-center > button')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
                
        });
    }

    public function test_for_validate_edit_form(){
        $this->test_for_create_reason();
        $this->browse(function (Browser $browser) {
            $browser->pause(8000)
                ->click('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > div > a.dropdown-item.edit_reason')
                ->waitForText('Edit cancel reason', 25)
                ->type('#processEditForm > div > div > div.col-xl-12 > div > input', '')
                ->type('#processEditForm > div > div > div:nth-child(3) > div > textarea', '')
                ->click('#processEditForm > div > div > div.col-lg-12.text-center > button')
                ->waitForTextIn('#edit_name_error', 'The name field is required.', 25)
                ->assertSeeIn('#edit_name_error','The name field is required.')
                ->assertSeeIn('#edit_description_error','The description field is required.');
                
        });
    }

    public function test_for_delete_reason(){
        $this->test_for_create_reason();
        $this->browse(function (Browser $browser) {
            $browser->pause(8000)
                ->click('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > button')
                ->click('#DataTables_Table_1 > tbody > tr > td:nth-child(4) > div > div > a.dropdown-item.delete_item')
                ->whenAvailable('#confirm-delete > div > div > div.modal-body', function($modal){
                    $modal->click('#delete_link')
                        ->assertPathIs('/ordermanage/cancel-reason');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });        
    }
}
