<?php

namespace Tests\Browser\Modules\Marketing;

use App\Models\Subscription;
use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\Marketing\Entities\NewsLetter;
use Tests\DuskTestCase;
use Twilio\TwiML\Voice\Pause;

class NewsLetterTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();

        Subscription::create([
            'email' => 'spn21@spondonit.com',
            'status' => 1
        ]);

    }

    public function tearDown(): void
    {
        $news_letters = NewsLetter::pluck('id');
        NewsLetter::destroy($news_letters);

        $subscriptions = Subscription::pluck('id');
        Subscription::destroy($subscriptions);
        
        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/marketing/news-letter')
                    ->assertSee('News Letter List');
        });
    }

    public function test_for_alluser_create_newsletter()
    {
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div.container-fluid.p-0 > div > div.col-12 > div > div > ul > li > a')
                    ->assertPathIs('/marketing/news-letter/create')
                    ->assertSee('Create News Letter')
                    ->type('#title', $this->faker->title)
                    ->type('#publish_date', date('m/d/Y'))
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > label')
                    ->pause(1000)
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(2)')
                    ->pause(1000)
                    ->assertSeeAnythingIn('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > label')
                    ->click('#submit_btn')
                    ->waitFor('.toast-message',25)
                    ->assertSeeIn('.toast-message', 'Created successfully!');
        });
    }

    public function test_for_test_mail(){
        $this->test_for_alluser_create_newsletter();
        $this->browse(function (Browser $browser) {
            $browser->whenAvailable('#testMailForm', function($modal){
                $modal->pause(6000)
                    ->type('#email', 'spn21@spondonit.com')
                    ->click('#mail_send_btn');
            })
            ->waitFor('.toast-message',25)
            ->assertSeeIn('.toast-message', 'Test Mail has been Send successfully!');
        });
    }

    public function test_for_role_wise_create_newsletter()
    {
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div.container-fluid.p-0 > div > div.col-12 > div > div > ul > li > a')
                    ->assertPathIs('/marketing/news-letter/create')
                    ->assertSee('Create News Letter')
                    ->type('#title', $this->faker->title)
                    ->type('#publish_date', date('m/d/Y'))
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > label')
                    ->pause(1000)
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(3)')
                    ->pause(1000)
                    ->assertSeeAnythingIn('#select_role_div > div > label')
                    ->click('#select_role_div > div > div')
                    ->click('#select_role_div > div > div > ul > li:nth-child(6)')
                    ->pause(10000)
                    ->click('#submit_btn')
                    ->waitFor('.toast-message',25)
                    ->assertSeeIn('.toast-message', 'Created successfully!');
        });
    }

    public function test_for_multi_role_select_user_create_newsletter()
    {
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div.container-fluid.p-0 > div > div.col-12 > div > div > ul > li > a')
                    ->assertPathIs('/marketing/news-letter/create')
                    ->assertSee('Create News Letter')
                    ->type('#title', $this->faker->title)
                    ->type('#publish_date', date('m/d/Y'))
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > label')
                    ->pause(1000)
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(4)')
                    ->pause(1000)
                    ->assertSeeAnythingIn('#multiple_role_div > label')
                    ->click('#multiple_role_div > div:nth-child(3) > label')
                    ->pause(1000)
                    ->click('#multiple_role_div > div:nth-child(3) > label')
                    ->click('#submit_btn')
                    ->waitFor('.toast-message',25)
                    ->assertSeeIn('.toast-message', 'Created successfully!');
        });
    }

    public function test_for_subscription_create_newsletter()
    {
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div.container-fluid.p-0 > div > div.col-12 > div > div > ul > li > a')
                    ->assertPathIs('/marketing/news-letter/create')
                    ->assertSee('Create News Letter')
                    ->type('#title', $this->faker->title)
                    ->type('#publish_date', date('m/d/Y'))
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > label')
                    ->pause(1000)
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(5)')
                    ->pause(1000)
                    ->assertSeeAnythingIn('#subscriber_div > label')
                    ->click('#subscriber_div > div > label')
                    ->pause(1000)
                    ->click('#subscriber_div > div > label')
                    ->click('#submit_btn')
                    ->waitFor('.toast-message',25)
                    ->assertSeeIn('.toast-message', 'Created successfully!');
        });
    }

    public function test_for_validate_create_form(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div.container-fluid.p-0 > div > div.col-12 > div > div > ul > li > a')
                    ->assertPathIs('/marketing/news-letter/create')
                    ->assertSee('Create News Letter')
                    ->click('#submit_btn')
                    ->waitForTextIn('#error_title', 'The title field is required.', 25)
                    ->assertSeeIn('#error_title', 'The title field is required.')
                    ->assertSeeIn('#error_send_to', 'The send to field is required.')
                    ->type('#title', $this->faker->title)
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(3)')
                    ->click('#submit_btn')
                    ->pause(2000)
                    ->waitForTextIn('#error_role', 'The role field is required.', 25)
                    ->assertSeeIn('#error_role', 'The role field is required.')
                    ->assertSeeIn('#error_role_user', 'The role user field is required.')
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(4)')
                    ->pause(1000)
                    ->click('#multiple_role_div > div:nth-child(3) > label')
                    ->pause(1000)
                    ->click('#submit_btn')
                    ->pause(2000)
                    ->waitForTextIn('#error_role_list', 'The role list field is required.', 25)
                    ->assertSeeIn('#error_role_list', 'The role list field is required.')
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                    ->click('#add_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(5)')
                    ->pause(1000)
                    ->click('#subscriber_div > div:nth-child(3) > label')
                    ->pause(1000)
                    ->click('#submit_btn')
                    ->pause(1000)
                    ->waitForTextIn('#error_subscriber_list', 'The subscriber list field is required.', 25)
                    ->assertSeeIn('#error_subscriber_list', 'The subscriber list field is required.');

        });            
    }


    public function test_for_with_all_user_edit()
    {
        $this->test_for_alluser_create_newsletter();
        $this->browse(function (Browser $browser) {
            $mail = NewsLetter::latest()->first();
            $browser->visit('/marketing/news-letter')
                ->pause(10000)
                ->click('#newsLetterTable > tbody > tr:nth-child(1) > td:nth-child(7) > div > button')
                ->click('#newsLetterTable > tbody > tr:nth-child(1) > td:nth-child(7) > div > div > a:nth-child(1)')
                ->assertPathIs('/marketing/news-letter/edit/'.$mail->id)
                ->assertSee('Update News Letter')
                ->type('#title', $this->faker->title)
                ->type('#publish_date', date('m/d/Y'))
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(3) > div > label')
                ->pause(1000)
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(3)')
                ->pause(1000)
                ->click('#select_role_div > div > div')
                ->click('#select_role_div > div > div > ul > li:nth-child(6)')
                ->pause(10000)
                ->click('#submit_btn')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');

        });
    }

    public function test_for_edit_with_role_wise_edit()
    {
        $this->test_for_role_wise_create_newsletter();
        $this->browse(function (Browser $browser) {
            $mail = NewsLetter::latest()->first();
            $browser->visit('/marketing/news-letter')
                ->pause(10000)
                ->click('#newsLetterTable > tbody > tr:nth-child(1) > td:nth-child(7) > div > button')
                ->click('#newsLetterTable > tbody > tr:nth-child(1) > td:nth-child(7) > div > div > a:nth-child(1)')
                ->assertPathIs('/marketing/news-letter/edit/'.$mail->id)
                ->assertSee('Update News Letter')
                ->type('#title', $this->faker->title)
                ->type('#publish_date', date('m/d/Y'))
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(3) > div > label')
                ->pause(1000)
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(2)')
                ->pause(1000)
                ->click('#submit_btn')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');

        });
    }

    public function test_for_validate_edit_form(){
        $this->test_for_alluser_create_newsletter();
        $this->browse(function (Browser $browser) {
            $mail = NewsLetter::latest()->first();
            $browser->visit('/marketing/news-letter')
                ->pause(10000)
                ->click('#newsLetterTable > tbody > tr:nth-child(1) > td:nth-child(7) > div > button')
                ->click('#newsLetterTable > tbody > tr:nth-child(1) > td:nth-child(7) > div > div > a:nth-child(1)')
                ->assertPathIs('/marketing/news-letter/edit/'.$mail->id)
                ->assertSee('Update News Letter')
                ->type('#title', '')
                ->click('#submit_btn')
                ->waitForTextIn('#error_title', 'The title field is required.', 25)
                ->assertSeeIn('#error_title', 'The title field is required.')
                ->type('#title', $this->faker->title)
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(3)')
                ->pause(1000)
                ->click('#submit_btn')
                ->pause(1000)
                ->waitForTextIn('#error_role', 'The role field is required.', 25)
                ->assertSeeIn('#error_role', 'The role field is required.')
                ->assertSeeIn('#error_role_user', 'The role user field is required.')
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(4)')
                ->pause(1000)
                ->click('#submit_btn')
                ->pause(1000)
                ->waitForTextIn('#error_role_list', 'The role list field is required.', 25)
                ->assertSeeIn('#error_role_list', 'The role list field is required.')
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(5) > div > div')
                ->click('#edit_form > div > div:nth-child(1) > div:nth-child(5) > div > div > ul > li:nth-child(5)')
                ->pause(1000)
                ->click('#submit_btn')
                ->pause(1000)
                ->waitForTextIn('#error_subscriber_list', 'The subscriber list field is required.', 25)
                ->assertSeeIn('#error_subscriber_list', 'The subscriber list field is required.');

        });
    }

    public function test_for_test_mail_from_edit(){
        $this->test_for_subscription_create_newsletter();
        $this->browse(function (Browser $browser) {
            $mail = NewsLetter::latest()->first();
            $browser->visit('/marketing/news-letter')
                ->pause(10000)
                ->click('#newsLetterTable > tbody > tr:nth-child(1) > td:nth-child(7) > div > button')
                ->click('#newsLetterTable > tbody > tr:nth-child(1) > td:nth-child(7) > div > div > a:nth-child(1)')
                ->assertPathIs('/marketing/news-letter/edit/'.$mail->id)
                ->assertSee('Update News Letter')
                ->click('#show_test_mail_btn')
                ->whenAvailable('#testMailForm', function($modal){
                    $modal->type('#email', 'spn21@spondonit.com')
                        ->click('#mail_send_btn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Test Mail has been Send successfully!');
        });
    }

    public function test_for_delete_newsletter(){
        $this->test_for_subscription_create_newsletter();
        $this->browse(function (Browser $browser) {
            $browser->visit('/marketing/news-letter')
                ->pause(10000)
                ->click('#newsLetterTable > tbody > tr:nth-child(1) > td:nth-child(7) > div > button')
                ->click('#newsLetterTable > tbody > tr:nth-child(1) > td:nth-child(7) > div > div > a:nth-child(2)')
                ->whenAvailable('#item_delete_form', function($modal){
                    $modal->click('#dataDeleteBtn');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Deleted successfully!');
        });        
    }


}
