<?php

namespace Tests\Browser\Modules\FrontendCMS;

use App\Models\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\FrontendCMS\Entities\Feature;
use Tests\DuskTestCase;

class FeaturePageTest extends DuskTestCase
{
    use  withFaker;

    

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $features = Feature::latest()->pluck('id');
        Feature::destroy($features);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }


    /**
     * A Dusk test example.
     *
     * @return void
     */

    public function test_for_visit_index_page(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(User::find(1))
                ->visit('/frontendcms/features')
                ->assertSee('Feature List');
        });
    }

    public function test_for_create_feature(){

        $this->browse(function (Browser $browser) {
            $browser->loginAs(User::find(1))
            ->visit('/frontendcms/features')
            ->assertSee('Feature List')
            ->type('#title',$this->faker->name)
            ->type('#slug',$this->faker->slug)
            ->type('#icon','ti-star')
            ->click('#item_create_form > div > div > div:nth-child(4) > div > label')
            ->pause(2000)
            ->click('#theme_nav > li:nth-child(2) > label > span')
            ->click('#item_create_form > div > div > div.col-lg-12.text-center > div > button')
            ->waitFor('.toast-message',25)
            ->pause(1000)
            ->assertSeeIn('.toast-message','Created successfully!');
        });
    }

    public function test_for_edit_feature(){
        $this->test_for_create_feature();
        $this->browse(function (Browser $browser) {
            $browser->visit('/frontendcms/features')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div')
                ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a.dropdown-item.edit_feature')
                ->waitForText('Edit Feature', 25)
                ->assertSee('Edit Feature')
                ->type('#title', $this->faker->name)
                ->type('#slug', $this->faker->slug)
                ->click('#theme_nav > li:nth-child(1) > label > span')
                ->click('#item_edit_form > div > div > div.col-lg-12.text-center > div > button')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }

    public function test_for_delete_feature(){
        $this->test_for_create_feature();
        $this->browse(function (Browser $browser) {
            $browser->visit('/frontendcms/features')
            ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div')
            ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(6) > div > div > a.dropdown-item.delete_feature')
            ->whenAvailable('#dataDeleteBtn',function($modal){
                $modal->pause(2000)
                      ->click('#dataDeleteBtn');
            })
            ->waitFor('.toast-message',25)
            ->assertSeeIn('.toast-message', 'Deleted successfully!');      
        });
    }
    
    
}
