<?php

namespace Tests\Browser\Modules\FrontendCMS;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\FrontendCMS\Entities\DynamicPage;
use Tests\DuskTestCase;

class DynamicPageTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $page = DynamicPage::latest()->first();
        $page->delete();

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                    ->visit('/frontendcms/dynamic-page')
                    ->assertSee('Page List');
        });
    }

    public function test_for_create_page(){
        $this->test_for_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-12 > div > div > ul > li > a')
                ->assertPathIs('/frontendcms/dynamic-page/create')
                ->assertSee('Create Dynamic Page')
                ->type('#title', 'test page 99')
                ->type('#slug', 'test-page-99')
                ->type('#formData > div > div:nth-child(4) > div > div > div.note-editing-area > div.note-editable', 'page for test 99')
                ->click('#save_button_parent')
                ->assertPathIs('/frontendcms/dynamic-page')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Created Successfully');
        });
    }

    public function test_for_edit_page(){
        $this->test_for_index_page();
        $this->test_for_create_page();
        $first_page = DynamicPage::latest()->first();
        $this->browse(function (Browser $browser) use($first_page) {
            $browser->click('#dropdownMenu2')
            ->click('#DataTables_Table_0 > tbody > tr.odd > td:nth-child(5) > div > div > a.dropdown-item.edit_brand')
                ->assertPathIs('/frontendcms/dynamic-page/'.$first_page->id.'/edit')
                ->assertSee('Update Dynamic Page')
                ->type('#title', 'test page 99 edit')
                ->type('#slug', 'test-page-99-edit')
                ->type('#formData > div > div.col-xl-12 > div > div > div.note-editing-area > div.note-editable', 'page for test 99 edit')
                ->click('#save_button_parent')
                ->assertPathIs('/frontendcms/dynamic-page')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated Successfully');
        });
        
    }

    public function test_for_delete_page(){
        $this->test_for_index_page();
        $this->test_for_create_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#dropdownMenu2')
                    ->click('#DataTables_Table_0 > tbody > tr > td:nth-child(5) > div > div > a.dropdown-item.delete_page')
                    ->whenAvailable('#dataDeleteBtn', function($modal){
                        $modal->click('#dataDeleteBtn');
                    })
                    ->waitFor('.toast-message',25)
                    ->assertSeeIn('.toast-message', 'Deleted Successfully!');
        });
    }

    public function test_for_status_change(){
        $this->test_for_index_page();
        $this->test_for_create_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#DataTables_Table_0 > tbody > tr > td:nth-child(4) > label > div')
                ->pause(8000)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Updated successfully!');
        });
    }
}
