<?php

namespace Tests\Browser\Modules\Attendance;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Session;
use Laravel\Dusk\Browser;
use Modules\Attendance\Entities\Attendance;
use Modules\Attendance\Entities\Holiday;
use Tests\DuskTestCase;

class HolidaySetupTest extends DuskTestCase
{
    use WithFaker;
    public function setUp(): void
    {
        parent::setUp();

        Session::forget('holidays');

    }

    public function tearDown(): void
    {
        $attendances = Attendance::pluck('id');
        Attendance::destroy($attendances);

        $holidays = Holiday::pluck('id');
        Holiday::destroy($holidays);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }
    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/attendance/holidays')
                ->assertSee('HOLIDAY NAME');
        });
    }

    public function test_for_setup_holiday(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#year', '2020')
                ->pause(9000)
                ->click('#main-content > section > div > div > div > div > form > div:nth-child(2) > div > div > label')
                ->pause(9000)
                ->type('#holiday_row_1_name', $this->faker->name)
                ->pause(1000)
                ->type('#main-content > section > div > div > div > div > form > div.QA_section.QA_section_heading_custom.check_box_table > div > div > table > tbody > tr > td:nth-child(3) > div.single_date > div > div > div > div > div > input', '07/01/2020')
                ->pause(1000)
                ->click('#main-content > section > div > div > div > div > form > div.QA_section.QA_section_heading_custom.check_box_table > div > div > table > tbody > tr > td:nth-child(1) > div > label')
                ->pause(1000)
                ->click('#add_row_btn')
                ->waitFor('#main-content > section > div > div > div > div > form > div.QA_section.QA_section_heading_custom.check_box_table > div > div > table > tbody > tr.add_row > td:nth-child(1) > div > input', 25)
                ->type('#main-content > section > div > div > div > div > form > div.QA_section.QA_section_heading_custom.check_box_table > div > div > table > tbody > tr.add_row > td:nth-child(1) > div > input', $this->faker->name)
                ->click('#main-content > section > div > div > div > div > form > div.QA_section.QA_section_heading_custom.check_box_table > div > div > table > tbody > tr.add_row > td:nth-child(2) > div > div')
                ->click('#main-content > section > div > div > div > div > form > div.QA_section.QA_section_heading_custom.check_box_table > div > div > table > tbody > tr.add_row > td:nth-child(2) > div > div > ul > li:nth-child(2)')
                ->pause(2000)
                ->type('#main-content > section > div > div > div > div > form > div.QA_section.QA_section_heading_custom.check_box_table > div > div > table > tbody > tr.add_row > td:nth-child(3) > div.multiple_date > div:nth-child(1) > div > div > div > div > input', '01/02/2020')
                ->click('#main-content > section > div > div > div > div > form > div.QA_section.QA_section_heading_custom.check_box_table > div > div > table > tbody > tr.add_row > td:nth-child(1) > div > label')
                ->pause(1000)
                ->type('#main-content > section > div > div > div > div > form > div.QA_section.QA_section_heading_custom.check_box_table > div > div > table > tbody > tr.add_row > td:nth-child(3) > div.multiple_date > div:nth-child(2) > div > div > div > div > input', '01/06/2020')
                ->click('#main-content > section > div > div > div > div > form > div.QA_section.QA_section_heading_custom.check_box_table > div > div > table > tbody > tr.add_row > td:nth-child(1) > div > label')
                ->pause(1000)
                ->click('#main-content > section > div > div > div > div > form > div.row.justify-content-center.mt-2 > button')
                ->assertPathIs('/attendance/holidays')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Holiday Saved Successfully.');
        });

    }

    public function test_for_copy_previous_year(){
        $this->test_for_setup_holiday();
        $this->browse(function (Browser $browser) {
            $browser->type('#year', '2021')
                ->pause(9000)
                ->click('#main-content > section > div > div > div > div > form > div:nth-child(2) > div > div > label')
                ->pause(9000)
                ->click('#copy_previous_year_btn')
                ->assertPathIs('/attendance/holidays')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Holiday Saved Successfully.');
        });
    }

    public function test_for_validate_copy_pre_year(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->type('#year', '2016')
                ->pause(9000)
                ->click('#main-content > section > div > div > div > div > form > div:nth-child(2) > div > div > label')
                ->pause(9000)
                ->click('#copy_previous_year_btn')
                ->assertPathIs('/attendance/holidays')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', '2015 Year Holiday not Found.');
        });
    }
    
}
