<?php

namespace Tests\Browser\Modules\Attendance;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Laravel\Dusk\Browser;
use Modules\Attendance\Entities\Attendance;
use Tests\DuskTestCase;

class AttendanceTest extends DuskTestCase
{

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $attendances = Attendance::pluck('id');
        Attendance::destroy($attendances);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/attendance/hr/attendance')
                ->assertSee('Attendance');
        });
    }

    public function test_for_admin_attendance(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-lg-12 > div > div > div.col-lg-6 > div > div')
                ->click('#main-content > section > div > div > div.col-lg-12 > div > div > div.col-lg-6 > div > div > ul > li:nth-child(2)')
                ->pause(10000)
                ->type('#date', '07/17/2021')
                ->click('#main-content > section > div > div > div.col-lg-12 > div > div > div.col-lg-6 > div > label')
                ->pause(10000)
                ->click('#main-content > div.create_form > form > div.common_QA_section.QA_section_heading_custom.th_padding_l0 > div > div > table > tbody > tr > td:nth-child(3) > div > div:nth-child(1) > label')
                ->type('#main-content > div.create_form > form > div.common_QA_section.QA_section_heading_custom.th_padding_l0 > div > div > table > tbody > tr > td:nth-child(4) > div > input', 'test-attendance')
                ->click('#save_button_parent')
                ->assertPathIs('/attendance/hr/attendance')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Attendance has been taken successfully.');
        });
    }

    public function test_for_staff_attendance(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-lg-12 > div > div > div.col-lg-6 > div > div')
                ->click('#main-content > section > div > div > div.col-lg-12 > div > div > div.col-lg-6 > div > div > ul > li:nth-child(3)')
                ->pause(7000)
                ->type('#date', '07/17/2021')
                ->click('#main-content > section > div > div > div.col-lg-12 > div > div > div.col-lg-6 > div > label')
                ->pause(10000)
                ->click('#main-content > div.create_form > form > div.common_QA_section.QA_section_heading_custom.th_padding_l0 > div > div > table > tbody > tr > td:nth-child(3) > div > div:nth-child(1) > label')
                ->type('#main-content > div.create_form > form > div.common_QA_section.QA_section_heading_custom.th_padding_l0 > div > div > table > tbody > tr > td:nth-child(4) > div > input', 'test-attendance')
                ->click('#save_button_parent')
                ->assertPathIs('/attendance/hr/attendance')
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'Attendance has been taken successfully.');
        });
    }

    public function test_for_validate(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-lg-12 > div > div > div.col-lg-6 > div > div')
                ->click('#main-content > section > div > div > div.col-lg-12 > div > div > div.col-lg-6 > div > div > ul > li:nth-child(3)')
                ->pause(7000)
                ->type('#date', '07/18/2021')
                ->click('#main-content > section > div > div > div.col-lg-12 > div > div > div.col-lg-6 > div > label')
                ->pause(10000)
                ->click('#save_button_parent')
                ->assertPathIs('/attendance/hr/attendance')
                ->pause(2000)
                ->assertSeeIn('#main-content > div.alert.alert-danger > ul > li', 'The attendance field is required.');
        });        
    }

    public function test_for_visit_report_page(){
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/attendance/hr/attendance/report-index')
                ->assertSee('Select Criteria');
        });
    }

    public function test_for_check_report(){
        $this->test_for_visit_report_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-lg-12.mb-3 > div > form > div:nth-child(1) > div:nth-child(1) > div > div')
                ->click('#main-content > section > div > div > div.col-lg-12.mb-3 > div > form > div:nth-child(1) > div:nth-child(1) > div > div > ul > li:nth-child(2)')
                ->click('#main-content > section > div > div > div.col-lg-12.mb-3 > div > form > div:nth-child(1) > div:nth-child(2) > div > div')
                ->pause(1000)
                ->click('#main-content > section > div > div > div.col-lg-12.mb-3 > div > form > div:nth-child(1) > div:nth-child(2) > div > div > ul > li:nth-child(7)')
                ->type('#year', '2021')
                ->click('#main-content > section > div > div > div.col-lg-12.mb-3 > div > form > div:nth-child(1) > div:nth-child(2) > div > label')
                ->pause(2000)
                ->click('#save_button_parent')
                ->assertPathIs('/attendance/attendance/report-index/search')
                ->assertSeeIn('#DataTables_Table_0 > tbody > tr > td:nth-child(2)', 'Admin')
                ->pause(1000)
                ->click('#main-content > section > div > div > div.col-lg-12.mb-3 > div > form > div:nth-child(1) > div:nth-child(1) > div > div')
                ->click('#main-content > section > div > div > div.col-lg-12.mb-3 > div > form > div:nth-child(1) > div:nth-child(1) > div > div > ul > li:nth-child(3)')
                ->click('#save_button_parent')
                ->assertPathIs('/attendance/attendance/report-index/search')
                ->assertSeeIn('#DataTables_Table_0 > tbody > tr > td:nth-child(3)', 'EMP-00003')
                ->click('#main-content > section > div > div > div:nth-child(3) > div > div > ul > li > a')
                ->assertPathIs('/attendance/attendance/report-index/search');
        });
    }


}
