<?php

namespace Tests\Browser\Modules\Account;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\File;
use Laravel\Dusk\Browser;
use Modules\Account\Entities\BankAccount;
use Modules\Account\Entities\ChartOfAccount;
use Modules\Account\Entities\Transaction;
use Tests\DuskTestCase;

class StatementTest extends DuskTestCase
{


    use WithFaker;

    protected $chart_of_accounts = [];

    public function setUp(): void
    {
        parent::setUp();

        

        $this->chart_of_accounts[] = ChartOfAccount::create([
            'code' => 'Income-6',
            'type' => 'Income',
            'default_for' => 'Product Wise Tax Account',
            'name' => 'Product Tax',
            'opening_balance' => 0,
            'description' => null,
            'level' => 0,
            'status' => 1,
            'created_by' => 1
        ]);

        $this->chart_of_accounts[] = ChartOfAccount::create([
            'code' => 'Income-1',
            'type' => 'Income',
            'default_for' => 'Income',
            'name' => 'Amaz Cart Income',
            'opening_balance' => 0,
            'description' => null,
            'level' => 0,
            'status' => 1,
            'created_by' => 1
        ]);

        BankAccount::create([
            'bank_name' => 'Dutch Bangla',
            'branch_name' => 'Savar',
            'account_name' => 'Amazcart',
            'account_number' => '216532356',
            'opening_balance' => 0,
            'status' => 1,
            'created_by' => 1
        ]);

        Transaction::create([
            'title' => 'test-transaction-1',
            'chart_of_account_id' => 1,
            'bank_account_id' => 1,
            'type' => 'in',
            'payment_method' => 'Cash',
            'come_from' => 'income',
            'description' => 'test',
            'amount' => 20,
            'transaction_date' => date("Y-m-d", strtotime("yesterday")),
            'created_by' => 1
        ]);

        Transaction::create([
            'title' => 'test-transaction-2',
            'chart_of_account_id' => 1,
            'bank_account_id' => 1,
            'type' => 'in',
            'payment_method' => 'Cash',
            'come_from' => 'income',
            'description' => 'test',
            'amount' => 20,
            'transaction_date' => date("Y-m-d", strtotime("yesterday")),
            'created_by' => 1
        ]);
            

    }

    public function tearDown(): void
    {

        $charts = ChartOfAccount::pluck('id');
        ChartOfAccount::destroy($charts);

        $accounts = BankAccount::pluck('id');
        BankAccount::destroy($accounts);

        $transactions = Transaction::all();
        foreach($transactions as $trans){
            if(File::exists(public_path($trans->file))){
                File::delete(public_path($trans->file));
            }
            $trans->delete();
        }

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/account/statement')
                ->assertSee('Statement');
        });
    }


    public function test_for_filter(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#date_range')
                ->pause(1000)
                ->click('div.daterangepicker.ltr.show-ranges.opensright > div.ranges > ul > li:nth-child(3)')
                ->pause(5000)
                ->waitForTextIn('#DataTables_Table_0 > tbody > tr:nth-child(1) > td:nth-child(1)', date("jS M, Y", strtotime("yesterday")), 25);
        });
    }
}
