<?php

namespace Tests\Browser\Modules\Account;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\WithFaker;
use Laravel\Dusk\Browser;
use Modules\Account\Entities\ChartOfAccount;
use Tests\DuskTestCase;

class ChartOfAccountTest extends DuskTestCase
{
    use WithFaker;

    public function setUp(): void
    {
        parent::setUp();


    }

    public function tearDown(): void
    {
        $charts =  ChartOfAccount::pluck('id');
        ChartOfAccount::destroy($charts);

        parent::tearDown(); // TODO: Change the autogenerated stub
    }

    /**
     * A Dusk test example.
     *
     * @return void
     */
    public function test_for_visit_index_page()
    {
        $this->browse(function (Browser $browser) {
            $browser->loginAs(1)
                ->visit('/account/chart-of-accounts')
                ->assertSee('Chart Of Accounts');
        });
    }

    public function test_for_create(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-12 > div > div > ul > li > a')
                ->whenAvailable('#chart_of_account_form', function($modal){
                    $modal->type('#name', 'Product Tax')
                        ->pause(2000)
                        ->type('#code', 'income-3')
                        ->click('#account_type_col > div > div')
                        ->pause(1000)
                        ->click('#account_type_col > div > div > ul > li.option.focus')
                        ->type('#description', $this->faker->paragraph)
                        ->click('div > div > div.col-xl-6.mb-25 > div > div')
                        ->click('div > div > div.col-xl-6.mb-25 > div > div > ul > li:nth-child(2)')
                        ->type('#opening_balance', '0')
                        ->click('div > div > div.col-lg-12.text-center > div > button.primary-btn.fix-gr-bg.submit');
                }, 25)
                
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'The requested chart of account created successful');
        });
    }

    public function test_for_validate_create(){
        $this->test_for_visit_index_page();
        $this->browse(function (Browser $browser) {
            $browser->click('#main-content > section > div > div > div.col-12 > div > div > ul > li > a')
                ->whenAvailable('#chart_of_account_form', function($modal){
                    $modal->type('#name', '')
                        ->click('div > div > div.col-lg-12.text-center > div > button.primary-btn.fix-gr-bg.submit');
                }, 25)
                ->pause(2000)
                ->assertSee('This value is required.');
        });
    }


    public function test_for_edit(){
        $this->test_for_create();
        $this->browse(function (Browser $browser) {
            $browser->pause(5000)
                ->click('#chart-of-account-table > tbody > tr > td:nth-child(8) > div > button')
                ->click('#chart-of-account-table > tbody > tr > td:nth-child(8) > div > div > a.dropdown-item.btn-modal')
                ->whenAvailable('#chart_of_account_edit_form', function($modal){
                    $modal->pause(2000)
                        ->type('#name', 'Product Tax')
                        ->type('#code', 'income-3')
                        ->type('#description', $this->faker->paragraph)
                        ->click('div > div > div.col-xl-6.mb-25 > div > div')
                        ->click('div > div > div.col-xl-6.mb-25 > div > div > ul > li:nth-child(2)')
                        ->type('#opening_balance', '20')
                        ->click('div > div > div:nth-child(8) > div > label > span')
                        ->click('div > div > div.col-lg-12.text-center > div > button.primary-btn.fix-gr-bg.submit');
                }, 25)
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'The requested chart of account updated successful');
        });
    }

    public function test_for_validate_edit(){
        $this->test_for_create();
        $this->browse(function (Browser $browser) {
            $browser->pause(10000)
                ->click('#chart-of-account-table > tbody > tr > td:nth-child(8) > div > button')
                ->click('#chart-of-account-table > tbody > tr > td:nth-child(8) > div > div > a.dropdown-item.btn-modal')
                ->whenAvailable('#chart_of_account_edit_form', function($modal){
                    $modal->pause(2000)
                        ->type('#name', '')
                        ->type('#code', '')
                        ->type('#opening_balance', '')
                        ->click('div > div > div.col-lg-12.text-center > div > button.primary-btn.fix-gr-bg.submit');
                }, 25)
                ->pause(2000)
                ->assertSee('This value is required.');
        });
    }

    public function test_for_delete(){
        $this->test_for_create();
        $this->browse(function (Browser $browser) {
            $browser->pause(5000)
                ->click('#chart-of-account-table > tbody > tr > td:nth-child(8) > div > button')
                ->click('#chart-of-account-table > tbody > tr > td:nth-child(8) > div > div > a.dropdown-item.delete_item')
                ->whenAvailable('#delete_modal_form', function($modal){
                    $modal->click('div > div > div.col-lg-12.text-center > div > button.primary-btn.fix-gr-bg.submit');
                })
                ->waitFor('.toast-message',25)
                ->assertSeeIn('.toast-message', 'The requested chart of account deleted successful');
            });        
    }
}
