/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@popperjs/core/lib/createPopper.js":
/*!*********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/createPopper.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPopper: () => (/* binding */ createPopper),
/* harmony export */   detectOverflow: () => (/* reexport safe */ _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   popperGenerator: () => (/* binding */ popperGenerator)
/* harmony export */ });
/* harmony import */ var _dom_utils_getCompositeRect_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./dom-utils/getCompositeRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./dom-utils/getLayoutRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dom-utils/listScrollParents.js */ "./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dom-utils/getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _utils_orderModifiers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/orderModifiers.js */ "./node_modules/@popperjs/core/lib/utils/orderModifiers.js");
/* harmony import */ var _utils_debounce_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./utils/debounce.js */ "./node_modules/@popperjs/core/lib/utils/debounce.js");
/* harmony import */ var _utils_validateModifiers_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/validateModifiers.js */ "./node_modules/@popperjs/core/lib/utils/validateModifiers.js");
/* harmony import */ var _utils_uniqueBy_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/uniqueBy.js */ "./node_modules/@popperjs/core/lib/utils/uniqueBy.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_mergeByName_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/mergeByName.js */ "./node_modules/@popperjs/core/lib/utils/mergeByName.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./enums.js */ "./node_modules/@popperjs/core/lib/enums.js");














var INVALID_ELEMENT_ERROR = 'Popper: Invalid reference or popper argument provided. They must be either a DOM element or virtual element.';
var INFINITE_LOOP_ERROR = 'Popper: An infinite loop in the modifiers cycle has been detected! The cycle has been interrupted to prevent a browser crash.';
var DEFAULT_OPTIONS = {
  placement: 'bottom',
  modifiers: [],
  strategy: 'absolute'
};

function areValidElements() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return !args.some(function (element) {
    return !(element && typeof element.getBoundingClientRect === 'function');
  });
}

function popperGenerator(generatorOptions) {
  if (generatorOptions === void 0) {
    generatorOptions = {};
  }

  var _generatorOptions = generatorOptions,
      _generatorOptions$def = _generatorOptions.defaultModifiers,
      defaultModifiers = _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
      _generatorOptions$def2 = _generatorOptions.defaultOptions,
      defaultOptions = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
  return function createPopper(reference, popper, options) {
    if (options === void 0) {
      options = defaultOptions;
    }

    var state = {
      placement: 'bottom',
      orderedModifiers: [],
      options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
      modifiersData: {},
      elements: {
        reference: reference,
        popper: popper
      },
      attributes: {},
      styles: {}
    };
    var effectCleanupFns = [];
    var isDestroyed = false;
    var instance = {
      state: state,
      setOptions: function setOptions(setOptionsAction) {
        var options = typeof setOptionsAction === 'function' ? setOptionsAction(state.options) : setOptionsAction;
        cleanupModifierEffects();
        state.options = Object.assign({}, defaultOptions, state.options, options);
        state.scrollParents = {
          reference: (0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isElement)(reference) ? (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__["default"])(reference) : reference.contextElement ? (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__["default"])(reference.contextElement) : [],
          popper: (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_1__["default"])(popper)
        }; // Orders the modifiers based on their dependencies and `phase`
        // properties

        var orderedModifiers = (0,_utils_orderModifiers_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_utils_mergeByName_js__WEBPACK_IMPORTED_MODULE_3__["default"])([].concat(defaultModifiers, state.options.modifiers))); // Strip out disabled modifiers

        state.orderedModifiers = orderedModifiers.filter(function (m) {
          return m.enabled;
        }); // Validate the provided modifiers so that the consumer will get warned
        // if one of the modifiers is invalid for any reason

        if (true) {
          var modifiers = (0,_utils_uniqueBy_js__WEBPACK_IMPORTED_MODULE_4__["default"])([].concat(orderedModifiers, state.options.modifiers), function (_ref) {
            var name = _ref.name;
            return name;
          });
          (0,_utils_validateModifiers_js__WEBPACK_IMPORTED_MODULE_5__["default"])(modifiers);

          if ((0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state.options.placement) === _enums_js__WEBPACK_IMPORTED_MODULE_7__.auto) {
            var flipModifier = state.orderedModifiers.find(function (_ref2) {
              var name = _ref2.name;
              return name === 'flip';
            });

            if (!flipModifier) {
              console.error(['Popper: "auto" placements require the "flip" modifier be', 'present and enabled to work.'].join(' '));
            }
          }

          var _getComputedStyle = (0,_dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_8__["default"])(popper),
              marginTop = _getComputedStyle.marginTop,
              marginRight = _getComputedStyle.marginRight,
              marginBottom = _getComputedStyle.marginBottom,
              marginLeft = _getComputedStyle.marginLeft; // We no longer take into account `margins` on the popper, and it can
          // cause bugs with positioning, so we'll warn the consumer


          if ([marginTop, marginRight, marginBottom, marginLeft].some(function (margin) {
            return parseFloat(margin);
          })) {
            console.warn(['Popper: CSS "margin" styles cannot be used to apply padding', 'between the popper and its reference element or boundary.', 'To replicate margin, use the `offset` modifier, as well as', 'the `padding` option in the `preventOverflow` and `flip`', 'modifiers.'].join(' '));
          }
        }

        runModifierEffects();
        return instance.update();
      },
      // Sync update – it will always be executed, even if not necessary. This
      // is useful for low frequency updates where sync behavior simplifies the
      // logic.
      // For high frequency updates (e.g. `resize` and `scroll` events), always
      // prefer the async Popper#update method
      forceUpdate: function forceUpdate() {
        if (isDestroyed) {
          return;
        }

        var _state$elements = state.elements,
            reference = _state$elements.reference,
            popper = _state$elements.popper; // Don't proceed if `reference` or `popper` are not valid elements
        // anymore

        if (!areValidElements(reference, popper)) {
          if (true) {
            console.error(INVALID_ELEMENT_ERROR);
          }

          return;
        } // Store the reference and popper rects to be read by modifiers


        state.rects = {
          reference: (0,_dom_utils_getCompositeRect_js__WEBPACK_IMPORTED_MODULE_9__["default"])(reference, (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_10__["default"])(popper), state.options.strategy === 'fixed'),
          popper: (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_11__["default"])(popper)
        }; // Modifiers have the ability to reset the current update cycle. The
        // most common use case for this is the `flip` modifier changing the
        // placement, which then needs to re-run all the modifiers, because the
        // logic was previously ran for the previous placement and is therefore
        // stale/incorrect

        state.reset = false;
        state.placement = state.options.placement; // On each update cycle, the `modifiersData` property for each modifier
        // is filled with the initial data specified by the modifier. This means
        // it doesn't persist and is fresh on each update.
        // To ensure persistent data, use `${name}#persistent`

        state.orderedModifiers.forEach(function (modifier) {
          return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
        });
        var __debug_loops__ = 0;

        for (var index = 0; index < state.orderedModifiers.length; index++) {
          if (true) {
            __debug_loops__ += 1;

            if (__debug_loops__ > 100) {
              console.error(INFINITE_LOOP_ERROR);
              break;
            }
          }

          if (state.reset === true) {
            state.reset = false;
            index = -1;
            continue;
          }

          var _state$orderedModifie = state.orderedModifiers[index],
              fn = _state$orderedModifie.fn,
              _state$orderedModifie2 = _state$orderedModifie.options,
              _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2,
              name = _state$orderedModifie.name;

          if (typeof fn === 'function') {
            state = fn({
              state: state,
              options: _options,
              name: name,
              instance: instance
            }) || state;
          }
        }
      },
      // Async and optimistically optimized update – it will not be executed if
      // not necessary (debounced to run at most once-per-tick)
      update: (0,_utils_debounce_js__WEBPACK_IMPORTED_MODULE_12__["default"])(function () {
        return new Promise(function (resolve) {
          instance.forceUpdate();
          resolve(state);
        });
      }),
      destroy: function destroy() {
        cleanupModifierEffects();
        isDestroyed = true;
      }
    };

    if (!areValidElements(reference, popper)) {
      if (true) {
        console.error(INVALID_ELEMENT_ERROR);
      }

      return instance;
    }

    instance.setOptions(options).then(function (state) {
      if (!isDestroyed && options.onFirstUpdate) {
        options.onFirstUpdate(state);
      }
    }); // Modifiers have the ability to execute arbitrary code before the first
    // update cycle runs. They will be executed in the same order as the update
    // cycle. This is useful when a modifier adds some persistent data that
    // other modifiers need to use, but the modifier is run after the dependent
    // one.

    function runModifierEffects() {
      state.orderedModifiers.forEach(function (_ref3) {
        var name = _ref3.name,
            _ref3$options = _ref3.options,
            options = _ref3$options === void 0 ? {} : _ref3$options,
            effect = _ref3.effect;

        if (typeof effect === 'function') {
          var cleanupFn = effect({
            state: state,
            name: name,
            instance: instance,
            options: options
          });

          var noopFn = function noopFn() {};

          effectCleanupFns.push(cleanupFn || noopFn);
        }
      });
    }

    function cleanupModifierEffects() {
      effectCleanupFns.forEach(function (fn) {
        return fn();
      });
      effectCleanupFns = [];
    }

    return instance;
  };
}
var createPopper = /*#__PURE__*/popperGenerator(); // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/contains.js":
/*!***************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/contains.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ contains)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

function contains(parent, child) {
  var rootNode = child.getRootNode && child.getRootNode(); // First, attempt with faster native method

  if (parent.contains(child)) {
    return true;
  } // then fallback to custom implementation with Shadow DOM support
  else if (rootNode && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isShadowRoot)(rootNode)) {
      var next = child;

      do {
        if (next && parent.isSameNode(next)) {
          return true;
        } // $FlowFixMe[prop-missing]: need a better way to handle this...


        next = next.parentNode || next.host;
      } while (next);
    } // Give up, the result is false


  return false;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getBoundingClientRect)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isLayoutViewport.js */ "./node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js");




function getBoundingClientRect(element, includeScale, isFixedStrategy) {
  if (includeScale === void 0) {
    includeScale = false;
  }

  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }

  var clientRect = element.getBoundingClientRect();
  var scaleX = 1;
  var scaleY = 1;

  if (includeScale && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {
    scaleX = element.offsetWidth > 0 ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_1__.round)(clientRect.width) / element.offsetWidth || 1 : 1;
    scaleY = element.offsetHeight > 0 ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_1__.round)(clientRect.height) / element.offsetHeight || 1 : 1;
  }

  var _ref = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isElement)(element) ? (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element) : window,
      visualViewport = _ref.visualViewport;

  var addVisualOffsets = !(0,_isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_3__["default"])() && isFixedStrategy;
  var x = (clientRect.left + (addVisualOffsets && visualViewport ? visualViewport.offsetLeft : 0)) / scaleX;
  var y = (clientRect.top + (addVisualOffsets && visualViewport ? visualViewport.offsetTop : 0)) / scaleY;
  var width = clientRect.width / scaleX;
  var height = clientRect.height / scaleY;
  return {
    width: width,
    height: height,
    top: y,
    right: x + width,
    bottom: y + height,
    left: x,
    x: x,
    y: y
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getClippingRect)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _getViewportRect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getViewportRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js");
/* harmony import */ var _getDocumentRect_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getDocumentRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js");
/* harmony import */ var _listScrollParents_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./listScrollParents.js */ "./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js");
/* harmony import */ var _getOffsetParent_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _contains_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./contains.js */ "./node_modules/@popperjs/core/lib/dom-utils/contains.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/rectToClientRect.js */ "./node_modules/@popperjs/core/lib/utils/rectToClientRect.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");















function getInnerBoundingClientRect(element, strategy) {
  var rect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element, false, strategy === 'fixed');
  rect.top = rect.top + element.clientTop;
  rect.left = rect.left + element.clientLeft;
  rect.bottom = rect.top + element.clientHeight;
  rect.right = rect.left + element.clientWidth;
  rect.width = element.clientWidth;
  rect.height = element.clientHeight;
  rect.x = rect.left;
  rect.y = rect.top;
  return rect;
}

function getClientRectFromMixedType(element, clippingParent, strategy) {
  return clippingParent === _enums_js__WEBPACK_IMPORTED_MODULE_1__.viewport ? (0,_utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_getViewportRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element, strategy)) : (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(clippingParent) ? getInnerBoundingClientRect(clippingParent, strategy) : (0,_utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_getDocumentRect_js__WEBPACK_IMPORTED_MODULE_5__["default"])((0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_6__["default"])(element)));
} // A "clipping parent" is an overflowable container with the characteristic of
// clipping (or hiding) overflowing elements with a position different from
// `initial`


function getClippingParents(element) {
  var clippingParents = (0,_listScrollParents_js__WEBPACK_IMPORTED_MODULE_7__["default"])((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_8__["default"])(element));
  var canEscapeClipping = ['absolute', 'fixed'].indexOf((0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_9__["default"])(element).position) >= 0;
  var clipperElement = canEscapeClipping && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isHTMLElement)(element) ? (0,_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_10__["default"])(element) : element;

  if (!(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(clipperElement)) {
    return [];
  } // $FlowFixMe[incompatible-return]: https://github.com/facebook/flow/issues/1414


  return clippingParents.filter(function (clippingParent) {
    return (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(clippingParent) && (0,_contains_js__WEBPACK_IMPORTED_MODULE_11__["default"])(clippingParent, clipperElement) && (0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_12__["default"])(clippingParent) !== 'body';
  });
} // Gets the maximum area that the element is visible in due to any number of
// clipping parents


function getClippingRect(element, boundary, rootBoundary, strategy) {
  var mainClippingParents = boundary === 'clippingParents' ? getClippingParents(element) : [].concat(boundary);
  var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
  var firstClippingParent = clippingParents[0];
  var clippingRect = clippingParents.reduce(function (accRect, clippingParent) {
    var rect = getClientRectFromMixedType(element, clippingParent, strategy);
    accRect.top = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.max)(rect.top, accRect.top);
    accRect.right = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.min)(rect.right, accRect.right);
    accRect.bottom = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.min)(rect.bottom, accRect.bottom);
    accRect.left = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.max)(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromMixedType(element, firstClippingParent, strategy));
  clippingRect.width = clippingRect.right - clippingRect.left;
  clippingRect.height = clippingRect.bottom - clippingRect.top;
  clippingRect.x = clippingRect.left;
  clippingRect.y = clippingRect.top;
  return clippingRect;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getCompositeRect)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getNodeScroll_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./getNodeScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");









function isElementScaled(element) {
  var rect = element.getBoundingClientRect();
  var scaleX = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(rect.width) / element.offsetWidth || 1;
  var scaleY = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(rect.height) / element.offsetHeight || 1;
  return scaleX !== 1 || scaleY !== 1;
} // Returns the composite rect of an element relative to its offsetParent.
// Composite means it takes into account transforms as well as layout.


function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
  if (isFixed === void 0) {
    isFixed = false;
  }

  var isOffsetParentAnElement = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(offsetParent);
  var offsetParentIsScaled = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(offsetParent) && isElementScaled(offsetParent);
  var documentElement = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(offsetParent);
  var rect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(elementOrVirtualElement, offsetParentIsScaled, isFixed);
  var scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  var offsets = {
    x: 0,
    y: 0
  };

  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_4__["default"])(offsetParent) !== 'body' || // https://github.com/popperjs/popper-core/issues/1078
    (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_5__["default"])(documentElement)) {
      scroll = (0,_getNodeScroll_js__WEBPACK_IMPORTED_MODULE_6__["default"])(offsetParent);
    }

    if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(offsetParent)) {
      offsets = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])(offsetParent, true);
      offsets.x += offsetParent.clientLeft;
      offsets.y += offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_7__["default"])(documentElement);
    }
  }

  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getComputedStyle)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");

function getComputedStyle(element) {
  return (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element).getComputedStyle(element);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDocumentElement)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

function getDocumentElement(element) {
  // $FlowFixMe[incompatible-return]: assume body is always available
  return (((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isElement)(element) ? element.ownerDocument : // $FlowFixMe[prop-missing]
  element.document) || window.document).documentElement;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDocumentRect)
/* harmony export */ });
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getWindowScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");




 // Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable

function getDocumentRect(element) {
  var _element$ownerDocumen;

  var html = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var winScroll = (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);
  var body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
  var width = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_2__.max)(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
  var height = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_2__.max)(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
  var x = -winScroll.scrollLeft + (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element);
  var y = -winScroll.scrollTop;

  if ((0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_4__["default"])(body || html).direction === 'rtl') {
    x += (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_2__.max)(html.clientWidth, body ? body.clientWidth : 0) - width;
  }

  return {
    width: width,
    height: height,
    x: x,
    y: y
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getHTMLElementScroll)
/* harmony export */ });
function getHTMLElementScroll(element) {
  return {
    scrollLeft: element.scrollLeft,
    scrollTop: element.scrollTop
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getLayoutRect)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
 // Returns the layout rect of an element relative to its offsetParent. Layout
// means it doesn't take into account transforms.

function getLayoutRect(element) {
  var clientRect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element); // Use the clientRect sizes if it's not been transformed.
  // Fixes https://github.com/popperjs/popper-core/issues/1223

  var width = element.offsetWidth;
  var height = element.offsetHeight;

  if (Math.abs(clientRect.width - width) <= 1) {
    width = clientRect.width;
  }

  if (Math.abs(clientRect.height - height) <= 1) {
    height = clientRect.height;
  }

  return {
    x: element.offsetLeft,
    y: element.offsetTop,
    width: width,
    height: height
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js":
/*!******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getNodeName)
/* harmony export */ });
function getNodeName(element) {
  return element ? (element.nodeName || '').toLowerCase() : null;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getNodeScroll)
/* harmony export */ });
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindowScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getHTMLElementScroll_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getHTMLElementScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js");




function getNodeScroll(node) {
  if (node === (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node) || !(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(node)) {
    return (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__["default"])(node);
  } else {
    return (0,_getHTMLElementScroll_js__WEBPACK_IMPORTED_MODULE_3__["default"])(node);
  }
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOffsetParent)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _isTableElement_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./isTableElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/isTableElement.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _utils_userAgent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/userAgent.js */ "./node_modules/@popperjs/core/lib/utils/userAgent.js");








function getTrueOffsetParent(element) {
  if (!(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || // https://github.com/popperjs/popper-core/issues/837
  (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element).position === 'fixed') {
    return null;
  }

  return element.offsetParent;
} // `.offsetParent` reports `null` for fixed elements, while absolute elements
// return the containing block


function getContainingBlock(element) {
  var isFirefox = /firefox/i.test((0,_utils_userAgent_js__WEBPACK_IMPORTED_MODULE_2__["default"])());
  var isIE = /Trident/i.test((0,_utils_userAgent_js__WEBPACK_IMPORTED_MODULE_2__["default"])());

  if (isIE && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {
    // In IE 9, 10 and 11 fixed elements containing block is always established by the viewport
    var elementCss = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);

    if (elementCss.position === 'fixed') {
      return null;
    }
  }

  var currentNode = (0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element);

  if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isShadowRoot)(currentNode)) {
    currentNode = currentNode.host;
  }

  while ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(currentNode) && ['html', 'body'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_4__["default"])(currentNode)) < 0) {
    var css = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(currentNode); // This is non-exhaustive but covers the most common CSS properties that
    // create a containing block.
    // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block

    if (css.transform !== 'none' || css.perspective !== 'none' || css.contain === 'paint' || ['transform', 'perspective'].indexOf(css.willChange) !== -1 || isFirefox && css.willChange === 'filter' || isFirefox && css.filter && css.filter !== 'none') {
      return currentNode;
    } else {
      currentNode = currentNode.parentNode;
    }
  }

  return null;
} // Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.


function getOffsetParent(element) {
  var window = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_5__["default"])(element);
  var offsetParent = getTrueOffsetParent(element);

  while (offsetParent && (0,_isTableElement_js__WEBPACK_IMPORTED_MODULE_6__["default"])(offsetParent) && (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(offsetParent).position === 'static') {
    offsetParent = getTrueOffsetParent(offsetParent);
  }

  if (offsetParent && ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_4__["default"])(offsetParent) === 'html' || (0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_4__["default"])(offsetParent) === 'body' && (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(offsetParent).position === 'static')) {
    return window;
  }

  return offsetParent || getContainingBlock(element) || window;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getParentNode)
/* harmony export */ });
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");



function getParentNode(element) {
  if ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element) === 'html') {
    return element;
  }

  return (// this is a quicker (but less type safe) way to save quite some bytes from the bundle
    // $FlowFixMe[incompatible-return]
    // $FlowFixMe[prop-missing]
    element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
    element.parentNode || ( // DOM Element detected
    (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isShadowRoot)(element) ? element.host : null) || // ShadowRoot detected
    // $FlowFixMe[incompatible-call]: HTMLElement is a Node
    (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element) // fallback

  );
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getScrollParent)
/* harmony export */ });
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");




function getScrollParent(node) {
  if (['html', 'body', '#document'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node)) >= 0) {
    // $FlowFixMe[incompatible-return]: assume body is always available
    return node.ownerDocument.body;
  }

  if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(node) && (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__["default"])(node)) {
    return node;
  }

  return getScrollParent((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_3__["default"])(node));
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getViewportRect)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isLayoutViewport.js */ "./node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js");




function getViewportRect(element, strategy) {
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var html = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);
  var visualViewport = win.visualViewport;
  var width = html.clientWidth;
  var height = html.clientHeight;
  var x = 0;
  var y = 0;

  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    var layoutViewport = (0,_isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_2__["default"])();

    if (layoutViewport || !layoutViewport && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }

  return {
    width: width,
    height: height,
    x: x + (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element),
    y: y
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js":
/*!****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getWindow.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindow)
/* harmony export */ });
function getWindow(node) {
  if (node == null) {
    return window;
  }

  if (node.toString() !== '[object Window]') {
    var ownerDocument = node.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView || window : window;
  }

  return node;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindowScroll)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");

function getWindowScroll(node) {
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node);
  var scrollLeft = win.pageXOffset;
  var scrollTop = win.pageYOffset;
  return {
    scrollLeft: scrollLeft,
    scrollTop: scrollTop
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindowScrollBarX)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindowScroll.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");



function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  // Popper 1 is broken in this case and never had a bug report so let's assume
  // it's not an issue. I don't think anyone ever specifies width on <html>
  // anyway.
  // Browsers where the left scrollbar doesn't cause an issue report `0` for
  // this (e.g. Edge 2019, IE11, Safari)
  return (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element)).left + (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element).scrollLeft;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isHTMLElement: () => (/* binding */ isHTMLElement),
/* harmony export */   isShadowRoot: () => (/* binding */ isShadowRoot)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");


function isElement(node) {
  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).Element;
  return node instanceof OwnElement || node instanceof Element;
}

function isHTMLElement(node) {
  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).HTMLElement;
  return node instanceof OwnElement || node instanceof HTMLElement;
}

function isShadowRoot(node) {
  // IE 11 has no ShadowRoot
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }

  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isLayoutViewport)
/* harmony export */ });
/* harmony import */ var _utils_userAgent_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/userAgent.js */ "./node_modules/@popperjs/core/lib/utils/userAgent.js");

function isLayoutViewport() {
  return !/^((?!chrome|android).)*safari/i.test((0,_utils_userAgent_js__WEBPACK_IMPORTED_MODULE_0__["default"])());
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isScrollParent)
/* harmony export */ });
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");

function isScrollParent(element) {
  // Firefox wants us to check `-x` and `-y` variations as well
  var _getComputedStyle = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element),
      overflow = _getComputedStyle.overflow,
      overflowX = _getComputedStyle.overflowX,
      overflowY = _getComputedStyle.overflowY;

  return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/isTableElement.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/isTableElement.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isTableElement)
/* harmony export */ });
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");

function isTableElement(element) {
  return ['table', 'td', 'th'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element)) >= 0;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js":
/*!************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ listScrollParents)
/* harmony export */ });
/* harmony import */ var _getScrollParent_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getParentNode.js */ "./node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isScrollParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");




/*
given a DOM element, return the list of all scroll parents, up the list of ancesors
until we get to the top window object. This list is what we attach scroll listeners
to, because if any of these parent elements scroll, we'll need to re-calculate the
reference element's position.
*/

function listScrollParents(element, list) {
  var _element$ownerDocumen;

  if (list === void 0) {
    list = [];
  }

  var scrollParent = (0,_getScrollParent_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(scrollParent);
  var target = isBody ? [win].concat(win.visualViewport || [], (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_2__["default"])(scrollParent) ? scrollParent : []) : scrollParent;
  var updatedList = list.concat(target);
  return isBody ? updatedList : // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
  updatedList.concat(listScrollParents((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_3__["default"])(target)));
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/enums.js":
/*!**************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/enums.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   afterMain: () => (/* binding */ afterMain),
/* harmony export */   afterRead: () => (/* binding */ afterRead),
/* harmony export */   afterWrite: () => (/* binding */ afterWrite),
/* harmony export */   auto: () => (/* binding */ auto),
/* harmony export */   basePlacements: () => (/* binding */ basePlacements),
/* harmony export */   beforeMain: () => (/* binding */ beforeMain),
/* harmony export */   beforeRead: () => (/* binding */ beforeRead),
/* harmony export */   beforeWrite: () => (/* binding */ beforeWrite),
/* harmony export */   bottom: () => (/* binding */ bottom),
/* harmony export */   clippingParents: () => (/* binding */ clippingParents),
/* harmony export */   end: () => (/* binding */ end),
/* harmony export */   left: () => (/* binding */ left),
/* harmony export */   main: () => (/* binding */ main),
/* harmony export */   modifierPhases: () => (/* binding */ modifierPhases),
/* harmony export */   placements: () => (/* binding */ placements),
/* harmony export */   popper: () => (/* binding */ popper),
/* harmony export */   read: () => (/* binding */ read),
/* harmony export */   reference: () => (/* binding */ reference),
/* harmony export */   right: () => (/* binding */ right),
/* harmony export */   start: () => (/* binding */ start),
/* harmony export */   top: () => (/* binding */ top),
/* harmony export */   variationPlacements: () => (/* binding */ variationPlacements),
/* harmony export */   viewport: () => (/* binding */ viewport),
/* harmony export */   write: () => (/* binding */ write)
/* harmony export */ });
var top = 'top';
var bottom = 'bottom';
var right = 'right';
var left = 'left';
var auto = 'auto';
var basePlacements = [top, bottom, right, left];
var start = 'start';
var end = 'end';
var clippingParents = 'clippingParents';
var viewport = 'viewport';
var popper = 'popper';
var reference = 'reference';
var variationPlacements = /*#__PURE__*/basePlacements.reduce(function (acc, placement) {
  return acc.concat([placement + "-" + start, placement + "-" + end]);
}, []);
var placements = /*#__PURE__*/[].concat(basePlacements, [auto]).reduce(function (acc, placement) {
  return acc.concat([placement, placement + "-" + start, placement + "-" + end]);
}, []); // modifiers that need to read the DOM

var beforeRead = 'beforeRead';
var read = 'read';
var afterRead = 'afterRead'; // pure-logic modifiers

var beforeMain = 'beforeMain';
var main = 'main';
var afterMain = 'afterMain'; // modifier with the purpose to write to the DOM (or write into a framework state)

var beforeWrite = 'beforeWrite';
var write = 'write';
var afterWrite = 'afterWrite';
var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/index.js":
/*!**************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   afterMain: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.afterMain),
/* harmony export */   afterRead: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.afterRead),
/* harmony export */   afterWrite: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.afterWrite),
/* harmony export */   applyStyles: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.applyStyles),
/* harmony export */   arrow: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.arrow),
/* harmony export */   auto: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.auto),
/* harmony export */   basePlacements: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.basePlacements),
/* harmony export */   beforeMain: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.beforeMain),
/* harmony export */   beforeRead: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.beforeRead),
/* harmony export */   beforeWrite: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.beforeWrite),
/* harmony export */   bottom: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom),
/* harmony export */   clippingParents: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.clippingParents),
/* harmony export */   computeStyles: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.computeStyles),
/* harmony export */   createPopper: () => (/* reexport safe */ _popper_js__WEBPACK_IMPORTED_MODULE_4__.createPopper),
/* harmony export */   createPopperBase: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_2__.createPopper),
/* harmony export */   createPopperLite: () => (/* reexport safe */ _popper_lite_js__WEBPACK_IMPORTED_MODULE_5__.createPopper),
/* harmony export */   detectOverflow: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   end: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.end),
/* harmony export */   eventListeners: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.eventListeners),
/* harmony export */   flip: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.flip),
/* harmony export */   hide: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.hide),
/* harmony export */   left: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.left),
/* harmony export */   main: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.main),
/* harmony export */   modifierPhases: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.modifierPhases),
/* harmony export */   offset: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.offset),
/* harmony export */   placements: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.placements),
/* harmony export */   popper: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper),
/* harmony export */   popperGenerator: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_2__.popperGenerator),
/* harmony export */   popperOffsets: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.popperOffsets),
/* harmony export */   preventOverflow: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__.preventOverflow),
/* harmony export */   read: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.read),
/* harmony export */   reference: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.reference),
/* harmony export */   right: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.right),
/* harmony export */   start: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.start),
/* harmony export */   top: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.top),
/* harmony export */   variationPlacements: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.variationPlacements),
/* harmony export */   viewport: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.viewport),
/* harmony export */   write: () => (/* reexport safe */ _enums_js__WEBPACK_IMPORTED_MODULE_0__.write)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _modifiers_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modifiers/index.js */ "./node_modules/@popperjs/core/lib/modifiers/index.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/createPopper.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _popper_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./popper.js */ "./node_modules/@popperjs/core/lib/popper.js");
/* harmony import */ var _popper_lite_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./popper-lite.js */ "./node_modules/@popperjs/core/lib/popper-lite.js");

 // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js":
/*!******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/applyStyles.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dom-utils/getNodeName.js */ "./node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

 // This modifier takes the styles prepared by the `computeStyles` modifier
// and applies them to the HTMLElements such as popper and arrow

function applyStyles(_ref) {
  var state = _ref.state;
  Object.keys(state.elements).forEach(function (name) {
    var style = state.styles[name] || {};
    var attributes = state.attributes[name] || {};
    var element = state.elements[name]; // arrow is optional + virtual elements

    if (!(0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || !(0,_dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element)) {
      return;
    } // Flow doesn't support to extend this property, but it's the most
    // effective way to apply styles to an HTMLElement
    // $FlowFixMe[cannot-write]


    Object.assign(element.style, style);
    Object.keys(attributes).forEach(function (name) {
      var value = attributes[name];

      if (value === false) {
        element.removeAttribute(name);
      } else {
        element.setAttribute(name, value === true ? '' : value);
      }
    });
  });
}

function effect(_ref2) {
  var state = _ref2.state;
  var initialStyles = {
    popper: {
      position: state.options.strategy,
      left: '0',
      top: '0',
      margin: '0'
    },
    arrow: {
      position: 'absolute'
    },
    reference: {}
  };
  Object.assign(state.elements.popper.style, initialStyles.popper);
  state.styles = initialStyles;

  if (state.elements.arrow) {
    Object.assign(state.elements.arrow.style, initialStyles.arrow);
  }

  return function () {
    Object.keys(state.elements).forEach(function (name) {
      var element = state.elements[name];
      var attributes = state.attributes[name] || {};
      var styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]); // Set all values to an empty string to unset them

      var style = styleProperties.reduce(function (style, property) {
        style[property] = '';
        return style;
      }, {}); // arrow is optional + virtual elements

      if (!(0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element) || !(0,_dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element)) {
        return;
      }

      Object.assign(element.style, style);
      Object.keys(attributes).forEach(function (attribute) {
        element.removeAttribute(attribute);
      });
    });
  };
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'applyStyles',
  enabled: true,
  phase: 'write',
  fn: applyStyles,
  effect: effect,
  requires: ['computeStyles']
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/arrow.js":
/*!************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/arrow.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dom-utils/getLayoutRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_contains_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../dom-utils/contains.js */ "./node_modules/@popperjs/core/lib/dom-utils/contains.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/getMainAxisFromPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _utils_within_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/within.js */ "./node_modules/@popperjs/core/lib/utils/within.js");
/* harmony import */ var _utils_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/mergePaddingObject.js */ "./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js");
/* harmony import */ var _utils_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/expandToHashMap.js */ "./node_modules/@popperjs/core/lib/utils/expandToHashMap.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");









 // eslint-disable-next-line import/no-unused-modules

var toPaddingObject = function toPaddingObject(padding, state) {
  padding = typeof padding === 'function' ? padding(Object.assign({}, state.rects, {
    placement: state.placement
  })) : padding;
  return (0,_utils_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(typeof padding !== 'number' ? padding : (0,_utils_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_1__["default"])(padding, _enums_js__WEBPACK_IMPORTED_MODULE_2__.basePlacements));
};

function arrow(_ref) {
  var _state$modifiersData$;

  var state = _ref.state,
      name = _ref.name,
      options = _ref.options;
  var arrowElement = state.elements.arrow;
  var popperOffsets = state.modifiersData.popperOffsets;
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(state.placement);
  var axis = (0,_utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(basePlacement);
  var isVertical = [_enums_js__WEBPACK_IMPORTED_MODULE_2__.left, _enums_js__WEBPACK_IMPORTED_MODULE_2__.right].indexOf(basePlacement) >= 0;
  var len = isVertical ? 'height' : 'width';

  if (!arrowElement || !popperOffsets) {
    return;
  }

  var paddingObject = toPaddingObject(options.padding, state);
  var arrowRect = (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_5__["default"])(arrowElement);
  var minProp = axis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_2__.top : _enums_js__WEBPACK_IMPORTED_MODULE_2__.left;
  var maxProp = axis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_2__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_2__.right;
  var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets[axis] - state.rects.popper[len];
  var startDiff = popperOffsets[axis] - state.rects.reference[axis];
  var arrowOffsetParent = (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_6__["default"])(arrowElement);
  var clientSize = arrowOffsetParent ? axis === 'y' ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
  var centerToReference = endDiff / 2 - startDiff / 2; // Make sure the arrow doesn't overflow the popper if the center point is
  // outside of the popper bounds

  var min = paddingObject[minProp];
  var max = clientSize - arrowRect[len] - paddingObject[maxProp];
  var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
  var offset = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_7__.within)(min, center, max); // Prevents breaking syntax highlighting...

  var axisProp = axis;
  state.modifiersData[name] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset, _state$modifiersData$.centerOffset = offset - center, _state$modifiersData$);
}

function effect(_ref2) {
  var state = _ref2.state,
      options = _ref2.options;
  var _options$element = options.element,
      arrowElement = _options$element === void 0 ? '[data-popper-arrow]' : _options$element;

  if (arrowElement == null) {
    return;
  } // CSS selector


  if (typeof arrowElement === 'string') {
    arrowElement = state.elements.popper.querySelector(arrowElement);

    if (!arrowElement) {
      return;
    }
  }

  if (true) {
    if (!(0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_8__.isHTMLElement)(arrowElement)) {
      console.error(['Popper: "arrow" element must be an HTMLElement (not an SVGElement).', 'To use an SVG arrow, wrap it in an HTMLElement that will be used as', 'the arrow.'].join(' '));
    }
  }

  if (!(0,_dom_utils_contains_js__WEBPACK_IMPORTED_MODULE_9__["default"])(state.elements.popper, arrowElement)) {
    if (true) {
      console.error(['Popper: "arrow" modifier\'s `element` must be a child of the popper', 'element.'].join(' '));
    }

    return;
  }

  state.elements.arrow = arrowElement;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'arrow',
  enabled: true,
  phase: 'main',
  fn: arrow,
  effect: effect,
  requires: ['popperOffsets'],
  requiresIfExists: ['preventOverflow']
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/computeStyles.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   mapToStyles: () => (/* binding */ mapToStyles)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dom-utils/getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dom-utils/getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dom-utils/getComputedStyle.js */ "./node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");







 // eslint-disable-next-line import/no-unused-modules

var unsetSides = {
  top: 'auto',
  right: 'auto',
  bottom: 'auto',
  left: 'auto'
}; // Round the offsets to the nearest suitable subpixel based on the DPR.
// Zooming can change the DPR, but it seems to report a value that will
// cleanly divide the values into the appropriate subpixels.

function roundOffsetsByDPR(_ref) {
  var x = _ref.x,
      y = _ref.y;
  var win = window;
  var dpr = win.devicePixelRatio || 1;
  return {
    x: (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(x * dpr) / dpr || 0,
    y: (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_0__.round)(y * dpr) / dpr || 0
  };
}

function mapToStyles(_ref2) {
  var _Object$assign2;

  var popper = _ref2.popper,
      popperRect = _ref2.popperRect,
      placement = _ref2.placement,
      variation = _ref2.variation,
      offsets = _ref2.offsets,
      position = _ref2.position,
      gpuAcceleration = _ref2.gpuAcceleration,
      adaptive = _ref2.adaptive,
      roundOffsets = _ref2.roundOffsets,
      isFixed = _ref2.isFixed;
  var _offsets$x = offsets.x,
      x = _offsets$x === void 0 ? 0 : _offsets$x,
      _offsets$y = offsets.y,
      y = _offsets$y === void 0 ? 0 : _offsets$y;

  var _ref3 = typeof roundOffsets === 'function' ? roundOffsets({
    x: x,
    y: y
  }) : {
    x: x,
    y: y
  };

  x = _ref3.x;
  y = _ref3.y;
  var hasX = offsets.hasOwnProperty('x');
  var hasY = offsets.hasOwnProperty('y');
  var sideX = _enums_js__WEBPACK_IMPORTED_MODULE_1__.left;
  var sideY = _enums_js__WEBPACK_IMPORTED_MODULE_1__.top;
  var win = window;

  if (adaptive) {
    var offsetParent = (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_2__["default"])(popper);
    var heightProp = 'clientHeight';
    var widthProp = 'clientWidth';

    if (offsetParent === (0,_dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_3__["default"])(popper)) {
      offsetParent = (0,_dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(popper);

      if ((0,_dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_5__["default"])(offsetParent).position !== 'static' && position === 'absolute') {
        heightProp = 'scrollHeight';
        widthProp = 'scrollWidth';
      }
    } // $FlowFixMe[incompatible-cast]: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it


    offsetParent = offsetParent;

    if (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.top || (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.left || placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.right) && variation === _enums_js__WEBPACK_IMPORTED_MODULE_1__.end) {
      sideY = _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom;
      var offsetY = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.height : // $FlowFixMe[prop-missing]
      offsetParent[heightProp];
      y -= offsetY - popperRect.height;
      y *= gpuAcceleration ? 1 : -1;
    }

    if (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.left || (placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.top || placement === _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom) && variation === _enums_js__WEBPACK_IMPORTED_MODULE_1__.end) {
      sideX = _enums_js__WEBPACK_IMPORTED_MODULE_1__.right;
      var offsetX = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.width : // $FlowFixMe[prop-missing]
      offsetParent[widthProp];
      x -= offsetX - popperRect.width;
      x *= gpuAcceleration ? 1 : -1;
    }
  }

  var commonStyles = Object.assign({
    position: position
  }, adaptive && unsetSides);

  var _ref4 = roundOffsets === true ? roundOffsetsByDPR({
    x: x,
    y: y
  }) : {
    x: x,
    y: y
  };

  x = _ref4.x;
  y = _ref4.y;

  if (gpuAcceleration) {
    var _Object$assign;

    return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? '0' : '', _Object$assign[sideX] = hasX ? '0' : '', _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x + "px, " + y + "px)" : "translate3d(" + x + "px, " + y + "px, 0)", _Object$assign));
  }

  return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y + "px" : '', _Object$assign2[sideX] = hasX ? x + "px" : '', _Object$assign2.transform = '', _Object$assign2));
}

function computeStyles(_ref5) {
  var state = _ref5.state,
      options = _ref5.options;
  var _options$gpuAccelerat = options.gpuAcceleration,
      gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
      _options$adaptive = options.adaptive,
      adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
      _options$roundOffsets = options.roundOffsets,
      roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;

  if (true) {
    var transitionProperty = (0,_dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_5__["default"])(state.elements.popper).transitionProperty || '';

    if (adaptive && ['transform', 'top', 'right', 'bottom', 'left'].some(function (property) {
      return transitionProperty.indexOf(property) >= 0;
    })) {
      console.warn(['Popper: Detected CSS transitions on at least one of the following', 'CSS properties: "transform", "top", "right", "bottom", "left".', '\n\n', 'Disable the "computeStyles" modifier\'s `adaptive` option to allow', 'for smooth transitions, or remove these properties from the CSS', 'transition declaration on the popper element if only transitioning', 'opacity or background-color for example.', '\n\n', 'We recommend using the popper element as a wrapper around an inner', 'element that can have any CSS property transitioned for animations.'].join(' '));
    }
  }

  var commonStyles = {
    placement: (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state.placement),
    variation: (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_7__["default"])(state.placement),
    popper: state.elements.popper,
    popperRect: state.rects.popper,
    gpuAcceleration: gpuAcceleration,
    isFixed: state.options.strategy === 'fixed'
  };

  if (state.modifiersData.popperOffsets != null) {
    state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.popperOffsets,
      position: state.options.strategy,
      adaptive: adaptive,
      roundOffsets: roundOffsets
    })));
  }

  if (state.modifiersData.arrow != null) {
    state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.arrow,
      position: 'absolute',
      adaptive: false,
      roundOffsets: roundOffsets
    })));
  }

  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-placement': state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'computeStyles',
  enabled: true,
  phase: 'beforeWrite',
  fn: computeStyles,
  data: {}
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/eventListeners.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../dom-utils/getWindow.js */ "./node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
 // eslint-disable-next-line import/no-unused-modules

var passive = {
  passive: true
};

function effect(_ref) {
  var state = _ref.state,
      instance = _ref.instance,
      options = _ref.options;
  var _options$scroll = options.scroll,
      scroll = _options$scroll === void 0 ? true : _options$scroll,
      _options$resize = options.resize,
      resize = _options$resize === void 0 ? true : _options$resize;
  var window = (0,_dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(state.elements.popper);
  var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);

  if (scroll) {
    scrollParents.forEach(function (scrollParent) {
      scrollParent.addEventListener('scroll', instance.update, passive);
    });
  }

  if (resize) {
    window.addEventListener('resize', instance.update, passive);
  }

  return function () {
    if (scroll) {
      scrollParents.forEach(function (scrollParent) {
        scrollParent.removeEventListener('scroll', instance.update, passive);
      });
    }

    if (resize) {
      window.removeEventListener('resize', instance.update, passive);
    }
  };
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'eventListeners',
  enabled: true,
  phase: 'write',
  fn: function fn() {},
  effect: effect,
  data: {}
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/flip.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/flip.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/getOppositePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getOppositePlacement.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/getOppositeVariationPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _utils_computeAutoPlacement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/computeAutoPlacement.js */ "./node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");






 // eslint-disable-next-line import/no-unused-modules

function getExpandedFallbackPlacements(placement) {
  if ((0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_1__.auto) {
    return [];
  }

  var oppositePlacement = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(placement);
  return [(0,_utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(placement), oppositePlacement, (0,_utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(oppositePlacement)];
}

function flip(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;

  if (state.modifiersData[name]._skip) {
    return;
  }

  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis,
      specifiedFallbackPlacements = options.fallbackPlacements,
      padding = options.padding,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      _options$flipVariatio = options.flipVariations,
      flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio,
      allowedAutoPlacements = options.allowedAutoPlacements;
  var preferredPlacement = state.options.placement;
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(preferredPlacement);
  var isBasePlacement = basePlacement === preferredPlacement;
  var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [(0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
  var placements = [preferredPlacement].concat(fallbackPlacements).reduce(function (acc, placement) {
    return acc.concat((0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_1__.auto ? (0,_utils_computeAutoPlacement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding,
      flipVariations: flipVariations,
      allowedAutoPlacements: allowedAutoPlacements
    }) : placement);
  }, []);
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var checksMap = new Map();
  var makeFallbackChecks = true;
  var firstFittingPlacement = placements[0];

  for (var i = 0; i < placements.length; i++) {
    var placement = placements[i];

    var _basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement);

    var isStartVariation = (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_5__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_1__.start;
    var isVertical = [_enums_js__WEBPACK_IMPORTED_MODULE_1__.top, _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom].indexOf(_basePlacement) >= 0;
    var len = isVertical ? 'width' : 'height';
    var overflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      altBoundary: altBoundary,
      padding: padding
    });
    var mainVariationSide = isVertical ? isStartVariation ? _enums_js__WEBPACK_IMPORTED_MODULE_1__.right : _enums_js__WEBPACK_IMPORTED_MODULE_1__.left : isStartVariation ? _enums_js__WEBPACK_IMPORTED_MODULE_1__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_1__.top;

    if (referenceRect[len] > popperRect[len]) {
      mainVariationSide = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(mainVariationSide);
    }

    var altVariationSide = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(mainVariationSide);
    var checks = [];

    if (checkMainAxis) {
      checks.push(overflow[_basePlacement] <= 0);
    }

    if (checkAltAxis) {
      checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
    }

    if (checks.every(function (check) {
      return check;
    })) {
      firstFittingPlacement = placement;
      makeFallbackChecks = false;
      break;
    }

    checksMap.set(placement, checks);
  }

  if (makeFallbackChecks) {
    // `2` may be desired in some cases – research later
    var numberOfChecks = flipVariations ? 3 : 1;

    var _loop = function _loop(_i) {
      var fittingPlacement = placements.find(function (placement) {
        var checks = checksMap.get(placement);

        if (checks) {
          return checks.slice(0, _i).every(function (check) {
            return check;
          });
        }
      });

      if (fittingPlacement) {
        firstFittingPlacement = fittingPlacement;
        return "break";
      }
    };

    for (var _i = numberOfChecks; _i > 0; _i--) {
      var _ret = _loop(_i);

      if (_ret === "break") break;
    }
  }

  if (state.placement !== firstFittingPlacement) {
    state.modifiersData[name]._skip = true;
    state.placement = firstFittingPlacement;
    state.reset = true;
  }
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'flip',
  enabled: true,
  phase: 'main',
  fn: flip,
  requiresIfExists: ['offset'],
  data: {
    _skip: false
  }
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/hide.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/hide.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");



function getSideOffsets(overflow, rect, preventedOffsets) {
  if (preventedOffsets === void 0) {
    preventedOffsets = {
      x: 0,
      y: 0
    };
  }

  return {
    top: overflow.top - rect.height - preventedOffsets.y,
    right: overflow.right - rect.width + preventedOffsets.x,
    bottom: overflow.bottom - rect.height + preventedOffsets.y,
    left: overflow.left - rect.width - preventedOffsets.x
  };
}

function isAnySideFullyClipped(overflow) {
  return [_enums_js__WEBPACK_IMPORTED_MODULE_0__.top, _enums_js__WEBPACK_IMPORTED_MODULE_0__.right, _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom, _enums_js__WEBPACK_IMPORTED_MODULE_0__.left].some(function (side) {
    return overflow[side] >= 0;
  });
}

function hide(_ref) {
  var state = _ref.state,
      name = _ref.name;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var preventedOffsets = state.modifiersData.preventOverflow;
  var referenceOverflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state, {
    elementContext: 'reference'
  });
  var popperAltOverflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state, {
    altBoundary: true
  });
  var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
  var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
  var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
  var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
  state.modifiersData[name] = {
    referenceClippingOffsets: referenceClippingOffsets,
    popperEscapeOffsets: popperEscapeOffsets,
    isReferenceHidden: isReferenceHidden,
    hasPopperEscaped: hasPopperEscaped
  };
  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-reference-hidden': isReferenceHidden,
    'data-popper-escaped': hasPopperEscaped
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'hide',
  enabled: true,
  phase: 'main',
  requiresIfExists: ['preventOverflow'],
  fn: hide
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyStyles: () => (/* reexport safe */ _applyStyles_js__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   arrow: () => (/* reexport safe */ _arrow_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   computeStyles: () => (/* reexport safe */ _computeStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   eventListeners: () => (/* reexport safe */ _eventListeners_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   flip: () => (/* reexport safe */ _flip_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   hide: () => (/* reexport safe */ _hide_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   offset: () => (/* reexport safe */ _offset_js__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   popperOffsets: () => (/* reexport safe */ _popperOffsets_js__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   preventOverflow: () => (/* reexport safe */ _preventOverflow_js__WEBPACK_IMPORTED_MODULE_8__["default"])
/* harmony export */ });
/* harmony import */ var _applyStyles_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./applyStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js");
/* harmony import */ var _arrow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./arrow.js */ "./node_modules/@popperjs/core/lib/modifiers/arrow.js");
/* harmony import */ var _computeStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./computeStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _eventListeners_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./eventListeners.js */ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _flip_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./flip.js */ "./node_modules/@popperjs/core/lib/modifiers/flip.js");
/* harmony import */ var _hide_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./hide.js */ "./node_modules/@popperjs/core/lib/modifiers/hide.js");
/* harmony import */ var _offset_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./offset.js */ "./node_modules/@popperjs/core/lib/modifiers/offset.js");
/* harmony import */ var _popperOffsets_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./popperOffsets.js */ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _preventOverflow_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./preventOverflow.js */ "./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js");










/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/offset.js":
/*!*************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/offset.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   distanceAndSkiddingToXY: () => (/* binding */ distanceAndSkiddingToXY)
/* harmony export */ });
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");

 // eslint-disable-next-line import/no-unused-modules

function distanceAndSkiddingToXY(placement, rects, offset) {
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement);
  var invertDistance = [_enums_js__WEBPACK_IMPORTED_MODULE_1__.left, _enums_js__WEBPACK_IMPORTED_MODULE_1__.top].indexOf(basePlacement) >= 0 ? -1 : 1;

  var _ref = typeof offset === 'function' ? offset(Object.assign({}, rects, {
    placement: placement
  })) : offset,
      skidding = _ref[0],
      distance = _ref[1];

  skidding = skidding || 0;
  distance = (distance || 0) * invertDistance;
  return [_enums_js__WEBPACK_IMPORTED_MODULE_1__.left, _enums_js__WEBPACK_IMPORTED_MODULE_1__.right].indexOf(basePlacement) >= 0 ? {
    x: distance,
    y: skidding
  } : {
    x: skidding,
    y: distance
  };
}

function offset(_ref2) {
  var state = _ref2.state,
      options = _ref2.options,
      name = _ref2.name;
  var _options$offset = options.offset,
      offset = _options$offset === void 0 ? [0, 0] : _options$offset;
  var data = _enums_js__WEBPACK_IMPORTED_MODULE_1__.placements.reduce(function (acc, placement) {
    acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset);
    return acc;
  }, {});
  var _data$state$placement = data[state.placement],
      x = _data$state$placement.x,
      y = _data$state$placement.y;

  if (state.modifiersData.popperOffsets != null) {
    state.modifiersData.popperOffsets.x += x;
    state.modifiersData.popperOffsets.y += y;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'offset',
  enabled: true,
  phase: 'main',
  requires: ['popperOffsets'],
  fn: offset
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_computeOffsets_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/computeOffsets.js */ "./node_modules/@popperjs/core/lib/utils/computeOffsets.js");


function popperOffsets(_ref) {
  var state = _ref.state,
      name = _ref.name;
  // Offsets are the actual position the popper needs to have to be
  // properly positioned near its reference element
  // This is the most basic placement, and will be adjusted by
  // the modifiers in the next step
  state.modifiersData[name] = (0,_utils_computeOffsets_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    reference: state.rects.reference,
    element: state.rects.popper,
    strategy: 'absolute',
    placement: state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'popperOffsets',
  enabled: true,
  phase: 'read',
  fn: popperOffsets,
  data: {}
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/getMainAxisFromPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _utils_getAltAxis_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/getAltAxis.js */ "./node_modules/@popperjs/core/lib/utils/getAltAxis.js");
/* harmony import */ var _utils_within_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/within.js */ "./node_modules/@popperjs/core/lib/utils/within.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/getLayoutRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "./node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _utils_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/getFreshSideObject.js */ "./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");












function preventOverflow(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;
  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      padding = options.padding,
      _options$tether = options.tether,
      tether = _options$tether === void 0 ? true : _options$tether,
      _options$tetherOffset = options.tetherOffset,
      tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
  var overflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(state, {
    boundary: boundary,
    rootBoundary: rootBoundary,
    padding: padding,
    altBoundary: altBoundary
  });
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state.placement);
  var variation = (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_2__["default"])(state.placement);
  var isBasePlacement = !variation;
  var mainAxis = (0,_utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(basePlacement);
  var altAxis = (0,_utils_getAltAxis_js__WEBPACK_IMPORTED_MODULE_4__["default"])(mainAxis);
  var popperOffsets = state.modifiersData.popperOffsets;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var tetherOffsetValue = typeof tetherOffset === 'function' ? tetherOffset(Object.assign({}, state.rects, {
    placement: state.placement
  })) : tetherOffset;
  var normalizedTetherOffsetValue = typeof tetherOffsetValue === 'number' ? {
    mainAxis: tetherOffsetValue,
    altAxis: tetherOffsetValue
  } : Object.assign({
    mainAxis: 0,
    altAxis: 0
  }, tetherOffsetValue);
  var offsetModifierState = state.modifiersData.offset ? state.modifiersData.offset[state.placement] : null;
  var data = {
    x: 0,
    y: 0
  };

  if (!popperOffsets) {
    return;
  }

  if (checkMainAxis) {
    var _offsetModifierState$;

    var mainSide = mainAxis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.top : _enums_js__WEBPACK_IMPORTED_MODULE_5__.left;
    var altSide = mainAxis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_5__.right;
    var len = mainAxis === 'y' ? 'height' : 'width';
    var offset = popperOffsets[mainAxis];
    var min = offset + overflow[mainSide];
    var max = offset - overflow[altSide];
    var additive = tether ? -popperRect[len] / 2 : 0;
    var minLen = variation === _enums_js__WEBPACK_IMPORTED_MODULE_5__.start ? referenceRect[len] : popperRect[len];
    var maxLen = variation === _enums_js__WEBPACK_IMPORTED_MODULE_5__.start ? -popperRect[len] : -referenceRect[len]; // We need to include the arrow in the calculation so the arrow doesn't go
    // outside the reference bounds

    var arrowElement = state.elements.arrow;
    var arrowRect = tether && arrowElement ? (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_6__["default"])(arrowElement) : {
      width: 0,
      height: 0
    };
    var arrowPaddingObject = state.modifiersData['arrow#persistent'] ? state.modifiersData['arrow#persistent'].padding : (0,_utils_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_7__["default"])();
    var arrowPaddingMin = arrowPaddingObject[mainSide];
    var arrowPaddingMax = arrowPaddingObject[altSide]; // If the reference length is smaller than the arrow length, we don't want
    // to include its full size in the calculation. If the reference is small
    // and near the edge of a boundary, the popper can overflow even if the
    // reference is not overflowing as well (e.g. virtual elements with no
    // width or height)

    var arrowLen = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.within)(0, referenceRect[len], arrowRect[len]);
    var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis : minLen - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis;
    var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis : maxLen + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis;
    var arrowOffsetParent = state.elements.arrow && (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_9__["default"])(state.elements.arrow);
    var clientOffset = arrowOffsetParent ? mainAxis === 'y' ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
    var offsetModifierValue = (_offsetModifierState$ = offsetModifierState == null ? void 0 : offsetModifierState[mainAxis]) != null ? _offsetModifierState$ : 0;
    var tetherMin = offset + minOffset - offsetModifierValue - clientOffset;
    var tetherMax = offset + maxOffset - offsetModifierValue;
    var preventedOffset = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.within)(tether ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_10__.min)(min, tetherMin) : min, offset, tether ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_10__.max)(max, tetherMax) : max);
    popperOffsets[mainAxis] = preventedOffset;
    data[mainAxis] = preventedOffset - offset;
  }

  if (checkAltAxis) {
    var _offsetModifierState$2;

    var _mainSide = mainAxis === 'x' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.top : _enums_js__WEBPACK_IMPORTED_MODULE_5__.left;

    var _altSide = mainAxis === 'x' ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_5__.right;

    var _offset = popperOffsets[altAxis];

    var _len = altAxis === 'y' ? 'height' : 'width';

    var _min = _offset + overflow[_mainSide];

    var _max = _offset - overflow[_altSide];

    var isOriginSide = [_enums_js__WEBPACK_IMPORTED_MODULE_5__.top, _enums_js__WEBPACK_IMPORTED_MODULE_5__.left].indexOf(basePlacement) !== -1;

    var _offsetModifierValue = (_offsetModifierState$2 = offsetModifierState == null ? void 0 : offsetModifierState[altAxis]) != null ? _offsetModifierState$2 : 0;

    var _tetherMin = isOriginSide ? _min : _offset - referenceRect[_len] - popperRect[_len] - _offsetModifierValue + normalizedTetherOffsetValue.altAxis;

    var _tetherMax = isOriginSide ? _offset + referenceRect[_len] + popperRect[_len] - _offsetModifierValue - normalizedTetherOffsetValue.altAxis : _max;

    var _preventedOffset = tether && isOriginSide ? (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.withinMaxClamp)(_tetherMin, _offset, _tetherMax) : (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_8__.within)(tether ? _tetherMin : _min, _offset, tether ? _tetherMax : _max);

    popperOffsets[altAxis] = _preventedOffset;
    data[altAxis] = _preventedOffset - _offset;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'preventOverflow',
  enabled: true,
  phase: 'main',
  fn: preventOverflow,
  requiresIfExists: ['offset']
});

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/popper-lite.js":
/*!********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/popper-lite.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPopper: () => (/* binding */ createPopper),
/* harmony export */   defaultModifiers: () => (/* binding */ defaultModifiers),
/* harmony export */   detectOverflow: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   popperGenerator: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_4__.popperGenerator)
/* harmony export */ });
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/createPopper.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modifiers/eventListeners.js */ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modifiers/popperOffsets.js */ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modifiers/computeStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modifiers/applyStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js");





var defaultModifiers = [_modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__["default"], _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__["default"], _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"], _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__["default"]];
var createPopper = /*#__PURE__*/(0,_createPopper_js__WEBPACK_IMPORTED_MODULE_4__.popperGenerator)({
  defaultModifiers: defaultModifiers
}); // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/popper.js":
/*!***************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/popper.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyStyles: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.applyStyles),
/* harmony export */   arrow: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.arrow),
/* harmony export */   computeStyles: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.computeStyles),
/* harmony export */   createPopper: () => (/* binding */ createPopper),
/* harmony export */   createPopperLite: () => (/* reexport safe */ _popper_lite_js__WEBPACK_IMPORTED_MODULE_11__.createPopper),
/* harmony export */   defaultModifiers: () => (/* binding */ defaultModifiers),
/* harmony export */   detectOverflow: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   eventListeners: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.eventListeners),
/* harmony export */   flip: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.flip),
/* harmony export */   hide: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.hide),
/* harmony export */   offset: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.offset),
/* harmony export */   popperGenerator: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_9__.popperGenerator),
/* harmony export */   popperOffsets: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.popperOffsets),
/* harmony export */   preventOverflow: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.preventOverflow)
/* harmony export */ });
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/createPopper.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./createPopper.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modifiers/eventListeners.js */ "./node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./modifiers/popperOffsets.js */ "./node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modifiers/computeStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modifiers/applyStyles.js */ "./node_modules/@popperjs/core/lib/modifiers/applyStyles.js");
/* harmony import */ var _modifiers_offset_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modifiers/offset.js */ "./node_modules/@popperjs/core/lib/modifiers/offset.js");
/* harmony import */ var _modifiers_flip_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./modifiers/flip.js */ "./node_modules/@popperjs/core/lib/modifiers/flip.js");
/* harmony import */ var _modifiers_preventOverflow_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./modifiers/preventOverflow.js */ "./node_modules/@popperjs/core/lib/modifiers/preventOverflow.js");
/* harmony import */ var _modifiers_arrow_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./modifiers/arrow.js */ "./node_modules/@popperjs/core/lib/modifiers/arrow.js");
/* harmony import */ var _modifiers_hide_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./modifiers/hide.js */ "./node_modules/@popperjs/core/lib/modifiers/hide.js");
/* harmony import */ var _popper_lite_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./popper-lite.js */ "./node_modules/@popperjs/core/lib/popper-lite.js");
/* harmony import */ var _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./modifiers/index.js */ "./node_modules/@popperjs/core/lib/modifiers/index.js");










var defaultModifiers = [_modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_0__["default"], _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_1__["default"], _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"], _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_3__["default"], _modifiers_offset_js__WEBPACK_IMPORTED_MODULE_4__["default"], _modifiers_flip_js__WEBPACK_IMPORTED_MODULE_5__["default"], _modifiers_preventOverflow_js__WEBPACK_IMPORTED_MODULE_6__["default"], _modifiers_arrow_js__WEBPACK_IMPORTED_MODULE_7__["default"], _modifiers_hide_js__WEBPACK_IMPORTED_MODULE_8__["default"]];
var createPopper = /*#__PURE__*/(0,_createPopper_js__WEBPACK_IMPORTED_MODULE_9__.popperGenerator)({
  defaultModifiers: defaultModifiers
}); // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ computeAutoPlacement)
/* harmony export */ });
/* harmony import */ var _getVariation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _detectOverflow_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./detectOverflow.js */ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");




function computeAutoPlacement(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      placement = _options.placement,
      boundary = _options.boundary,
      rootBoundary = _options.rootBoundary,
      padding = _options.padding,
      flipVariations = _options.flipVariations,
      _options$allowedAutoP = _options.allowedAutoPlacements,
      allowedAutoPlacements = _options$allowedAutoP === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.placements : _options$allowedAutoP;
  var variation = (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement);
  var placements = variation ? flipVariations ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.variationPlacements : _enums_js__WEBPACK_IMPORTED_MODULE_0__.variationPlacements.filter(function (placement) {
    return (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement) === variation;
  }) : _enums_js__WEBPACK_IMPORTED_MODULE_0__.basePlacements;
  var allowedPlacements = placements.filter(function (placement) {
    return allowedAutoPlacements.indexOf(placement) >= 0;
  });

  if (allowedPlacements.length === 0) {
    allowedPlacements = placements;

    if (true) {
      console.error(['Popper: The `allowedAutoPlacements` option did not allow any', 'placements. Ensure the `placement` option matches the variation', 'of the allowed placements.', 'For example, "auto" cannot be used to allow "bottom-start".', 'Use "auto-start" instead.'].join(' '));
    }
  } // $FlowFixMe[incompatible-type]: Flow seems to have problems with two array unions...


  var overflows = allowedPlacements.reduce(function (acc, placement) {
    acc[placement] = (0,_detectOverflow_js__WEBPACK_IMPORTED_MODULE_2__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding
    })[(0,_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(placement)];
    return acc;
  }, {});
  return Object.keys(overflows).sort(function (a, b) {
    return overflows[a] - overflows[b];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/computeOffsets.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/computeOffsets.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ computeOffsets)
/* harmony export */ });
/* harmony import */ var _getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBasePlacement.js */ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _getVariation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getVariation.js */ "./node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getMainAxisFromPlacement.js */ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");




function computeOffsets(_ref) {
  var reference = _ref.reference,
      element = _ref.element,
      placement = _ref.placement;
  var basePlacement = placement ? (0,_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) : null;
  var variation = placement ? (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement) : null;
  var commonX = reference.x + reference.width / 2 - element.width / 2;
  var commonY = reference.y + reference.height / 2 - element.height / 2;
  var offsets;

  switch (basePlacement) {
    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.top:
      offsets = {
        x: commonX,
        y: reference.y - element.height
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.bottom:
      offsets = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.right:
      offsets = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_2__.left:
      offsets = {
        x: reference.x - element.width,
        y: commonY
      };
      break;

    default:
      offsets = {
        x: reference.x,
        y: reference.y
      };
  }

  var mainAxis = basePlacement ? (0,_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(basePlacement) : null;

  if (mainAxis != null) {
    var len = mainAxis === 'y' ? 'height' : 'width';

    switch (variation) {
      case _enums_js__WEBPACK_IMPORTED_MODULE_2__.start:
        offsets[mainAxis] = offsets[mainAxis] - (reference[len] / 2 - element[len] / 2);
        break;

      case _enums_js__WEBPACK_IMPORTED_MODULE_2__.end:
        offsets[mainAxis] = offsets[mainAxis] + (reference[len] / 2 - element[len] / 2);
        break;

      default:
    }
  }

  return offsets;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/debounce.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/debounce.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ debounce)
/* harmony export */ });
function debounce(fn) {
  var pending;
  return function () {
    if (!pending) {
      pending = new Promise(function (resolve) {
        Promise.resolve().then(function () {
          pending = undefined;
          resolve(fn());
        });
      });
    }

    return pending;
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/detectOverflow.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/detectOverflow.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ detectOverflow)
/* harmony export */ });
/* harmony import */ var _dom_utils_getClippingRect_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dom-utils/getClippingRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js");
/* harmony import */ var _dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dom-utils/getDocumentElement.js */ "./node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _dom_utils_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/getBoundingClientRect.js */ "./node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _computeOffsets_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./computeOffsets.js */ "./node_modules/@popperjs/core/lib/utils/computeOffsets.js");
/* harmony import */ var _rectToClientRect_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./rectToClientRect.js */ "./node_modules/@popperjs/core/lib/utils/rectToClientRect.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dom-utils/instanceOf.js */ "./node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mergePaddingObject.js */ "./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js");
/* harmony import */ var _expandToHashMap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./expandToHashMap.js */ "./node_modules/@popperjs/core/lib/utils/expandToHashMap.js");








 // eslint-disable-next-line import/no-unused-modules

function detectOverflow(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      _options$placement = _options.placement,
      placement = _options$placement === void 0 ? state.placement : _options$placement,
      _options$strategy = _options.strategy,
      strategy = _options$strategy === void 0 ? state.strategy : _options$strategy,
      _options$boundary = _options.boundary,
      boundary = _options$boundary === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.clippingParents : _options$boundary,
      _options$rootBoundary = _options.rootBoundary,
      rootBoundary = _options$rootBoundary === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.viewport : _options$rootBoundary,
      _options$elementConte = _options.elementContext,
      elementContext = _options$elementConte === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper : _options$elementConte,
      _options$altBoundary = _options.altBoundary,
      altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary,
      _options$padding = _options.padding,
      padding = _options$padding === void 0 ? 0 : _options$padding;
  var paddingObject = (0,_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_1__["default"])(typeof padding !== 'number' ? padding : (0,_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_2__["default"])(padding, _enums_js__WEBPACK_IMPORTED_MODULE_0__.basePlacements));
  var altContext = elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.reference : _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper;
  var popperRect = state.rects.popper;
  var element = state.elements[altBoundary ? altContext : elementContext];
  var clippingClientRect = (0,_dom_utils_getClippingRect_js__WEBPACK_IMPORTED_MODULE_3__["default"])((0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_4__.isElement)(element) ? element : element.contextElement || (0,_dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_5__["default"])(state.elements.popper), boundary, rootBoundary, strategy);
  var referenceClientRect = (0,_dom_utils_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state.elements.reference);
  var popperOffsets = (0,_computeOffsets_js__WEBPACK_IMPORTED_MODULE_7__["default"])({
    reference: referenceClientRect,
    element: popperRect,
    strategy: 'absolute',
    placement: placement
  });
  var popperClientRect = (0,_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_8__["default"])(Object.assign({}, popperRect, popperOffsets));
  var elementClientRect = elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper ? popperClientRect : referenceClientRect; // positive = overflowing the clipping rect
  // 0 or negative = within the clipping rect

  var overflowOffsets = {
    top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
    bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
    left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
    right: elementClientRect.right - clippingClientRect.right + paddingObject.right
  };
  var offsetData = state.modifiersData.offset; // Offsets can be applied only to the popper element

  if (elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_0__.popper && offsetData) {
    var offset = offsetData[placement];
    Object.keys(overflowOffsets).forEach(function (key) {
      var multiply = [_enums_js__WEBPACK_IMPORTED_MODULE_0__.right, _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom].indexOf(key) >= 0 ? 1 : -1;
      var axis = [_enums_js__WEBPACK_IMPORTED_MODULE_0__.top, _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom].indexOf(key) >= 0 ? 'y' : 'x';
      overflowOffsets[key] += offset[axis] * multiply;
    });
  }

  return overflowOffsets;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/expandToHashMap.js":
/*!******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/expandToHashMap.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ expandToHashMap)
/* harmony export */ });
function expandToHashMap(value, keys) {
  return keys.reduce(function (hashMap, key) {
    hashMap[key] = value;
    return hashMap;
  }, {});
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/format.js":
/*!*********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/format.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ format)
/* harmony export */ });
function format(str) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }

  return [].concat(args).reduce(function (p, c) {
    return p.replace(/%s/, c);
  }, str);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getAltAxis.js":
/*!*************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getAltAxis.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getAltAxis)
/* harmony export */ });
function getAltAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getBasePlacement.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getBasePlacement.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getBasePlacement)
/* harmony export */ });

function getBasePlacement(placement) {
  return placement.split('-')[0];
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getFreshSideObject)
/* harmony export */ });
function getFreshSideObject() {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  };
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getMainAxisFromPlacement)
/* harmony export */ });
function getMainAxisFromPlacement(placement) {
  return ['top', 'bottom'].indexOf(placement) >= 0 ? 'x' : 'y';
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getOppositePlacement.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getOppositePlacement.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOppositePlacement)
/* harmony export */ });
var hash = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, function (matched) {
    return hash[matched];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOppositeVariationPlacement)
/* harmony export */ });
var hash = {
  start: 'end',
  end: 'start'
};
function getOppositeVariationPlacement(placement) {
  return placement.replace(/start|end/g, function (matched) {
    return hash[matched];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/getVariation.js":
/*!***************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/getVariation.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getVariation)
/* harmony export */ });
function getVariation(placement) {
  return placement.split('-')[1];
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/math.js":
/*!*******************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/math.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   max: () => (/* binding */ max),
/* harmony export */   min: () => (/* binding */ min),
/* harmony export */   round: () => (/* binding */ round)
/* harmony export */ });
var max = Math.max;
var min = Math.min;
var round = Math.round;

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/mergeByName.js":
/*!**************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/mergeByName.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeByName)
/* harmony export */ });
function mergeByName(modifiers) {
  var merged = modifiers.reduce(function (merged, current) {
    var existing = merged[current.name];
    merged[current.name] = existing ? Object.assign({}, existing, current, {
      options: Object.assign({}, existing.options, current.options),
      data: Object.assign({}, existing.data, current.data)
    }) : current;
    return merged;
  }, {}); // IE11 does not support Object.values

  return Object.keys(merged).map(function (key) {
    return merged[key];
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/mergePaddingObject.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergePaddingObject)
/* harmony export */ });
/* harmony import */ var _getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getFreshSideObject.js */ "./node_modules/@popperjs/core/lib/utils/getFreshSideObject.js");

function mergePaddingObject(paddingObject) {
  return Object.assign({}, (0,_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(), paddingObject);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/orderModifiers.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/orderModifiers.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ orderModifiers)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");
 // source: https://stackoverflow.com/questions/49875255

function order(modifiers) {
  var map = new Map();
  var visited = new Set();
  var result = [];
  modifiers.forEach(function (modifier) {
    map.set(modifier.name, modifier);
  }); // On visiting object, check for its dependencies and visit them recursively

  function sort(modifier) {
    visited.add(modifier.name);
    var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
    requires.forEach(function (dep) {
      if (!visited.has(dep)) {
        var depModifier = map.get(dep);

        if (depModifier) {
          sort(depModifier);
        }
      }
    });
    result.push(modifier);
  }

  modifiers.forEach(function (modifier) {
    if (!visited.has(modifier.name)) {
      // check for visited object
      sort(modifier);
    }
  });
  return result;
}

function orderModifiers(modifiers) {
  // order based on dependencies
  var orderedModifiers = order(modifiers); // order based on phase

  return _enums_js__WEBPACK_IMPORTED_MODULE_0__.modifierPhases.reduce(function (acc, phase) {
    return acc.concat(orderedModifiers.filter(function (modifier) {
      return modifier.phase === phase;
    }));
  }, []);
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/rectToClientRect.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/rectToClientRect.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ rectToClientRect)
/* harmony export */ });
function rectToClientRect(rect) {
  return Object.assign({}, rect, {
    left: rect.x,
    top: rect.y,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/uniqueBy.js":
/*!***********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/uniqueBy.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ uniqueBy)
/* harmony export */ });
function uniqueBy(arr, fn) {
  var identifiers = new Set();
  return arr.filter(function (item) {
    var identifier = fn(item);

    if (!identifiers.has(identifier)) {
      identifiers.add(identifier);
      return true;
    }
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/userAgent.js":
/*!************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/userAgent.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getUAString)
/* harmony export */ });
function getUAString() {
  var uaData = navigator.userAgentData;

  if (uaData != null && uaData.brands) {
    return uaData.brands.map(function (item) {
      return item.brand + "/" + item.version;
    }).join(' ');
  }

  return navigator.userAgent;
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/validateModifiers.js":
/*!********************************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/validateModifiers.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ validateModifiers)
/* harmony export */ });
/* harmony import */ var _format_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./format.js */ "./node_modules/@popperjs/core/lib/utils/format.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "./node_modules/@popperjs/core/lib/enums.js");


var INVALID_MODIFIER_ERROR = 'Popper: modifier "%s" provided an invalid %s property, expected %s but got %s';
var MISSING_DEPENDENCY_ERROR = 'Popper: modifier "%s" requires "%s", but "%s" modifier is not available';
var VALID_PROPERTIES = ['name', 'enabled', 'phase', 'fn', 'effect', 'requires', 'options'];
function validateModifiers(modifiers) {
  modifiers.forEach(function (modifier) {
    [].concat(Object.keys(modifier), VALID_PROPERTIES) // IE11-compatible replacement for `new Set(iterable)`
    .filter(function (value, index, self) {
      return self.indexOf(value) === index;
    }).forEach(function (key) {
      switch (key) {
        case 'name':
          if (typeof modifier.name !== 'string') {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, String(modifier.name), '"name"', '"string"', "\"" + String(modifier.name) + "\""));
          }

          break;

        case 'enabled':
          if (typeof modifier.enabled !== 'boolean') {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"enabled"', '"boolean"', "\"" + String(modifier.enabled) + "\""));
          }

          break;

        case 'phase':
          if (_enums_js__WEBPACK_IMPORTED_MODULE_1__.modifierPhases.indexOf(modifier.phase) < 0) {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"phase"', "either " + _enums_js__WEBPACK_IMPORTED_MODULE_1__.modifierPhases.join(', '), "\"" + String(modifier.phase) + "\""));
          }

          break;

        case 'fn':
          if (typeof modifier.fn !== 'function') {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"fn"', '"function"', "\"" + String(modifier.fn) + "\""));
          }

          break;

        case 'effect':
          if (modifier.effect != null && typeof modifier.effect !== 'function') {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"effect"', '"function"', "\"" + String(modifier.fn) + "\""));
          }

          break;

        case 'requires':
          if (modifier.requires != null && !Array.isArray(modifier.requires)) {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"requires"', '"array"', "\"" + String(modifier.requires) + "\""));
          }

          break;

        case 'requiresIfExists':
          if (!Array.isArray(modifier.requiresIfExists)) {
            console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(INVALID_MODIFIER_ERROR, modifier.name, '"requiresIfExists"', '"array"', "\"" + String(modifier.requiresIfExists) + "\""));
          }

          break;

        case 'options':
        case 'data':
          break;

        default:
          console.error("PopperJS: an invalid property has been provided to the \"" + modifier.name + "\" modifier, valid properties are " + VALID_PROPERTIES.map(function (s) {
            return "\"" + s + "\"";
          }).join(', ') + "; but \"" + key + "\" was provided.");
      }

      modifier.requires && modifier.requires.forEach(function (requirement) {
        if (modifiers.find(function (mod) {
          return mod.name === requirement;
        }) == null) {
          console.error((0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(MISSING_DEPENDENCY_ERROR, String(modifier.name), requirement, requirement));
        }
      });
    });
  });
}

/***/ }),

/***/ "./node_modules/@popperjs/core/lib/utils/within.js":
/*!*********************************************************!*\
  !*** ./node_modules/@popperjs/core/lib/utils/within.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   within: () => (/* binding */ within),
/* harmony export */   withinMaxClamp: () => (/* binding */ withinMaxClamp)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/@popperjs/core/lib/utils/math.js");

function within(min, value, max) {
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.max)(min, (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.min)(value, max));
}
function withinMaxClamp(min, value, max) {
  var v = within(min, value, max);
  return v > max ? max : v;
}

/***/ }),

/***/ "./public/backend/js/loadah.min.js":
/*!*****************************************!*\
  !*** ./public/backend/js/loadah.min.js ***!
  \*****************************************/
/***/ (function(module, exports, __webpack_require__) {

/* module decorator */ module = __webpack_require__.nmd(module);
var __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */
(function () {
  function n(n, t, r) {
    switch (r.length) {
      case 0:
        return n.call(t);
      case 1:
        return n.call(t, r[0]);
      case 2:
        return n.call(t, r[0], r[1]);
      case 3:
        return n.call(t, r[0], r[1], r[2]);
    }
    return n.apply(t, r);
  }
  function t(n, t, r, e) {
    for (var u = -1, i = null == n ? 0 : n.length; ++u < i;) {
      var o = n[u];
      t(e, o, r(o), n);
    }
    return e;
  }
  function r(n, t) {
    for (var r = -1, e = null == n ? 0 : n.length; ++r < e && t(n[r], r, n) !== !1;);
    return n;
  }
  function e(n, t) {
    for (var r = null == n ? 0 : n.length; r-- && t(n[r], r, n) !== !1;);
    return n;
  }
  function u(n, t) {
    for (var r = -1, e = null == n ? 0 : n.length; ++r < e;) if (!t(n[r], r, n)) return !1;
    return !0;
  }
  function i(n, t) {
    for (var r = -1, e = null == n ? 0 : n.length, u = 0, i = []; ++r < e;) {
      var o = n[r];
      t(o, r, n) && (i[u++] = o);
    }
    return i;
  }
  function o(n, t) {
    return !!(null == n ? 0 : n.length) && y(n, t, 0) > -1;
  }
  function f(n, t, r) {
    for (var e = -1, u = null == n ? 0 : n.length; ++e < u;) if (r(t, n[e])) return !0;
    return !1;
  }
  function c(n, t) {
    for (var r = -1, e = null == n ? 0 : n.length, u = Array(e); ++r < e;) u[r] = t(n[r], r, n);
    return u;
  }
  function a(n, t) {
    for (var r = -1, e = t.length, u = n.length; ++r < e;) n[u + r] = t[r];
    return n;
  }
  function l(n, t, r, e) {
    var u = -1,
      i = null == n ? 0 : n.length;
    for (e && i && (r = n[++u]); ++u < i;) r = t(r, n[u], u, n);
    return r;
  }
  function s(n, t, r, e) {
    var u = null == n ? 0 : n.length;
    for (e && u && (r = n[--u]); u--;) r = t(r, n[u], u, n);
    return r;
  }
  function h(n, t) {
    for (var r = -1, e = null == n ? 0 : n.length; ++r < e;) if (t(n[r], r, n)) return !0;
    return !1;
  }
  function p(n) {
    return n.split("");
  }
  function _(n) {
    return n.match($t) || [];
  }
  function v(n, t, r) {
    var e;
    return r(n, function (n, r, u) {
      if (t(n, r, u)) return e = r, !1;
    }), e;
  }
  function g(n, t, r, e) {
    for (var u = n.length, i = r + (e ? 1 : -1); e ? i-- : ++i < u;) if (t(n[i], i, n)) return i;
    return -1;
  }
  function y(n, t, r) {
    return t === t ? Z(n, t, r) : g(n, b, r);
  }
  function d(n, t, r, e) {
    for (var u = r - 1, i = n.length; ++u < i;) if (e(n[u], t)) return u;
    return -1;
  }
  function b(n) {
    return n !== n;
  }
  function w(n, t) {
    var r = null == n ? 0 : n.length;
    return r ? k(n, t) / r : Cn;
  }
  function m(n) {
    return function (t) {
      return null == t ? X : t[n];
    };
  }
  function x(n) {
    return function (t) {
      return null == n ? X : n[t];
    };
  }
  function j(n, t, r, e, u) {
    return u(n, function (n, u, i) {
      r = e ? (e = !1, n) : t(r, n, u, i);
    }), r;
  }
  function A(n, t) {
    var r = n.length;
    for (n.sort(t); r--;) n[r] = n[r].value;
    return n;
  }
  function k(n, t) {
    for (var r, e = -1, u = n.length; ++e < u;) {
      var i = t(n[e]);
      i !== X && (r = r === X ? i : r + i);
    }
    return r;
  }
  function O(n, t) {
    for (var r = -1, e = Array(n); ++r < n;) e[r] = t(r);
    return e;
  }
  function I(n, t) {
    return c(t, function (t) {
      return [t, n[t]];
    });
  }
  function R(n) {
    return n ? n.slice(0, H(n) + 1).replace(Lt, "") : n;
  }
  function z(n) {
    return function (t) {
      return n(t);
    };
  }
  function E(n, t) {
    return c(t, function (t) {
      return n[t];
    });
  }
  function S(n, t) {
    return n.has(t);
  }
  function W(n, t) {
    for (var r = -1, e = n.length; ++r < e && y(t, n[r], 0) > -1;);
    return r;
  }
  function L(n, t) {
    for (var r = n.length; r-- && y(t, n[r], 0) > -1;);
    return r;
  }
  function C(n, t) {
    for (var r = n.length, e = 0; r--;) n[r] === t && ++e;
    return e;
  }
  function U(n) {
    return "\\" + Yr[n];
  }
  function B(n, t) {
    return null == n ? X : n[t];
  }
  function T(n) {
    return Nr.test(n);
  }
  function $(n) {
    return Pr.test(n);
  }
  function D(n) {
    for (var t, r = []; !(t = n.next()).done;) r.push(t.value);
    return r;
  }
  function M(n) {
    var t = -1,
      r = Array(n.size);
    return n.forEach(function (n, e) {
      r[++t] = [e, n];
    }), r;
  }
  function F(n, t) {
    return function (r) {
      return n(t(r));
    };
  }
  function N(n, t) {
    for (var r = -1, e = n.length, u = 0, i = []; ++r < e;) {
      var o = n[r];
      o !== t && o !== cn || (n[r] = cn, i[u++] = r);
    }
    return i;
  }
  function P(n) {
    var t = -1,
      r = Array(n.size);
    return n.forEach(function (n) {
      r[++t] = n;
    }), r;
  }
  function q(n) {
    var t = -1,
      r = Array(n.size);
    return n.forEach(function (n) {
      r[++t] = [n, n];
    }), r;
  }
  function Z(n, t, r) {
    for (var e = r - 1, u = n.length; ++e < u;) if (n[e] === t) return e;
    return -1;
  }
  function K(n, t, r) {
    for (var e = r + 1; e--;) if (n[e] === t) return e;
    return e;
  }
  function V(n) {
    return T(n) ? J(n) : _e(n);
  }
  function G(n) {
    return T(n) ? Y(n) : p(n);
  }
  function H(n) {
    for (var t = n.length; t-- && Ct.test(n.charAt(t)););
    return t;
  }
  function J(n) {
    for (var t = Mr.lastIndex = 0; Mr.test(n);) ++t;
    return t;
  }
  function Y(n) {
    return n.match(Mr) || [];
  }
  function Q(n) {
    return n.match(Fr) || [];
  }
  var X,
    nn = "4.17.21",
    tn = 200,
    rn = "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.",
    en = "Expected a function",
    un = "Invalid `variable` option passed into `_.template`",
    on = "__lodash_hash_undefined__",
    fn = 500,
    cn = "__lodash_placeholder__",
    an = 1,
    ln = 2,
    sn = 4,
    hn = 1,
    pn = 2,
    _n = 1,
    vn = 2,
    gn = 4,
    yn = 8,
    dn = 16,
    bn = 32,
    wn = 64,
    mn = 128,
    xn = 256,
    jn = 512,
    An = 30,
    kn = "...",
    On = 800,
    In = 16,
    Rn = 1,
    zn = 2,
    En = 3,
    Sn = 1 / 0,
    Wn = 9007199254740991,
    Ln = 1.7976931348623157e308,
    Cn = NaN,
    Un = 4294967295,
    Bn = Un - 1,
    Tn = Un >>> 1,
    $n = [["ary", mn], ["bind", _n], ["bindKey", vn], ["curry", yn], ["curryRight", dn], ["flip", jn], ["partial", bn], ["partialRight", wn], ["rearg", xn]],
    Dn = "[object Arguments]",
    Mn = "[object Array]",
    Fn = "[object AsyncFunction]",
    Nn = "[object Boolean]",
    Pn = "[object Date]",
    qn = "[object DOMException]",
    Zn = "[object Error]",
    Kn = "[object Function]",
    Vn = "[object GeneratorFunction]",
    Gn = "[object Map]",
    Hn = "[object Number]",
    Jn = "[object Null]",
    Yn = "[object Object]",
    Qn = "[object Promise]",
    Xn = "[object Proxy]",
    nt = "[object RegExp]",
    tt = "[object Set]",
    rt = "[object String]",
    et = "[object Symbol]",
    ut = "[object Undefined]",
    it = "[object WeakMap]",
    ot = "[object WeakSet]",
    ft = "[object ArrayBuffer]",
    ct = "[object DataView]",
    at = "[object Float32Array]",
    lt = "[object Float64Array]",
    st = "[object Int8Array]",
    ht = "[object Int16Array]",
    pt = "[object Int32Array]",
    _t = "[object Uint8Array]",
    vt = "[object Uint8ClampedArray]",
    gt = "[object Uint16Array]",
    yt = "[object Uint32Array]",
    dt = /\b__p \+= '';/g,
    bt = /\b(__p \+=) '' \+/g,
    wt = /(__e\(.*?\)|\b__t\)) \+\n'';/g,
    mt = /&(?:amp|lt|gt|quot|#39);/g,
    xt = /[&<>"']/g,
    jt = RegExp(mt.source),
    At = RegExp(xt.source),
    kt = /<%-([\s\S]+?)%>/g,
    Ot = /<%([\s\S]+?)%>/g,
    It = /<%=([\s\S]+?)%>/g,
    Rt = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
    zt = /^\w*$/,
    Et = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,
    St = /[\\^$.*+?()[\]{}|]/g,
    Wt = RegExp(St.source),
    Lt = /^\s+/,
    Ct = /\s/,
    Ut = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,
    Bt = /\{\n\/\* \[wrapped with (.+)\] \*/,
    Tt = /,? & /,
    $t = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g,
    Dt = /[()=,{}\[\]\/\s]/,
    Mt = /\\(\\)?/g,
    Ft = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,
    Nt = /\w*$/,
    Pt = /^[-+]0x[0-9a-f]+$/i,
    qt = /^0b[01]+$/i,
    Zt = /^\[object .+?Constructor\]$/,
    Kt = /^0o[0-7]+$/i,
    Vt = /^(?:0|[1-9]\d*)$/,
    Gt = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g,
    Ht = /($^)/,
    Jt = /['\n\r\u2028\u2029\\]/g,
    Yt = "\\ud800-\\udfff",
    Qt = "\\u0300-\\u036f",
    Xt = "\\ufe20-\\ufe2f",
    nr = "\\u20d0-\\u20ff",
    tr = Qt + Xt + nr,
    rr = "\\u2700-\\u27bf",
    er = "a-z\\xdf-\\xf6\\xf8-\\xff",
    ur = "\\xac\\xb1\\xd7\\xf7",
    ir = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf",
    or = "\\u2000-\\u206f",
    fr = " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",
    cr = "A-Z\\xc0-\\xd6\\xd8-\\xde",
    ar = "\\ufe0e\\ufe0f",
    lr = ur + ir + or + fr,
    sr = "['\u2019]",
    hr = "[" + Yt + "]",
    pr = "[" + lr + "]",
    _r = "[" + tr + "]",
    vr = "\\d+",
    gr = "[" + rr + "]",
    yr = "[" + er + "]",
    dr = "[^" + Yt + lr + vr + rr + er + cr + "]",
    br = "\\ud83c[\\udffb-\\udfff]",
    wr = "(?:" + _r + "|" + br + ")",
    mr = "[^" + Yt + "]",
    xr = "(?:\\ud83c[\\udde6-\\uddff]){2}",
    jr = "[\\ud800-\\udbff][\\udc00-\\udfff]",
    Ar = "[" + cr + "]",
    kr = "\\u200d",
    Or = "(?:" + yr + "|" + dr + ")",
    Ir = "(?:" + Ar + "|" + dr + ")",
    Rr = "(?:" + sr + "(?:d|ll|m|re|s|t|ve))?",
    zr = "(?:" + sr + "(?:D|LL|M|RE|S|T|VE))?",
    Er = wr + "?",
    Sr = "[" + ar + "]?",
    Wr = "(?:" + kr + "(?:" + [mr, xr, jr].join("|") + ")" + Sr + Er + ")*",
    Lr = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",
    Cr = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])",
    Ur = Sr + Er + Wr,
    Br = "(?:" + [gr, xr, jr].join("|") + ")" + Ur,
    Tr = "(?:" + [mr + _r + "?", _r, xr, jr, hr].join("|") + ")",
    $r = RegExp(sr, "g"),
    Dr = RegExp(_r, "g"),
    Mr = RegExp(br + "(?=" + br + ")|" + Tr + Ur, "g"),
    Fr = RegExp([Ar + "?" + yr + "+" + Rr + "(?=" + [pr, Ar, "$"].join("|") + ")", Ir + "+" + zr + "(?=" + [pr, Ar + Or, "$"].join("|") + ")", Ar + "?" + Or + "+" + Rr, Ar + "+" + zr, Cr, Lr, vr, Br].join("|"), "g"),
    Nr = RegExp("[" + kr + Yt + tr + ar + "]"),
    Pr = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,
    qr = ["Array", "Buffer", "DataView", "Date", "Error", "Float32Array", "Float64Array", "Function", "Int8Array", "Int16Array", "Int32Array", "Map", "Math", "Object", "Promise", "RegExp", "Set", "String", "Symbol", "TypeError", "Uint8Array", "Uint8ClampedArray", "Uint16Array", "Uint32Array", "WeakMap", "_", "clearTimeout", "isFinite", "parseInt", "setTimeout"],
    Zr = -1,
    Kr = {};
  Kr[at] = Kr[lt] = Kr[st] = Kr[ht] = Kr[pt] = Kr[_t] = Kr[vt] = Kr[gt] = Kr[yt] = !0, Kr[Dn] = Kr[Mn] = Kr[ft] = Kr[Nn] = Kr[ct] = Kr[Pn] = Kr[Zn] = Kr[Kn] = Kr[Gn] = Kr[Hn] = Kr[Yn] = Kr[nt] = Kr[tt] = Kr[rt] = Kr[it] = !1;
  var Vr = {};
  Vr[Dn] = Vr[Mn] = Vr[ft] = Vr[ct] = Vr[Nn] = Vr[Pn] = Vr[at] = Vr[lt] = Vr[st] = Vr[ht] = Vr[pt] = Vr[Gn] = Vr[Hn] = Vr[Yn] = Vr[nt] = Vr[tt] = Vr[rt] = Vr[et] = Vr[_t] = Vr[vt] = Vr[gt] = Vr[yt] = !0, Vr[Zn] = Vr[Kn] = Vr[it] = !1;
  var Gr = {
      "\xc0": "A",
      "\xc1": "A",
      "\xc2": "A",
      "\xc3": "A",
      "\xc4": "A",
      "\xc5": "A",
      "\xe0": "a",
      "\xe1": "a",
      "\xe2": "a",
      "\xe3": "a",
      "\xe4": "a",
      "\xe5": "a",
      "\xc7": "C",
      "\xe7": "c",
      "\xd0": "D",
      "\xf0": "d",
      "\xc8": "E",
      "\xc9": "E",
      "\xca": "E",
      "\xcb": "E",
      "\xe8": "e",
      "\xe9": "e",
      "\xea": "e",
      "\xeb": "e",
      "\xcc": "I",
      "\xcd": "I",
      "\xce": "I",
      "\xcf": "I",
      "\xec": "i",
      "\xed": "i",
      "\xee": "i",
      "\xef": "i",
      "\xd1": "N",
      "\xf1": "n",
      "\xd2": "O",
      "\xd3": "O",
      "\xd4": "O",
      "\xd5": "O",
      "\xd6": "O",
      "\xd8": "O",
      "\xf2": "o",
      "\xf3": "o",
      "\xf4": "o",
      "\xf5": "o",
      "\xf6": "o",
      "\xf8": "o",
      "\xd9": "U",
      "\xda": "U",
      "\xdb": "U",
      "\xdc": "U",
      "\xf9": "u",
      "\xfa": "u",
      "\xfb": "u",
      "\xfc": "u",
      "\xdd": "Y",
      "\xfd": "y",
      "\xff": "y",
      "\xc6": "Ae",
      "\xe6": "ae",
      "\xde": "Th",
      "\xfe": "th",
      "\xdf": "ss",
      "\u0100": "A",
      "\u0102": "A",
      "\u0104": "A",
      "\u0101": "a",
      "\u0103": "a",
      "\u0105": "a",
      "\u0106": "C",
      "\u0108": "C",
      "\u010A": "C",
      "\u010C": "C",
      "\u0107": "c",
      "\u0109": "c",
      "\u010B": "c",
      "\u010D": "c",
      "\u010E": "D",
      "\u0110": "D",
      "\u010F": "d",
      "\u0111": "d",
      "\u0112": "E",
      "\u0114": "E",
      "\u0116": "E",
      "\u0118": "E",
      "\u011A": "E",
      "\u0113": "e",
      "\u0115": "e",
      "\u0117": "e",
      "\u0119": "e",
      "\u011B": "e",
      "\u011C": "G",
      "\u011E": "G",
      "\u0120": "G",
      "\u0122": "G",
      "\u011D": "g",
      "\u011F": "g",
      "\u0121": "g",
      "\u0123": "g",
      "\u0124": "H",
      "\u0126": "H",
      "\u0125": "h",
      "\u0127": "h",
      "\u0128": "I",
      "\u012A": "I",
      "\u012C": "I",
      "\u012E": "I",
      "\u0130": "I",
      "\u0129": "i",
      "\u012B": "i",
      "\u012D": "i",
      "\u012F": "i",
      "\u0131": "i",
      "\u0134": "J",
      "\u0135": "j",
      "\u0136": "K",
      "\u0137": "k",
      "\u0138": "k",
      "\u0139": "L",
      "\u013B": "L",
      "\u013D": "L",
      "\u013F": "L",
      "\u0141": "L",
      "\u013A": "l",
      "\u013C": "l",
      "\u013E": "l",
      "\u0140": "l",
      "\u0142": "l",
      "\u0143": "N",
      "\u0145": "N",
      "\u0147": "N",
      "\u014A": "N",
      "\u0144": "n",
      "\u0146": "n",
      "\u0148": "n",
      "\u014B": "n",
      "\u014C": "O",
      "\u014E": "O",
      "\u0150": "O",
      "\u014D": "o",
      "\u014F": "o",
      "\u0151": "o",
      "\u0154": "R",
      "\u0156": "R",
      "\u0158": "R",
      "\u0155": "r",
      "\u0157": "r",
      "\u0159": "r",
      "\u015A": "S",
      "\u015C": "S",
      "\u015E": "S",
      "\u0160": "S",
      "\u015B": "s",
      "\u015D": "s",
      "\u015F": "s",
      "\u0161": "s",
      "\u0162": "T",
      "\u0164": "T",
      "\u0166": "T",
      "\u0163": "t",
      "\u0165": "t",
      "\u0167": "t",
      "\u0168": "U",
      "\u016A": "U",
      "\u016C": "U",
      "\u016E": "U",
      "\u0170": "U",
      "\u0172": "U",
      "\u0169": "u",
      "\u016B": "u",
      "\u016D": "u",
      "\u016F": "u",
      "\u0171": "u",
      "\u0173": "u",
      "\u0174": "W",
      "\u0175": "w",
      "\u0176": "Y",
      "\u0177": "y",
      "\u0178": "Y",
      "\u0179": "Z",
      "\u017B": "Z",
      "\u017D": "Z",
      "\u017A": "z",
      "\u017C": "z",
      "\u017E": "z",
      "\u0132": "IJ",
      "\u0133": "ij",
      "\u0152": "Oe",
      "\u0153": "oe",
      "\u0149": "'n",
      "\u017F": "s"
    },
    Hr = {
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&#39;"
    },
    Jr = {
      "&amp;": "&",
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&#39;": "'"
    },
    Yr = {
      "\\": "\\",
      "'": "'",
      "\n": "n",
      "\r": "r",
      "\u2028": "u2028",
      "\u2029": "u2029"
    },
    Qr = parseFloat,
    Xr = parseInt,
    ne = "object" == (typeof __webpack_require__.g === "undefined" ? "undefined" : _typeof(__webpack_require__.g)) && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g,
    te = "object" == (typeof self === "undefined" ? "undefined" : _typeof(self)) && self && self.Object === Object && self,
    re = ne || te || Function("return this")(),
    ee = "object" == ( false ? 0 : _typeof(exports)) && exports && !exports.nodeType && exports,
    ue = ee && "object" == ( false ? 0 : _typeof(module)) && module && !module.nodeType && module,
    ie = ue && ue.exports === ee,
    oe = ie && ne.process,
    fe = function () {
      try {
        var n = ue && ue.require && ue.require("util").types;
        return n ? n : oe && oe.binding && oe.binding("util");
      } catch (n) {}
    }(),
    ce = fe && fe.isArrayBuffer,
    ae = fe && fe.isDate,
    le = fe && fe.isMap,
    se = fe && fe.isRegExp,
    he = fe && fe.isSet,
    pe = fe && fe.isTypedArray,
    _e = m("length"),
    ve = x(Gr),
    ge = x(Hr),
    ye = x(Jr),
    de = function p(x) {
      function Z(n) {
        if (cc(n) && !bh(n) && !(n instanceof Ct)) {
          if (n instanceof Y) return n;
          if (bl.call(n, "__wrapped__")) return eo(n);
        }
        return new Y(n);
      }
      function J() {}
      function Y(n, t) {
        this.__wrapped__ = n, this.__actions__ = [], this.__chain__ = !!t, this.__index__ = 0, this.__values__ = X;
      }
      function Ct(n) {
        this.__wrapped__ = n, this.__actions__ = [], this.__dir__ = 1, this.__filtered__ = !1, this.__iteratees__ = [], this.__takeCount__ = Un, this.__views__ = [];
      }
      function $t() {
        var n = new Ct(this.__wrapped__);
        return n.__actions__ = Tu(this.__actions__), n.__dir__ = this.__dir__, n.__filtered__ = this.__filtered__, n.__iteratees__ = Tu(this.__iteratees__), n.__takeCount__ = this.__takeCount__, n.__views__ = Tu(this.__views__), n;
      }
      function Yt() {
        if (this.__filtered__) {
          var n = new Ct(this);
          n.__dir__ = -1, n.__filtered__ = !0;
        } else n = this.clone(), n.__dir__ *= -1;
        return n;
      }
      function Qt() {
        var n = this.__wrapped__.value(),
          t = this.__dir__,
          r = bh(n),
          e = t < 0,
          u = r ? n.length : 0,
          i = Oi(0, u, this.__views__),
          o = i.start,
          f = i.end,
          c = f - o,
          a = e ? f : o - 1,
          l = this.__iteratees__,
          s = l.length,
          h = 0,
          p = Hl(c, this.__takeCount__);
        if (!r || !e && u == c && p == c) return wu(n, this.__actions__);
        var _ = [];
        n: for (; c-- && h < p;) {
          a += t;
          for (var v = -1, g = n[a]; ++v < s;) {
            var y = l[v],
              d = y.iteratee,
              b = y.type,
              w = d(g);
            if (b == zn) g = w;else if (!w) {
              if (b == Rn) continue n;
              break n;
            }
          }
          _[h++] = g;
        }
        return _;
      }
      function Xt(n) {
        var t = -1,
          r = null == n ? 0 : n.length;
        for (this.clear(); ++t < r;) {
          var e = n[t];
          this.set(e[0], e[1]);
        }
      }
      function nr() {
        this.__data__ = is ? is(null) : {}, this.size = 0;
      }
      function tr(n) {
        var t = this.has(n) && delete this.__data__[n];
        return this.size -= t ? 1 : 0, t;
      }
      function rr(n) {
        var t = this.__data__;
        if (is) {
          var r = t[n];
          return r === on ? X : r;
        }
        return bl.call(t, n) ? t[n] : X;
      }
      function er(n) {
        var t = this.__data__;
        return is ? t[n] !== X : bl.call(t, n);
      }
      function ur(n, t) {
        var r = this.__data__;
        return this.size += this.has(n) ? 0 : 1, r[n] = is && t === X ? on : t, this;
      }
      function ir(n) {
        var t = -1,
          r = null == n ? 0 : n.length;
        for (this.clear(); ++t < r;) {
          var e = n[t];
          this.set(e[0], e[1]);
        }
      }
      function or() {
        this.__data__ = [], this.size = 0;
      }
      function fr(n) {
        var t = this.__data__,
          r = Wr(t, n);
        return !(r < 0) && (r == t.length - 1 ? t.pop() : Ll.call(t, r, 1), --this.size, !0);
      }
      function cr(n) {
        var t = this.__data__,
          r = Wr(t, n);
        return r < 0 ? X : t[r][1];
      }
      function ar(n) {
        return Wr(this.__data__, n) > -1;
      }
      function lr(n, t) {
        var r = this.__data__,
          e = Wr(r, n);
        return e < 0 ? (++this.size, r.push([n, t])) : r[e][1] = t, this;
      }
      function sr(n) {
        var t = -1,
          r = null == n ? 0 : n.length;
        for (this.clear(); ++t < r;) {
          var e = n[t];
          this.set(e[0], e[1]);
        }
      }
      function hr() {
        this.size = 0, this.__data__ = {
          hash: new Xt(),
          map: new (ts || ir)(),
          string: new Xt()
        };
      }
      function pr(n) {
        var t = xi(this, n)["delete"](n);
        return this.size -= t ? 1 : 0, t;
      }
      function _r(n) {
        return xi(this, n).get(n);
      }
      function vr(n) {
        return xi(this, n).has(n);
      }
      function gr(n, t) {
        var r = xi(this, n),
          e = r.size;
        return r.set(n, t), this.size += r.size == e ? 0 : 1, this;
      }
      function yr(n) {
        var t = -1,
          r = null == n ? 0 : n.length;
        for (this.__data__ = new sr(); ++t < r;) this.add(n[t]);
      }
      function dr(n) {
        return this.__data__.set(n, on), this;
      }
      function br(n) {
        return this.__data__.has(n);
      }
      function wr(n) {
        this.size = (this.__data__ = new ir(n)).size;
      }
      function mr() {
        this.__data__ = new ir(), this.size = 0;
      }
      function xr(n) {
        var t = this.__data__,
          r = t["delete"](n);
        return this.size = t.size, r;
      }
      function jr(n) {
        return this.__data__.get(n);
      }
      function Ar(n) {
        return this.__data__.has(n);
      }
      function kr(n, t) {
        var r = this.__data__;
        if (r instanceof ir) {
          var e = r.__data__;
          if (!ts || e.length < tn - 1) return e.push([n, t]), this.size = ++r.size, this;
          r = this.__data__ = new sr(e);
        }
        return r.set(n, t), this.size = r.size, this;
      }
      function Or(n, t) {
        var r = bh(n),
          e = !r && dh(n),
          u = !r && !e && mh(n),
          i = !r && !e && !u && Oh(n),
          o = r || e || u || i,
          f = o ? O(n.length, hl) : [],
          c = f.length;
        for (var a in n) !t && !bl.call(n, a) || o && ("length" == a || u && ("offset" == a || "parent" == a) || i && ("buffer" == a || "byteLength" == a || "byteOffset" == a) || Ci(a, c)) || f.push(a);
        return f;
      }
      function Ir(n) {
        var t = n.length;
        return t ? n[tu(0, t - 1)] : X;
      }
      function Rr(n, t) {
        return Xi(Tu(n), Mr(t, 0, n.length));
      }
      function zr(n) {
        return Xi(Tu(n));
      }
      function Er(n, t, r) {
        (r === X || Gf(n[t], r)) && (r !== X || t in n) || Br(n, t, r);
      }
      function Sr(n, t, r) {
        var e = n[t];
        bl.call(n, t) && Gf(e, r) && (r !== X || t in n) || Br(n, t, r);
      }
      function Wr(n, t) {
        for (var r = n.length; r--;) if (Gf(n[r][0], t)) return r;
        return -1;
      }
      function Lr(n, t, r, e) {
        return ys(n, function (n, u, i) {
          t(e, n, r(n), i);
        }), e;
      }
      function Cr(n, t) {
        return n && $u(t, Pc(t), n);
      }
      function Ur(n, t) {
        return n && $u(t, qc(t), n);
      }
      function Br(n, t, r) {
        "__proto__" == t && Tl ? Tl(n, t, {
          configurable: !0,
          enumerable: !0,
          value: r,
          writable: !0
        }) : n[t] = r;
      }
      function Tr(n, t) {
        for (var r = -1, e = t.length, u = il(e), i = null == n; ++r < e;) u[r] = i ? X : Mc(n, t[r]);
        return u;
      }
      function Mr(n, t, r) {
        return n === n && (r !== X && (n = n <= r ? n : r), t !== X && (n = n >= t ? n : t)), n;
      }
      function Fr(n, t, e, u, i, o) {
        var f,
          c = t & an,
          a = t & ln,
          l = t & sn;
        if (e && (f = i ? e(n, u, i, o) : e(n)), f !== X) return f;
        if (!fc(n)) return n;
        var s = bh(n);
        if (s) {
          if (f = zi(n), !c) return Tu(n, f);
        } else {
          var h = zs(n),
            p = h == Kn || h == Vn;
          if (mh(n)) return Iu(n, c);
          if (h == Yn || h == Dn || p && !i) {
            if (f = a || p ? {} : Ei(n), !c) return a ? Mu(n, Ur(f, n)) : Du(n, Cr(f, n));
          } else {
            if (!Vr[h]) return i ? n : {};
            f = Si(n, h, c);
          }
        }
        o || (o = new wr());
        var _ = o.get(n);
        if (_) return _;
        o.set(n, f), kh(n) ? n.forEach(function (r) {
          f.add(Fr(r, t, e, r, n, o));
        }) : jh(n) && n.forEach(function (r, u) {
          f.set(u, Fr(r, t, e, u, n, o));
        });
        var v = l ? a ? di : yi : a ? qc : Pc,
          g = s ? X : v(n);
        return r(g || n, function (r, u) {
          g && (u = r, r = n[u]), Sr(f, u, Fr(r, t, e, u, n, o));
        }), f;
      }
      function Nr(n) {
        var t = Pc(n);
        return function (r) {
          return Pr(r, n, t);
        };
      }
      function Pr(n, t, r) {
        var e = r.length;
        if (null == n) return !e;
        for (n = ll(n); e--;) {
          var u = r[e],
            i = t[u],
            o = n[u];
          if (o === X && !(u in n) || !i(o)) return !1;
        }
        return !0;
      }
      function Gr(n, t, r) {
        if ("function" != typeof n) throw new pl(en);
        return Ws(function () {
          n.apply(X, r);
        }, t);
      }
      function Hr(n, t, r, e) {
        var u = -1,
          i = o,
          a = !0,
          l = n.length,
          s = [],
          h = t.length;
        if (!l) return s;
        r && (t = c(t, z(r))), e ? (i = f, a = !1) : t.length >= tn && (i = S, a = !1, t = new yr(t));
        n: for (; ++u < l;) {
          var p = n[u],
            _ = null == r ? p : r(p);
          if (p = e || 0 !== p ? p : 0, a && _ === _) {
            for (var v = h; v--;) if (t[v] === _) continue n;
            s.push(p);
          } else i(t, _, e) || s.push(p);
        }
        return s;
      }
      function Jr(n, t) {
        var r = !0;
        return ys(n, function (n, e, u) {
          return r = !!t(n, e, u);
        }), r;
      }
      function Yr(n, t, r) {
        for (var e = -1, u = n.length; ++e < u;) {
          var i = n[e],
            o = t(i);
          if (null != o && (f === X ? o === o && !bc(o) : r(o, f))) var f = o,
            c = i;
        }
        return c;
      }
      function ne(n, t, r, e) {
        var u = n.length;
        for (r = kc(r), r < 0 && (r = -r > u ? 0 : u + r), e = e === X || e > u ? u : kc(e), e < 0 && (e += u), e = r > e ? 0 : Oc(e); r < e;) n[r++] = t;
        return n;
      }
      function te(n, t) {
        var r = [];
        return ys(n, function (n, e, u) {
          t(n, e, u) && r.push(n);
        }), r;
      }
      function ee(n, t, r, e, u) {
        var i = -1,
          o = n.length;
        for (r || (r = Li), u || (u = []); ++i < o;) {
          var f = n[i];
          t > 0 && r(f) ? t > 1 ? ee(f, t - 1, r, e, u) : a(u, f) : e || (u[u.length] = f);
        }
        return u;
      }
      function ue(n, t) {
        return n && bs(n, t, Pc);
      }
      function oe(n, t) {
        return n && ws(n, t, Pc);
      }
      function fe(n, t) {
        return i(t, function (t) {
          return uc(n[t]);
        });
      }
      function _e(n, t) {
        t = ku(t, n);
        for (var r = 0, e = t.length; null != n && r < e;) n = n[no(t[r++])];
        return r && r == e ? n : X;
      }
      function de(n, t, r) {
        var e = t(n);
        return bh(n) ? e : a(e, r(n));
      }
      function we(n) {
        return null == n ? n === X ? ut : Jn : Bl && Bl in ll(n) ? ki(n) : Ki(n);
      }
      function me(n, t) {
        return n > t;
      }
      function xe(n, t) {
        return null != n && bl.call(n, t);
      }
      function je(n, t) {
        return null != n && t in ll(n);
      }
      function Ae(n, t, r) {
        return n >= Hl(t, r) && n < Gl(t, r);
      }
      function ke(n, t, r) {
        for (var e = r ? f : o, u = n[0].length, i = n.length, a = i, l = il(i), s = 1 / 0, h = []; a--;) {
          var p = n[a];
          a && t && (p = c(p, z(t))), s = Hl(p.length, s), l[a] = !r && (t || u >= 120 && p.length >= 120) ? new yr(a && p) : X;
        }
        p = n[0];
        var _ = -1,
          v = l[0];
        n: for (; ++_ < u && h.length < s;) {
          var g = p[_],
            y = t ? t(g) : g;
          if (g = r || 0 !== g ? g : 0, !(v ? S(v, y) : e(h, y, r))) {
            for (a = i; --a;) {
              var d = l[a];
              if (!(d ? S(d, y) : e(n[a], y, r))) continue n;
            }
            v && v.push(y), h.push(g);
          }
        }
        return h;
      }
      function Oe(n, t, r, e) {
        return ue(n, function (n, u, i) {
          t(e, r(n), u, i);
        }), e;
      }
      function Ie(t, r, e) {
        r = ku(r, t), t = Gi(t, r);
        var u = null == t ? t : t[no(jo(r))];
        return null == u ? X : n(u, t, e);
      }
      function Re(n) {
        return cc(n) && we(n) == Dn;
      }
      function ze(n) {
        return cc(n) && we(n) == ft;
      }
      function Ee(n) {
        return cc(n) && we(n) == Pn;
      }
      function Se(n, t, r, e, u) {
        return n === t || (null == n || null == t || !cc(n) && !cc(t) ? n !== n && t !== t : We(n, t, r, e, Se, u));
      }
      function We(n, t, r, e, u, i) {
        var o = bh(n),
          f = bh(t),
          c = o ? Mn : zs(n),
          a = f ? Mn : zs(t);
        c = c == Dn ? Yn : c, a = a == Dn ? Yn : a;
        var l = c == Yn,
          s = a == Yn,
          h = c == a;
        if (h && mh(n)) {
          if (!mh(t)) return !1;
          o = !0, l = !1;
        }
        if (h && !l) return i || (i = new wr()), o || Oh(n) ? pi(n, t, r, e, u, i) : _i(n, t, c, r, e, u, i);
        if (!(r & hn)) {
          var p = l && bl.call(n, "__wrapped__"),
            _ = s && bl.call(t, "__wrapped__");
          if (p || _) {
            var v = p ? n.value() : n,
              g = _ ? t.value() : t;
            return i || (i = new wr()), u(v, g, r, e, i);
          }
        }
        return !!h && (i || (i = new wr()), vi(n, t, r, e, u, i));
      }
      function Le(n) {
        return cc(n) && zs(n) == Gn;
      }
      function Ce(n, t, r, e) {
        var u = r.length,
          i = u,
          o = !e;
        if (null == n) return !i;
        for (n = ll(n); u--;) {
          var f = r[u];
          if (o && f[2] ? f[1] !== n[f[0]] : !(f[0] in n)) return !1;
        }
        for (; ++u < i;) {
          f = r[u];
          var c = f[0],
            a = n[c],
            l = f[1];
          if (o && f[2]) {
            if (a === X && !(c in n)) return !1;
          } else {
            var s = new wr();
            if (e) var h = e(a, l, c, n, t, s);
            if (!(h === X ? Se(l, a, hn | pn, e, s) : h)) return !1;
          }
        }
        return !0;
      }
      function Ue(n) {
        return !(!fc(n) || Di(n)) && (uc(n) ? kl : Zt).test(to(n));
      }
      function Be(n) {
        return cc(n) && we(n) == nt;
      }
      function Te(n) {
        return cc(n) && zs(n) == tt;
      }
      function $e(n) {
        return cc(n) && oc(n.length) && !!Kr[we(n)];
      }
      function De(n) {
        return "function" == typeof n ? n : null == n ? La : "object" == _typeof(n) ? bh(n) ? Ze(n[0], n[1]) : qe(n) : Fa(n);
      }
      function Me(n) {
        if (!Mi(n)) return Vl(n);
        var t = [];
        for (var r in ll(n)) bl.call(n, r) && "constructor" != r && t.push(r);
        return t;
      }
      function Fe(n) {
        if (!fc(n)) return Zi(n);
        var t = Mi(n),
          r = [];
        for (var e in n) ("constructor" != e || !t && bl.call(n, e)) && r.push(e);
        return r;
      }
      function Ne(n, t) {
        return n < t;
      }
      function Pe(n, t) {
        var r = -1,
          e = Hf(n) ? il(n.length) : [];
        return ys(n, function (n, u, i) {
          e[++r] = t(n, u, i);
        }), e;
      }
      function qe(n) {
        var t = ji(n);
        return 1 == t.length && t[0][2] ? Ni(t[0][0], t[0][1]) : function (r) {
          return r === n || Ce(r, n, t);
        };
      }
      function Ze(n, t) {
        return Bi(n) && Fi(t) ? Ni(no(n), t) : function (r) {
          var e = Mc(r, n);
          return e === X && e === t ? Nc(r, n) : Se(t, e, hn | pn);
        };
      }
      function Ke(n, t, r, e, u) {
        n !== t && bs(t, function (i, o) {
          if (u || (u = new wr()), fc(i)) Ve(n, t, o, r, Ke, e, u);else {
            var f = e ? e(Ji(n, o), i, o + "", n, t, u) : X;
            f === X && (f = i), Er(n, o, f);
          }
        }, qc);
      }
      function Ve(n, t, r, e, u, i, o) {
        var f = Ji(n, r),
          c = Ji(t, r),
          a = o.get(c);
        if (a) return Er(n, r, a), X;
        var l = i ? i(f, c, r + "", n, t, o) : X,
          s = l === X;
        if (s) {
          var h = bh(c),
            p = !h && mh(c),
            _ = !h && !p && Oh(c);
          l = c, h || p || _ ? bh(f) ? l = f : Jf(f) ? l = Tu(f) : p ? (s = !1, l = Iu(c, !0)) : _ ? (s = !1, l = Wu(c, !0)) : l = [] : gc(c) || dh(c) ? (l = f, dh(f) ? l = Rc(f) : fc(f) && !uc(f) || (l = Ei(c))) : s = !1;
        }
        s && (o.set(c, l), u(l, c, e, i, o), o["delete"](c)), Er(n, r, l);
      }
      function Ge(n, t) {
        var r = n.length;
        if (r) return t += t < 0 ? r : 0, Ci(t, r) ? n[t] : X;
      }
      function He(n, t, r) {
        t = t.length ? c(t, function (n) {
          return bh(n) ? function (t) {
            return _e(t, 1 === n.length ? n[0] : n);
          } : n;
        }) : [La];
        var e = -1;
        return t = c(t, z(mi())), A(Pe(n, function (n, r, u) {
          return {
            criteria: c(t, function (t) {
              return t(n);
            }),
            index: ++e,
            value: n
          };
        }), function (n, t) {
          return Cu(n, t, r);
        });
      }
      function Je(n, t) {
        return Ye(n, t, function (t, r) {
          return Nc(n, r);
        });
      }
      function Ye(n, t, r) {
        for (var e = -1, u = t.length, i = {}; ++e < u;) {
          var o = t[e],
            f = _e(n, o);
          r(f, o) && fu(i, ku(o, n), f);
        }
        return i;
      }
      function Qe(n) {
        return function (t) {
          return _e(t, n);
        };
      }
      function Xe(n, t, r, e) {
        var u = e ? d : y,
          i = -1,
          o = t.length,
          f = n;
        for (n === t && (t = Tu(t)), r && (f = c(n, z(r))); ++i < o;) for (var a = 0, l = t[i], s = r ? r(l) : l; (a = u(f, s, a, e)) > -1;) f !== n && Ll.call(f, a, 1), Ll.call(n, a, 1);
        return n;
      }
      function nu(n, t) {
        for (var r = n ? t.length : 0, e = r - 1; r--;) {
          var u = t[r];
          if (r == e || u !== i) {
            var i = u;
            Ci(u) ? Ll.call(n, u, 1) : yu(n, u);
          }
        }
        return n;
      }
      function tu(n, t) {
        return n + Nl(Ql() * (t - n + 1));
      }
      function ru(n, t, r, e) {
        for (var u = -1, i = Gl(Fl((t - n) / (r || 1)), 0), o = il(i); i--;) o[e ? i : ++u] = n, n += r;
        return o;
      }
      function eu(n, t) {
        var r = "";
        if (!n || t < 1 || t > Wn) return r;
        do t % 2 && (r += n), t = Nl(t / 2), t && (n += n); while (t);
        return r;
      }
      function uu(n, t) {
        return Ls(Vi(n, t, La), n + "");
      }
      function iu(n) {
        return Ir(ra(n));
      }
      function ou(n, t) {
        var r = ra(n);
        return Xi(r, Mr(t, 0, r.length));
      }
      function fu(n, t, r, e) {
        if (!fc(n)) return n;
        t = ku(t, n);
        for (var u = -1, i = t.length, o = i - 1, f = n; null != f && ++u < i;) {
          var c = no(t[u]),
            a = r;
          if ("__proto__" === c || "constructor" === c || "prototype" === c) return n;
          if (u != o) {
            var l = f[c];
            a = e ? e(l, c, f) : X, a === X && (a = fc(l) ? l : Ci(t[u + 1]) ? [] : {});
          }
          Sr(f, c, a), f = f[c];
        }
        return n;
      }
      function cu(n) {
        return Xi(ra(n));
      }
      function au(n, t, r) {
        var e = -1,
          u = n.length;
        t < 0 && (t = -t > u ? 0 : u + t), r = r > u ? u : r, r < 0 && (r += u), u = t > r ? 0 : r - t >>> 0, t >>>= 0;
        for (var i = il(u); ++e < u;) i[e] = n[e + t];
        return i;
      }
      function lu(n, t) {
        var r;
        return ys(n, function (n, e, u) {
          return r = t(n, e, u), !r;
        }), !!r;
      }
      function su(n, t, r) {
        var e = 0,
          u = null == n ? e : n.length;
        if ("number" == typeof t && t === t && u <= Tn) {
          for (; e < u;) {
            var i = e + u >>> 1,
              o = n[i];
            null !== o && !bc(o) && (r ? o <= t : o < t) ? e = i + 1 : u = i;
          }
          return u;
        }
        return hu(n, t, La, r);
      }
      function hu(n, t, r, e) {
        var u = 0,
          i = null == n ? 0 : n.length;
        if (0 === i) return 0;
        t = r(t);
        for (var o = t !== t, f = null === t, c = bc(t), a = t === X; u < i;) {
          var l = Nl((u + i) / 2),
            s = r(n[l]),
            h = s !== X,
            p = null === s,
            _ = s === s,
            v = bc(s);
          if (o) var g = e || _;else g = a ? _ && (e || h) : f ? _ && h && (e || !p) : c ? _ && h && !p && (e || !v) : !p && !v && (e ? s <= t : s < t);
          g ? u = l + 1 : i = l;
        }
        return Hl(i, Bn);
      }
      function pu(n, t) {
        for (var r = -1, e = n.length, u = 0, i = []; ++r < e;) {
          var o = n[r],
            f = t ? t(o) : o;
          if (!r || !Gf(f, c)) {
            var c = f;
            i[u++] = 0 === o ? 0 : o;
          }
        }
        return i;
      }
      function _u(n) {
        return "number" == typeof n ? n : bc(n) ? Cn : +n;
      }
      function vu(n) {
        if ("string" == typeof n) return n;
        if (bh(n)) return c(n, vu) + "";
        if (bc(n)) return vs ? vs.call(n) : "";
        var t = n + "";
        return "0" == t && 1 / n == -Sn ? "-0" : t;
      }
      function gu(n, t, r) {
        var e = -1,
          u = o,
          i = n.length,
          c = !0,
          a = [],
          l = a;
        if (r) c = !1, u = f;else if (i >= tn) {
          var s = t ? null : ks(n);
          if (s) return P(s);
          c = !1, u = S, l = new yr();
        } else l = t ? [] : a;
        n: for (; ++e < i;) {
          var h = n[e],
            p = t ? t(h) : h;
          if (h = r || 0 !== h ? h : 0, c && p === p) {
            for (var _ = l.length; _--;) if (l[_] === p) continue n;
            t && l.push(p), a.push(h);
          } else u(l, p, r) || (l !== a && l.push(p), a.push(h));
        }
        return a;
      }
      function yu(n, t) {
        return t = ku(t, n), n = Gi(n, t), null == n || delete n[no(jo(t))];
      }
      function du(n, t, r, e) {
        return fu(n, t, r(_e(n, t)), e);
      }
      function bu(n, t, r, e) {
        for (var u = n.length, i = e ? u : -1; (e ? i-- : ++i < u) && t(n[i], i, n););
        return r ? au(n, e ? 0 : i, e ? i + 1 : u) : au(n, e ? i + 1 : 0, e ? u : i);
      }
      function wu(n, t) {
        var r = n;
        return r instanceof Ct && (r = r.value()), l(t, function (n, t) {
          return t.func.apply(t.thisArg, a([n], t.args));
        }, r);
      }
      function mu(n, t, r) {
        var e = n.length;
        if (e < 2) return e ? gu(n[0]) : [];
        for (var u = -1, i = il(e); ++u < e;) for (var o = n[u], f = -1; ++f < e;) f != u && (i[u] = Hr(i[u] || o, n[f], t, r));
        return gu(ee(i, 1), t, r);
      }
      function xu(n, t, r) {
        for (var e = -1, u = n.length, i = t.length, o = {}; ++e < u;) {
          r(o, n[e], e < i ? t[e] : X);
        }
        return o;
      }
      function ju(n) {
        return Jf(n) ? n : [];
      }
      function Au(n) {
        return "function" == typeof n ? n : La;
      }
      function ku(n, t) {
        return bh(n) ? n : Bi(n, t) ? [n] : Cs(Ec(n));
      }
      function Ou(n, t, r) {
        var e = n.length;
        return r = r === X ? e : r, !t && r >= e ? n : au(n, t, r);
      }
      function Iu(n, t) {
        if (t) return n.slice();
        var r = n.length,
          e = zl ? zl(r) : new n.constructor(r);
        return n.copy(e), e;
      }
      function Ru(n) {
        var t = new n.constructor(n.byteLength);
        return new Rl(t).set(new Rl(n)), t;
      }
      function zu(n, t) {
        return new n.constructor(t ? Ru(n.buffer) : n.buffer, n.byteOffset, n.byteLength);
      }
      function Eu(n) {
        var t = new n.constructor(n.source, Nt.exec(n));
        return t.lastIndex = n.lastIndex, t;
      }
      function Su(n) {
        return _s ? ll(_s.call(n)) : {};
      }
      function Wu(n, t) {
        return new n.constructor(t ? Ru(n.buffer) : n.buffer, n.byteOffset, n.length);
      }
      function Lu(n, t) {
        if (n !== t) {
          var r = n !== X,
            e = null === n,
            u = n === n,
            i = bc(n),
            o = t !== X,
            f = null === t,
            c = t === t,
            a = bc(t);
          if (!f && !a && !i && n > t || i && o && c && !f && !a || e && o && c || !r && c || !u) return 1;
          if (!e && !i && !a && n < t || a && r && u && !e && !i || f && r && u || !o && u || !c) return -1;
        }
        return 0;
      }
      function Cu(n, t, r) {
        for (var e = -1, u = n.criteria, i = t.criteria, o = u.length, f = r.length; ++e < o;) {
          var c = Lu(u[e], i[e]);
          if (c) {
            if (e >= f) return c;
            return c * ("desc" == r[e] ? -1 : 1);
          }
        }
        return n.index - t.index;
      }
      function Uu(n, t, r, e) {
        for (var u = -1, i = n.length, o = r.length, f = -1, c = t.length, a = Gl(i - o, 0), l = il(c + a), s = !e; ++f < c;) l[f] = t[f];
        for (; ++u < o;) (s || u < i) && (l[r[u]] = n[u]);
        for (; a--;) l[f++] = n[u++];
        return l;
      }
      function Bu(n, t, r, e) {
        for (var u = -1, i = n.length, o = -1, f = r.length, c = -1, a = t.length, l = Gl(i - f, 0), s = il(l + a), h = !e; ++u < l;) s[u] = n[u];
        for (var p = u; ++c < a;) s[p + c] = t[c];
        for (; ++o < f;) (h || u < i) && (s[p + r[o]] = n[u++]);
        return s;
      }
      function Tu(n, t) {
        var r = -1,
          e = n.length;
        for (t || (t = il(e)); ++r < e;) t[r] = n[r];
        return t;
      }
      function $u(n, t, r, e) {
        var u = !r;
        r || (r = {});
        for (var i = -1, o = t.length; ++i < o;) {
          var f = t[i],
            c = e ? e(r[f], n[f], f, r, n) : X;
          c === X && (c = n[f]), u ? Br(r, f, c) : Sr(r, f, c);
        }
        return r;
      }
      function Du(n, t) {
        return $u(n, Is(n), t);
      }
      function Mu(n, t) {
        return $u(n, Rs(n), t);
      }
      function Fu(n, r) {
        return function (e, u) {
          var i = bh(e) ? t : Lr,
            o = r ? r() : {};
          return i(e, n, mi(u, 2), o);
        };
      }
      function Nu(n) {
        return uu(function (t, r) {
          var e = -1,
            u = r.length,
            i = u > 1 ? r[u - 1] : X,
            o = u > 2 ? r[2] : X;
          for (i = n.length > 3 && "function" == typeof i ? (u--, i) : X, o && Ui(r[0], r[1], o) && (i = u < 3 ? X : i, u = 1), t = ll(t); ++e < u;) {
            var f = r[e];
            f && n(t, f, e, i);
          }
          return t;
        });
      }
      function Pu(n, t) {
        return function (r, e) {
          if (null == r) return r;
          if (!Hf(r)) return n(r, e);
          for (var u = r.length, i = t ? u : -1, o = ll(r); (t ? i-- : ++i < u) && e(o[i], i, o) !== !1;);
          return r;
        };
      }
      function qu(n) {
        return function (t, r, e) {
          for (var u = -1, i = ll(t), o = e(t), f = o.length; f--;) {
            var c = o[n ? f : ++u];
            if (r(i[c], c, i) === !1) break;
          }
          return t;
        };
      }
      function Zu(n, t, r) {
        function e() {
          return (this && this !== re && this instanceof e ? i : n).apply(u ? r : this, arguments);
        }
        var u = t & _n,
          i = Gu(n);
        return e;
      }
      function Ku(n) {
        return function (t) {
          t = Ec(t);
          var r = T(t) ? G(t) : X,
            e = r ? r[0] : t.charAt(0),
            u = r ? Ou(r, 1).join("") : t.slice(1);
          return e[n]() + u;
        };
      }
      function Vu(n) {
        return function (t) {
          return l(Ra(ca(t).replace($r, "")), n, "");
        };
      }
      function Gu(n) {
        return function () {
          var t = arguments;
          switch (t.length) {
            case 0:
              return new n();
            case 1:
              return new n(t[0]);
            case 2:
              return new n(t[0], t[1]);
            case 3:
              return new n(t[0], t[1], t[2]);
            case 4:
              return new n(t[0], t[1], t[2], t[3]);
            case 5:
              return new n(t[0], t[1], t[2], t[3], t[4]);
            case 6:
              return new n(t[0], t[1], t[2], t[3], t[4], t[5]);
            case 7:
              return new n(t[0], t[1], t[2], t[3], t[4], t[5], t[6]);
          }
          var r = gs(n.prototype),
            e = n.apply(r, t);
          return fc(e) ? e : r;
        };
      }
      function Hu(t, r, e) {
        function u() {
          for (var o = arguments.length, f = il(o), c = o, a = wi(u); c--;) f[c] = arguments[c];
          var l = o < 3 && f[0] !== a && f[o - 1] !== a ? [] : N(f, a);
          return o -= l.length, o < e ? oi(t, r, Qu, u.placeholder, X, f, l, X, X, e - o) : n(this && this !== re && this instanceof u ? i : t, this, f);
        }
        var i = Gu(t);
        return u;
      }
      function Ju(n) {
        return function (t, r, e) {
          var u = ll(t);
          if (!Hf(t)) {
            var i = mi(r, 3);
            t = Pc(t), r = function r(n) {
              return i(u[n], n, u);
            };
          }
          var o = n(t, r, e);
          return o > -1 ? u[i ? t[o] : o] : X;
        };
      }
      function Yu(n) {
        return gi(function (t) {
          var r = t.length,
            e = r,
            u = Y.prototype.thru;
          for (n && t.reverse(); e--;) {
            var i = t[e];
            if ("function" != typeof i) throw new pl(en);
            if (u && !o && "wrapper" == bi(i)) var o = new Y([], !0);
          }
          for (e = o ? e : r; ++e < r;) {
            i = t[e];
            var f = bi(i),
              c = "wrapper" == f ? Os(i) : X;
            o = c && $i(c[0]) && c[1] == (mn | yn | bn | xn) && !c[4].length && 1 == c[9] ? o[bi(c[0])].apply(o, c[3]) : 1 == i.length && $i(i) ? o[f]() : o.thru(i);
          }
          return function () {
            var n = arguments,
              e = n[0];
            if (o && 1 == n.length && bh(e)) return o.plant(e).value();
            for (var u = 0, i = r ? t[u].apply(this, n) : e; ++u < r;) i = t[u].call(this, i);
            return i;
          };
        });
      }
      function Qu(n, t, r, e, u, i, o, f, c, a) {
        function l() {
          for (var y = arguments.length, d = il(y), b = y; b--;) d[b] = arguments[b];
          if (_) var w = wi(l),
            m = C(d, w);
          if (e && (d = Uu(d, e, u, _)), i && (d = Bu(d, i, o, _)), y -= m, _ && y < a) {
            return oi(n, t, Qu, l.placeholder, r, d, N(d, w), f, c, a - y);
          }
          var x = h ? r : this,
            j = p ? x[n] : n;
          return y = d.length, f ? d = Hi(d, f) : v && y > 1 && d.reverse(), s && c < y && (d.length = c), this && this !== re && this instanceof l && (j = g || Gu(j)), j.apply(x, d);
        }
        var s = t & mn,
          h = t & _n,
          p = t & vn,
          _ = t & (yn | dn),
          v = t & jn,
          g = p ? X : Gu(n);
        return l;
      }
      function Xu(n, t) {
        return function (r, e) {
          return Oe(r, n, t(e), {});
        };
      }
      function ni(n, t) {
        return function (r, e) {
          var u;
          if (r === X && e === X) return t;
          if (r !== X && (u = r), e !== X) {
            if (u === X) return e;
            "string" == typeof r || "string" == typeof e ? (r = vu(r), e = vu(e)) : (r = _u(r), e = _u(e)), u = n(r, e);
          }
          return u;
        };
      }
      function ti(t) {
        return gi(function (r) {
          return r = c(r, z(mi())), uu(function (e) {
            var u = this;
            return t(r, function (t) {
              return n(t, u, e);
            });
          });
        });
      }
      function ri(n, t) {
        t = t === X ? " " : vu(t);
        var r = t.length;
        if (r < 2) return r ? eu(t, n) : t;
        var e = eu(t, Fl(n / V(t)));
        return T(t) ? Ou(G(e), 0, n).join("") : e.slice(0, n);
      }
      function ei(t, r, e, u) {
        function i() {
          for (var r = -1, c = arguments.length, a = -1, l = u.length, s = il(l + c), h = this && this !== re && this instanceof i ? f : t; ++a < l;) s[a] = u[a];
          for (; c--;) s[a++] = arguments[++r];
          return n(h, o ? e : this, s);
        }
        var o = r & _n,
          f = Gu(t);
        return i;
      }
      function ui(n) {
        return function (t, r, e) {
          return e && "number" != typeof e && Ui(t, r, e) && (r = e = X), t = Ac(t), r === X ? (r = t, t = 0) : r = Ac(r), e = e === X ? t < r ? 1 : -1 : Ac(e), ru(t, r, e, n);
        };
      }
      function ii(n) {
        return function (t, r) {
          return "string" == typeof t && "string" == typeof r || (t = Ic(t), r = Ic(r)), n(t, r);
        };
      }
      function oi(n, t, r, e, u, i, o, f, c, a) {
        var l = t & yn,
          s = l ? o : X,
          h = l ? X : o,
          p = l ? i : X,
          _ = l ? X : i;
        t |= l ? bn : wn, t &= ~(l ? wn : bn), t & gn || (t &= ~(_n | vn));
        var v = [n, t, u, p, s, _, h, f, c, a],
          g = r.apply(X, v);
        return $i(n) && Ss(g, v), g.placeholder = e, Yi(g, n, t);
      }
      function fi(n) {
        var t = al[n];
        return function (n, r) {
          if (n = Ic(n), r = null == r ? 0 : Hl(kc(r), 292), r && Zl(n)) {
            var e = (Ec(n) + "e").split("e");
            return e = (Ec(t(e[0] + "e" + (+e[1] + r))) + "e").split("e"), +(e[0] + "e" + (+e[1] - r));
          }
          return t(n);
        };
      }
      function ci(n) {
        return function (t) {
          var r = zs(t);
          return r == Gn ? M(t) : r == tt ? q(t) : I(t, n(t));
        };
      }
      function ai(n, t, r, e, u, i, o, f) {
        var c = t & vn;
        if (!c && "function" != typeof n) throw new pl(en);
        var a = e ? e.length : 0;
        if (a || (t &= ~(bn | wn), e = u = X), o = o === X ? o : Gl(kc(o), 0), f = f === X ? f : kc(f), a -= u ? u.length : 0, t & wn) {
          var l = e,
            s = u;
          e = u = X;
        }
        var h = c ? X : Os(n),
          p = [n, t, r, e, u, l, s, i, o, f];
        if (h && qi(p, h), n = p[0], t = p[1], r = p[2], e = p[3], u = p[4], f = p[9] = p[9] === X ? c ? 0 : n.length : Gl(p[9] - a, 0), !f && t & (yn | dn) && (t &= ~(yn | dn)), t && t != _n) _ = t == yn || t == dn ? Hu(n, t, f) : t != bn && t != (_n | bn) || u.length ? Qu.apply(X, p) : ei(n, t, r, e);else var _ = Zu(n, t, r);
        return Yi((h ? ms : Ss)(_, p), n, t);
      }
      function li(n, t, r, e) {
        return n === X || Gf(n, gl[r]) && !bl.call(e, r) ? t : n;
      }
      function si(n, t, r, e, u, i) {
        return fc(n) && fc(t) && (i.set(t, n), Ke(n, t, X, si, i), i["delete"](t)), n;
      }
      function hi(n) {
        return gc(n) ? X : n;
      }
      function pi(n, t, r, e, u, i) {
        var o = r & hn,
          f = n.length,
          c = t.length;
        if (f != c && !(o && c > f)) return !1;
        var a = i.get(n),
          l = i.get(t);
        if (a && l) return a == t && l == n;
        var s = -1,
          p = !0,
          _ = r & pn ? new yr() : X;
        for (i.set(n, t), i.set(t, n); ++s < f;) {
          var v = n[s],
            g = t[s];
          if (e) var y = o ? e(g, v, s, t, n, i) : e(v, g, s, n, t, i);
          if (y !== X) {
            if (y) continue;
            p = !1;
            break;
          }
          if (_) {
            if (!h(t, function (n, t) {
              if (!S(_, t) && (v === n || u(v, n, r, e, i))) return _.push(t);
            })) {
              p = !1;
              break;
            }
          } else if (v !== g && !u(v, g, r, e, i)) {
            p = !1;
            break;
          }
        }
        return i["delete"](n), i["delete"](t), p;
      }
      function _i(n, t, r, e, u, i, o) {
        switch (r) {
          case ct:
            if (n.byteLength != t.byteLength || n.byteOffset != t.byteOffset) return !1;
            n = n.buffer, t = t.buffer;
          case ft:
            return !(n.byteLength != t.byteLength || !i(new Rl(n), new Rl(t)));
          case Nn:
          case Pn:
          case Hn:
            return Gf(+n, +t);
          case Zn:
            return n.name == t.name && n.message == t.message;
          case nt:
          case rt:
            return n == t + "";
          case Gn:
            var f = M;
          case tt:
            var c = e & hn;
            if (f || (f = P), n.size != t.size && !c) return !1;
            var a = o.get(n);
            if (a) return a == t;
            e |= pn, o.set(n, t);
            var l = pi(f(n), f(t), e, u, i, o);
            return o["delete"](n), l;
          case et:
            if (_s) return _s.call(n) == _s.call(t);
        }
        return !1;
      }
      function vi(n, t, r, e, u, i) {
        var o = r & hn,
          f = yi(n),
          c = f.length;
        if (c != yi(t).length && !o) return !1;
        for (var a = c; a--;) {
          var l = f[a];
          if (!(o ? l in t : bl.call(t, l))) return !1;
        }
        var s = i.get(n),
          h = i.get(t);
        if (s && h) return s == t && h == n;
        var p = !0;
        i.set(n, t), i.set(t, n);
        for (var _ = o; ++a < c;) {
          l = f[a];
          var v = n[l],
            g = t[l];
          if (e) var y = o ? e(g, v, l, t, n, i) : e(v, g, l, n, t, i);
          if (!(y === X ? v === g || u(v, g, r, e, i) : y)) {
            p = !1;
            break;
          }
          _ || (_ = "constructor" == l);
        }
        if (p && !_) {
          var d = n.constructor,
            b = t.constructor;
          d != b && "constructor" in n && "constructor" in t && !("function" == typeof d && d instanceof d && "function" == typeof b && b instanceof b) && (p = !1);
        }
        return i["delete"](n), i["delete"](t), p;
      }
      function gi(n) {
        return Ls(Vi(n, X, _o), n + "");
      }
      function yi(n) {
        return de(n, Pc, Is);
      }
      function di(n) {
        return de(n, qc, Rs);
      }
      function bi(n) {
        for (var t = n.name + "", r = fs[t], e = bl.call(fs, t) ? r.length : 0; e--;) {
          var u = r[e],
            i = u.func;
          if (null == i || i == n) return u.name;
        }
        return t;
      }
      function wi(n) {
        return (bl.call(Z, "placeholder") ? Z : n).placeholder;
      }
      function mi() {
        var n = Z.iteratee || Ca;
        return n = n === Ca ? De : n, arguments.length ? n(arguments[0], arguments[1]) : n;
      }
      function xi(n, t) {
        var r = n.__data__;
        return Ti(t) ? r["string" == typeof t ? "string" : "hash"] : r.map;
      }
      function ji(n) {
        for (var t = Pc(n), r = t.length; r--;) {
          var e = t[r],
            u = n[e];
          t[r] = [e, u, Fi(u)];
        }
        return t;
      }
      function Ai(n, t) {
        var r = B(n, t);
        return Ue(r) ? r : X;
      }
      function ki(n) {
        var t = bl.call(n, Bl),
          r = n[Bl];
        try {
          n[Bl] = X;
          var e = !0;
        } catch (n) {}
        var u = xl.call(n);
        return e && (t ? n[Bl] = r : delete n[Bl]), u;
      }
      function Oi(n, t, r) {
        for (var e = -1, u = r.length; ++e < u;) {
          var i = r[e],
            o = i.size;
          switch (i.type) {
            case "drop":
              n += o;
              break;
            case "dropRight":
              t -= o;
              break;
            case "take":
              t = Hl(t, n + o);
              break;
            case "takeRight":
              n = Gl(n, t - o);
          }
        }
        return {
          start: n,
          end: t
        };
      }
      function Ii(n) {
        var t = n.match(Bt);
        return t ? t[1].split(Tt) : [];
      }
      function Ri(n, t, r) {
        t = ku(t, n);
        for (var e = -1, u = t.length, i = !1; ++e < u;) {
          var o = no(t[e]);
          if (!(i = null != n && r(n, o))) break;
          n = n[o];
        }
        return i || ++e != u ? i : (u = null == n ? 0 : n.length, !!u && oc(u) && Ci(o, u) && (bh(n) || dh(n)));
      }
      function zi(n) {
        var t = n.length,
          r = new n.constructor(t);
        return t && "string" == typeof n[0] && bl.call(n, "index") && (r.index = n.index, r.input = n.input), r;
      }
      function Ei(n) {
        return "function" != typeof n.constructor || Mi(n) ? {} : gs(El(n));
      }
      function Si(n, t, r) {
        var e = n.constructor;
        switch (t) {
          case ft:
            return Ru(n);
          case Nn:
          case Pn:
            return new e(+n);
          case ct:
            return zu(n, r);
          case at:
          case lt:
          case st:
          case ht:
          case pt:
          case _t:
          case vt:
          case gt:
          case yt:
            return Wu(n, r);
          case Gn:
            return new e();
          case Hn:
          case rt:
            return new e(n);
          case nt:
            return Eu(n);
          case tt:
            return new e();
          case et:
            return Su(n);
        }
      }
      function Wi(n, t) {
        var r = t.length;
        if (!r) return n;
        var e = r - 1;
        return t[e] = (r > 1 ? "& " : "") + t[e], t = t.join(r > 2 ? ", " : " "), n.replace(Ut, "{\n/* [wrapped with " + t + "] */\n");
      }
      function Li(n) {
        return bh(n) || dh(n) || !!(Cl && n && n[Cl]);
      }
      function Ci(n, t) {
        var r = _typeof(n);
        return t = null == t ? Wn : t, !!t && ("number" == r || "symbol" != r && Vt.test(n)) && n > -1 && n % 1 == 0 && n < t;
      }
      function Ui(n, t, r) {
        if (!fc(r)) return !1;
        var e = _typeof(t);
        return !!("number" == e ? Hf(r) && Ci(t, r.length) : "string" == e && t in r) && Gf(r[t], n);
      }
      function Bi(n, t) {
        if (bh(n)) return !1;
        var r = _typeof(n);
        return !("number" != r && "symbol" != r && "boolean" != r && null != n && !bc(n)) || zt.test(n) || !Rt.test(n) || null != t && n in ll(t);
      }
      function Ti(n) {
        var t = _typeof(n);
        return "string" == t || "number" == t || "symbol" == t || "boolean" == t ? "__proto__" !== n : null === n;
      }
      function $i(n) {
        var t = bi(n),
          r = Z[t];
        if ("function" != typeof r || !(t in Ct.prototype)) return !1;
        if (n === r) return !0;
        var e = Os(r);
        return !!e && n === e[0];
      }
      function Di(n) {
        return !!ml && ml in n;
      }
      function Mi(n) {
        var t = n && n.constructor;
        return n === ("function" == typeof t && t.prototype || gl);
      }
      function Fi(n) {
        return n === n && !fc(n);
      }
      function Ni(n, t) {
        return function (r) {
          return null != r && r[n] === t && (t !== X || n in ll(r));
        };
      }
      function Pi(n) {
        var t = Cf(n, function (n) {
            return r.size === fn && r.clear(), n;
          }),
          r = t.cache;
        return t;
      }
      function qi(n, t) {
        var r = n[1],
          e = t[1],
          u = r | e,
          i = u < (_n | vn | mn),
          o = e == mn && r == yn || e == mn && r == xn && n[7].length <= t[8] || e == (mn | xn) && t[7].length <= t[8] && r == yn;
        if (!i && !o) return n;
        e & _n && (n[2] = t[2], u |= r & _n ? 0 : gn);
        var f = t[3];
        if (f) {
          var c = n[3];
          n[3] = c ? Uu(c, f, t[4]) : f, n[4] = c ? N(n[3], cn) : t[4];
        }
        return f = t[5], f && (c = n[5], n[5] = c ? Bu(c, f, t[6]) : f, n[6] = c ? N(n[5], cn) : t[6]), f = t[7], f && (n[7] = f), e & mn && (n[8] = null == n[8] ? t[8] : Hl(n[8], t[8])), null == n[9] && (n[9] = t[9]), n[0] = t[0], n[1] = u, n;
      }
      function Zi(n) {
        var t = [];
        if (null != n) for (var r in ll(n)) t.push(r);
        return t;
      }
      function Ki(n) {
        return xl.call(n);
      }
      function Vi(t, r, e) {
        return r = Gl(r === X ? t.length - 1 : r, 0), function () {
          for (var u = arguments, i = -1, o = Gl(u.length - r, 0), f = il(o); ++i < o;) f[i] = u[r + i];
          i = -1;
          for (var c = il(r + 1); ++i < r;) c[i] = u[i];
          return c[r] = e(f), n(t, this, c);
        };
      }
      function Gi(n, t) {
        return t.length < 2 ? n : _e(n, au(t, 0, -1));
      }
      function Hi(n, t) {
        for (var r = n.length, e = Hl(t.length, r), u = Tu(n); e--;) {
          var i = t[e];
          n[e] = Ci(i, r) ? u[i] : X;
        }
        return n;
      }
      function Ji(n, t) {
        if (("constructor" !== t || "function" != typeof n[t]) && "__proto__" != t) return n[t];
      }
      function Yi(n, t, r) {
        var e = t + "";
        return Ls(n, Wi(e, ro(Ii(e), r)));
      }
      function Qi(n) {
        var t = 0,
          r = 0;
        return function () {
          var e = Jl(),
            u = In - (e - r);
          if (r = e, u > 0) {
            if (++t >= On) return arguments[0];
          } else t = 0;
          return n.apply(X, arguments);
        };
      }
      function Xi(n, t) {
        var r = -1,
          e = n.length,
          u = e - 1;
        for (t = t === X ? e : t; ++r < t;) {
          var i = tu(r, u),
            o = n[i];
          n[i] = n[r], n[r] = o;
        }
        return n.length = t, n;
      }
      function no(n) {
        if ("string" == typeof n || bc(n)) return n;
        var t = n + "";
        return "0" == t && 1 / n == -Sn ? "-0" : t;
      }
      function to(n) {
        if (null != n) {
          try {
            return dl.call(n);
          } catch (n) {}
          try {
            return n + "";
          } catch (n) {}
        }
        return "";
      }
      function ro(n, t) {
        return r($n, function (r) {
          var e = "_." + r[0];
          t & r[1] && !o(n, e) && n.push(e);
        }), n.sort();
      }
      function eo(n) {
        if (n instanceof Ct) return n.clone();
        var t = new Y(n.__wrapped__, n.__chain__);
        return t.__actions__ = Tu(n.__actions__), t.__index__ = n.__index__, t.__values__ = n.__values__, t;
      }
      function uo(n, t, r) {
        t = (r ? Ui(n, t, r) : t === X) ? 1 : Gl(kc(t), 0);
        var e = null == n ? 0 : n.length;
        if (!e || t < 1) return [];
        for (var u = 0, i = 0, o = il(Fl(e / t)); u < e;) o[i++] = au(n, u, u += t);
        return o;
      }
      function io(n) {
        for (var t = -1, r = null == n ? 0 : n.length, e = 0, u = []; ++t < r;) {
          var i = n[t];
          i && (u[e++] = i);
        }
        return u;
      }
      function oo() {
        var n = arguments.length;
        if (!n) return [];
        for (var t = il(n - 1), r = arguments[0], e = n; e--;) t[e - 1] = arguments[e];
        return a(bh(r) ? Tu(r) : [r], ee(t, 1));
      }
      function fo(n, t, r) {
        var e = null == n ? 0 : n.length;
        return e ? (t = r || t === X ? 1 : kc(t), au(n, t < 0 ? 0 : t, e)) : [];
      }
      function co(n, t, r) {
        var e = null == n ? 0 : n.length;
        return e ? (t = r || t === X ? 1 : kc(t), t = e - t, au(n, 0, t < 0 ? 0 : t)) : [];
      }
      function ao(n, t) {
        return n && n.length ? bu(n, mi(t, 3), !0, !0) : [];
      }
      function lo(n, t) {
        return n && n.length ? bu(n, mi(t, 3), !0) : [];
      }
      function so(n, t, r, e) {
        var u = null == n ? 0 : n.length;
        return u ? (r && "number" != typeof r && Ui(n, t, r) && (r = 0, e = u), ne(n, t, r, e)) : [];
      }
      function ho(n, t, r) {
        var e = null == n ? 0 : n.length;
        if (!e) return -1;
        var u = null == r ? 0 : kc(r);
        return u < 0 && (u = Gl(e + u, 0)), g(n, mi(t, 3), u);
      }
      function po(n, t, r) {
        var e = null == n ? 0 : n.length;
        if (!e) return -1;
        var u = e - 1;
        return r !== X && (u = kc(r), u = r < 0 ? Gl(e + u, 0) : Hl(u, e - 1)), g(n, mi(t, 3), u, !0);
      }
      function _o(n) {
        return (null == n ? 0 : n.length) ? ee(n, 1) : [];
      }
      function vo(n) {
        return (null == n ? 0 : n.length) ? ee(n, Sn) : [];
      }
      function go(n, t) {
        return (null == n ? 0 : n.length) ? (t = t === X ? 1 : kc(t), ee(n, t)) : [];
      }
      function yo(n) {
        for (var t = -1, r = null == n ? 0 : n.length, e = {}; ++t < r;) {
          var u = n[t];
          e[u[0]] = u[1];
        }
        return e;
      }
      function bo(n) {
        return n && n.length ? n[0] : X;
      }
      function wo(n, t, r) {
        var e = null == n ? 0 : n.length;
        if (!e) return -1;
        var u = null == r ? 0 : kc(r);
        return u < 0 && (u = Gl(e + u, 0)), y(n, t, u);
      }
      function mo(n) {
        return (null == n ? 0 : n.length) ? au(n, 0, -1) : [];
      }
      function xo(n, t) {
        return null == n ? "" : Kl.call(n, t);
      }
      function jo(n) {
        var t = null == n ? 0 : n.length;
        return t ? n[t - 1] : X;
      }
      function Ao(n, t, r) {
        var e = null == n ? 0 : n.length;
        if (!e) return -1;
        var u = e;
        return r !== X && (u = kc(r), u = u < 0 ? Gl(e + u, 0) : Hl(u, e - 1)), t === t ? K(n, t, u) : g(n, b, u, !0);
      }
      function ko(n, t) {
        return n && n.length ? Ge(n, kc(t)) : X;
      }
      function Oo(n, t) {
        return n && n.length && t && t.length ? Xe(n, t) : n;
      }
      function Io(n, t, r) {
        return n && n.length && t && t.length ? Xe(n, t, mi(r, 2)) : n;
      }
      function Ro(n, t, r) {
        return n && n.length && t && t.length ? Xe(n, t, X, r) : n;
      }
      function zo(n, t) {
        var r = [];
        if (!n || !n.length) return r;
        var e = -1,
          u = [],
          i = n.length;
        for (t = mi(t, 3); ++e < i;) {
          var o = n[e];
          t(o, e, n) && (r.push(o), u.push(e));
        }
        return nu(n, u), r;
      }
      function Eo(n) {
        return null == n ? n : Xl.call(n);
      }
      function So(n, t, r) {
        var e = null == n ? 0 : n.length;
        return e ? (r && "number" != typeof r && Ui(n, t, r) ? (t = 0, r = e) : (t = null == t ? 0 : kc(t), r = r === X ? e : kc(r)), au(n, t, r)) : [];
      }
      function Wo(n, t) {
        return su(n, t);
      }
      function Lo(n, t, r) {
        return hu(n, t, mi(r, 2));
      }
      function Co(n, t) {
        var r = null == n ? 0 : n.length;
        if (r) {
          var e = su(n, t);
          if (e < r && Gf(n[e], t)) return e;
        }
        return -1;
      }
      function Uo(n, t) {
        return su(n, t, !0);
      }
      function Bo(n, t, r) {
        return hu(n, t, mi(r, 2), !0);
      }
      function To(n, t) {
        if (null == n ? 0 : n.length) {
          var r = su(n, t, !0) - 1;
          if (Gf(n[r], t)) return r;
        }
        return -1;
      }
      function $o(n) {
        return n && n.length ? pu(n) : [];
      }
      function Do(n, t) {
        return n && n.length ? pu(n, mi(t, 2)) : [];
      }
      function Mo(n) {
        var t = null == n ? 0 : n.length;
        return t ? au(n, 1, t) : [];
      }
      function Fo(n, t, r) {
        return n && n.length ? (t = r || t === X ? 1 : kc(t), au(n, 0, t < 0 ? 0 : t)) : [];
      }
      function No(n, t, r) {
        var e = null == n ? 0 : n.length;
        return e ? (t = r || t === X ? 1 : kc(t), t = e - t, au(n, t < 0 ? 0 : t, e)) : [];
      }
      function Po(n, t) {
        return n && n.length ? bu(n, mi(t, 3), !1, !0) : [];
      }
      function qo(n, t) {
        return n && n.length ? bu(n, mi(t, 3)) : [];
      }
      function Zo(n) {
        return n && n.length ? gu(n) : [];
      }
      function Ko(n, t) {
        return n && n.length ? gu(n, mi(t, 2)) : [];
      }
      function Vo(n, t) {
        return t = "function" == typeof t ? t : X, n && n.length ? gu(n, X, t) : [];
      }
      function Go(n) {
        if (!n || !n.length) return [];
        var t = 0;
        return n = i(n, function (n) {
          if (Jf(n)) return t = Gl(n.length, t), !0;
        }), O(t, function (t) {
          return c(n, m(t));
        });
      }
      function Ho(t, r) {
        if (!t || !t.length) return [];
        var e = Go(t);
        return null == r ? e : c(e, function (t) {
          return n(r, X, t);
        });
      }
      function Jo(n, t) {
        return xu(n || [], t || [], Sr);
      }
      function Yo(n, t) {
        return xu(n || [], t || [], fu);
      }
      function Qo(n) {
        var t = Z(n);
        return t.__chain__ = !0, t;
      }
      function Xo(n, t) {
        return t(n), n;
      }
      function nf(n, t) {
        return t(n);
      }
      function tf() {
        return Qo(this);
      }
      function rf() {
        return new Y(this.value(), this.__chain__);
      }
      function ef() {
        this.__values__ === X && (this.__values__ = jc(this.value()));
        var n = this.__index__ >= this.__values__.length;
        return {
          done: n,
          value: n ? X : this.__values__[this.__index__++]
        };
      }
      function uf() {
        return this;
      }
      function of(n) {
        for (var t, r = this; r instanceof J;) {
          var e = eo(r);
          e.__index__ = 0, e.__values__ = X, t ? u.__wrapped__ = e : t = e;
          var u = e;
          r = r.__wrapped__;
        }
        return u.__wrapped__ = n, t;
      }
      function ff() {
        var n = this.__wrapped__;
        if (n instanceof Ct) {
          var t = n;
          return this.__actions__.length && (t = new Ct(this)), t = t.reverse(), t.__actions__.push({
            func: nf,
            args: [Eo],
            thisArg: X
          }), new Y(t, this.__chain__);
        }
        return this.thru(Eo);
      }
      function cf() {
        return wu(this.__wrapped__, this.__actions__);
      }
      function af(n, t, r) {
        var e = bh(n) ? u : Jr;
        return r && Ui(n, t, r) && (t = X), e(n, mi(t, 3));
      }
      function lf(n, t) {
        return (bh(n) ? i : te)(n, mi(t, 3));
      }
      function sf(n, t) {
        return ee(yf(n, t), 1);
      }
      function hf(n, t) {
        return ee(yf(n, t), Sn);
      }
      function pf(n, t, r) {
        return r = r === X ? 1 : kc(r), ee(yf(n, t), r);
      }
      function _f(n, t) {
        return (bh(n) ? r : ys)(n, mi(t, 3));
      }
      function vf(n, t) {
        return (bh(n) ? e : ds)(n, mi(t, 3));
      }
      function gf(n, t, r, e) {
        n = Hf(n) ? n : ra(n), r = r && !e ? kc(r) : 0;
        var u = n.length;
        return r < 0 && (r = Gl(u + r, 0)), dc(n) ? r <= u && n.indexOf(t, r) > -1 : !!u && y(n, t, r) > -1;
      }
      function yf(n, t) {
        return (bh(n) ? c : Pe)(n, mi(t, 3));
      }
      function df(n, t, r, e) {
        return null == n ? [] : (bh(t) || (t = null == t ? [] : [t]), r = e ? X : r, bh(r) || (r = null == r ? [] : [r]), He(n, t, r));
      }
      function bf(n, t, r) {
        var e = bh(n) ? l : j,
          u = arguments.length < 3;
        return e(n, mi(t, 4), r, u, ys);
      }
      function wf(n, t, r) {
        var e = bh(n) ? s : j,
          u = arguments.length < 3;
        return e(n, mi(t, 4), r, u, ds);
      }
      function mf(n, t) {
        return (bh(n) ? i : te)(n, Uf(mi(t, 3)));
      }
      function xf(n) {
        return (bh(n) ? Ir : iu)(n);
      }
      function jf(n, t, r) {
        return t = (r ? Ui(n, t, r) : t === X) ? 1 : kc(t), (bh(n) ? Rr : ou)(n, t);
      }
      function Af(n) {
        return (bh(n) ? zr : cu)(n);
      }
      function kf(n) {
        if (null == n) return 0;
        if (Hf(n)) return dc(n) ? V(n) : n.length;
        var t = zs(n);
        return t == Gn || t == tt ? n.size : Me(n).length;
      }
      function Of(n, t, r) {
        var e = bh(n) ? h : lu;
        return r && Ui(n, t, r) && (t = X), e(n, mi(t, 3));
      }
      function If(n, t) {
        if ("function" != typeof t) throw new pl(en);
        return n = kc(n), function () {
          if (--n < 1) return t.apply(this, arguments);
        };
      }
      function Rf(n, t, r) {
        return t = r ? X : t, t = n && null == t ? n.length : t, ai(n, mn, X, X, X, X, t);
      }
      function zf(n, t) {
        var r;
        if ("function" != typeof t) throw new pl(en);
        return n = kc(n), function () {
          return --n > 0 && (r = t.apply(this, arguments)), n <= 1 && (t = X), r;
        };
      }
      function Ef(n, t, r) {
        t = r ? X : t;
        var e = ai(n, yn, X, X, X, X, X, t);
        return e.placeholder = Ef.placeholder, e;
      }
      function Sf(n, t, r) {
        t = r ? X : t;
        var e = ai(n, dn, X, X, X, X, X, t);
        return e.placeholder = Sf.placeholder, e;
      }
      function Wf(n, t, r) {
        function e(t) {
          var r = h,
            e = p;
          return h = p = X, d = t, v = n.apply(e, r);
        }
        function u(n) {
          return d = n, g = Ws(f, t), b ? e(n) : v;
        }
        function i(n) {
          var r = n - y,
            e = n - d,
            u = t - r;
          return w ? Hl(u, _ - e) : u;
        }
        function o(n) {
          var r = n - y,
            e = n - d;
          return y === X || r >= t || r < 0 || w && e >= _;
        }
        function f() {
          var n = fh();
          return o(n) ? c(n) : (g = Ws(f, i(n)), X);
        }
        function c(n) {
          return g = X, m && h ? e(n) : (h = p = X, v);
        }
        function a() {
          g !== X && As(g), d = 0, h = y = p = g = X;
        }
        function l() {
          return g === X ? v : c(fh());
        }
        function s() {
          var n = fh(),
            r = o(n);
          if (h = arguments, p = this, y = n, r) {
            if (g === X) return u(y);
            if (w) return As(g), g = Ws(f, t), e(y);
          }
          return g === X && (g = Ws(f, t)), v;
        }
        var h,
          p,
          _,
          v,
          g,
          y,
          d = 0,
          b = !1,
          w = !1,
          m = !0;
        if ("function" != typeof n) throw new pl(en);
        return t = Ic(t) || 0, fc(r) && (b = !!r.leading, w = "maxWait" in r, _ = w ? Gl(Ic(r.maxWait) || 0, t) : _, m = "trailing" in r ? !!r.trailing : m), s.cancel = a, s.flush = l, s;
      }
      function Lf(n) {
        return ai(n, jn);
      }
      function Cf(n, t) {
        if ("function" != typeof n || null != t && "function" != typeof t) throw new pl(en);
        var r = function r() {
          var e = arguments,
            u = t ? t.apply(this, e) : e[0],
            i = r.cache;
          if (i.has(u)) return i.get(u);
          var o = n.apply(this, e);
          return r.cache = i.set(u, o) || i, o;
        };
        return r.cache = new (Cf.Cache || sr)(), r;
      }
      function Uf(n) {
        if ("function" != typeof n) throw new pl(en);
        return function () {
          var t = arguments;
          switch (t.length) {
            case 0:
              return !n.call(this);
            case 1:
              return !n.call(this, t[0]);
            case 2:
              return !n.call(this, t[0], t[1]);
            case 3:
              return !n.call(this, t[0], t[1], t[2]);
          }
          return !n.apply(this, t);
        };
      }
      function Bf(n) {
        return zf(2, n);
      }
      function Tf(n, t) {
        if ("function" != typeof n) throw new pl(en);
        return t = t === X ? t : kc(t), uu(n, t);
      }
      function $f(t, r) {
        if ("function" != typeof t) throw new pl(en);
        return r = null == r ? 0 : Gl(kc(r), 0), uu(function (e) {
          var u = e[r],
            i = Ou(e, 0, r);
          return u && a(i, u), n(t, this, i);
        });
      }
      function Df(n, t, r) {
        var e = !0,
          u = !0;
        if ("function" != typeof n) throw new pl(en);
        return fc(r) && (e = "leading" in r ? !!r.leading : e, u = "trailing" in r ? !!r.trailing : u), Wf(n, t, {
          leading: e,
          maxWait: t,
          trailing: u
        });
      }
      function Mf(n) {
        return Rf(n, 1);
      }
      function Ff(n, t) {
        return ph(Au(t), n);
      }
      function Nf() {
        if (!arguments.length) return [];
        var n = arguments[0];
        return bh(n) ? n : [n];
      }
      function Pf(n) {
        return Fr(n, sn);
      }
      function qf(n, t) {
        return t = "function" == typeof t ? t : X, Fr(n, sn, t);
      }
      function Zf(n) {
        return Fr(n, an | sn);
      }
      function Kf(n, t) {
        return t = "function" == typeof t ? t : X, Fr(n, an | sn, t);
      }
      function Vf(n, t) {
        return null == t || Pr(n, t, Pc(t));
      }
      function Gf(n, t) {
        return n === t || n !== n && t !== t;
      }
      function Hf(n) {
        return null != n && oc(n.length) && !uc(n);
      }
      function Jf(n) {
        return cc(n) && Hf(n);
      }
      function Yf(n) {
        return n === !0 || n === !1 || cc(n) && we(n) == Nn;
      }
      function Qf(n) {
        return cc(n) && 1 === n.nodeType && !gc(n);
      }
      function Xf(n) {
        if (null == n) return !0;
        if (Hf(n) && (bh(n) || "string" == typeof n || "function" == typeof n.splice || mh(n) || Oh(n) || dh(n))) return !n.length;
        var t = zs(n);
        if (t == Gn || t == tt) return !n.size;
        if (Mi(n)) return !Me(n).length;
        for (var r in n) if (bl.call(n, r)) return !1;
        return !0;
      }
      function nc(n, t) {
        return Se(n, t);
      }
      function tc(n, t, r) {
        r = "function" == typeof r ? r : X;
        var e = r ? r(n, t) : X;
        return e === X ? Se(n, t, X, r) : !!e;
      }
      function rc(n) {
        if (!cc(n)) return !1;
        var t = we(n);
        return t == Zn || t == qn || "string" == typeof n.message && "string" == typeof n.name && !gc(n);
      }
      function ec(n) {
        return "number" == typeof n && Zl(n);
      }
      function uc(n) {
        if (!fc(n)) return !1;
        var t = we(n);
        return t == Kn || t == Vn || t == Fn || t == Xn;
      }
      function ic(n) {
        return "number" == typeof n && n == kc(n);
      }
      function oc(n) {
        return "number" == typeof n && n > -1 && n % 1 == 0 && n <= Wn;
      }
      function fc(n) {
        var t = _typeof(n);
        return null != n && ("object" == t || "function" == t);
      }
      function cc(n) {
        return null != n && "object" == _typeof(n);
      }
      function ac(n, t) {
        return n === t || Ce(n, t, ji(t));
      }
      function lc(n, t, r) {
        return r = "function" == typeof r ? r : X, Ce(n, t, ji(t), r);
      }
      function sc(n) {
        return vc(n) && n != +n;
      }
      function hc(n) {
        if (Es(n)) throw new fl(rn);
        return Ue(n);
      }
      function pc(n) {
        return null === n;
      }
      function _c(n) {
        return null == n;
      }
      function vc(n) {
        return "number" == typeof n || cc(n) && we(n) == Hn;
      }
      function gc(n) {
        if (!cc(n) || we(n) != Yn) return !1;
        var t = El(n);
        if (null === t) return !0;
        var r = bl.call(t, "constructor") && t.constructor;
        return "function" == typeof r && r instanceof r && dl.call(r) == jl;
      }
      function yc(n) {
        return ic(n) && n >= -Wn && n <= Wn;
      }
      function dc(n) {
        return "string" == typeof n || !bh(n) && cc(n) && we(n) == rt;
      }
      function bc(n) {
        return "symbol" == _typeof(n) || cc(n) && we(n) == et;
      }
      function wc(n) {
        return n === X;
      }
      function mc(n) {
        return cc(n) && zs(n) == it;
      }
      function xc(n) {
        return cc(n) && we(n) == ot;
      }
      function jc(n) {
        if (!n) return [];
        if (Hf(n)) return dc(n) ? G(n) : Tu(n);
        if (Ul && n[Ul]) return D(n[Ul]());
        var t = zs(n);
        return (t == Gn ? M : t == tt ? P : ra)(n);
      }
      function Ac(n) {
        if (!n) return 0 === n ? n : 0;
        if (n = Ic(n), n === Sn || n === -Sn) {
          return (n < 0 ? -1 : 1) * Ln;
        }
        return n === n ? n : 0;
      }
      function kc(n) {
        var t = Ac(n),
          r = t % 1;
        return t === t ? r ? t - r : t : 0;
      }
      function Oc(n) {
        return n ? Mr(kc(n), 0, Un) : 0;
      }
      function Ic(n) {
        if ("number" == typeof n) return n;
        if (bc(n)) return Cn;
        if (fc(n)) {
          var t = "function" == typeof n.valueOf ? n.valueOf() : n;
          n = fc(t) ? t + "" : t;
        }
        if ("string" != typeof n) return 0 === n ? n : +n;
        n = R(n);
        var r = qt.test(n);
        return r || Kt.test(n) ? Xr(n.slice(2), r ? 2 : 8) : Pt.test(n) ? Cn : +n;
      }
      function Rc(n) {
        return $u(n, qc(n));
      }
      function zc(n) {
        return n ? Mr(kc(n), -Wn, Wn) : 0 === n ? n : 0;
      }
      function Ec(n) {
        return null == n ? "" : vu(n);
      }
      function Sc(n, t) {
        var r = gs(n);
        return null == t ? r : Cr(r, t);
      }
      function Wc(n, t) {
        return v(n, mi(t, 3), ue);
      }
      function Lc(n, t) {
        return v(n, mi(t, 3), oe);
      }
      function Cc(n, t) {
        return null == n ? n : bs(n, mi(t, 3), qc);
      }
      function Uc(n, t) {
        return null == n ? n : ws(n, mi(t, 3), qc);
      }
      function Bc(n, t) {
        return n && ue(n, mi(t, 3));
      }
      function Tc(n, t) {
        return n && oe(n, mi(t, 3));
      }
      function $c(n) {
        return null == n ? [] : fe(n, Pc(n));
      }
      function Dc(n) {
        return null == n ? [] : fe(n, qc(n));
      }
      function Mc(n, t, r) {
        var e = null == n ? X : _e(n, t);
        return e === X ? r : e;
      }
      function Fc(n, t) {
        return null != n && Ri(n, t, xe);
      }
      function Nc(n, t) {
        return null != n && Ri(n, t, je);
      }
      function Pc(n) {
        return Hf(n) ? Or(n) : Me(n);
      }
      function qc(n) {
        return Hf(n) ? Or(n, !0) : Fe(n);
      }
      function Zc(n, t) {
        var r = {};
        return t = mi(t, 3), ue(n, function (n, e, u) {
          Br(r, t(n, e, u), n);
        }), r;
      }
      function Kc(n, t) {
        var r = {};
        return t = mi(t, 3), ue(n, function (n, e, u) {
          Br(r, e, t(n, e, u));
        }), r;
      }
      function Vc(n, t) {
        return Gc(n, Uf(mi(t)));
      }
      function Gc(n, t) {
        if (null == n) return {};
        var r = c(di(n), function (n) {
          return [n];
        });
        return t = mi(t), Ye(n, r, function (n, r) {
          return t(n, r[0]);
        });
      }
      function Hc(n, t, r) {
        t = ku(t, n);
        var e = -1,
          u = t.length;
        for (u || (u = 1, n = X); ++e < u;) {
          var i = null == n ? X : n[no(t[e])];
          i === X && (e = u, i = r), n = uc(i) ? i.call(n) : i;
        }
        return n;
      }
      function Jc(n, t, r) {
        return null == n ? n : fu(n, t, r);
      }
      function Yc(n, t, r, e) {
        return e = "function" == typeof e ? e : X, null == n ? n : fu(n, t, r, e);
      }
      function Qc(n, t, e) {
        var u = bh(n),
          i = u || mh(n) || Oh(n);
        if (t = mi(t, 4), null == e) {
          var o = n && n.constructor;
          e = i ? u ? new o() : [] : fc(n) && uc(o) ? gs(El(n)) : {};
        }
        return (i ? r : ue)(n, function (n, r, u) {
          return t(e, n, r, u);
        }), e;
      }
      function Xc(n, t) {
        return null == n || yu(n, t);
      }
      function na(n, t, r) {
        return null == n ? n : du(n, t, Au(r));
      }
      function ta(n, t, r, e) {
        return e = "function" == typeof e ? e : X, null == n ? n : du(n, t, Au(r), e);
      }
      function ra(n) {
        return null == n ? [] : E(n, Pc(n));
      }
      function ea(n) {
        return null == n ? [] : E(n, qc(n));
      }
      function ua(n, t, r) {
        return r === X && (r = t, t = X), r !== X && (r = Ic(r), r = r === r ? r : 0), t !== X && (t = Ic(t), t = t === t ? t : 0), Mr(Ic(n), t, r);
      }
      function ia(n, t, r) {
        return t = Ac(t), r === X ? (r = t, t = 0) : r = Ac(r), n = Ic(n), Ae(n, t, r);
      }
      function oa(n, t, r) {
        if (r && "boolean" != typeof r && Ui(n, t, r) && (t = r = X), r === X && ("boolean" == typeof t ? (r = t, t = X) : "boolean" == typeof n && (r = n, n = X)), n === X && t === X ? (n = 0, t = 1) : (n = Ac(n), t === X ? (t = n, n = 0) : t = Ac(t)), n > t) {
          var e = n;
          n = t, t = e;
        }
        if (r || n % 1 || t % 1) {
          var u = Ql();
          return Hl(n + u * (t - n + Qr("1e-" + ((u + "").length - 1))), t);
        }
        return tu(n, t);
      }
      function fa(n) {
        return Qh(Ec(n).toLowerCase());
      }
      function ca(n) {
        return n = Ec(n), n && n.replace(Gt, ve).replace(Dr, "");
      }
      function aa(n, t, r) {
        n = Ec(n), t = vu(t);
        var e = n.length;
        r = r === X ? e : Mr(kc(r), 0, e);
        var u = r;
        return r -= t.length, r >= 0 && n.slice(r, u) == t;
      }
      function la(n) {
        return n = Ec(n), n && At.test(n) ? n.replace(xt, ge) : n;
      }
      function sa(n) {
        return n = Ec(n), n && Wt.test(n) ? n.replace(St, "\\$&") : n;
      }
      function ha(n, t, r) {
        n = Ec(n), t = kc(t);
        var e = t ? V(n) : 0;
        if (!t || e >= t) return n;
        var u = (t - e) / 2;
        return ri(Nl(u), r) + n + ri(Fl(u), r);
      }
      function pa(n, t, r) {
        n = Ec(n), t = kc(t);
        var e = t ? V(n) : 0;
        return t && e < t ? n + ri(t - e, r) : n;
      }
      function _a(n, t, r) {
        n = Ec(n), t = kc(t);
        var e = t ? V(n) : 0;
        return t && e < t ? ri(t - e, r) + n : n;
      }
      function va(n, t, r) {
        return r || null == t ? t = 0 : t && (t = +t), Yl(Ec(n).replace(Lt, ""), t || 0);
      }
      function ga(n, t, r) {
        return t = (r ? Ui(n, t, r) : t === X) ? 1 : kc(t), eu(Ec(n), t);
      }
      function ya() {
        var n = arguments,
          t = Ec(n[0]);
        return n.length < 3 ? t : t.replace(n[1], n[2]);
      }
      function da(n, t, r) {
        return r && "number" != typeof r && Ui(n, t, r) && (t = r = X), (r = r === X ? Un : r >>> 0) ? (n = Ec(n), n && ("string" == typeof t || null != t && !Ah(t)) && (t = vu(t), !t && T(n)) ? Ou(G(n), 0, r) : n.split(t, r)) : [];
      }
      function ba(n, t, r) {
        return n = Ec(n), r = null == r ? 0 : Mr(kc(r), 0, n.length), t = vu(t), n.slice(r, r + t.length) == t;
      }
      function wa(n, t, r) {
        var e = Z.templateSettings;
        r && Ui(n, t, r) && (t = X), n = Ec(n), t = Sh({}, t, e, li);
        var u,
          i,
          o = Sh({}, t.imports, e.imports, li),
          f = Pc(o),
          c = E(o, f),
          a = 0,
          l = t.interpolate || Ht,
          s = "__p += '",
          h = sl((t.escape || Ht).source + "|" + l.source + "|" + (l === It ? Ft : Ht).source + "|" + (t.evaluate || Ht).source + "|$", "g"),
          p = "//# sourceURL=" + (bl.call(t, "sourceURL") ? (t.sourceURL + "").replace(/\s/g, " ") : "lodash.templateSources[" + ++Zr + "]") + "\n";
        n.replace(h, function (t, r, e, o, f, c) {
          return e || (e = o), s += n.slice(a, c).replace(Jt, U), r && (u = !0, s += "' +\n__e(" + r + ") +\n'"), f && (i = !0, s += "';\n" + f + ";\n__p += '"), e && (s += "' +\n((__t = (" + e + ")) == null ? '' : __t) +\n'"), a = c + t.length, t;
        }), s += "';\n";
        var _ = bl.call(t, "variable") && t.variable;
        if (_) {
          if (Dt.test(_)) throw new fl(un);
        } else s = "with (obj) {\n" + s + "\n}\n";
        s = (i ? s.replace(dt, "") : s).replace(bt, "$1").replace(wt, "$1;"), s = "function(" + (_ || "obj") + ") {\n" + (_ ? "" : "obj || (obj = {});\n") + "var __t, __p = ''" + (u ? ", __e = _.escape" : "") + (i ? ", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n" : ";\n") + s + "return __p\n}";
        var v = Xh(function () {
          return cl(f, p + "return " + s).apply(X, c);
        });
        if (v.source = s, rc(v)) throw v;
        return v;
      }
      function ma(n) {
        return Ec(n).toLowerCase();
      }
      function xa(n) {
        return Ec(n).toUpperCase();
      }
      function ja(n, t, r) {
        if (n = Ec(n), n && (r || t === X)) return R(n);
        if (!n || !(t = vu(t))) return n;
        var e = G(n),
          u = G(t);
        return Ou(e, W(e, u), L(e, u) + 1).join("");
      }
      function Aa(n, t, r) {
        if (n = Ec(n), n && (r || t === X)) return n.slice(0, H(n) + 1);
        if (!n || !(t = vu(t))) return n;
        var e = G(n);
        return Ou(e, 0, L(e, G(t)) + 1).join("");
      }
      function ka(n, t, r) {
        if (n = Ec(n), n && (r || t === X)) return n.replace(Lt, "");
        if (!n || !(t = vu(t))) return n;
        var e = G(n);
        return Ou(e, W(e, G(t))).join("");
      }
      function Oa(n, t) {
        var r = An,
          e = kn;
        if (fc(t)) {
          var u = "separator" in t ? t.separator : u;
          r = "length" in t ? kc(t.length) : r, e = "omission" in t ? vu(t.omission) : e;
        }
        n = Ec(n);
        var i = n.length;
        if (T(n)) {
          var o = G(n);
          i = o.length;
        }
        if (r >= i) return n;
        var f = r - V(e);
        if (f < 1) return e;
        var c = o ? Ou(o, 0, f).join("") : n.slice(0, f);
        if (u === X) return c + e;
        if (o && (f += c.length - f), Ah(u)) {
          if (n.slice(f).search(u)) {
            var a,
              l = c;
            for (u.global || (u = sl(u.source, Ec(Nt.exec(u)) + "g")), u.lastIndex = 0; a = u.exec(l);) var s = a.index;
            c = c.slice(0, s === X ? f : s);
          }
        } else if (n.indexOf(vu(u), f) != f) {
          var h = c.lastIndexOf(u);
          h > -1 && (c = c.slice(0, h));
        }
        return c + e;
      }
      function Ia(n) {
        return n = Ec(n), n && jt.test(n) ? n.replace(mt, ye) : n;
      }
      function Ra(n, t, r) {
        return n = Ec(n), t = r ? X : t, t === X ? $(n) ? Q(n) : _(n) : n.match(t) || [];
      }
      function za(t) {
        var r = null == t ? 0 : t.length,
          e = mi();
        return t = r ? c(t, function (n) {
          if ("function" != typeof n[1]) throw new pl(en);
          return [e(n[0]), n[1]];
        }) : [], uu(function (e) {
          for (var u = -1; ++u < r;) {
            var i = t[u];
            if (n(i[0], this, e)) return n(i[1], this, e);
          }
        });
      }
      function Ea(n) {
        return Nr(Fr(n, an));
      }
      function Sa(n) {
        return function () {
          return n;
        };
      }
      function Wa(n, t) {
        return null == n || n !== n ? t : n;
      }
      function La(n) {
        return n;
      }
      function Ca(n) {
        return De("function" == typeof n ? n : Fr(n, an));
      }
      function Ua(n) {
        return qe(Fr(n, an));
      }
      function Ba(n, t) {
        return Ze(n, Fr(t, an));
      }
      function Ta(n, t, e) {
        var u = Pc(t),
          i = fe(t, u);
        null != e || fc(t) && (i.length || !u.length) || (e = t, t = n, n = this, i = fe(t, Pc(t)));
        var o = !(fc(e) && "chain" in e && !e.chain),
          f = uc(n);
        return r(i, function (r) {
          var e = t[r];
          n[r] = e, f && (n.prototype[r] = function () {
            var t = this.__chain__;
            if (o || t) {
              var r = n(this.__wrapped__);
              return (r.__actions__ = Tu(this.__actions__)).push({
                func: e,
                args: arguments,
                thisArg: n
              }), r.__chain__ = t, r;
            }
            return e.apply(n, a([this.value()], arguments));
          });
        }), n;
      }
      function $a() {
        return re._ === this && (re._ = Al), this;
      }
      function Da() {}
      function Ma(n) {
        return n = kc(n), uu(function (t) {
          return Ge(t, n);
        });
      }
      function Fa(n) {
        return Bi(n) ? m(no(n)) : Qe(n);
      }
      function Na(n) {
        return function (t) {
          return null == n ? X : _e(n, t);
        };
      }
      function Pa() {
        return [];
      }
      function qa() {
        return !1;
      }
      function Za() {
        return {};
      }
      function Ka() {
        return "";
      }
      function Va() {
        return !0;
      }
      function Ga(n, t) {
        if (n = kc(n), n < 1 || n > Wn) return [];
        var r = Un,
          e = Hl(n, Un);
        t = mi(t), n -= Un;
        for (var u = O(e, t); ++r < n;) t(r);
        return u;
      }
      function Ha(n) {
        return bh(n) ? c(n, no) : bc(n) ? [n] : Tu(Cs(Ec(n)));
      }
      function Ja(n) {
        var t = ++wl;
        return Ec(n) + t;
      }
      function Ya(n) {
        return n && n.length ? Yr(n, La, me) : X;
      }
      function Qa(n, t) {
        return n && n.length ? Yr(n, mi(t, 2), me) : X;
      }
      function Xa(n) {
        return w(n, La);
      }
      function nl(n, t) {
        return w(n, mi(t, 2));
      }
      function tl(n) {
        return n && n.length ? Yr(n, La, Ne) : X;
      }
      function rl(n, t) {
        return n && n.length ? Yr(n, mi(t, 2), Ne) : X;
      }
      function el(n) {
        return n && n.length ? k(n, La) : 0;
      }
      function ul(n, t) {
        return n && n.length ? k(n, mi(t, 2)) : 0;
      }
      x = null == x ? re : be.defaults(re.Object(), x, be.pick(re, qr));
      var il = x.Array,
        ol = x.Date,
        fl = x.Error,
        cl = x.Function,
        al = x.Math,
        ll = x.Object,
        sl = x.RegExp,
        hl = x.String,
        pl = x.TypeError,
        _l = il.prototype,
        vl = cl.prototype,
        gl = ll.prototype,
        yl = x["__core-js_shared__"],
        dl = vl.toString,
        bl = gl.hasOwnProperty,
        wl = 0,
        ml = function () {
          var n = /[^.]+$/.exec(yl && yl.keys && yl.keys.IE_PROTO || "");
          return n ? "Symbol(src)_1." + n : "";
        }(),
        xl = gl.toString,
        jl = dl.call(ll),
        Al = re._,
        kl = sl("^" + dl.call(bl).replace(St, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"),
        Ol = ie ? x.Buffer : X,
        Il = x.Symbol,
        Rl = x.Uint8Array,
        zl = Ol ? Ol.allocUnsafe : X,
        El = F(ll.getPrototypeOf, ll),
        Sl = ll.create,
        Wl = gl.propertyIsEnumerable,
        Ll = _l.splice,
        Cl = Il ? Il.isConcatSpreadable : X,
        Ul = Il ? Il.iterator : X,
        Bl = Il ? Il.toStringTag : X,
        Tl = function () {
          try {
            var n = Ai(ll, "defineProperty");
            return n({}, "", {}), n;
          } catch (n) {}
        }(),
        $l = x.clearTimeout !== re.clearTimeout && x.clearTimeout,
        Dl = ol && ol.now !== re.Date.now && ol.now,
        Ml = x.setTimeout !== re.setTimeout && x.setTimeout,
        Fl = al.ceil,
        Nl = al.floor,
        Pl = ll.getOwnPropertySymbols,
        ql = Ol ? Ol.isBuffer : X,
        Zl = x.isFinite,
        Kl = _l.join,
        Vl = F(ll.keys, ll),
        Gl = al.max,
        Hl = al.min,
        Jl = ol.now,
        Yl = x.parseInt,
        Ql = al.random,
        Xl = _l.reverse,
        ns = Ai(x, "DataView"),
        ts = Ai(x, "Map"),
        rs = Ai(x, "Promise"),
        es = Ai(x, "Set"),
        us = Ai(x, "WeakMap"),
        is = Ai(ll, "create"),
        os = us && new us(),
        fs = {},
        cs = to(ns),
        as = to(ts),
        ls = to(rs),
        ss = to(es),
        hs = to(us),
        ps = Il ? Il.prototype : X,
        _s = ps ? ps.valueOf : X,
        vs = ps ? ps.toString : X,
        gs = function () {
          function n() {}
          return function (t) {
            if (!fc(t)) return {};
            if (Sl) return Sl(t);
            n.prototype = t;
            var r = new n();
            return n.prototype = X, r;
          };
        }();
      Z.templateSettings = {
        escape: kt,
        evaluate: Ot,
        interpolate: It,
        variable: "",
        imports: {
          _: Z
        }
      }, Z.prototype = J.prototype, Z.prototype.constructor = Z, Y.prototype = gs(J.prototype), Y.prototype.constructor = Y, Ct.prototype = gs(J.prototype), Ct.prototype.constructor = Ct, Xt.prototype.clear = nr, Xt.prototype["delete"] = tr, Xt.prototype.get = rr, Xt.prototype.has = er, Xt.prototype.set = ur, ir.prototype.clear = or, ir.prototype["delete"] = fr, ir.prototype.get = cr, ir.prototype.has = ar, ir.prototype.set = lr, sr.prototype.clear = hr, sr.prototype["delete"] = pr, sr.prototype.get = _r, sr.prototype.has = vr, sr.prototype.set = gr, yr.prototype.add = yr.prototype.push = dr, yr.prototype.has = br, wr.prototype.clear = mr, wr.prototype["delete"] = xr, wr.prototype.get = jr, wr.prototype.has = Ar, wr.prototype.set = kr;
      var ys = Pu(ue),
        ds = Pu(oe, !0),
        bs = qu(),
        ws = qu(!0),
        ms = os ? function (n, t) {
          return os.set(n, t), n;
        } : La,
        xs = Tl ? function (n, t) {
          return Tl(n, "toString", {
            configurable: !0,
            enumerable: !1,
            value: Sa(t),
            writable: !0
          });
        } : La,
        js = uu,
        As = $l || function (n) {
          return re.clearTimeout(n);
        },
        ks = es && 1 / P(new es([, -0]))[1] == Sn ? function (n) {
          return new es(n);
        } : Da,
        Os = os ? function (n) {
          return os.get(n);
        } : Da,
        Is = Pl ? function (n) {
          return null == n ? [] : (n = ll(n), i(Pl(n), function (t) {
            return Wl.call(n, t);
          }));
        } : Pa,
        Rs = Pl ? function (n) {
          for (var t = []; n;) a(t, Is(n)), n = El(n);
          return t;
        } : Pa,
        zs = we;
      (ns && zs(new ns(new ArrayBuffer(1))) != ct || ts && zs(new ts()) != Gn || rs && zs(rs.resolve()) != Qn || es && zs(new es()) != tt || us && zs(new us()) != it) && (zs = function zs(n) {
        var t = we(n),
          r = t == Yn ? n.constructor : X,
          e = r ? to(r) : "";
        if (e) switch (e) {
          case cs:
            return ct;
          case as:
            return Gn;
          case ls:
            return Qn;
          case ss:
            return tt;
          case hs:
            return it;
        }
        return t;
      });
      var Es = yl ? uc : qa,
        Ss = Qi(ms),
        Ws = Ml || function (n, t) {
          return re.setTimeout(n, t);
        },
        Ls = Qi(xs),
        Cs = Pi(function (n) {
          var t = [];
          return 46 === n.charCodeAt(0) && t.push(""), n.replace(Et, function (n, r, e, u) {
            t.push(e ? u.replace(Mt, "$1") : r || n);
          }), t;
        }),
        Us = uu(function (n, t) {
          return Jf(n) ? Hr(n, ee(t, 1, Jf, !0)) : [];
        }),
        Bs = uu(function (n, t) {
          var r = jo(t);
          return Jf(r) && (r = X), Jf(n) ? Hr(n, ee(t, 1, Jf, !0), mi(r, 2)) : [];
        }),
        Ts = uu(function (n, t) {
          var r = jo(t);
          return Jf(r) && (r = X), Jf(n) ? Hr(n, ee(t, 1, Jf, !0), X, r) : [];
        }),
        $s = uu(function (n) {
          var t = c(n, ju);
          return t.length && t[0] === n[0] ? ke(t) : [];
        }),
        Ds = uu(function (n) {
          var t = jo(n),
            r = c(n, ju);
          return t === jo(r) ? t = X : r.pop(), r.length && r[0] === n[0] ? ke(r, mi(t, 2)) : [];
        }),
        Ms = uu(function (n) {
          var t = jo(n),
            r = c(n, ju);
          return t = "function" == typeof t ? t : X, t && r.pop(), r.length && r[0] === n[0] ? ke(r, X, t) : [];
        }),
        Fs = uu(Oo),
        Ns = gi(function (n, t) {
          var r = null == n ? 0 : n.length,
            e = Tr(n, t);
          return nu(n, c(t, function (n) {
            return Ci(n, r) ? +n : n;
          }).sort(Lu)), e;
        }),
        Ps = uu(function (n) {
          return gu(ee(n, 1, Jf, !0));
        }),
        qs = uu(function (n) {
          var t = jo(n);
          return Jf(t) && (t = X), gu(ee(n, 1, Jf, !0), mi(t, 2));
        }),
        Zs = uu(function (n) {
          var t = jo(n);
          return t = "function" == typeof t ? t : X, gu(ee(n, 1, Jf, !0), X, t);
        }),
        Ks = uu(function (n, t) {
          return Jf(n) ? Hr(n, t) : [];
        }),
        Vs = uu(function (n) {
          return mu(i(n, Jf));
        }),
        Gs = uu(function (n) {
          var t = jo(n);
          return Jf(t) && (t = X), mu(i(n, Jf), mi(t, 2));
        }),
        Hs = uu(function (n) {
          var t = jo(n);
          return t = "function" == typeof t ? t : X, mu(i(n, Jf), X, t);
        }),
        Js = uu(Go),
        Ys = uu(function (n) {
          var t = n.length,
            r = t > 1 ? n[t - 1] : X;
          return r = "function" == typeof r ? (n.pop(), r) : X, Ho(n, r);
        }),
        Qs = gi(function (n) {
          var t = n.length,
            r = t ? n[0] : 0,
            e = this.__wrapped__,
            u = function u(t) {
              return Tr(t, n);
            };
          return !(t > 1 || this.__actions__.length) && e instanceof Ct && Ci(r) ? (e = e.slice(r, +r + (t ? 1 : 0)), e.__actions__.push({
            func: nf,
            args: [u],
            thisArg: X
          }), new Y(e, this.__chain__).thru(function (n) {
            return t && !n.length && n.push(X), n;
          })) : this.thru(u);
        }),
        Xs = Fu(function (n, t, r) {
          bl.call(n, r) ? ++n[r] : Br(n, r, 1);
        }),
        nh = Ju(ho),
        th = Ju(po),
        rh = Fu(function (n, t, r) {
          bl.call(n, r) ? n[r].push(t) : Br(n, r, [t]);
        }),
        eh = uu(function (t, r, e) {
          var u = -1,
            i = "function" == typeof r,
            o = Hf(t) ? il(t.length) : [];
          return ys(t, function (t) {
            o[++u] = i ? n(r, t, e) : Ie(t, r, e);
          }), o;
        }),
        uh = Fu(function (n, t, r) {
          Br(n, r, t);
        }),
        ih = Fu(function (n, t, r) {
          n[r ? 0 : 1].push(t);
        }, function () {
          return [[], []];
        }),
        oh = uu(function (n, t) {
          if (null == n) return [];
          var r = t.length;
          return r > 1 && Ui(n, t[0], t[1]) ? t = [] : r > 2 && Ui(t[0], t[1], t[2]) && (t = [t[0]]), He(n, ee(t, 1), []);
        }),
        fh = Dl || function () {
          return re.Date.now();
        },
        ch = uu(function (n, t, r) {
          var e = _n;
          if (r.length) {
            var u = N(r, wi(ch));
            e |= bn;
          }
          return ai(n, e, t, r, u);
        }),
        ah = uu(function (n, t, r) {
          var e = _n | vn;
          if (r.length) {
            var u = N(r, wi(ah));
            e |= bn;
          }
          return ai(t, e, n, r, u);
        }),
        lh = uu(function (n, t) {
          return Gr(n, 1, t);
        }),
        sh = uu(function (n, t, r) {
          return Gr(n, Ic(t) || 0, r);
        });
      Cf.Cache = sr;
      var hh = js(function (t, r) {
          r = 1 == r.length && bh(r[0]) ? c(r[0], z(mi())) : c(ee(r, 1), z(mi()));
          var e = r.length;
          return uu(function (u) {
            for (var i = -1, o = Hl(u.length, e); ++i < o;) u[i] = r[i].call(this, u[i]);
            return n(t, this, u);
          });
        }),
        ph = uu(function (n, t) {
          return ai(n, bn, X, t, N(t, wi(ph)));
        }),
        _h = uu(function (n, t) {
          return ai(n, wn, X, t, N(t, wi(_h)));
        }),
        vh = gi(function (n, t) {
          return ai(n, xn, X, X, X, t);
        }),
        gh = ii(me),
        yh = ii(function (n, t) {
          return n >= t;
        }),
        dh = Re(function () {
          return arguments;
        }()) ? Re : function (n) {
          return cc(n) && bl.call(n, "callee") && !Wl.call(n, "callee");
        },
        bh = il.isArray,
        wh = ce ? z(ce) : ze,
        mh = ql || qa,
        xh = ae ? z(ae) : Ee,
        jh = le ? z(le) : Le,
        Ah = se ? z(se) : Be,
        kh = he ? z(he) : Te,
        Oh = pe ? z(pe) : $e,
        Ih = ii(Ne),
        Rh = ii(function (n, t) {
          return n <= t;
        }),
        zh = Nu(function (n, t) {
          if (Mi(t) || Hf(t)) return $u(t, Pc(t), n), X;
          for (var r in t) bl.call(t, r) && Sr(n, r, t[r]);
        }),
        Eh = Nu(function (n, t) {
          $u(t, qc(t), n);
        }),
        Sh = Nu(function (n, t, r, e) {
          $u(t, qc(t), n, e);
        }),
        Wh = Nu(function (n, t, r, e) {
          $u(t, Pc(t), n, e);
        }),
        Lh = gi(Tr),
        Ch = uu(function (n, t) {
          n = ll(n);
          var r = -1,
            e = t.length,
            u = e > 2 ? t[2] : X;
          for (u && Ui(t[0], t[1], u) && (e = 1); ++r < e;) for (var i = t[r], o = qc(i), f = -1, c = o.length; ++f < c;) {
            var a = o[f],
              l = n[a];
            (l === X || Gf(l, gl[a]) && !bl.call(n, a)) && (n[a] = i[a]);
          }
          return n;
        }),
        Uh = uu(function (t) {
          return t.push(X, si), n(Mh, X, t);
        }),
        Bh = Xu(function (n, t, r) {
          null != t && "function" != typeof t.toString && (t = xl.call(t)), n[t] = r;
        }, Sa(La)),
        Th = Xu(function (n, t, r) {
          null != t && "function" != typeof t.toString && (t = xl.call(t)), bl.call(n, t) ? n[t].push(r) : n[t] = [r];
        }, mi),
        $h = uu(Ie),
        Dh = Nu(function (n, t, r) {
          Ke(n, t, r);
        }),
        Mh = Nu(function (n, t, r, e) {
          Ke(n, t, r, e);
        }),
        Fh = gi(function (n, t) {
          var r = {};
          if (null == n) return r;
          var e = !1;
          t = c(t, function (t) {
            return t = ku(t, n), e || (e = t.length > 1), t;
          }), $u(n, di(n), r), e && (r = Fr(r, an | ln | sn, hi));
          for (var u = t.length; u--;) yu(r, t[u]);
          return r;
        }),
        Nh = gi(function (n, t) {
          return null == n ? {} : Je(n, t);
        }),
        Ph = ci(Pc),
        qh = ci(qc),
        Zh = Vu(function (n, t, r) {
          return t = t.toLowerCase(), n + (r ? fa(t) : t);
        }),
        Kh = Vu(function (n, t, r) {
          return n + (r ? "-" : "") + t.toLowerCase();
        }),
        Vh = Vu(function (n, t, r) {
          return n + (r ? " " : "") + t.toLowerCase();
        }),
        Gh = Ku("toLowerCase"),
        Hh = Vu(function (n, t, r) {
          return n + (r ? "_" : "") + t.toLowerCase();
        }),
        Jh = Vu(function (n, t, r) {
          return n + (r ? " " : "") + Qh(t);
        }),
        Yh = Vu(function (n, t, r) {
          return n + (r ? " " : "") + t.toUpperCase();
        }),
        Qh = Ku("toUpperCase"),
        Xh = uu(function (t, r) {
          try {
            return n(t, X, r);
          } catch (n) {
            return rc(n) ? n : new fl(n);
          }
        }),
        np = gi(function (n, t) {
          return r(t, function (t) {
            t = no(t), Br(n, t, ch(n[t], n));
          }), n;
        }),
        tp = Yu(),
        rp = Yu(!0),
        ep = uu(function (n, t) {
          return function (r) {
            return Ie(r, n, t);
          };
        }),
        up = uu(function (n, t) {
          return function (r) {
            return Ie(n, r, t);
          };
        }),
        ip = ti(c),
        op = ti(u),
        fp = ti(h),
        cp = ui(),
        ap = ui(!0),
        lp = ni(function (n, t) {
          return n + t;
        }, 0),
        sp = fi("ceil"),
        hp = ni(function (n, t) {
          return n / t;
        }, 1),
        pp = fi("floor"),
        _p = ni(function (n, t) {
          return n * t;
        }, 1),
        vp = fi("round"),
        gp = ni(function (n, t) {
          return n - t;
        }, 0);
      return Z.after = If, Z.ary = Rf, Z.assign = zh, Z.assignIn = Eh, Z.assignInWith = Sh, Z.assignWith = Wh, Z.at = Lh, Z.before = zf, Z.bind = ch, Z.bindAll = np, Z.bindKey = ah, Z.castArray = Nf, Z.chain = Qo, Z.chunk = uo, Z.compact = io, Z.concat = oo, Z.cond = za, Z.conforms = Ea, Z.constant = Sa, Z.countBy = Xs, Z.create = Sc, Z.curry = Ef, Z.curryRight = Sf, Z.debounce = Wf, Z.defaults = Ch, Z.defaultsDeep = Uh, Z.defer = lh, Z.delay = sh, Z.difference = Us, Z.differenceBy = Bs, Z.differenceWith = Ts, Z.drop = fo, Z.dropRight = co, Z.dropRightWhile = ao, Z.dropWhile = lo, Z.fill = so, Z.filter = lf, Z.flatMap = sf, Z.flatMapDeep = hf, Z.flatMapDepth = pf, Z.flatten = _o, Z.flattenDeep = vo, Z.flattenDepth = go, Z.flip = Lf, Z.flow = tp, Z.flowRight = rp, Z.fromPairs = yo, Z.functions = $c, Z.functionsIn = Dc, Z.groupBy = rh, Z.initial = mo, Z.intersection = $s, Z.intersectionBy = Ds, Z.intersectionWith = Ms, Z.invert = Bh, Z.invertBy = Th, Z.invokeMap = eh, Z.iteratee = Ca, Z.keyBy = uh, Z.keys = Pc, Z.keysIn = qc, Z.map = yf, Z.mapKeys = Zc, Z.mapValues = Kc, Z.matches = Ua, Z.matchesProperty = Ba, Z.memoize = Cf, Z.merge = Dh, Z.mergeWith = Mh, Z.method = ep, Z.methodOf = up, Z.mixin = Ta, Z.negate = Uf, Z.nthArg = Ma, Z.omit = Fh, Z.omitBy = Vc, Z.once = Bf, Z.orderBy = df, Z.over = ip, Z.overArgs = hh, Z.overEvery = op, Z.overSome = fp, Z.partial = ph, Z.partialRight = _h, Z.partition = ih, Z.pick = Nh, Z.pickBy = Gc, Z.property = Fa, Z.propertyOf = Na, Z.pull = Fs, Z.pullAll = Oo, Z.pullAllBy = Io, Z.pullAllWith = Ro, Z.pullAt = Ns, Z.range = cp, Z.rangeRight = ap, Z.rearg = vh, Z.reject = mf, Z.remove = zo, Z.rest = Tf, Z.reverse = Eo, Z.sampleSize = jf, Z.set = Jc, Z.setWith = Yc, Z.shuffle = Af, Z.slice = So, Z.sortBy = oh, Z.sortedUniq = $o, Z.sortedUniqBy = Do, Z.split = da, Z.spread = $f, Z.tail = Mo, Z.take = Fo, Z.takeRight = No, Z.takeRightWhile = Po, Z.takeWhile = qo, Z.tap = Xo, Z.throttle = Df, Z.thru = nf, Z.toArray = jc, Z.toPairs = Ph, Z.toPairsIn = qh, Z.toPath = Ha, Z.toPlainObject = Rc, Z.transform = Qc, Z.unary = Mf, Z.union = Ps, Z.unionBy = qs, Z.unionWith = Zs, Z.uniq = Zo, Z.uniqBy = Ko, Z.uniqWith = Vo, Z.unset = Xc, Z.unzip = Go, Z.unzipWith = Ho, Z.update = na, Z.updateWith = ta, Z.values = ra, Z.valuesIn = ea, Z.without = Ks, Z.words = Ra, Z.wrap = Ff, Z.xor = Vs, Z.xorBy = Gs, Z.xorWith = Hs, Z.zip = Js, Z.zipObject = Jo, Z.zipObjectDeep = Yo, Z.zipWith = Ys, Z.entries = Ph, Z.entriesIn = qh, Z.extend = Eh, Z.extendWith = Sh, Ta(Z, Z), Z.add = lp, Z.attempt = Xh, Z.camelCase = Zh, Z.capitalize = fa, Z.ceil = sp, Z.clamp = ua, Z.clone = Pf, Z.cloneDeep = Zf, Z.cloneDeepWith = Kf, Z.cloneWith = qf, Z.conformsTo = Vf, Z.deburr = ca, Z.defaultTo = Wa, Z.divide = hp, Z.endsWith = aa, Z.eq = Gf, Z.escape = la, Z.escapeRegExp = sa, Z.every = af, Z.find = nh, Z.findIndex = ho, Z.findKey = Wc, Z.findLast = th, Z.findLastIndex = po, Z.findLastKey = Lc, Z.floor = pp, Z.forEach = _f, Z.forEachRight = vf, Z.forIn = Cc, Z.forInRight = Uc, Z.forOwn = Bc, Z.forOwnRight = Tc, Z.get = Mc, Z.gt = gh, Z.gte = yh, Z.has = Fc, Z.hasIn = Nc, Z.head = bo, Z.identity = La, Z.includes = gf, Z.indexOf = wo, Z.inRange = ia, Z.invoke = $h, Z.isArguments = dh, Z.isArray = bh, Z.isArrayBuffer = wh, Z.isArrayLike = Hf, Z.isArrayLikeObject = Jf, Z.isBoolean = Yf, Z.isBuffer = mh, Z.isDate = xh, Z.isElement = Qf, Z.isEmpty = Xf, Z.isEqual = nc, Z.isEqualWith = tc, Z.isError = rc, Z.isFinite = ec, Z.isFunction = uc, Z.isInteger = ic, Z.isLength = oc, Z.isMap = jh, Z.isMatch = ac, Z.isMatchWith = lc, Z.isNaN = sc, Z.isNative = hc, Z.isNil = _c, Z.isNull = pc, Z.isNumber = vc, Z.isObject = fc, Z.isObjectLike = cc, Z.isPlainObject = gc, Z.isRegExp = Ah, Z.isSafeInteger = yc, Z.isSet = kh, Z.isString = dc, Z.isSymbol = bc, Z.isTypedArray = Oh, Z.isUndefined = wc, Z.isWeakMap = mc, Z.isWeakSet = xc, Z.join = xo, Z.kebabCase = Kh, Z.last = jo, Z.lastIndexOf = Ao, Z.lowerCase = Vh, Z.lowerFirst = Gh, Z.lt = Ih, Z.lte = Rh, Z.max = Ya, Z.maxBy = Qa, Z.mean = Xa, Z.meanBy = nl, Z.min = tl, Z.minBy = rl, Z.stubArray = Pa, Z.stubFalse = qa, Z.stubObject = Za, Z.stubString = Ka, Z.stubTrue = Va, Z.multiply = _p, Z.nth = ko, Z.noConflict = $a, Z.noop = Da, Z.now = fh, Z.pad = ha, Z.padEnd = pa, Z.padStart = _a, Z.parseInt = va, Z.random = oa, Z.reduce = bf, Z.reduceRight = wf, Z.repeat = ga, Z.replace = ya, Z.result = Hc, Z.round = vp, Z.runInContext = p, Z.sample = xf, Z.size = kf, Z.snakeCase = Hh, Z.some = Of, Z.sortedIndex = Wo, Z.sortedIndexBy = Lo, Z.sortedIndexOf = Co, Z.sortedLastIndex = Uo, Z.sortedLastIndexBy = Bo, Z.sortedLastIndexOf = To, Z.startCase = Jh, Z.startsWith = ba, Z.subtract = gp, Z.sum = el, Z.sumBy = ul, Z.template = wa, Z.times = Ga, Z.toFinite = Ac, Z.toInteger = kc, Z.toLength = Oc, Z.toLower = ma, Z.toNumber = Ic, Z.toSafeInteger = zc, Z.toString = Ec, Z.toUpper = xa, Z.trim = ja, Z.trimEnd = Aa, Z.trimStart = ka, Z.truncate = Oa, Z.unescape = Ia, Z.uniqueId = Ja, Z.upperCase = Yh, Z.upperFirst = Qh, Z.each = _f, Z.eachRight = vf, Z.first = bo, Ta(Z, function () {
        var n = {};
        return ue(Z, function (t, r) {
          bl.call(Z.prototype, r) || (n[r] = t);
        }), n;
      }(), {
        chain: !1
      }), Z.VERSION = nn, r(["bind", "bindKey", "curry", "curryRight", "partial", "partialRight"], function (n) {
        Z[n].placeholder = Z;
      }), r(["drop", "take"], function (n, t) {
        Ct.prototype[n] = function (r) {
          r = r === X ? 1 : Gl(kc(r), 0);
          var e = this.__filtered__ && !t ? new Ct(this) : this.clone();
          return e.__filtered__ ? e.__takeCount__ = Hl(r, e.__takeCount__) : e.__views__.push({
            size: Hl(r, Un),
            type: n + (e.__dir__ < 0 ? "Right" : "")
          }), e;
        }, Ct.prototype[n + "Right"] = function (t) {
          return this.reverse()[n](t).reverse();
        };
      }), r(["filter", "map", "takeWhile"], function (n, t) {
        var r = t + 1,
          e = r == Rn || r == En;
        Ct.prototype[n] = function (n) {
          var t = this.clone();
          return t.__iteratees__.push({
            iteratee: mi(n, 3),
            type: r
          }), t.__filtered__ = t.__filtered__ || e, t;
        };
      }), r(["head", "last"], function (n, t) {
        var r = "take" + (t ? "Right" : "");
        Ct.prototype[n] = function () {
          return this[r](1).value()[0];
        };
      }), r(["initial", "tail"], function (n, t) {
        var r = "drop" + (t ? "" : "Right");
        Ct.prototype[n] = function () {
          return this.__filtered__ ? new Ct(this) : this[r](1);
        };
      }), Ct.prototype.compact = function () {
        return this.filter(La);
      }, Ct.prototype.find = function (n) {
        return this.filter(n).head();
      }, Ct.prototype.findLast = function (n) {
        return this.reverse().find(n);
      }, Ct.prototype.invokeMap = uu(function (n, t) {
        return "function" == typeof n ? new Ct(this) : this.map(function (r) {
          return Ie(r, n, t);
        });
      }), Ct.prototype.reject = function (n) {
        return this.filter(Uf(mi(n)));
      }, Ct.prototype.slice = function (n, t) {
        n = kc(n);
        var r = this;
        return r.__filtered__ && (n > 0 || t < 0) ? new Ct(r) : (n < 0 ? r = r.takeRight(-n) : n && (r = r.drop(n)), t !== X && (t = kc(t), r = t < 0 ? r.dropRight(-t) : r.take(t - n)), r);
      }, Ct.prototype.takeRightWhile = function (n) {
        return this.reverse().takeWhile(n).reverse();
      }, Ct.prototype.toArray = function () {
        return this.take(Un);
      }, ue(Ct.prototype, function (n, t) {
        var r = /^(?:filter|find|map|reject)|While$/.test(t),
          e = /^(?:head|last)$/.test(t),
          u = Z[e ? "take" + ("last" == t ? "Right" : "") : t],
          i = e || /^find/.test(t);
        u && (Z.prototype[t] = function () {
          var t = this.__wrapped__,
            o = e ? [1] : arguments,
            f = t instanceof Ct,
            c = o[0],
            l = f || bh(t),
            s = function s(n) {
              var t = u.apply(Z, a([n], o));
              return e && h ? t[0] : t;
            };
          l && r && "function" == typeof c && 1 != c.length && (f = l = !1);
          var h = this.__chain__,
            p = !!this.__actions__.length,
            _ = i && !h,
            v = f && !p;
          if (!i && l) {
            t = v ? t : new Ct(this);
            var g = n.apply(t, o);
            return g.__actions__.push({
              func: nf,
              args: [s],
              thisArg: X
            }), new Y(g, h);
          }
          return _ && v ? n.apply(this, o) : (g = this.thru(s), _ ? e ? g.value()[0] : g.value() : g);
        });
      }), r(["pop", "push", "shift", "sort", "splice", "unshift"], function (n) {
        var t = _l[n],
          r = /^(?:push|sort|unshift)$/.test(n) ? "tap" : "thru",
          e = /^(?:pop|shift)$/.test(n);
        Z.prototype[n] = function () {
          var n = arguments;
          if (e && !this.__chain__) {
            var u = this.value();
            return t.apply(bh(u) ? u : [], n);
          }
          return this[r](function (r) {
            return t.apply(bh(r) ? r : [], n);
          });
        };
      }), ue(Ct.prototype, function (n, t) {
        var r = Z[t];
        if (r) {
          var e = r.name + "";
          bl.call(fs, e) || (fs[e] = []), fs[e].push({
            name: t,
            func: r
          });
        }
      }), fs[Qu(X, vn).name] = [{
        name: "wrapper",
        func: X
      }], Ct.prototype.clone = $t, Ct.prototype.reverse = Yt, Ct.prototype.value = Qt, Z.prototype.at = Qs, Z.prototype.chain = tf, Z.prototype.commit = rf, Z.prototype.next = ef, Z.prototype.plant = of, Z.prototype.reverse = ff, Z.prototype.toJSON = Z.prototype.valueOf = Z.prototype.value = cf, Z.prototype.first = Z.prototype.head, Ul && (Z.prototype[Ul] = uf), Z;
    },
    be = de();
   true && "object" == _typeof(__webpack_require__.amdO) && __webpack_require__.amdO ? (re._ = be, !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {
    return be;
  }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__))) : ue ? ((ue.exports = be)._ = be, ee._ = be) : re._ = be;
}).call(this);

/***/ }),

/***/ "./public/backend/vendors/lazyload/lazyload.js":
/*!*****************************************************!*\
  !*** ./public/backend/vendors/lazyload/lazyload.js ***!
  \*****************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/*!
 * Lazy Load - JavaScript plugin for lazy loading images
 *
 * Copyright (c) 2007-2019 Mika Tuupola
 *
 * Licensed under the MIT license:
 *   http://www.opensource.org/licenses/mit-license.php
 *
 * Project home:
 *   https://appelsiini.net/projects/lazyload
 *
 * Version: 2.0.0-rc.2
 *
 */

(function (root, factory) {
  if (( false ? 0 : _typeof(exports)) === "object") {
    module.exports = factory(root);
  } else if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(typeof __webpack_require__.g !== "undefined" ? __webpack_require__.g : this.window || this.global, function (root) {
  "use strict";

  if (true) {
    root = window;
  }
  var defaults = {
    src: "data-src",
    srcset: "data-srcset",
    selector: ".lazyload",
    root: null,
    rootMargin: "0px",
    threshold: 0
  };

  /**
  * Merge two or more objects. Returns a new object.
  * @private
  * @param {Boolean}  deep     If true, do a deep (or recursive) merge [optional]
  * @param {Object}   objects  The objects to merge together
  * @returns {Object}          Merged values of defaults and options
  */
  var extend = function extend() {
    var extended = {};
    var deep = false;
    var i = 0;
    var length = arguments.length;

    /* Check if a deep merge */
    if (Object.prototype.toString.call(arguments[0]) === "[object Boolean]") {
      deep = arguments[0];
      i++;
    }

    /* Merge the object into the extended object */
    var merge = function merge(obj) {
      for (var prop in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, prop)) {
          /* If deep merge and property is an object, merge properties */
          if (deep && Object.prototype.toString.call(obj[prop]) === "[object Object]") {
            extended[prop] = extend(true, extended[prop], obj[prop]);
          } else {
            extended[prop] = obj[prop];
          }
        }
      }
    };

    /* Loop through each object and conduct a merge */
    for (; i < length; i++) {
      var obj = arguments[i];
      merge(obj);
    }
    return extended;
  };
  function LazyLoad(images, options) {
    this.settings = extend(defaults, options || {});
    this.images = images || document.querySelectorAll(this.settings.selector);
    this.observer = null;
    this.init();
  }
  LazyLoad.prototype = {
    init: function init() {
      /* Without observers load everything and bail out early. */
      if (!root.IntersectionObserver) {
        this.loadImages();
        return;
      }
      var self = this;
      var observerConfig = {
        root: this.settings.root,
        rootMargin: this.settings.rootMargin,
        threshold: [this.settings.threshold]
      };
      this.observer = new IntersectionObserver(function (entries) {
        Array.prototype.forEach.call(entries, function (entry) {
          if (entry.isIntersecting) {
            self.observer.unobserve(entry.target);
            var src = entry.target.getAttribute(self.settings.src);
            var srcset = entry.target.getAttribute(self.settings.srcset);
            if ("img" === entry.target.tagName.toLowerCase()) {
              if (src) {
                entry.target.src = src;
              }
              if (srcset) {
                entry.target.srcset = srcset;
              }
            } else {
              entry.target.style.backgroundImage = "url(" + src + ")";
            }
          }
        });
      }, observerConfig);
      Array.prototype.forEach.call(this.images, function (image) {
        self.observer.observe(image);
      });
    },
    loadAndDestroy: function loadAndDestroy() {
      if (!this.settings) {
        return;
      }
      this.loadImages();
      this.destroy();
    },
    loadImages: function loadImages() {
      if (!this.settings) {
        return;
      }
      var self = this;
      Array.prototype.forEach.call(this.images, function (image) {
        var src = image.getAttribute(self.settings.src);
        var srcset = image.getAttribute(self.settings.srcset);
        if ("img" === image.tagName.toLowerCase()) {
          if (src) {
            image.src = src;
          }
          if (srcset) {
            image.srcset = srcset;
          }
        } else {
          image.style.backgroundImage = "url('" + src + "')";
        }
      });
    },
    destroy: function destroy() {
      if (!this.settings) {
        return;
      }
      this.observer.disconnect();
      this.settings = null;
    }
  };
  root.lazyload = function (images, options) {
    return new LazyLoad(images, options);
  };
  if (root.jQuery) {
    var $ = root.jQuery;
    $.fn.lazyload = function (options) {
      options = options || {};
      options.attribute = options.attribute || "data-src";
      new LazyLoad($.makeArray(this), options);
      return this;
    };
  }
  return LazyLoad;
});

/***/ }),

/***/ "./public/frontend/amazy/js/barfiller.js":
/*!***********************************************!*\
  !*** ./public/frontend/amazy/js/barfiller.js ***!
  \***********************************************/
/***/ (() => {

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/*
* File: jquery.barfiller.js
* Version: 1.0.1
* Description: A plugin that fills bars with a percentage you set.
* Author: 9bit Studios
* Copyright 2012, 9bit Studios
* http://www.9bitstudios.com
* Free to use and abuse under the MIT license.
* http://www.opensource.org/licenses/mit-license.php
*/

(function ($) {
  $.fn.barfiller = function (options) {
    var defaults = $.extend({
      barColor: '#16b597',
      tooltip: true,
      duration: 1000,
      animateOnResize: true,
      symbol: "%"
    }, options);

    /******************************
    Private Variables
    *******************************/

    var object = $(this);
    var settings = $.extend(defaults, options);
    var barWidth = object.width();
    var fill = object.find('.fill');
    var toolTip = object.find('.tip');
    var fillPercentage = fill.attr('data-percentage');
    var resizeTimeout;
    var transitionSupport = false;
    var transitionPrefix;

    /******************************
    Public Methods
    *******************************/

    var methods = {
      init: function init() {
        return this.each(function () {
          if (methods.getTransitionSupport()) {
            transitionSupport = true;
            transitionPrefix = methods.getTransitionPrefix();
          }
          methods.appendHTML();
          methods.setEventHandlers();
          methods.initializeItems();
        });
      },
      /******************************
      Append HTML
      *******************************/

      appendHTML: function appendHTML() {
        fill.css('background', settings.barColor);
        if (!settings.tooltip) {
          toolTip.css('display', 'none');
        }
        toolTip.text(fillPercentage + settings.symbol);
      },
      /******************************
      Set Event Handlers
      *******************************/
      setEventHandlers: function setEventHandlers() {
        if (settings.animateOnResize) {
          $(window).on("resize", function (event) {
            clearTimeout(resizeTimeout);
            resizeTimeout = setTimeout(function () {
              methods.refill();
            }, 300);
          });
        }
      },
      /******************************
      Initialize
      *******************************/

      initializeItems: function initializeItems() {
        var pctWidth = methods.calculateFill(fillPercentage);
        object.find('.tipWrap').css({
          display: 'inline'
        });
        if (transitionSupport) methods.transitionFill(pctWidth);else methods.animateFill(pctWidth);
      },
      getTransitionSupport: function getTransitionSupport() {
        var thisBody = document.body || document.documentElement,
          thisStyle = thisBody.style;
        var support = thisStyle.transition !== undefined || thisStyle.WebkitTransition !== undefined || thisStyle.MozTransition !== undefined || thisStyle.MsTransition !== undefined || thisStyle.OTransition !== undefined;
        return support;
      },
      getTransitionPrefix: function getTransitionPrefix() {
        if (/mozilla/.test(navigator.userAgent.toLowerCase()) && !/webkit/.test(navigator.userAgent.toLowerCase())) {
          return '-moz-transition';
        }
        if (/webkit/.test(navigator.userAgent.toLowerCase())) {
          return '-webkit-transition';
        }
        if (/opera/.test(navigator.userAgent.toLowerCase())) {
          return '-o-transition';
        }
        if (/msie/.test(navigator.userAgent.toLowerCase())) {
          return '-ms-transition';
        } else {
          return 'transition';
        }
      },
      getTransition: function getTransition(val, time, type) {
        var CSSObj;
        if (type === 'width') {
          CSSObj = {
            width: val
          };
        } else if (type === 'left') {
          CSSObj = {
            left: val
          };
        }
        time = time / 1000;
        CSSObj[transitionPrefix] = type + ' ' + time + 's ease-in-out';
        return CSSObj;
      },
      refill: function refill() {
        fill.css('width', 0);
        toolTip.css('left', 0);
        barWidth = object.width();
        methods.initializeItems();
      },
      calculateFill: function calculateFill(percentage) {
        percentage = percentage * 0.01;
        var finalWidth = barWidth * percentage;
        return finalWidth;
      },
      transitionFill: function transitionFill(barWidth) {
        var toolTipOffset = barWidth - toolTip.width();
        fill.css(methods.getTransition(barWidth, settings.duration, 'width'));
        toolTip.css(methods.getTransition(toolTipOffset, settings.duration, 'left'));
      },
      animateFill: function animateFill(barWidth) {
        var toolTipOffset = barWidth - toolTip.width();
        fill.stop().animate({
          width: '+=' + barWidth
        }, settings.duration);
        toolTip.stop().animate({
          left: '+=' + toolTipOffset
        }, settings.duration);
      }
    };
    if (methods[options]) {
      // $("#element").pluginName('methodName', 'arg1', 'arg2');
      return methods[options].apply(this, Array.prototype.slice.call(arguments, 1));
    } else if (_typeof(options) === 'object' || !options) {
      // $("#element").pluginName({ option: 1, option:2 });
      return methods.init.apply(this);
    } else {
      $.error('Method "' + method + '" does not exist in barfiller plugin!');
    }
  };
})(jQuery);

/***/ }),

/***/ "./public/frontend/amazy/js/gijgo.min.js":
/*!***********************************************!*\
  !*** ./public/frontend/amazy/js/gijgo.min.js ***!
  \***********************************************/
/***/ (() => {

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var gj = {};
gj.widget = function () {
  var a = this;
  a.xhr = null, a.generateGUID = function () {
    function a() {
      return Math.floor(65536 * (1 + Math.random())).toString(16).substring(1);
    }
    return a() + a() + "-" + a() + "-" + a() + "-" + a() + "-" + a() + a() + a();
  }, a.mouseX = function (a) {
    if (a) {
      if (a.pageX) return a.pageX;
      if (a.clientX) return a.clientX + (document.documentElement.scrollLeft ? document.documentElement.scrollLeft : document.body.scrollLeft);
      if (a.touches && a.touches.length) return a.touches[0].pageX;
      if (a.changedTouches && a.changedTouches.length) return a.changedTouches[0].pageX;
      if (a.originalEvent && a.originalEvent.touches && a.originalEvent.touches.length) return a.originalEvent.touches[0].pageX;
      if (a.originalEvent && a.originalEvent.changedTouches && a.originalEvent.changedTouches.length) return a.originalEvent.touches[0].pageX;
    }
    return null;
  }, a.mouseY = function (a) {
    if (a) {
      if (a.pageY) return a.pageY;
      if (a.clientY) return a.clientY + (document.documentElement.scrollTop ? document.documentElement.scrollTop : document.body.scrollTop);
      if (a.touches && a.touches.length) return a.touches[0].pageY;
      if (a.changedTouches && a.changedTouches.length) return a.changedTouches[0].pageY;
      if (a.originalEvent && a.originalEvent.touches && a.originalEvent.touches.length) return a.originalEvent.touches[0].pageY;
      if (a.originalEvent && a.originalEvent.changedTouches && a.originalEvent.changedTouches.length) return a.originalEvent.touches[0].pageY;
    }
    return null;
  };
}, gj.widget.prototype.init = function (a, b) {
  var c, d, e;
  this.attr("data-type", b), d = $.extend(!0, {}, this.getHTMLConfig() || {}), $.extend(!0, d, a || {}), e = this.getConfig(d, b), this.attr("data-guid", e.guid), this.data(e);
  for (c in e) gj[b].events.hasOwnProperty(c) && (this.on(c, e[c]), delete e[c]);
  for (plugin in gj[b].plugins) gj[b].plugins.hasOwnProperty(plugin) && gj[b].plugins[plugin].configure(this, e, d);
  return this;
}, gj.widget.prototype.getConfig = function (a, b) {
  var c, d, e, f;
  c = $.extend(!0, {}, gj[b].config.base), d = a.hasOwnProperty("uiLibrary") ? a.uiLibrary : c.uiLibrary, gj[b].config[d] && $.extend(!0, c, gj[b].config[d]), e = a.hasOwnProperty("iconsLibrary") ? a.iconsLibrary : c.iconsLibrary, gj[b].config[e] && $.extend(!0, c, gj[b].config[e]);
  for (f in gj[b].plugins) gj[b].plugins.hasOwnProperty(f) && ($.extend(!0, c, gj[b].plugins[f].config.base), gj[b].plugins[f].config[d] && $.extend(!0, c, gj[b].plugins[f].config[d]), gj[b].plugins[f].config[e] && $.extend(!0, c, gj[b].plugins[f].config[e]));
  return $.extend(!0, c, a), c.guid || (c.guid = this.generateGUID()), c;
}, gj.widget.prototype.getHTMLConfig = function () {
  var a = this.data(),
    b = this[0].attributes;
  return b.width && (a.width = b.width.value), b.height && (a.height = b.height.value), b.value && (a.value = b.value.value), b.align && (a.align = b.align.value), a && a.source && (a.dataSource = a.source, delete a.source), a;
}, gj.widget.prototype.createDoneHandler = function () {
  var a = this;
  return function (b) {
    "string" == typeof b && JSON && (b = JSON.parse(b)), gj[a.data("type")].methods.render(a, b);
  };
}, gj.widget.prototype.createErrorHandler = function () {
  return function (a) {
    a && a.statusText && "abort" !== a.statusText && alert(a.statusText);
  };
}, gj.widget.prototype.reload = function (a) {
  var b,
    c,
    d = this.data(),
    e = this.data("type");
  return void 0 === d.dataSource && gj[e].methods.useHtmlDataSource(this, d), $.extend(d.params, a), $.isArray(d.dataSource) ? (c = gj[e].methods.filter(this), gj[e].methods.render(this, c)) : "string" == typeof d.dataSource ? (b = {
    url: d.dataSource,
    data: d.params
  }, this.xhr && this.xhr.abort(), this.xhr = $.ajax(b).done(this.createDoneHandler()).fail(this.createErrorHandler())) : "object" == _typeof(d.dataSource) && (d.dataSource.data || (d.dataSource.data = {}), $.extend(d.dataSource.data, d.params), b = $.extend(!0, {}, d.dataSource), "json" === b.dataType && "object" == _typeof(b.data) && (b.data = JSON.stringify(b.data)), b.success || (b.success = this.createDoneHandler()), b.error || (b.error = this.createErrorHandler()), this.xhr && this.xhr.abort(), this.xhr = $.ajax(b)), this;
}, gj.documentManager = {
  events: {},
  subscribeForEvent: function subscribeForEvent(a, b, c) {
    if (gj.documentManager.events[a] && 0 !== gj.documentManager.events[a].length) {
      if (gj.documentManager.events[a][b]) throw "Event " + a + ' for widget with guid="' + b + '" is already attached.';
      gj.documentManager.events[a].push({
        widgetId: b,
        callback: c
      });
    } else gj.documentManager.events[a] = [{
      widgetId: b,
      callback: c
    }], $(document).on(a, gj.documentManager.executeCallbacks);
  },
  executeCallbacks: function executeCallbacks(a) {
    var b = gj.documentManager.events[a.type];
    if (b) for (var c = 0; c < b.length; c++) b[c].callback(a);
  },
  unsubscribeForEvent: function unsubscribeForEvent(a, b) {
    var c = !1,
      d = gj.documentManager.events[a];
    if (d) for (var e = 0; e < d.length; e++) d[e].widgetId === b && (d.splice(e, 1), c = !0, 0 === d.length && ($(document).off(a), delete gj.documentManager.events[a]));
    if (!c) throw 'The "' + a + '" for widget with guid="' + b + "\" can't be removed.";
  }
}, gj.core = {
  messages: {
    "en-us": {
      monthNames: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
      monthShortNames: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
      weekDaysMin: ["S", "M", "T", "W", "T", "F", "S"],
      weekDaysShort: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
      weekDays: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
      am: "AM",
      pm: "PM",
      ok: "Ok",
      cancel: "Cancel",
      titleFormat: "mmmm yyyy"
    }
  },
  parseDate: function parseDate(a, b, c) {
    var d,
      e,
      f,
      g,
      h = 0,
      i = 0,
      j = 1,
      k = 0,
      l = 0;
    if (a && "string" == typeof a) {
      if (/^\d+$/.test(a)) g = new Date(a);else if (a.indexOf("/Date(") > -1) g = new Date(parseInt(a.substr(6), 10));else if (a) {
        for (f = b.split(/[\s,-\.\/\/\:]+/), e = a.split(/[\s]+/), e.length != f.length && (e = a.split(/[\s,-\.\/\/\:]+/)), d = 0; d < f.length; d++) ["d", "dd"].indexOf(f[d]) > -1 ? j = parseInt(e[d], 10) : ["m", "mm"].indexOf(f[d]) > -1 ? i = parseInt(e[d], 10) - 1 : "mmm" === f[d] ? i = gj.core.messages[c || "en-us"].monthShortNames.indexOf(e[d]) : "mmmm" === f[d] ? i = gj.core.messages[c || "en-us"].monthNames.indexOf(e[d]) : ["yy", "yyyy"].indexOf(f[d]) > -1 ? (h = parseInt(e[d], 10), "yy" === f[d] && (h += 2e3)) : ["h", "hh", "H", "HH"].indexOf(f[d]) > -1 ? k = parseInt(e[d], 10) : ["M", "MM"].indexOf(f[d]) > -1 && (l = parseInt(e[d], 10));
        g = new Date(h, i, j, k, l);
      }
    } else "number" == typeof a ? g = new Date(a) : a instanceof Date && (g = a);
    return g;
  },
  formatDate: function formatDate(a, b, c) {
    var d,
      e,
      f = "",
      g = b.split(/[\s,-\.\/\/\:]+/),
      h = b.split(/s+|M+|H+|h+|t+|T+|d+|m+|y+/);
    for (h = h.splice(1, h.length - 2), i = 0; i < g.length; i++) switch (d = h[i] || "", g[i]) {
      case "s":
        f += a.getSeconds() + d;
        break;
      case "ss":
        f += gj.core.pad(a.getSeconds()) + d;
        break;
      case "M":
        f += a.getMinutes() + d;
        break;
      case "MM":
        f += gj.core.pad(a.getMinutes()) + d;
        break;
      case "H":
        f += a.getHours() + d;
        break;
      case "HH":
        f += gj.core.pad(a.getHours()) + d;
        break;
      case "h":
        e = a.getHours() > 12 ? a.getHours() % 12 : a.getHours(), f += e + d;
        break;
      case "hh":
        e = a.getHours() > 12 ? a.getHours() % 12 : a.getHours(), f += gj.core.pad(e) + d;
        break;
      case "tt":
        f += (a.getHours() >= 12 ? "pm" : "am") + d;
        break;
      case "TT":
        f += (a.getHours() >= 12 ? "PM" : "AM") + d;
        break;
      case "d":
        f += a.getDate() + d;
        break;
      case "dd":
        f += gj.core.pad(a.getDate()) + d;
        break;
      case "ddd":
        f += gj.core.messages[c || "en-us"].weekDaysShort[a.getDay()] + d;
        break;
      case "dddd":
        f += gj.core.messages[c || "en-us"].weekDays[a.getDay()] + d;
        break;
      case "m":
        f += a.getMonth() + 1 + d;
        break;
      case "mm":
        f += gj.core.pad(a.getMonth() + 1) + d;
        break;
      case "mmm":
        f += gj.core.messages[c || "en-us"].monthShortNames[a.getMonth()] + d;
        break;
      case "mmmm":
        f += gj.core.messages[c || "en-us"].monthNames[a.getMonth()] + d;
        break;
      case "yy":
        f += a.getFullYear().toString().substr(2) + d;
        break;
      case "yyyy":
        f += a.getFullYear() + d;
    }
    return f;
  },
  pad: function pad(a, b) {
    for (a = String(a), b = b || 2; a.length < b;) a = "0" + a;
    return a;
  },
  center: function center(a) {
    var b = $(window).width() / 2 - a.width() / 2,
      c = $(window).height() / 2 - a.height() / 2;
    a.css("position", "absolute"), a.css("left", b > 0 ? b : 0), a.css("top", c > 0 ? c : 0);
  },
  isIE: function isIE() {
    return !!navigator.userAgent.match(/Trident/g) || !!navigator.userAgent.match(/MSIE/g);
  },
  setChildPosition: function setChildPosition(a, b) {
    var c = a.getBoundingClientRect(),
      d = gj.core.height(a, !0),
      e = gj.core.height(b, !0),
      f = gj.core.width(a, !0),
      g = gj.core.width(b, !0),
      h = window.scrollY || window.pageYOffset || 0,
      i = window.scrollX || window.pageXOffset || 0;
    c.top + d + e > window.innerHeight && c.top > e ? b.style.top = Math.round(c.top + h - e - 3) + "px" : b.style.top = Math.round(c.top + h + d + 3) + "px", c.left + g > document.body.clientWidth ? b.style.left = Math.round(c.left + i + f - g) + "px" : b.style.left = Math.round(c.left + i) + "px";
  },
  height: function height(a, b) {
    var c,
      d = window.getComputedStyle(a);
    return "border-box" === d.boxSizing ? (c = parseInt(d.height, 10), gj.core.isIE() && (c += parseInt(d.paddingTop || 0, 10) + parseInt(d.paddingBottom || 0, 10), c += parseInt(d.borderTopWidth || 0, 10) + parseInt(d.borderBottomWidth || 0, 10))) : (c = parseInt(d.height, 10), c += parseInt(d.paddingTop || 0, 10) + parseInt(d.paddingBottom || 0, 10), c += parseInt(d.borderTopWidth || 0, 10) + parseInt(d.borderBottomWidth || 0, 10)), b && (c += parseInt(d.marginTop || 0, 10) + parseInt(d.marginBottom || 0, 10)), c;
  },
  width: function width(a, b) {
    var c,
      d = window.getComputedStyle(a);
    return "border-box" === d.boxSizing ? c = parseInt(d.width, 10) : (c = parseInt(d.width, 10), c += parseInt(d.paddingLeft || 0, 10) + parseInt(d.paddingRight || 0, 10), c += parseInt(d.borderLeftWidth || 0, 10) + parseInt(d.borderRightWidth || 0, 10)), b && (c += parseInt(d.marginLeft || 0, 10) + parseInt(d.marginRight || 0, 10)), c;
  },
  addClasses: function addClasses(a, b) {
    var c, d;
    if (b) for (d = b.split(" "), c = 0; c < d.length; c++) a.classList.add(d[c]);
  },
  position: function position(a) {
    for (var b, c, d = 0, e = 0, f = gj.core.height(a), g = gj.core.width(a); a;) "BODY" == a.tagName ? (b = a.scrollLeft || document.documentElement.scrollLeft, c = a.scrollTop || document.documentElement.scrollTop, d += a.offsetLeft - b, e += a.offsetTop - c) : (d += a.offsetLeft - a.scrollLeft, e += a.offsetTop - a.scrollTop), a = a.offsetParent;
    return {
      top: e,
      left: d,
      bottom: e + f,
      right: d + g
    };
  },
  setCaretAtEnd: function setCaretAtEnd(a) {
    var b;
    if (a) if (b = a.value.length, document.selection) {
      a.focus();
      var c = document.selection.createRange();
      c.moveStart("character", -b), c.moveStart("character", b), c.moveEnd("character", 0), c.select();
    } else (a.selectionStart || "0" == a.selectionStart) && (a.selectionStart = b, a.selectionEnd = b, a.focus());
  },
  getScrollParent: function getScrollParent(a) {
    return null == a ? null : a.scrollHeight > a.clientHeight ? a : gj.core.getScrollParent(a.parentNode);
  }
}, gj.picker = {
  messages: {
    "en-us": {}
  }
}, gj.picker.methods = {
  initialize: function initialize(a, b, c) {
    var d,
      e = c.createPicker(a, b),
      f = a.parent('div[role="wrapper"]');
    d = "bootstrap" === b.uiLibrary ? $('<span class="input-group-addon">' + b.icons.rightIcon + "</span>") : "bootstrap4" === b.uiLibrary ? $('<span class="input-group-append"><button class="btn btn-outline-secondary border-left-0" type="button">' + b.icons.rightIcon + "</button></span>") : $(b.icons.rightIcon), d.attr("role", "right-icon"), 0 === f.length ? (f = $('<div role="wrapper" />').addClass(b.style.wrapper), a.wrap(f)) : f.addClass(b.style.wrapper), f = a.parent('div[role="wrapper"]'), b.width && f.css("width", b.width), a.val(b.value).addClass(b.style.input).attr("role", "input"), b.fontSize && a.css("font-size", b.fontSize), "bootstrap" === b.uiLibrary || "bootstrap4" === b.uiLibrary ? "small" === b.size ? (f.addClass("input-group-sm"), a.addClass("form-control-sm")) : "large" === b.size && (f.addClass("input-group-lg"), a.addClass("form-control-lg")) : "small" === b.size ? f.addClass("small") : "large" === b.size && f.addClass("large"), d.on("click", function (b) {
      e.is(":visible") ? a.close() : a.open();
    }), f.append(d), !0 !== b.footer && (a.on("blur", function () {
      a.timeout = setTimeout(function () {
        a.close();
      }, 500);
    }), e.mousedown(function () {
      return clearTimeout(a.timeout), a.focus(), !1;
    }), e.on("click", function () {
      clearTimeout(a.timeout), a.focus();
    }));
  }
}, gj.picker.widget = function (a, b) {
  var c = this,
    d = gj.picker.methods;
  return c.destroy = function () {
    return d.destroy(this);
  }, a;
}, gj.picker.widget.prototype = new gj.widget(), gj.picker.widget.constructor = gj.picker.widget, gj.picker.widget.prototype.init = function (a, b, c) {
  return gj.widget.prototype.init.call(this, a, b), this.attr("data-" + b, "true"), gj.picker.methods.initialize(this, this.data(), gj[b].methods), this;
}, gj.picker.widget.prototype.open = function (a) {
  var b = this.data(),
    c = $("body").find('[role="picker"][guid="' + this.attr("data-guid") + '"]');
  return c.show(), c.closest('div[role="modal"]').show(), b.modal ? gj.core.center(c) : (gj.core.setChildPosition(this[0], c[0]), this.focus()), clearTimeout(this.timeout), gj[a].events.open(this), this;
}, gj.picker.widget.prototype.close = function (a) {
  var b = $("body").find('[role="picker"][guid="' + this.attr("data-guid") + '"]');
  return b.hide(), b.closest('div[role="modal"]').hide(), gj[a].events.close(this), this;
}, gj.picker.widget.prototype.destroy = function (a) {
  var b = this.data(),
    c = this.parent(),
    d = $("body").find('[role="picker"][guid="' + this.attr("data-guid") + '"]');
  return b && (this.off(), d.parent('[role="modal"]').length > 0 && d.unwrap(), d.remove(), this.removeData(), this.removeAttr("data-type").removeAttr("data-guid").removeAttr("data-" + a), this.removeClass(), c.children('[role="right-icon"]').remove(), this.unwrap()), this;
}, gj.dialog = {
  plugins: {},
  messages: {}
}, gj.dialog.config = {
  base: {
    autoOpen: !0,
    closeButtonInHeader: !0,
    closeOnEscape: !0,
    draggable: !0,
    height: "auto",
    locale: "en-us",
    maxHeight: void 0,
    maxWidth: void 0,
    minHeight: void 0,
    minWidth: void 0,
    modal: !1,
    resizable: !1,
    scrollable: !1,
    title: void 0,
    uiLibrary: void 0,
    width: 300,
    style: {
      modal: "gj-modal",
      content: "gj-dialog-md",
      header: "gj-dialog-md-header gj-unselectable",
      headerTitle: "gj-dialog-md-title",
      headerCloseButton: "gj-dialog-md-close",
      body: "gj-dialog-md-body",
      footer: "gj-dialog-footer gj-dialog-md-footer"
    }
  },
  bootstrap: {
    style: {
      modal: "modal",
      content: "modal-content gj-dialog-bootstrap",
      header: "modal-header",
      headerTitle: "modal-title",
      headerCloseButton: "close",
      body: "modal-body",
      footer: "gj-dialog-footer modal-footer"
    }
  },
  bootstrap4: {
    style: {
      modal: "modal",
      content: "modal-content gj-dialog-bootstrap4",
      header: "modal-header",
      headerTitle: "modal-title",
      headerCloseButton: "close",
      body: "modal-body",
      footer: "gj-dialog-footer modal-footer"
    }
  }
}, gj.dialog.events = {
  initialized: function initialized(a) {
    a.trigger("initialized");
  },
  opening: function opening(a) {
    a.trigger("opening");
  },
  opened: function opened(a) {
    a.trigger("opened");
  },
  closing: function closing(a) {
    a.trigger("closing");
  },
  closed: function closed(a) {
    a.trigger("closed");
  },
  drag: function drag(a) {
    a.trigger("drag");
  },
  dragStart: function dragStart(a) {
    a.trigger("dragStart");
  },
  dragStop: function dragStop(a) {
    a.trigger("dragStop");
  },
  resize: function resize(a) {
    a.trigger("resize");
  },
  resizeStart: function resizeStart(a) {
    a.trigger("resizeStart");
  },
  resizeStop: function resizeStop(a) {
    a.trigger("resizeStop");
  }
}, gj.dialog.methods = {
  init: function init(a) {
    return gj.widget.prototype.init.call(this, a, "dialog"), gj.dialog.methods.localization(this), gj.dialog.methods.initialize(this), gj.dialog.events.initialized(this), this;
  },
  localization: function localization(a) {
    var b = a.data();
    void 0 === b.title && (b.title = gj.dialog.messages[b.locale].DefaultTitle);
  },
  getHTMLConfig: function getHTMLConfig() {
    var a = gj.widget.prototype.getHTMLConfig.call(this),
      b = this[0].attributes;
    return b.title && (a.title = b.title.value), a;
  },
  initialize: function initialize(a) {
    var b,
      c,
      d,
      e = a.data();
    a.addClass(e.style.content), gj.dialog.methods.setSize(a), e.closeOnEscape && $(document).keyup(function (b) {
      27 === b.keyCode && a.close();
    }), c = a.children('div[data-role="body"]'), 0 === c.length ? (c = $('<div data-role="body"/>').addClass(e.style.body), a.wrapInner(c)) : c.addClass(e.style.body), b = gj.dialog.methods.renderHeader(a), d = a.children('div[data-role="footer"]').addClass(e.style.footer), a.find('[data-role="close"]').on("click", function () {
      a.close();
    }), gj.draggable && (e.draggable && gj.dialog.methods.draggable(a, b), e.resizable && gj.dialog.methods.resizable(a)), e.scrollable && e.height && (a.addClass("gj-dialog-scrollable"), a.on("opened", function () {
      a.children('div[data-role="body"]').css("height", e.height - b.outerHeight() - (d.length ? d.outerHeight() : 0));
    })), gj.core.center(a), e.modal && a.wrapAll('<div data-role="modal" class="' + e.style.modal + '"/>'), e.autoOpen && a.open();
  },
  setSize: function setSize(a) {
    var b = a.data();
    b.width && a.css("width", b.width), b.height && a.css("height", b.height);
  },
  renderHeader: function renderHeader(a) {
    var b,
      c,
      d,
      e = a.data();
    return b = a.children('div[data-role="header"]'), 0 === b.length && (b = $('<div data-role="header" />'), a.prepend(b)), b.addClass(e.style.header), c = b.find('[data-role="title"]'), 0 === c.length && (c = $('<h4 data-role="title">' + e.title + "</h4>"), b.append(c)), c.addClass(e.style.headerTitle), d = b.find('[data-role="close"]'), 0 === d.length && e.closeButtonInHeader ? (d = $('<button type="button" data-role="close" title="' + gj.dialog.messages[e.locale].Close + '"><span>×</span></button>'), d.addClass(e.style.headerCloseButton), b.append(d)) : d.length > 0 && !1 === e.closeButtonInHeader ? d.hide() : d.addClass(e.style.headerCloseButton), b;
  },
  draggable: function draggable(a, b) {
    a.appendTo("body"), b.addClass("gj-draggable"), a.draggable({
      handle: b,
      start: function start() {
        a.addClass("gj-unselectable"), gj.dialog.events.dragStart(a);
      },
      stop: function stop() {
        a.removeClass("gj-unselectable"), gj.dialog.events.dragStop(a);
      }
    });
  },
  resizable: function resizable(a) {
    var b = {
      drag: gj.dialog.methods.resize,
      start: function start() {
        a.addClass("gj-unselectable"), gj.dialog.events.resizeStart(a);
      },
      stop: function stop() {
        this.removeAttribute("style"), a.removeClass("gj-unselectable"), gj.dialog.events.resizeStop(a);
      }
    };
    a.append($('<div class="gj-resizable-handle gj-resizable-n"></div>').draggable($.extend(!0, {
      horizontal: !1
    }, b))), a.append($('<div class="gj-resizable-handle gj-resizable-e"></div>').draggable($.extend(!0, {
      vertical: !1
    }, b))), a.append($('<div class="gj-resizable-handle gj-resizable-s"></div>').draggable($.extend(!0, {
      horizontal: !1
    }, b))), a.append($('<div class="gj-resizable-handle gj-resizable-w"></div>').draggable($.extend(!0, {
      vertical: !1
    }, b))), a.append($('<div class="gj-resizable-handle gj-resizable-ne"></div>').draggable($.extend(!0, {}, b))), a.append($('<div class="gj-resizable-handle gj-resizable-nw"></div>').draggable($.extend(!0, {}, b))), a.append($('<div class="gj-resizable-handle gj-resizable-sw"></div>').draggable($.extend(!0, {}, b))), a.append($('<div class="gj-resizable-handle gj-resizable-se"></div>').draggable($.extend(!0, {}, b)));
  },
  resize: function resize(a, b) {
    var c,
      d,
      e,
      f,
      g,
      h,
      i,
      j,
      k = !1;
    return c = $(this), d = c.parent(), e = gj.core.position(this), offset = {
      top: b.top - e.top,
      left: b.left - e.left
    }, f = d.data(), c.hasClass("gj-resizable-n") ? (g = d.height() - offset.top, i = d.offset().top + offset.top) : c.hasClass("gj-resizable-e") ? h = d.width() + offset.left : c.hasClass("gj-resizable-s") ? g = d.height() + offset.top : c.hasClass("gj-resizable-w") ? (h = d.width() - offset.left, j = d.offset().left + offset.left) : c.hasClass("gj-resizable-ne") ? (g = d.height() - offset.top, i = d.offset().top + offset.top, h = d.width() + offset.left) : c.hasClass("gj-resizable-nw") ? (g = d.height() - offset.top, i = d.offset().top + offset.top, h = d.width() - offset.left, j = d.offset().left + offset.left) : c.hasClass("gj-resizable-se") ? (g = d.height() + offset.top, h = d.width() + offset.left) : c.hasClass("gj-resizable-sw") && (g = d.height() + offset.top, h = d.width() - offset.left, j = d.offset().left + offset.left), g && (!f.minHeight || g >= f.minHeight) && (!f.maxHeight || g <= f.maxHeight) && (d.height(g), i && d.css("top", i), k = !0), h && (!f.minWidth || h >= f.minWidth) && (!f.maxWidth || h <= f.maxWidth) && (d.width(h), j && d.css("left", j), k = !0), k && gj.dialog.events.resize(d), k;
  },
  open: function open(a, b) {
    var c;
    return gj.dialog.events.opening(a), a.css("display", "block"), a.closest('div[data-role="modal"]').css("display", "block"), c = a.children('div[data-role="footer"]'), c.length && c.outerHeight() && a.children('div[data-role="body"]').css("margin-bottom", c.outerHeight()), void 0 !== b && a.find('[data-role="title"]').html(b), gj.dialog.events.opened(a), a;
  },
  close: function close(a) {
    return a.is(":visible") && (gj.dialog.events.closing(a), a.css("display", "none"), a.closest('div[data-role="modal"]').css("display", "none"), gj.dialog.events.closed(a)), a;
  },
  isOpen: function isOpen(a) {
    return a.is(":visible");
  },
  content: function content(a, b) {
    var c = a.children('div[data-role="body"]');
    return void 0 === b ? c.html() : c.html(b);
  },
  destroy: function destroy(a, b) {
    var c = a.data();
    return c && (!1 === b ? a.remove() : (a.close(), a.off(), a.removeData(), a.removeAttr("data-type"), a.removeClass(c.style.content), a.find('[data-role="header"]').removeClass(c.style.header), a.find('[data-role="title"]').removeClass(c.style.headerTitle), a.find('[data-role="close"]').remove(), a.find('[data-role="body"]').removeClass(c.style.body), a.find('[data-role="footer"]').removeClass(c.style.footer))), a;
  }
}, gj.dialog.widget = function (a, b) {
  var c = this,
    d = gj.dialog.methods;
  return c.open = function (a) {
    return d.open(this, a);
  }, c.close = function () {
    return d.close(this);
  }, c.isOpen = function () {
    return d.isOpen(this);
  }, c.content = function (a) {
    return d.content(this, a);
  }, c.destroy = function (a) {
    return d.destroy(this, a);
  }, $.extend(a, c), "dialog" !== a.attr("data-type") && d.init.call(a, b), a;
}, gj.dialog.widget.prototype = new gj.widget(), gj.dialog.widget.constructor = gj.dialog.widget, gj.dialog.widget.prototype.getHTMLConfig = gj.dialog.methods.getHTMLConfig, function (a) {
  a.fn.dialog = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.dialog.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.dialog.widget(this, a);
    }
  };
}(jQuery), gj.dialog.messages["en-us"] = {
  Close: "Close",
  DefaultTitle: "Dialog"
}, gj.draggable = {
  plugins: {}
}, gj.draggable.config = {
  base: {
    handle: void 0,
    vertical: !0,
    horizontal: !0,
    containment: void 0
  }
}, gj.draggable.methods = {
  init: function init(a) {
    var b,
      c,
      d = this;
    return gj.widget.prototype.init.call(this, a, "draggable"), c = this.data(), d.attr("data-draggable", "true"), b = gj.draggable.methods.getHandleElement(d), b.on("touchstart mousedown", function (a) {
      var e = gj.core.position(d[0]);
      d[0].style.top = e.top + "px", d[0].style.left = e.left + "px", d[0].style.position = "fixed", d.attr("draggable-dragging", !0), d.removeAttr("draggable-x").removeAttr("draggable-y"), gj.documentManager.subscribeForEvent("touchmove", d.data("guid"), gj.draggable.methods.createMoveHandler(d, b, c)), gj.documentManager.subscribeForEvent("mousemove", d.data("guid"), gj.draggable.methods.createMoveHandler(d, b, c));
    }), gj.documentManager.subscribeForEvent("mouseup", d.data("guid"), gj.draggable.methods.createUpHandler(d)), gj.documentManager.subscribeForEvent("touchend", d.data("guid"), gj.draggable.methods.createUpHandler(d)), gj.documentManager.subscribeForEvent("touchcancel", d.data("guid"), gj.draggable.methods.createUpHandler(d)), d;
  },
  getHandleElement: function getHandleElement(a) {
    var b = a.data("handle");
    return b && b.length ? b : a;
  },
  createUpHandler: function createUpHandler(a) {
    return function (b) {
      "true" === a.attr("draggable-dragging") && (a.attr("draggable-dragging", !1), gj.documentManager.unsubscribeForEvent("mousemove", a.data("guid")), gj.documentManager.unsubscribeForEvent("touchmove", a.data("guid")), gj.draggable.events.stop(a, {
        x: a.mouseX(b),
        y: a.mouseY(b)
      }));
    };
  },
  createMoveHandler: function createMoveHandler(a, b, c) {
    return function (b) {
      var d, e, f, g, h, i;
      "true" === a.attr("draggable-dragging") && (d = Math.round(a.mouseX(b)), e = Math.round(a.mouseY(b)), h = a.attr("draggable-x"), i = a.attr("draggable-y"), h && i ? (f = c.horizontal ? d - parseInt(h, 10) : 0, g = c.vertical ? e - parseInt(i, 10) : 0, gj.draggable.methods.move(a[0], c, f, g, d, e)) : gj.draggable.events.start(a, d, e), a.attr("draggable-x", d), a.attr("draggable-y", e));
    };
  },
  move: function move(a, b, c, d, e, f) {
    var g,
      h,
      i,
      j = gj.core.position(a),
      k = j.top + d,
      l = j.left + c;
    b.containment && (g = gj.core.position(b.containment), h = g.top + gj.core.height(b.containment) - gj.core.height(a), i = g.left + gj.core.width(b.containment) - gj.core.width(a), k > g.top && k < h ? (g.top >= f || g.bottom <= f) && (k = j.top) : k = k <= g.top ? g.top + 1 : h - 1, l > g.left && l < i ? (g.left >= e || g.right <= e) && (l = j.left) : l = l <= g.left ? g.left + 1 : i - 1), !1 !== gj.draggable.events.drag($(a), l, k, e, f) && (a.style.top = k + "px", a.style.left = l + "px");
  },
  destroy: function destroy(a) {
    return "true" === a.attr("data-draggable") && (gj.documentManager.unsubscribeForEvent("mouseup", a.data("guid")), a.removeData(), a.removeAttr("data-guid").removeAttr("data-type").removeAttr("data-draggable"), a.removeAttr("draggable-x").removeAttr("draggable-y").removeAttr("draggable-dragging"), a[0].style.top = "", a[0].style.left = "", a[0].style.position = "", a.off("drag").off("start").off("stop"), gj.draggable.methods.getHandleElement(a).off("mousedown")), a;
  }
}, gj.draggable.events = {
  drag: function drag(a, b, c, d, e) {
    return a.triggerHandler("drag", [{
      left: b,
      top: c
    }, {
      x: d,
      y: e
    }]);
  },
  start: function start(a, b, c) {
    a.triggerHandler("start", [{
      x: b,
      y: c
    }]);
  },
  stop: function stop(a, b) {
    a.triggerHandler("stop", [b]);
  }
}, gj.draggable.widget = function (a, b) {
  var c = this,
    d = gj.draggable.methods;
  return a.destroy || (c.destroy = function () {
    return d.destroy(this);
  }), $.extend(a, c), "true" !== a.attr("data-draggable") && d.init.call(a, b), a;
}, gj.draggable.widget.prototype = new gj.widget(), gj.draggable.widget.constructor = gj.draggable.widget, function (a) {
  a.fn.draggable = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.draggable.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.draggable.widget(this, a);
    }
  };
}(jQuery), gj.droppable = {
  plugins: {}
}, gj.droppable.config = {
  hoverClass: void 0
}, gj.droppable.methods = {
  init: function init(a) {
    var b = this;
    return gj.widget.prototype.init.call(this, a, "droppable"), b.attr("data-droppable", "true"), gj.documentManager.subscribeForEvent("mousedown", b.data("guid"), gj.droppable.methods.createMouseDownHandler(b)), gj.documentManager.subscribeForEvent("mousemove", b.data("guid"), gj.droppable.methods.createMouseMoveHandler(b)), gj.documentManager.subscribeForEvent("mouseup", b.data("guid"), gj.droppable.methods.createMouseUpHandler(b)), b;
  },
  createMouseDownHandler: function createMouseDownHandler(a) {
    return function (b) {
      a.isDragging = !0;
    };
  },
  createMouseMoveHandler: function createMouseMoveHandler(a) {
    return function (b) {
      if (a.isDragging) {
        var c = a.data("hoverClass"),
          d = {
            x: a.mouseX(b),
            y: a.mouseY(b)
          },
          e = gj.droppable.methods.isOver(a, d);
        e != a.isOver && (e ? (c && a.addClass(c), gj.droppable.events.over(a, d)) : (c && a.removeClass(c), gj.droppable.events.out(a))), a.isOver = e;
      }
    };
  },
  createMouseUpHandler: function createMouseUpHandler(a) {
    return function (b) {
      var c = {
        left: a.mouseX(b),
        top: a.mouseY(b)
      };
      a.isDragging = !1, gj.droppable.methods.isOver(a, c) && gj.droppable.events.drop(a);
    };
  },
  isOver: function isOver(a, b) {
    var c = a.offset().top,
      d = a.offset().left;
    return b.x > d && b.x < d + a.outerWidth(!0) && b.y > c && b.y < c + a.outerHeight(!0);
  },
  destroy: function destroy(a) {
    return "true" === a.attr("data-droppable") && (gj.documentManager.unsubscribeForEvent("mousedown", a.data("guid")), gj.documentManager.unsubscribeForEvent("mousemove", a.data("guid")), gj.documentManager.unsubscribeForEvent("mouseup", a.data("guid")), a.removeData(), a.removeAttr("data-guid"), a.removeAttr("data-droppable"), a.off("drop").off("over").off("out")), a;
  }
}, gj.droppable.events = {
  drop: function drop(a, b, c) {
    a.trigger("drop", [{
      top: c,
      left: b
    }]);
  },
  over: function over(a, b) {
    a.trigger("over", [b]);
  },
  out: function out(a) {
    a.trigger("out");
  }
}, gj.droppable.widget = function (a, b) {
  var c = this,
    d = gj.droppable.methods;
  return c.isOver = !1, c.isDragging = !1, c.destroy = function () {
    return d.destroy(this);
  }, c.isOver = function (a) {
    return d.isOver(this, a);
  }, $.extend(a, c), "true" !== a.attr("data-droppable") && d.init.call(a, b), a;
}, gj.droppable.widget.prototype = new gj.widget(), gj.droppable.widget.constructor = gj.droppable.widget, function (a) {
  a.fn.droppable = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.droppable.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.droppable.widget(this, a);
    }
  };
}(jQuery), gj.grid = {
  plugins: {},
  messages: {}
}, gj.grid.config = {
  base: {
    dataSource: void 0,
    columns: [],
    autoGenerateColumns: !1,
    defaultColumnSettings: {
      hidden: !1,
      width: void 0,
      sortable: !1,
      type: "text",
      title: void 0,
      field: void 0,
      align: void 0,
      cssClass: void 0,
      headerCssClass: void 0,
      tooltip: void 0,
      icon: void 0,
      events: void 0,
      format: "mm/dd/yyyy",
      decimalDigits: void 0,
      tmpl: void 0,
      stopPropagation: !1,
      renderer: void 0,
      filter: void 0
    },
    mapping: {
      dataField: "records",
      totalRecordsField: "total"
    },
    params: {},
    paramNames: {
      sortBy: "sortBy",
      direction: "direction"
    },
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    selectionType: "single",
    selectionMethod: "basic",
    autoLoad: !0,
    notFoundText: void 0,
    width: void 0,
    minWidth: void 0,
    headerRowHeight: "fixed",
    bodyRowHeight: "autogrow",
    fontSize: void 0,
    primaryKey: void 0,
    locale: "en-us",
    defaultIconColumnWidth: 70,
    defaultCheckBoxColumnWidth: 70,
    style: {
      wrapper: "gj-grid-wrapper",
      table: "gj-grid gj-grid-md",
      loadingCover: "gj-grid-loading-cover",
      loadingText: "gj-grid-loading-text",
      header: {
        cell: void 0,
        sortable: "gj-cursor-pointer gj-unselectable"
      },
      content: {
        rowSelected: "gj-grid-md-select"
      }
    },
    icons: {
      asc: "▲",
      desc: "▼"
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-grid-wrapper",
      table: "gj-grid gj-grid-bootstrap gj-grid-bootstrap-3 table table-bordered table-hover",
      content: {
        rowSelected: "active"
      }
    },
    iconsLibrary: "glyphicons",
    defaultIconColumnWidth: 34,
    defaultCheckBoxColumnWidth: 36
  },
  bootstrap4: {
    style: {
      wrapper: "gj-grid-wrapper",
      table: "gj-grid gj-grid-bootstrap gj-grid-bootstrap-4 table table-bordered table-hover",
      content: {
        rowSelected: "active"
      }
    },
    defaultIconColumnWidth: 42,
    defaultCheckBoxColumnWidth: 44
  },
  materialicons: {
    icons: {
      asc: '<i class="gj-icon arrow-upward" />',
      desc: '<i class="gj-icon arrow-downward" />'
    }
  },
  fontawesome: {
    icons: {
      asc: '<i class="fa fa-sort-amount-asc" aria-hidden="true"></i>',
      desc: '<i class="fa fa-sort-amount-desc" aria-hidden="true"></i>'
    }
  },
  glyphicons: {
    icons: {
      asc: '<span class="glyphicon glyphicon-sort-by-alphabet" />',
      desc: '<span class="glyphicon glyphicon-sort-by-alphabet-alt" />'
    }
  }
}, gj.grid.events = {
  beforeEmptyRowInsert: function beforeEmptyRowInsert(a, b) {
    return a.triggerHandler("beforeEmptyRowInsert", [b]);
  },
  dataBinding: function dataBinding(a, b) {
    return a.triggerHandler("dataBinding", [b]);
  },
  dataBound: function dataBound(a, b, c) {
    return a.triggerHandler("dataBound", [b, c]);
  },
  rowDataBound: function rowDataBound(a, b, c, d) {
    return a.triggerHandler("rowDataBound", [b, c, d]);
  },
  cellDataBound: function cellDataBound(a, b, c, d, e) {
    return a.triggerHandler("cellDataBound", [b, c, d, e]);
  },
  rowSelect: function rowSelect(a, b, c, d) {
    return a.triggerHandler("rowSelect", [b, c, d]);
  },
  rowUnselect: function rowUnselect(a, b, c, d) {
    return a.triggerHandler("rowUnselect", [b, c, d]);
  },
  rowRemoving: function rowRemoving(a, b, c, d) {
    return a.triggerHandler("rowRemoving", [b, c, d]);
  },
  destroying: function destroying(a) {
    return a.triggerHandler("destroying");
  },
  columnHide: function columnHide(a, b) {
    return a.triggerHandler("columnHide", [b]);
  },
  columnShow: function columnShow(a, b) {
    return a.triggerHandler("columnShow", [b]);
  },
  initialized: function initialized(a) {
    return a.triggerHandler("initialized");
  },
  dataFiltered: function dataFiltered(a, b) {
    return a.triggerHandler("dataFiltered", [b]);
  }
}, gj.grid.methods = {
  init: function init(a) {
    return gj.widget.prototype.init.call(this, a, "grid"), gj.grid.methods.initialize(this), this.data("autoLoad") && this.reload(), this;
  },
  getConfig: function getConfig(a, b) {
    var c = gj.widget.prototype.getConfig.call(this, a, b);
    return gj.grid.methods.setDefaultColumnConfig(c.columns, c.defaultColumnSettings), c;
  },
  setDefaultColumnConfig: function setDefaultColumnConfig(a, b) {
    var c, d;
    if (a && a.length) for (d = 0; d < a.length; d++) c = $.extend(!0, {}, b), $.extend(!0, c, a[d]), a[d] = c;
  },
  getHTMLConfig: function getHTMLConfig() {
    var a = gj.widget.prototype.getHTMLConfig.call(this);
    return a.columns = [], this.find("thead > tr > th").each(function () {
      var b = $(this),
        c = b.text(),
        d = gj.widget.prototype.getHTMLConfig.call(b);
      d.title = c, d.field || (d.field = c), d.events && (d.events = gj.grid.methods.eventsParser(d.events)), a.columns.push(d);
    }), a;
  },
  eventsParser: function eventsParser(events) {
    var result = {},
      list,
      i,
      key,
      func,
      position;
    for (list = events.split(","), i = 0; i < list.length; i++) (position = list[i].indexOf(":")) > 0 && (key = $.trim(list[i].substr(0, position)), func = $.trim(list[i].substr(position + 1, list[i].length)), result[key] = eval("window." + func));
    return result;
  },
  initialize: function initialize(a) {
    var b = a.data(),
      c = a.parent('div[data-role="wrapper"]');
    gj.grid.methods.localization(b), 0 === c.length ? (c = $('<div data-role="wrapper" />').addClass(b.style.wrapper), a.wrap(c)) : c.addClass(b.style.wrapper), b.width && a.parent().css("width", b.width), b.minWidth && a.css("min-width", b.minWidth), b.fontSize && a.css("font-size", b.fontSize), "autogrow" === b.headerRowHeight && a.addClass("autogrow-header-row"), "fixed" === b.bodyRowHeight && a.addClass("fixed-body-rows"), a.addClass(b.style.table), "checkbox" === b.selectionMethod && b.columns.splice(gj.grid.methods.getColumnPositionNotInRole(a), 0, {
      title: "",
      width: b.defaultCheckBoxColumnWidth,
      align: "center",
      type: "checkbox",
      role: "selectRow",
      events: {
        click: function click(b) {
          gj.grid.methods.setSelected(a, b.data.id, $(this).closest("tr"));
        }
      },
      headerCssClass: "gj-grid-select-all",
      stopPropagation: !0
    }), 0 === a.children("tbody").length && a.append($("<tbody/>")), gj.grid.methods.renderHeader(a), gj.grid.methods.appendEmptyRow(a, "&nbsp;"), gj.grid.events.initialized(a);
  },
  localization: function localization(a) {
    a.notFoundText || (a.notFoundText = gj.grid.messages[a.locale].NoRecordsFound);
  },
  renderHeader: function renderHeader(a) {
    var b, c, d, e, f, g, h, i, j;
    for (b = a.data(), c = b.columns, d = b.style.header, e = a.children("thead"), 0 === e.length && (e = $("<thead />"), a.prepend(e)), f = $('<tr data-role="caption" />'), i = 0; i < c.length; i += 1) g = $('<th data-field="' + (c[i].field || "") + '" />'), c[i].width ? g.attr("width", c[i].width) : "checkbox" === c[i].type && g.attr("width", b.defaultIconColumnWidth), g.addClass(d.cell), c[i].headerCssClass && g.addClass(c[i].headerCssClass), g.css("text-align", c[i].align || "left"), "checkbox" === b.selectionMethod && "multiple" === b.selectionType && "checkbox" === c[i].type && "selectRow" === c[i].role ? (j = g.find('input[data-role="selectAll"]'), 0 === j.length && (j = $('<input type="checkbox" data-role="selectAll" />'), g.append(j), j.checkbox({
      uiLibrary: b.uiLibrary
    })), j.off("click").on("click", function () {
      this.checked ? a.selectAll() : a.unSelectAll();
    })) : (h = $('<div data-role="title"/>').html(void 0 === c[i].title ? c[i].field : c[i].title), g.append(h), c[i].sortable && (h.addClass(d.sortable), h.on("click", gj.grid.methods.createSortHandler(a, c[i])))), c[i].hidden && g.hide(), f.append(g);
    e.empty().append(f);
  },
  createSortHandler: function createSortHandler(a, b) {
    return function () {
      var c,
        d = {};
      a.count() > 0 && (c = a.data(), d[c.paramNames.sortBy] = b.field, b.direction = "asc" === b.direction ? "desc" : "asc", d[c.paramNames.direction] = b.direction, a.reload(d));
    };
  },
  updateHeader: function updateHeader(a) {
    var b,
      c,
      d = a.data(),
      e = d.params[d.paramNames.sortBy],
      f = d.params[d.paramNames.direction];
    a.find('thead tr th [data-role="sorticon"]').remove(), e && (position = gj.grid.methods.getColumnPosition(a.data("columns"), e), position > -1 && (c = a.find("thead tr th:eq(" + position + ') div[data-role="title"]'), b = $('<div data-role="sorticon" class="gj-unselectable" />').append("desc" === f ? d.icons.desc : d.icons.asc), c.after(b)));
  },
  useHtmlDataSource: function useHtmlDataSource(a, b) {
    var c,
      d,
      e,
      f,
      g = [],
      h = a.find('tbody tr[data-role != "empty"]');
    for (c = 0; c < h.length; c++) {
      for (e = $(h[c]).find("td"), f = {}, d = 0; d < e.length; d++) f[b.columns[d].field] = $(e[d]).html();
      g.push(f);
    }
    b.dataSource = g;
  },
  startLoading: function startLoading(a) {
    var b, c, d, e, f, g, h;
    gj.grid.methods.stopLoading(a), h = a.data(), 0 !== a.outerHeight() && (b = a.children("tbody"), e = b.outerWidth(!1), f = b.outerHeight(!1), g = Math.abs(a.parent().offset().top - b.offset().top), c = $('<div data-role="loading-cover" />').addClass(h.style.loadingCover).css({
      width: e,
      height: f,
      top: g
    }), d = $('<div data-role="loading-text">' + gj.grid.messages[h.locale].Loading + "</div>").addClass(h.style.loadingText), d.insertAfter(a), c.insertAfter(a), d.css({
      top: g + f / 2 - d.outerHeight(!1) / 2,
      left: e / 2 - d.outerWidth(!1) / 2
    }));
  },
  stopLoading: function stopLoading(a) {
    a.parent().find('div[data-role="loading-cover"]').remove(), a.parent().find('div[data-role="loading-text"]').remove();
  },
  appendEmptyRow: function appendEmptyRow(a, b) {
    var c, d, e, f;
    c = a.data(), d = $('<tr data-role="empty"/>'), e = $("<td/>").css({
      width: "100%",
      "text-align": "center"
    }), e.attr("colspan", gj.grid.methods.countVisibleColumns(a)), f = $("<div />").html(b || c.notFoundText), e.append(f), d.append(e), gj.grid.events.beforeEmptyRowInsert(a, d), a.append(d);
  },
  autoGenerateColumns: function autoGenerateColumns(a, b) {
    var c,
      d,
      e,
      f,
      g = a.data();
    if (g.columns = [], b.length > 0) {
      for (c = Object.getOwnPropertyNames(b[0]), f = 0; f < c.length; f++) d = b[0][c[f]], e = "text", d && ("number" == typeof d ? e = "number" : d.indexOf("/Date(") > -1 && (e = "date")), g.columns.push({
        field: c[f],
        type: e
      });
      gj.grid.methods.setDefaultColumnConfig(g.columns, g.defaultColumnSettings);
    }
    gj.grid.methods.renderHeader(a);
  },
  loadData: function loadData(a) {
    var b, c, d, e, f, g, h, i;
    for (b = a.data(), c = a.getAll(), gj.grid.events.dataBinding(a, c), e = c.length, gj.grid.methods.stopLoading(a), b.autoGenerateColumns && gj.grid.methods.autoGenerateColumns(a, c), g = a.children("tbody"), "checkbox" === b.selectionMethod && "multiple" === b.selectionType && a.find('thead input[data-role="selectAll"]').prop("checked", !1), g.children("tr").not('[data-role="row"]').remove(), 0 === e && (g.empty(), gj.grid.methods.appendEmptyRow(a)), h = g.children("tr"), f = h.length, d = 0; d < f; d++) {
      if (!(d < e)) {
        g.find('tr[data-role="row"]:gt(' + (d - 1) + ")").remove();
        break;
      }
      i = h.eq(d), gj.grid.methods.renderRow(a, i, c[d], d);
    }
    for (d = f; d < e; d++) gj.grid.methods.renderRow(a, null, c[d], d);
    gj.grid.events.dataBound(a, c, b.totalRecords);
  },
  getId: function getId(a, b, c) {
    return b && a[b] ? a[b] : c;
  },
  renderRow: function renderRow(a, b, c, d) {
    var e, f, g, h, i;
    for (h = a.data(), b && 0 !== b.length ? (i = "update", b.removeClass(h.style.content.rowSelected).removeAttr("data-selected").off("click")) : (i = "create", b = $('<tr data-role="row"/>'), a.children("tbody").append(b)), e = gj.grid.methods.getId(c, h.primaryKey, d + 1), b.attr("data-position", d + 1), "checkbox" !== h.selectionMethod && b.on("click", gj.grid.methods.createRowClickHandler(a, e)), g = 0; g < h.columns.length; g++) "update" === i ? (f = b.find("td:eq(" + g + ")"), gj.grid.methods.renderCell(a, f, h.columns[g], c, e)) : (f = gj.grid.methods.renderCell(a, null, h.columns[g], c, e), b.append(f));
    gj.grid.events.rowDataBound(a, b, e, c);
  },
  renderCell: function renderCell(a, b, c, d, e, f) {
    var g, h;
    if (b && 0 !== b.length ? (g = b.find('div[data-role="display"]'), f = "update") : (b = $("<td/>"), g = $('<div data-role="display" />'), c.align && b.css("text-align", c.align), c.cssClass && b.addClass(c.cssClass), b.append(g), f = "create"), gj.grid.methods.renderDisplayElement(a, g, c, d, e, f), "update" === f && (b.off(), g.off()), c.events) for (h in c.events) c.events.hasOwnProperty(h) && b.on(h, {
      id: e,
      field: c.field,
      record: d
    }, gj.grid.methods.createCellEventHandler(c, c.events[h]));
    return c.hidden && b.hide(), gj.grid.events.cellDataBound(a, g, e, c, d), b;
  },
  createCellEventHandler: function createCellEventHandler(a, b) {
    return function (c) {
      a.stopPropagation && c.stopPropagation(), b.call(this, c);
    };
  },
  renderDisplayElement: function renderDisplayElement(a, b, c, d, e, f) {
    var g, h;
    "checkbox" === c.type && gj.checkbox ? "create" === f ? (h = $('<input type="checkbox" />').val(e).prop("checked", !!d[c.field]), c.role && h.attr("data-role", c.role), b.append(h), h.checkbox({
      uiLibrary: a.data("uiLibrary")
    }), "selectRow" === c.role ? h.on("click", function () {
      return !1;
    }) : h.prop("disabled", !0)) : b.find('input[type="checkbox"]').val(e).prop("checked", !!d[c.field]) : "icon" === c.type ? "create" === f && (b.append($("<span/>").addClass(c.icon).css({
      cursor: "pointer"
    })), "bootstrap" === a.data().uiLibrary && b.children("span").addClass("glyphicon"), c.stopPropagation = !0) : c.tmpl ? (g = c.tmpl, c.tmpl.replace(/\{(.+?)\}/g, function (a, b) {
      g = g.replace(a, gj.grid.methods.formatText(d[b], c));
    }), b.html(g)) : c.renderer && "function" == typeof c.renderer ? (g = c.renderer(d[c.field], d, b.parent(), b, e, a)) && b.html(g) : (d[c.field] = gj.grid.methods.formatText(d[c.field], c), !c.tooltip && d[c.field] && b.attr("title", d[c.field]), b.html(d[c.field])), c.tooltip && "create" === f && b.attr("title", c.tooltip);
  },
  formatText: function formatText(a, b) {
    return a = a && ["date", "time", "datetime"].indexOf(b.type) > -1 ? gj.core.formatDate(gj.core.parseDate(a, b.format), b.format) : void 0 === a || null === a ? "" : a.toString(), b.decimalDigits && a && (a = parseFloat(a).toFixed(b.decimalDigits)), a;
  },
  setRecordsData: function setRecordsData(a, b) {
    var c = [],
      d = 0,
      e = a.data();
    return $.isArray(b) ? (c = b, d = b.length) : e && e.mapping && $.isArray(b[e.mapping.dataField]) && (c = b[e.mapping.dataField], (d = b[e.mapping.totalRecordsField]) && !isNaN(d) || (d = 0)), a.data("records", c), a.data("totalRecords", d), c;
  },
  createRowClickHandler: function createRowClickHandler(a, b) {
    return function () {
      gj.grid.methods.setSelected(a, b, $(this));
    };
  },
  selectRow: function selectRow(a, b, c, d) {
    var e;
    return c.addClass(b.style.content.rowSelected), c.attr("data-selected", "true"), "checkbox" === b.selectionMethod && (e = c.find('input[type="checkbox"][data-role="selectRow"]'), e.length && !e.prop("checked") && e.prop("checked", !0), "multiple" === b.selectionType && a.getSelections().length === a.count(!1) && a.find('thead input[data-role="selectAll"]').prop("checked", !0)), gj.grid.events.rowSelect(a, c, d, a.getById(d));
  },
  unselectRow: function unselectRow(a, b, c, d) {
    var e;
    if ("true" === c.attr("data-selected")) return c.removeClass(b.style.content.rowSelected), "checkbox" === b.selectionMethod && (e = c.find('td input[type="checkbox"][data-role="selectRow"]'), e.length && e.prop("checked") && e.prop("checked", !1), "multiple" === b.selectionType && a.find('thead input[data-role="selectAll"]').prop("checked", !1)), c.removeAttr("data-selected"), gj.grid.events.rowUnselect(a, c, d, a.getById(d));
  },
  setSelected: function setSelected(a, b, c) {
    var d = a.data();
    return c && c.length || (c = gj.grid.methods.getRowById(a, b)), c && ("true" === c.attr("data-selected") ? gj.grid.methods.unselectRow(a, d, c, b) : ("single" === d.selectionType && c.siblings('[data-selected="true"]').each(function () {
      var b = $(this),
        c = gj.grid.methods.getId(b, d.primaryKey, b.data("position"));
      gj.grid.methods.unselectRow(a, d, b, c);
    }), gj.grid.methods.selectRow(a, d, c, b))), a;
  },
  selectAll: function selectAll(a) {
    var b = a.data();
    return a.find('tbody tr[data-role="row"]').each(function () {
      var c = $(this),
        d = c.data("position"),
        e = a.get(d),
        f = gj.grid.methods.getId(e, b.primaryKey, d);
      gj.grid.methods.selectRow(a, b, c, f);
    }), a.find('thead input[data-role="selectAll"]').prop("checked", !0), a;
  },
  unSelectAll: function unSelectAll(a) {
    var b = a.data();
    return a.find("tbody tr").each(function () {
      var c = $(this),
        d = c.data("position"),
        e = a.get(d),
        f = gj.grid.methods.getId(e, b.primaryKey, d);
      gj.grid.methods.unselectRow(a, b, c, f), c.find('input[type="checkbox"][data-role="selectRow"]').prop("checked", !1);
    }), a.find('thead input[data-role="selectAll"]').prop("checked", !1), a;
  },
  getSelected: function getSelected(a) {
    var b,
      c,
      d,
      e = null;
    return b = a.find('tbody>tr[data-selected="true"]'), b.length > 0 && (d = $(b[0]).data("position"), c = a.get(d), e = gj.grid.methods.getId(c, a.data().primaryKey, d)), e;
  },
  getSelectedRows: function getSelectedRows(a) {
    a.data();
    return a.find('tbody>tr[data-selected="true"]');
  },
  getSelections: function getSelections(a) {
    var b,
      c,
      d = [],
      e = a.data(),
      f = gj.grid.methods.getSelectedRows(a);
    return 0 < f.length && f.each(function () {
      b = $(this).data("position"), c = a.get(b), d.push(gj.grid.methods.getId(c, e.primaryKey, b));
    }), d;
  },
  getById: function getById(a, b) {
    var c,
      d = null,
      e = a.data("primaryKey"),
      f = a.data("records");
    if (e) {
      for (c = 0; c < f.length; c++) if (f[c][e] == b) {
        d = f[c];
        break;
      }
    } else d = a.get(b);
    return d;
  },
  getRecVPosById: function getRecVPosById(a, b) {
    var c,
      d = b,
      e = a.data();
    if (e.primaryKey) for (c = 0; c < e.dataSource.length; c++) if (e.dataSource[c][e.primaryKey] == b) {
      d = c;
      break;
    }
    return d;
  },
  getRowById: function getRowById(a, b) {
    var c,
      d,
      e = a.getAll(!1),
      f = a.data("primaryKey"),
      g = void 0;
    if (f) {
      for (d = 0; d < e.length; d++) if (e[d][f] == b) {
        c = d + 1;
        break;
      }
    } else c = b;
    return c && (g = a.children("tbody").children('tr[data-position="' + c + '"]')), g;
  },
  getByPosition: function getByPosition(a, b) {
    return a.getAll(!1)[b - 1];
  },
  getColumnPosition: function getColumnPosition(a, b) {
    var c,
      d = -1;
    for (c = 0; c < a.length; c++) if (a[c].field === b) {
      d = c;
      break;
    }
    return d;
  },
  getColumnInfo: function getColumnInfo(a, b) {
    var c,
      d = {},
      e = a.data();
    for (c = 0; c < e.columns.length; c += 1) if (e.columns[c].field === b) {
      d = e.columns[c];
      break;
    }
    return d;
  },
  getCell: function getCell(a, b, c) {
    var d,
      e,
      f = null;
    return d = gj.grid.methods.getColumnPosition(a.data("columns"), c), d > -1 && (e = gj.grid.methods.getRowById(a, b), f = e.find("td:eq(" + d + ') div[data-role="display"]')), f;
  },
  setCellContent: function setCellContent(a, b, c, d) {
    var e,
      f = gj.grid.methods.getCell(a, b, c);
    f && (f.empty(), "object" == _typeof(d) ? f.append(d) : (e = gj.grid.methods.getColumnInfo(a, c), gj.grid.methods.renderDisplayElement(a, f, e, a.getById(b), b, "update")));
  },
  clone: function clone(a) {
    var b = [];
    return $.each(a, function () {
      b.push(this.clone());
    }), b;
  },
  getAll: function getAll(a) {
    return a.data("records");
  },
  countVisibleColumns: function countVisibleColumns(a) {
    var b, c, d;
    for (b = a.data().columns, c = 0, d = 0; d < b.length; d++) !0 !== b[d].hidden && c++;
    return c;
  },
  clear: function clear(a, b) {
    var c = a.data();
    return a.xhr && a.xhr.abort(), a.children("tbody").empty(), c.records = [], gj.grid.methods.stopLoading(a), gj.grid.methods.appendEmptyRow(a, b ? c.notFoundText : "&nbsp;"), gj.grid.events.dataBound(a, [], 0), a;
  },
  render: function render(a, b) {
    return b && (gj.grid.methods.setRecordsData(a, b), gj.grid.methods.updateHeader(a), gj.grid.methods.loadData(a)), a;
  },
  filter: function filter(a) {
    var b,
      c,
      d = a.data(),
      e = d.dataSource.slice();
    d.params[d.paramNames.sortBy] && (c = gj.grid.methods.getColumnInfo(a, d.params[d.paramNames.sortBy]), e.sort(c.sortable.sorter ? c.sortable.sorter(c.direction, c) : gj.grid.methods.createDefaultSorter(c.direction, c.field)));
    for (b in d.params) d.params[b] && !d.paramNames[b] && (c = gj.grid.methods.getColumnInfo(a, b), e = $.grep(e, function (a) {
      var e = a[b] || "",
        f = d.params[b] || "";
      return c && "function" == typeof c.filter ? c.filter(e, f) : e.toUpperCase().indexOf(f.toUpperCase()) > -1;
    }));
    return gj.grid.events.dataFiltered(a, e), e;
  },
  createDefaultSorter: function createDefaultSorter(a, b) {
    return function (c, d) {
      var e = (c[b] || "").toString(),
        f = (d[b] || "").toString();
      return "asc" === a ? e.localeCompare(f) : f.localeCompare(e);
    };
  },
  destroy: function destroy(a, b, c) {
    return a.data() && (gj.grid.events.destroying(a), gj.grid.methods.stopLoading(a), a.xhr && a.xhr.abort(), a.off(), !1 === c && a.parent('div[data-role="wrapper"]').length > 0 && a.unwrap(), a.removeData(), !1 === b ? a.remove() : a.removeClass().empty(), a.removeAttr("data-type")), a;
  },
  showColumn: function showColumn(a, b) {
    var c,
      d = a.data(),
      e = gj.grid.methods.getColumnPosition(d.columns, b);
    return e > -1 && (a.find("thead>tr").each(function () {
      $(this).children("th").eq(e).show();
    }), $.each(a.find("tbody>tr"), function () {
      $(this).children("td").eq(e).show();
    }), d.columns[e].hidden = !1, c = a.find('tbody > tr[data-role="empty"] > td'), c && c.length && c.attr("colspan", gj.grid.methods.countVisibleColumns(a)), gj.grid.events.columnShow(a, d.columns[e])), a;
  },
  hideColumn: function hideColumn(a, b) {
    var c,
      d = a.data(),
      e = gj.grid.methods.getColumnPosition(d.columns, b);
    return e > -1 && (a.find("thead>tr").each(function () {
      $(this).children("th").eq(e).hide();
    }), $.each(a.find("tbody>tr"), function () {
      $(this).children("td").eq(e).hide();
    }), d.columns[e].hidden = !0, c = a.find('tbody > tr[data-role="empty"] > td'), c && c.length && c.attr("colspan", gj.grid.methods.countVisibleColumns(a)), gj.grid.events.columnHide(a, d.columns[e])), a;
  },
  isLastRecordVisible: function isLastRecordVisible() {
    return !0;
  },
  addRow: function addRow(a, b) {
    var c = a.data();
    return c.totalRecords = a.data("totalRecords") + 1, gj.grid.events.dataBinding(a, [b]), c.records.push(b), $.isArray(c.dataSource) && c.dataSource.push(b), 1 === c.totalRecords && a.children("tbody").empty(), gj.grid.methods.isLastRecordVisible(a) && gj.grid.methods.renderRow(a, null, b, a.count() - 1), gj.grid.events.dataBound(a, [b], c.totalRecords), a;
  },
  updateRow: function updateRow(a, b, c) {
    var d,
      e = gj.grid.methods.getRowById(a, b),
      f = a.data();
    return f.records[e.data("position") - 1] = c, $.isArray(f.dataSource) && (d = gj.grid.methods.getRecVPosById(a, b), f.dataSource[d] = c), gj.grid.methods.renderRow(a, e, c, e.index()), a;
  },
  removeRow: function removeRow(a, b) {
    var c,
      d = a.data(),
      e = gj.grid.methods.getRowById(a, b);
    return gj.grid.events.rowRemoving(a, e, b, a.getById(b)), $.isArray(d.dataSource) && (c = gj.grid.methods.getRecVPosById(a, b), d.dataSource.splice(c, 1)), a.reload(), a;
  },
  count: function count(a, b) {
    return b ? a.data().totalRecords : a.getAll().length;
  },
  getColumnPositionByRole: function getColumnPositionByRole(a, b) {
    var c,
      d,
      e = a.data("columns");
    for (c = 0; c < e.length; c++) if (e[c].role === b) {
      d = c;
      break;
    }
    return d;
  },
  getColumnPositionNotInRole: function getColumnPositionNotInRole(a) {
    var b,
      c = 0,
      d = a.data("columns");
    for (b = 0; b < d.length; b++) if (!d[b].role) {
      c = b;
      break;
    }
    return c;
  }
}, gj.grid.widget = function (a, b) {
  var c = this,
    d = gj.grid.methods;
  return c.reload = function (a) {
    return d.startLoading(this), gj.widget.prototype.reload.call(this, a);
  }, c.clear = function (a) {
    return d.clear(this, a);
  }, c.count = function (a) {
    return d.count(this, a);
  }, c.render = function (b) {
    return d.render(a, b);
  }, c.destroy = function (a, b) {
    return d.destroy(this, a, b);
  }, c.setSelected = function (a) {
    return d.setSelected(this, a);
  }, c.getSelected = function () {
    return d.getSelected(this);
  }, c.getSelections = function () {
    return d.getSelections(this);
  }, c.selectAll = function () {
    return d.selectAll(this);
  }, c.unSelectAll = function () {
    return d.unSelectAll(this);
  }, c.getById = function (a) {
    return d.getById(this, a);
  }, c.get = function (a) {
    return d.getByPosition(this, a);
  }, c.getAll = function (a) {
    return d.getAll(this, a);
  }, c.showColumn = function (a) {
    return d.showColumn(this, a);
  }, c.hideColumn = function (a) {
    return d.hideColumn(this, a);
  }, c.addRow = function (a) {
    return d.addRow(this, a);
  }, c.updateRow = function (a, b) {
    return d.updateRow(this, a, b);
  }, c.setCellContent = function (a, b, c) {
    d.setCellContent(this, a, b, c);
  }, c.removeRow = function (a) {
    return d.removeRow(this, a);
  }, $.extend(a, c), "grid" !== a.attr("data-type") && d.init.call(a, b), a;
}, gj.grid.widget.prototype = new gj.widget(), gj.grid.widget.constructor = gj.grid.widget, gj.grid.widget.prototype.getConfig = gj.grid.methods.getConfig, gj.grid.widget.prototype.getHTMLConfig = gj.grid.methods.getHTMLConfig, function (a) {
  a.fn.grid = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.grid.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.grid.widget(this, a);
    }
  };
}(jQuery), gj.grid.plugins.fixedHeader = {
  config: {
    base: {
      fixedHeader: !1,
      height: 300
    }
  },
  "private": {
    init: function init(a) {
      var b = a.data(),
        c = a.children("tbody"),
        d = a.children("thead"),
        e = b.height - d.outerHeight() - (a.children("tfoot").outerHeight() || 0);
      a.addClass("gj-grid-scrollable"), c.css("width", d.outerWidth()), c.height(e);
    },
    refresh: function refresh(a) {
      var b,
        c,
        d = (a.data(), a.children("tbody")),
        e = a.children("thead"),
        f = a.find('tbody tr[data-role="row"] td'),
        g = a.find('thead tr[data-role="caption"] th');
      for (a.children("tbody").height() < gj.grid.plugins.fixedHeader["private"].getRowsHeight(a) ? d.css("width", e.outerWidth() + gj.grid.plugins.fixedHeader["private"].getScrollBarWidth() + (navigator.userAgent.toLowerCase().indexOf("firefox") > -1 ? 1 : 0)) : d.css("width", e.outerWidth()), b = 0; b < g.length; b++) c = $(g[b]).outerWidth(), 0 === b && gj.core.isIE() && (c -= 1), $(f[b]).attr("width", c);
    },
    getRowsHeight: function getRowsHeight(a) {
      var b = 0;
      return a.find("tbody tr").each(function () {
        b += $(this).height();
      }), b;
    },
    getScrollBarWidth: function getScrollBarWidth() {
      var a = document.createElement("p");
      a.style.width = "100%", a.style.height = "200px";
      var b = document.createElement("div");
      b.style.position = "absolute", b.style.top = "0px", b.style.left = "0px", b.style.visibility = "hidden", b.style.width = "200px", b.style.height = "150px", b.style.overflow = "hidden", b.appendChild(a), document.body.appendChild(b);
      var c = a.offsetWidth;
      b.style.overflow = "scroll";
      var d = a.offsetWidth;
      return c == d && (d = b.clientWidth), document.body.removeChild(b), c - d;
    }
  },
  "public": {},
  events: {},
  configure: function configure(a, b, c) {
    $.extend(!0, a, gj.grid.plugins.fixedHeader["public"]);
    a.data();
    c.fixedHeader && (a.on("initialized", function () {
      gj.grid.plugins.fixedHeader["private"].init(a);
    }), a.on("dataBound", function () {
      gj.grid.plugins.fixedHeader["private"].refresh(a);
    }), a.on("resize", function () {
      gj.grid.plugins.fixedHeader["private"].refresh(a);
    }));
  }
}, gj.grid.plugins.expandCollapseRows = {
  config: {
    base: {
      detailTemplate: void 0,
      keepExpandedRows: !0,
      expandedRows: [],
      icons: {
        expandRow: '<i class="gj-icon chevron-right" />',
        collapseRow: '<i class="gj-icon chevron-down" />'
      }
    },
    fontawesome: {
      icons: {
        expandRow: '<i class="fa fa-angle-right" aria-hidden="true"></i>',
        collapseRow: '<i class="fa fa-angle-down" aria-hidden="true"></i>'
      }
    },
    glyphicons: {
      icons: {
        expandRow: '<span class="glyphicon glyphicon-chevron-right" />',
        collapseRow: '<span class="glyphicon glyphicon-chevron-down" />'
      }
    }
  },
  "private": {
    expandDetail: function expandDetail(a, b, c) {
      var d = b.closest("tr"),
        e = $('<tr data-role="details" />'),
        f = $('<td colspan="' + gj.grid.methods.countVisibleColumns(a) + '" />'),
        g = $('<div data-role="display" />'),
        h = a.data(),
        i = d.data("position"),
        j = a.get(i),
        k = gj.grid.plugins.expandCollapseRows;
      void 0 === _typeof(c) && (c = gj.grid.methods.getId(j, h.primaryKey, j)), e.append(f.append(g.append(d.data("details")))), e.insertAfter(d), b.children('div[data-role="display"]').empty().append(h.icons.collapseRow), a.updateDetails(d), k["private"].keepSelection(a, c), k.events.detailExpand(a, e.find("td>div"), c);
    },
    collapseDetail: function collapseDetail(a, b, c) {
      var d = b.closest("tr"),
        e = d.next('tr[data-role="details"]'),
        f = a.data(),
        g = gj.grid.plugins.expandCollapseRows;
      void 0 === _typeof(c) && (c = gj.grid.methods.getId(record, f.primaryKey, record)), e.remove(), b.children('div[data-role="display"]').empty().append(f.icons.expandRow), g["private"].removeSelection(a, c), g.events.detailCollapse(a, e.find("td>div"), c);
    },
    keepSelection: function keepSelection(a, b) {
      var c = a.data();
      c.keepExpandedRows && ($.isArray(c.expandedRows) ? -1 == c.expandedRows.indexOf(b) && c.expandedRows.push(b) : c.expandedRows = [b]);
    },
    removeSelection: function removeSelection(a, b) {
      var c = a.data();
      c.keepExpandedRows && $.isArray(c.expandedRows) && c.expandedRows.indexOf(b) > -1 && c.expandedRows.splice(c.expandedRows.indexOf(b), 1);
    },
    updateDetailsColSpan: function updateDetailsColSpan(a) {
      var b = a.find('tbody > tr[data-role="details"] > td');
      b && b.length && b.attr("colspan", gj.grid.methods.countVisibleColumns(a));
    }
  },
  "public": {
    collapseAll: function collapseAll() {
      var a,
        b = this,
        c = b.data();
      return void 0 !== c.detailTemplate && (a = gj.grid.methods.getColumnPositionByRole(b, "expander"), b.find('tbody tr[data-role="row"]').each(function () {
        gj.grid.plugins.expandCollapseRows["private"].collapseDetail(b, $(this).find("td:eq(" + a + ")"));
      })), void 0 !== c.grouping && b.find('tbody tr[role="group"]').each(function () {
        gj.grid.plugins.grouping["private"].collapseGroup(c, $(this).find("td:eq(0)"));
      }), b;
    },
    expandAll: function expandAll() {
      var a,
        b = this,
        c = b.data();
      return void 0 !== c.detailTemplate && (a = gj.grid.methods.getColumnPositionByRole(b, "expander"), b.find('tbody tr[data-role="row"]').each(function () {
        gj.grid.plugins.expandCollapseRows["private"].expandDetail(b, $(this).find("td:eq(" + a + ")"));
      })), void 0 !== c.grouping && b.find('tbody tr[role="group"]').each(function () {
        gj.grid.plugins.grouping["private"].expandGroup(c, $(this).find("td:eq(0)"));
      }), b;
    },
    updateDetails: function updateDetails(a) {
      var b = this,
        c = a.data("details"),
        d = c.html(),
        e = b.get(a.data("position"));
      return e && d && (c.html().replace(/\{(.+?)\}/g, function (a, c) {
        var f = gj.grid.methods.getColumnInfo(b, c);
        d = d.replace(a, gj.grid.methods.formatText(e[c], f));
      }), c.html(d)), b;
    }
  },
  events: {
    detailExpand: function detailExpand(a, b, c) {
      a.triggerHandler("detailExpand", [b, c]);
    },
    detailCollapse: function detailCollapse(a, b, c) {
      a.triggerHandler("detailCollapse", [b, c]);
    }
  },
  configure: function configure(a) {
    var b,
      c = a.data();
    $.extend(!0, a, gj.grid.plugins.expandCollapseRows["public"]), void 0 !== c.detailTemplate && (b = {
      title: "",
      width: c.defaultIconColumnWidth,
      align: "center",
      stopPropagation: !0,
      cssClass: "gj-cursor-pointer gj-unselectable",
      tmpl: c.icons.expandRow,
      role: "expander",
      events: {
        click: function click(b) {
          var c = $(this),
            d = gj.grid.plugins.expandCollapseRows["private"];
          "details" === c.closest("tr").next().attr("data-role") ? d.collapseDetail(a, c, b.data.id) : d.expandDetail(a, $(this), b.data.id);
        }
      }
    }, c.columns = [b].concat(c.columns), a.on("rowDataBound", function (a, b, d, e) {
      b.data("details", $(c.detailTemplate));
    }), a.on("columnShow", function (b, c) {
      gj.grid.plugins.expandCollapseRows["private"].updateDetailsColSpan(a);
    }), a.on("columnHide", function (b, c) {
      gj.grid.plugins.expandCollapseRows["private"].updateDetailsColSpan(a);
    }), a.on("rowRemoving", function (b, c, d, e) {
      gj.grid.plugins.expandCollapseRows["private"].collapseDetail(a, c.children("td").first(), d);
    }), a.on("dataBinding", function () {
      a.collapseAll();
    }), a.on("pageChanging", function () {
      a.collapseAll();
    }), a.on("dataBound", function () {
      var b,
        c,
        d,
        e,
        f = a.data();
      if (f.keepExpandedRows && $.isArray(f.expandedRows)) for (b = 0; b < f.expandedRows.length; b++) (d = gj.grid.methods.getRowById(a, f.expandedRows[b])) && d.length && (e = gj.grid.methods.getColumnPositionByRole(a, "expander"), (c = d.children("td:eq(" + e + ")")) && c.length && gj.grid.plugins.expandCollapseRows["private"].expandDetail(a, c));
    }));
  }
}, gj.grid.plugins.inlineEditing = {
  renderers: {
    editManager: function editManager(a, b, c, d, e, f) {
      var g = f.data(),
        h = $(g.inlineEditing.editButton).attr("key", e),
        i = $(g.inlineEditing.deleteButton).attr("key", e),
        j = $(g.inlineEditing.updateButton).attr("key", e).hide(),
        k = $(g.inlineEditing.cancelButton).attr("key", e).hide();
      h.on("click", function (a) {
        f.edit($(this).attr("key"));
      }), i.on("click", function (a) {
        f.removeRow($(this).attr("key"));
      }), j.on("click", function (a) {
        f.update($(this).attr("key"));
      }), k.on("click", function (a) {
        f.cancel($(this).attr("key"));
      }), d.empty().append(h).append(i).append(j).append(k);
    }
  }
}, gj.grid.plugins.inlineEditing.config = {
  base: {
    defaultColumnSettings: {
      editor: void 0,
      editField: void 0,
      mode: "readEdit"
    },
    inlineEditing: {
      mode: "click",
      managementColumn: !0,
      managementColumnConfig: {
        width: 300,
        role: "managementColumn",
        align: "center",
        renderer: gj.grid.plugins.inlineEditing.renderers.editManager,
        cssClass: "gj-grid-management-column"
      }
    }
  },
  bootstrap: {
    inlineEditing: {
      managementColumnConfig: {
        width: 200,
        role: "managementColumn",
        align: "center",
        renderer: gj.grid.plugins.inlineEditing.renderers.editManager,
        cssClass: "gj-grid-management-column"
      }
    }
  },
  bootstrap4: {
    inlineEditing: {
      managementColumnConfig: {
        width: 280,
        role: "managementColumn",
        align: "center",
        renderer: gj.grid.plugins.inlineEditing.renderers.editManager,
        cssClass: "gj-grid-management-column"
      }
    }
  }
}, gj.grid.plugins.inlineEditing["private"] = {
  localization: function localization(a) {
    "bootstrap" === a.uiLibrary ? (a.inlineEditing.editButton = '<button role="edit" class="btn btn-default btn-sm"><span class="glyphicon glyphicon-pencil" aria-hidden="true"></span> ' + gj.grid.messages[a.locale].Edit + "</button>", a.inlineEditing.deleteButton = '<button role="delete" class="btn btn-default btn-sm gj-margin-left-10"><span class="glyphicon glyphicon-remove" aria-hidden="true"></span> ' + gj.grid.messages[a.locale].Delete + "</button>", a.inlineEditing.updateButton = '<button role="update" class="btn btn-default btn-sm"><span class="glyphicon glyphicon-ok" aria-hidden="true"></span> ' + gj.grid.messages[a.locale].Update + "</button>", a.inlineEditing.cancelButton = '<button role="cancel" class="btn btn-default btn-sm gj-margin-left-10"><span class="glyphicon glyphicon-ban-circle" aria-hidden="true"></span> ' + gj.grid.messages[a.locale].Cancel + "</button>") : (a.inlineEditing.editButton = '<button role="edit" class="gj-button-md"><i class="gj-icon pencil" /> ' + gj.grid.messages[a.locale].Edit.toUpperCase() + "</button>", a.inlineEditing.deleteButton = '<button role="delete" class="gj-button-md"><i class="gj-icon delete" /> ' + gj.grid.messages[a.locale].Delete.toUpperCase() + "</button>", a.inlineEditing.updateButton = '<button role="update" class="gj-button-md"><i class="gj-icon check-circle" /> ' + gj.grid.messages[a.locale].Update.toUpperCase() + "</button>", a.inlineEditing.cancelButton = '<button role="cancel" class="gj-button-md"><i class="gj-icon cancel" /> ' + gj.grid.messages[a.locale].Cancel.toUpperCase() + "</button>");
  },
  editMode: function editMode(a, b, c, d) {
    var e,
      f,
      g,
      h,
      i,
      j = a.data();
    if ("edit" !== b.attr("data-mode")) if (c.editor) {
      if (gj.grid.plugins.inlineEditing["private"].updateOtherCells(a, c.mode), e = b.find('div[data-role="display"]').hide(), f = b.find('div[data-role="edit"]').show(), 0 === f.length && (f = $('<div data-role="edit" />'), b.append(f)), h = d[c.editField || c.field], g = f.find("input, select, textarea").first(), g.length) switch (c.type) {
        case "checkbox":
          g.prop("checked", h);
          break;
        case "dropdown":
          g = g.dropdown("value", h);
          break;
        default:
          g.val(h);
      } else {
        if ("function" == typeof c.editor) c.editor(f, h, d), g = f.find("input, select, textarea").first();else if (i = "object" == _typeof(c.editor) ? c.editor : {}, i.uiLibrary = j.uiLibrary, i.iconsLibrary = j.iconsLibrary, i.fontSize = a.css("font-size"), i.showOnFocus = !1, "checkbox" === c.type && gj.checkbox) g = $('<input type="checkbox" />').prop("checked", h), f.append(g), g.checkbox(i);else if ("date" === c.type && gj.datepicker || "time" === c.type && gj.timepicker || "datetime" === c.type && gj.datetimepicker) {
          switch (g = $('<input type="text" width="100%"/>'), f.append(g), c.format && (i.format = c.format), c.type) {
            case "date":
              g = g.datepicker(i);
              break;
            case "time":
              g = g.timepicker(i);
              break;
            case "datetime":
              g = g.datetimepicker(i);
          }
          g.value && g.value(e.html());
        } else "dropdown" === c.type && gj.dropdown ? (g = $('<select type="text" width="100%"/>'), f.append(g), i.dataBound = function (a) {
          var b = $(this).dropdown();
          c.editField ? b.value(d[c.editField]) : b.value(d[c.field]);
        }, g = g.dropdown(i)) : (g = $('<input type="text" value="' + h + '" class="gj-width-full"/>'), "materialdesign" === j.uiLibrary && g.addClass("gj-textbox-md").css("font-size", a.css("font-size")), f.append(g));
        "command" !== j.inlineEditing.mode && "editOnly" !== c.mode && (g = f.find("input, select, textarea").first(), g.on("keyup", function (d) {
          13 !== d.keyCode && 27 !== d.keyCode || gj.grid.plugins.inlineEditing["private"].displayMode(a, b, c);
        }));
      }
      "INPUT" === g.prop("tagName").toUpperCase() && "TEXT" === g.prop("type").toUpperCase() ? gj.core.setCaretAtEnd(g[0]) : g.focus(), b.attr("data-mode", "edit");
    } else "managementColumn" === c.role && (b.find('[role="edit"]').hide(), b.find('[role="delete"]').hide(), b.find('[role="update"]').show(), b.find('[role="cancel"]').show());
  },
  displayMode: function displayMode(a, b, c, d) {
    var e, f, g, h, i, j, k;
    "editOnly" !== c.mode && ("edit" === b.attr("data-mode") && (e = b.find('div[data-role="edit"]'), f = b.find('div[data-role="display"]'), g = e.find("input, select, textarea").first(), "SELECT" === g[0].tagName.toUpperCase() && g[0].selectedIndex > -1 ? (h = g[0].options[g[0].selectedIndex].innerHTML, i = g[0].value) : h = "INPUT" === g[0].tagName.toUpperCase() && "CHECKBOX" === g[0].type.toUpperCase() ? g[0].checked : g.val(), k = b.parent().data("position"), j = a.get(k), !0 !== d && h !== j[c.field] && (j[c.field] = "date" === c.type ? gj.core.parseDate(h, c.format) : h, c.editField && (j[c.editField] = i || h), "editOnly" !== c.mode && (gj.grid.methods.renderDisplayElement(a, f, c, j, gj.grid.methods.getId(j, a.data("primaryKey"), k), "update"), 0 === b.find("span.gj-dirty").length && b.prepend($('<span class="gj-dirty" />'))), gj.grid.plugins.inlineEditing.events.cellDataChanged(a, b, c, j, h), gj.grid.plugins.inlineEditing["private"].updateChanges(a, c, j, h)), e.hide(), f.show(), b.attr("data-mode", "display")), "managementColumn" === c.role && (b.find('[role="update"]').hide(), b.find('[role="cancel"]').hide(), b.find('[role="edit"]').show(), b.find('[role="delete"]').show()));
  },
  updateOtherCells: function updateOtherCells(a, b) {
    var c = a.data();
    "command" !== c.inlineEditing.mode && "editOnly" !== b && a.find('div[data-role="edit"]:visible').parent("td").each(function () {
      var b = $(this),
        d = c.columns[b.index()];
      gj.grid.plugins.inlineEditing["private"].displayMode(a, b, d);
    });
  },
  updateChanges: function updateChanges(a, b, c, d) {
    var e,
      f,
      g,
      h = a.data();
    h.guid || (h.guid = gj.grid.plugins.inlineEditing["private"].generateGUID()), h.primaryKey && (e = JSON.parse(sessionStorage.getItem("gj.grid." + h.guid)), e ? f = e.filter(function (a) {
      return a[h.primaryKey] === c[h.primaryKey];
    }) : e = [], f && 1 === f.length ? f[0][b.field] = d : (g = {}, g[h.primaryKey] = c[h.primaryKey], h.primaryKey !== b.field && (g[b.field] = d), e.push(g)), sessionStorage.setItem("gj.grid." + h.guid, JSON.stringify(e)));
  },
  generateGUID: function generateGUID() {
    function a() {
      return Math.floor(65536 * (1 + Math.random())).toString(16).substring(1);
    }
    return a() + a() + "-" + a() + "-" + a() + "-" + a() + "-" + a() + a() + a();
  }
}, gj.grid.plugins.inlineEditing["public"] = {
  getChanges: function getChanges() {
    return JSON.parse(sessionStorage.getItem("gj.grid." + this.data().guid));
  },
  edit: function edit(a) {
    var b,
      c = this.getById(a),
      d = gj.grid.methods.getRowById(this, a).children("td"),
      e = this.data("columns");
    for (b = 0; b < d.length; b++) gj.grid.plugins.inlineEditing["private"].editMode(this, $(d[b]), e[b], c);
    return this;
  },
  update: function update(a) {
    var b,
      c = this.getById(a),
      d = gj.grid.methods.getRowById(this, a).children("td"),
      e = this.data("columns");
    for (b = 0; b < d.length; b++) gj.grid.plugins.inlineEditing["private"].displayMode(this, $(d[b]), e[b], !1);
    return gj.grid.plugins.inlineEditing.events.rowDataChanged(this, a, c), this;
  },
  cancel: function cancel(a) {
    var b,
      c = (this.getById(a), gj.grid.methods.getRowById(this, a).children("td")),
      d = this.data("columns");
    for (b = 0; b < c.length; b++) gj.grid.plugins.inlineEditing["private"].displayMode(this, $(c[b]), d[b], !0);
    return this;
  }
}, gj.grid.plugins.inlineEditing.events = {
  cellDataChanged: function cellDataChanged(a, b, c, d, e, f) {
    a.triggerHandler("cellDataChanged", [b, c, d, e, f]);
  },
  rowDataChanged: function rowDataChanged(a, b, c) {
    a.triggerHandler("rowDataChanged", [b, c]);
  }
}, gj.grid.plugins.inlineEditing.configure = function (a, b, c) {
  var d = a.data();
  $.extend(!0, a, gj.grid.plugins.inlineEditing["public"]), c.inlineEditing && (a.on("dataBound", function () {
    a.find("span.gj-dirty").remove();
  }), a.on("rowDataBound", function (b, c, d, e) {
    a.cancel(d);
  })), "command" === d.inlineEditing.mode ? (gj.grid.plugins.inlineEditing["private"].localization(d), b.inlineEditing.managementColumn && d.columns.push(b.inlineEditing.managementColumnConfig)) : a.on("cellDataBound", function (b, c, e, f, g) {
    f.editor && ("editOnly" === f.mode ? gj.grid.plugins.inlineEditing["private"].editMode(a, c.parent(), f, g) : c.parent("td").on("dblclick" === d.inlineEditing.mode ? "dblclick" : "click", function () {
      gj.grid.plugins.inlineEditing["private"].editMode(a, c.parent(), f, g);
    }));
  });
}, gj.grid.plugins.optimisticPersistence = {
  config: {
    base: {
      optimisticPersistence: {
        localStorage: void 0,
        sessionStorage: void 0
      }
    }
  },
  "private": {
    applyParams: function applyParams(a) {
      var b,
        c = a.data(),
        d = {};
      b = JSON.parse(sessionStorage.getItem("gj.grid." + c.guid)), b && b.optimisticPersistence && $.extend(d, b.optimisticPersistence), b = JSON.parse(localStorage.getItem("gj.grid." + c.guid)), b && b.optimisticPersistence && $.extend(d, b.optimisticPersistence), $.extend(c.params, d);
    },
    saveParams: function saveParams(a) {
      var b,
        c,
        d = a.data(),
        e = {
          optimisticPersistence: {}
        };
      if (d.optimisticPersistence.sessionStorage) {
        for (b = 0; b < d.optimisticPersistence.sessionStorage.length; b++) c = d.optimisticPersistence.sessionStorage[b], e.optimisticPersistence[c] = d.params[c];
        e = $.extend(!0, JSON.parse(sessionStorage.getItem("gj.grid." + d.guid)), e), sessionStorage.setItem("gj.grid." + d.guid, JSON.stringify(e));
      }
      if (d.optimisticPersistence.localStorage) {
        for (e = {
          optimisticPersistence: {}
        }, b = 0; b < d.optimisticPersistence.localStorage.length; b++) c = d.optimisticPersistence.localStorage[b], e.optimisticPersistence[c] = d.params[c];
        e = $.extend(!0, JSON.parse(localStorage.getItem("gj.grid." + d.guid)), e), localStorage.setItem("gj.grid." + d.guid, JSON.stringify(e));
      }
    }
  },
  configure: function configure(a, b, c) {
    b.guid && (b.optimisticPersistence.localStorage || b.optimisticPersistence.sessionStorage) && (gj.grid.plugins.optimisticPersistence["private"].applyParams(a), a.on("dataBound", function (b) {
      gj.grid.plugins.optimisticPersistence["private"].saveParams(a);
    }));
  }
}, gj.grid.plugins.pagination = {
  config: {
    base: {
      style: {
        pager: {
          panel: "",
          stateDisabled: "",
          activeButton: ""
        }
      },
      paramNames: {
        page: "page",
        limit: "limit"
      },
      pager: {
        limit: 10,
        sizes: [5, 10, 20, 100],
        leftControls: void 0,
        rightControls: void 0
      }
    },
    bootstrap: {
      style: {
        pager: {
          panel: "",
          stateDisabled: ""
        }
      }
    },
    bootstrap4: {
      style: {
        pager: {
          panel: "btn-toolbar",
          stateDisabled: ""
        }
      }
    },
    glyphicons: {
      icons: {
        first: '<span class="glyphicon glyphicon-step-backward"></span>',
        previous: '<span class="glyphicon glyphicon-backward"></span>',
        next: '<span class="glyphicon glyphicon-forward"></span>',
        last: '<span class="glyphicon glyphicon-step-forward"></span>',
        refresh: '<span class="glyphicon glyphicon-refresh"></span>'
      }
    },
    materialicons: {
      icons: {
        first: '<i class="gj-icon first-page" />',
        previous: '<i class="ti-angle-left" />',
        next: '<i class="ti-angle-right" />',
        last: '<i class="gj-icon last-page" />',
        refresh: '<i class="gj-icon refresh" />'
      }
    },
    fontawesome: {
      icons: {
        first: '<i class="fa fa-fast-backward" aria-hidden="true"></i>',
        previous: '<i class="fa fa-backward" aria-hidden="true"></i>',
        next: '<i class="fa fa-forward" aria-hidden="true"></i>',
        last: '<i class="fa fa-fast-forward" aria-hidden="true"></i>',
        refresh: '<i class="fa fa-refresh" aria-hidden="true"></i>'
      }
    }
  },
  "private": {
    init: function init(a) {
      var b, c, d, e, f, g, h, i, j, k;
      if (d = a.data(), d.pager) for (d.params[d.paramNames.page] || (d.params[d.paramNames.page] = 1), d.params[d.paramNames.limit] || (d.params[d.paramNames.limit] = d.pager.limit), gj.grid.plugins.pagination["private"].localization(d), b = $('<tr data-role="pager"/>'), c = $("<th/>"), b.append(c), f = $('<div data-role="display" />').addClass(d.style.pager.panel).css({
        "float": "left"
      }), g = $('<div data-role="display" />').addClass(d.style.pager.panel).css({
        "float": "right"
      }), c.append(f).append(g), h = $("<tfoot />").append(b), a.append(h), gj.grid.plugins.pagination["private"].updatePagerColSpan(a), i = gj.grid.methods.clone(d.pager.leftControls), $.each(i, function () {
        f.append(this);
      }), j = gj.grid.methods.clone(d.pager.rightControls), $.each(j, function () {
        g.append(this);
      }), e = a.find("tfoot [data-role]"), k = 0; k < e.length; k++) gj.grid.plugins.pagination["private"].initPagerControl($(e[k]), a);
    },
    localization: function localization(a) {
      "bootstrap" === a.uiLibrary ? gj.grid.plugins.pagination["private"].localizationBootstrap(a) : "bootstrap4" === a.uiLibrary ? gj.grid.plugins.pagination["private"].localizationBootstrap4(a) : gj.grid.plugins.pagination["private"].localizationMaterialDesign(a);
    },
    localizationBootstrap: function localizationBootstrap(a) {
      var b = gj.grid.messages[a.locale];
      void 0 === a.pager.leftControls && (a.pager.leftControls = [$('<button type="button" class="btn btn-default btn-sm">' + (a.icons.first || b.First) + "</button>").attr("title", b.FirstPageTooltip).attr("data-role", "page-first"), $('<button type="button" class="btn btn-default btn-sm">' + (a.icons.previous || b.Previous) + "</button>").attr("title", b.PreviousPageTooltip).attr("data-role", "page-previous"), $("<div>" + b.Page + "</div>"), $('<input data-role="page-number" class="form-control input-sm" type="text" value="0">'), $("<div>" + b.Of + "</div>"), $('<div data-role="page-label-last">0</div>'), $('<button type="button" class="btn btn-default btn-sm">' + (a.icons.next || b.Next) + "</button>").attr("title", b.NextPageTooltip).attr("data-role", "page-next"), $('<button type="button" class="btn btn-default btn-sm">' + (a.icons.last || b.Last) + "</button>").attr("title", b.LastPageTooltip).attr("data-role", "page-last"), $('<button type="button" class="btn btn-default btn-sm">' + (a.icons.refresh || b.Refresh) + "</button>").attr("title", b.Refresh).attr("data-role", "page-refresh"), $('<select data-role="page-size" class="form-control input-sm" width="60"></select>')]), void 0 === a.pager.rightControls && (a.pager.rightControls = [$("<div>" + b.DisplayingRecords + "</div>"), $('<div data-role="record-first">0</div>'), $("<div>-</div>"), $('<div data-role="record-last">0</div>'), $("<div>" + b.Of + "</div>"), $('<div data-role="record-total">0</div>')]);
    },
    localizationBootstrap4: function localizationBootstrap4(a) {
      var b = gj.grid.messages[a.locale];
      void 0 === a.pager.leftControls && (a.pager.leftControls = [$('<button class="btn btn-default btn-sm gj-cursor-pointer">' + (a.icons.first || b.First) + "</button>").attr("title", b.FirstPageTooltip).attr("data-role", "page-first"), $('<button class="btn btn-default btn-sm gj-cursor-pointer">' + (a.icons.previous || b.Previous) + "</button>").attr("title", b.PreviousPageTooltip).attr("data-role", "page-previous"), $("<div>" + b.Page + "</div>"), $('<div class="input-group"><input data-role="page-number" class="form-control form-control-sm" type="text" value="0"></div>'), $("<div>" + b.Of + "</div>"), $('<div data-role="page-label-last">0</div>'), $('<button class="btn btn-default btn-sm gj-cursor-pointer">' + (a.icons.next || b.Next) + "</button>").attr("title", b.NextPageTooltip).attr("data-role", "page-next"), $('<button class="btn btn-default btn-sm gj-cursor-pointer">' + (a.icons.last || b.Last) + "</button>").attr("title", b.LastPageTooltip).attr("data-role", "page-last"), $('<button class="btn btn-default btn-sm gj-cursor-pointer">' + (a.icons.refresh || b.Refresh) + "</button>").attr("title", b.Refresh).attr("data-role", "page-refresh"), $('<select data-role="page-size" class="form-control input-sm" width="60"></select>')]), void 0 === a.pager.rightControls && (a.pager.rightControls = [$("<div>" + b.DisplayingRecords + "&nbsp;</div>"), $('<div data-role="record-first">0</div>'), $("<div>-</div>"), $('<div data-role="record-last">0</div>'), $("<div>" + b.Of + "</div>"), $('<div data-role="record-total">0</div>')]);
    },
    localizationMaterialDesign: function localizationMaterialDesign(a) {
      var b = gj.grid.messages[a.locale];
      void 0 === a.pager.leftControls && (a.pager.leftControls = []), void 0 === a.pager.rightControls && (a.pager.rightControls = [$('<span class="">' + b.RowsPerPage + "</span>"), $('<select data-role="page-size" class="gj-grid-md-limit-select" width="52"></select></div>'), $('<span class="gj-md-spacer-32">&nbsp;</span>'), $('<span data-role="record-first" class="">0</span>'), $('<span class="">-</span>'), $('<span data-role="record-last" class="">0</span>'), $('<span class="gj-grid-mdl-pager-label">' + b.Of + "</span>"), $('<span data-role="record-total" class="">0</span>'), $('<span class="gj-md-spacer-32">&nbsp;</span>'), $('<button class="gj-button-md">' + (a.icons.previous || b.Previous) + "</button>").attr("title", b.PreviousPageTooltip).attr("data-role", "page-previous").addClass(a.icons.first ? "gj-button-md-icon" : ""), $('<span class="gj-md-spacer-24">&nbsp;</span>'), $('<button class="gj-button-md">' + (a.icons.next || b.Next) + "</button>").attr("title", b.NextPageTooltip).attr("data-role", "page-next").addClass(a.icons.first ? "gj-button-md-icon" : "")]);
    },
    initPagerControl: function initPagerControl(a, b) {
      var c = b.data();
      switch (a.data("role")) {
        case "page-size":
          c.pager.sizes && 0 < c.pager.sizes.length ? (a.show(), $.each(c.pager.sizes, function () {
            a.append($("<option/>").attr("value", this.toString()).text(this.toString()));
          }), a.change(function () {
            var a = parseInt(this.value, 10);
            c.params[c.paramNames.limit] = a, gj.grid.plugins.pagination["private"].changePage(b, 1), gj.grid.plugins.pagination.events.pageSizeChange(b, a);
          }), a.val(c.params[c.paramNames.limit]), gj.dropdown && a.dropdown({
            uiLibrary: c.uiLibrary,
            iconsLibrary: c.iconsLibrary,
            fontSize: a.css("font-size"),
            style: {
              presenter: "btn btn-default btn-sm"
            }
          })) : a.hide();
          break;
        case "page-refresh":
          a.on("click", function () {
            b.reload();
          });
      }
    },
    reloadPager: function reloadPager(a, b) {
      var c, d, e, f, g, h, i, j;
      if (h = a.data(), h.pager) {
        for (c = 0 === b ? 0 : parseInt(h.params[h.paramNames.page], 10), d = parseInt(h.params[h.paramNames.limit], 10), e = Math.ceil(b / d), f = 0 === c ? 0 : d * (c - 1) + 1, g = f + d > b ? b : f + d - 1, i = a.find("TFOOT [data-role]"), j = 0; j < i.length; j++) gj.grid.plugins.pagination["private"].reloadPagerControl($(i[j]), a, c, e, f, g, b);
        gj.grid.plugins.pagination["private"].updatePagerColSpan(a);
      }
    },
    reloadPagerControl: function reloadPagerControl(a, b, c, d, e, f, g) {
      var h;
      switch (a.data("role")) {
        case "page-first":
          gj.grid.plugins.pagination["private"].assignPageHandler(b, a, 1, c < 2);
          break;
        case "page-previous":
          gj.grid.plugins.pagination["private"].assignPageHandler(b, a, c - 1, c < 2);
          break;
        case "page-number":
          a.val(c).off("change").on("change", gj.grid.plugins.pagination["private"].createChangePageHandler(b, c));
          break;
        case "page-label-last":
          a.text(d);
          break;
        case "page-next":
          gj.grid.plugins.pagination["private"].assignPageHandler(b, a, c + 1, d === c);
          break;
        case "page-last":
          gj.grid.plugins.pagination["private"].assignPageHandler(b, a, d, d === c);
          break;
        case "page-button-one":
          h = 1 === c ? 1 : c == d ? c - 2 : c - 1, gj.grid.plugins.pagination["private"].assignButtonHandler(b, a, c, h, d);
          break;
        case "page-button-two":
          h = 1 === c ? 2 : c == d ? d - 1 : c, gj.grid.plugins.pagination["private"].assignButtonHandler(b, a, c, h, d);
          break;
        case "page-button-three":
          h = 1 === c ? c + 2 : c == d ? c : c + 1, gj.grid.plugins.pagination["private"].assignButtonHandler(b, a, c, h, d);
          break;
        case "record-first":
          a.text(e);
          break;
        case "record-last":
          a.text(f);
          break;
        case "record-total":
          a.text(g);
      }
    },
    assignPageHandler: function assignPageHandler(a, b, c, d) {
      var e = a.data().style.pager;
      d ? b.addClass(e.stateDisabled).prop("disabled", !0).off("click") : b.removeClass(e.stateDisabled).prop("disabled", !1).off("click").on("click", function () {
        gj.grid.plugins.pagination["private"].changePage(a, c);
      });
    },
    assignButtonHandler: function assignButtonHandler(a, b, c, d, e) {
      var f = a.data().style.pager;
      d < 1 || d > e ? b.hide() : (b.show().off("click").text(d), d === c ? b.addClass(f.activeButton) : b.removeClass(f.activeButton).on("click", function () {
        gj.grid.plugins.pagination["private"].changePage(a, d);
      }));
    },
    createChangePageHandler: function createChangePageHandler(a, b) {
      return function () {
        var b = (a.data(), parseInt(this.value, 10));
        gj.grid.plugins.pagination["private"].changePage(a, b);
      };
    },
    changePage: function changePage(a, b) {
      var c = a.data();
      !1 === gj.grid.plugins.pagination.events.pageChanging(a, b) || isNaN(b) || (a.find('TFOOT [data-role="page-number"]').val(b), c.params[c.paramNames.page] = b), a.reload();
    },
    updatePagerColSpan: function updatePagerColSpan(a) {
      var b = a.find('tfoot > tr[data-role="pager"] > th');
      b && b.length && b.attr("colspan", gj.grid.methods.countVisibleColumns(a));
    },
    isLastRecordVisible: function isLastRecordVisible(a) {
      var b = !0,
        c = a.data(),
        d = parseInt(c.params[c.paramNames.limit], 10),
        e = parseInt(c.params[c.paramNames.page], 10),
        f = a.count();
      return d && e && (b = (e - 1) * d + f === c.totalRecords), b;
    }
  },
  "public": {
    getAll: function getAll(a) {
      var b,
        c,
        d,
        e = this.data();
      return $.isArray(e.dataSource) ? a ? e.dataSource : e.params[e.paramNames.limit] && e.params[e.paramNames.page] ? (b = parseInt(e.params[e.paramNames.limit], 10), c = parseInt(e.params[e.paramNames.page], 10), d = (c - 1) * b, e.records.slice(d, d + b)) : e.records : e.records;
    }
  },
  events: {
    pageSizeChange: function pageSizeChange(a, b) {
      a.triggerHandler("pageSizeChange", [b]);
    },
    pageChanging: function pageChanging(a, b) {
      a.triggerHandler("pageChanging", [b]);
    }
  },
  configure: function configure(a, b, c) {
    $.extend(!0, a, gj.grid.plugins.pagination["public"]);
    a.data();
    c.pager && (gj.grid.methods.isLastRecordVisible = gj.grid.plugins.pagination["private"].isLastRecordVisible, a.on("initialized", function () {
      gj.grid.plugins.pagination["private"].init(a);
    }), a.on("dataBound", function (b, c, d) {
      gj.grid.plugins.pagination["private"].reloadPager(a, d);
    }), a.on("columnShow", function () {
      gj.grid.plugins.pagination["private"].updatePagerColSpan(a);
    }), a.on("columnHide", function () {
      gj.grid.plugins.pagination["private"].updatePagerColSpan(a);
    }));
  }
}, gj.grid.plugins.responsiveDesign = {
  config: {
    base: {
      resizeCheckInterval: 500,
      responsive: !1,
      showHiddenColumnsAsDetails: !1,
      defaultColumn: {
        priority: void 0,
        minWidth: 250
      },
      style: {
        rowDetailItem: ""
      }
    },
    bootstrap: {
      style: {
        rowDetailItem: "col-lg-4"
      }
    }
  },
  "private": {
    orderColumns: function orderColumns(a) {
      var b = [];
      if (a.columns && a.columns.length) {
        for (i = 0; i < a.columns.length; i++) b.push({
          position: i,
          field: a.columns[i].field,
          minWidth: a.columns[i].width || a.columns[i].minWidth || a.defaultColumn.minWidth,
          priority: a.columns[i].priority || 0
        });
        b.sort(function (a, b) {
          var c = 0;
          return a.priority < b.priority ? c = -1 : a.priority > b.priority && (c = 1), c;
        });
      }
      return b;
    },
    updateDetails: function updateDetails(a) {
      var b, c, d, e, f, g, h, i, j;
      for (b = a.find('tbody > tr[data-role="row"]'), c = a.data(), d = 0; d < b.length; d++) {
        for (f = $(b[d]), g = f.data("details"), e = 0; e < c.columns.length; e++) i = c.columns[e], h = g && g.find('div[data-id="' + i.field + '"]'), c.columns[e].hidden ? (j = "<b>" + (i.title || i.field) + "</b>: {" + i.field + "}", h && h.length ? h.empty().html(j) : (h = $('<div data-id="' + i.field + '"/>').html(j), h.addClass(c.style.rowDetailItem), g && g.length || (g = $('<div class="row"/>')), g.append(h))) : h && h.length && h.remove();
        a.updateDetails(f);
      }
    }
  },
  "public": {
    oldWidth: void 0,
    resizeCheckIntervalId: void 0,
    makeResponsive: function makeResponsive() {
      var a,
        b,
        c = 0,
        d = this.data(),
        e = gj.grid.plugins.responsiveDesign["private"].orderColumns(d);
      for (a = 0; a < e.length; a++) b = this.find("thead>tr>th:eq(" + e[a].position + ")"), b.is(":visible") && e[a].minWidth < b.width() && (c += b.width() - e[a].minWidth);
      if (c) for (a = 0; a < e.length; a++) b = this.find("thead>tr>th:eq(" + e[a].position + ")"), !b.is(":visible") && e[a].minWidth <= c && (this.showColumn(e[a].field), c -= b.width());
      for (a = e.length - 1; a >= 0; a--) b = this.find("thead>tr>th:eq(" + e[a].position + ")"), b.is(":visible") && e[a].priority && e[a].minWidth > b.outerWidth() && this.hideColumn(e[a].field);
      return this;
    }
  },
  events: {
    resize: function resize(a, b, c) {
      a.triggerHandler("resize", [b, c]);
    }
  },
  configure: function configure(a, b, c) {
    $.extend(!0, a, gj.grid.plugins.responsiveDesign["public"]), b.responsive && (a.on("initialized", function () {
      a.makeResponsive(), a.oldWidth = a.width(), a.resizeCheckIntervalId = setInterval(function () {
        var b = a.width();
        b !== a.oldWidth && gj.grid.plugins.responsiveDesign.events.resize(a, b, a.oldWidth), a.oldWidth = b;
      }, b.resizeCheckInterval);
    }), a.on("destroy", function () {
      a.resizeCheckIntervalId && clearInterval(a.resizeCheckIntervalId);
    }), a.on("resize", function () {
      a.makeResponsive();
    })), b.showHiddenColumnsAsDetails && gj.grid.plugins.expandCollapseRows && (a.on("dataBound", function () {
      gj.grid.plugins.responsiveDesign["private"].updateDetails(a);
    }), a.on("columnHide", function () {
      gj.grid.plugins.responsiveDesign["private"].updateDetails(a);
    }), a.on("columnShow", function () {
      gj.grid.plugins.responsiveDesign["private"].updateDetails(a);
    }), a.on("rowDataBound", function () {
      gj.grid.plugins.responsiveDesign["private"].updateDetails(a);
    }));
  }
}, gj.grid.plugins.toolbar = {
  config: {
    base: {
      toolbarTemplate: void 0,
      title: void 0,
      style: {
        toolbar: "gj-grid-md-toolbar"
      }
    },
    bootstrap: {
      style: {
        toolbar: "gj-grid-bootstrap-toolbar"
      }
    },
    bootstrap4: {
      style: {
        toolbar: "gj-grid-bootstrap-4-toolbar"
      }
    }
  },
  "private": {
    init: function init(a) {
      var b, c, d;
      b = a.data(), c = a.prev('div[data-role="toolbar"]'), (void 0 !== b.toolbarTemplate || void 0 !== b.title || c.length > 0) && (0 === c.length && (c = $('<div data-role="toolbar"></div>'), a.before(c)), c.addClass(b.style.toolbar), 0 === c.children().length && b.toolbarTemplate && c.append(b.toolbarTemplate), d = c.find('[data-role="title"]'), 0 === d.length && (d = $('<div data-role="title"/>'), c.prepend(d)), b.title && d.text(b.title), b.minWidth && c.css("min-width", b.minWidth));
    }
  },
  "public": {
    title: function title(a) {
      var b = this.parent().find('div[data-role="toolbar"] [data-role="title"]');
      return void 0 !== a ? (b.text(a), this) : b.text();
    }
  },
  configure: function configure(a) {
    $.extend(!0, a, gj.grid.plugins.toolbar["public"]), a.on("initialized", function () {
      gj.grid.plugins.toolbar["private"].init(a);
    }), a.on("destroying", function () {
      a.prev('[data-role="toolbar"]').remove();
    });
  }
}, gj.grid.plugins.resizableColumns = {
  config: {
    base: {
      resizableColumns: !1
    }
  },
  "private": {
    init: function init(a, b) {
      var c, d, e, f, g, h;
      if (c = a.find('thead tr[data-role="caption"] th'), c.length) {
        for (e = 0; e < c.length - 1; e++) d = $(c[e]), f = $('<div class="gj-grid-column-resizer-wrapper" />'), h = parseInt(d.css("padding-right"), 10) + 3, g = $('<span class="gj-grid-column-resizer" />').css("margin-right", "-" + h + "px"), g.draggable({
          start: function start() {
            a.addClass("gj-unselectable"), a.addClass("gj-grid-resize-cursor");
          },
          stop: function stop() {
            a.removeClass("gj-unselectable"), a.removeClass("gj-grid-resize-cursor"), this.style.removeProperty("top"), this.style.removeProperty("left"), this.style.removeProperty("position");
          },
          drag: gj.grid.plugins.resizableColumns["private"].createResizeHandle(a, d, b.columns[e])
        }), d.append(f.append(g));
        for (e = 0; e < c.length; e++) d = $(c[e]), d.attr("width") || d.attr("width", d.outerWidth());
      }
    },
    createResizeHandle: function createResizeHandle(a, b, c) {
      var d = a.data();
      return function (e, f) {
        var g,
          h,
          i,
          j,
          k,
          l,
          m = parseInt(b.attr("width"), 10),
          n = gj.core.position(this),
          o = {
            top: f.top - n.top,
            left: f.left - n.left
          };
        if (m || (m = b.outerWidth()), o.left && (k = m + o.left, c.width = k, b.attr("width", k), h = b[0].cellIndex, j = b[0].parentElement.children[h + 1], l = parseInt($(j).attr("width"), 10) - o.left, j.setAttribute("width", l), d.resizableColumns)) for (i = a[0].tBodies[0].children, g = 0; g < i.length; g++) i[g].cells[h].setAttribute("width", k), j = i[g].cells[h + 1], j.setAttribute("width", l);
      };
    }
  },
  "public": {},
  configure: function configure(a, b, c) {
    $.extend(!0, a, gj.grid.plugins.resizableColumns["public"]), b.resizableColumns && gj.draggable && a.on("initialized", function () {
      gj.grid.plugins.resizableColumns["private"].init(a, b);
    });
  }
}, gj.grid.plugins.rowReorder = {
  config: {
    base: {
      rowReorder: !1,
      rowReorderColumn: void 0,
      orderNumberField: void 0,
      style: {
        targetRowIndicatorTop: "gj-grid-row-reorder-indicator-top",
        targetRowIndicatorBottom: "gj-grid-row-reorder-indicator-bottom"
      }
    }
  },
  "private": {
    init: function init(a) {
      var b,
        c,
        d,
        e = a.find('tbody tr[data-role="row"]');
      for (a.data("rowReorderColumn") && (c = gj.grid.methods.getColumnPosition(a.data("columns"), a.data("rowReorderColumn"))), b = 0; b < e.length; b++) d = $(e[b]), void 0 !== c ? d.find("td:eq(" + c + ")").on("mousedown", gj.grid.plugins.rowReorder["private"].createRowMouseDownHandler(a, d)) : d.on("mousedown", gj.grid.plugins.rowReorder["private"].createRowMouseDownHandler(a, d));
    },
    createRowMouseDownHandler: function createRowMouseDownHandler(a, b) {
      return function (c) {
        var d,
          e,
          f = a.clone(),
          g = a.data("columns");
        for (a.addClass("gj-unselectable"), $("body").append(f), f.attr("data-role", "draggable-clone").css("cursor", "move"), f.children("thead").remove().children("tfoot").remove(), f.find('tbody tr:not([data-position="' + b.data("position") + '"])').remove(), e = f.find("tbody tr td"), d = 0; d < e.length; d++) g[d].width && e[d].setAttribute("width", g[d].width);
        f.draggable({
          stop: gj.grid.plugins.rowReorder["private"].createDragStopHandler(a, b)
        }), f.css({
          position: "absolute",
          top: b.offset().top,
          left: b.offset().left,
          width: b.width(),
          zIndex: 1
        }), "true" === b.attr("data-droppable") && b.droppable("destroy"), b.siblings('tr[data-role="row"]').each(function () {
          var a = $(this);
          "true" === a.attr("data-droppable") && a.droppable("destroy"), a.droppable({
            over: gj.grid.plugins.rowReorder["private"].createDroppableOverHandler(b),
            out: gj.grid.plugins.rowReorder["private"].droppableOut
          });
        }), f.trigger("mousedown");
      };
    },
    createDragStopHandler: function createDragStopHandler(a, b) {
      return function (c, d) {
        $('table[data-role="draggable-clone"]').draggable("destroy").remove(), a.removeClass("gj-unselectable"), b.siblings('tr[data-role="row"]').each(function () {
          var c,
            e,
            f,
            g,
            h,
            i = $(this),
            j = i.data("position"),
            k = b.data("position"),
            l = a.data();
          if (i.droppable("isOver", d)) {
            for (j < k ? i.before(b) : i.after(b), l.records.splice(j - 1, 0, l.records.splice(k - 1, 1)[0]), c = i.parent().find('tr[data-role="row"]'), f = 0; f < c.length; f++) $(c[f]).attr("data-position", f + 1);
            if (l.orderNumberField) {
              for (f = 0; f < l.records.length; f++) l.records[f][l.orderNumberField] = f + 1;
              for (f = 0; f < c.length; f++) e = $(c[f]), h = gj.grid.methods.getId(e, l.primaryKey, e.attr("data-position")), g = gj.grid.methods.getByPosition(a, e.attr("data-position")), a.setCellContent(h, l.orderNumberField, g[l.orderNumberField]);
            }
          }
          i.removeClass("gj-grid-top-border"), i.removeClass("gj-grid-bottom-border"), i.droppable("destroy");
        });
      };
    },
    createDroppableOverHandler: function createDroppableOverHandler(a) {
      return function (b) {
        var c = $(this);
        c.data("position") < a.data("position") ? c.addClass("gj-grid-top-border") : c.addClass("gj-grid-bottom-border");
      };
    },
    droppableOut: function droppableOut() {
      $(this).removeClass("gj-grid-top-border"), $(this).removeClass("gj-grid-bottom-border");
    }
  },
  "public": {},
  configure: function configure(a, b, c) {
    $.extend(!0, a, gj.grid.plugins.rowReorder["public"]), b.rowReorder && gj.draggable && gj.droppable && a.on("dataBound", function () {
      gj.grid.plugins.rowReorder["private"].init(a);
    });
  }
}, gj.grid.plugins["export"] = {
  config: {
    base: {}
  },
  "public": {
    getCSV: function getCSV(a) {
      var b,
        c,
        d = "",
        e = "",
        f = this.data().columns,
        g = this.getAll(a);
      if (g.length) {
        for (b = 0; b < f.length; b++) gj.grid.plugins["export"]["public"].isColumnApplicable(f[b]) && (d += '"' + (f[b].title || f[b].field).replace(/<[^>]+>/g, " ") + '",');
        for (e += d.slice(0, d.length - 1) + "\r\n", b = 0; b < g.length; b++) {
          for (d = "", c = 0; c < f.length; c++) gj.grid.plugins["export"]["public"].isColumnApplicable(f[c]) && (d += '"' + g[b][f[c].field] + '",');
          e += d.slice(0, d.length - 1) + "\r\n";
        }
      }
      return e;
    },
    downloadCSV: function downloadCSV(a, b) {
      var c = document.createElement("a");
      return document.body.appendChild(c), c.download = a || "griddata.csv", window.navigator.userAgent.indexOf("Edge") > -1 ? c.href = URL.createObjectURL(new Blob([this.getCSV(b)], {
        type: "text/csv;charset=utf-8;"
      })) : c.href = "data:text/csv;charset=utf-8," + escape(this.getCSV(b)), c.click(), document.body.removeChild(c), this;
    },
    isColumnApplicable: function isColumnApplicable(a) {
      return !0 !== a.hidden && !a.role;
    }
  },
  configure: function configure(a) {
    $.extend(!0, a, gj.grid.plugins["export"]["public"]);
  }
}, gj.grid.plugins.columnReorder = {
  config: {
    base: {
      columnReorder: !1,
      dragReady: !1,
      style: {
        targetRowIndicatorTop: "gj-grid-row-reorder-indicator-top",
        targetRowIndicatorBottom: "gj-grid-row-reorder-indicator-bottom"
      }
    }
  },
  "private": {
    init: function init(a) {
      var b,
        c,
        d = a.find("thead tr th");
      for (b = 0; b < d.length; b++) c = $(d[b]), c.on("mousedown", gj.grid.plugins.columnReorder["private"].createMouseDownHandler(a, c)), c.on("mousemove", gj.grid.plugins.columnReorder["private"].createMouseMoveHandler(a, c)), c.on("mouseup", gj.grid.plugins.columnReorder["private"].createMouseUpHandler(a, c));
    },
    createMouseDownHandler: function createMouseDownHandler(a) {
      return function (b) {
        a.timeout = setTimeout(function () {
          a.data("dragReady", !0);
        }, 100);
      };
    },
    createMouseUpHandler: function createMouseUpHandler(a) {
      return function (b) {
        clearTimeout(a.timeout), a.data("dragReady", !1);
      };
    },
    createMouseMoveHandler: function createMouseMoveHandler(a, b) {
      return function (c) {
        var d, e;
        a.data("dragReady") && (a.data("dragReady", !1), d = a.clone(), e = b.index(), a.addClass("gj-unselectable"), $("body").append(d), d.attr("data-role", "draggable-clone").css("cursor", "move"), d.find("thead tr th:eq(" + e + ")").siblings().remove(), d.find('tbody tr[data-role != "row"]').remove(), d.find("tbody tr td:nth-child(" + (e + 1) + ")").siblings().remove(), d.find("tfoot").remove(), d.draggable({
          stop: gj.grid.plugins.columnReorder["private"].createDragStopHandler(a, b)
        }), d.css({
          position: "absolute",
          top: b.offset().top,
          left: b.offset().left,
          width: b.width(),
          zIndex: 1
        }), "true" === b.attr("data-droppable") && b.droppable("destroy"), b.siblings("th").each(function () {
          var c = $(this);
          "true" === c.attr("data-droppable") && c.droppable("destroy"), c.droppable({
            over: gj.grid.plugins.columnReorder["private"].createDroppableOverHandler(a, b),
            out: gj.grid.plugins.columnReorder["private"].droppableOut
          });
        }), d.trigger("mousedown"));
      };
    },
    createDragStopHandler: function createDragStopHandler(a, b) {
      return function (c, d) {
        $('table[data-role="draggable-clone"]').draggable("destroy").remove(), a.removeClass("gj-unselectable"), b.siblings("th").each(function () {
          var c = $(this),
            e = a.data(),
            f = gj.grid.methods.getColumnPosition(e.columns, c.data("field")),
            g = gj.grid.methods.getColumnPosition(e.columns, b.data("field"));
          c.removeClass("gj-grid-left-border").removeClass("gj-grid-right-border"), c.closest("table").find('tbody tr[data-role="row"] td:nth-child(' + (c.index() + 1) + ")").removeClass("gj-grid-left-border").removeClass("gj-grid-right-border"), c.droppable("isOver", d) && (f < g ? c.before(b) : c.after(b), gj.grid.plugins.columnReorder["private"].moveRowCells(a, g, f), e.columns.splice(f, 0, e.columns.splice(g, 1)[0])), c.droppable("destroy");
        });
      };
    },
    moveRowCells: function moveRowCells(a, b, c) {
      var d,
        e,
        f = a.find('tbody tr[data-role="row"]');
      for (d = 0; d < f.length; d++) e = $(f[d]), c < b ? e.find("td:eq(" + c + ")").before(e.find("td:eq(" + b + ")")) : e.find("td:eq(" + c + ")").after(e.find("td:eq(" + b + ")"));
    },
    createDroppableOverHandler: function createDroppableOverHandler(a, b) {
      return function (c) {
        var d = $(this),
          e = a.data();
        gj.grid.methods.getColumnPosition(e.columns, d.data("field")) < gj.grid.methods.getColumnPosition(e.columns, b.data("field")) ? (d.addClass("gj-grid-left-border"), a.find('tbody tr[data-role="row"] td:nth-child(' + (d.index() + 1) + ")").addClass("gj-grid-left-border")) : (d.addClass("gj-grid-right-border"), a.find('tbody tr[data-role="row"] td:nth-child(' + (d.index() + 1) + ")").addClass("gj-grid-right-border"));
      };
    },
    droppableOut: function droppableOut() {
      var a = $(this);
      a.removeClass("gj-grid-left-border").removeClass("gj-grid-right-border"), a.closest("table").find('tbody tr[data-role="row"] td:nth-child(' + (a.index() + 1) + ")").removeClass("gj-grid-left-border").removeClass("gj-grid-right-border");
    }
  },
  "public": {},
  configure: function configure(a, b, c) {
    $.extend(!0, a, gj.grid.plugins.columnReorder["public"]), b.columnReorder && a.on("initialized", function () {
      gj.grid.plugins.columnReorder["private"].init(a);
    });
  }
}, gj.grid.plugins.headerFilter = {
  config: {
    base: {
      defaultColumnSettings: {
        filterable: !0
      },
      headerFilter: {
        type: "onenterkeypress"
      }
    }
  },
  "private": {
    init: function init(a) {
      var b,
        c,
        d,
        e = a.data(),
        f = $('<tr data-role="filter"/>');
      for (b = 0; b < e.columns.length; b++) c = $("<th/>"), e.columns[b].filterable && (d = $('<input data-field="' + e.columns[b].field + '" class="gj-width-full" />'), "onchange" === e.headerFilter.type ? d.on("input propertychange", function (b) {
        gj.grid.plugins.headerFilter["private"].reload(a, $(this));
      }) : (d.on("keypress", function (b) {
        13 == b.which && gj.grid.plugins.headerFilter["private"].reload(a, $(this));
      }), d.on("blur", function (b) {
        gj.grid.plugins.headerFilter["private"].reload(a, $(this));
      })), c.append(d)), e.columns[b].hidden && c.hide(), f.append(c);
      a.children("thead").append(f);
    },
    reload: function reload(a, b) {
      var c = {};
      c[b.data("field")] = b.val(), a.reload(c);
    }
  },
  "public": {},
  events: {},
  configure: function configure(a, b, c) {
    $.extend(!0, a, gj.grid.plugins.headerFilter["public"]);
    a.data();
    c.headerFilter && a.on("initialized", function () {
      gj.grid.plugins.headerFilter["private"].init(a);
    });
  }
}, gj.grid.plugins.grouping = {
  config: {
    base: {
      paramNames: {
        groupBy: "groupBy",
        groupByDirection: "groupByDirection"
      },
      grouping: {
        groupBy: void 0,
        direction: "asc"
      },
      icons: {
        expandGroup: '<i class="gj-icon plus" />',
        collapseGroup: '<i class="gj-icon minus" />'
      }
    },
    fontawesome: {
      icons: {
        expandGroup: '<i class="fa fa-plus" aria-hidden="true"></i>',
        collapseGroup: '<i class="fa fa-minus" aria-hidden="true"></i>'
      }
    },
    glyphicons: {
      icons: {
        expandGroup: '<span class="glyphicon glyphicon-plus" />',
        collapseGroup: '<span class="glyphicon glyphicon-minus" />'
      }
    }
  },
  "private": {
    init: function init(a) {
      var b,
        c = a.data();
      b = void 0, a.on("rowDataBound", function (d, e, f, g) {
        if (b !== g[c.grouping.groupBy] || 1 === e[0].rowIndex) {
          var h = gj.grid.methods.countVisibleColumns(a) - 1,
            i = $('<tr role="group" />'),
            j = $('<td class="gj-text-align-center gj-unselectable gj-cursor-pointer" />');
          j.append('<div data-role="display">' + c.icons.collapseGroup + "</div>"), j.on("click", gj.grid.plugins.grouping["private"].createExpandCollapseHandler(c)), i.append(j), i.append('<td colspan="' + h + '"><div data-role="display">' + c.grouping.groupBy + ": " + g[c.grouping.groupBy] + "</div></td>"), i.insertBefore(e), b = g[c.grouping.groupBy];
        }
        e.show();
      }), c.params[c.paramNames.groupBy] = c.grouping.groupBy, c.params[c.paramNames.groupByDirection] = c.grouping.direction;
    },
    grouping: function grouping(a, b) {
      var c = a.data();
      b.sort(gj.grid.methods.createDefaultSorter(c.grouping.direction, c.grouping.groupBy));
    },
    createExpandCollapseHandler: function createExpandCollapseHandler(a) {
      return function (b) {
        var c = $(this),
          d = gj.grid.plugins.grouping["private"];
        "row" === c.closest("tr").next(":visible").data("role") ? d.collapseGroup(a, c) : d.expandGroup(a, c);
      };
    },
    collapseGroup: function collapseGroup(a, b) {
      var c = b.children('div[data-role="display"]');
      b.closest("tr").nextUntil('[role="group"]').hide(), c.empty().append(a.icons.expandGroup);
    },
    expandGroup: function expandGroup(a, b) {
      var c = b.children('div[data-role="display"]');
      b.closest("tr").nextUntil('[role="group"]').show(), c.empty().append(a.icons.collapseGroup);
    }
  },
  "public": {},
  configure: function configure(a) {
    var b,
      c = a.data();
    $.extend(!0, a, gj.grid.plugins.grouping["public"]), c.grouping && c.grouping.groupBy && (b = {
      title: "",
      width: c.defaultIconColumnWidth,
      align: "center",
      stopPropagation: !0,
      cssClass: "gj-cursor-pointer gj-unselectable"
    }, c.columns = [b].concat(c.columns), a.on("initialized", function () {
      gj.grid.plugins.grouping["private"].init(a);
    }), a.on("dataFiltered", function (b, c) {
      gj.grid.plugins.grouping["private"].grouping(a, c);
    }));
  }
}, gj.grid.messages["en-us"] = {
  First: "First",
  Previous: "Previous",
  Next: "Next",
  Last: "Last",
  Page: "Page",
  FirstPageTooltip: "First Page",
  PreviousPageTooltip: "Previous Page",
  NextPageTooltip: "Next Page",
  LastPageTooltip: "Last Page",
  Refresh: "Refresh",
  Of: "of",
  DisplayingRecords: "Displaying records",
  RowsPerPage: "Rows per page:",
  Edit: "Edit",
  Delete: "Delete",
  Update: "Update",
  Cancel: "Cancel",
  NoRecordsFound: "No records found.",
  Loading: "Loading..."
}, gj.tree = {
  plugins: {}
}, gj.tree.config = {
  base: {
    params: {},
    autoLoad: !0,
    selectionType: "single",
    cascadeSelection: !1,
    dataSource: void 0,
    primaryKey: void 0,
    textField: "text",
    childrenField: "children",
    hasChildrenField: "hasChildren",
    imageCssClassField: "imageCssClass",
    imageUrlField: "imageUrl",
    imageHtmlField: "imageHtml",
    disabledField: "disabled",
    width: void 0,
    border: !1,
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    autoGenId: 1,
    autoGenFieldName: "autoId_b5497cc5-7ef3-49f5-a7dc-4a932e1aee4a",
    indentation: 24,
    style: {
      wrapper: "gj-unselectable",
      list: "gj-list gj-list-md",
      item: void 0,
      active: "gj-list-md-active",
      leafIcon: void 0,
      border: "gj-tree-md-border"
    },
    icons: {
      expand: '<i class="gj-icon chevron-right" />',
      collapse: '<i class="gj-icon chevron-down" />'
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-unselectable gj-tree-bootstrap-3",
      list: "gj-list gj-list-bootstrap list-group",
      item: "list-group-item",
      active: "active",
      border: "gj-tree-bootstrap-border"
    },
    iconsLibrary: "glyphicons"
  },
  bootstrap4: {
    style: {
      wrapper: "gj-unselectable gj-tree-bootstrap-4",
      list: "gj-list gj-list-bootstrap",
      item: "list-group-item",
      active: "active",
      border: "gj-tree-bootstrap-border"
    },
    icons: {
      expand: '<i class="gj-icon plus" />',
      collapse: '<i class="gj-icon minus" />'
    }
  },
  materialicons: {
    style: {
      expander: "gj-tree-material-icons-expander"
    }
  },
  fontawesome: {
    style: {
      expander: "gj-tree-font-awesome-expander"
    },
    icons: {
      expand: '<i class="fa fa-plus" aria-hidden="true"></i>',
      collapse: '<i class="fa fa-minus" aria-hidden="true"></i>'
    }
  },
  glyphicons: {
    style: {
      expander: "gj-tree-glyphicons-expander"
    },
    icons: {
      expand: '<span class="glyphicon glyphicon-plus" />',
      collapse: '<span class="glyphicon glyphicon-minus" />'
    }
  }
}, gj.tree.events = {
  initialized: function initialized(a) {
    a.triggerHandler("initialized");
  },
  dataBinding: function dataBinding(a) {
    a.triggerHandler("dataBinding");
  },
  dataBound: function dataBound(a) {
    a.triggerHandler("dataBound");
  },
  select: function select(a, b, c) {
    return a.triggerHandler("select", [b, c]);
  },
  unselect: function unselect(a, b, c) {
    return a.triggerHandler("unselect", [b, c]);
  },
  expand: function expand(a, b, c) {
    return a.triggerHandler("expand", [b, c]);
  },
  collapse: function collapse(a, b, c) {
    return a.triggerHandler("collapse", [b, c]);
  },
  enable: function enable(a, b) {
    return a.triggerHandler("enable", [b]);
  },
  disable: function disable(a, b) {
    return a.triggerHandler("disable", [b]);
  },
  destroying: function destroying(a) {
    return a.triggerHandler("destroying");
  },
  nodeDataBound: function nodeDataBound(a, b, c, d) {
    return a.triggerHandler("nodeDataBound", [b, c, d]);
  }
}, gj.tree.methods = {
  init: function init(a) {
    return gj.widget.prototype.init.call(this, a, "tree"), gj.tree.methods.initialize.call(this), this.data("autoLoad") && this.reload(), this;
  },
  initialize: function initialize() {
    var a = this.data(),
      b = $('<ul class="' + a.style.list + '"/>');
    this.empty().addClass(a.style.wrapper).append(b), a.width && this.width(a.width), a.border && this.addClass(a.style.border), gj.tree.events.initialized(this);
  },
  useHtmlDataSource: function useHtmlDataSource(a, b) {
    b.dataSource = [];
  },
  render: function render(a, b) {
    var c;
    return b && ("string" == typeof b && JSON && (b = JSON.parse(b)), c = a.data(), c.records = b, c.primaryKey || gj.tree.methods.genAutoId(c, c.records), gj.tree.methods.loadData(a)), a;
  },
  filter: function filter(a) {
    return a.data().dataSource;
  },
  genAutoId: function genAutoId(a, b) {
    var c;
    for (c = 0; c < b.length; c++) b[c][a.autoGenFieldName] = a.autoGenId++, b[c][a.childrenField] && b[c][a.childrenField].length && gj.tree.methods.genAutoId(a, b[c][a.childrenField]);
  },
  loadData: function loadData(a) {
    var b,
      c = a.data("records"),
      d = a.children("ul");
    for (gj.tree.events.dataBinding(a), d.off().empty(), b = 0; b < c.length; b++) gj.tree.methods.appendNode(a, d, c[b], 1);
    gj.tree.events.dataBound(a);
  },
  appendNode: function appendNode(a, b, c, d, e) {
    var f,
      g,
      h,
      i,
      j,
      k = a.data(),
      l = k.primaryKey ? c[k.primaryKey] : c[k.autoGenFieldName];
    if (g = $('<li data-id="' + l + '" data-role="node" />').addClass(k.style.item), $wrapper = $('<div data-role="wrapper" />'), $expander = $('<span data-role="expander" data-mode="close"></span>').addClass(k.style.expander), $display = $('<span data-role="display">' + c[k.textField] + "</span>"), hasChildren = void 0 !== c[k.hasChildrenField] && "true" === c[k.hasChildrenField].toString().toLowerCase(), disabled = void 0 !== c[k.disabledField] && "true" === c[k.disabledField].toString().toLowerCase(), k.indentation && $wrapper.append('<span data-role="spacer" style="width: ' + k.indentation * (d - 1) + 'px;"></span>'), disabled ? gj.tree.methods.disableNode(a, g) : ($expander.on("click", gj.tree.methods.expanderClickHandler(a)), $display.on("click", gj.tree.methods.displayClickHandler(a))), $wrapper.append($expander), $wrapper.append($display), g.append($wrapper), e ? b.find("li:eq(" + (e - 1) + ")").before(g) : b.append(g), k.imageCssClassField && c[k.imageCssClassField] ? (i = $('<span data-role="image"><span class="' + c[k.imageCssClassField] + '"></span></span>'), i.insertBefore($display)) : k.imageUrlField && c[k.imageUrlField] ? (i = $('<span data-role="image"></span>'), i.insertBefore($display), j = $('<img src="' + c[k.imageUrlField] + '"></img>'), j.attr("width", i.width()).attr("height", i.height()), i.append(j)) : k.imageHtmlField && c[k.imageHtmlField] && (i = $('<span data-role="image">' + c[k.imageHtmlField] + "</span>"), i.insertBefore($display)), c[k.childrenField] && c[k.childrenField].length || hasChildren) {
      if ($expander.empty().append(k.icons.expand), h = $("<ul />").addClass(k.style.list).addClass("gj-hidden"), g.append(h), c[k.childrenField] && c[k.childrenField].length) for (f = 0; f < c[k.childrenField].length; f++) gj.tree.methods.appendNode(a, h, c[k.childrenField][f], d + 1);
    } else k.style.leafIcon ? $expander.addClass(k.style.leafIcon) : $expander.html("&nbsp;");
    gj.tree.events.nodeDataBound(a, g, c.id, c);
  },
  expanderClickHandler: function expanderClickHandler(a) {
    return function (b) {
      var c = $(this),
        d = c.closest("li");
      "close" === c.attr("data-mode") ? a.expand(d) : a.collapse(d);
    };
  },
  expand: function expand(a, b, c) {
    var d,
      e,
      f = b.find('>[data-role="wrapper"]>[data-role="expander"]'),
      g = a.data(),
      h = b.attr("data-id"),
      i = b.children("ul");
    if (!1 !== gj.tree.events.expand(a, b, h) && i && i.length && (i.show(), f.attr("data-mode", "open"), f.empty().append(g.icons.collapse), c)) for (d = b.find("ul>li"), e = 0; e < d.length; e++) gj.tree.methods.expand(a, $(d[e]), c);
    return a;
  },
  collapse: function collapse(a, b, c) {
    var d,
      e,
      f = b.find('>[data-role="wrapper"]>[data-role="expander"]'),
      g = a.data(),
      h = b.attr("data-id"),
      i = b.children("ul");
    if (!1 !== gj.tree.events.collapse(a, b, h) && i && i.length && (i.hide(), f.attr("data-mode", "close"), f.empty().append(g.icons.expand), c)) for (d = b.find("ul>li"), e = 0; e < d.length; e++) gj.tree.methods.collapse(a, $(d[e]), c);
    return a;
  },
  expandAll: function expandAll(a) {
    var b,
      c = a.find("ul>li");
    for (b = 0; b < c.length; b++) gj.tree.methods.expand(a, $(c[b]), !0);
    return a;
  },
  collapseAll: function collapseAll(a) {
    var b,
      c = a.find("ul>li");
    for (b = 0; b < c.length; b++) gj.tree.methods.collapse(a, $(c[b]), !0);
    return a;
  },
  displayClickHandler: function displayClickHandler(a) {
    return function (b) {
      var c = $(this),
        d = c.closest("li"),
        e = a.data().cascadeSelection;
      "true" === d.attr("data-selected") ? gj.tree.methods.unselect(a, d, e) : ("single" === a.data("selectionType") && gj.tree.methods.unselectAll(a), gj.tree.methods.select(a, d, e));
    };
  },
  selectAll: function selectAll(a) {
    var b,
      c = a.find("ul>li");
    for (b = 0; b < c.length; b++) gj.tree.methods.select(a, $(c[b]), !0);
    return a;
  },
  select: function select(a, b, c) {
    var d,
      e,
      f = a.data();
    if ("true" !== b.attr("data-selected") && !1 !== gj.tree.events.select(a, b, b.attr("data-id")) && (b.addClass(f.style.active).attr("data-selected", "true"), c)) for (e = b.find("ul>li"), d = 0; d < e.length; d++) gj.tree.methods.select(a, $(e[d]), c);
  },
  unselectAll: function unselectAll(a) {
    var b,
      c = a.find("ul>li");
    for (b = 0; b < c.length; b++) gj.tree.methods.unselect(a, $(c[b]), !0);
    return a;
  },
  unselect: function unselect(a, b, c) {
    var d, e;
    a.data();
    if ("true" === b.attr("data-selected") && !1 !== gj.tree.events.unselect(a, b, b.attr("data-id")) && (b.removeClass(a.data().style.active).removeAttr("data-selected"), c)) for (e = b.find("ul>li"), d = 0; d < e.length; d++) gj.tree.methods.unselect(a, $(e[d]), c);
  },
  getSelections: function getSelections(a) {
    var b,
      c,
      d,
      e = [],
      f = a.children("li");
    if (f && f.length) for (b = 0; b < f.length; b++) c = $(f[b]), "true" === c.attr("data-selected") ? e.push(c.attr("data-id")) : c.has("ul") && (d = gj.tree.methods.getSelections(c.children("ul")), d.length && (e = e.concat(d)));
    return e;
  },
  getDataById: function getDataById(a, b, c) {
    var d,
      e = a.data(),
      f = void 0;
    for (d = 0; d < c.length; d++) {
      if (e.primaryKey && c[d][e.primaryKey] == b) {
        f = c[d];
        break;
      }
      if (c[d][e.autoGenFieldName] == b) {
        f = c[d];
        break;
      }
      if (c[d][e.childrenField] && c[d][e.childrenField].length && (f = gj.tree.methods.getDataById(a, b, c[d][e.childrenField]))) break;
    }
    return f;
  },
  getDataByText: function getDataByText(a, b, c) {
    var d,
      e = void 0,
      f = a.data();
    for (d = 0; d < c.length; d++) {
      if (b === c[d][f.textField]) {
        e = c[d];
        break;
      }
      if (c[d][f.childrenField] && c[d][f.childrenField].length && (e = gj.tree.methods.getDataByText(a, b, c[d][f.childrenField]))) break;
    }
    return e;
  },
  getNodeById: function getNodeById(a, b) {
    var c,
      d,
      e = void 0,
      f = a.children("li");
    if (f && f.length) for (c = 0; c < f.length; c++) {
      if (d = $(f[c]), b == d.attr("data-id")) {
        e = d;
        break;
      }
      if (d.has("ul") && (e = gj.tree.methods.getNodeById(d.children("ul"), b))) break;
    }
    return e;
  },
  getNodeByText: function getNodeByText(a, b) {
    var c,
      d,
      e = void 0,
      f = a.children("li");
    if (f && f.length) for (c = 0; c < f.length; c++) {
      if (d = $(f[c]), b === d.find('>[data-role="wrapper"]>[data-role="display"]').text()) {
        e = d;
        break;
      }
      if (d.has("ul") && (e = gj.tree.methods.getNodeByText(d.children("ul"), b))) break;
    }
    return e;
  },
  addNode: function addNode(a, b, c, d) {
    var e,
      f,
      g = a.data();
    return c && c.length ? ("li" === c[0].tagName.toLowerCase() && (0 === c.children("ul").length && (c.find('[data-role="expander"]').empty().append(g.icons.collapse), c.append($("<ul />").addClass(g.style.list))), c = c.children("ul")), f = a.getDataById(c.parent().data("id")), f[g.childrenField] || (f[g.childrenField] = []), f[g.childrenField].push(b)) : (c = a.children("ul"), a.data("records").push(b)), e = c.parentsUntil('[data-type="tree"]', "ul").length + 1, g.primaryKey || gj.tree.methods.genAutoId(g, [b]), gj.tree.methods.appendNode(a, c, b, e, d), a;
  },
  remove: function remove(a, b) {
    return gj.tree.methods.removeDataById(a, b.attr("data-id"), a.data("records")), b.remove(), a;
  },
  removeDataById: function removeDataById(a, b, c) {
    var d,
      e = a.data();
    for (d = 0; d < c.length; d++) {
      if (e.primaryKey && c[d][e.primaryKey] == b) {
        c.splice(d, 1);
        break;
      }
      if (c[d][e.autoGenFieldName] == b) {
        c.splice(d, 1);
        break;
      }
      c[d][e.childrenField] && c[d][e.childrenField].length && gj.tree.methods.removeDataById(a, b, c[d][e.childrenField]);
    }
  },
  update: function update(a, b, c) {
    var d = a.data(),
      e = a.getNodeById(b);
    a.getDataById(b);
    return c, e.find('>[data-role="wrapper"]>[data-role="display"]').html(c[d.textField]), gj.tree.events.nodeDataBound(a, e, b, c), a;
  },
  getChildren: function getChildren(a, b, c) {
    var d,
      e,
      f = [],
      c = void 0 === c || c;
    for (e = c ? b.find("ul li") : b.find(">ul>li"), d = 0; d < e.length; d++) f.push($(e[d]).data("id"));
    return f;
  },
  enableAll: function enableAll(a) {
    var b,
      c = a.find("ul>li");
    for (b = 0; b < c.length; b++) gj.tree.methods.enableNode(a, $(c[b]), !0);
    return a;
  },
  enableNode: function enableNode(a, b, c) {
    var d,
      e,
      f = b.find('>[data-role="wrapper"]>[data-role="expander"]'),
      g = b.find('>[data-role="wrapper"]>[data-role="display"]'),
      c = void 0 === c || c;
    if (b.removeClass("disabled"), f.on("click", gj.tree.methods.expanderClickHandler(a)), g.on("click", gj.tree.methods.displayClickHandler(a)), gj.tree.events.enable(a, b), c) for (e = b.find("ul>li"), d = 0; d < e.length; d++) gj.tree.methods.enableNode(a, $(e[d]), c);
  },
  disableAll: function disableAll(a) {
    var b,
      c = a.find("ul>li");
    for (b = 0; b < c.length; b++) gj.tree.methods.disableNode(a, $(c[b]), !0);
    return a;
  },
  disableNode: function disableNode(a, b, c) {
    var d,
      e,
      f = b.find('>[data-role="wrapper"]>[data-role="expander"]'),
      g = b.find('>[data-role="wrapper"]>[data-role="display"]'),
      c = void 0 === c || c;
    if (b.addClass("disabled"), f.off("click"), g.off("click"), gj.tree.events.disable(a, b), c) for (e = b.find("ul>li"), d = 0; d < e.length; d++) gj.tree.methods.disableNode(a, $(e[d]), c);
  },
  destroy: function destroy(a) {
    return a.data() && (gj.tree.events.destroying(a), a.xhr && a.xhr.abort(), a.off(), a.removeData(), a.removeAttr("data-type"), a.removeClass().empty()), a;
  },
  pathFinder: function pathFinder(a, b, c, d) {
    var e,
      f = !1;
    for (e = 0; e < b.length; e++) {
      if (b[e].id == c) {
        f = !0;
        break;
      }
      if (gj.tree.methods.pathFinder(a, b[e][a.childrenField], c, d)) {
        d.push(b[e].data[a.textField]), f = !0;
        break;
      }
    }
    return f;
  }
}, gj.tree.widget = function (a, b) {
  var c = this,
    d = gj.tree.methods;
  return c.reload = function (a) {
    return gj.widget.prototype.reload.call(this, a);
  }, c.render = function (a) {
    return d.render(this, a);
  }, c.addNode = function (a, b, c) {
    return d.addNode(this, a, b, c);
  }, c.removeNode = function (a) {
    return d.remove(this, a);
  }, c.updateNode = function (a, b) {
    return d.update(this, a, b);
  }, c.destroy = function () {
    return d.destroy(this);
  }, c.expand = function (a, b) {
    return d.expand(this, a, b);
  }, c.collapse = function (a, b) {
    return d.collapse(this, a, b);
  }, c.expandAll = function () {
    return d.expandAll(this);
  }, c.collapseAll = function () {
    return d.collapseAll(this);
  }, c.getDataById = function (a) {
    return d.getDataById(this, a, this.data("records"));
  }, c.getDataByText = function (a) {
    return d.getDataByText(this, a, this.data("records"));
  }, c.getNodeById = function (a) {
    return d.getNodeById(this.children("ul"), a);
  }, c.getNodeByText = function (a) {
    return d.getNodeByText(this.children("ul"), a);
  }, c.getAll = function () {
    return this.data("records");
  }, c.select = function (a) {
    return d.select(this, a);
  }, c.unselect = function (a) {
    return d.unselect(this, a);
  }, c.selectAll = function () {
    return d.selectAll(this);
  }, c.unselectAll = function () {
    return d.unselectAll(this);
  }, c.getSelections = function () {
    return d.getSelections(this.children("ul"));
  }, c.getChildren = function (a, b) {
    return d.getChildren(this, a, b);
  }, c.parents = function (a) {
    var b = [],
      c = this.data();
    return d.pathFinder(c, c.records, a, b), b.reverse();
  }, c.enable = function (a, b) {
    return d.enableNode(this, a, b);
  }, c.enableAll = function () {
    return d.enableAll(this);
  }, c.disable = function (a, b) {
    return d.disableNode(this, a, b);
  }, c.disableAll = function () {
    return d.disableAll(this);
  }, $.extend(a, c), "tree" !== a.attr("data-type") && d.init.call(a, b), a;
}, gj.tree.widget.prototype = new gj.widget(), gj.tree.widget.constructor = gj.tree.widget, function (a) {
  a.fn.tree = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.tree.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.tree.widget(this, a);
    }
  };
}(jQuery), gj.tree.plugins.checkboxes = {
  config: {
    base: {
      checkboxes: void 0,
      checkedField: "checked",
      cascadeCheck: !0
    }
  },
  "private": {
    dataBound: function dataBound(a) {
      var b;
      a.data("cascadeCheck") && (b = a.find('li[data-role="node"]'), $.each(b, function () {
        var a = $(this),
          b = a.find('[data-role="checkbox"] input[type="checkbox"]').checkbox("state");
        "checked" === b && (gj.tree.plugins.checkboxes["private"].updateChildrenState(a, b), gj.tree.plugins.checkboxes["private"].updateParentState(a, b));
      }));
    },
    nodeDataBound: function nodeDataBound(a, b, c, d) {
      var e, f, g, h, i;
      0 === b.find('> [data-role="wrapper"] > [data-role="checkbox"]').length && (e = a.data(), f = b.find('> [data-role="wrapper"] > [data-role="expander"]'), g = $('<input type="checkbox"/>'), h = $('<span data-role="checkbox"></span>').append(g), i = void 0 !== d[e.disabledField] && "true" === d[e.disabledField].toString().toLowerCase(), g = g.checkbox({
        uiLibrary: e.uiLibrary,
        iconsLibrary: e.iconsLibrary,
        change: function change(c, e) {
          gj.tree.plugins.checkboxes.events.checkboxChange(a, b, d, g.state());
        }
      }), i && g.prop("disabled", !0), d[e.checkedField] && g.state("checked"), g.on("click", function (a) {
        var b = g.closest("li"),
          c = g.state();
        e.cascadeCheck && (gj.tree.plugins.checkboxes["private"].updateChildrenState(b, c), gj.tree.plugins.checkboxes["private"].updateParentState(b, c));
      }), f.after(h));
    },
    updateParentState: function updateParentState(a, b) {
      var c, d, e, f, g, h;
      c = a.parent("ul").parent("li"), 1 === c.length && (d = a.parent("ul").parent("li").find('> [data-role="wrapper"] > [data-role="checkbox"] input[type="checkbox"]'), e = a.siblings().find('> [data-role="wrapper"] > span[data-role="checkbox"] input[type="checkbox"]'), f = "checked" === b, g = "unchecked" === b, h = "indeterminate", $.each(e, function () {
        var a = $(this).checkbox("state");
        f && "checked" !== a && (f = !1), g && "unchecked" !== a && (g = !1);
      }), f && !g && (h = "checked"), !f && g && (h = "unchecked"), d.checkbox("state", h), gj.tree.plugins.checkboxes["private"].updateParentState(c, d.checkbox("state")));
    },
    updateChildrenState: function updateChildrenState(a, b) {
      var c = a.find('ul li [data-role="wrapper"] [data-role="checkbox"] input[type="checkbox"]');
      c.length > 0 && $.each(c, function () {
        $(this).checkbox("state", b);
      });
    },
    update: function update(a, b, c) {
      var d = b.find('[data-role="checkbox"] input[type="checkbox"]').first();
      $(d).checkbox("state", c), a.data().cascadeCheck && (gj.tree.plugins.checkboxes["private"].updateChildrenState(b, c), gj.tree.plugins.checkboxes["private"].updateParentState(b, c));
    }
  },
  "public": {
    getCheckedNodes: function getCheckedNodes() {
      var a = [],
        b = this.find('li [data-role="checkbox"] input[type="checkbox"]');
      return $.each(b, function () {
        var b = $(this);
        "checked" === b.checkbox("state") && a.push(b.closest("li").data("id"));
      }), a;
    },
    checkAll: function checkAll() {
      var a = this.find('li [data-role="checkbox"] input[type="checkbox"]');
      return $.each(a, function () {
        $(this).checkbox("state", "checked");
      }), this;
    },
    uncheckAll: function uncheckAll() {
      var a = this.find('li [data-role="checkbox"] input[type="checkbox"]');
      return $.each(a, function () {
        $(this).checkbox("state", "unchecked");
      }), this;
    },
    check: function check(a) {
      return gj.tree.plugins.checkboxes["private"].update(this, a, "checked"), this;
    },
    uncheck: function uncheck(a) {
      return gj.tree.plugins.checkboxes["private"].update(this, a, "unchecked"), this;
    }
  },
  events: {
    checkboxChange: function checkboxChange(a, b, c, d) {
      return a.triggerHandler("checkboxChange", [b, c, d]);
    }
  },
  configure: function configure(a) {
    a.data("checkboxes") && gj.checkbox && ($.extend(!0, a, gj.tree.plugins.checkboxes["public"]), a.on("nodeDataBound", function (b, c, d, e) {
      gj.tree.plugins.checkboxes["private"].nodeDataBound(a, c, d, e);
    }), a.on("dataBound", function () {
      gj.tree.plugins.checkboxes["private"].dataBound(a);
    }), a.on("enable", function (a, b) {
      b.find('>[data-role="wrapper"]>[data-role="checkbox"] input[type="checkbox"]').prop("disabled", !1);
    }), a.on("disable", function (a, b) {
      b.find('>[data-role="wrapper"]>[data-role="checkbox"] input[type="checkbox"]').prop("disabled", !0);
    }));
  }
}, gj.tree.plugins.dragAndDrop = {
  config: {
    base: {
      dragAndDrop: void 0,
      style: {
        dragEl: "gj-tree-drag-el gj-tree-md-drag-el",
        dropAsChildIcon: "gj-cursor-pointer gj-icon plus",
        dropAbove: "gj-tree-drop-above",
        dropBelow: "gj-tree-drop-below"
      }
    },
    bootstrap: {
      style: {
        dragEl: "gj-tree-drag-el gj-tree-bootstrap-drag-el",
        dropAsChildIcon: "glyphicon glyphicon-plus",
        dropAbove: "drop-above",
        dropBelow: "drop-below"
      }
    },
    bootstrap4: {
      style: {
        dragEl: "gj-tree-drag-el gj-tree-bootstrap-drag-el",
        dropAsChildIcon: "gj-cursor-pointer gj-icon plus",
        dropAbove: "drop-above",
        dropBelow: "drop-below"
      }
    }
  },
  "private": {
    nodeDataBound: function nodeDataBound(a, b) {
      var c = b.children('[data-role="wrapper"]'),
        d = b.find('>[data-role="wrapper"]>[data-role="display"]');
      c.length && d.length && (d.on("mousedown", gj.tree.plugins.dragAndDrop["private"].createNodeMouseDownHandler(a)), d.on("mousemove", gj.tree.plugins.dragAndDrop["private"].createNodeMouseMoveHandler(a, b, d)), d.on("mouseup", gj.tree.plugins.dragAndDrop["private"].createNodeMouseUpHandler(a)));
    },
    createNodeMouseDownHandler: function createNodeMouseDownHandler(a) {
      return function (b) {
        a.data("dragReady", !0);
      };
    },
    createNodeMouseUpHandler: function createNodeMouseUpHandler(a) {
      return function (b) {
        a.data("dragReady", !1);
      };
    },
    createNodeMouseMoveHandler: function createNodeMouseMoveHandler(a, b, c) {
      return function (d) {
        if (a.data("dragReady")) {
          var e,
            f,
            g,
            h,
            i = a.data();
          a.data("dragReady", !1), e = c.clone().wrap('<div data-role="wrapper"/>').closest("div").wrap('<li class="' + i.style.item + '" />').closest("li").wrap('<ul class="' + i.style.list + '" />').closest("ul"), $("body").append(e), e.attr("data-role", "draggable-clone").addClass("gj-unselectable").addClass(i.style.dragEl), e.find('[data-role="wrapper"]').prepend('<span data-role="indicator" />'), e.draggable({
            drag: gj.tree.plugins.dragAndDrop["private"].createDragHandler(a, b, c),
            stop: gj.tree.plugins.dragAndDrop["private"].createDragStopHandler(a, b, c)
          }), f = c.parent(), g = c.offset().top, g -= parseInt(f.css("border-top-width")) + parseInt(f.css("margin-top")) + parseInt(f.css("padding-top")), h = c.offset().left, h -= parseInt(f.css("border-left-width")) + parseInt(f.css("margin-left")) + parseInt(f.css("padding-left")), h -= e.find('[data-role="indicator"]').outerWidth(!0), e.css({
            position: "absolute",
            top: g,
            left: h,
            width: c.outerWidth(!0)
          }), "true" === c.attr("data-droppable") && c.droppable("destroy"), gj.tree.plugins.dragAndDrop["private"].getTargetDisplays(a, b, c).each(function () {
            var a = $(this);
            "true" === a.attr("data-droppable") && a.droppable("destroy"), a.droppable();
          }), gj.tree.plugins.dragAndDrop["private"].getTargetDisplays(a, b).each(function () {
            var a = $(this);
            "true" === a.attr("data-droppable") && a.droppable("destroy"), a.droppable();
          }), e.trigger("mousedown");
        }
      };
    },
    getTargetDisplays: function getTargetDisplays(a, b, c) {
      return a.find('[data-role="display"]').not(c).not(b.find('[data-role="display"]'));
    },
    getTargetWrappers: function getTargetWrappers(a, b) {
      return a.find('[data-role="wrapper"]').not(b.find('[data-role="wrapper"]'));
    },
    createDragHandler: function createDragHandler(a, b, c) {
      var d = gj.tree.plugins.dragAndDrop["private"].getTargetDisplays(a, b, c),
        e = gj.tree.plugins.dragAndDrop["private"].getTargetWrappers(a, b),
        f = a.data();
      return function (a, b, c) {
        var g = $(this),
          h = !1;
        d.each(function () {
          var a,
            b = $(this);
          if (b.droppable("isOver", c)) return a = g.find('[data-role="indicator"]'), f.style.dropAsChildIcon ? a.addClass(f.style.dropAsChildIcon) : a.text("+"), h = !0, !1;
          g.find('[data-role="indicator"]').removeClass(f.style.dropAsChildIcon).empty();
        }), e.each(function () {
          var a,
            b = $(this);
          !h && b.droppable("isOver", c) ? (a = b.position().top + b.outerHeight() / 2, c.y < a ? b.addClass(f.style.dropAbove).removeClass(f.style.dropBelow) : b.addClass(f.style.dropBelow).removeClass(f.style.dropAbove)) : b.removeClass(f.style.dropAbove).removeClass(f.style.dropBelow);
        });
      };
    },
    createDragStopHandler: function createDragStopHandler(a, b, c) {
      var d = gj.tree.plugins.dragAndDrop["private"].getTargetDisplays(a, b, c),
        e = gj.tree.plugins.dragAndDrop["private"].getTargetWrappers(a, b),
        f = a.data();
      return function (c, g) {
        var h,
          i,
          j,
          k,
          l = !1;
        $(this).draggable("destroy").remove(), d.each(function () {
          var c,
            d = $(this);
          if (d.droppable("isOver", g)) return i = d.closest("li"), j = b.parent("ul").parent("li"), c = i.children("ul"), 0 === c.length && (c = $("<ul />").addClass(f.style.list), i.append(c)), !1 !== gj.tree.plugins.dragAndDrop.events.nodeDrop(a, b.data("id"), i.data("id"), c.children("li").length + 1) && (c.append(b), h = a.getDataById(b.data("id")), gj.tree.methods.removeDataById(a, b.data("id"), f.records), k = a.getDataById(c.parent().data("id")), void 0 === k[f.childrenField] && (k[f.childrenField] = []), k[f.childrenField].push(h), gj.tree.plugins.dragAndDrop["private"].refresh(a, b, i, j)), l = !0, !1;
          d.droppable("destroy");
        }), l || e.each(function () {
          var c,
            d,
            e,
            k = $(this);
          if (k.droppable("isOver", g)) return i = k.closest("li"), j = b.parent("ul").parent("li"), c = g.y < k.position().top + k.outerHeight() / 2, e = b.data("id"), d = i.prevAll('li:not([data-id="' + e + '"])').length + (c ? 1 : 2), !1 !== gj.tree.plugins.dragAndDrop.events.nodeDrop(a, e, i.parent("ul").parent("li").data("id"), d) && (h = a.getDataById(b.data("id")), gj.tree.methods.removeDataById(a, b.data("id"), f.records), a.getDataById(i.parent().data("id"))[f.childrenField].splice(i.index() + (c ? 0 : 1), 0, h), c ? b.insertBefore(i) : b.insertAfter(i), gj.tree.plugins.dragAndDrop["private"].refresh(a, b, i, j)), !1;
          k.droppable("destroy");
        });
      };
    },
    refresh: function refresh(a, b, c, d) {
      var e = a.data();
      gj.tree.plugins.dragAndDrop["private"].refreshNode(a, c), gj.tree.plugins.dragAndDrop["private"].refreshNode(a, d), gj.tree.plugins.dragAndDrop["private"].refreshNode(a, b), b.find('li[data-role="node"]').each(function () {
        gj.tree.plugins.dragAndDrop["private"].refreshNode(a, $(this));
      }), c.children('[data-role="wrapper"]').removeClass(e.style.dropAbove).removeClass(e.style.dropBelow);
    },
    refreshNode: function refreshNode(a, b) {
      var c = b.children('[data-role="wrapper"]'),
        d = c.children('[data-role="expander"]'),
        e = c.children('[data-role="spacer"]'),
        f = b.children("ul"),
        g = a.data(),
        h = b.parentsUntil('[data-type="tree"]', "ul").length;
      f.length && f.children().length ? f.is(":visible") ? d.empty().append(g.icons.collapse) : d.empty().append(g.icons.expand) : d.empty(), c.removeClass(g.style.dropAbove).removeClass(g.style.dropBelow), e.css("width", g.indentation * (h - 1));
    }
  },
  "public": {},
  events: {
    nodeDrop: function nodeDrop(a, b, c, d) {
      return a.triggerHandler("nodeDrop", [b, c, d]);
    }
  },
  configure: function configure(a) {
    $.extend(!0, a, gj.tree.plugins.dragAndDrop["public"]), a.data("dragAndDrop") && gj.draggable && gj.droppable && a.on("nodeDataBound", function (b, c) {
      gj.tree.plugins.dragAndDrop["private"].nodeDataBound(a, c);
    });
  }
}, gj.tree.plugins.lazyLoading = {
  config: {
    base: {
      paramNames: {
        parentId: "parentId"
      },
      lazyLoading: !1
    }
  },
  "private": {
    nodeDataBound: function nodeDataBound(a, b, c, d) {
      var e = a.data(),
        f = b.find('> [data-role="wrapper"] > [data-role="expander"]');
      d.hasChildren && f.empty().append(e.icons.expand);
    },
    createDoneHandler: function createDoneHandler(a, b) {
      return function (c) {
        var d,
          e,
          f,
          g = a.data();
        if ("string" == typeof c && JSON && (c = JSON.parse(c)), c && c.length) {
          for (f = b.children("ul"), 0 === f.length && (f = $("<ul />").addClass(g.style.list), b.append(f)), d = 0; d < c.length; d++) a.addNode(c[d], f);
          e = b.find('>[data-role="wrapper"]>[data-role="expander"]'), e.attr("data-mode", "open"), e.empty().append(g.icons.collapse), gj.tree.events.dataBound(a);
        }
      };
    },
    expand: function expand(a, b, c) {
      var d,
        e = a.data(),
        f = {},
        g = b.find(">ul>li");
      g && g.length || "string" == typeof e.dataSource && (f[e.paramNames.parentId] = c, d = {
        url: e.dataSource,
        data: f
      }, a.xhr && a.xhr.abort(), a.xhr = $.ajax(d).done(gj.tree.plugins.lazyLoading["private"].createDoneHandler(a, b)).fail(a.createErrorHandler()));
    }
  },
  "public": {},
  events: {},
  configure: function configure(a, b, c) {
    c.lazyLoading && (a.on("nodeDataBound", function (b, c, d, e) {
      gj.tree.plugins.lazyLoading["private"].nodeDataBound(a, c, d, e);
    }), a.on("expand", function (b, c, d) {
      gj.tree.plugins.lazyLoading["private"].expand(a, c, d);
    }));
  }
}, gj.checkbox = {
  plugins: {}
}, gj.checkbox.config = {
  base: {
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    style: {
      wrapperCssClass: "gj-checkbox-md",
      spanCssClass: void 0
    }
  },
  bootstrap: {
    style: {
      wrapperCssClass: "gj-checkbox-bootstrap"
    },
    iconsLibrary: "glyphicons"
  },
  bootstrap4: {
    style: {
      wrapperCssClass: "gj-checkbox-bootstrap gj-checkbox-bootstrap-4"
    },
    iconsLibrary: "materialicons"
  },
  materialicons: {
    style: {
      iconsCssClass: "gj-checkbox-material-icons",
      spanCssClass: "gj-icon"
    }
  },
  glyphicons: {
    style: {
      iconsCssClass: "gj-checkbox-glyphicons",
      spanCssClass: ""
    }
  },
  fontawesome: {
    style: {
      iconsCssClass: "gj-checkbox-fontawesome",
      spanCssClass: "fa"
    }
  }
}, gj.checkbox.methods = {
  init: function init(a) {
    var b = this;
    return gj.widget.prototype.init.call(this, a, "checkbox"), b.attr("data-checkbox", "true"), gj.checkbox.methods.initialize(b), b;
  },
  initialize: function initialize(a) {
    var b,
      c,
      d = a.data();
    d.style.wrapperCssClass && (b = $('<label class="' + d.style.wrapperCssClass + " " + d.style.iconsCssClass + '"></label>'), a.attr("id") && b.attr("for", a.attr("id")), a.wrap(b), c = $("<span />"), d.style.spanCssClass && c.addClass(d.style.spanCssClass), a.parent().append(c));
  },
  state: function state(a, b) {
    return b ? ("checked" === b ? (a.prop("indeterminate", !1), a.prop("checked", !0)) : "unchecked" === b ? (a.prop("indeterminate", !1), a.prop("checked", !1)) : "indeterminate" === b && (a.prop("checked", !0), a.prop("indeterminate", !0)), gj.checkbox.events.change(a, b), a) : b = a.prop("indeterminate") ? "indeterminate" : a.prop("checked") ? "checked" : "unchecked";
  },
  toggle: function toggle(a) {
    return "checked" == a.state() ? a.state("unchecked") : a.state("checked"), a;
  },
  destroy: function destroy(a) {
    return "true" === a.attr("data-checkbox") && (a.removeData(), a.removeAttr("data-guid"), a.removeAttr("data-checkbox"), a.off(), a.next("span").remove(), a.unwrap()), a;
  }
}, gj.checkbox.events = {
  change: function change(a, b) {
    return a.triggerHandler("change", [b]);
  }
}, gj.checkbox.widget = function (a, b) {
  var c = this,
    d = gj.checkbox.methods;
  return c.toggle = function () {
    return d.toggle(this);
  }, c.state = function (a) {
    return d.state(this, a);
  }, c.destroy = function () {
    return d.destroy(this);
  }, $.extend(a, c), "true" !== a.attr("data-checkbox") && d.init.call(a, b), a;
}, gj.checkbox.widget.prototype = new gj.widget(), gj.checkbox.widget.constructor = gj.checkbox.widget, function (a) {
  a.fn.checkbox = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.checkbox.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.checkbox.widget(this, a);
    }
  };
}(jQuery), gj.editor = {
  plugins: {},
  messages: {}
}, gj.editor.config = {
  base: {
    height: 300,
    width: void 0,
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    locale: "en-us",
    buttons: void 0,
    style: {
      wrapper: "gj-editor gj-editor-md",
      buttonsGroup: "gj-button-md-group",
      button: "gj-button-md",
      buttonActive: "active"
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-editor gj-editor-bootstrap",
      buttonsGroup: "btn-group",
      button: "btn btn-default gj-cursor-pointer",
      buttonActive: "active"
    }
  },
  bootstrap4: {
    style: {
      wrapper: "gj-editor gj-editor-bootstrap",
      buttonsGroup: "btn-group",
      button: "btn btn-outline-secondary gj-cursor-pointer",
      buttonActive: "active"
    }
  },
  materialicons: {
    icons: {
      bold: '<i class="gj-icon bold" />',
      italic: '<i class="gj-icon italic" />',
      strikethrough: '<i class="gj-icon strikethrough" />',
      underline: '<i class="gj-icon underlined" />',
      listBulleted: '<i class="gj-icon list-bulleted" />',
      listNumbered: '<i class="gj-icon list-numbered" />',
      indentDecrease: '<i class="gj-icon indent-decrease" />',
      indentIncrease: '<i class="gj-icon indent-increase" />',
      alignLeft: '<i class="gj-icon align-left" />',
      alignCenter: '<i class="gj-icon align-center" />',
      alignRight: '<i class="gj-icon align-right" />',
      alignJustify: '<i class="gj-icon align-justify" />',
      undo: '<i class="gj-icon undo" />',
      redo: '<i class="gj-icon redo" />'
    }
  },
  fontawesome: {
    icons: {
      bold: '<i class="fa fa-bold" aria-hidden="true"></i>',
      italic: '<i class="fa fa-italic" aria-hidden="true"></i>',
      strikethrough: '<i class="fa fa-strikethrough" aria-hidden="true"></i>',
      underline: '<i class="fa fa-underline" aria-hidden="true"></i>',
      listBulleted: '<i class="fa fa-list-ul" aria-hidden="true"></i>',
      listNumbered: '<i class="fa fa-list-ol" aria-hidden="true"></i>',
      indentDecrease: '<i class="fa fa-indent" aria-hidden="true"></i>',
      indentIncrease: '<i class="fa fa-outdent" aria-hidden="true"></i>',
      alignLeft: '<i class="fa fa-align-left" aria-hidden="true"></i>',
      alignCenter: '<i class="fa fa-align-center" aria-hidden="true"></i>',
      alignRight: '<i class="fa fa-align-right" aria-hidden="true"></i>',
      alignJustify: '<i class="fa fa-align-justify" aria-hidden="true"></i>',
      undo: '<i class="fa fa-undo" aria-hidden="true"></i>',
      redo: '<i class="fa fa-repeat" aria-hidden="true"></i>'
    }
  }
}, gj.editor.methods = {
  init: function init(a) {
    return gj.widget.prototype.init.call(this, a, "editor"), this.attr("data-editor", "true"), gj.editor.methods.initialize(this), this;
  },
  initialize: function initialize(a) {
    var b,
      c,
      d,
      e,
      f,
      g = this,
      h = a.data();
    if (a.hide(), "wrapper" !== a[0].parentElement.attributes.role && (d = document.createElement("div"), d.setAttribute("role", "wrapper"), a[0].parentNode.insertBefore(d, a[0]), d.appendChild(a[0])), gj.editor.methods.localization(h), $(d).addClass(h.style.wrapper), h.width && $(d).width(h.width), e = $(d).children('div[role="body"]'), 0 === e.length && (e = $('<div role="body"></div>'), $(d).append(e), a[0].innerText && (e[0].innerHTML = a[0].innerText)), e.attr("contenteditable", !0), e.on("keydown", function (b) {
      var c = event.keyCode || event.charCode;
      !1 === gj.editor.events.changing(a) && 8 !== c && 46 !== c && b.preventDefault();
    }), e.on("mouseup keyup mouseout cut paste", function (b) {
      g.updateToolbar(a, f), gj.editor.events.changed(a), a.html(e.html());
    }), f = $(d).children('div[role="toolbar"]'), 0 === f.length) {
      f = $('<div role="toolbar"></div>'), e.before(f);
      for (var i in h.buttons) {
        b = $("<div />").addClass(h.style.buttonsGroup);
        for (var j in h.buttons[i]) c = $(h.buttons[i][j]), c.on("click", function () {
          gj.editor.methods.executeCmd(a, e, f, $(this));
        }), b.append(c);
        f.append(b);
      }
    }
    e.height(h.height - gj.core.height(f[0], !0));
  },
  localization: function localization(a) {
    var b = gj.editor.messages[a.locale];
    void 0 === a.buttons && (a.buttons = [['<button type="button" class="' + a.style.button + '" title="' + b.bold + '" role="bold">' + a.icons.bold + "</button>", '<button type="button" class="' + a.style.button + '" title="' + b.italic + '" role="italic">' + a.icons.italic + "</button>", '<button type="button" class="' + a.style.button + '" title="' + b.strikethrough + '" role="strikethrough">' + a.icons.strikethrough + "</button>", '<button type="button" class="' + a.style.button + '" title="' + b.underline + '" role="underline">' + a.icons.underline + "</button>"], ['<button type="button" class="' + a.style.button + '" title="' + b.listBulleted + '" role="insertunorderedlist">' + a.icons.listBulleted + "</button>", '<button type="button" class="' + a.style.button + '" title="' + b.listNumbered + '" role="insertorderedlist">' + a.icons.listNumbered + "</button>", '<button type="button" class="' + a.style.button + '" title="' + b.indentDecrease + '" role="outdent">' + a.icons.indentDecrease + "</button>", '<button type="button" class="' + a.style.button + '" title="' + b.indentIncrease + '" role="indent">' + a.icons.indentIncrease + "</button>"], ['<button type="button" class="' + a.style.button + '" title="' + b.alignLeft + '" role="justifyleft">' + a.icons.alignLeft + "</button>", '<button type="button" class="' + a.style.button + '" title="' + b.alignCenter + '" role="justifycenter">' + a.icons.alignCenter + "</button>", '<button type="button" class="' + a.style.button + '" title="' + b.alignRight + '" role="justifyright">' + a.icons.alignRight + "</button>", '<button type="button" class="' + a.style.button + '" title="' + b.alignJustify + '" role="justifyfull">' + a.icons.alignJustify + "</button>"], ['<button type="button" class="' + a.style.button + '" title="' + b.undo + '" role="undo">' + a.icons.undo + "</button>", '<button type="button" class="' + a.style.button + '" title="' + b.redo + '" role="redo">' + a.icons.redo + "</button>"]]);
  },
  updateToolbar: function updateToolbar(a, b) {
    var c = a.data();
    $buttons = b.find("[role]").each(function () {
      var a = $(this),
        b = a.attr("role");
      b && document.queryCommandEnabled(b) && "true" === document.queryCommandValue(b) ? a.addClass(c.style.buttonActive) : a.removeClass(c.style.buttonActive);
    });
  },
  executeCmd: function executeCmd(a, b, c, d) {
    b.focus(), document.execCommand(d.attr("role"), !1), gj.editor.methods.updateToolbar(a, c);
  },
  content: function content(a, b) {
    var c = a.parent().children('div[role="body"]');
    return void 0 === b ? c.html() : c.html(b);
  },
  destroy: function destroy(a) {
    var b;
    return "true" === a.attr("data-editor") && (b = a.parent(), b.children('div[role="body"]').remove(), b.children('div[role="toolbar"]').remove(), a.unwrap(), a.removeData(), a.removeAttr("data-guid"), a.removeAttr("data-editor"), a.off(), a.show()), a;
  }
}, gj.editor.events = {
  changing: function changing(a) {
    return a.triggerHandler("changing");
  },
  changed: function changed(a) {
    return a.triggerHandler("changed");
  }
}, gj.editor.widget = function (a, b) {
  var c = this,
    d = gj.editor.methods;
  return c.content = function (a) {
    return d.content(this, a);
  }, c.destroy = function () {
    return d.destroy(this);
  }, $.extend(a, c), "true" !== a.attr("data-editor") && d.init.call(a, b), a;
}, gj.editor.widget.prototype = new gj.widget(), gj.editor.widget.constructor = gj.editor.widget, function (a) {
  a.fn.editor = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.editor.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.editor.widget(this, a);
    }
  };
}(jQuery), gj.editor.messages["en-us"] = {
  bold: "Bold",
  italic: "Italic",
  strikethrough: "Strikethrough",
  underline: "Underline",
  listBulleted: "List Bulleted",
  listNumbered: "List Numbered",
  indentDecrease: "Indent Decrease",
  indentIncrease: "Indent Increase",
  alignLeft: "Align Left",
  alignCenter: "Align Center",
  alignRight: "Align Right",
  alignJustify: "Align Justify",
  undo: "Undo",
  redo: "Redo"
}, gj.dropdown = {
  plugins: {}
}, gj.dropdown.config = {
  base: {
    dataSource: void 0,
    textField: "text",
    valueField: "value",
    selectedField: "selected",
    width: void 0,
    maxHeight: "auto",
    placeholder: void 0,
    fontSize: void 0,
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    icons: {
      dropdown: '<i class="gj-icon arrow-dropdown" />',
      dropup: '<i class="gj-icon arrow-dropup" />'
    },
    style: {
      wrapper: "gj-dropdown gj-dropdown-md gj-unselectable",
      list: "gj-list gj-list-md gj-dropdown-list-md",
      active: "gj-list-md-active"
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-dropdown gj-dropdown-bootstrap gj-dropdown-bootstrap-3 gj-unselectable",
      presenter: "btn btn-default",
      list: "gj-list gj-list-bootstrap gj-dropdown-list-bootstrap list-group",
      item: "list-group-item",
      active: "active"
    },
    iconsLibrary: "glyphicons"
  },
  bootstrap4: {
    style: {
      wrapper: "gj-dropdown gj-dropdown-bootstrap gj-dropdown-bootstrap-4 gj-unselectable",
      presenter: "btn btn-outline-secondary",
      list: "gj-list gj-list-bootstrap gj-dropdown-list-bootstrap list-group",
      item: "list-group-item",
      active: "active"
    }
  },
  materialicons: {
    style: {
      expander: "gj-dropdown-expander-mi"
    }
  },
  fontawesome: {
    icons: {
      dropdown: '<i class="fa fa-caret-down" aria-hidden="true"></i>',
      dropup: '<i class="fa fa-caret-up" aria-hidden="true"></i>'
    },
    style: {
      expander: "gj-dropdown-expander-fa"
    }
  },
  glyphicons: {
    icons: {
      dropdown: '<span class="caret"></span>',
      dropup: '<span class="dropup"><span class="caret" ></span></span>'
    },
    style: {
      expander: "gj-dropdown-expander-glyphicons"
    }
  }
}, gj.dropdown.methods = {
  init: function init(a) {
    return gj.widget.prototype.init.call(this, a, "dropdown"), this.attr("data-dropdown", "true"), gj.dropdown.methods.initialize(this), this;
  },
  getHTMLConfig: function getHTMLConfig() {
    var a = gj.widget.prototype.getHTMLConfig.call(this),
      b = this[0].attributes;
    return b.placeholder && (a.placeholder = b.placeholder.value), a;
  },
  initialize: function initialize(a) {
    var b = a.data(),
      c = a.parent('div[role="wrapper"]'),
      d = $('<span role="display"></span>'),
      e = $('<span role="expander">' + b.icons.dropdown + "</span>").addClass(b.style.expander),
      f = $('<button role="presenter" type="button"></button>').addClass(b.style.presenter),
      g = $('<ul role="list" class="' + b.style.list + '"></ul>').attr("guid", a.attr("data-guid"));
    0 === c.length ? (c = $('<div role="wrapper" />').addClass(b.style.wrapper), a.wrap(c)) : c.addClass(b.style.wrapper), b.fontSize && f.css("font-size", b.fontSize), f.on("click", function (b) {
      g.is(":visible") ? gj.dropdown.methods.close(a, g) : gj.dropdown.methods.open(a, g);
    }), f.on("blur", function (b) {
      setTimeout(function () {
        gj.dropdown.methods.close(a, g);
      }, 500);
    }), f.append(d).append(e), a.hide(), a.after(f), $("body").append(g), g.hide(), a.reload();
  },
  setListPosition: function setListPosition(a, b, c) {
    var d,
      e,
      f,
      g,
      h = a.getBoundingClientRect(),
      i = window.scrollY || window.pageYOffset || 0;
    window.scrollX || window.pageXOffset;
    b.style.overflow = "", b.style.overflowX = "", b.style.height = "", gj.core.setChildPosition(a, b), d = gj.core.height(b, !0), g = b.getBoundingClientRect(), e = gj.core.height(a, !0), "auto" === c.maxHeight ? h.top < g.top ? h.top + d + e > window.innerHeight && (f = window.innerHeight - h.top - e - 3) : h.top - d - 3 > 0 ? b.style.top = Math.round(h.top + i - d - 3) + "px" : (b.style.top = i + "px", f = h.top - 3) : !isNaN(c.maxHeight) && c.maxHeight < d && (f = c.maxHeight), f && (b.style.overflow = "scroll", b.style.overflowX = "hidden", b.style.height = f + "px");
  },
  useHtmlDataSource: function useHtmlDataSource(a, b) {
    var c,
      d,
      e = [],
      f = a.find("option");
    for (c = 0; c < f.length; c++) d = {}, d[b.valueField] = f[c].value, d[b.textField] = f[c].innerHTML, d[b.selectedField] = a[0].value === f[c].value, e.push(d);
    b.dataSource = e;
  },
  filter: function filter(a) {
    var b,
      c,
      d = a.data();
    if (d.dataSource) {
      if ("string" == typeof d.dataSource[0]) for (b = 0; b < d.dataSource.length; b++) c = {}, c[d.valueField] = d.dataSource[b], c[d.textField] = d.dataSource[b], d.dataSource[b] = c;
    } else d.dataSource = [];
    return d.dataSource;
  },
  render: function render(a, b) {
    var c = [],
      d = a.data(),
      e = a.parent(),
      f = $("body").children('[role="list"][guid="' + a.attr("data-guid") + '"]'),
      g = e.children('[role="presenter"]'),
      h = (g.children('[role="expander"]'), g.children('[role="display"]'));
    if (a.data("records", b), a.empty(), f.empty(), b && b.length) if ($.each(b, function () {
      var b,
        e = this[d.valueField],
        g = this[d.textField],
        h = this[d.selectedField] && "true" === this[d.selectedField].toString().toLowerCase();
      b = $('<li value="' + e + '"><div data-role="wrapper"><span data-role="display">' + g + "</span></div></li>"), b.addClass(d.style.item), b.on("click", function (b) {
        gj.dropdown.methods.select(a, e);
      }), f.append(b), a.append('<option value="' + e + '">' + g + "</option>"), h && c.push(e);
    }), 0 === c.length) a.prepend('<option value=""></option>'), a[0].selectedIndex = 0, d.placeholder && (h[0].innerHTML = '<span class="placeholder">' + d.placeholder + "</span>");else for (i = 0; i < c.length; i++) gj.dropdown.methods.select(a, c[i]);
    return d.width && (e.css("width", d.width), g.css("width", d.width)), d.fontSize && f.children("li").css("font-size", d.fontSize), gj.dropdown.events.dataBound(a), a;
  },
  open: function open(a, b) {
    var c = a.data(),
      d = a.parent().find('[role="expander"]'),
      e = a.parent().find('[role="presenter"]'),
      f = gj.core.getScrollParent(a[0]);
    b.css("width", gj.core.width(e[0])), b.show(), gj.dropdown.methods.setListPosition(e[0], b[0], c), d.html(c.icons.dropup), f && (c.parentScrollHandler = function () {
      gj.dropdown.methods.setListPosition(e[0], b[0], c);
    }, gj.dropdown.methods.addParentsScrollListener(f, c.parentScrollHandler));
  },
  close: function close(a, b) {
    var c = a.data(),
      d = a.parent().find('[role="expander"]'),
      e = gj.core.getScrollParent(a[0]);
    d.html(c.icons.dropdown), e && c.parentScrollHandler && gj.dropdown.methods.removeParentsScrollListener(e, c.parentScrollHandler), b.hide();
  },
  addParentsScrollListener: function addParentsScrollListener(a, b) {
    var c = gj.core.getScrollParent(a.parentNode);
    a.addEventListener("scroll", b), c && gj.dropdown.methods.addParentsScrollListener(c, b);
  },
  removeParentsScrollListener: function removeParentsScrollListener(a, b) {
    var c = gj.core.getScrollParent(a.parentNode);
    a.removeEventListener("scroll", b), c && gj.dropdown.methods.removeParentsScrollListener(c, b);
  },
  select: function select(a, b) {
    var c = a.data(),
      d = $("body").children('[role="list"][guid="' + a.attr("data-guid") + '"]'),
      e = d.children('li[value="' + b + '"]'),
      f = a.next('[role="presenter"]').find('[role="display"]'),
      g = gj.dropdown.methods.getRecordByValue(a, b);
    return d.children("li").removeClass(c.style.active), g ? (e.addClass(c.style.active), a[0].value = b, f[0].innerHTML = g[c.textField]) : (c.placeholder && (f[0].innerHTML = '<span class="placeholder">' + c.placeholder + "</span>"), a[0].value = ""), gj.dropdown.events.change(a), gj.dropdown.methods.close(a, d), a;
  },
  getRecordByValue: function getRecordByValue(a, b) {
    var c,
      d = a.data(),
      e = void 0;
    for (c = 0; c < d.records.length; c++) if (d.records[c][d.valueField] === b) {
      e = d.records[c];
      break;
    }
    return e;
  },
  value: function value(a, b) {
    return void 0 === b ? a.val() : (gj.dropdown.methods.select(a, b), a);
  },
  destroy: function destroy(a) {
    var b = a.data(),
      c = a.parent('div[role="wrapper"]');
    return b && (a.xhr && a.xhr.abort(), a.off(), a.removeData(), a.removeAttr("data-type").removeAttr("data-guid").removeAttr("data-dropdown"), a.removeClass(), c.length > 0 && (c.children('[role="presenter"]').remove(), c.children('[role="list"]').remove(), a.unwrap()), a.show()), a;
  }
}, gj.dropdown.events = {
  change: function change(a) {
    return a.triggerHandler("change");
  },
  dataBound: function dataBound(a) {
    return a.triggerHandler("dataBound");
  }
}, gj.dropdown.widget = function (a, b) {
  var c = this,
    d = gj.dropdown.methods;
  return c.value = function (a) {
    return d.value(this, a);
  }, c.enable = function () {
    return d.enable(this);
  }, c.disable = function () {
    return d.disable(this);
  }, c.destroy = function () {
    return d.destroy(this);
  }, $.extend(a, c), "true" !== a.attr("data-dropdown") && d.init.call(a, b), a;
}, gj.dropdown.widget.prototype = new gj.widget(), gj.dropdown.widget.constructor = gj.dropdown.widget, gj.dropdown.widget.prototype.getHTMLConfig = gj.dropdown.methods.getHTMLConfig, function (a) {
  a.fn.dropdown = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.dropdown.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.dropdown.widget(this, a);
    }
  };
}(jQuery), gj.datepicker = {
  plugins: {}
}, gj.datepicker.config = {
  base: {
    showOtherMonths: !1,
    selectOtherMonths: !0,
    width: void 0,
    minDate: void 0,
    maxDate: void 0,
    format: "mm/dd/yyyy",
    uiLibrary: "materialdesign",
    iconsLibrary: "materialicons",
    value: void 0,
    weekStartDay: 0,
    disableDates: void 0,
    disableDaysOfWeek: void 0,
    calendarWeeks: !1,
    keyboardNavigation: !0,
    locale: "en-us",
    icons: {
      rightIcon: '<i class="ti-calendar"></i>',
      previousMonth: '<i class="ti-angle-left"></i>',
      nextMonth: '<i class="ti-angle-right"></i>'
    },
    fontSize: void 0,
    size: "default",
    modal: !1,
    header: !1,
    footer: !1,
    showOnFocus: !0,
    showRightIcon: !0,
    style: {
      modal: "gj-modal",
      wrapper: "gj-datepicker gj-datepicker-md gj-unselectable",
      input: "gj-textbox-md",
      calendar: "gj-picker gj-picker-md datepicker gj-unselectable",
      footer: "",
      button: "gj-button-md"
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-datepicker gj-datepicker-bootstrap gj-unselectable input-group",
      input: "form-control",
      calendar: "gj-picker gj-picker-bootstrap datepicker gj-unselectable",
      footer: "modal-footer",
      button: "btn btn-default"
    },
    iconsLibrary: "glyphicons",
    showOtherMonths: !0
  },
  bootstrap4: {
    style: {
      wrapper: "gj-datepicker gj-datepicker-bootstrap gj-unselectable input-group",
      input: "form-control",
      calendar: "gj-picker gj-picker-bootstrap datepicker gj-unselectable",
      footer: "modal-footer",
      button: "btn btn-default"
    },
    showOtherMonths: !0
  },
  fontawesome: {
    icons: {
      rightIcon: '<i class="fa fa-calendar" aria-hidden="true"></i>',
      previousMonth: '<i class="fa fa-chevron-left" aria-hidden="true"></i>',
      nextMonth: '<i class="fa fa-chevron-right" aria-hidden="true"></i>'
    }
  },
  glyphicons: {
    icons: {
      rightIcon: '<span class="glyphicon glyphicon-calendar"></span>',
      previousMonth: '<span class="glyphicon glyphicon-chevron-left"></span>',
      nextMonth: '<span class="glyphicon glyphicon-chevron-right"></span>'
    }
  }
}, gj.datepicker.methods = {
  init: function init(a) {
    return gj.widget.prototype.init.call(this, a, "datepicker"), this.attr("data-datepicker", "true"), gj.datepicker.methods.initialize(this, this.data()), this;
  },
  initialize: function initialize(a, b) {
    var c,
      d,
      e = a.parent('div[role="wrapper"]');
    0 === e.length ? (e = $('<div role="wrapper" />').addClass(b.style.wrapper), a.wrap(e)) : e.addClass(b.style.wrapper), e = a.parent('div[role="wrapper"]'), b.width && e.css("width", b.width), a.val(b.value).addClass(b.style.input).attr("role", "input"), b.fontSize && a.css("font-size", b.fontSize), "bootstrap" === b.uiLibrary || "bootstrap4" === b.uiLibrary ? "small" === b.size ? (e.addClass("input-group-sm"), a.addClass("form-control-sm")) : "large" === b.size && (e.addClass("input-group-lg"), a.addClass("form-control-lg")) : "small" === b.size ? e.addClass("small") : "large" === b.size && e.addClass("large"), b.showRightIcon && (d = "bootstrap" === b.uiLibrary ? $('<span class="input-group-addon">' + b.icons.rightIcon + "</span>") : "bootstrap4" === b.uiLibrary ? $('<span class="input-group-append"><button class="btn btn-outline-secondary border-left-0" type="button">' + b.icons.rightIcon + "</button></span>") : $(b.icons.rightIcon), d.attr("role", "right-icon"), d.on("click", function (c) {
      $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]').is(":visible") ? gj.datepicker.methods.close(a) : gj.datepicker.methods.open(a, b);
    }), e.append(d)), b.showOnFocus && a.on("focus", function () {
      gj.datepicker.methods.open(a, b);
    }), c = gj.datepicker.methods.createCalendar(a, b), !0 !== b.footer && (a.on("blur", function () {
      a.timeout = setTimeout(function () {
        gj.datepicker.methods.close(a);
      }, 500);
    }), c.mousedown(function () {
      return clearTimeout(a.timeout), document.activeElement !== a[0] && a.focus(), !1;
    }), c.on("click", function () {
      clearTimeout(a.timeout), document.activeElement !== a[0] && a.focus();
    })), b.keyboardNavigation && $(document).on("keydown", gj.datepicker.methods.createKeyDownHandler(a, c, b));
  },
  createCalendar: function createCalendar(a, b) {
    var c,
      d,
      e,
      f,
      g,
      h = $('<div role="calendar" type="month"/>').addClass(b.style.calendar).attr("guid", a.attr("data-guid"));
    return b.fontSize && h.css("font-size", b.fontSize), c = gj.core.parseDate(b.value, b.format, b.locale), !c || isNaN(c.getTime()) ? c = new Date() : a.attr("day", c.getFullYear() + "-" + c.getMonth() + "-" + c.getDate()), h.attr("month", c.getMonth()), h.attr("year", c.getFullYear()), gj.datepicker.methods.renderHeader(a, h, b, c), d = $('<div role="body" />'), h.append(d), b.footer && (e = $('<div role="footer" class="' + b.style.footer + '" />'), f = $('<button class="' + b.style.button + '">' + gj.core.messages[b.locale].cancel + "</button>"), f.on("click", function () {
      a.close();
    }), e.append(f), g = $('<button class="' + b.style.button + '">' + gj.core.messages[b.locale].ok + "</button>"), g.on("click", function () {
      var c,
        d,
        e = h.attr("selectedDay");
      e ? (d = e.split("-"), c = new Date(d[0], d[1], d[2], h.attr("hour") || 0, h.attr("minute") || 0), gj.datepicker.methods.change(a, h, b, c)) : a.close();
    }), e.append(g), h.append(e)), h.hide(), $("body").append(h), b.modal && (h.wrapAll('<div role="modal" class="' + b.style.modal + '"/>'), gj.core.center(h)), h;
  },
  renderHeader: function renderHeader(a, b, c, d) {
    var e, f, g;
    c.header && (e = $('<div role="header" />'), g = $('<div role="year" />').on("click", function () {
      gj.datepicker.methods.renderDecade(a, b, c), g.addClass("selected"), f.removeClass("selected");
    }), g.html(gj.core.formatDate(d, "yyyy", c.locale)), e.append(g), f = $('<div role="date" class="selected" />').on("click", function () {
      gj.datepicker.methods.renderMonth(a, b, c), f.addClass("selected"), g.removeClass("selected");
    }), f.html(gj.core.formatDate(d, "ddd, mmm dd", c.locale)), e.append(f), b.append(e));
  },
  updateHeader: function updateHeader(a, b, c) {
    a.find('[role="header"] [role="year"]').removeClass("selected").html(gj.core.formatDate(c, "yyyy", b.locale)), a.find('[role="header"] [role="date"]').addClass("selected").html(gj.core.formatDate(c, "ddd, mmm dd", b.locale)), a.find('[role="header"] [role="hour"]').removeClass("selected").html(gj.core.formatDate(c, "HH", b.locale)), a.find('[role="header"] [role="minute"]').removeClass("selected").html(gj.core.formatDate(c, "MM", b.locale));
  },
  createNavigation: function createNavigation(a, b, c, d) {
    var e,
      f,
      g = $("<thead/>");
    for (f = $('<div role="navigator" />'), f.append($("<div>" + d.icons.previousMonth + "</div>").on("click", gj.datepicker.methods.prev(a, d))), f.append($('<div role="period"></div>').on("click", gj.datepicker.methods.changePeriod(a, d))), f.append($("<div>" + d.icons.nextMonth + "</div>").on("click", gj.datepicker.methods.next(a, d))), b.append(f), e = $('<tr role="week-days" />'), d.calendarWeeks && e.append("<th><div>&nbsp;</div></th>"), i = d.weekStartDay; i < gj.core.messages[d.locale].weekDaysMin.length; i++) e.append("<th><div>" + gj.core.messages[d.locale].weekDaysMin[i] + "</div></th>");
    for (i = 0; i < d.weekStartDay; i++) e.append("<th><div>" + gj.core.messages[d.locale].weekDaysMin[i] + "</div></th>");
    g.append(e), c.append(g);
  },
  renderMonth: function renderMonth(a, b, c) {
    var d,
      e,
      f,
      g,
      h,
      i,
      j,
      k,
      l,
      m,
      n,
      o,
      p,
      q,
      r,
      s = b.children('[role="body"]'),
      t = $("<table/>"),
      u = $("<tbody/>"),
      v = gj.core.messages[c.locale].titleFormat;
    for (s.off().empty(), gj.datepicker.methods.createNavigation(a, s, t, c), g = parseInt(b.attr("month"), 10), h = parseInt(b.attr("year"), 10), b.attr("type", "month"), v = v.replace("mmmm", gj.core.messages[c.locale].monthNames[g]).replace("yyyy", h), b.find('div[role="period"]').text(v), i = new Array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31), h % 4 == 0 && 1900 != h && (i[1] = 29), j = i[g], k = (new Date(h, g, 1).getDay() + 7 - c.weekStartDay) % 7, d = 0, $row = $("<tr />"), n = gj.datepicker.methods.getPrevMonth(g, h), l = 1; l <= k; l++) f = i[n.month] - k + l, r = new Date(n.year, n.month, f), c.calendarWeeks && 1 === l && $row.append('<td class="calendar-week"><div>' + gj.datepicker.methods.getWeekNumber(r) + "</div></td>"), p = $('<td class="other-month" />'), c.showOtherMonths && (q = $("<div>" + f + "</div>"), p.append(q), c.selectOtherMonths && gj.datepicker.methods.isSelectable(c, r) ? (p.addClass("gj-cursor-pointer").attr("day", f).attr("month", n.month).attr("year", n.year), q.on("click", gj.datepicker.methods.dayClickHandler(a, b, c, r)), q.on("mousedown", function (a) {
      a.stopPropagation();
    })) : p.addClass("disabled")), $row.append(p), d++;
    for (l > 1 && u.append($row), m = new Date(), l = 1; l <= j; l++) r = new Date(h, g, l), 0 == d && ($row = $("<tr>"), c.calendarWeeks && $row.append('<td class="calendar-week"><div>' + gj.datepicker.methods.getWeekNumber(r) + "</div></td>")), p = $('<td day="' + l + '" month="' + g + '" year="' + h + '" />'), h === m.getFullYear() && g === m.getMonth() && l === m.getDate() ? p.addClass("today") : p.addClass("current-month"), q = $("<div>" + l + "</div>"), gj.datepicker.methods.isSelectable(c, r) ? (p.addClass("gj-cursor-pointer"), q.on("click", gj.datepicker.methods.dayClickHandler(a, b, c, r)), q.on("mousedown", function (a) {
      a.stopPropagation();
    })) : p.addClass("disabled"), p.append(q), $row.append(p), 7 == ++d && (u.append($row), d = 0);
    for (o = gj.datepicker.methods.getNextMonth(g, h), l = 1; 0 != d; l++) r = new Date(o.year, o.month, l), p = $('<td class="other-month" />'), c.showOtherMonths && (q = $("<div>" + l + "</div>"), c.selectOtherMonths && gj.datepicker.methods.isSelectable(c, r) ? (p.addClass("gj-cursor-pointer").attr("day", l).attr("month", o.month).attr("year", o.year), q.on("click", gj.datepicker.methods.dayClickHandler(a, b, c, r)), q.on("mousedown", function (a) {
      a.stopPropagation();
    })) : p.addClass("disabled"), p.append(q)), $row.append(p), 7 == ++d && (u.append($row), d = 0);
    t.append(u), s.append(t), b.attr("selectedDay") && (e = b.attr("selectedDay").split("-"), r = new Date(e[0], e[1], e[2], b.attr("hour") || 0, b.attr("minute") || 0), b.find('tbody td[day="' + e[2] + '"][month="' + e[1] + '"]').addClass("selected"), gj.datepicker.methods.updateHeader(b, c, r));
  },
  renderYear: function renderYear(a, b, c) {
    var d,
      e,
      f,
      g,
      h = b.find('>[role="body"]>table'),
      i = h.children("tbody");
    for (h.children("thead").hide(), d = parseInt(b.attr("year"), 10), b.attr("type", "year"), b.find('div[role="period"]').text(d), i.empty(), e = 0; e < 3; e++) {
      for ($row = $("<tr />"), f = 4 * e; f <= 4 * e + 3; f++) g = $("<div>" + gj.core.messages[c.locale].monthShortNames[f] + "</div>"), g.on("click", gj.datepicker.methods.selectMonth(a, b, c, f)), $cell = $("<td></td>").append(g), $row.append($cell);
      i.append($row);
    }
  },
  renderDecade: function renderDecade(a, b, c) {
    var d,
      e,
      f,
      g,
      h,
      i = b.find('>[role="body"]>table'),
      j = i.children("tbody");
    for (i.children("thead").hide(), d = parseInt(b.attr("year"), 10), e = d - d % 10, b.attr("type", "decade"), b.find('div[role="period"]').text(e + " - " + (e + 9)), j.empty(), f = e - 1; f <= e + 10; f += 4) {
      for ($row = $("<tr />"), g = f; g <= f + 3; g++) h = $("<div>" + g + "</div>"), h.on("click", gj.datepicker.methods.selectYear(a, b, c, g)), $cell = $("<td></td>").append(h), $row.append($cell);
      j.append($row);
    }
  },
  renderCentury: function renderCentury(a, b, c) {
    var d,
      e,
      f,
      g,
      h,
      i = b.find('>[role="body"]>table'),
      j = i.children("tbody");
    for (i.children("thead").hide(), d = parseInt(b.attr("year"), 10), e = d - d % 100, b.attr("type", "century"), b.find('div[role="period"]').text(e + " - " + (e + 99)), j.empty(), f = e - 10; f < e + 100; f += 40) {
      for ($row = $("<tr />"), g = f; g <= f + 30; g += 10) h = $("<div>" + g + "</div>"), h.on("click", gj.datepicker.methods.selectDecade(a, b, c, g)), $cell = $("<td></td>").append(h), $row.append($cell);
      j.append($row);
    }
  },
  getWeekNumber: function getWeekNumber(a) {
    var b = new Date(a.valueOf());
    b.setDate(b.getDate() + 6), b = new Date(Date.UTC(b.getFullYear(), b.getMonth(), b.getDate())), b.setUTCDate(b.getUTCDate() + 4 - (b.getUTCDay() || 7));
    var c = new Date(Date.UTC(b.getUTCFullYear(), 0, 1));
    return Math.ceil(((b - c) / 864e5 + 1) / 7);
  },
  getMinDate: function getMinDate(a) {
    var b;
    return a.minDate && ("string" == typeof a.minDate ? b = gj.core.parseDate(a.minDate, a.format, a.locale) : "function" == typeof a.minDate ? "string" == typeof (b = a.minDate()) && (b = gj.core.parseDate(b, a.format, a.locale)) : "function" == typeof a.minDate.getMonth && (b = a.minDate)), b;
  },
  getMaxDate: function getMaxDate(a) {
    var b;
    return a.maxDate && ("string" == typeof a.maxDate ? b = gj.core.parseDate(a.maxDate, a.format, a.locale) : "function" == typeof a.maxDate ? "string" == typeof (b = a.maxDate()) && (b = gj.core.parseDate(b, a.format, a.locale)) : "function" == typeof a.maxDate.getMonth && (b = a.maxDate)), b;
  },
  isSelectable: function isSelectable(a, b) {
    var c,
      d = !0,
      e = gj.datepicker.methods.getMinDate(a),
      f = gj.datepicker.methods.getMaxDate(a);
    if (e && b < e ? d = !1 : f && b > f && (d = !1), d) {
      if (a.disableDates) if ($.isArray(a.disableDates)) for (c = 0; c < a.disableDates.length; c++) a.disableDates[c] instanceof Date && a.disableDates[c].getTime() === b.getTime() ? d = !1 : "string" == typeof a.disableDates[c] && gj.core.parseDate(a.disableDates[c], a.format, a.locale).getTime() === b.getTime() && (d = !1);else a.disableDates instanceof Function && (d = a.disableDates(b));
      $.isArray(a.disableDaysOfWeek) && a.disableDaysOfWeek.indexOf(b.getDay()) > -1 && (d = !1);
    }
    return d;
  },
  getPrevMonth: function getPrevMonth(a, b) {
    return date = new Date(b, a, 1), date.setMonth(date.getMonth() - 1), {
      month: date.getMonth(),
      year: date.getFullYear()
    };
  },
  getNextMonth: function getNextMonth(a, b) {
    return date = new Date(b, a, 1), date.setMonth(date.getMonth() + 1), {
      month: date.getMonth(),
      year: date.getFullYear()
    };
  },
  prev: function prev(a, b) {
    return function () {
      var c,
        d,
        e,
        f,
        g,
        h = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]');
      switch (e = parseInt(h.attr("year"), 10), h.attr("type")) {
        case "month":
          d = parseInt(h.attr("month"), 10), c = gj.datepicker.methods.getPrevMonth(d, e), h.attr("month", c.month), h.attr("year", c.year), gj.datepicker.methods.renderMonth(a, h, b);
          break;
        case "year":
          h.attr("year", e - 1), gj.datepicker.methods.renderYear(a, h, b);
          break;
        case "decade":
          f = e - e % 10, h.attr("year", f - 10), gj.datepicker.methods.renderDecade(a, h, b);
          break;
        case "century":
          g = e - e % 100, h.attr("year", g - 100), gj.datepicker.methods.renderCentury(a, h, b);
      }
    };
  },
  next: function next(a, b) {
    return function () {
      var c,
        d,
        e,
        f,
        g,
        h = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]');
      switch (e = parseInt(h.attr("year"), 10), h.attr("type")) {
        case "month":
          d = parseInt(h.attr("month"), 10), c = gj.datepicker.methods.getNextMonth(d, e), h.attr("month", c.month), h.attr("year", c.year), gj.datepicker.methods.renderMonth(a, h, b);
          break;
        case "year":
          h.attr("year", e + 1), gj.datepicker.methods.renderYear(a, h, b);
          break;
        case "decade":
          f = e - e % 10, h.attr("year", f + 10), gj.datepicker.methods.renderDecade(a, h, b);
          break;
        case "century":
          g = e - e % 100, h.attr("year", g + 100), gj.datepicker.methods.renderCentury(a, h, b);
      }
    };
  },
  changePeriod: function changePeriod(a, b) {
    return function (c) {
      var d = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]');
      switch (d.attr("type")) {
        case "month":
          gj.datepicker.methods.renderYear(a, d, b);
          break;
        case "year":
          gj.datepicker.methods.renderDecade(a, d, b);
          break;
        case "decade":
          gj.datepicker.methods.renderCentury(a, d, b);
      }
    };
  },
  dayClickHandler: function dayClickHandler(a, b, c, d) {
    return function (e) {
      return e && e.stopPropagation(), gj.datepicker.methods.selectDay(a, b, c, d), !0 !== c.footer && !1 !== c.autoClose && gj.datepicker.methods.change(a, b, c, d), a;
    };
  },
  change: function change(a, b, c, d) {
    var e = (d.getDate(), d.getMonth()),
      f = d.getFullYear(),
      g = gj.core.formatDate(d, c.format, c.locale);
    b.attr("month", e), b.attr("year", f), a.val(g), gj.datepicker.events.change(a), "none" !== window.getComputedStyle(b[0]).display && gj.datepicker.methods.close(a);
  },
  selectDay: function selectDay(a, b, c, d) {
    var e = d.getDate(),
      f = d.getMonth(),
      g = d.getFullYear();
    b.attr("selectedDay", g + "-" + f + "-" + e), b.find("tbody td").removeClass("selected"), b.find('tbody td[day="' + e + '"][month="' + f + '"]').addClass("selected"), gj.datepicker.methods.updateHeader(b, c, d), gj.datepicker.events.select(a, "day");
  },
  selectMonth: function selectMonth(a, b, c, d) {
    return function (e) {
      b.attr("month", d), gj.datepicker.methods.renderMonth(a, b, c), gj.datepicker.events.select(a, "month");
    };
  },
  selectYear: function selectYear(a, b, c, d) {
    return function (e) {
      b.attr("year", d), gj.datepicker.methods.renderYear(a, b, c), gj.datepicker.events.select(a, "year");
    };
  },
  selectDecade: function selectDecade(a, b, c, d) {
    return function (e) {
      b.attr("year", d), gj.datepicker.methods.renderDecade(a, b, c), gj.datepicker.events.select(a, "decade");
    };
  },
  open: function open(a, b) {
    var c,
      d = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]');
    switch (a.val() ? a.value(a.val()) : (c = new Date(), d.attr("month", c.getMonth()), d.attr("year", c.getFullYear())), d.attr("type")) {
      case "month":
        gj.datepicker.methods.renderMonth(a, d, b);
        break;
      case "year":
        gj.datepicker.methods.renderYear(a, d, b);
        break;
      case "decade":
        gj.datepicker.methods.renderDecade(a, d, b);
        break;
      case "century":
        gj.datepicker.methods.renderCentury(a, d, b);
    }
    d.show(), d.closest('div[role="modal"]').show(), b.modal ? gj.core.center(d) : (gj.core.setChildPosition(a[0], d[0]), document.activeElement !== a[0] && a.focus()), clearTimeout(a.timeout), gj.datepicker.events.open(a);
  },
  close: function close(a) {
    var b = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]');
    b.hide(), b.closest('div[role="modal"]').hide(), gj.datepicker.events.close(a);
  },
  createKeyDownHandler: function createKeyDownHandler(a, b, c) {
    return function (d) {
      var e,
        f,
        g,
        h,
        i,
        j,
        d = d || window.event;
      "none" !== window.getComputedStyle(b[0]).display && (j = gj.datepicker.methods.getActiveCell(b), "38" == d.keyCode ? (h = j.index(), i = j.closest("tr").prev("tr").find("td:eq(" + h + ")"), i.is("[day]") || (gj.datepicker.methods.prev(a, c)(), i = b.find("tbody tr").last().find("td:eq(" + h + ")"), i.is(":empty") && (i = b.find("tbody tr").last().prev().find("td:eq(" + h + ")"))), i.is("[day]") && (i.addClass("focused"), j.removeClass("focused"))) : "40" == d.keyCode ? (h = j.index(), i = j.closest("tr").next("tr").find("td:eq(" + h + ")"), i.is("[day]") || (gj.datepicker.methods.next(a, c)(), i = b.find("tbody tr").first().find("td:eq(" + h + ")"), i.is("[day]") || (i = b.find("tbody tr:eq(1)").find("td:eq(" + h + ")"))), i.is("[day]") && (i.addClass("focused"), j.removeClass("focused"))) : "37" == d.keyCode ? (i = j.prev("td[day]:not(.disabled)"), 0 === i.length && (i = j.closest("tr").prev("tr").find("td[day]").last()), 0 === i.length && (gj.datepicker.methods.prev(a, c)(), i = b.find("tbody tr").last().find("td[day]").last()), i.length > 0 && (i.addClass("focused"), j.removeClass("focused"))) : "39" == d.keyCode ? (i = j.next("[day]:not(.disabled)"), 0 === i.length && (i = j.closest("tr").next("tr").find("td[day]").first()), 0 === i.length && (gj.datepicker.methods.next(a, c)(), i = b.find("tbody tr").first().find("td[day]").first()), i.length > 0 && (i.addClass("focused"), j.removeClass("focused"))) : "13" == d.keyCode ? (g = parseInt(j.attr("day"), 10), e = parseInt(j.attr("month"), 10), f = parseInt(j.attr("year"), 10), gj.datepicker.methods.dayClickHandler(a, b, c, new Date(f, e, g))()) : "27" == d.keyCode && a.close());
    };
  },
  getActiveCell: function getActiveCell(a) {
    var b = a.find("td[day].focused");
    return 0 === b.length && (b = a.find("td[day].selected"), 0 === b.length && (b = a.find("td[day].today"), 0 === b.length && (b = a.find("td[day]:not(.disabled)").first()))), b;
  },
  value: function value(a, b) {
    var c,
      d,
      e = a.data();
    return void 0 === b ? a.val() : (d = gj.core.parseDate(b, e.format, e.locale), d && d.getTime() ? (c = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]'), gj.datepicker.methods.dayClickHandler(a, c, e, d)()) : a.val(""), a);
  },
  destroy: function destroy(a) {
    var b = a.data(),
      c = a.parent(),
      d = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]');
    return b && (a.off(), d.parent('[role="modal"]').length > 0 && d.unwrap(), d.remove(), a.removeData(), a.removeAttr("data-type").removeAttr("data-guid").removeAttr("data-datepicker"), a.removeClass(), c.children('[role="right-icon"]').remove(), a.unwrap()), a;
  }
}, gj.datepicker.events = {
  change: function change(a) {
    return a.triggerHandler("change");
  },
  select: function select(a, b) {
    return a.triggerHandler("select", [b]);
  },
  open: function open(a) {
    return a.triggerHandler("open");
  },
  close: function close(a) {
    return a.triggerHandler("close");
  }
}, gj.datepicker.widget = function (a, b) {
  var c = this,
    d = gj.datepicker.methods;
  return c.value = function (a) {
    return d.value(this, a);
  }, c.destroy = function () {
    return d.destroy(this);
  }, c.open = function () {
    return d.open(this, this.data());
  }, c.close = function () {
    return d.close(this);
  }, $.extend(a, c), "true" !== a.attr("data-datepicker") && d.init.call(a, b), a;
}, gj.datepicker.widget.prototype = new gj.widget(), gj.datepicker.widget.constructor = gj.datepicker.widget, function (a) {
  a.fn.datepicker = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.datepicker.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.datepicker.widget(this, a);
    }
  };
}(jQuery), gj.timepicker = {
  plugins: {}
}, gj.timepicker.config = {
  base: {
    width: void 0,
    modal: !0,
    header: !0,
    footer: !0,
    format: "HH:MM",
    uiLibrary: "materialdesign",
    value: void 0,
    mode: "ampm",
    locale: "en-us",
    size: "default",
    icons: {
      rightIcon: '<i class="gj-icon clock" />'
    },
    style: {
      modal: "gj-modal",
      wrapper: "gj-timepicker gj-timepicker-md gj-unselectable",
      input: "gj-textbox-md",
      clock: "gj-picker gj-picker-md timepicker",
      footer: "",
      button: "gj-button-md"
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-timepicker gj-timepicker-bootstrap gj-unselectable input-group",
      input: "form-control",
      clock: "gj-picker gj-picker-bootstrap timepicker",
      footer: "modal-footer",
      button: "btn btn-default"
    },
    iconsLibrary: "glyphicons"
  },
  bootstrap4: {
    style: {
      wrapper: "gj-timepicker gj-timepicker-bootstrap gj-unselectable input-group",
      input: "form-control border",
      clock: "gj-picker gj-picker-bootstrap timepicker",
      footer: "modal-footer",
      button: "btn btn-default"
    }
  }
}, gj.timepicker.methods = {
  init: function init(a) {
    return gj.picker.widget.prototype.init.call(this, a, "timepicker"), this;
  },
  initialize: function initialize() {},
  initMouse: function initMouse(a, b, c, d) {
    a.off(), a.on("mousedown", gj.timepicker.methods.mouseDownHandler(b, c)), a.on("mousemove", gj.timepicker.methods.mouseMoveHandler(b, c, d)), a.on("mouseup", gj.timepicker.methods.mouseUpHandler(b, c, d));
  },
  createPicker: function createPicker(a) {
    var b,
      c = a.data(),
      d = $('<div role="picker" />').addClass(c.style.clock).attr("guid", a.attr("data-guid")),
      e = $('<div role="hour" />'),
      f = $('<div role="minute" />'),
      g = $('<div role="header" />'),
      h = $('<div role="mode" />'),
      i = $('<div role="body" />'),
      j = $('<button class="' + c.style.button + '">' + gj.core.messages[c.locale].ok + "</button>"),
      k = $('<button class="' + c.style.button + '">' + gj.core.messages[c.locale].cancel + "</button>"),
      l = $('<div role="footer" class="' + c.style.footer + '" />');
    return b = gj.core.parseDate(c.value, c.format, c.locale), !b || isNaN(b.getTime()) ? b = new Date() : a.attr("hours", b.getHours()), gj.timepicker.methods.initMouse(i, a, d, c), c.header && (e.on("click", function () {
      gj.timepicker.methods.renderHours(a, d, c);
    }), f.on("click", function () {
      gj.timepicker.methods.renderMinutes(a, d, c);
    }), g.append(e).append(":").append(f), "ampm" === c.mode && (h.append($('<span role="am">' + gj.core.messages[c.locale].am + "</span>").on("click", function () {
      var b = gj.timepicker.methods.getHour(d);
      d.attr("mode", "am"), $(this).addClass("selected"), $(this).parent().children('[role="pm"]').removeClass("selected"), b >= 12 && d.attr("hour", b - 12), c.modal || (clearTimeout(a.timeout), a.focus());
    })), h.append("<br />"), h.append($('<span role="pm">' + gj.core.messages[c.locale].pm + "</span>").on("click", function () {
      var b = gj.timepicker.methods.getHour(d);
      d.attr("mode", "pm"), $(this).addClass("selected"), $(this).parent().children('[role="am"]').removeClass("selected"), b < 12 && d.attr("hour", b + 12), c.modal || (clearTimeout(a.timeout), a.focus());
    })), g.append(h)), d.append(g)), d.append(i), c.footer && (k.on("click", function () {
      a.close();
    }), l.append(k), j.on("click", gj.timepicker.methods.setTime(a, d)), l.append(j), d.append(l)), d.hide(), $("body").append(d), c.modal && (d.wrapAll('<div role="modal" class="' + c.style.modal + '"/>'), gj.core.center(d)), d;
  },
  getHour: function getHour(a) {
    return parseInt(a.attr("hour"), 10) || 0;
  },
  getMinute: function getMinute(a) {
    return parseInt(a.attr("minute"), 10) || 0;
  },
  setTime: function setTime(a, b) {
    return function () {
      var c = gj.timepicker.methods.getHour(b),
        d = gj.timepicker.methods.getMinute(b),
        e = b.attr("mode"),
        f = new Date(0, 0, 0, 12 === c && "am" === e ? 0 : c, d),
        g = a.data(),
        h = gj.core.formatDate(f, g.format, g.locale);
      a.value(h), a.close();
    };
  },
  getPointerValue: function getPointerValue(a, b, c) {
    var d,
      e,
      f = 256,
      g = Math.atan2(f / 2 - a, f / 2 - b) / Math.PI * 180;
    switch (g < 0 && (g = 360 + g), c) {
      case "ampm":
        return d = 12 - Math.round(12 * g / 360), 0 === d ? 12 : d;
      case "24hr":
        return e = Math.sqrt(Math.pow(f / 2 - a, 2) + Math.pow(f / 2 - b, 2)), d = 12 - Math.round(12 * g / 360), 0 === d && (d = 12), e < f / 2 - 32 && (d = 12 === d ? 0 : d + 12), d;
      case "minutes":
        return d = Math.round(60 - 60 * g / 360), 60 === d ? 0 : d;
    }
  },
  updateArrow: function updateArrow(a, b, c, d) {
    var e,
      f,
      g = b.mouseX(a),
      h = b.mouseY(a),
      i = window.scrollY || window.pageYOffset || 0,
      j = window.scrollX || window.pageXOffset || 0;
    e = a.target.getBoundingClientRect(), "hours" == d.dialMode ? (f = gj.timepicker.methods.getPointerValue(g - j - e.left, h - i - e.top, d.mode), c.attr("hour", "ampm" === d.mode && "pm" === c.attr("mode") && f < 12 ? f + 12 : f)) : "minutes" == d.dialMode && (f = gj.timepicker.methods.getPointerValue(g - j - e.left, h - i - e.top, "minutes"), c.attr("minute", f)), gj.timepicker.methods.update(b, c, d);
  },
  update: function update(a, b, c) {
    var d, e, f, g, h, i;
    d = gj.timepicker.methods.getHour(b), e = gj.timepicker.methods.getMinute(b), f = b.find('[role="arrow"]'), "hours" == c.dialMode && (0 == d || d > 12) && "24hr" === c.mode ? f.css("width", "calc(50% - 52px)") : f.css("width", "calc(50% - 20px)"), "hours" == c.dialMode ? f.css("transform", "rotate(" + (30 * d - 90).toString() + "deg)") : f.css("transform", "rotate(" + (6 * e - 90).toString() + "deg)"), f.show(), g = "ampm" === c.mode && d > 12 ? d - 12 : 0 == d ? 12 : d, i = b.find('[role="body"] span'), i.removeClass("selected"), i.filter(function (a) {
      return "hours" == c.dialMode ? parseInt($(this).text(), 10) == g : parseInt($(this).text(), 10) == e;
    }).addClass("selected"), c.header && (h = b.find('[role="header"]'), h.find('[role="hour"]').text(g), h.find('[role="minute"]').text(gj.core.pad(e)), "ampm" === c.mode && (d >= 12 ? (h.find('[role="pm"]').addClass("selected"), h.find('[role="am"]').removeClass("selected")) : (h.find('[role="am"]').addClass("selected"), h.find('[role="pm"]').removeClass("selected"))));
  },
  mouseDownHandler: function mouseDownHandler(a, b) {
    return function (b) {
      a.mouseMove = !0;
    };
  },
  mouseMoveHandler: function mouseMoveHandler(a, b, c) {
    return function (d) {
      a.mouseMove && gj.timepicker.methods.updateArrow(d, a, b, c);
    };
  },
  mouseUpHandler: function mouseUpHandler(a, b, c) {
    return function (d) {
      gj.timepicker.methods.updateArrow(d, a, b, c), a.mouseMove = !1, c.modal || (clearTimeout(a.timeout), a.focus()), "hours" == c.dialMode ? setTimeout(function () {
        gj.timepicker.events.select(a, "hour"), gj.timepicker.methods.renderMinutes(a, b, c);
      }, 1e3) : "minutes" == c.dialMode && (!0 !== c.footer && !1 !== c.autoClose && gj.timepicker.methods.setTime(a, b)(), gj.timepicker.events.select(a, "minute"));
    };
  },
  renderHours: function renderHours(a, b, c) {
    var d,
      e = b.find('[role="body"]');
    clearTimeout(a.timeout), e.empty(), d = $('<div role="dial"></div>'), d.append('<div role="arrow" style="transform: rotate(-90deg); display: none;"><div class="arrow-begin"></div><div class="arrow-end"></div></div>'), d.append('<span role="hour" style="transform: translate(54px, -93.5307px);">1</span>'), d.append('<span role="hour" style="transform: translate(93.5307px, -54px);">2</span>'), d.append('<span role="hour" style="transform: translate(108px, 0px);">3</span>'), d.append('<span role="hour" style="transform: translate(93.5307px, 54px);">4</span>'), d.append('<span role="hour" style="transform: translate(54px, 93.5307px);">5</span>'), d.append('<span role="hour" style="transform: translate(6.61309e-15px, 108px);">6</span>'), d.append('<span role="hour" style="transform: translate(-54px, 93.5307px);">7</span>'), d.append('<span role="hour" style="transform: translate(-93.5307px, 54px);">8</span>'), d.append('<span role="hour" style="transform: translate(-108px, 1.32262e-14px);">9</span>'), d.append('<span role="hour" style="transform: translate(-93.5307px, -54px);">10</span>'), d.append('<span role="hour" style="transform: translate(-54px, -93.5307px);">11</span>'), d.append('<span role="hour" style="transform: translate(-1.98393e-14px, -108px);">12</span>'), "24hr" === c.mode && (d.append('<span role="hour" style="transform: translate(38px, -65.8179px);">13</span>'), d.append('<span role="hour" style="transform: translate(65.8179px, -38px);">14</span>'), d.append('<span role="hour" style="transform: translate(76px, 0px);">15</span>'), d.append('<span role="hour" style="transform: translate(65.8179px, 38px);">16</span>'), d.append('<span role="hour" style="transform: translate(38px, 65.8179px);">17</span>'), d.append('<span role="hour" style="transform: translate(4.65366e-15px, 76px);">18</span>'), d.append('<span role="hour" style="transform: translate(-38px, 65.8179px);">19</span>'), d.append('<span role="hour" style="transform: translate(-65.8179px, 38px);">20</span>'), d.append('<span role="hour" style="transform: translate(-76px, 9.30732e-15px);">21</span>'), d.append('<span role="hour" style="transform: translate(-65.8179px, -38px);">22</span>'), d.append('<span role="hour" style="transform: translate(-38px, -65.8179px);">23</span>'), d.append('<span role="hour" style="transform: translate(-1.3961e-14px, -76px);">00</span>')), e.append(d), b.find('[role="header"] [role="hour"]').addClass("selected"), b.find('[role="header"] [role="minute"]').removeClass("selected"), c.dialMode = "hours", gj.timepicker.methods.update(a, b, c);
  },
  renderMinutes: function renderMinutes(a, b, c) {
    var d = b.find('[role="body"]');
    clearTimeout(a.timeout), d.empty(), $dial = $('<div role="dial"></div>'), $dial.append('<div role="arrow" style="transform: rotate(-90deg); display: none;"><div class="arrow-begin"></div><div class="arrow-end"></div></div>'), $dial.append('<span role="hour" style="transform: translate(54px, -93.5307px);">5</span>'), $dial.append('<span role="hour" style="transform: translate(93.5307px, -54px);">10</span>'), $dial.append('<span role="hour" style="transform: translate(108px, 0px);">15</span>'), $dial.append('<span role="hour" style="transform: translate(93.5307px, 54px);">20</span>'), $dial.append('<span role="hour" style="transform: translate(54px, 93.5307px);">25</span>'), $dial.append('<span role="hour" style="transform: translate(6.61309e-15px, 108px);">30</span>'), $dial.append('<span role="hour" style="transform: translate(-54px, 93.5307px);">35</span>'), $dial.append('<span role="hour" style="transform: translate(-93.5307px, 54px);">40</span>'), $dial.append('<span role="hour" style="transform: translate(-108px, 1.32262e-14px);">45</span>'), $dial.append('<span role="hour" style="transform: translate(-93.5307px, -54px);">50</span>'), $dial.append('<span role="hour" style="transform: translate(-54px, -93.5307px);">55</span>'), $dial.append('<span role="hour" style="transform: translate(-1.98393e-14px, -108px);">00</span>'), d.append($dial), b.find('[role="header"] [role="hour"]').removeClass("selected"), b.find('[role="header"] [role="minute"]').addClass("selected"), c.dialMode = "minutes", gj.timepicker.methods.update(a, b, c);
  },
  open: function open(a) {
    var b,
      c,
      d = a.data(),
      e = $("body").find('[role="picker"][guid="' + a.attr("data-guid") + '"]');
    return b = a.value() ? gj.core.parseDate(a.value(), d.format, d.locale) : new Date(), c = b.getHours(), "ampm" === d.mode && e.attr("mode", c > 12 ? "pm" : "am"), e.attr("hour", c), e.attr("minute", b.getMinutes()), gj.timepicker.methods.renderHours(a, e, d), gj.picker.widget.prototype.open.call(a, "timepicker"), a;
  },
  value: function value(a, b) {
    a.data();
    return void 0 === b ? a.val() : (a.val(b), gj.timepicker.events.change(a), a);
  }
}, gj.timepicker.events = {
  change: function change(a) {
    return a.triggerHandler("change");
  },
  select: function select(a, b) {
    return a.triggerHandler("select", [b]);
  },
  open: function open(a) {
    return a.triggerHandler("open");
  },
  close: function close(a) {
    return a.triggerHandler("close");
  }
}, gj.timepicker.widget = function (a, b) {
  var c = this,
    d = gj.timepicker.methods;
  return c.mouseMove = !1, c.value = function (a) {
    return d.value(this, a);
  }, c.destroy = function () {
    return gj.picker.widget.prototype.destroy.call(this, "timepicker");
  }, c.open = function () {
    return gj.timepicker.methods.open(this);
  }, c.close = function () {
    return gj.picker.widget.prototype.close.call(this, "timepicker");
  }, $.extend(a, c), "true" !== a.attr("data-timepicker") && d.init.call(a, b), a;
}, gj.timepicker.widget.prototype = new gj.picker.widget(), gj.timepicker.widget.constructor = gj.timepicker.widget, function (a) {
  a.fn.timepicker = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.timepicker.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.timepicker.widget(this, a);
    }
  };
}(jQuery), gj.datetimepicker = {
  plugins: {},
  messages: {
    "en-us": {}
  }
}, gj.datetimepicker.config = {
  base: {
    datepicker: gj.datepicker.config.base,
    timepicker: gj.timepicker.config.base,
    uiLibrary: "materialdesign",
    value: void 0,
    format: "HH:MM mm/dd/yyyy",
    width: void 0,
    modal: !1,
    footer: !1,
    size: "default",
    locale: "en-us",
    icons: {},
    style: {
      calendar: "gj-picker gj-picker-md datetimepicker gj-unselectable"
    }
  },
  bootstrap: {
    style: {
      calendar: "gj-picker gj-picker-bootstrap datetimepicker gj-unselectable"
    },
    iconsLibrary: "glyphicons"
  },
  bootstrap4: {
    style: {
      calendar: "gj-picker gj-picker-bootstrap datetimepicker gj-unselectable"
    }
  }
}, gj.datetimepicker.methods = {
  init: function init(a) {
    return gj.widget.prototype.init.call(this, a, "datetimepicker"), this.attr("data-datetimepicker", "true"), gj.datetimepicker.methods.initialize(this), this;
  },
  getConfig: function getConfig(a, b) {
    var c = gj.widget.prototype.getConfig.call(this, a, b);
    return uiLibrary = a.hasOwnProperty("uiLibrary") ? a.uiLibrary : c.uiLibrary, gj.datepicker.config[uiLibrary] && $.extend(!0, c.datepicker, gj.datepicker.config[uiLibrary]), gj.timepicker.config[uiLibrary] && $.extend(!0, c.timepicker, gj.timepicker.config[uiLibrary]), iconsLibrary = a.hasOwnProperty("iconsLibrary") ? a.iconsLibrary : c.iconsLibrary, gj.datepicker.config[iconsLibrary] && $.extend(!0, c.datepicker, gj.datepicker.config[iconsLibrary]), gj.timepicker.config[iconsLibrary] && $.extend(!0, c.timepicker, gj.timepicker.config[iconsLibrary]), c;
  },
  initialize: function initialize(a) {
    var b,
      c,
      d,
      e,
      f,
      g,
      h,
      i,
      j = a.data();
    j.datepicker.uiLibrary = j.uiLibrary, j.datepicker.iconsLibrary = j.iconsLibrary, j.datepicker.width = j.width, j.datepicker.format = j.format, j.datepicker.locale = j.locale, j.datepicker.modal = j.modal, j.datepicker.footer = j.footer, j.datepicker.style.calendar = j.style.calendar, j.datepicker.value = j.value, j.datepicker.size = j.size, j.datepicker.autoClose = !1, gj.datepicker.methods.initialize(a, j.datepicker), a.on("select", function (c, d) {
      var e, f;
      "day" === d ? gj.datetimepicker.methods.createShowHourHandler(a, b, j)() : "minute" === d && b.attr("selectedDay") && !0 !== j.footer && (selectedDay = b.attr("selectedDay").split("-"), e = new Date(selectedDay[0], selectedDay[1], selectedDay[2], b.attr("hour") || 0, b.attr("minute") || 0), f = gj.core.formatDate(e, j.format, j.locale), a.val(f), gj.datetimepicker.events.change(a), gj.datetimepicker.methods.close(a));
    }), a.on("open", function () {
      var a = b.children('[role="header"]');
      a.find('[role="calendarMode"]').addClass("selected"), a.find('[role="clockMode"]').removeClass("selected");
    }), b = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]'), f = j.value ? gj.core.parseDate(j.value, j.format, j.locale) : new Date(), b.attr("hour", f.getHours()), b.attr("minute", f.getMinutes()), j.timepicker.uiLibrary = j.uiLibrary, j.timepicker.iconsLibrary = j.iconsLibrary, j.timepicker.format = j.format, j.timepicker.locale = j.locale, j.timepicker.header = !0, j.timepicker.footer = j.footer, j.timepicker.size = j.size, j.timepicker.mode = "24hr", j.timepicker.autoClose = !1, c = $('<div role="header" />'), d = $('<div role="date" class="selected" />'), d.on("click", gj.datetimepicker.methods.createShowDateHandler(a, b, j)), d.html(gj.core.formatDate(new Date(), "ddd, mmm dd", j.locale)), c.append(d), g = $('<div role="switch"></div>'), h = $('<i class="gj-icon selected" role="calendarMode">event</i>'), h.on("click", gj.datetimepicker.methods.createShowDateHandler(a, b, j)), g.append(h), e = $('<div role="time" />'), e.append($('<div role="hour" />').on("click", gj.datetimepicker.methods.createShowHourHandler(a, b, j)).html(gj.core.formatDate(new Date(), "HH", j.locale))), e.append(":"), e.append($('<div role="minute" />').on("click", gj.datetimepicker.methods.createShowMinuteHandler(a, b, j)).html(gj.core.formatDate(new Date(), "MM", j.locale))), g.append(e), i = $('<i class="gj-icon" role="clockMode">clock</i>'), i.on("click", gj.datetimepicker.methods.createShowHourHandler(a, b, j)), g.append(i), c.append(g), b.prepend(c);
  },
  createShowDateHandler: function createShowDateHandler(a, b, c) {
    return function (d) {
      var e = b.children('[role="header"]');
      e.find('[role="calendarMode"]').addClass("selected"), e.find('[role="date"]').addClass("selected"), e.find('[role="clockMode"]').removeClass("selected"), e.find('[role="hour"]').removeClass("selected"), e.find('[role="minute"]').removeClass("selected"), gj.datepicker.methods.renderMonth(a, b, c.datepicker);
    };
  },
  createShowHourHandler: function createShowHourHandler(a, b, c) {
    return function () {
      var d = b.children('[role="header"]');
      d.find('[role="calendarMode"]').removeClass("selected"), d.find('[role="date"]').removeClass("selected"), d.find('[role="clockMode"]').addClass("selected"), d.find('[role="hour"]').addClass("selected"), d.find('[role="minute"]').removeClass("selected"), gj.timepicker.methods.initMouse(b.children('[role="body"]'), a, b, c.timepicker), gj.timepicker.methods.renderHours(a, b, c.timepicker);
    };
  },
  createShowMinuteHandler: function createShowMinuteHandler(a, b, c) {
    return function () {
      var d = b.children('[role="header"]');
      d.find('[role="calendarMode"]').removeClass("selected"), d.find('[role="date"]').removeClass("selected"), d.find('[role="clockMode"]').addClass("selected"), d.find('[role="hour"]').removeClass("selected"), d.find('[role="minute"]').addClass("selected"), gj.timepicker.methods.initMouse(b.children('[role="body"]'), a, b, c.timepicker), gj.timepicker.methods.renderMinutes(a, b, c.timepicker);
    };
  },
  close: function close(a) {
    var b = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]');
    b.hide(), b.closest('div[role="modal"]').hide();
  },
  value: function value(a, b) {
    var c,
      d,
      e,
      f = a.data();
    return void 0 === b ? a.val() : (d = gj.core.parseDate(b, f.format, f.locale), d ? (c = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]'), gj.datepicker.methods.dayClickHandler(a, c, f, d)(), e = d.getHours(), "ampm" === f.mode && c.attr("mode", e > 12 ? "pm" : "am"), c.attr("hour", e), c.attr("minute", d.getMinutes()), a.val(b)) : a.val(""), a);
  },
  destroy: function destroy(a) {
    var b = a.data(),
      c = a.parent(),
      d = $("body").find('[role="calendar"][guid="' + a.attr("data-guid") + '"]');
    return b && (a.off(), d.parent('[role="modal"]').length > 0 && d.unwrap(), d.remove(), a.removeData(), a.removeAttr("data-type").removeAttr("data-guid").removeAttr("data-datetimepicker"), a.removeClass(), c.children('[role="right-icon"]').remove(), a.unwrap()), a;
  }
}, gj.datetimepicker.events = {
  change: function change(a) {
    return a.triggerHandler("change");
  }
}, gj.datetimepicker.widget = function (a, b) {
  var c = this,
    d = gj.datetimepicker.methods;
  return c.mouseMove = !1, c.value = function (a) {
    return d.value(this, a);
  }, c.open = function () {
    gj.datepicker.methods.open(this, this.data().datepicker);
  }, c.close = function () {
    gj.datepicker.methods.close(this);
  }, c.destroy = function () {
    return d.destroy(this);
  }, $.extend(a, c), "true" !== a.attr("data-datetimepicker") && d.init.call(a, b), a;
}, gj.datetimepicker.widget.prototype = new gj.widget(), gj.datetimepicker.widget.constructor = gj.datetimepicker.widget, gj.datetimepicker.widget.prototype.getConfig = gj.datetimepicker.methods.getConfig, function (a) {
  a.fn.datetimepicker = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.datetimepicker.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.datetimepicker.widget(this, a);
    }
  };
}(jQuery), gj.slider = {
  plugins: {},
  messages: {
    "en-us": {}
  }
}, gj.slider.config = {
  base: {
    min: 0,
    max: 100,
    width: void 0,
    uiLibrary: "materialdesign",
    value: void 0,
    icons: {},
    style: {
      wrapper: "gj-slider gj-slider-md",
      progress: void 0,
      track: void 0
    }
  },
  bootstrap: {
    style: {
      wrapper: "gj-slider gj-slider-bootstrap gj-slider-bootstrap-3",
      progress: "progress-bar",
      track: "progress"
    }
  },
  bootstrap4: {
    style: {
      wrapper: "gj-slider gj-slider-bootstrap gj-slider-bootstrap-4",
      progress: "progress-bar",
      track: "progress"
    }
  }
}, gj.slider.methods = {
  init: function init(a) {
    return gj.widget.prototype.init.call(this, a, "slider"), this.attr("data-slider", "true"), gj.slider.methods.initialize(this, this.data()), this;
  },
  initialize: function initialize(a, b) {
    var c, d, e, f;
    a[0].style.display = "none", "wrapper" !== a[0].parentElement.attributes.role ? (c = document.createElement("div"), c.setAttribute("role", "wrapper"), a[0].parentNode.insertBefore(c, a[0]), c.appendChild(a[0])) : c = a[0].parentElement, b.width && (c.style.width = b.width + "px"), gj.core.addClasses(c, b.style.wrapper), d = a[0].querySelector('[role="track"]'), null == d && (d = document.createElement("div"), d.setAttribute("role", "track"), c.appendChild(d)), gj.core.addClasses(d, b.style.track), e = a[0].querySelector('[role="handle"]'), null == e && (e = document.createElement("div"), e.setAttribute("role", "handle"), c.appendChild(e)), f = a[0].querySelector('[role="progress"]'), null == f && (f = document.createElement("div"), f.setAttribute("role", "progress"), c.appendChild(f)), gj.core.addClasses(f, b.style.progress), b.value || (b.value = b.min), gj.slider.methods.value(a, b, b.value), gj.documentManager.subscribeForEvent("mouseup", a.data("guid"), gj.slider.methods.createMouseUpHandler(a, e, b)), e.addEventListener("mousedown", gj.slider.methods.createMouseDownHandler(e, b)), gj.documentManager.subscribeForEvent("mousemove", a.data("guid"), gj.slider.methods.createMouseMoveHandler(a, d, e, f, b)), e.addEventListener("click", function (a) {
      a.stopPropagation();
    }), c.addEventListener("click", gj.slider.methods.createClickHandler(a, d, e, b));
  },
  createClickHandler: function createClickHandler(a, b, c, d) {
    return function (e) {
      var f, g, h, i, j;
      "true" !== c.getAttribute("drag") && (f = gj.core.position(a[0].parentElement), g = new gj.widget().mouseX(e) - f.left, h = gj.core.width(c) / 2, i = gj.core.width(b) / (d.max - d.min), j = Math.round((g - h) / i) + d.min, gj.slider.methods.value(a, d, j));
    };
  },
  createMouseUpHandler: function createMouseUpHandler(a, b, c) {
    return function (c) {
      "true" === b.getAttribute("drag") && (b.setAttribute("drag", "false"), gj.slider.events.change(a));
    };
  },
  createMouseDownHandler: function createMouseDownHandler(a, b) {
    return function (b) {
      a.setAttribute("drag", "true");
    };
  },
  createMouseMoveHandler: function createMouseMoveHandler(a, b, c, d, e) {
    return function (d) {
      var f, g, h, i, j, k, l;
      "true" === c.getAttribute("drag") && (f = gj.core.position(a[0].parentElement), g = new gj.widget().mouseX(d) - f.left, h = gj.core.width(b), i = gj.core.width(c) / 2, j = h / (e.max - e.min), k = (e.value - e.min) * j, g >= i && g <= h + i && (g > k + j / 2 || g < k - j / 2) && (l = Math.round((g - i) / j) + e.min, gj.slider.methods.value(a, e, l)));
    };
  },
  value: function value(a, b, c) {
    var d, e, f, g;
    return void 0 === c ? a[0].value : (a[0].setAttribute("value", c), b.value = c, e = a.parent().children('[role="track"]')[0], d = gj.core.width(e) / (b.max - b.min), f = a.parent().children('[role="handle"]')[0], f.style.left = (c - b.min) * d + "px", g = a.parent().children('[role="progress"]')[0], g.style.width = (c - b.min) * d + "px", gj.slider.events.slide(a, c), a);
  },
  destroy: function destroy(a) {
    var b = a.data(),
      c = a.parent();
    return b && (c.children('[role="track"]').remove(), c.children('[role="handle"]').remove(), c.children('[role="progress"]').remove(), a.unwrap(), a.off(), a.removeData(), a.removeAttr("data-type").removeAttr("data-guid").removeAttr("data-slider"), a.removeClass(), a.show()), a;
  }
}, gj.slider.events = {
  change: function change(a) {
    return a.triggerHandler("change");
  },
  slide: function slide(a, b) {
    return a.triggerHandler("slide", [b]);
  }
}, gj.slider.widget = function (a, b) {
  var c = this,
    d = gj.slider.methods;
  return c.value = function (a) {
    return d.value(this, this.data(), a);
  }, c.destroy = function () {
    return d.destroy(this);
  }, $.extend(a, c), "true" !== a.attr("data-slider") && d.init.call(a, b), a;
}, gj.slider.widget.prototype = new gj.widget(), gj.slider.widget.constructor = gj.slider.widget, function (a) {
  a.fn.slider = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.slider.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.slider.widget(this, a);
    }
  };
}(jQuery), gj.colorpicker = {
  plugins: {},
  messages: {
    "en-us": {}
  }
}, gj.colorpicker.config = {
  base: {
    uiLibrary: "materialdesign",
    value: void 0,
    icons: {
      rightIcon: '<i class="gj-icon">event</i>'
    },
    style: {
      modal: "gj-modal",
      wrapper: "gj-colorpicker gj-colorpicker-md gj-unselectable",
      input: "gj-textbox-md",
      picker: "gj-picker gj-picker-md colorpicker gj-unselectable",
      footer: "",
      button: "gj-button-md"
    }
  },
  bootstrap: {
    style: {}
  },
  bootstrap4: {
    style: {}
  }
}, gj.colorpicker.methods = {
  init: function init(a) {
    return gj.picker.widget.prototype.init.call(this, a, "colorpicker"), gj.colorpicker.methods.initialize(this), this;
  },
  initialize: function initialize(a) {},
  createPicker: function createPicker(a, b) {
    var c = $('<div role="picker" />').addClass(b.style.picker).attr("guid", a.attr("data-guid"));
    return c.html("test"), c.hide(), $("body").append(c), c;
  },
  open: function open(a) {
    return a.val() && a.value(a.val()), gj.picker.widget.prototype.open.call(a, "colorpicker");
  }
}, gj.colorpicker.events = {
  change: function change(a) {
    return a.triggerHandler("change");
  },
  select: function select(a) {
    return a.triggerHandler("select");
  },
  open: function open(a) {
    return a.triggerHandler("open");
  },
  close: function close(a) {
    return a.triggerHandler("close");
  }
}, gj.colorpicker.widget = function (a, b) {
  var c = this,
    d = gj.colorpicker.methods;
  return c.value = function (a) {
    return d.value(this, a);
  }, c.destroy = function () {
    return gj.picker.widget.prototype.destroy.call(this, "colorpicker");
  }, c.open = function () {
    return d.open(this);
  }, c.close = function () {
    return gj.picker.widget.prototype.close.call(this, "colorpicker");
  }, $.extend(a, c), "true" !== a.attr("data-colorpicker") && d.init.call(a, b), a;
}, gj.colorpicker.widget.prototype = new gj.picker.widget(), gj.colorpicker.widget.constructor = gj.colorpicker.widget, function (a) {
  a.fn.colorpicker = function (a) {
    var b;
    if (this && this.length) {
      if ("object" != _typeof(a) && a) {
        if (b = new gj.colorpicker.widget(this, null), b[a]) return b[a].apply(this, Array.prototype.slice.call(arguments, 1));
        throw "Method " + a + " does not exist.";
      }
      return new gj.colorpicker.widget(this, a);
    }
  };
}(jQuery);

/***/ }),

/***/ "./public/frontend/amazy/js/imagesloaded.pkgd.min.js":
/*!***********************************************************!*\
  !*** ./public/frontend/amazy/js/imagesloaded.pkgd.min.js ***!
  \***********************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_LOCAL_MODULE_0__, __WEBPACK_LOCAL_MODULE_0__factory, __WEBPACK_LOCAL_MODULE_0__module;var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/*!
 * imagesLoaded PACKAGED v4.1.4
 * JavaScript is all like "You images are done yet or what?"
 * MIT License
 */

!function (e, t) {
   true ? !(__WEBPACK_LOCAL_MODULE_0__factory = (t), (typeof __WEBPACK_LOCAL_MODULE_0__factory === 'function' ? ((__WEBPACK_LOCAL_MODULE_0__module = { id: "ev-emitter/ev-emitter", exports: {}, loaded: false }), (__WEBPACK_LOCAL_MODULE_0__ = __WEBPACK_LOCAL_MODULE_0__factory.call(__WEBPACK_LOCAL_MODULE_0__module.exports, __webpack_require__, __WEBPACK_LOCAL_MODULE_0__module.exports, __WEBPACK_LOCAL_MODULE_0__module)), (__WEBPACK_LOCAL_MODULE_0__module.loaded = true), __WEBPACK_LOCAL_MODULE_0__ === undefined && (__WEBPACK_LOCAL_MODULE_0__ = __WEBPACK_LOCAL_MODULE_0__module.exports)) : __WEBPACK_LOCAL_MODULE_0__ = __WEBPACK_LOCAL_MODULE_0__factory)) : 0;
}("undefined" != typeof window ? window : this, function () {
  function e() {}
  var t = e.prototype;
  return t.on = function (e, t) {
    if (e && t) {
      var i = this._events = this._events || {},
        n = i[e] = i[e] || [];
      return n.indexOf(t) == -1 && n.push(t), this;
    }
  }, t.once = function (e, t) {
    if (e && t) {
      this.on(e, t);
      var i = this._onceEvents = this._onceEvents || {},
        n = i[e] = i[e] || {};
      return n[t] = !0, this;
    }
  }, t.off = function (e, t) {
    var i = this._events && this._events[e];
    if (i && i.length) {
      var n = i.indexOf(t);
      return n != -1 && i.splice(n, 1), this;
    }
  }, t.emitEvent = function (e, t) {
    var i = this._events && this._events[e];
    if (i && i.length) {
      i = i.slice(0), t = t || [];
      for (var n = this._onceEvents && this._onceEvents[e], o = 0; o < i.length; o++) {
        var r = i[o],
          s = n && n[r];
        s && (this.off(e, r), delete n[r]), r.apply(this, t);
      }
      return this;
    }
  }, t.allOff = function () {
    delete this._events, delete this._onceEvents;
  }, e;
}), function (e, t) {
  "use strict";

   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__WEBPACK_LOCAL_MODULE_0__], __WEBPACK_AMD_DEFINE_RESULT__ = (function (i) {
    return t(e, i);
  }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
}("undefined" != typeof window ? window : this, function (e, t) {
  function i(e, t) {
    for (var i in t) e[i] = t[i];
    return e;
  }
  function n(e) {
    if (Array.isArray(e)) return e;
    var t = "object" == _typeof(e) && "number" == typeof e.length;
    return t ? d.call(e) : [e];
  }
  function o(e, t, r) {
    if (!(this instanceof o)) return new o(e, t, r);
    var s = e;
    return "string" == typeof e && (s = document.querySelectorAll(e)), s ? (this.elements = n(s), this.options = i({}, this.options), "function" == typeof t ? r = t : i(this.options, t), r && this.on("always", r), this.getImages(), h && (this.jqDeferred = new h.Deferred()), void setTimeout(this.check.bind(this))) : void a.error("Bad element for imagesLoaded " + (s || e));
  }
  function r(e) {
    this.img = e;
  }
  function s(e, t) {
    this.url = e, this.element = t, this.img = new Image();
  }
  var h = e.jQuery,
    a = e.console,
    d = Array.prototype.slice;
  o.prototype = Object.create(t.prototype), o.prototype.options = {}, o.prototype.getImages = function () {
    this.images = [], this.elements.forEach(this.addElementImages, this);
  }, o.prototype.addElementImages = function (e) {
    "IMG" == e.nodeName && this.addImage(e), this.options.background === !0 && this.addElementBackgroundImages(e);
    var t = e.nodeType;
    if (t && u[t]) {
      for (var i = e.querySelectorAll("img"), n = 0; n < i.length; n++) {
        var o = i[n];
        this.addImage(o);
      }
      if ("string" == typeof this.options.background) {
        var r = e.querySelectorAll(this.options.background);
        for (n = 0; n < r.length; n++) {
          var s = r[n];
          this.addElementBackgroundImages(s);
        }
      }
    }
  };
  var u = {
    1: !0,
    9: !0,
    11: !0
  };
  return o.prototype.addElementBackgroundImages = function (e) {
    var t = getComputedStyle(e);
    if (t) for (var i = /url\((['"])?(.*?)\1\)/gi, n = i.exec(t.backgroundImage); null !== n;) {
      var o = n && n[2];
      o && this.addBackground(o, e), n = i.exec(t.backgroundImage);
    }
  }, o.prototype.addImage = function (e) {
    var t = new r(e);
    this.images.push(t);
  }, o.prototype.addBackground = function (e, t) {
    var i = new s(e, t);
    this.images.push(i);
  }, o.prototype.check = function () {
    function e(e, i, n) {
      setTimeout(function () {
        t.progress(e, i, n);
      });
    }
    var t = this;
    return this.progressedCount = 0, this.hasAnyBroken = !1, this.images.length ? void this.images.forEach(function (t) {
      t.once("progress", e), t.check();
    }) : void this.complete();
  }, o.prototype.progress = function (e, t, i) {
    this.progressedCount++, this.hasAnyBroken = this.hasAnyBroken || !e.isLoaded, this.emitEvent("progress", [this, e, t]), this.jqDeferred && this.jqDeferred.notify && this.jqDeferred.notify(this, e), this.progressedCount == this.images.length && this.complete(), this.options.debug && a && a.log("progress: " + i, e, t);
  }, o.prototype.complete = function () {
    var e = this.hasAnyBroken ? "fail" : "done";
    if (this.isComplete = !0, this.emitEvent(e, [this]), this.emitEvent("always", [this]), this.jqDeferred) {
      var t = this.hasAnyBroken ? "reject" : "resolve";
      this.jqDeferred[t](this);
    }
  }, r.prototype = Object.create(t.prototype), r.prototype.check = function () {
    var e = this.getIsImageComplete();
    return e ? void this.confirm(0 !== this.img.naturalWidth, "naturalWidth") : (this.proxyImage = new Image(), this.proxyImage.addEventListener("load", this), this.proxyImage.addEventListener("error", this), this.img.addEventListener("load", this), this.img.addEventListener("error", this), void (this.proxyImage.src = this.img.src));
  }, r.prototype.getIsImageComplete = function () {
    return this.img.complete && this.img.naturalWidth;
  }, r.prototype.confirm = function (e, t) {
    this.isLoaded = e, this.emitEvent("progress", [this, this.img, t]);
  }, r.prototype.handleEvent = function (e) {
    var t = "on" + e.type;
    this[t] && this[t](e);
  }, r.prototype.onload = function () {
    this.confirm(!0, "onload"), this.unbindEvents();
  }, r.prototype.onerror = function () {
    this.confirm(!1, "onerror"), this.unbindEvents();
  }, r.prototype.unbindEvents = function () {
    this.proxyImage.removeEventListener("load", this), this.proxyImage.removeEventListener("error", this), this.img.removeEventListener("load", this), this.img.removeEventListener("error", this);
  }, s.prototype = Object.create(r.prototype), s.prototype.check = function () {
    this.img.addEventListener("load", this), this.img.addEventListener("error", this), this.img.src = this.url;
    var e = this.getIsImageComplete();
    e && (this.confirm(0 !== this.img.naturalWidth, "naturalWidth"), this.unbindEvents());
  }, s.prototype.unbindEvents = function () {
    this.img.removeEventListener("load", this), this.img.removeEventListener("error", this);
  }, s.prototype.confirm = function (e, t) {
    this.isLoaded = e, this.emitEvent("progress", [this, this.element, t]);
  }, o.makeJQueryPlugin = function (t) {
    t = t || e.jQuery, t && (h = t, h.fn.imagesLoaded = function (e, t) {
      var i = new o(this, e, t);
      return i.jqDeferred.promise(h(this));
    });
  }, o.makeJQueryPlugin(), o;
});

/***/ }),

/***/ "./public/frontend/amazy/js/isotope.pkgd.min.js":
/*!******************************************************!*\
  !*** ./public/frontend/amazy/js/isotope.pkgd.min.js ***!
  \******************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;var __WEBPACK_LOCAL_MODULE_1__, __WEBPACK_LOCAL_MODULE_1__factory, __WEBPACK_LOCAL_MODULE_1__module;var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_LOCAL_MODULE_2__, __WEBPACK_LOCAL_MODULE_2__exports;var __WEBPACK_LOCAL_MODULE_3__, __WEBPACK_LOCAL_MODULE_3__factory, __WEBPACK_LOCAL_MODULE_3__module;var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_LOCAL_MODULE_4__, __WEBPACK_LOCAL_MODULE_4__exports;var __WEBPACK_LOCAL_MODULE_5__array, __WEBPACK_LOCAL_MODULE_5__factory, __WEBPACK_LOCAL_MODULE_5__exports, __WEBPACK_LOCAL_MODULE_5__;var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_LOCAL_MODULE_6__, __WEBPACK_LOCAL_MODULE_6__exports;var __WEBPACK_LOCAL_MODULE_7__array, __WEBPACK_LOCAL_MODULE_7__factory, __WEBPACK_LOCAL_MODULE_7__exports, __WEBPACK_LOCAL_MODULE_7__;var __WEBPACK_LOCAL_MODULE_8__array, __WEBPACK_LOCAL_MODULE_8__factory, __WEBPACK_LOCAL_MODULE_8__exports, __WEBPACK_LOCAL_MODULE_8__;var __WEBPACK_LOCAL_MODULE_9__array, __WEBPACK_LOCAL_MODULE_9__factory, __WEBPACK_LOCAL_MODULE_9__exports, __WEBPACK_LOCAL_MODULE_9__;var __WEBPACK_LOCAL_MODULE_10__array, __WEBPACK_LOCAL_MODULE_10__factory, __WEBPACK_LOCAL_MODULE_10__exports, __WEBPACK_LOCAL_MODULE_10__;var __WEBPACK_LOCAL_MODULE_11__array, __WEBPACK_LOCAL_MODULE_11__factory, __WEBPACK_LOCAL_MODULE_11__exports, __WEBPACK_LOCAL_MODULE_11__;var __WEBPACK_LOCAL_MODULE_12__array, __WEBPACK_LOCAL_MODULE_12__factory, __WEBPACK_LOCAL_MODULE_12__exports, __WEBPACK_LOCAL_MODULE_12__;var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/*!
 * Isotope PACKAGED v3.0.5
 *
 * Licensed GPLv3 for open source use
 * or Isotope Commercial License for commercial use
 *
 * https://isotope.metafizzy.co
 * Copyright 2017 Metafizzy
 */

!function (t, e) {
   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")], __WEBPACK_AMD_DEFINE_RESULT__ = (function (i) {
    return e(t, i);
  }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
}(window, function (t, e) {
  "use strict";

  function i(i, s, a) {
    function u(t, e, o) {
      var n,
        s = "$()." + i + '("' + e + '")';
      return t.each(function (t, u) {
        var h = a.data(u, i);
        if (!h) return void r(i + " not initialized. Cannot call methods, i.e. " + s);
        var d = h[e];
        if (!d || "_" == e.charAt(0)) return void r(s + " is not a valid method");
        var l = d.apply(h, o);
        n = void 0 === n ? l : n;
      }), void 0 !== n ? n : t;
    }
    function h(t, e) {
      t.each(function (t, o) {
        var n = a.data(o, i);
        n ? (n.option(e), n._init()) : (n = new s(o, e), a.data(o, i, n));
      });
    }
    a = a || e || t.jQuery, a && (s.prototype.option || (s.prototype.option = function (t) {
      a.isPlainObject(t) && (this.options = a.extend(!0, this.options, t));
    }), a.fn[i] = function (t) {
      if ("string" == typeof t) {
        var e = n.call(arguments, 1);
        return u(this, t, e);
      }
      return h(this, t), this;
    }, o(a));
  }
  function o(t) {
    !t || t && t.bridget || (t.bridget = i);
  }
  var n = Array.prototype.slice,
    s = t.console,
    r = "undefined" == typeof s ? function () {} : function (t) {
      s.error(t);
    };
  return o(e || t.jQuery), i;
}), function (t, e) {
   true ? !(__WEBPACK_LOCAL_MODULE_1__factory = (e), (typeof __WEBPACK_LOCAL_MODULE_1__factory === 'function' ? ((__WEBPACK_LOCAL_MODULE_1__module = { id: "ev-emitter/ev-emitter", exports: {}, loaded: false }), (__WEBPACK_LOCAL_MODULE_1__ = __WEBPACK_LOCAL_MODULE_1__factory.call(__WEBPACK_LOCAL_MODULE_1__module.exports, __webpack_require__, __WEBPACK_LOCAL_MODULE_1__module.exports, __WEBPACK_LOCAL_MODULE_1__module)), (__WEBPACK_LOCAL_MODULE_1__module.loaded = true), __WEBPACK_LOCAL_MODULE_1__ === undefined && (__WEBPACK_LOCAL_MODULE_1__ = __WEBPACK_LOCAL_MODULE_1__module.exports)) : __WEBPACK_LOCAL_MODULE_1__ = __WEBPACK_LOCAL_MODULE_1__factory)) : 0;
}("undefined" != typeof window ? window : this, function () {
  function t() {}
  var e = t.prototype;
  return e.on = function (t, e) {
    if (t && e) {
      var i = this._events = this._events || {},
        o = i[t] = i[t] || [];
      return o.indexOf(e) == -1 && o.push(e), this;
    }
  }, e.once = function (t, e) {
    if (t && e) {
      this.on(t, e);
      var i = this._onceEvents = this._onceEvents || {},
        o = i[t] = i[t] || {};
      return o[e] = !0, this;
    }
  }, e.off = function (t, e) {
    var i = this._events && this._events[t];
    if (i && i.length) {
      var o = i.indexOf(e);
      return o != -1 && i.splice(o, 1), this;
    }
  }, e.emitEvent = function (t, e) {
    var i = this._events && this._events[t];
    if (i && i.length) {
      i = i.slice(0), e = e || [];
      for (var o = this._onceEvents && this._onceEvents[t], n = 0; n < i.length; n++) {
        var s = i[n],
          r = o && o[s];
        r && (this.off(t, s), delete o[s]), s.apply(this, e);
      }
      return this;
    }
  }, e.allOff = function () {
    delete this._events, delete this._onceEvents;
  }, t;
}), function (t, e) {
  "use strict";

   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_LOCAL_MODULE_2__ = (function () {
    return e();
  }).apply(__WEBPACK_LOCAL_MODULE_2__exports = {}, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_LOCAL_MODULE_2__ === undefined && (__WEBPACK_LOCAL_MODULE_2__ = __WEBPACK_LOCAL_MODULE_2__exports)) : 0;
}(window, function () {
  "use strict";

  function t(t) {
    var e = parseFloat(t),
      i = t.indexOf("%") == -1 && !isNaN(e);
    return i && e;
  }
  function e() {}
  function i() {
    for (var t = {
        width: 0,
        height: 0,
        innerWidth: 0,
        innerHeight: 0,
        outerWidth: 0,
        outerHeight: 0
      }, e = 0; e < h; e++) {
      var i = u[e];
      t[i] = 0;
    }
    return t;
  }
  function o(t) {
    var e = getComputedStyle(t);
    return e || a("Style returned " + e + ". Are you running this code in a hidden iframe on Firefox? See http://bit.ly/getsizebug1"), e;
  }
  function n() {
    if (!d) {
      d = !0;
      var e = document.createElement("div");
      e.style.width = "200px", e.style.padding = "1px 2px 3px 4px", e.style.borderStyle = "solid", e.style.borderWidth = "1px 2px 3px 4px", e.style.boxSizing = "border-box";
      var i = document.body || document.documentElement;
      i.appendChild(e);
      var n = o(e);
      s.isBoxSizeOuter = r = 200 == t(n.width), i.removeChild(e);
    }
  }
  function s(e) {
    if (n(), "string" == typeof e && (e = document.querySelector(e)), e && "object" == _typeof(e) && e.nodeType) {
      var s = o(e);
      if ("none" == s.display) return i();
      var a = {};
      a.width = e.offsetWidth, a.height = e.offsetHeight;
      for (var d = a.isBorderBox = "border-box" == s.boxSizing, l = 0; l < h; l++) {
        var f = u[l],
          c = s[f],
          m = parseFloat(c);
        a[f] = isNaN(m) ? 0 : m;
      }
      var p = a.paddingLeft + a.paddingRight,
        y = a.paddingTop + a.paddingBottom,
        g = a.marginLeft + a.marginRight,
        v = a.marginTop + a.marginBottom,
        _ = a.borderLeftWidth + a.borderRightWidth,
        I = a.borderTopWidth + a.borderBottomWidth,
        z = d && r,
        x = t(s.width);
      x !== !1 && (a.width = x + (z ? 0 : p + _));
      var S = t(s.height);
      return S !== !1 && (a.height = S + (z ? 0 : y + I)), a.innerWidth = a.width - (p + _), a.innerHeight = a.height - (y + I), a.outerWidth = a.width + g, a.outerHeight = a.height + v, a;
    }
  }
  var r,
    a = "undefined" == typeof console ? e : function (t) {
      console.error(t);
    },
    u = ["paddingLeft", "paddingRight", "paddingTop", "paddingBottom", "marginLeft", "marginRight", "marginTop", "marginBottom", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"],
    h = u.length,
    d = !1;
  return s;
}), function (t, e) {
  "use strict";

   true ? !(__WEBPACK_LOCAL_MODULE_3__factory = (e), (typeof __WEBPACK_LOCAL_MODULE_3__factory === 'function' ? ((__WEBPACK_LOCAL_MODULE_3__module = { id: "desandro-matches-selector/matches-selector", exports: {}, loaded: false }), (__WEBPACK_LOCAL_MODULE_3__ = __WEBPACK_LOCAL_MODULE_3__factory.call(__WEBPACK_LOCAL_MODULE_3__module.exports, __webpack_require__, __WEBPACK_LOCAL_MODULE_3__module.exports, __WEBPACK_LOCAL_MODULE_3__module)), (__WEBPACK_LOCAL_MODULE_3__module.loaded = true), __WEBPACK_LOCAL_MODULE_3__ === undefined && (__WEBPACK_LOCAL_MODULE_3__ = __WEBPACK_LOCAL_MODULE_3__module.exports)) : __WEBPACK_LOCAL_MODULE_3__ = __WEBPACK_LOCAL_MODULE_3__factory)) : 0;
}(window, function () {
  "use strict";

  var t = function () {
    var t = window.Element.prototype;
    if (t.matches) return "matches";
    if (t.matchesSelector) return "matchesSelector";
    for (var e = ["webkit", "moz", "ms", "o"], i = 0; i < e.length; i++) {
      var o = e[i],
        n = o + "MatchesSelector";
      if (t[n]) return n;
    }
  }();
  return function (e, i) {
    return e[t](i);
  };
}), function (t, e) {
   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__WEBPACK_LOCAL_MODULE_3__], __WEBPACK_LOCAL_MODULE_4__ = (function (i) {
    return e(t, i);
  }).apply(__WEBPACK_LOCAL_MODULE_4__exports = {}, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_LOCAL_MODULE_4__ === undefined && (__WEBPACK_LOCAL_MODULE_4__ = __WEBPACK_LOCAL_MODULE_4__exports)) : 0;
}(window, function (t, e) {
  var i = {};
  i.extend = function (t, e) {
    for (var i in e) t[i] = e[i];
    return t;
  }, i.modulo = function (t, e) {
    return (t % e + e) % e;
  }, i.makeArray = function (t) {
    var e = [];
    if (Array.isArray(t)) e = t;else if (t && "object" == _typeof(t) && "number" == typeof t.length) for (var i = 0; i < t.length; i++) e.push(t[i]);else e.push(t);
    return e;
  }, i.removeFrom = function (t, e) {
    var i = t.indexOf(e);
    i != -1 && t.splice(i, 1);
  }, i.getParent = function (t, i) {
    for (; t.parentNode && t != document.body;) if (t = t.parentNode, e(t, i)) return t;
  }, i.getQueryElement = function (t) {
    return "string" == typeof t ? document.querySelector(t) : t;
  }, i.handleEvent = function (t) {
    var e = "on" + t.type;
    this[e] && this[e](t);
  }, i.filterFindElements = function (t, o) {
    t = i.makeArray(t);
    var n = [];
    return t.forEach(function (t) {
      if (t instanceof HTMLElement) {
        if (!o) return void n.push(t);
        e(t, o) && n.push(t);
        for (var i = t.querySelectorAll(o), s = 0; s < i.length; s++) n.push(i[s]);
      }
    }), n;
  }, i.debounceMethod = function (t, e, i) {
    var o = t.prototype[e],
      n = e + "Timeout";
    t.prototype[e] = function () {
      var t = this[n];
      t && clearTimeout(t);
      var e = arguments,
        s = this;
      this[n] = setTimeout(function () {
        o.apply(s, e), delete s[n];
      }, i || 100);
    };
  }, i.docReady = function (t) {
    var e = document.readyState;
    "complete" == e || "interactive" == e ? setTimeout(t) : document.addEventListener("DOMContentLoaded", t);
  }, i.toDashed = function (t) {
    return t.replace(/(.)([A-Z])/g, function (t, e, i) {
      return e + "-" + i;
    }).toLowerCase();
  };
  var o = t.console;
  return i.htmlInit = function (e, n) {
    i.docReady(function () {
      var s = i.toDashed(n),
        r = "data-" + s,
        a = document.querySelectorAll("[" + r + "]"),
        u = document.querySelectorAll(".js-" + s),
        h = i.makeArray(a).concat(i.makeArray(u)),
        d = r + "-options",
        l = t.jQuery;
      h.forEach(function (t) {
        var i,
          s = t.getAttribute(r) || t.getAttribute(d);
        try {
          i = s && JSON.parse(s);
        } catch (a) {
          return void (o && o.error("Error parsing " + r + " on " + t.className + ": " + a));
        }
        var u = new e(t, i);
        l && l.data(t, n, u);
      });
    });
  }, i;
}), function (t, e) {
   true ? !(__WEBPACK_LOCAL_MODULE_5__array = [__WEBPACK_LOCAL_MODULE_1__, __WEBPACK_LOCAL_MODULE_2__], __WEBPACK_LOCAL_MODULE_5__factory = (e),
		(typeof __WEBPACK_LOCAL_MODULE_5__factory === 'function' ?
			((__WEBPACK_LOCAL_MODULE_5__ = __WEBPACK_LOCAL_MODULE_5__factory.apply(__WEBPACK_LOCAL_MODULE_5__exports = {}, __WEBPACK_LOCAL_MODULE_5__array)), __WEBPACK_LOCAL_MODULE_5__ === undefined && (__WEBPACK_LOCAL_MODULE_5__ = __WEBPACK_LOCAL_MODULE_5__exports)) :
			(__WEBPACK_LOCAL_MODULE_5__ = __WEBPACK_LOCAL_MODULE_5__factory)
		)) : 0;
}(window, function (t, e) {
  "use strict";

  function i(t) {
    for (var e in t) return !1;
    return e = null, !0;
  }
  function o(t, e) {
    t && (this.element = t, this.layout = e, this.position = {
      x: 0,
      y: 0
    }, this._create());
  }
  function n(t) {
    return t.replace(/([A-Z])/g, function (t) {
      return "-" + t.toLowerCase();
    });
  }
  var s = document.documentElement.style,
    r = "string" == typeof s.transition ? "transition" : "WebkitTransition",
    a = "string" == typeof s.transform ? "transform" : "WebkitTransform",
    u = {
      WebkitTransition: "webkitTransitionEnd",
      transition: "transitionend"
    }[r],
    h = {
      transform: a,
      transition: r,
      transitionDuration: r + "Duration",
      transitionProperty: r + "Property",
      transitionDelay: r + "Delay"
    },
    d = o.prototype = Object.create(t.prototype);
  d.constructor = o, d._create = function () {
    this._transn = {
      ingProperties: {},
      clean: {},
      onEnd: {}
    }, this.css({
      position: "absolute"
    });
  }, d.handleEvent = function (t) {
    var e = "on" + t.type;
    this[e] && this[e](t);
  }, d.getSize = function () {
    this.size = e(this.element);
  }, d.css = function (t) {
    var e = this.element.style;
    for (var i in t) {
      var o = h[i] || i;
      e[o] = t[i];
    }
  }, d.getPosition = function () {
    var t = getComputedStyle(this.element),
      e = this.layout._getOption("originLeft"),
      i = this.layout._getOption("originTop"),
      o = t[e ? "left" : "right"],
      n = t[i ? "top" : "bottom"],
      s = this.layout.size,
      r = o.indexOf("%") != -1 ? parseFloat(o) / 100 * s.width : parseInt(o, 10),
      a = n.indexOf("%") != -1 ? parseFloat(n) / 100 * s.height : parseInt(n, 10);
    r = isNaN(r) ? 0 : r, a = isNaN(a) ? 0 : a, r -= e ? s.paddingLeft : s.paddingRight, a -= i ? s.paddingTop : s.paddingBottom, this.position.x = r, this.position.y = a;
  }, d.layoutPosition = function () {
    var t = this.layout.size,
      e = {},
      i = this.layout._getOption("originLeft"),
      o = this.layout._getOption("originTop"),
      n = i ? "paddingLeft" : "paddingRight",
      s = i ? "left" : "right",
      r = i ? "right" : "left",
      a = this.position.x + t[n];
    e[s] = this.getXValue(a), e[r] = "";
    var u = o ? "paddingTop" : "paddingBottom",
      h = o ? "top" : "bottom",
      d = o ? "bottom" : "top",
      l = this.position.y + t[u];
    e[h] = this.getYValue(l), e[d] = "", this.css(e), this.emitEvent("layout", [this]);
  }, d.getXValue = function (t) {
    var e = this.layout._getOption("horizontal");
    return this.layout.options.percentPosition && !e ? t / this.layout.size.width * 100 + "%" : t + "px";
  }, d.getYValue = function (t) {
    var e = this.layout._getOption("horizontal");
    return this.layout.options.percentPosition && e ? t / this.layout.size.height * 100 + "%" : t + "px";
  }, d._transitionTo = function (t, e) {
    this.getPosition();
    var i = this.position.x,
      o = this.position.y,
      n = parseInt(t, 10),
      s = parseInt(e, 10),
      r = n === this.position.x && s === this.position.y;
    if (this.setPosition(t, e), r && !this.isTransitioning) return void this.layoutPosition();
    var a = t - i,
      u = e - o,
      h = {};
    h.transform = this.getTranslate(a, u), this.transition({
      to: h,
      onTransitionEnd: {
        transform: this.layoutPosition
      },
      isCleaning: !0
    });
  }, d.getTranslate = function (t, e) {
    var i = this.layout._getOption("originLeft"),
      o = this.layout._getOption("originTop");
    return t = i ? t : -t, e = o ? e : -e, "translate3d(" + t + "px, " + e + "px, 0)";
  }, d.goTo = function (t, e) {
    this.setPosition(t, e), this.layoutPosition();
  }, d.moveTo = d._transitionTo, d.setPosition = function (t, e) {
    this.position.x = parseInt(t, 10), this.position.y = parseInt(e, 10);
  }, d._nonTransition = function (t) {
    this.css(t.to), t.isCleaning && this._removeStyles(t.to);
    for (var e in t.onTransitionEnd) t.onTransitionEnd[e].call(this);
  }, d.transition = function (t) {
    if (!parseFloat(this.layout.options.transitionDuration)) return void this._nonTransition(t);
    var e = this._transn;
    for (var i in t.onTransitionEnd) e.onEnd[i] = t.onTransitionEnd[i];
    for (i in t.to) e.ingProperties[i] = !0, t.isCleaning && (e.clean[i] = !0);
    if (t.from) {
      this.css(t.from);
      var o = this.element.offsetHeight;
      o = null;
    }
    this.enableTransition(t.to), this.css(t.to), this.isTransitioning = !0;
  };
  var l = "opacity," + n(a);
  d.enableTransition = function () {
    if (!this.isTransitioning) {
      var t = this.layout.options.transitionDuration;
      t = "number" == typeof t ? t + "ms" : t, this.css({
        transitionProperty: l,
        transitionDuration: t,
        transitionDelay: this.staggerDelay || 0
      }), this.element.addEventListener(u, this, !1);
    }
  }, d.onwebkitTransitionEnd = function (t) {
    this.ontransitionend(t);
  }, d.onotransitionend = function (t) {
    this.ontransitionend(t);
  };
  var f = {
    "-webkit-transform": "transform"
  };
  d.ontransitionend = function (t) {
    if (t.target === this.element) {
      var e = this._transn,
        o = f[t.propertyName] || t.propertyName;
      if (delete e.ingProperties[o], i(e.ingProperties) && this.disableTransition(), o in e.clean && (this.element.style[t.propertyName] = "", delete e.clean[o]), o in e.onEnd) {
        var n = e.onEnd[o];
        n.call(this), delete e.onEnd[o];
      }
      this.emitEvent("transitionEnd", [this]);
    }
  }, d.disableTransition = function () {
    this.removeTransitionStyles(), this.element.removeEventListener(u, this, !1), this.isTransitioning = !1;
  }, d._removeStyles = function (t) {
    var e = {};
    for (var i in t) e[i] = "";
    this.css(e);
  };
  var c = {
    transitionProperty: "",
    transitionDuration: "",
    transitionDelay: ""
  };
  return d.removeTransitionStyles = function () {
    this.css(c);
  }, d.stagger = function (t) {
    t = isNaN(t) ? 0 : t, this.staggerDelay = t + "ms";
  }, d.removeElem = function () {
    this.element.parentNode.removeChild(this.element), this.css({
      display: ""
    }), this.emitEvent("remove", [this]);
  }, d.remove = function () {
    return r && parseFloat(this.layout.options.transitionDuration) ? (this.once("transitionEnd", function () {
      this.removeElem();
    }), void this.hide()) : void this.removeElem();
  }, d.reveal = function () {
    delete this.isHidden, this.css({
      display: ""
    });
    var t = this.layout.options,
      e = {},
      i = this.getHideRevealTransitionEndProperty("visibleStyle");
    e[i] = this.onRevealTransitionEnd, this.transition({
      from: t.hiddenStyle,
      to: t.visibleStyle,
      isCleaning: !0,
      onTransitionEnd: e
    });
  }, d.onRevealTransitionEnd = function () {
    this.isHidden || this.emitEvent("reveal");
  }, d.getHideRevealTransitionEndProperty = function (t) {
    var e = this.layout.options[t];
    if (e.opacity) return "opacity";
    for (var i in e) return i;
  }, d.hide = function () {
    this.isHidden = !0, this.css({
      display: ""
    });
    var t = this.layout.options,
      e = {},
      i = this.getHideRevealTransitionEndProperty("hiddenStyle");
    e[i] = this.onHideTransitionEnd, this.transition({
      from: t.visibleStyle,
      to: t.hiddenStyle,
      isCleaning: !0,
      onTransitionEnd: e
    });
  }, d.onHideTransitionEnd = function () {
    this.isHidden && (this.css({
      display: "none"
    }), this.emitEvent("hide"));
  }, d.destroy = function () {
    this.css({
      position: "",
      left: "",
      right: "",
      top: "",
      bottom: "",
      transition: "",
      transform: ""
    });
  }, o;
}), function (t, e) {
  "use strict";

   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__WEBPACK_LOCAL_MODULE_1__, __WEBPACK_LOCAL_MODULE_2__, __WEBPACK_LOCAL_MODULE_4__, __WEBPACK_LOCAL_MODULE_5__], __WEBPACK_LOCAL_MODULE_6__ = (function (i, o, n, s) {
    return e(t, i, o, n, s);
  }).apply(__WEBPACK_LOCAL_MODULE_6__exports = {}, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_LOCAL_MODULE_6__ === undefined && (__WEBPACK_LOCAL_MODULE_6__ = __WEBPACK_LOCAL_MODULE_6__exports)) : 0;
}(window, function (t, e, i, o, n) {
  "use strict";

  function s(t, e) {
    var i = o.getQueryElement(t);
    if (!i) return void (u && u.error("Bad element for " + this.constructor.namespace + ": " + (i || t)));
    this.element = i, h && (this.$element = h(this.element)), this.options = o.extend({}, this.constructor.defaults), this.option(e);
    var n = ++l;
    this.element.outlayerGUID = n, f[n] = this, this._create();
    var s = this._getOption("initLayout");
    s && this.layout();
  }
  function r(t) {
    function e() {
      t.apply(this, arguments);
    }
    return e.prototype = Object.create(t.prototype), e.prototype.constructor = e, e;
  }
  function a(t) {
    if ("number" == typeof t) return t;
    var e = t.match(/(^\d*\.?\d*)(\w*)/),
      i = e && e[1],
      o = e && e[2];
    if (!i.length) return 0;
    i = parseFloat(i);
    var n = m[o] || 1;
    return i * n;
  }
  var u = t.console,
    h = t.jQuery,
    d = function d() {},
    l = 0,
    f = {};
  s.namespace = "outlayer", s.Item = n, s.defaults = {
    containerStyle: {
      position: "relative"
    },
    initLayout: !0,
    originLeft: !0,
    originTop: !0,
    resize: !0,
    resizeContainer: !0,
    transitionDuration: "0.4s",
    hiddenStyle: {
      opacity: 0,
      transform: "scale(0.001)"
    },
    visibleStyle: {
      opacity: 1,
      transform: "scale(1)"
    }
  };
  var c = s.prototype;
  o.extend(c, e.prototype), c.option = function (t) {
    o.extend(this.options, t);
  }, c._getOption = function (t) {
    var e = this.constructor.compatOptions[t];
    return e && void 0 !== this.options[e] ? this.options[e] : this.options[t];
  }, s.compatOptions = {
    initLayout: "isInitLayout",
    horizontal: "isHorizontal",
    layoutInstant: "isLayoutInstant",
    originLeft: "isOriginLeft",
    originTop: "isOriginTop",
    resize: "isResizeBound",
    resizeContainer: "isResizingContainer"
  }, c._create = function () {
    this.reloadItems(), this.stamps = [], this.stamp(this.options.stamp), o.extend(this.element.style, this.options.containerStyle);
    var t = this._getOption("resize");
    t && this.bindResize();
  }, c.reloadItems = function () {
    this.items = this._itemize(this.element.children);
  }, c._itemize = function (t) {
    for (var e = this._filterFindItemElements(t), i = this.constructor.Item, o = [], n = 0; n < e.length; n++) {
      var s = e[n],
        r = new i(s, this);
      o.push(r);
    }
    return o;
  }, c._filterFindItemElements = function (t) {
    return o.filterFindElements(t, this.options.itemSelector);
  }, c.getItemElements = function () {
    return this.items.map(function (t) {
      return t.element;
    });
  }, c.layout = function () {
    this._resetLayout(), this._manageStamps();
    var t = this._getOption("layoutInstant"),
      e = void 0 !== t ? t : !this._isLayoutInited;
    this.layoutItems(this.items, e), this._isLayoutInited = !0;
  }, c._init = c.layout, c._resetLayout = function () {
    this.getSize();
  }, c.getSize = function () {
    this.size = i(this.element);
  }, c._getMeasurement = function (t, e) {
    var o,
      n = this.options[t];
    n ? ("string" == typeof n ? o = this.element.querySelector(n) : n instanceof HTMLElement && (o = n), this[t] = o ? i(o)[e] : n) : this[t] = 0;
  }, c.layoutItems = function (t, e) {
    t = this._getItemsForLayout(t), this._layoutItems(t, e), this._postLayout();
  }, c._getItemsForLayout = function (t) {
    return t.filter(function (t) {
      return !t.isIgnored;
    });
  }, c._layoutItems = function (t, e) {
    if (this._emitCompleteOnItems("layout", t), t && t.length) {
      var i = [];
      t.forEach(function (t) {
        var o = this._getItemLayoutPosition(t);
        o.item = t, o.isInstant = e || t.isLayoutInstant, i.push(o);
      }, this), this._processLayoutQueue(i);
    }
  }, c._getItemLayoutPosition = function () {
    return {
      x: 0,
      y: 0
    };
  }, c._processLayoutQueue = function (t) {
    this.updateStagger(), t.forEach(function (t, e) {
      this._positionItem(t.item, t.x, t.y, t.isInstant, e);
    }, this);
  }, c.updateStagger = function () {
    var t = this.options.stagger;
    return null === t || void 0 === t ? void (this.stagger = 0) : (this.stagger = a(t), this.stagger);
  }, c._positionItem = function (t, e, i, o, n) {
    o ? t.goTo(e, i) : (t.stagger(n * this.stagger), t.moveTo(e, i));
  }, c._postLayout = function () {
    this.resizeContainer();
  }, c.resizeContainer = function () {
    var t = this._getOption("resizeContainer");
    if (t) {
      var e = this._getContainerSize();
      e && (this._setContainerMeasure(e.width, !0), this._setContainerMeasure(e.height, !1));
    }
  }, c._getContainerSize = d, c._setContainerMeasure = function (t, e) {
    if (void 0 !== t) {
      var i = this.size;
      i.isBorderBox && (t += e ? i.paddingLeft + i.paddingRight + i.borderLeftWidth + i.borderRightWidth : i.paddingBottom + i.paddingTop + i.borderTopWidth + i.borderBottomWidth), t = Math.max(t, 0), this.element.style[e ? "width" : "height"] = t + "px";
    }
  }, c._emitCompleteOnItems = function (t, e) {
    function i() {
      n.dispatchEvent(t + "Complete", null, [e]);
    }
    function o() {
      r++, r == s && i();
    }
    var n = this,
      s = e.length;
    if (!e || !s) return void i();
    var r = 0;
    e.forEach(function (e) {
      e.once(t, o);
    });
  }, c.dispatchEvent = function (t, e, i) {
    var o = e ? [e].concat(i) : i;
    if (this.emitEvent(t, o), h) if (this.$element = this.$element || h(this.element), e) {
      var n = h.Event(e);
      n.type = t, this.$element.trigger(n, i);
    } else this.$element.trigger(t, i);
  }, c.ignore = function (t) {
    var e = this.getItem(t);
    e && (e.isIgnored = !0);
  }, c.unignore = function (t) {
    var e = this.getItem(t);
    e && delete e.isIgnored;
  }, c.stamp = function (t) {
    t = this._find(t), t && (this.stamps = this.stamps.concat(t), t.forEach(this.ignore, this));
  }, c.unstamp = function (t) {
    t = this._find(t), t && t.forEach(function (t) {
      o.removeFrom(this.stamps, t), this.unignore(t);
    }, this);
  }, c._find = function (t) {
    if (t) return "string" == typeof t && (t = this.element.querySelectorAll(t)), t = o.makeArray(t);
  }, c._manageStamps = function () {
    this.stamps && this.stamps.length && (this._getBoundingRect(), this.stamps.forEach(this._manageStamp, this));
  }, c._getBoundingRect = function () {
    var t = this.element.getBoundingClientRect(),
      e = this.size;
    this._boundingRect = {
      left: t.left + e.paddingLeft + e.borderLeftWidth,
      top: t.top + e.paddingTop + e.borderTopWidth,
      right: t.right - (e.paddingRight + e.borderRightWidth),
      bottom: t.bottom - (e.paddingBottom + e.borderBottomWidth)
    };
  }, c._manageStamp = d, c._getElementOffset = function (t) {
    var e = t.getBoundingClientRect(),
      o = this._boundingRect,
      n = i(t),
      s = {
        left: e.left - o.left - n.marginLeft,
        top: e.top - o.top - n.marginTop,
        right: o.right - e.right - n.marginRight,
        bottom: o.bottom - e.bottom - n.marginBottom
      };
    return s;
  }, c.handleEvent = o.handleEvent, c.bindResize = function () {
    t.addEventListener("resize", this), this.isResizeBound = !0;
  }, c.unbindResize = function () {
    t.removeEventListener("resize", this), this.isResizeBound = !1;
  }, c.onresize = function () {
    this.resize();
  }, o.debounceMethod(s, "onresize", 100), c.resize = function () {
    this.isResizeBound && this.needsResizeLayout() && this.layout();
  }, c.needsResizeLayout = function () {
    var t = i(this.element),
      e = this.size && t;
    return e && t.innerWidth !== this.size.innerWidth;
  }, c.addItems = function (t) {
    var e = this._itemize(t);
    return e.length && (this.items = this.items.concat(e)), e;
  }, c.appended = function (t) {
    var e = this.addItems(t);
    e.length && (this.layoutItems(e, !0), this.reveal(e));
  }, c.prepended = function (t) {
    var e = this._itemize(t);
    if (e.length) {
      var i = this.items.slice(0);
      this.items = e.concat(i), this._resetLayout(), this._manageStamps(), this.layoutItems(e, !0), this.reveal(e), this.layoutItems(i);
    }
  }, c.reveal = function (t) {
    if (this._emitCompleteOnItems("reveal", t), t && t.length) {
      var e = this.updateStagger();
      t.forEach(function (t, i) {
        t.stagger(i * e), t.reveal();
      });
    }
  }, c.hide = function (t) {
    if (this._emitCompleteOnItems("hide", t), t && t.length) {
      var e = this.updateStagger();
      t.forEach(function (t, i) {
        t.stagger(i * e), t.hide();
      });
    }
  }, c.revealItemElements = function (t) {
    var e = this.getItems(t);
    this.reveal(e);
  }, c.hideItemElements = function (t) {
    var e = this.getItems(t);
    this.hide(e);
  }, c.getItem = function (t) {
    for (var e = 0; e < this.items.length; e++) {
      var i = this.items[e];
      if (i.element == t) return i;
    }
  }, c.getItems = function (t) {
    t = o.makeArray(t);
    var e = [];
    return t.forEach(function (t) {
      var i = this.getItem(t);
      i && e.push(i);
    }, this), e;
  }, c.remove = function (t) {
    var e = this.getItems(t);
    this._emitCompleteOnItems("remove", e), e && e.length && e.forEach(function (t) {
      t.remove(), o.removeFrom(this.items, t);
    }, this);
  }, c.destroy = function () {
    var t = this.element.style;
    t.height = "", t.position = "", t.width = "", this.items.forEach(function (t) {
      t.destroy();
    }), this.unbindResize();
    var e = this.element.outlayerGUID;
    delete f[e], delete this.element.outlayerGUID, h && h.removeData(this.element, this.constructor.namespace);
  }, s.data = function (t) {
    t = o.getQueryElement(t);
    var e = t && t.outlayerGUID;
    return e && f[e];
  }, s.create = function (t, e) {
    var i = r(s);
    return i.defaults = o.extend({}, s.defaults), o.extend(i.defaults, e), i.compatOptions = o.extend({}, s.compatOptions), i.namespace = t, i.data = s.data, i.Item = r(n), o.htmlInit(i, t), h && h.bridget && h.bridget(t, i), i;
  };
  var m = {
    ms: 1,
    s: 1e3
  };
  return s.Item = n, s;
}), function (t, e) {
   true ? !(__WEBPACK_LOCAL_MODULE_7__array = [__WEBPACK_LOCAL_MODULE_6__], __WEBPACK_LOCAL_MODULE_7__factory = (e),
		(typeof __WEBPACK_LOCAL_MODULE_7__factory === 'function' ?
			((__WEBPACK_LOCAL_MODULE_7__ = __WEBPACK_LOCAL_MODULE_7__factory.apply(__WEBPACK_LOCAL_MODULE_7__exports = {}, __WEBPACK_LOCAL_MODULE_7__array)), __WEBPACK_LOCAL_MODULE_7__ === undefined && (__WEBPACK_LOCAL_MODULE_7__ = __WEBPACK_LOCAL_MODULE_7__exports)) :
			(__WEBPACK_LOCAL_MODULE_7__ = __WEBPACK_LOCAL_MODULE_7__factory)
		)) : 0;
}(window, function (t) {
  "use strict";

  function e() {
    t.Item.apply(this, arguments);
  }
  var i = e.prototype = Object.create(t.Item.prototype),
    o = i._create;
  i._create = function () {
    this.id = this.layout.itemGUID++, o.call(this), this.sortData = {};
  }, i.updateSortData = function () {
    if (!this.isIgnored) {
      this.sortData.id = this.id, this.sortData["original-order"] = this.id, this.sortData.random = Math.random();
      var t = this.layout.options.getSortData,
        e = this.layout._sorters;
      for (var i in t) {
        var o = e[i];
        this.sortData[i] = o(this.element, this);
      }
    }
  };
  var n = i.destroy;
  return i.destroy = function () {
    n.apply(this, arguments), this.css({
      display: ""
    });
  }, e;
}), function (t, e) {
   true ? !(__WEBPACK_LOCAL_MODULE_8__array = [__WEBPACK_LOCAL_MODULE_2__, __WEBPACK_LOCAL_MODULE_6__], __WEBPACK_LOCAL_MODULE_8__factory = (e),
		(typeof __WEBPACK_LOCAL_MODULE_8__factory === 'function' ?
			((__WEBPACK_LOCAL_MODULE_8__ = __WEBPACK_LOCAL_MODULE_8__factory.apply(__WEBPACK_LOCAL_MODULE_8__exports = {}, __WEBPACK_LOCAL_MODULE_8__array)), __WEBPACK_LOCAL_MODULE_8__ === undefined && (__WEBPACK_LOCAL_MODULE_8__ = __WEBPACK_LOCAL_MODULE_8__exports)) :
			(__WEBPACK_LOCAL_MODULE_8__ = __WEBPACK_LOCAL_MODULE_8__factory)
		)) : 0;
}(window, function (t, e) {
  "use strict";

  function i(t) {
    this.isotope = t, t && (this.options = t.options[this.namespace], this.element = t.element, this.items = t.filteredItems, this.size = t.size);
  }
  var o = i.prototype,
    n = ["_resetLayout", "_getItemLayoutPosition", "_manageStamp", "_getContainerSize", "_getElementOffset", "needsResizeLayout", "_getOption"];
  return n.forEach(function (t) {
    o[t] = function () {
      return e.prototype[t].apply(this.isotope, arguments);
    };
  }), o.needsVerticalResizeLayout = function () {
    var e = t(this.isotope.element),
      i = this.isotope.size && e;
    return i && e.innerHeight != this.isotope.size.innerHeight;
  }, o._getMeasurement = function () {
    this.isotope._getMeasurement.apply(this, arguments);
  }, o.getColumnWidth = function () {
    this.getSegmentSize("column", "Width");
  }, o.getRowHeight = function () {
    this.getSegmentSize("row", "Height");
  }, o.getSegmentSize = function (t, e) {
    var i = t + e,
      o = "outer" + e;
    if (this._getMeasurement(i, o), !this[i]) {
      var n = this.getFirstItemSize();
      this[i] = n && n[o] || this.isotope.size["inner" + e];
    }
  }, o.getFirstItemSize = function () {
    var e = this.isotope.filteredItems[0];
    return e && e.element && t(e.element);
  }, o.layout = function () {
    this.isotope.layout.apply(this.isotope, arguments);
  }, o.getSize = function () {
    this.isotope.getSize(), this.size = this.isotope.size;
  }, i.modes = {}, i.create = function (t, e) {
    function n() {
      i.apply(this, arguments);
    }
    return n.prototype = Object.create(o), n.prototype.constructor = n, e && (n.options = e), n.prototype.namespace = t, i.modes[t] = n, n;
  }, i;
}), function (t, e) {
   true ? !(__WEBPACK_LOCAL_MODULE_9__array = [__WEBPACK_LOCAL_MODULE_6__, __WEBPACK_LOCAL_MODULE_2__], __WEBPACK_LOCAL_MODULE_9__factory = (e),
		(typeof __WEBPACK_LOCAL_MODULE_9__factory === 'function' ?
			((__WEBPACK_LOCAL_MODULE_9__ = __WEBPACK_LOCAL_MODULE_9__factory.apply(__WEBPACK_LOCAL_MODULE_9__exports = {}, __WEBPACK_LOCAL_MODULE_9__array)), __WEBPACK_LOCAL_MODULE_9__ === undefined && (__WEBPACK_LOCAL_MODULE_9__ = __WEBPACK_LOCAL_MODULE_9__exports)) :
			(__WEBPACK_LOCAL_MODULE_9__ = __WEBPACK_LOCAL_MODULE_9__factory)
		)) : 0;
}(window, function (t, e) {
  var i = t.create("masonry");
  i.compatOptions.fitWidth = "isFitWidth";
  var o = i.prototype;
  return o._resetLayout = function () {
    this.getSize(), this._getMeasurement("columnWidth", "outerWidth"), this._getMeasurement("gutter", "outerWidth"), this.measureColumns(), this.colYs = [];
    for (var t = 0; t < this.cols; t++) this.colYs.push(0);
    this.maxY = 0, this.horizontalColIndex = 0;
  }, o.measureColumns = function () {
    if (this.getContainerWidth(), !this.columnWidth) {
      var t = this.items[0],
        i = t && t.element;
      this.columnWidth = i && e(i).outerWidth || this.containerWidth;
    }
    var o = this.columnWidth += this.gutter,
      n = this.containerWidth + this.gutter,
      s = n / o,
      r = o - n % o,
      a = r && r < 1 ? "round" : "floor";
    s = Math[a](s), this.cols = Math.max(s, 1);
  }, o.getContainerWidth = function () {
    var t = this._getOption("fitWidth"),
      i = t ? this.element.parentNode : this.element,
      o = e(i);
    this.containerWidth = o && o.innerWidth;
  }, o._getItemLayoutPosition = function (t) {
    t.getSize();
    var e = t.size.outerWidth % this.columnWidth,
      i = e && e < 1 ? "round" : "ceil",
      o = Math[i](t.size.outerWidth / this.columnWidth);
    o = Math.min(o, this.cols);
    for (var n = this.options.horizontalOrder ? "_getHorizontalColPosition" : "_getTopColPosition", s = this[n](o, t), r = {
        x: this.columnWidth * s.col,
        y: s.y
      }, a = s.y + t.size.outerHeight, u = o + s.col, h = s.col; h < u; h++) this.colYs[h] = a;
    return r;
  }, o._getTopColPosition = function (t) {
    var e = this._getTopColGroup(t),
      i = Math.min.apply(Math, e);
    return {
      col: e.indexOf(i),
      y: i
    };
  }, o._getTopColGroup = function (t) {
    if (t < 2) return this.colYs;
    for (var e = [], i = this.cols + 1 - t, o = 0; o < i; o++) e[o] = this._getColGroupY(o, t);
    return e;
  }, o._getColGroupY = function (t, e) {
    if (e < 2) return this.colYs[t];
    var i = this.colYs.slice(t, t + e);
    return Math.max.apply(Math, i);
  }, o._getHorizontalColPosition = function (t, e) {
    var i = this.horizontalColIndex % this.cols,
      o = t > 1 && i + t > this.cols;
    i = o ? 0 : i;
    var n = e.size.outerWidth && e.size.outerHeight;
    return this.horizontalColIndex = n ? i + t : this.horizontalColIndex, {
      col: i,
      y: this._getColGroupY(i, t)
    };
  }, o._manageStamp = function (t) {
    var i = e(t),
      o = this._getElementOffset(t),
      n = this._getOption("originLeft"),
      s = n ? o.left : o.right,
      r = s + i.outerWidth,
      a = Math.floor(s / this.columnWidth);
    a = Math.max(0, a);
    var u = Math.floor(r / this.columnWidth);
    u -= r % this.columnWidth ? 0 : 1, u = Math.min(this.cols - 1, u);
    for (var h = this._getOption("originTop"), d = (h ? o.top : o.bottom) + i.outerHeight, l = a; l <= u; l++) this.colYs[l] = Math.max(d, this.colYs[l]);
  }, o._getContainerSize = function () {
    this.maxY = Math.max.apply(Math, this.colYs);
    var t = {
      height: this.maxY
    };
    return this._getOption("fitWidth") && (t.width = this._getContainerFitWidth()), t;
  }, o._getContainerFitWidth = function () {
    for (var t = 0, e = this.cols; --e && 0 === this.colYs[e];) t++;
    return (this.cols - t) * this.columnWidth - this.gutter;
  }, o.needsResizeLayout = function () {
    var t = this.containerWidth;
    return this.getContainerWidth(), t != this.containerWidth;
  }, i;
}), function (t, e) {
   true ? !(__WEBPACK_LOCAL_MODULE_10__array = [__WEBPACK_LOCAL_MODULE_8__, __WEBPACK_LOCAL_MODULE_9__], __WEBPACK_LOCAL_MODULE_10__factory = (e),
		(typeof __WEBPACK_LOCAL_MODULE_10__factory === 'function' ?
			((__WEBPACK_LOCAL_MODULE_10__ = __WEBPACK_LOCAL_MODULE_10__factory.apply(__WEBPACK_LOCAL_MODULE_10__exports = {}, __WEBPACK_LOCAL_MODULE_10__array)), __WEBPACK_LOCAL_MODULE_10__ === undefined && (__WEBPACK_LOCAL_MODULE_10__ = __WEBPACK_LOCAL_MODULE_10__exports)) :
			(__WEBPACK_LOCAL_MODULE_10__ = __WEBPACK_LOCAL_MODULE_10__factory)
		)) : 0;
}(window, function (t, e) {
  "use strict";

  var i = t.create("masonry"),
    o = i.prototype,
    n = {
      _getElementOffset: !0,
      layout: !0,
      _getMeasurement: !0
    };
  for (var s in e.prototype) n[s] || (o[s] = e.prototype[s]);
  var r = o.measureColumns;
  o.measureColumns = function () {
    this.items = this.isotope.filteredItems, r.call(this);
  };
  var a = o._getOption;
  return o._getOption = function (t) {
    return "fitWidth" == t ? void 0 !== this.options.isFitWidth ? this.options.isFitWidth : this.options.fitWidth : a.apply(this.isotope, arguments);
  }, i;
}), function (t, e) {
   true ? !(__WEBPACK_LOCAL_MODULE_11__array = [__WEBPACK_LOCAL_MODULE_8__], __WEBPACK_LOCAL_MODULE_11__factory = (e),
		(typeof __WEBPACK_LOCAL_MODULE_11__factory === 'function' ?
			((__WEBPACK_LOCAL_MODULE_11__ = __WEBPACK_LOCAL_MODULE_11__factory.apply(__WEBPACK_LOCAL_MODULE_11__exports = {}, __WEBPACK_LOCAL_MODULE_11__array)), __WEBPACK_LOCAL_MODULE_11__ === undefined && (__WEBPACK_LOCAL_MODULE_11__ = __WEBPACK_LOCAL_MODULE_11__exports)) :
			(__WEBPACK_LOCAL_MODULE_11__ = __WEBPACK_LOCAL_MODULE_11__factory)
		)) : 0;
}(window, function (t) {
  "use strict";

  var e = t.create("fitRows"),
    i = e.prototype;
  return i._resetLayout = function () {
    this.x = 0, this.y = 0, this.maxY = 0, this._getMeasurement("gutter", "outerWidth");
  }, i._getItemLayoutPosition = function (t) {
    t.getSize();
    var e = t.size.outerWidth + this.gutter,
      i = this.isotope.size.innerWidth + this.gutter;
    0 !== this.x && e + this.x > i && (this.x = 0, this.y = this.maxY);
    var o = {
      x: this.x,
      y: this.y
    };
    return this.maxY = Math.max(this.maxY, this.y + t.size.outerHeight), this.x += e, o;
  }, i._getContainerSize = function () {
    return {
      height: this.maxY
    };
  }, e;
}), function (t, e) {
   true ? !(__WEBPACK_LOCAL_MODULE_12__array = [__WEBPACK_LOCAL_MODULE_8__], __WEBPACK_LOCAL_MODULE_12__factory = (e),
		(typeof __WEBPACK_LOCAL_MODULE_12__factory === 'function' ?
			((__WEBPACK_LOCAL_MODULE_12__ = __WEBPACK_LOCAL_MODULE_12__factory.apply(__WEBPACK_LOCAL_MODULE_12__exports = {}, __WEBPACK_LOCAL_MODULE_12__array)), __WEBPACK_LOCAL_MODULE_12__ === undefined && (__WEBPACK_LOCAL_MODULE_12__ = __WEBPACK_LOCAL_MODULE_12__exports)) :
			(__WEBPACK_LOCAL_MODULE_12__ = __WEBPACK_LOCAL_MODULE_12__factory)
		)) : 0;
}(window, function (t) {
  "use strict";

  var e = t.create("vertical", {
      horizontalAlignment: 0
    }),
    i = e.prototype;
  return i._resetLayout = function () {
    this.y = 0;
  }, i._getItemLayoutPosition = function (t) {
    t.getSize();
    var e = (this.isotope.size.innerWidth - t.size.outerWidth) * this.options.horizontalAlignment,
      i = this.y;
    return this.y += t.size.outerHeight, {
      x: e,
      y: i
    };
  }, i._getContainerSize = function () {
    return {
      height: this.y
    };
  }, e;
}), function (t, e) {
   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__WEBPACK_LOCAL_MODULE_6__, __WEBPACK_LOCAL_MODULE_2__, __WEBPACK_LOCAL_MODULE_3__, __WEBPACK_LOCAL_MODULE_4__, __WEBPACK_LOCAL_MODULE_7__, __WEBPACK_LOCAL_MODULE_8__, __WEBPACK_LOCAL_MODULE_10__, __WEBPACK_LOCAL_MODULE_11__, __WEBPACK_LOCAL_MODULE_12__], __WEBPACK_AMD_DEFINE_RESULT__ = (function (i, o, n, s, r, a) {
    return e(t, i, o, n, s, r, a);
  }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
}(window, function (t, e, i, o, n, s, r) {
  function a(t, e) {
    return function (i, o) {
      for (var n = 0; n < t.length; n++) {
        var s = t[n],
          r = i.sortData[s],
          a = o.sortData[s];
        if (r > a || r < a) {
          var u = void 0 !== e[s] ? e[s] : e,
            h = u ? 1 : -1;
          return (r > a ? 1 : -1) * h;
        }
      }
      return 0;
    };
  }
  var u = t.jQuery,
    h = String.prototype.trim ? function (t) {
      return t.trim();
    } : function (t) {
      return t.replace(/^\s+|\s+$/g, "");
    },
    d = e.create("isotope", {
      layoutMode: "masonry",
      isJQueryFiltering: !0,
      sortAscending: !0
    });
  d.Item = s, d.LayoutMode = r;
  var l = d.prototype;
  l._create = function () {
    this.itemGUID = 0, this._sorters = {}, this._getSorters(), e.prototype._create.call(this), this.modes = {}, this.filteredItems = this.items, this.sortHistory = ["original-order"];
    for (var t in r.modes) this._initLayoutMode(t);
  }, l.reloadItems = function () {
    this.itemGUID = 0, e.prototype.reloadItems.call(this);
  }, l._itemize = function () {
    for (var t = e.prototype._itemize.apply(this, arguments), i = 0; i < t.length; i++) {
      var o = t[i];
      o.id = this.itemGUID++;
    }
    return this._updateItemsSortData(t), t;
  }, l._initLayoutMode = function (t) {
    var e = r.modes[t],
      i = this.options[t] || {};
    this.options[t] = e.options ? n.extend(e.options, i) : i, this.modes[t] = new e(this);
  }, l.layout = function () {
    return !this._isLayoutInited && this._getOption("initLayout") ? void this.arrange() : void this._layout();
  }, l._layout = function () {
    var t = this._getIsInstant();
    this._resetLayout(), this._manageStamps(), this.layoutItems(this.filteredItems, t), this._isLayoutInited = !0;
  }, l.arrange = function (t) {
    this.option(t), this._getIsInstant();
    var e = this._filter(this.items);
    this.filteredItems = e.matches, this._bindArrangeComplete(), this._isInstant ? this._noTransition(this._hideReveal, [e]) : this._hideReveal(e), this._sort(), this._layout();
  }, l._init = l.arrange, l._hideReveal = function (t) {
    this.reveal(t.needReveal), this.hide(t.needHide);
  }, l._getIsInstant = function () {
    var t = this._getOption("layoutInstant"),
      e = void 0 !== t ? t : !this._isLayoutInited;
    return this._isInstant = e, e;
  }, l._bindArrangeComplete = function () {
    function t() {
      e && i && o && n.dispatchEvent("arrangeComplete", null, [n.filteredItems]);
    }
    var e,
      i,
      o,
      n = this;
    this.once("layoutComplete", function () {
      e = !0, t();
    }), this.once("hideComplete", function () {
      i = !0, t();
    }), this.once("revealComplete", function () {
      o = !0, t();
    });
  }, l._filter = function (t) {
    var e = this.options.filter;
    e = e || "*";
    for (var i = [], o = [], n = [], s = this._getFilterTest(e), r = 0; r < t.length; r++) {
      var a = t[r];
      if (!a.isIgnored) {
        var u = s(a);
        u && i.push(a), u && a.isHidden ? o.push(a) : u || a.isHidden || n.push(a);
      }
    }
    return {
      matches: i,
      needReveal: o,
      needHide: n
    };
  }, l._getFilterTest = function (t) {
    return u && this.options.isJQueryFiltering ? function (e) {
      return u(e.element).is(t);
    } : "function" == typeof t ? function (e) {
      return t(e.element);
    } : function (e) {
      return o(e.element, t);
    };
  }, l.updateSortData = function (t) {
    var e;
    t ? (t = n.makeArray(t), e = this.getItems(t)) : e = this.items, this._getSorters(), this._updateItemsSortData(e);
  }, l._getSorters = function () {
    var t = this.options.getSortData;
    for (var e in t) {
      var i = t[e];
      this._sorters[e] = f(i);
    }
  }, l._updateItemsSortData = function (t) {
    for (var e = t && t.length, i = 0; e && i < e; i++) {
      var o = t[i];
      o.updateSortData();
    }
  };
  var f = function () {
    function t(t) {
      if ("string" != typeof t) return t;
      var i = h(t).split(" "),
        o = i[0],
        n = o.match(/^\[(.+)\]$/),
        s = n && n[1],
        r = e(s, o),
        a = d.sortDataParsers[i[1]];
      return t = a ? function (t) {
        return t && a(r(t));
      } : function (t) {
        return t && r(t);
      };
    }
    function e(t, e) {
      return t ? function (e) {
        return e.getAttribute(t);
      } : function (t) {
        var i = t.querySelector(e);
        return i && i.textContent;
      };
    }
    return t;
  }();
  d.sortDataParsers = {
    parseInt: function (_parseInt) {
      function parseInt(_x) {
        return _parseInt.apply(this, arguments);
      }
      parseInt.toString = function () {
        return _parseInt.toString();
      };
      return parseInt;
    }(function (t) {
      return parseInt(t, 10);
    }),
    parseFloat: function (_parseFloat) {
      function parseFloat(_x2) {
        return _parseFloat.apply(this, arguments);
      }
      parseFloat.toString = function () {
        return _parseFloat.toString();
      };
      return parseFloat;
    }(function (t) {
      return parseFloat(t);
    })
  }, l._sort = function () {
    if (this.options.sortBy) {
      var t = n.makeArray(this.options.sortBy);
      this._getIsSameSortBy(t) || (this.sortHistory = t.concat(this.sortHistory));
      var e = a(this.sortHistory, this.options.sortAscending);
      this.filteredItems.sort(e);
    }
  }, l._getIsSameSortBy = function (t) {
    for (var e = 0; e < t.length; e++) if (t[e] != this.sortHistory[e]) return !1;
    return !0;
  }, l._mode = function () {
    var t = this.options.layoutMode,
      e = this.modes[t];
    if (!e) throw new Error("No layout mode: " + t);
    return e.options = this.options[t], e;
  }, l._resetLayout = function () {
    e.prototype._resetLayout.call(this), this._mode()._resetLayout();
  }, l._getItemLayoutPosition = function (t) {
    return this._mode()._getItemLayoutPosition(t);
  }, l._manageStamp = function (t) {
    this._mode()._manageStamp(t);
  }, l._getContainerSize = function () {
    return this._mode()._getContainerSize();
  }, l.needsResizeLayout = function () {
    return this._mode().needsResizeLayout();
  }, l.appended = function (t) {
    var e = this.addItems(t);
    if (e.length) {
      var i = this._filterRevealAdded(e);
      this.filteredItems = this.filteredItems.concat(i);
    }
  }, l.prepended = function (t) {
    var e = this._itemize(t);
    if (e.length) {
      this._resetLayout(), this._manageStamps();
      var i = this._filterRevealAdded(e);
      this.layoutItems(this.filteredItems), this.filteredItems = i.concat(this.filteredItems), this.items = e.concat(this.items);
    }
  }, l._filterRevealAdded = function (t) {
    var e = this._filter(t);
    return this.hide(e.needHide), this.reveal(e.matches), this.layoutItems(e.matches, !0), e.matches;
  }, l.insert = function (t) {
    var e = this.addItems(t);
    if (e.length) {
      var i,
        o,
        n = e.length;
      for (i = 0; i < n; i++) o = e[i], this.element.appendChild(o.element);
      var s = this._filter(e).matches;
      for (i = 0; i < n; i++) e[i].isLayoutInstant = !0;
      for (this.arrange(), i = 0; i < n; i++) delete e[i].isLayoutInstant;
      this.reveal(s);
    }
  };
  var c = l.remove;
  return l.remove = function (t) {
    t = n.makeArray(t);
    var e = this.getItems(t);
    c.call(this, t);
    for (var i = e && e.length, o = 0; i && o < i; o++) {
      var s = e[o];
      n.removeFrom(this.filteredItems, s);
    }
  }, l.shuffle = function () {
    for (var t = 0; t < this.items.length; t++) {
      var e = this.items[t];
      e.sortData.random = Math.random();
    }
    this.options.sortBy = "random", this._sort(), this._layout();
  }, l._noTransition = function (t, e) {
    var i = this.options.transitionDuration;
    this.options.transitionDuration = 0;
    var o = t.apply(this, e);
    return this.options.transitionDuration = i, o;
  }, l.getFilteredItemElements = function () {
    return this.filteredItems.map(function (t) {
      return t.element;
    });
  }, d;
});

/***/ }),

/***/ "./public/frontend/amazy/js/jquery.ajaxchimp.min.js":
/*!**********************************************************!*\
  !*** ./public/frontend/amazy/js/jquery.ajaxchimp.min.js ***!
  \**********************************************************/
/***/ (() => {

(function ($) {
  'use strict';

  $.ajaxChimp = {
    responses: {
      'We have sent you a confirmation email': 0,
      'Please enter a valid email': 1,
      'An email address must contain a single @': 2,
      'The domain portion of the email address is invalid (the portion after the @: )': 3,
      'The username portion of the email address is invalid (the portion before the @: )': 4,
      'This email address looks fake or invalid. Please enter a real email address': 5
    },
    translations: {
      'en': null
    },
    init: function init(selector, options) {
      $(selector).ajaxChimp(options);
    }
  };
  $.fn.ajaxChimp = function (options) {
    $(this).each(function (i, elem) {
      var form = $(elem);
      var email = form.find('input[type=email]');
      var label = form.find('.info');
      var settings = $.extend({
        'url': form.attr('action'),
        'language': 'en'
      }, options);
      var url = settings.url.replace('/post?', '/post-json?').concat('&c=?');
      form.attr('novalidate', 'true');
      email.attr('name', 'EMAIL');
      form.submit(function () {
        var msg;
        function successCallback(resp) {
          if (resp.result === 'success') {
            msg = 'We have sent you a confirmation email';
            label.removeClass('error').addClass('valid');
            email.removeClass('error').addClass('valid');
          } else {
            email.removeClass('valid').addClass('error');
            label.removeClass('valid').addClass('error');
            var index = -1;
            try {
              var parts = resp.msg.split(' - ', 2);
              if (parts[1] === undefined) {
                msg = resp.msg;
              } else {
                var i = parseInt(parts[0], 10);
                if (i.toString() === parts[0]) {
                  index = parts[0];
                  msg = parts[1];
                } else {
                  index = -1;
                  msg = resp.msg;
                }
              }
            } catch (e) {
              index = -1;
              msg = resp.msg;
            }
          }

          // Translate and display message
          if (settings.language !== 'en' && $.ajaxChimp.responses[msg] !== undefined && $.ajaxChimp.translations && $.ajaxChimp.translations[settings.language] && $.ajaxChimp.translations[settings.language][$.ajaxChimp.responses[msg]]) {
            msg = $.ajaxChimp.translations[settings.language][$.ajaxChimp.responses[msg]];
          }
          label.html(msg);
          label.show(2000);
          if (settings.callback) {
            settings.callback(resp);
          }
        }
        var data = {};
        var dataArray = form.serializeArray();
        $.each(dataArray, function (index, item) {
          data[item.name] = item.value;
        });
        $.ajax({
          url: url,
          data: data,
          success: successCallback,
          dataType: 'jsonp',
          error: function error(resp, text) {
            console.log('mailchimp ajax submit error: ' + text);
          }
        });

        // Translate and display submit message
        var submitMsg = 'Submitting...';
        if (settings.language !== 'en' && $.ajaxChimp.translations && $.ajaxChimp.translations[settings.language] && $.ajaxChimp.translations[settings.language]['submit']) {
          submitMsg = $.ajaxChimp.translations[settings.language]['submit'];
        }
        label.html(submitMsg).show(2000);
        return false;
      });
    });
    return this;
  };
})(jQuery);

/***/ }),

/***/ "./public/frontend/amazy/js/jquery.countdown.min.js":
/*!**********************************************************!*\
  !*** ./public/frontend/amazy/js/jquery.countdown.min.js ***!
  \**********************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * The Final Countdown for jQuery v2.2.0 (http://hilios.github.io/jQuery.countdown/)
 * Copyright (c) 2016 Edson Hilios
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
!function (a) {
  "use strict";

   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (a),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
}(function (a) {
  "use strict";

  function b(a) {
    if (a instanceof Date) return a;
    if (String(a).match(g)) return String(a).match(/^[0-9]*$/) && (a = Number(a)), String(a).match(/\-/) && (a = String(a).replace(/\-/g, "/")), new Date(a);
    throw new Error("Couldn't cast `" + a + "` to a date object.");
  }
  function c(a) {
    var b = a.toString().replace(/([.?*+^$[\]\\(){}|-])/g, "\\$1");
    return new RegExp(b);
  }
  function d(a) {
    return function (b) {
      var d = b.match(/%(-|!)?[A-Z]{1}(:[^;]+;)?/gi);
      if (d) for (var f = 0, g = d.length; f < g; ++f) {
        var h = d[f].match(/%(-|!)?([a-zA-Z]{1})(:[^;]+;)?/),
          j = c(h[0]),
          k = h[1] || "",
          l = h[3] || "",
          m = null;
        h = h[2], i.hasOwnProperty(h) && (m = i[h], m = Number(a[m])), null !== m && ("!" === k && (m = e(l, m)), "" === k && m < 10 && (m = "0" + m.toString()), b = b.replace(j, m.toString()));
      }
      return b = b.replace(/%%/, "%");
    };
  }
  function e(a, b) {
    var c = "s",
      d = "";
    return a && (a = a.replace(/(:|;|\s)/gi, "").split(/\,/), 1 === a.length ? c = a[0] : (d = a[0], c = a[1])), Math.abs(b) > 1 ? c : d;
  }
  var f = [],
    g = [],
    h = {
      precision: 100,
      elapse: !1,
      defer: !1
    };
  g.push(/^[0-9]*$/.source), g.push(/([0-9]{1,2}\/){2}[0-9]{4}( [0-9]{1,2}(:[0-9]{2}){2})?/.source), g.push(/[0-9]{4}([\/\-][0-9]{1,2}){2}( [0-9]{1,2}(:[0-9]{2}){2})?/.source), g = new RegExp(g.join("|"));
  var i = {
      Y: "years",
      m: "months",
      n: "daysToMonth",
      d: "daysToWeek",
      w: "weeks",
      W: "weeksToMonth",
      H: "hours",
      M: "minutes",
      S: "seconds",
      D: "totalDays",
      I: "totalHours",
      N: "totalMinutes",
      T: "totalSeconds"
    },
    j = function j(b, c, d) {
      this.el = b, this.$el = a(b), this.interval = null, this.offset = {}, this.options = a.extend({}, h), this.firstTick = !0, this.instanceNumber = f.length, f.push(this), this.$el.data("countdown-instance", this.instanceNumber), d && ("function" == typeof d ? (this.$el.on("update.countdown", d), this.$el.on("stoped.countdown", d), this.$el.on("finish.countdown", d)) : this.options = a.extend({}, h, d)), this.setFinalDate(c), this.options.defer === !1 && this.start();
    };
  a.extend(j.prototype, {
    start: function start() {
      null !== this.interval && clearInterval(this.interval);
      var a = this;
      this.update(), this.interval = setInterval(function () {
        a.update.call(a);
      }, this.options.precision);
    },
    stop: function stop() {
      clearInterval(this.interval), this.interval = null, this.dispatchEvent("stoped");
    },
    toggle: function toggle() {
      this.interval ? this.stop() : this.start();
    },
    pause: function pause() {
      this.stop();
    },
    resume: function resume() {
      this.start();
    },
    remove: function remove() {
      this.stop.call(this), f[this.instanceNumber] = null, delete this.$el.data().countdownInstance;
    },
    setFinalDate: function setFinalDate(a) {
      this.finalDate = b(a);
    },
    update: function update() {
      if (0 === this.$el.closest("html").length) return void this.remove();
      var a,
        b = new Date();
      return a = this.finalDate.getTime() - b.getTime(), a = Math.ceil(a / 1e3), a = !this.options.elapse && a < 0 ? 0 : Math.abs(a), this.totalSecsLeft === a || this.firstTick ? void (this.firstTick = !1) : (this.totalSecsLeft = a, this.elapsed = b >= this.finalDate, this.offset = {
        seconds: this.totalSecsLeft % 60,
        minutes: Math.floor(this.totalSecsLeft / 60) % 60,
        hours: Math.floor(this.totalSecsLeft / 60 / 60) % 24,
        days: Math.floor(this.totalSecsLeft / 60 / 60 / 24) % 7,
        daysToWeek: Math.floor(this.totalSecsLeft / 60 / 60 / 24) % 7,
        daysToMonth: Math.floor(this.totalSecsLeft / 60 / 60 / 24 % 30.4368),
        weeks: Math.floor(this.totalSecsLeft / 60 / 60 / 24 / 7),
        weeksToMonth: Math.floor(this.totalSecsLeft / 60 / 60 / 24 / 7) % 4,
        months: Math.floor(this.totalSecsLeft / 60 / 60 / 24 / 30.4368),
        years: Math.abs(this.finalDate.getFullYear() - b.getFullYear()),
        totalDays: Math.floor(this.totalSecsLeft / 60 / 60 / 24),
        totalHours: Math.floor(this.totalSecsLeft / 60 / 60),
        totalMinutes: Math.floor(this.totalSecsLeft / 60),
        totalSeconds: this.totalSecsLeft
      }, void (this.options.elapse || 0 !== this.totalSecsLeft ? this.dispatchEvent("update") : (this.stop(), this.dispatchEvent("finish"))));
    },
    dispatchEvent: function dispatchEvent(b) {
      var c = a.Event(b + ".countdown");
      c.finalDate = this.finalDate, c.elapsed = this.elapsed, c.offset = a.extend({}, this.offset), c.strftime = d(this.offset), this.$el.trigger(c);
    }
  }), a.fn.countdown = function () {
    var b = Array.prototype.slice.call(arguments, 0);
    return this.each(function () {
      var c = a(this).data("countdown-instance");
      if (void 0 !== c) {
        var d = f[c],
          e = b[0];
        j.prototype.hasOwnProperty(e) ? d[e].apply(d, b.slice(1)) : null === String(e).match(/^[$A-Z_][0-9A-Z_$]*$/i) ? (d.setFinalDate.call(d, e), d.start()) : a.error("Method %s does not exist on jQuery.countdown".replace(/\%s/gi, e));
      } else new j(this, b[0], b[1]);
    });
  };
});

/***/ }),

/***/ "./public/frontend/amazy/js/jquery.counterup.min.js":
/*!**********************************************************!*\
  !*** ./public/frontend/amazy/js/jquery.counterup.min.js ***!
  \**********************************************************/
/***/ (() => {

/*!
* jquery.counterup.js 1.0
*
* Copyright 2013, Benjamin Intal http://gambit.ph @bfintal
* Released under the GPL v2 License
*
* Date: Nov 26, 2013
*/(function (e) {
  "use strict";

  e.fn.counterUp = function (t) {
    var n = e.extend({
      time: 400,
      delay: 10
    }, t);
    return this.each(function () {
      var t = e(this),
        r = n,
        i = function i() {
          var e = [],
            n = r.time / r.delay,
            i = t.text(),
            s = /[0-9]+,[0-9]+/.test(i);
          i = i.replace(/,/g, "");
          var o = /^[0-9]+$/.test(i),
            u = /^[0-9]+\.[0-9]+$/.test(i),
            a = u ? (i.split(".")[1] || []).length : 0;
          for (var f = n; f >= 1; f--) {
            var l = parseInt(i / n * f);
            u && (l = parseFloat(i / n * f).toFixed(a));
            if (s) while (/(\d+)(\d{3})/.test(l.toString())) l = l.toString().replace(/(\d+)(\d{3})/, "$1,$2");
            e.unshift(l);
          }
          t.data("counterup-nums", e);
          t.text("0");
          var c = function c() {
            t.text(t.data("counterup-nums").shift());
            if (t.data("counterup-nums").length) setTimeout(t.data("counterup-func"), r.delay);else {
              delete t.data("counterup-nums");
              t.data("counterup-nums", null);
              t.data("counterup-func", null);
            }
          };
          t.data("counterup-func", c);
          setTimeout(t.data("counterup-func"), r.delay);
        };
      t.waypoint(i, {
        offset: "100%",
        triggerOnce: !0
      });
    });
  };
})(jQuery);

/***/ }),

/***/ "./public/frontend/amazy/js/jquery.magnific-popup.min.js":
/*!***************************************************************!*\
  !*** ./public/frontend/amazy/js/jquery.magnific-popup.min.js ***!
  \***************************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/*! Magnific Popup - v1.1.0 - 2016-02-20
* http://dimsemenov.com/plugins/magnific-popup/
* Copyright (c) 2016 Dmitry Semenov; */
!function (a) {
   true ? !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (a),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : 0;
}(function (a) {
  var b,
    c,
    d,
    e,
    f,
    g,
    h = "Close",
    i = "BeforeClose",
    j = "AfterClose",
    k = "BeforeAppend",
    l = "MarkupParse",
    m = "Open",
    n = "Change",
    o = "mfp",
    p = "." + o,
    q = "mfp-ready",
    r = "mfp-removing",
    s = "mfp-prevent-close",
    t = function t() {},
    u = !!window.jQuery,
    v = a(window),
    w = function w(a, c) {
      b.ev.on(o + a + p, c);
    },
    x = function x(b, c, d, e) {
      var f = document.createElement("div");
      return f.className = "mfp-" + b, d && (f.innerHTML = d), e ? c && c.appendChild(f) : (f = a(f), c && f.appendTo(c)), f;
    },
    y = function y(c, d) {
      b.ev.triggerHandler(o + c, d), b.st.callbacks && (c = c.charAt(0).toLowerCase() + c.slice(1), b.st.callbacks[c] && b.st.callbacks[c].apply(b, a.isArray(d) ? d : [d]));
    },
    z = function z(c) {
      return c === g && b.currTemplate.closeBtn || (b.currTemplate.closeBtn = a(b.st.closeMarkup.replace("%title%", b.st.tClose)), g = c), b.currTemplate.closeBtn;
    },
    A = function A() {
      a.magnificPopup.instance || (b = new t(), b.init(), a.magnificPopup.instance = b);
    },
    B = function B() {
      var a = document.createElement("p").style,
        b = ["ms", "O", "Moz", "Webkit"];
      if (void 0 !== a.transition) return !0;
      for (; b.length;) if (b.pop() + "Transition" in a) return !0;
      return !1;
    };
  t.prototype = {
    constructor: t,
    init: function init() {
      var c = navigator.appVersion;
      b.isLowIE = b.isIE8 = document.all && !document.addEventListener, b.isAndroid = /android/gi.test(c), b.isIOS = /iphone|ipad|ipod/gi.test(c), b.supportsTransition = B(), b.probablyMobile = b.isAndroid || b.isIOS || /(Opera Mini)|Kindle|webOS|BlackBerry|(Opera Mobi)|(Windows Phone)|IEMobile/i.test(navigator.userAgent), d = a(document), b.popupsCache = {};
    },
    open: function open(c) {
      var e;
      if (c.isObj === !1) {
        b.items = c.items.toArray(), b.index = 0;
        var g,
          h = c.items;
        for (e = 0; e < h.length; e++) if (g = h[e], g.parsed && (g = g.el[0]), g === c.el[0]) {
          b.index = e;
          break;
        }
      } else b.items = a.isArray(c.items) ? c.items : [c.items], b.index = c.index || 0;
      if (b.isOpen) return void b.updateItemHTML();
      b.types = [], f = "", c.mainEl && c.mainEl.length ? b.ev = c.mainEl.eq(0) : b.ev = d, c.key ? (b.popupsCache[c.key] || (b.popupsCache[c.key] = {}), b.currTemplate = b.popupsCache[c.key]) : b.currTemplate = {}, b.st = a.extend(!0, {}, a.magnificPopup.defaults, c), b.fixedContentPos = "auto" === b.st.fixedContentPos ? !b.probablyMobile : b.st.fixedContentPos, b.st.modal && (b.st.closeOnContentClick = !1, b.st.closeOnBgClick = !1, b.st.showCloseBtn = !1, b.st.enableEscapeKey = !1), b.bgOverlay || (b.bgOverlay = x("bg").on("click" + p, function () {
        b.close();
      }), b.wrap = x("wrap").attr("tabindex", -1).on("click" + p, function (a) {
        b._checkIfClose(a.target) && b.close();
      }), b.container = x("container", b.wrap)), b.contentContainer = x("content"), b.st.preloader && (b.preloader = x("preloader", b.container, b.st.tLoading));
      var i = a.magnificPopup.modules;
      for (e = 0; e < i.length; e++) {
        var j = i[e];
        j = j.charAt(0).toUpperCase() + j.slice(1), b["init" + j].call(b);
      }
      y("BeforeOpen"), b.st.showCloseBtn && (b.st.closeBtnInside ? (w(l, function (a, b, c, d) {
        c.close_replaceWith = z(d.type);
      }), f += " mfp-close-btn-in") : b.wrap.append(z())), b.st.alignTop && (f += " mfp-align-top"), b.fixedContentPos ? b.wrap.css({
        overflow: b.st.overflowY,
        overflowX: "hidden",
        overflowY: b.st.overflowY
      }) : b.wrap.css({
        top: v.scrollTop(),
        position: "absolute"
      }), (b.st.fixedBgPos === !1 || "auto" === b.st.fixedBgPos && !b.fixedContentPos) && b.bgOverlay.css({
        height: d.height(),
        position: "absolute"
      }), b.st.enableEscapeKey && d.on("keyup" + p, function (a) {
        27 === a.keyCode && b.close();
      }), v.on("resize" + p, function () {
        b.updateSize();
      }), b.st.closeOnContentClick || (f += " mfp-auto-cursor"), f && b.wrap.addClass(f);
      var k = b.wH = v.height(),
        n = {};
      if (b.fixedContentPos && b._hasScrollBar(k)) {
        var o = b._getScrollbarSize();
        o && (n.marginRight = o);
      }
      b.fixedContentPos && (b.isIE7 ? a("body, html").css("overflow", "hidden") : n.overflow = "hidden");
      var r = b.st.mainClass;
      return b.isIE7 && (r += " mfp-ie7"), r && b._addClassToMFP(r), b.updateItemHTML(), y("BuildControls"), a("html").css(n), b.bgOverlay.add(b.wrap).prependTo(b.st.prependTo || a(document.body)), b._lastFocusedEl = document.activeElement, setTimeout(function () {
        b.content ? (b._addClassToMFP(q), b._setFocus()) : b.bgOverlay.addClass(q), d.on("focusin" + p, b._onFocusIn);
      }, 16), b.isOpen = !0, b.updateSize(k), y(m), c;
    },
    close: function close() {
      b.isOpen && (y(i), b.isOpen = !1, b.st.removalDelay && !b.isLowIE && b.supportsTransition ? (b._addClassToMFP(r), setTimeout(function () {
        b._close();
      }, b.st.removalDelay)) : b._close());
    },
    _close: function _close() {
      y(h);
      var c = r + " " + q + " ";
      if (b.bgOverlay.detach(), b.wrap.detach(), b.container.empty(), b.st.mainClass && (c += b.st.mainClass + " "), b._removeClassFromMFP(c), b.fixedContentPos) {
        var e = {
          marginRight: ""
        };
        b.isIE7 ? a("body, html").css("overflow", "") : e.overflow = "", a("html").css(e);
      }
      d.off("keyup" + p + " focusin" + p), b.ev.off(p), b.wrap.attr("class", "mfp-wrap").removeAttr("style"), b.bgOverlay.attr("class", "mfp-bg"), b.container.attr("class", "mfp-container"), !b.st.showCloseBtn || b.st.closeBtnInside && b.currTemplate[b.currItem.type] !== !0 || b.currTemplate.closeBtn && b.currTemplate.closeBtn.detach(), b.st.autoFocusLast && b._lastFocusedEl && a(b._lastFocusedEl).focus(), b.currItem = null, b.content = null, b.currTemplate = null, b.prevHeight = 0, y(j);
    },
    updateSize: function updateSize(a) {
      if (b.isIOS) {
        var c = document.documentElement.clientWidth / window.innerWidth,
          d = window.innerHeight * c;
        b.wrap.css("height", d), b.wH = d;
      } else b.wH = a || v.height();
      b.fixedContentPos || b.wrap.css("height", b.wH), y("Resize");
    },
    updateItemHTML: function updateItemHTML() {
      var c = b.items[b.index];
      b.contentContainer.detach(), b.content && b.content.detach(), c.parsed || (c = b.parseEl(b.index));
      var d = c.type;
      if (y("BeforeChange", [b.currItem ? b.currItem.type : "", d]), b.currItem = c, !b.currTemplate[d]) {
        var f = b.st[d] ? b.st[d].markup : !1;
        y("FirstMarkupParse", f), f ? b.currTemplate[d] = a(f) : b.currTemplate[d] = !0;
      }
      e && e !== c.type && b.container.removeClass("mfp-" + e + "-holder");
      var g = b["get" + d.charAt(0).toUpperCase() + d.slice(1)](c, b.currTemplate[d]);
      b.appendContent(g, d), c.preloaded = !0, y(n, c), e = c.type, b.container.prepend(b.contentContainer), y("AfterChange");
    },
    appendContent: function appendContent(a, c) {
      b.content = a, a ? b.st.showCloseBtn && b.st.closeBtnInside && b.currTemplate[c] === !0 ? b.content.find(".mfp-close").length || b.content.append(z()) : b.content = a : b.content = "", y(k), b.container.addClass("mfp-" + c + "-holder"), b.contentContainer.append(b.content);
    },
    parseEl: function parseEl(c) {
      var d,
        e = b.items[c];
      if (e.tagName ? e = {
        el: a(e)
      } : (d = e.type, e = {
        data: e,
        src: e.src
      }), e.el) {
        for (var f = b.types, g = 0; g < f.length; g++) if (e.el.hasClass("mfp-" + f[g])) {
          d = f[g];
          break;
        }
        e.src = e.el.attr("data-mfp-src"), e.src || (e.src = e.el.attr("href"));
      }
      return e.type = d || b.st.type || "inline", e.index = c, e.parsed = !0, b.items[c] = e, y("ElementParse", e), b.items[c];
    },
    addGroup: function addGroup(a, c) {
      var d = function d(_d) {
        _d.mfpEl = this, b._openClick(_d, a, c);
      };
      c || (c = {});
      var e = "click.magnificPopup";
      c.mainEl = a, c.items ? (c.isObj = !0, a.off(e).on(e, d)) : (c.isObj = !1, c.delegate ? a.off(e).on(e, c.delegate, d) : (c.items = a, a.off(e).on(e, d)));
    },
    _openClick: function _openClick(c, d, e) {
      var f = void 0 !== e.midClick ? e.midClick : a.magnificPopup.defaults.midClick;
      if (f || !(2 === c.which || c.ctrlKey || c.metaKey || c.altKey || c.shiftKey)) {
        var g = void 0 !== e.disableOn ? e.disableOn : a.magnificPopup.defaults.disableOn;
        if (g) if (a.isFunction(g)) {
          if (!g.call(b)) return !0;
        } else if (v.width() < g) return !0;
        c.type && (c.preventDefault(), b.isOpen && c.stopPropagation()), e.el = a(c.mfpEl), e.delegate && (e.items = d.find(e.delegate)), b.open(e);
      }
    },
    updateStatus: function updateStatus(a, d) {
      if (b.preloader) {
        c !== a && b.container.removeClass("mfp-s-" + c), d || "loading" !== a || (d = b.st.tLoading);
        var e = {
          status: a,
          text: d
        };
        y("UpdateStatus", e), a = e.status, d = e.text, b.preloader.html(d), b.preloader.find("a").on("click", function (a) {
          a.stopImmediatePropagation();
        }), b.container.addClass("mfp-s-" + a), c = a;
      }
    },
    _checkIfClose: function _checkIfClose(c) {
      if (!a(c).hasClass(s)) {
        var d = b.st.closeOnContentClick,
          e = b.st.closeOnBgClick;
        if (d && e) return !0;
        if (!b.content || a(c).hasClass("mfp-close") || b.preloader && c === b.preloader[0]) return !0;
        if (c === b.content[0] || a.contains(b.content[0], c)) {
          if (d) return !0;
        } else if (e && a.contains(document, c)) return !0;
        return !1;
      }
    },
    _addClassToMFP: function _addClassToMFP(a) {
      b.bgOverlay.addClass(a), b.wrap.addClass(a);
    },
    _removeClassFromMFP: function _removeClassFromMFP(a) {
      this.bgOverlay.removeClass(a), b.wrap.removeClass(a);
    },
    _hasScrollBar: function _hasScrollBar(a) {
      return (b.isIE7 ? d.height() : document.body.scrollHeight) > (a || v.height());
    },
    _setFocus: function _setFocus() {
      (b.st.focus ? b.content.find(b.st.focus).eq(0) : b.wrap).focus();
    },
    _onFocusIn: function _onFocusIn(c) {
      return c.target === b.wrap[0] || a.contains(b.wrap[0], c.target) ? void 0 : (b._setFocus(), !1);
    },
    _parseMarkup: function _parseMarkup(b, c, d) {
      var e;
      d.data && (c = a.extend(d.data, c)), y(l, [b, c, d]), a.each(c, function (c, d) {
        if (void 0 === d || d === !1) return !0;
        if (e = c.split("_"), e.length > 1) {
          var f = b.find(p + "-" + e[0]);
          if (f.length > 0) {
            var g = e[1];
            "replaceWith" === g ? f[0] !== d[0] && f.replaceWith(d) : "img" === g ? f.is("img") ? f.attr("src", d) : f.replaceWith(a("<img>").attr("src", d).attr("class", f.attr("class"))) : f.attr(e[1], d);
          }
        } else b.find(p + "-" + c).html(d);
      });
    },
    _getScrollbarSize: function _getScrollbarSize() {
      if (void 0 === b.scrollbarSize) {
        var a = document.createElement("div");
        a.style.cssText = "width: 99px; height: 99px; overflow: scroll; position: absolute; top: -9999px;", document.body.appendChild(a), b.scrollbarSize = a.offsetWidth - a.clientWidth, document.body.removeChild(a);
      }
      return b.scrollbarSize;
    }
  }, a.magnificPopup = {
    instance: null,
    proto: t.prototype,
    modules: [],
    open: function open(b, c) {
      return A(), b = b ? a.extend(!0, {}, b) : {}, b.isObj = !0, b.index = c || 0, this.instance.open(b);
    },
    close: function close() {
      return a.magnificPopup.instance && a.magnificPopup.instance.close();
    },
    registerModule: function registerModule(b, c) {
      c.options && (a.magnificPopup.defaults[b] = c.options), a.extend(this.proto, c.proto), this.modules.push(b);
    },
    defaults: {
      disableOn: 0,
      key: null,
      midClick: !1,
      mainClass: "",
      preloader: !0,
      focus: "",
      closeOnContentClick: !1,
      closeOnBgClick: !0,
      closeBtnInside: !0,
      showCloseBtn: !0,
      enableEscapeKey: !0,
      modal: !1,
      alignTop: !1,
      removalDelay: 0,
      prependTo: null,
      fixedContentPos: "auto",
      fixedBgPos: "auto",
      overflowY: "auto",
      closeMarkup: '<button title="%title%" type="button" class="mfp-close">&#215;</button>',
      tClose: "Close (Esc)",
      tLoading: "Loading...",
      autoFocusLast: !0
    }
  }, a.fn.magnificPopup = function (c) {
    A();
    var d = a(this);
    if ("string" == typeof c) {
      if ("open" === c) {
        var e,
          f = u ? d.data("magnificPopup") : d[0].magnificPopup,
          g = parseInt(arguments[1], 10) || 0;
        f.items ? e = f.items[g] : (e = d, f.delegate && (e = e.find(f.delegate)), e = e.eq(g)), b._openClick({
          mfpEl: e
        }, d, f);
      } else b.isOpen && b[c].apply(b, Array.prototype.slice.call(arguments, 1));
    } else c = a.extend(!0, {}, c), u ? d.data("magnificPopup", c) : d[0].magnificPopup = c, b.addGroup(d, c);
    return d;
  };
  var C,
    D,
    E,
    F = "inline",
    G = function G() {
      E && (D.after(E.addClass(C)).detach(), E = null);
    };
  a.magnificPopup.registerModule(F, {
    options: {
      hiddenClass: "hide",
      markup: "",
      tNotFound: "Content not found"
    },
    proto: {
      initInline: function initInline() {
        b.types.push(F), w(h + "." + F, function () {
          G();
        });
      },
      getInline: function getInline(c, d) {
        if (G(), c.src) {
          var e = b.st.inline,
            f = a(c.src);
          if (f.length) {
            var g = f[0].parentNode;
            g && g.tagName && (D || (C = e.hiddenClass, D = x(C), C = "mfp-" + C), E = f.after(D).detach().removeClass(C)), b.updateStatus("ready");
          } else b.updateStatus("error", e.tNotFound), f = a("<div>");
          return c.inlineElement = f, f;
        }
        return b.updateStatus("ready"), b._parseMarkup(d, {}, c), d;
      }
    }
  });
  var H,
    I = "ajax",
    J = function J() {
      H && a(document.body).removeClass(H);
    },
    K = function K() {
      J(), b.req && b.req.abort();
    };
  a.magnificPopup.registerModule(I, {
    options: {
      settings: null,
      cursor: "mfp-ajax-cur",
      tError: '<a href="%url%">The content</a> could not be loaded.'
    },
    proto: {
      initAjax: function initAjax() {
        b.types.push(I), H = b.st.ajax.cursor, w(h + "." + I, K), w("BeforeChange." + I, K);
      },
      getAjax: function getAjax(c) {
        H && a(document.body).addClass(H), b.updateStatus("loading");
        var d = a.extend({
          url: c.src,
          success: function success(d, e, f) {
            var g = {
              data: d,
              xhr: f
            };
            y("ParseAjax", g), b.appendContent(a(g.data), I), c.finished = !0, J(), b._setFocus(), setTimeout(function () {
              b.wrap.addClass(q);
            }, 16), b.updateStatus("ready"), y("AjaxContentAdded");
          },
          error: function error() {
            J(), c.finished = c.loadError = !0, b.updateStatus("error", b.st.ajax.tError.replace("%url%", c.src));
          }
        }, b.st.ajax.settings);
        return b.req = a.ajax(d), "";
      }
    }
  });
  var L,
    M = function M(c) {
      if (c.data && void 0 !== c.data.title) return c.data.title;
      var d = b.st.image.titleSrc;
      if (d) {
        if (a.isFunction(d)) return d.call(b, c);
        if (c.el) return c.el.attr(d) || "";
      }
      return "";
    };
  a.magnificPopup.registerModule("image", {
    options: {
      markup: '<div class="mfp-figure"><div class="mfp-close"></div><figure><div class="mfp-img"></div><figcaption><div class="mfp-bottom-bar"><div class="mfp-title"></div><div class="mfp-counter"></div></div></figcaption></figure></div>',
      cursor: "mfp-zoom-out-cur",
      titleSrc: "title",
      verticalFit: !0,
      tError: '<a href="%url%">The image</a> could not be loaded.'
    },
    proto: {
      initImage: function initImage() {
        var c = b.st.image,
          d = ".image";
        b.types.push("image"), w(m + d, function () {
          "image" === b.currItem.type && c.cursor && a(document.body).addClass(c.cursor);
        }), w(h + d, function () {
          c.cursor && a(document.body).removeClass(c.cursor), v.off("resize" + p);
        }), w("Resize" + d, b.resizeImage), b.isLowIE && w("AfterChange", b.resizeImage);
      },
      resizeImage: function resizeImage() {
        var a = b.currItem;
        if (a && a.img && b.st.image.verticalFit) {
          var c = 0;
          b.isLowIE && (c = parseInt(a.img.css("padding-top"), 10) + parseInt(a.img.css("padding-bottom"), 10)), a.img.css("max-height", b.wH - c);
        }
      },
      _onImageHasSize: function _onImageHasSize(a) {
        a.img && (a.hasSize = !0, L && clearInterval(L), a.isCheckingImgSize = !1, y("ImageHasSize", a), a.imgHidden && (b.content && b.content.removeClass("mfp-loading"), a.imgHidden = !1));
      },
      findImageSize: function findImageSize(a) {
        var c = 0,
          d = a.img[0],
          e = function e(f) {
            L && clearInterval(L), L = setInterval(function () {
              return d.naturalWidth > 0 ? void b._onImageHasSize(a) : (c > 200 && clearInterval(L), c++, void (3 === c ? e(10) : 40 === c ? e(50) : 100 === c && e(500)));
            }, f);
          };
        e(1);
      },
      getImage: function getImage(c, d) {
        var e = 0,
          f = function f() {
            c && (c.img[0].complete ? (c.img.off(".mfploader"), c === b.currItem && (b._onImageHasSize(c), b.updateStatus("ready")), c.hasSize = !0, c.loaded = !0, y("ImageLoadComplete")) : (e++, 200 > e ? setTimeout(f, 100) : g()));
          },
          g = function g() {
            c && (c.img.off(".mfploader"), c === b.currItem && (b._onImageHasSize(c), b.updateStatus("error", h.tError.replace("%url%", c.src))), c.hasSize = !0, c.loaded = !0, c.loadError = !0);
          },
          h = b.st.image,
          i = d.find(".mfp-img");
        if (i.length) {
          var j = document.createElement("img");
          j.className = "mfp-img", c.el && c.el.find("img").length && (j.alt = c.el.find("img").attr("alt")), c.img = a(j).on("load.mfploader", f).on("error.mfploader", g), j.src = c.src, i.is("img") && (c.img = c.img.clone()), j = c.img[0], j.naturalWidth > 0 ? c.hasSize = !0 : j.width || (c.hasSize = !1);
        }
        return b._parseMarkup(d, {
          title: M(c),
          img_replaceWith: c.img
        }, c), b.resizeImage(), c.hasSize ? (L && clearInterval(L), c.loadError ? (d.addClass("mfp-loading"), b.updateStatus("error", h.tError.replace("%url%", c.src))) : (d.removeClass("mfp-loading"), b.updateStatus("ready")), d) : (b.updateStatus("loading"), c.loading = !0, c.hasSize || (c.imgHidden = !0, d.addClass("mfp-loading"), b.findImageSize(c)), d);
      }
    }
  });
  var N,
    O = function O() {
      return void 0 === N && (N = void 0 !== document.createElement("p").style.MozTransform), N;
    };
  a.magnificPopup.registerModule("zoom", {
    options: {
      enabled: !1,
      easing: "ease-in-out",
      duration: 300,
      opener: function opener(a) {
        return a.is("img") ? a : a.find("img");
      }
    },
    proto: {
      initZoom: function initZoom() {
        var a,
          c = b.st.zoom,
          d = ".zoom";
        if (c.enabled && b.supportsTransition) {
          var e,
            f,
            g = c.duration,
            j = function j(a) {
              var b = a.clone().removeAttr("style").removeAttr("class").addClass("mfp-animated-image"),
                d = "all " + c.duration / 1e3 + "s " + c.easing,
                e = {
                  position: "fixed",
                  zIndex: 9999,
                  left: 0,
                  top: 0,
                  "-webkit-backface-visibility": "hidden"
                },
                f = "transition";
              return e["-webkit-" + f] = e["-moz-" + f] = e["-o-" + f] = e[f] = d, b.css(e), b;
            },
            k = function k() {
              b.content.css("visibility", "visible");
            };
          w("BuildControls" + d, function () {
            if (b._allowZoom()) {
              if (clearTimeout(e), b.content.css("visibility", "hidden"), a = b._getItemToZoom(), !a) return void k();
              f = j(a), f.css(b._getOffset()), b.wrap.append(f), e = setTimeout(function () {
                f.css(b._getOffset(!0)), e = setTimeout(function () {
                  k(), setTimeout(function () {
                    f.remove(), a = f = null, y("ZoomAnimationEnded");
                  }, 16);
                }, g);
              }, 16);
            }
          }), w(i + d, function () {
            if (b._allowZoom()) {
              if (clearTimeout(e), b.st.removalDelay = g, !a) {
                if (a = b._getItemToZoom(), !a) return;
                f = j(a);
              }
              f.css(b._getOffset(!0)), b.wrap.append(f), b.content.css("visibility", "hidden"), setTimeout(function () {
                f.css(b._getOffset());
              }, 16);
            }
          }), w(h + d, function () {
            b._allowZoom() && (k(), f && f.remove(), a = null);
          });
        }
      },
      _allowZoom: function _allowZoom() {
        return "image" === b.currItem.type;
      },
      _getItemToZoom: function _getItemToZoom() {
        return b.currItem.hasSize ? b.currItem.img : !1;
      },
      _getOffset: function _getOffset(c) {
        var d;
        d = c ? b.currItem.img : b.st.zoom.opener(b.currItem.el || b.currItem);
        var e = d.offset(),
          f = parseInt(d.css("padding-top"), 10),
          g = parseInt(d.css("padding-bottom"), 10);
        e.top -= a(window).scrollTop() - f;
        var h = {
          width: d.width(),
          height: (u ? d.innerHeight() : d[0].offsetHeight) - g - f
        };
        return O() ? h["-moz-transform"] = h.transform = "translate(" + e.left + "px," + e.top + "px)" : (h.left = e.left, h.top = e.top), h;
      }
    }
  });
  var P = "iframe",
    Q = "//about:blank",
    R = function R(a) {
      if (b.currTemplate[P]) {
        var c = b.currTemplate[P].find("iframe");
        c.length && (a || (c[0].src = Q), b.isIE8 && c.css("display", a ? "block" : "none"));
      }
    };
  a.magnificPopup.registerModule(P, {
    options: {
      markup: '<div class="mfp-iframe-scaler"><div class="mfp-close"></div><iframe class="mfp-iframe" src="//about:blank" frameborder="0" allowfullscreen></iframe></div>',
      srcAction: "iframe_src",
      patterns: {
        youtube: {
          index: "youtube.com",
          id: "v=",
          src: "//www.youtube.com/embed/%id%?autoplay=1"
        },
        vimeo: {
          index: "vimeo.com/",
          id: "/",
          src: "//player.vimeo.com/video/%id%?autoplay=1"
        },
        gmaps: {
          index: "//maps.google.",
          src: "%id%&output=embed"
        }
      }
    },
    proto: {
      initIframe: function initIframe() {
        b.types.push(P), w("BeforeChange", function (a, b, c) {
          b !== c && (b === P ? R() : c === P && R(!0));
        }), w(h + "." + P, function () {
          R();
        });
      },
      getIframe: function getIframe(c, d) {
        var e = c.src,
          f = b.st.iframe;
        a.each(f.patterns, function () {
          return e.indexOf(this.index) > -1 ? (this.id && (e = "string" == typeof this.id ? e.substr(e.lastIndexOf(this.id) + this.id.length, e.length) : this.id.call(this, e)), e = this.src.replace("%id%", e), !1) : void 0;
        });
        var g = {};
        return f.srcAction && (g[f.srcAction] = e), b._parseMarkup(d, g, c), b.updateStatus("ready"), d;
      }
    }
  });
  var S = function S(a) {
      var c = b.items.length;
      return a > c - 1 ? a - c : 0 > a ? c + a : a;
    },
    T = function T(a, b, c) {
      return a.replace(/%curr%/gi, b + 1).replace(/%total%/gi, c);
    };
  a.magnificPopup.registerModule("gallery", {
    options: {
      enabled: !1,
      arrowMarkup: '<button title="%title%" type="button" class="mfp-arrow mfp-arrow-%dir%"></button>',
      preload: [0, 2],
      navigateByImgClick: !0,
      arrows: !0,
      tPrev: "Previous (Left arrow key)",
      tNext: "Next (Right arrow key)",
      tCounter: "%curr% of %total%"
    },
    proto: {
      initGallery: function initGallery() {
        var c = b.st.gallery,
          e = ".mfp-gallery";
        return b.direction = !0, c && c.enabled ? (f += " mfp-gallery", w(m + e, function () {
          c.navigateByImgClick && b.wrap.on("click" + e, ".mfp-img", function () {
            return b.items.length > 1 ? (b.next(), !1) : void 0;
          }), d.on("keydown" + e, function (a) {
            37 === a.keyCode ? b.prev() : 39 === a.keyCode && b.next();
          });
        }), w("UpdateStatus" + e, function (a, c) {
          c.text && (c.text = T(c.text, b.currItem.index, b.items.length));
        }), w(l + e, function (a, d, e, f) {
          var g = b.items.length;
          e.counter = g > 1 ? T(c.tCounter, f.index, g) : "";
        }), w("BuildControls" + e, function () {
          if (b.items.length > 1 && c.arrows && !b.arrowLeft) {
            var d = c.arrowMarkup,
              e = b.arrowLeft = a(d.replace(/%title%/gi, c.tPrev).replace(/%dir%/gi, "left")).addClass(s),
              f = b.arrowRight = a(d.replace(/%title%/gi, c.tNext).replace(/%dir%/gi, "right")).addClass(s);
            e.click(function () {
              b.prev();
            }), f.click(function () {
              b.next();
            }), b.container.append(e.add(f));
          }
        }), w(n + e, function () {
          b._preloadTimeout && clearTimeout(b._preloadTimeout), b._preloadTimeout = setTimeout(function () {
            b.preloadNearbyImages(), b._preloadTimeout = null;
          }, 16);
        }), void w(h + e, function () {
          d.off(e), b.wrap.off("click" + e), b.arrowRight = b.arrowLeft = null;
        })) : !1;
      },
      next: function next() {
        b.direction = !0, b.index = S(b.index + 1), b.updateItemHTML();
      },
      prev: function prev() {
        b.direction = !1, b.index = S(b.index - 1), b.updateItemHTML();
      },
      goTo: function goTo(a) {
        b.direction = a >= b.index, b.index = a, b.updateItemHTML();
      },
      preloadNearbyImages: function preloadNearbyImages() {
        var a,
          c = b.st.gallery.preload,
          d = Math.min(c[0], b.items.length),
          e = Math.min(c[1], b.items.length);
        for (a = 1; a <= (b.direction ? e : d); a++) b._preloadItem(b.index + a);
        for (a = 1; a <= (b.direction ? d : e); a++) b._preloadItem(b.index - a);
      },
      _preloadItem: function _preloadItem(c) {
        if (c = S(c), !b.items[c].preloaded) {
          var d = b.items[c];
          d.parsed || (d = b.parseEl(c)), y("LazyLoad", d), "image" === d.type && (d.img = a('<img class="mfp-img" />').on("load.mfploader", function () {
            d.hasSize = !0;
          }).on("error.mfploader", function () {
            d.hasSize = !0, d.loadError = !0, y("LazyLoadError", d);
          }).attr("src", d.src)), d.preloaded = !0;
        }
      }
    }
  });
  var U = "retina";
  a.magnificPopup.registerModule(U, {
    options: {
      replaceSrc: function replaceSrc(a) {
        return a.src.replace(/\.\w+$/, function (a) {
          return "@2x" + a;
        });
      },
      ratio: 1
    },
    proto: {
      initRetina: function initRetina() {
        if (window.devicePixelRatio > 1) {
          var a = b.st.retina,
            c = a.ratio;
          c = isNaN(c) ? c() : c, c > 1 && (w("ImageHasSize." + U, function (a, b) {
            b.img.css({
              "max-width": b.img[0].naturalWidth / c,
              width: "100%"
            });
          }), w("ElementParse." + U, function (b, d) {
            d.src = a.replaceSrc(d, c);
          }));
        }
      }
    }
  }), A();
});

/***/ }),

/***/ "./public/frontend/amazy/js/jquery.nav.js":
/*!************************************************!*\
  !*** ./public/frontend/amazy/js/jquery.nav.js ***!
  \************************************************/
/***/ (() => {

/*
 * jQuery One Page Nav Plugin
 * http://github.com/davist11/jQuery-One-Page-Nav
 *
 * Copyright (c) 2010 Trevor Davis (http://trevordavis.net)
 * Dual licensed under the MIT and GPL licenses.
 * Uses the same license as jQuery, see:
 * http://jquery.org/license
 *
 * @version 3.0.0
 *
 * Example usage:
 * $('#nav').onePageNav({
 *   currentClass: 'current',
 *   changeHash: false,
 *   scrollSpeed: 750
 * });
 */

;
(function ($, window, document, undefined) {
  // our plugin constructor
  var OnePageNav = function OnePageNav(elem, options) {
    this.elem = elem;
    this.$elem = $(elem);
    this.options = options;
    this.metadata = this.$elem.data('plugin-options');
    this.$win = $(window);
    this.sections = {};
    this.didScroll = false;
    this.$doc = $(document);
    this.docHeight = this.$doc.height();
  };

  // the plugin prototype
  OnePageNav.prototype = {
    defaults: {
      navItems: 'a',
      currentClass: 'current',
      changeHash: false,
      easing: 'swing',
      filter: '',
      scrollSpeed: 750,
      scrollThreshold: 0.5,
      begin: false,
      end: false,
      scrollChange: false
    },
    init: function init() {
      // Introduce defaults that can be extended either
      // globally or using an object literal.
      this.config = $.extend({}, this.defaults, this.options, this.metadata);
      this.$nav = this.$elem.find(this.config.navItems);

      //Filter any links out of the nav
      if (this.config.filter !== '') {
        this.$nav = this.$nav.filter(this.config.filter);
      }

      //Handle clicks on the nav
      this.$nav.on('click.onePageNav', $.proxy(this.handleClick, this));

      //Get the section positions
      this.getPositions();

      //Handle scroll changes
      this.bindInterval();

      //Update the positions on resize too
      this.$win.on('resize.onePageNav', $.proxy(this.getPositions, this));
      return this;
    },
    adjustNav: function adjustNav(self, $parent) {
      self.$elem.find('.' + self.config.currentClass).removeClass(self.config.currentClass);
      $parent.addClass(self.config.currentClass);
    },
    bindInterval: function bindInterval() {
      var self = this;
      var docHeight;
      self.$win.on('scroll.onePageNav', function () {
        self.didScroll = true;
      });
      self.t = setInterval(function () {
        docHeight = self.$doc.height();

        //If it was scrolled
        if (self.didScroll) {
          self.didScroll = false;
          self.scrollChange();
        }

        //If the document height changes
        if (docHeight !== self.docHeight) {
          self.docHeight = docHeight;
          self.getPositions();
        }
      }, 250);
    },
    getHash: function getHash($link) {
      return $link.attr('href').split('#')[1];
    },
    getPositions: function getPositions() {
      var self = this;
      var linkHref;
      var topPos;
      var $target;
      self.$nav.each(function () {
        linkHref = self.getHash($(this));
        $target = $('#' + linkHref);
        if ($target.length) {
          topPos = $target.offset().top;
          self.sections[linkHref] = Math.round(topPos);
        }
      });
    },
    getSection: function getSection(windowPos) {
      var returnValue = null;
      var windowHeight = Math.round(this.$win.height() * this.config.scrollThreshold);
      for (var section in this.sections) {
        if (this.sections[section] - windowHeight < windowPos) {
          returnValue = section;
        }
      }
      return returnValue;
    },
    handleClick: function handleClick(e) {
      var self = this;
      var $link = $(e.currentTarget);
      var $parent = $link.parent();
      var newLoc = '#' + self.getHash($link);
      if (!$parent.hasClass(self.config.currentClass)) {
        //Start callback
        if (self.config.begin) {
          self.config.begin();
        }

        //Change the highlighted nav item
        self.adjustNav(self, $parent);

        //Removing the auto-adjust on scroll
        self.unbindInterval();

        //Scroll to the correct position
        self.scrollTo(newLoc, function () {
          //Do we need to change the hash?
          if (self.config.changeHash) {
            window.location.hash = newLoc;
          }

          //Add the auto-adjust on scroll back in
          self.bindInterval();

          //End callback
          if (self.config.end) {
            self.config.end();
          }
        });
      }
      e.preventDefault();
    },
    scrollChange: function scrollChange() {
      var windowTop = this.$win.scrollTop();
      var position = this.getSection(windowTop);
      var $parent;

      //If the position is set
      if (position !== null) {
        $parent = this.$elem.find('a[href$="#' + position + '"]').parent();

        //If it's not already the current section
        if (!$parent.hasClass(this.config.currentClass)) {
          //Change the highlighted nav item
          this.adjustNav(this, $parent);

          //If there is a scrollChange callback
          if (this.config.scrollChange) {
            this.config.scrollChange($parent);
          }
        }
      }
    },
    scrollTo: function scrollTo(target, callback) {
      var offset = $(target).offset().top;
      $('html, body').animate({
        scrollTop: offset
      }, this.config.scrollSpeed, this.config.easing, callback);
    },
    unbindInterval: function unbindInterval() {
      clearInterval(this.t);
      this.$win.unbind('scroll.onePageNav');
    }
  };
  OnePageNav.defaults = OnePageNav.prototype.defaults;
  $.fn.onePageNav = function (options) {
    return this.each(function () {
      new OnePageNav(this, options).init();
    });
  };
})(jQuery, window, document);

/***/ }),

/***/ "./public/frontend/amazy/js/jquery.slicknav.js":
/*!*****************************************************!*\
  !*** ./public/frontend/amazy/js/jquery.slicknav.js ***!
  \*****************************************************/
/***/ (() => {

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/*!
 * SlickNav Responsive Mobile Menu v1.0.10
 * (c) 2016 Josh Cope
 * licensed under MIT
 */
;
(function ($, document, window) {
  var
    // default settings object.
    defaults = {
      label: 'MENU',
      duplicate: true,
      duration: 200,
      easingOpen: 'swing',
      easingClose: 'swing',
      closedSymbol: '&#9658;',
      openedSymbol: '&#9660;',
      prependTo: 'body',
      appendTo: '',
      parentTag: 'a',
      closeOnClick: false,
      allowParentLinks: false,
      nestedParentLinks: true,
      showChildren: false,
      removeIds: true,
      removeClasses: false,
      removeStyles: false,
      brand: '',
      animations: 'jquery',
      init: function init() {},
      beforeOpen: function beforeOpen() {},
      beforeClose: function beforeClose() {},
      afterOpen: function afterOpen() {},
      afterClose: function afterClose() {}
    },
    mobileMenu = 'slicknav',
    prefix = 'slicknav',
    Keyboard = {
      DOWN: 40,
      ENTER: 13,
      ESCAPE: 27,
      LEFT: 37,
      RIGHT: 39,
      SPACE: 32,
      TAB: 9,
      UP: 38
    };
  function Plugin(element, options) {
    this.element = element;

    // jQuery has an extend method which merges the contents of two or
    // more objects, storing the result in the first object. The first object
    // is generally empty as we don't want to alter the default options for
    // future instances of the plugin
    this.settings = $.extend({}, defaults, options);

    // Don't remove IDs by default if duplicate is false
    if (!this.settings.duplicate && !options.hasOwnProperty("removeIds")) {
      this.settings.removeIds = false;
    }
    this._defaults = defaults;
    this._name = mobileMenu;
    this.init();
  }
  Plugin.prototype.init = function () {
    var $this = this,
      menu = $(this.element),
      settings = this.settings,
      iconClass,
      menuBar;

    // clone menu if needed
    if (settings.duplicate) {
      $this.mobileNav = menu.clone();
    } else {
      $this.mobileNav = menu;
    }

    // remove IDs if set
    if (settings.removeIds) {
      $this.mobileNav.removeAttr('id');
      $this.mobileNav.find('*').each(function (i, e) {
        $(e).removeAttr('id');
      });
    }

    // remove classes if set
    if (settings.removeClasses) {
      $this.mobileNav.removeAttr('class');
      $this.mobileNav.find('*').each(function (i, e) {
        $(e).removeAttr('class');
      });
    }

    // remove styles if set
    if (settings.removeStyles) {
      $this.mobileNav.removeAttr('style');
      $this.mobileNav.find('*').each(function (i, e) {
        $(e).removeAttr('style');
      });
    }

    // styling class for the button
    iconClass = prefix + '_icon';
    if (settings.label === '') {
      iconClass += ' ' + prefix + '_no-text';
    }
    if (settings.parentTag == 'a') {
      settings.parentTag = 'a href="#"';
    }

    // create menu bar
    $this.mobileNav.attr('class', prefix + '_nav');
    menuBar = $('<div class="' + prefix + '_menu"></div>');
    if (settings.brand !== '') {
      var brand = $('<div class="' + prefix + '_brand">' + settings.brand + '</div>');
      $(menuBar).append(brand);
    }
    $this.btn = $(['<' + settings.parentTag + ' aria-haspopup="true" role="button" tabindex="0" class="' + prefix + '_btn ' + prefix + '_collapsed">', '<span class="' + prefix + '_menutxt">' + settings.label + '</span>', '<span class="' + iconClass + '">', '<span class="' + prefix + '_icon-bar"></span>', '<span class="' + prefix + '_icon-bar"></span>', '<span class="' + prefix + '_icon-bar"></span>', '</span>', '</' + settings.parentTag + '>'].join(''));
    $(menuBar).append($this.btn);
    if (settings.appendTo !== '') {
      $(settings.appendTo).append(menuBar);
    } else {
      $(settings.prependTo).prepend(menuBar);
    }
    menuBar.append($this.mobileNav);

    // iterate over structure adding additional structure
    var items = $this.mobileNav.find('li');
    $(items).each(function () {
      var item = $(this),
        data = {};
      data.children = item.children('ul').attr('role', 'menu');
      item.data('menu', data);

      // if a list item has a nested menu
      if (data.children.length > 0) {
        // select all text before the child menu
        // check for anchors

        var a = item.contents(),
          containsAnchor = false,
          nodes = [];
        $(a).each(function () {
          if (!$(this).is('ul')) {
            nodes.push(this);
          } else {
            return false;
          }
          if ($(this).is("a")) {
            containsAnchor = true;
          }
        });
        var wrapElement = $('<' + settings.parentTag + ' role="menuitem" aria-haspopup="true" tabindex="-1" class="' + prefix + '_item"/>');

        // wrap item text with tag and add classes unless we are separating parent links
        if (!settings.allowParentLinks || settings.nestedParentLinks || !containsAnchor) {
          var $wrap = $(nodes).wrapAll(wrapElement).parent();
          $wrap.addClass(prefix + '_row');
        } else $(nodes).wrapAll('<span class="' + prefix + '_parent-link ' + prefix + '_row"/>').parent();
        if (!settings.showChildren) {
          item.addClass(prefix + '_collapsed');
        } else {
          item.addClass(prefix + '_open');
        }
        item.addClass(prefix + '_parent');

        // create parent arrow. wrap with link if parent links and separating
        var arrowElement = $('<span class="' + prefix + '_arrow">' + (settings.showChildren ? settings.openedSymbol : settings.closedSymbol) + '</span>');
        if (settings.allowParentLinks && !settings.nestedParentLinks && containsAnchor) arrowElement = arrowElement.wrap(wrapElement).parent();

        //append arrow
        $(nodes).last().after(arrowElement);
      } else if (item.children().length === 0) {
        item.addClass(prefix + '_txtnode');
      }

      // accessibility for links
      item.children('a').attr('role', 'menuitem').click(function (event) {
        //Ensure that it's not a parent
        if (settings.closeOnClick && !$(event.target).parent().closest('li').hasClass(prefix + '_parent')) {
          //Emulate menu close if set
          $($this.btn).click();
        }
      });

      //also close on click if parent links are set
      if (settings.closeOnClick && settings.allowParentLinks) {
        item.children('a').children('a').click(function (event) {
          //Emulate menu close
          $($this.btn).click();
        });
        item.find('.' + prefix + '_parent-link a:not(.' + prefix + '_item)').click(function (event) {
          //Emulate menu close
          $($this.btn).click();
        });
      }
    });

    // structure is in place, now hide appropriate items
    $(items).each(function () {
      var data = $(this).data('menu');
      if (!settings.showChildren) {
        $this._visibilityToggle(data.children, null, false, null, true);
      }
    });

    // finally toggle entire menu
    $this._visibilityToggle($this.mobileNav, null, false, 'init', true);

    // accessibility for menu button
    $this.mobileNav.attr('role', 'menu');

    // outline prevention when using mouse
    $(document).mousedown(function () {
      $this._outlines(false);
    });
    $(document).keyup(function () {
      $this._outlines(true);
    });

    // menu button click
    $($this.btn).click(function (e) {
      e.preventDefault();
      $this._menuToggle();
    });

    // click on menu parent
    $this.mobileNav.on('click', '.' + prefix + '_item', function (e) {
      e.preventDefault();
      $this._itemClick($(this));
    });

    // check for keyboard events on menu button and menu parents
    $($this.btn).keydown(function (e) {
      var ev = e || event;
      switch (ev.keyCode) {
        case Keyboard.ENTER:
        case Keyboard.SPACE:
        case Keyboard.DOWN:
          e.preventDefault();
          if (ev.keyCode !== Keyboard.DOWN || !$($this.btn).hasClass(prefix + '_open')) {
            $this._menuToggle();
          }
          $($this.btn).next().find('[role="menuitem"]').first().focus();
          break;
      }
    });
    $this.mobileNav.on('keydown', '.' + prefix + '_item', function (e) {
      var ev = e || event;
      switch (ev.keyCode) {
        case Keyboard.ENTER:
          e.preventDefault();
          $this._itemClick($(e.target));
          break;
        case Keyboard.RIGHT:
          e.preventDefault();
          if ($(e.target).parent().hasClass(prefix + '_collapsed')) {
            $this._itemClick($(e.target));
          }
          $(e.target).next().find('[role="menuitem"]').first().focus();
          break;
      }
    });
    $this.mobileNav.on('keydown', '[role="menuitem"]', function (e) {
      var ev = e || event;
      switch (ev.keyCode) {
        case Keyboard.DOWN:
          e.preventDefault();
          var allItems = $(e.target).parent().parent().children().children('[role="menuitem"]:visible');
          var idx = allItems.index(e.target);
          var nextIdx = idx + 1;
          if (allItems.length <= nextIdx) {
            nextIdx = 0;
          }
          var next = allItems.eq(nextIdx);
          next.focus();
          break;
        case Keyboard.UP:
          e.preventDefault();
          var allItems = $(e.target).parent().parent().children().children('[role="menuitem"]:visible');
          var idx = allItems.index(e.target);
          var next = allItems.eq(idx - 1);
          next.focus();
          break;
        case Keyboard.LEFT:
          e.preventDefault();
          if ($(e.target).parent().parent().parent().hasClass(prefix + '_open')) {
            var parent = $(e.target).parent().parent().prev();
            parent.focus();
            $this._itemClick(parent);
          } else if ($(e.target).parent().parent().hasClass(prefix + '_nav')) {
            $this._menuToggle();
            $($this.btn).focus();
          }
          break;
        case Keyboard.ESCAPE:
          e.preventDefault();
          $this._menuToggle();
          $($this.btn).focus();
          break;
      }
    });

    // allow links clickable within parent tags if set
    if (settings.allowParentLinks && settings.nestedParentLinks) {
      $('.' + prefix + '_item a').click(function (e) {
        e.stopImmediatePropagation();
      });
    }
  };

  //toggle menu
  Plugin.prototype._menuToggle = function (el) {
    var $this = this;
    var btn = $this.btn;
    var mobileNav = $this.mobileNav;
    if (btn.hasClass(prefix + '_collapsed')) {
      btn.removeClass(prefix + '_collapsed');
      btn.addClass(prefix + '_open');
    } else {
      btn.removeClass(prefix + '_open');
      btn.addClass(prefix + '_collapsed');
    }
    btn.addClass(prefix + '_animating');
    $this._visibilityToggle(mobileNav, btn.parent(), true, btn);
  };

  // toggle clicked items
  Plugin.prototype._itemClick = function (el) {
    var $this = this;
    var settings = $this.settings;
    var data = el.data('menu');
    if (!data) {
      data = {};
      data.arrow = el.children('.' + prefix + '_arrow');
      data.ul = el.next('ul');
      data.parent = el.parent();
      //Separated parent link structure
      if (data.parent.hasClass(prefix + '_parent-link')) {
        data.parent = el.parent().parent();
        data.ul = el.parent().next('ul');
      }
      el.data('menu', data);
    }
    if (data.parent.hasClass(prefix + '_collapsed')) {
      data.arrow.html(settings.openedSymbol);
      data.parent.removeClass(prefix + '_collapsed');
      data.parent.addClass(prefix + '_open');
      data.parent.addClass(prefix + '_animating');
      $this._visibilityToggle(data.ul, data.parent, true, el);
    } else {
      data.arrow.html(settings.closedSymbol);
      data.parent.addClass(prefix + '_collapsed');
      data.parent.removeClass(prefix + '_open');
      data.parent.addClass(prefix + '_animating');
      $this._visibilityToggle(data.ul, data.parent, true, el);
    }
  };

  // toggle actual visibility and accessibility tags
  Plugin.prototype._visibilityToggle = function (el, parent, animate, trigger, init) {
    var $this = this;
    var settings = $this.settings;
    var items = $this._getActionItems(el);
    var duration = 0;
    if (animate) {
      duration = settings.duration;
    }
    function afterOpen(trigger, parent) {
      $(trigger).removeClass(prefix + '_animating');
      $(parent).removeClass(prefix + '_animating');

      //Fire afterOpen callback
      if (!init) {
        settings.afterOpen(trigger);
      }
    }
    function afterClose(trigger, parent) {
      el.attr('aria-hidden', 'true');
      items.attr('tabindex', '-1');
      $this._setVisAttr(el, true);
      el.hide(); //jQuery 1.7 bug fix

      $(trigger).removeClass(prefix + '_animating');
      $(parent).removeClass(prefix + '_animating');

      //Fire init or afterClose callback
      if (!init) {
        settings.afterClose(trigger);
      } else if (trigger == 'init') {
        settings.init();
      }
    }
    if (el.hasClass(prefix + '_hidden')) {
      el.removeClass(prefix + '_hidden');
      //Fire beforeOpen callback
      if (!init) {
        settings.beforeOpen(trigger);
      }
      if (settings.animations === 'jquery') {
        el.stop(true, true).slideDown(duration, settings.easingOpen, function () {
          afterOpen(trigger, parent);
        });
      } else if (settings.animations === 'velocity') {
        el.velocity("finish").velocity("slideDown", {
          duration: duration,
          easing: settings.easingOpen,
          complete: function complete() {
            afterOpen(trigger, parent);
          }
        });
      }
      el.attr('aria-hidden', 'false');
      items.attr('tabindex', '0');
      $this._setVisAttr(el, false);
    } else {
      el.addClass(prefix + '_hidden');

      //Fire init or beforeClose callback
      if (!init) {
        settings.beforeClose(trigger);
      }
      if (settings.animations === 'jquery') {
        el.stop(true, true).slideUp(duration, this.settings.easingClose, function () {
          afterClose(trigger, parent);
        });
      } else if (settings.animations === 'velocity') {
        el.velocity("finish").velocity("slideUp", {
          duration: duration,
          easing: settings.easingClose,
          complete: function complete() {
            afterClose(trigger, parent);
          }
        });
      }
    }
  };

  // set attributes of element and children based on visibility
  Plugin.prototype._setVisAttr = function (el, hidden) {
    var $this = this;

    // select all parents that aren't hidden
    var nonHidden = el.children('li').children('ul').not('.' + prefix + '_hidden');

    // iterate over all items setting appropriate tags
    if (!hidden) {
      nonHidden.each(function () {
        var ul = $(this);
        ul.attr('aria-hidden', 'false');
        var items = $this._getActionItems(ul);
        items.attr('tabindex', '0');
        $this._setVisAttr(ul, hidden);
      });
    } else {
      nonHidden.each(function () {
        var ul = $(this);
        ul.attr('aria-hidden', 'true');
        var items = $this._getActionItems(ul);
        items.attr('tabindex', '-1');
        $this._setVisAttr(ul, hidden);
      });
    }
  };

  // get all 1st level items that are clickable
  Plugin.prototype._getActionItems = function (el) {
    var data = el.data("menu");
    if (!data) {
      data = {};
      var items = el.children('li');
      var anchors = items.find('a');
      data.links = anchors.add(items.find('.' + prefix + '_item'));
      el.data('menu', data);
    }
    return data.links;
  };
  Plugin.prototype._outlines = function (state) {
    if (!state) {
      $('.' + prefix + '_item, .' + prefix + '_btn').css('outline', 'none');
    } else {
      $('.' + prefix + '_item, .' + prefix + '_btn').css('outline', '');
    }
  };
  Plugin.prototype.toggle = function () {
    var $this = this;
    $this._menuToggle();
  };
  Plugin.prototype.open = function () {
    var $this = this;
    if ($this.btn.hasClass(prefix + '_collapsed')) {
      $this._menuToggle();
    }
  };
  Plugin.prototype.close = function () {
    var $this = this;
    if ($this.btn.hasClass(prefix + '_open')) {
      $this._menuToggle();
    }
  };
  $.fn[mobileMenu] = function (options) {
    var args = arguments;

    // Is the first parameter an object (options), or was omitted, instantiate a new instance
    if (options === undefined || _typeof(options) === 'object') {
      return this.each(function () {
        // Only allow the plugin to be instantiated once due to methods
        if (!$.data(this, 'plugin_' + mobileMenu)) {
          // if it has no instance, create a new one, pass options to our plugin constructor,
          // and store the plugin instance in the elements jQuery data object.
          $.data(this, 'plugin_' + mobileMenu, new Plugin(this, options));
        }
      });

      // If is a string and doesn't start with an underscore or 'init' function, treat this as a call to a public method.
    } else if (typeof options === 'string' && options[0] !== '_' && options !== 'init') {
      // Cache the method call to make it possible to return a value
      var returns;
      this.each(function () {
        var instance = $.data(this, 'plugin_' + mobileMenu);

        // Tests that there's already a plugin-instance and checks that the requested public method exists
        if (instance instanceof Plugin && typeof instance[options] === 'function') {
          // Call the method of our plugin instance, and pass it the supplied arguments.
          returns = instance[options].apply(instance, Array.prototype.slice.call(args, 1));
        }
      });

      // If the earlier cached method gives a value back return the value, otherwise return this to preserve chainability.
      return returns !== undefined ? returns : this;
    }
  };
})(jQuery, document, window);

/***/ }),

/***/ "./public/frontend/amazy/js/mail-script.js":
/*!*************************************************!*\
  !*** ./public/frontend/amazy/js/mail-script.js ***!
  \*************************************************/
/***/ (() => {

// -------   Mail Send ajax

$(document).ready(function () {
  var form = $('#myForm'); // contact form
  var submit = $('.submit-btn'); // submit button
  var alert = $('.alert-msg'); // alert div for show alert message

  // form submit event
  form.on('submit', function (e) {
    e.preventDefault(); // prevent default form submit

    $.ajax({
      url: 'mail.php',
      // form action url
      type: 'POST',
      // form submit method get/post
      dataType: 'html',
      // request type html/json/xml
      data: form.serialize(),
      // serialize form data
      beforeSend: function beforeSend() {
        alert.fadeOut();
        submit.html('Sending....'); // change submit button text
      },

      success: function success(data) {
        alert.html(data).fadeIn(); // fade in response data
        form.trigger('reset'); // reset form
        submit.attr("style", "display: none !important");
        ; // reset submit button text
      },

      error: function error(e) {}
    });
  });
});

/***/ }),

/***/ "./public/frontend/amazy/js/main.js":
/*!******************************************!*\
  !*** ./public/frontend/amazy/js/main.js ***!
  \******************************************/
/***/ (() => {

(function ($) {
  "use strict";

  $(window).on("load", function () {
    setTimeout(function () {
      $(".newsletter_form_wrapper").addClass("newsletter_active").fadeIn();
    }, 1500);
  });

  //progress-bar
  $(window).on('load', function (e) {
    $.each($('.progress-bar'), function () {
      $(this).css('width', $(this).attr('aria-valuenow') + '%');
    });
  });

  //* Navbar Fixed
  var nav_offset_top = $("header").height() + 50;
  /*-------------------------------------------------------------------------------
  Navbar
  -------------------------------------------------------------------------------*/
  $(window).on("scroll", function () {
    var scroll = $(window).scrollTop();
    if (scroll < 400) {
      $("#sticky-header").removeClass("navbar_fixed");
      $("#back-top").fadeOut(500);
    } else {
      $("#sticky-header").addClass("navbar_fixed");
      $("#back-top").fadeIn(500);
    }
  });
  // search home6

  // back to top
  $("#back-top a").on("click", function () {
    $('html').css('scroll-behavior', 'inherit');
    $("body,html").animate({
      scrollTop: 0
    }, 1000);
    setTimeout(function () {
      $('html').removeAttr('style');
    }, 1000);
    return false;
  });

  // #######################
  //   MOBILE MENU
  // #######################

  var menu = $("ul#mobile-menu");
  if (menu.length) {
    menu.slicknav({
      prependTo: ".mobile_menu",
      closedSymbol: '<i class="ti-angle-down"></i>',
      openedSymbol: '<i class="ti-angle-up"></i>'
    });
  }
  $(document).ready(function () {
    if ($("#scrolling_nav").length > 0) {
      $("#scrolling_nav").onePageNav();
    }
  });
  // .scrollbar activation
  if ($(".full_with_menu").length > 0) {
    var ps = new PerfectScrollbar(".full_with_menu", {
      wheelSpeed: 0.5,
      wheelPropagation: 0,
      minScrollbarLength: 10
    });
  }

  //active sidebar
  $(".sidebar_icon").on("click", function () {
    $(".sidebar").toggleClass("active_sidebar");
  });
  $(".sidebar_close_icon i").on("click", function () {
    $(".sidebar").removeClass("active_sidebar");
  });

  //remove sidebar
  $(document).click(function (event) {
    if (!$(event.target).closest(".sidebar_icon, .sidebar").length) {
      $("body").find(".sidebar").removeClass("active_sidebar");
    }
  });

  // home 5 search
  $(".search_btn").on("click", function () {
    $(this).parent().toggleClass("active");
    $("i", this).toggleClass("ti-search ti-close");
  });
  $(document).click(function (event) {
    if (!$(event.target).closest(".search_btn, .search_field").length) {
      $("body").find(".search_field").removeClass("active");
      $("body").find(".search_btn i").toggleClass("ti-close ti-search ");
    }
  });

  //notification
  $(".notification_open > a").on("click", function () {
    $(".notification_area").toggleClass("active");
  });
  //remove sidebar
  $(document).click(function (event) {
    if (!$(event.target).closest(".notification_area,.notification_open > a").length) {
      $("body").find(".notification_area").removeClass("active");
    }
  });
  //active courses option
  $(".courses_option, .collaps_icon").on("click", function () {
    $(this).parent(".custom_select, .collaps_part").toggleClass("active");
  });
  $(document).click(function (event) {
    if (!$(event.target).closest(".custom_select").length) {
      $("body").find(".custom_select").removeClass("active");
    }
    if (!$(event.target).closest(".collaps_part").length) {
      $("body").find(".collaps_part").removeClass("active");
    }
  });

  // elemts sidebar
  $(".elemnts_sidebar_toogler").on("click", function () {
    $(".elemts_sidebar").toggleClass("active");
  });

  //remove sidebar
  $(document).click(function (event) {
    if (!$(event.target).closest(".elemnts_sidebar_toogler, .elemts_sidebar").length) {
      $("body").find(".elemts_sidebar").removeClass("active");
    }
  });

  // for MENU POPUP

  $(document).ready(function () {
    $(document).on("click", ".chart_close", function () {
      $(".shoping_cart ,.dark_overlay").removeClass("active");
    });
    $(document).on("click", ".side_chartView_total", function () {
      $(".shoping_cart ,.dark_overlay").toggleClass("active");
    });
    // sidebar menu open
    $(document).on("click", ".sidebar_menu_toggle", function () {
      $(".sidebar_menu_wrapper").toggleClass("sidebar_open");
    });

    // catgory toggle
    $(document).on("click", ".category_toggler", function () {
      $("#product_category_chose").toggleClass("active");
    });
    $(document).on("click", "#catgory_sidebar_closeIcon", function () {
      $("#product_category_chose").removeClass("active");
    });
  });
  $(document).click(function (event) {
    if (!$(event.target).closest(".sidebar_menu_toggle ,.sidebar_menu_wrapper").length) {
      $("body").find(".sidebar_menu_wrapper").removeClass("sidebar_open");
    }
  });
  $(document).click(function (event) {
    if (!$(event.target).closest(".category_toggler ,#product_category_chose").length) {
      $("body").find("#product_category_chose").removeClass("active");
    }
  });
  // hideporobar
  $(".close_promobar").on("click", function () {
    $(this).closest(".promotion_bar").remove();
  });
  // language
  $(".language_toggle_btn").on("click", function () {
    $(this).siblings(".language_toggle_box").toggleClass("active");
  });
  $(document).click(function (event) {
    if (!$(event.target).closest(".language_toggle_btn ,.language_toggle_box").length) {
      $("body").find(".language_toggle_box").removeClass("active");
    }
  });
  // summernote
  $(document).ready(function () {
    if ($("#summernote").length > 0) {
      $("#summernote").summernote({
        placeholder: "Hello stand alone ui",
        tabsize: 2,
        height: 150,
        toolbar: [["style", ["style"]], ["font", ["bold", "underline", "clear"]], ["color", ["color"]], ["para", ["ul", "ol", "paragraph"]], ["table", ["table"]], ["insert", ["link", "picture", "video"]], ["view", ["fullscreen", "codeview", "help"]]]
      });
    }
  });
  // select
  if ($(".small_select").length > 0) {
    $(".small_select").niceSelect();
  }
  if ($(".theme_select").length > 0) {
    $(".theme_select").niceSelect();
  }
  if ($(".amaz_select").length > 0) {
    $(".amaz_select").niceSelect();
  }
  if ($(".amaz_select2").length > 0) {
    $(".amaz_select2").niceSelect();
  }
  if ($(".amaz_select3").length > 0) {
    $(".amaz_select3").niceSelect();
  }
  if ($(".amaz_select4").length > 0) {
    $(".amaz_select4").niceSelect();
  }
  if ($(".amaz_select5").length > 0) {
    $(".amaz_select5").niceSelect();
  }
  if ($(".amaz_select6").length > 0) {
    $(".amaz_select6").niceSelect();
  }
  if ($(".home10_select2").length > 0) {
    $(".home10_select2").niceSelect();
  }
  $(".product_size li").on("click", function (event) {
    $(this).siblings(".active").removeClass("active");
    $(this).addClass("active");
    event.preventDefault();
  });
  // BARFILLER
  $(document).ready(function () {
    var proBar = $("#bar1");
    if (proBar.length) {
      proBar.barfiller({
        barColor: "#fb6600",
        duration: 2000
      });
    }
    var proBar = $("#bar2");
    if (proBar.length) {
      proBar.barfiller({
        barColor: "#fb6600",
        duration: 2100
      });
    }
    var proBar = $("#bar3");
    if (proBar.length) {
      proBar.barfiller({
        barColor: "#fb6600",
        duration: 2200
      });
    }
  });

  // #######################
  //  carousel_active
  // #######################
  var dir = $('html').attr('dir');
  var dir_val = false;
  if (dir == 'rtl') {
    dir_val = true;
  }
  if (".carousel_active".length > 0) {
    $(".carousel_active").owlCarousel({
      loop: true,
      margin: 30,
      items: 1,
      autoplay: true,
      navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
      nav: false,
      dots: false,
      rtl: dir_val,
      autoplayHoverPause: true,
      autoplaySpeed: 800,
      responsive: {
        0: {
          items: 2
        },
        767: {
          items: 4
        },
        992: {
          items: 5
        },
        1400: {
          items: 6
        }
      }
    });
  }
  if (".product_slide".length > 0) {
    $(".product_slide").owlCarousel({
      loop: true,
      margin: -1,
      items: 1,
      autoplay: true,
      navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
      nav: true,
      dots: false,
      rtl: dir_val,
      autoplayHoverPause: true,
      autoplaySpeed: 800,
      responsive: {
        0: {
          items: 1,
          nav: false
        },
        767: {
          items: 2
        },
        992: {
          items: 3
        },
        1400: {
          items: 4
        }
      }
    });
  }
  if (".product_slide2".length > 0) {
    $(".product_slide2").owlCarousel({
      loop: true,
      margin: -1,
      items: 1,
      autoplay: true,
      navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
      nav: false,
      dots: false,
      rtl: dir_val,
      autoplayHoverPause: true,
      autoplaySpeed: 800,
      responsive: {
        0: {
          items: 1,
          nav: false
        },
        767: {
          items: 2
        },
        992: {
          items: 3
        },
        1400: {
          items: 4
        }
      }
    });
  }
  if (".brand_active".length > 0) {
    $(".brand_active").owlCarousel({
      loop: true,
      margin: -1,
      items: 1,
      autoplay: true,
      navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
      nav: false,
      dots: false,
      rtl: true,
      autoplayHoverPause: true,
      autoplaySpeed: 800,
      responsive: {
        0: {
          items: 1
        },
        767: {
          items: 3
        },
        992: {
          items: 4
        },
        1400: {
          items: 5
        }
      }
    });
  }

  /* -------------------------------------------------------------------------- */
  /*                               AmazcartUi                              */
  /* -------------------------------------------------------------------------- */
  if (".bannerUi_active".length > 0) {
    $(".bannerUi_active").owlCarousel({
      loop: true,
      margin: 0,
      items: 1,
      autoplay: true,
      navText: ['<i class="ti-angle-left"></i>', '<i class="ti-angle-right"></i>'],
      nav: false,
      rtl: dir_val,
      autoplayHoverPause: true,
      autoplaySpeed: 800,
      responsive: {
        0: {
          items: 1,
          nav: false,
          dots: false
        },
        992: {
          items: 1,
          nav: false,
          dots: false
        },
        1200: {
          items: 1,
          dots: true
        }
      }
    });
  }
  if (".bannerUi_Recommendation_active".length > 0) {
    $(".bannerUi_Recommendation_active").owlCarousel({
      loop: true,
      margin: -1,
      items: 1,
      autoplay: true,
      navText: ['<i class="ti-angle-left"></i>', '<i class="ti-angle-right"></i>'],
      nav: true,
      dots: false,
      rtl: dir_val,
      autoplayHoverPause: true,
      autoplaySpeed: 800,
      responsive: {
        0: {
          items: 2,
          nav: false
        },
        768: {
          items: 2
        },
        992: {
          items: 3
        },
        1200: {
          items: 4
        },
        1640: {
          items: 5
        }
      }
    });
  }
  if (".amaz_fieature_active".length > 0) {
    $(".amaz_fieature_active").owlCarousel({
      loop: true,
      margin: 0,
      items: 1,
      autoplay: true,
      // stagePadding: 1,
      navText: ['<i class="ti-angle-left"></i>', '<i class="ti-angle-right"></i>'],
      nav: true,
      dots: false,
      rtl: dir_val,
      autoplayHoverPause: true,
      autoplaySpeed: 800,
      responsive: {
        0: {
          items: 2,
          margin: 10
        },
        390: {
          items: 2
        },
        992: {
          items: 3
        },
        1200: {
          items: 4
        },
        1640: {
          items: 5
        }
      }
    });
  }
  if (".trending_product_active".length > 0) {
    var count = $('.productQtyCount').val();
    var val = false;
    if (count > 5) {
      val = true;
    }
    $(".trending_product_active").owlCarousel({
      loop: val,
      margin: 30,
      items: 1,
      autoplay: true,
      navText: ['<i class="ti-angle-left"></i>', '<i class="ti-angle-right"></i>'],
      nav: false,
      dots: false,
      rtl: dir_val,
      autoplayHoverPause: true,
      autoplaySpeed: 800,
      responsive: {
        0: {
          items: 2,
          nav: false,
          margin: 10
        },
        768: {
          items: 2
        },
        992: {
          items: 3
        },
        1200: {
          items: 4
        },
        1580: {
          items: 5
        }
      }
    });
  }
  // counter
  $(".counter").counterUp({
    delay: 10,
    time: 10000
  });

  /* magnificPopup img view */
  $(".popup-image").magnificPopup({
    type: "image",
    gallery: {
      enabled: true
    }
  });

  /* magnificPopup video view */
  $(".popup-video").magnificPopup({
    type: "iframe",
    mainClass: "mfp-fade",
    removalDelay: 160,
    preloader: false,
    fixedContentPos: false
  });
  $("#container").imagesLoaded(function () {
    // for filter
    // init Isotope
    var $grid = $(".grid_active").isotope({
      itemSelector: ".grid-item",
      percentPosition: true,
      masonry: {
        // use outer width of grid-sizer for columnWidth
        columnWidth: 1,
        gutter: 0
      }
    });

    // filter items on button click
    $(".portfolio-menu").on("click", "button", function () {
      var filterValue = $(this).attr("data-filter");
      $grid.isotope({
        filter: filterValue
      });
    });

    //for menu active class
    $(".portfolio-menu button").on("click", function (event) {
      $(this).siblings(".active").removeClass("active");
      $(this).addClass("active");
      event.preventDefault();
    });
    //for wallet_payent_box active class
    $(".wallet_payent_box button").on("click", function (event) {
      $('.wallet_elemnt').removeClass("active");
      $(this).addClass("active");
    });
  });
  /*===============================================
        Parallax business_image
  ================================================*/
  if ($(".man_img").length > 0) {
    $(".man_img").parallax({
      scalarX: 7.0,
      scalarY: 7.0
    });
  }
  $(".btnNext").click(function () {
    $(".nav-pills .active").parent().next("li").find("a").trigger("click");
  });
  $(".btnPrevious").click(function () {
    $(".nav-pills .active").parent().prev("li").find("a").trigger("click");
  });
  if ($("#count_down").length > 0) {
    $("#count_down").countdown("2021/3/10", function (event) {
      $(this).html(event.strftime('<div class="single_count"><span>%D</span></div><span class="count_separator">:</span><div class="single_count"><span>%H</span></div><span class="count_separator">:</span><div class="single_count"><span>%M</span></div><span class="count_separator">:</span><div class="single_count"><span>%S</span></div>'));
    });
  }
  if ($("#count_down2").length > 0) {
    $("#count_down2").countdown("2021/3/10", function (event) {
      $(this).html(event.strftime('<div class="single_count"><span>%D</span><p>Days</p></div><div class="single_count"><span>%H</span><p>Hours</p></div><div class="single_count"><span>%M</span><p>Minute</p></div><div class="single_count"><span>%S</span><p>Second</p></div>'));
    });
  }
  if ($("#count_small").length > 0) {
    $("#count_small").countdown("2021/3/10", function (event) {
      $(this).html(event.strftime('<div class="single_count"><span>%D</span><p>Days</p></div><div class="single_count"><span>%H</span><p>Hrs</p></div><div class="single_count"><span>%M</span><p>Mins</p></div><div class="single_count"><span>%S</span><p>Secs</p></div>'));
    });
  }
  if ($("#week_countdown").length > 0) {
    $("#week_countdown").countdown("2022/3/10", function (event) {
      $(this).html(event.strftime('<div class="single_count"><span>%w</span><p>Weeks</p></div><div class="single_count"><span>%D</span><p>Days</p></div><div class="single_count"><span>%H</span><p>Hrs</p></div><div class="single_count"><span>%M</span><p>Mins</p></div><div class="single_count"><span>%S</span><p>Secs</p></div>'));
    });
  }
  if ($("#week_countdown2").length > 0) {
    $("#week_countdown2").countdown("2022/10/10", function (event) {
      $(this).html(event.strftime('<div class="single_count"><span>%w</span><p>Weeks</p></div><div class="single_count"><span>%D</span><p>Days</p></div><div class="single_count"><span>%H</span><p>Hrs</p></div><div class="single_count"><span>%M</span><p>Mins</p></div><div class="single_count"><span>%S</span><p>Secs</p></div>'));
    });
  }
  $(document).ready(function () {
    $("#start_datepicker").datepicker();
    $("#end_datepicker").datepicker();
    $("#start_datepicker2").datepicker();
    $("#end_datepicker2").datepicker();
  });
  $(".add_collaspe_btn").on("click", function () {
    $(this).hide();
    $(this).closest(".single_apply_wrapper").find(".collaspe_form").slideDown(200);
  });
  $(".hide_collape_form").on("click", function () {
    $(this).closest(".single_apply_wrapper").find(".collaspe_form").slideUp(500);
    $(this).closest(".single_apply_wrapper").find(".add_collaspe_btn").show();
  });
  $(".variant-slider").owlCarousel({
    loop: true,
    items: 6,
    autoplay: false,
    margin: 4,
    navText: ['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
    nav: true,
    dots: true,
    rtl: false,
    autoplayHoverPause: true,
    autoplaySpeed: 800,
    responsive: {
      0: {
        items: 4
      },
      768: {
        items: 6
      },
      992: {
        items: 4
      },
      1200: {
        items: 4
      },
      1400: {
        items: 4
      },
      1581: {
        items: 6
      }
    }
  });

  // PRODUCT DETAILS CROUSEL
  $(function () {
    // Card's slider
    var $carousel = $(".slider-for");
    $carousel.slick({
      slidesToShow: 1,
      slidesToScroll: 1,
      arrows: true,
      fade: true,
      asNavFor: ".slider-nav",
      centerMode: true,
      pauseOnHover: true,
      useTransform: false,
      autoplay: false,
      infinite: true,
      prevArrow: "<button type='button' class='slick-prev pull-left slick_only_mobile'><i class='fa fa-angle-left' aria-hidden='true'></i></button>",
      nextArrow: "<button type='button' class='slick-next pull-right slick_only_mobile'><i class='fa fa-angle-right' aria-hidden='true'></i></button>"
    });
    $(".slider-nav").slick({
      slidesToShow: 3,
      slidesToScroll: 1,
      asNavFor: ".slider-for",
      dots: false,
      centerPadding: "0px",
      centerMode: false,
      useTransform: false,
      autoplay: false,
      infinite: true,
      focusOnSelect: true,
      prevArrow: "<button type='button' class='slick-prev pull-left'><i class='fa fa-angle-left' aria-hidden='true'></i></button>",
      nextArrow: "<button type='button' class='slick-next pull-right'><i class='fa fa-angle-right' aria-hidden='true'></i></button>"
    });
    $(".slider-nav-new").slick({
      slidesToShow: 3,
      slidesToScroll: 1,
      asNavFor: ".slider-for",
      dots: false,
      centerPadding: "0px",
      centerMode: true,
      useTransform: false,
      autoplay: false,
      infinite: true,
      focusOnSelect: true,
      prevArrow: "<button type='button' class='slick-prev pull-left'><i class='fa fa-angle-left' aria-hidden='true'></i></button>",
      nextArrow: "<button type='button' class='slick-next pull-right'><i class='fa fa-angle-right' aria-hidden='true'></i></button>"
    });
  });
  $(".close_modal").on("click", function () {
    $(".newsletter_form_wrapper").removeClass("newsletter_active");
  });
  $(document).click(function (event) {
    if (!$(event.target).closest(".newsletter_form_inner").length) {
      $("body").find(".newsletter_form_wrapper").removeClass("newsletter_active");
    }
  });
  $(".Categories_togler").on("click", function () {
    $(".catdropdown_menu").toggleClass("dropdown_menu_active");
  });
  $(document).click(function (event) {
    if (!$(event.target).closest(".Categories_togler, .catdropdown_menu").length) {
      $("body").find(".catdropdown_menu").removeClass("dropdown_menu_active");
    }
  });

  // search home6
  $(".home6_search_toggle").on("click", function () {
    $(".menu_search_popup").toggleClass("active");
  });
  $(".home6_search_hide").on("click", function () {
    $(".menu_search_popup").removeClass("active");
  });
  $(document).click(function (event) {
    if (!$(event.target).closest(".home6_search_toggle, .menu_search_popup").length) {
      $("body").find(".menu_search_popup").removeClass("active");
    }
  });

  // FOR SIGNUP MODAL PROBLEM
  $(document).on("show.bs.modal", function (event) {
    if (!event.relatedTarget) {
      $(".modal").not(event.target).modal("hide");
    }
    if ($(event.relatedTarget).parents(".modal").length > 0) {
      $(event.relatedTarget).parents(".modal").modal("hide");
    }
  });
  $(document).on("shown.bs.modal", function (event) {
    if ($("body").hasClass("modal-open") == false) {
      $("body").addClass("modal-open");
    }
  });

  // active dashboard menu
  jQuery(function ($) {
    var path = window.location.href;
    $(".dashboard_sidebar_menuList a").each(function () {
      if (this.href === path) {
        $(this).addClass("active");
      }
    });
  });
  $(document).ready(function () {
    $("#date_dynamic").html(new Date().getFullYear());
  });

  // chat js
  $(document).on('click', '.chat-caret', function (e) {
    $(this).addClass('hide');
    $('.chat-caret-details').removeClass('hide');
    $('.chat-overlay').fadeIn('fast');
    $('body').addClass('overflow-hidden');
  });
  $(document).on('click', '#close', function (e) {
    $('.chat-caret').removeClass('hide');
    $('.chat-caret-details').addClass('hide');
    $('.chat-overlay').fadeOut('fast');
    $('body').removeClass('overflow-hidden');
  });
})(jQuery);
function config(key, default_value) {
  var value = _.get(_config, key);
  if (typeof value == 'undefined') {
    return default_value;
  }
  return value;
}
function user_currency(key, default_value) {
  var value = _.get(_user_currency, key);
  if (typeof value == 'undefined') {
    return default_value;
  }
  return value;
}
function formatMoney(amount) {
  var decimalCount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  var decimal = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ".";
  var thousands = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : ",";
  try {
    decimalCount = Math.abs(decimalCount);
    decimalCount = isNaN(decimalCount) ? 2 : decimalCount;
    var negativeSign = amount < 0 ? "-" : "";
    var i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
    var j = i.length > 3 ? i.length % 3 : 0;
    var number = negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    return numbertrans(number);
  } catch (e) {
    console.log(e);
  }
}
window.currency_format = function (amount) {
  if (_user_currency.length !== 0) {
    if (config('currency_symbol_position') === 'left') {
      return user_currency('symbol') + formatMoney(parseFloat(amount) * parseFloat(user_currency('convert_rate')), config('decimal_limit'));
    } else if (config('currency_symbol_position') === 'left_with_space') {
      return user_currency('symbol') + " " + formatMoney(parseFloat(amount) * parseFloat(user_currency('convert_rate')), config('decimal_limit'));
    } else if (config('currency_symbol_position') === 'right') {
      return formatMoney(parseFloat(amount) * parseFloat(user_currency('convert_rate')), config('decimal_limit')) + user_currency('symbol');
    } else if (config('currency_symbol_position') === 'right_with_space') {
      return formatMoney(parseFloat(amount) * parseFloat(user_currency('convert_rate')), config('decimal_limit')) + " " + user_currency('symbol');
    }
  } else if (config('currency_symbol')) {
    if (config('currency_symbol_position') === 'left') {
      return config('currency_symbol') + formatMoney(parseFloat(amount), config('decimal_limit'));
    } else if (config('currency_symbol_position') === 'left_with_space') {
      return config('currency_symbol') + " " + formatMoney(parseFloat(amount), config('decimal_limit'));
    } else if (config('currency_symbol_position') === 'right') {
      return formatMoney(parseFloat(amount), config('decimal_limit')) + config('currency_symbol');
    } else if (config('currency_symbol_position') === 'right_with_space') {
      return formatMoney(parseFloat(amount), config('decimal_limit')) + " " + config('currency_symbol');
    }
  } else {
    return "$ " + formatMoney(parseFloat(amount), 2);
  }
};
$(function () {
  // Add read more functionality at product details

  var screenWidth = $(window).width();
  $(window).on("resize", function () {
    screenWidth = $(window).width();
    if (screenWidth < 767) {
      toggleShowMore();
    }
    if (screenWidth > 768) {
      $(".product_description_container").removeClass("short_description");
      $('.show_full_btn').addClass('d-none');
    }
  });
  if (screenWidth < 767) {
    toggleShowMore();
  }
  function toggleShowMore() {
    var descriptionHeight = $('.product_description_container .contents').height();
    if (descriptionHeight > 300) {
      $('.show_full_btn').removeClass('d-none');
      $(".product_description_container").addClass("short_description");
    }
    $(document).on("click", "#show_full_details", function () {
      $('.product_description_container').toggleClass('show_full_details');
      if ($(this).hasClass('show_less')) {
        $(this).removeClass('show_less');
        $(this).text('Show Less');
        $('.product_description_container').css("max-height", descriptionHeight + "px");
        $(".product_description_container").removeClass("short_description");
      } else {
        $(this).addClass('show_less');
        $(this).text('Show More');
        $('.product_description_container').css("max-height", "300px");
        $(".product_description_container").addClass("short_description");
      }
    });
  }

  // Rating active

  $(".rating_filter_area button").on("click", function () {
    if ($(this).hasClass('active')) {
      $(this).removeClass('active');
    } else {
      $(".rating_filter_area button").removeClass("active");
      $(this).addClass('active');
    }
  });

  // Video Popup play

  $(".review_video_item").magnificPopup({
    type: "iframe",
    gallery: {
      enabled: false
    },
    scroll: false,
    delegate: "a"
  });
});

/***/ }),

/***/ "./public/frontend/amazy/js/nice-select.min.js":
/*!*****************************************************!*\
  !*** ./public/frontend/amazy/js/nice-select.min.js ***!
  \*****************************************************/
/***/ (() => {

/*  jQuery Nice Select - v1.1.0
https://github.com/hernansartorio/jquery-nice-select
Made by Hernán Sartorio  */

(function ($) {
  $.fn.niceSelect = function (method) {
    // Methods
    if (typeof method == "string") {
      if (method == "update") {
        this.each(function () {
          var $select = $(this);
          var $dropdown = $(this).next(".nice-select");
          var open = $dropdown.hasClass("open");
          if ($dropdown.length) {
            $dropdown.remove();
            create_nice_select($select);
            if (open) {
              $select.next().trigger("click");
            }
          }
        });
      } else if (method == "destroy") {
        this.each(function () {
          var $select = $(this);
          var $dropdown = $(this).next(".nice-select");
          if ($dropdown.length) {
            $dropdown.remove();
            $select.css("display", "");
          }
        });
        if ($(".nice-select").length == 0) {
          $(document).off(".nice_select");
        }
      } else {
        console.log('Method "' + method + '" does not exist.');
      }
      return this;
    }

    // Hide native select
    this.hide();

    // Create custom markup
    this.each(function () {
      var $select = $(this);
      if (!$select.next().hasClass("nice-select")) {
        create_nice_select($select);
      }
    });
    function create_nice_select($select) {
      $select.after($("<div></div>").addClass("nice-select").addClass($select.attr("class") || "").addClass($select.attr("disabled") ? "disabled" : "").addClass($select.attr("multiple") ? "has-multiple" : "").attr("tabindex", $select.attr("disabled") ? null : "0").html($select.attr("multiple") ? '<span class="multiple-options"></span><div class="nice-select-search-box"><input type="text" class="nice-select-search" placeholder="Search..."/></div><ul class="list"></ul>' : '<span class="current"></span><div class="nice-select-search-box"><input type="text" class="nice-select-search" placeholder="Search..."/></div><ul class="list"></ul>'));
      var $dropdown = $select.next();
      var $options = $select.find("option");
      if ($select.attr("multiple")) {
        var $selected = $select.find("option:selected");
        var $selected_html = "";
        $selected.each(function () {
          $selected_option = $(this);
          $selected_text = $selected_option.data("display") || $selected_option.text();
          $selected_html += '<span class="current">' + $selected_text + "</span>";
        });
        $select_placeholder = $select.data("placeholder") || $select.attr("placeholder");
        $select_placeholder = $select_placeholder == "" ? "Select" : $select_placeholder;
        $selected_html = $selected_html == "" ? $select_placeholder : $selected_html;
        $dropdown.find(".multiple-options").html($selected_html);
      } else {
        var $selected = $select.find("option:selected");
        $dropdown.find(".current").html($selected.data("display") || $selected.text());
      }
      $options.each(function (i) {
        var $option = $(this);
        var display = $option.data("display");
        $dropdown.find("ul").append($("<li></li>").attr("data-value", $option.val()).attr("data-display", display || null).addClass("option" + ($option.is(":selected") ? " selected" : "") + ($option.is(":disabled") ? " disabled" : "")).html($option.text()));
      });
    }

    /* Event listeners */

    // Unbind existing events in case that the plugin has been initialized before
    $(document).off(".nice_select");

    // Open/close
    $(document).on("click.nice_select", ".nice-select", function (event) {
      var $dropdown = $(this);
      $(".nice-select").not($dropdown).removeClass("open");
      $dropdown.toggleClass("open");
      if ($dropdown.hasClass("open")) {
        $dropdown.find(".option");
        $dropdown.find(".nice-select-search").val("");
        $dropdown.find(".nice-select-search").focus();
        $dropdown.find(".focus").removeClass("focus");
        $dropdown.find(".selected").addClass("focus");
        $dropdown.find("ul li").show();
      } else {
        $dropdown.focus();
      }
    });
    $(document).on("click", ".nice-select-search-box", function (event) {
      event.stopPropagation();
      return false;
    });
    $(document).on("keyup.nice-select-search", ".nice-select", function () {
      var $self = $(this);
      var $text = $self.find(".nice-select-search").val();
      var $options = $self.find("ul li");
      if ($text == "") $options.show();else if ($self.hasClass("open")) {
        $text = $text.toLowerCase();
        var $matchReg = new RegExp($text);
        if (0 < $options.length) {
          $options.each(function () {
            var $this = $(this);
            var $optionText = $this.text().toLowerCase();
            var $matchCheck = $matchReg.test($optionText);
            $matchCheck ? $this.show() : $this.hide();
          });
        } else {
          $options.show();
        }
      }
      $self.find(".option"), $self.find(".focus").removeClass("focus"), $self.find(".selected").addClass("focus");
    });

    // Close when clicking outside
    $(document).on("click.nice_select", function (event) {
      if ($(event.target).closest(".nice-select").length === 0) {
        $(".nice-select").removeClass("open").find(".option");
      }
    });

    // Option click
    $(document).on("click.nice_select", ".nice-select .option:not(.disabled)", function (event) {
      var $option = $(this);
      var $dropdown = $option.closest(".nice-select");
      if ($dropdown.hasClass("has-multiple")) {
        if ($option.hasClass("selected")) {
          $option.removeClass("selected");
        } else {
          $option.addClass("selected");
        }
        $selected_html = "";
        $selected_values = [];
        $dropdown.find(".selected").each(function () {
          $selected_option = $(this);
          var text = $selected_option.data("display") || $selected_option.text();
          $selected_html += '<span class="current">' + text + "</span>";
          $selected_values.push($selected_option.data("value"));
        });
        $select_placeholder = $dropdown.prev("select").data("placeholder") || $dropdown.prev("select").attr("placeholder");
        $select_placeholder = $select_placeholder == "" ? "Select" : $select_placeholder;
        $selected_html = $selected_html == "" ? $select_placeholder : $selected_html;
        $dropdown.find(".multiple-options").html($selected_html);
        $dropdown.prev("select").val($selected_values).trigger("change");
      } else {
        $dropdown.find(".selected").removeClass("selected");
        $option.addClass("selected");
        var text = $option.data("display") || $option.text();
        $dropdown.find(".current").text(text);
        $dropdown.prev("select").val($option.data("value")).trigger("change");
      }
    });

    // Keyboard events
    $(document).on("keydown.nice_select", ".nice-select", function (event) {
      var $dropdown = $(this);
      var $focused_option = $($dropdown.find(".focus") || $dropdown.find(".list .option.selected"));

      // Space or Enter
      if (event.keyCode == 32 || event.keyCode == 13) {
        if ($dropdown.hasClass("open")) {
          $focused_option.trigger("click");
        } else {
          $dropdown.trigger("click");
        }
        return false;
        // Down
      } else if (event.keyCode == 40) {
        if (!$dropdown.hasClass("open")) {
          $dropdown.trigger("click");
        } else {
          var $next = $focused_option.nextAll(".option:not(.disabled)").first();
          if ($next.length > 0) {
            $dropdown.find(".focus").removeClass("focus");
            $next.addClass("focus");
          }
        }
        return false;
        // Up
      } else if (event.keyCode == 38) {
        if (!$dropdown.hasClass("open")) {
          $dropdown.trigger("click");
        } else {
          var $prev = $focused_option.prevAll(".option:not(.disabled)").first();
          if ($prev.length > 0) {
            $dropdown.find(".focus").removeClass("focus");
            $prev.addClass("focus");
          }
        }
        return false;
        // Esc
      } else if (event.keyCode == 27) {
        if ($dropdown.hasClass("open")) {
          $dropdown.trigger("click");
        }
        // Tab
      } else if (event.keyCode == 9) {
        if ($dropdown.hasClass("open")) {
          return false;
        }
      }
    });

    // Detect CSS pointer-events support, for IE <= 10. From Modernizr.
    var style = document.createElement("a").style;
    style.cssText = "pointer-events:auto";
    if (style.pointerEvents !== "auto") {
      $("html").addClass("no-csspointerevents");
    }
    return this;
  };
})(jQuery);

/***/ }),

/***/ "./public/frontend/amazy/js/owl.carousel.min.js":
/*!******************************************************!*\
  !*** ./public/frontend/amazy/js/owl.carousel.min.js ***!
  \******************************************************/
/***/ (() => {

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/**
 * Owl Carousel v2.2.1
 * Copyright 2013-2017 David Deutsch
 * Licensed under  ()
 */
!function (a, b, c, d) {
  function e(b, c) {
    this.settings = null, this.options = a.extend({}, e.Defaults, c), this.$element = a(b), this._handlers = {}, this._plugins = {}, this._supress = {}, this._current = null, this._speed = null, this._coordinates = [], this._breakpoint = null, this._width = null, this._items = [], this._clones = [], this._mergers = [], this._widths = [], this._invalidated = {}, this._pipe = [], this._drag = {
      time: null,
      target: null,
      pointer: null,
      stage: {
        start: null,
        current: null
      },
      direction: null
    }, this._states = {
      current: {},
      tags: {
        initializing: ["busy"],
        animating: ["busy"],
        dragging: ["interacting"]
      }
    }, a.each(["onResize", "onThrottledResize"], a.proxy(function (b, c) {
      this._handlers[c] = a.proxy(this[c], this);
    }, this)), a.each(e.Plugins, a.proxy(function (a, b) {
      this._plugins[a.charAt(0).toLowerCase() + a.slice(1)] = new b(this);
    }, this)), a.each(e.Workers, a.proxy(function (b, c) {
      this._pipe.push({
        filter: c.filter,
        run: a.proxy(c.run, this)
      });
    }, this)), this.setup(), this.initialize();
  }
  e.Defaults = {
    items: 3,
    loop: !1,
    center: !1,
    rewind: !1,
    mouseDrag: !0,
    touchDrag: !0,
    pullDrag: !0,
    freeDrag: !1,
    margin: 0,
    stagePadding: 0,
    merge: !1,
    mergeFit: !0,
    autoWidth: !1,
    startPosition: 0,
    rtl: !1,
    smartSpeed: 250,
    fluidSpeed: !1,
    dragEndSpeed: !1,
    responsive: {},
    responsiveRefreshRate: 200,
    responsiveBaseElement: b,
    fallbackEasing: "swing",
    info: !1,
    nestedItemSelector: !1,
    itemElement: "div",
    stageElement: "div",
    refreshClass: "owl-refresh",
    loadedClass: "owl-loaded",
    loadingClass: "owl-loading",
    rtlClass: "owl-rtl",
    responsiveClass: "owl-responsive",
    dragClass: "owl-drag",
    itemClass: "owl-item",
    stageClass: "owl-stage",
    stageOuterClass: "owl-stage-outer",
    grabClass: "owl-grab"
  }, e.Width = {
    Default: "default",
    Inner: "inner",
    Outer: "outer"
  }, e.Type = {
    Event: "event",
    State: "state"
  }, e.Plugins = {}, e.Workers = [{
    filter: ["width", "settings"],
    run: function run() {
      this._width = this.$element.width();
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run(a) {
      a.current = this._items && this._items[this.relative(this._current)];
    }
  }, {
    filter: ["items", "settings"],
    run: function run() {
      this.$stage.children(".cloned").remove();
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run(a) {
      var b = this.settings.margin || "",
        c = !this.settings.autoWidth,
        d = this.settings.rtl,
        e = {
          width: "auto",
          "margin-left": d ? b : "",
          "margin-right": d ? "" : b
        };
      !c && this.$stage.children().css(e), a.css = e;
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run(a) {
      var b = (this.width() / this.settings.items).toFixed(3) - this.settings.margin,
        c = null,
        d = this._items.length,
        e = !this.settings.autoWidth,
        f = [];
      for (a.items = {
        merge: !1,
        width: b
      }; d--;) c = this._mergers[d], c = this.settings.mergeFit && Math.min(c, this.settings.items) || c, a.items.merge = c > 1 || a.items.merge, f[d] = e ? b * c : this._items[d].width();
      this._widths = f;
    }
  }, {
    filter: ["items", "settings"],
    run: function run() {
      var b = [],
        c = this._items,
        d = this.settings,
        e = Math.max(2 * d.items, 4),
        f = 2 * Math.ceil(c.length / 2),
        g = d.loop && c.length ? d.rewind ? e : Math.max(e, f) : 0,
        h = "",
        i = "";
      for (g /= 2; g--;) b.push(this.normalize(b.length / 2, !0)), h += c[b[b.length - 1]][0].outerHTML, b.push(this.normalize(c.length - 1 - (b.length - 1) / 2, !0)), i = c[b[b.length - 1]][0].outerHTML + i;
      this._clones = b, a(h).addClass("cloned").appendTo(this.$stage), a(i).addClass("cloned").prependTo(this.$stage);
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run() {
      for (var a = this.settings.rtl ? 1 : -1, b = this._clones.length + this._items.length, c = -1, d = 0, e = 0, f = []; ++c < b;) d = f[c - 1] || 0, e = this._widths[this.relative(c)] + this.settings.margin, f.push(d + e * a);
      this._coordinates = f;
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run() {
      var a = this.settings.stagePadding,
        b = this._coordinates,
        c = {
          width: Math.ceil(Math.abs(b[b.length - 1])) + 2 * a,
          "padding-left": a || "",
          "padding-right": a || ""
        };
      this.$stage.css(c);
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run(a) {
      var b = this._coordinates.length,
        c = !this.settings.autoWidth,
        d = this.$stage.children();
      if (c && a.items.merge) for (; b--;) a.css.width = this._widths[this.relative(b)], d.eq(b).css(a.css);else c && (a.css.width = a.items.width, d.css(a.css));
    }
  }, {
    filter: ["items"],
    run: function run() {
      this._coordinates.length < 1 && this.$stage.removeAttr("style");
    }
  }, {
    filter: ["width", "items", "settings"],
    run: function run(a) {
      a.current = a.current ? this.$stage.children().index(a.current) : 0, a.current = Math.max(this.minimum(), Math.min(this.maximum(), a.current)), this.reset(a.current);
    }
  }, {
    filter: ["position"],
    run: function run() {
      this.animate(this.coordinates(this._current));
    }
  }, {
    filter: ["width", "position", "items", "settings"],
    run: function run() {
      var a,
        b,
        c,
        d,
        e = this.settings.rtl ? 1 : -1,
        f = 2 * this.settings.stagePadding,
        g = this.coordinates(this.current()) + f,
        h = g + this.width() * e,
        i = [];
      for (c = 0, d = this._coordinates.length; c < d; c++) a = this._coordinates[c - 1] || 0, b = Math.abs(this._coordinates[c]) + f * e, (this.op(a, "<=", g) && this.op(a, ">", h) || this.op(b, "<", g) && this.op(b, ">", h)) && i.push(c);
      this.$stage.children(".active").removeClass("active"), this.$stage.children(":eq(" + i.join("), :eq(") + ")").addClass("active"), this.settings.center && (this.$stage.children(".center").removeClass("center"), this.$stage.children().eq(this.current()).addClass("center"));
    }
  }], e.prototype.initialize = function () {
    if (this.enter("initializing"), this.trigger("initialize"), this.$element.toggleClass(this.settings.rtlClass, this.settings.rtl), this.settings.autoWidth && !this.is("pre-loading")) {
      var b, c, e;
      b = this.$element.find("img"), c = this.settings.nestedItemSelector ? "." + this.settings.nestedItemSelector : d, e = this.$element.children(c).width(), b.length && e <= 0 && this.preloadAutoWidthImages(b);
    }
    this.$element.addClass(this.options.loadingClass), this.$stage = a("<" + this.settings.stageElement + ' class="' + this.settings.stageClass + '"/>').wrap('<div class="' + this.settings.stageOuterClass + '"/>'), this.$element.append(this.$stage.parent()), this.replace(this.$element.children().not(this.$stage.parent())), this.$element.is(":visible") ? this.refresh() : this.invalidate("width"), this.$element.removeClass(this.options.loadingClass).addClass(this.options.loadedClass), this.registerEventHandlers(), this.leave("initializing"), this.trigger("initialized");
  }, e.prototype.setup = function () {
    var b = this.viewport(),
      c = this.options.responsive,
      d = -1,
      e = null;
    c ? (a.each(c, function (a) {
      a <= b && a > d && (d = Number(a));
    }), e = a.extend({}, this.options, c[d]), "function" == typeof e.stagePadding && (e.stagePadding = e.stagePadding()), delete e.responsive, e.responsiveClass && this.$element.attr("class", this.$element.attr("class").replace(new RegExp("(" + this.options.responsiveClass + "-)\\S+\\s", "g"), "$1" + d))) : e = a.extend({}, this.options), this.trigger("change", {
      property: {
        name: "settings",
        value: e
      }
    }), this._breakpoint = d, this.settings = e, this.invalidate("settings"), this.trigger("changed", {
      property: {
        name: "settings",
        value: this.settings
      }
    });
  }, e.prototype.optionsLogic = function () {
    this.settings.autoWidth && (this.settings.stagePadding = !1, this.settings.merge = !1);
  }, e.prototype.prepare = function (b) {
    var c = this.trigger("prepare", {
      content: b
    });
    return c.data || (c.data = a("<" + this.settings.itemElement + "/>").addClass(this.options.itemClass).append(b)), this.trigger("prepared", {
      content: c.data
    }), c.data;
  }, e.prototype.update = function () {
    for (var b = 0, c = this._pipe.length, d = a.proxy(function (a) {
        return this[a];
      }, this._invalidated), e = {}; b < c;) (this._invalidated.all || a.grep(this._pipe[b].filter, d).length > 0) && this._pipe[b].run(e), b++;
    this._invalidated = {}, !this.is("valid") && this.enter("valid");
  }, e.prototype.width = function (a) {
    switch (a = a || e.Width.Default) {
      case e.Width.Inner:
      case e.Width.Outer:
        return this._width;
      default:
        return this._width - 2 * this.settings.stagePadding + this.settings.margin;
    }
  }, e.prototype.refresh = function () {
    this.enter("refreshing"), this.trigger("refresh"), this.setup(), this.optionsLogic(), this.$element.addClass(this.options.refreshClass), this.update(), this.$element.removeClass(this.options.refreshClass), this.leave("refreshing"), this.trigger("refreshed");
  }, e.prototype.onThrottledResize = function () {
    b.clearTimeout(this.resizeTimer), this.resizeTimer = b.setTimeout(this._handlers.onResize, this.settings.responsiveRefreshRate);
  }, e.prototype.onResize = function () {
    return !!this._items.length && this._width !== this.$element.width() && !!this.$element.is(":visible") && (this.enter("resizing"), this.trigger("resize").isDefaultPrevented() ? (this.leave("resizing"), !1) : (this.invalidate("width"), this.refresh(), this.leave("resizing"), void this.trigger("resized")));
  }, e.prototype.registerEventHandlers = function () {
    a.support.transition && this.$stage.on(a.support.transition.end + ".owl.core", a.proxy(this.onTransitionEnd, this)), this.settings.responsive !== !1 && this.on(b, "resize", this._handlers.onThrottledResize), this.settings.mouseDrag && (this.$element.addClass(this.options.dragClass), this.$stage.on("mousedown.owl.core", a.proxy(this.onDragStart, this)), this.$stage.on("dragstart.owl.core selectstart.owl.core", function () {
      return !1;
    })), this.settings.touchDrag && (this.$stage.on("touchstart.owl.core", a.proxy(this.onDragStart, this)), this.$stage.on("touchcancel.owl.core", a.proxy(this.onDragEnd, this)));
  }, e.prototype.onDragStart = function (b) {
    var d = null;
    3 !== b.which && (a.support.transform ? (d = this.$stage.css("transform").replace(/.*\(|\)| /g, "").split(","), d = {
      x: d[16 === d.length ? 12 : 4],
      y: d[16 === d.length ? 13 : 5]
    }) : (d = this.$stage.position(), d = {
      x: this.settings.rtl ? d.left + this.$stage.width() - this.width() + this.settings.margin : d.left,
      y: d.top
    }), this.is("animating") && (a.support.transform ? this.animate(d.x) : this.$stage.stop(), this.invalidate("position")), this.$element.toggleClass(this.options.grabClass, "mousedown" === b.type), this.speed(0), this._drag.time = new Date().getTime(), this._drag.target = a(b.target), this._drag.stage.start = d, this._drag.stage.current = d, this._drag.pointer = this.pointer(b), a(c).on("mouseup.owl.core touchend.owl.core", a.proxy(this.onDragEnd, this)), a(c).one("mousemove.owl.core touchmove.owl.core", a.proxy(function (b) {
      var d = this.difference(this._drag.pointer, this.pointer(b));
      a(c).on("mousemove.owl.core touchmove.owl.core", a.proxy(this.onDragMove, this)), Math.abs(d.x) < Math.abs(d.y) && this.is("valid") || (b.preventDefault(), this.enter("dragging"), this.trigger("drag"));
    }, this)));
  }, e.prototype.onDragMove = function (a) {
    var b = null,
      c = null,
      d = null,
      e = this.difference(this._drag.pointer, this.pointer(a)),
      f = this.difference(this._drag.stage.start, e);
    this.is("dragging") && (a.preventDefault(), this.settings.loop ? (b = this.coordinates(this.minimum()), c = this.coordinates(this.maximum() + 1) - b, f.x = ((f.x - b) % c + c) % c + b) : (b = this.settings.rtl ? this.coordinates(this.maximum()) : this.coordinates(this.minimum()), c = this.settings.rtl ? this.coordinates(this.minimum()) : this.coordinates(this.maximum()), d = this.settings.pullDrag ? -1 * e.x / 5 : 0, f.x = Math.max(Math.min(f.x, b + d), c + d)), this._drag.stage.current = f, this.animate(f.x));
  }, e.prototype.onDragEnd = function (b) {
    var d = this.difference(this._drag.pointer, this.pointer(b)),
      e = this._drag.stage.current,
      f = d.x > 0 ^ this.settings.rtl ? "left" : "right";
    a(c).off(".owl.core"), this.$element.removeClass(this.options.grabClass), (0 !== d.x && this.is("dragging") || !this.is("valid")) && (this.speed(this.settings.dragEndSpeed || this.settings.smartSpeed), this.current(this.closest(e.x, 0 !== d.x ? f : this._drag.direction)), this.invalidate("position"), this.update(), this._drag.direction = f, (Math.abs(d.x) > 3 || new Date().getTime() - this._drag.time > 300) && this._drag.target.one("click.owl.core", function () {
      return !1;
    })), this.is("dragging") && (this.leave("dragging"), this.trigger("dragged"));
  }, e.prototype.closest = function (b, c) {
    var d = -1,
      e = 30,
      f = this.width(),
      g = this.coordinates();
    return this.settings.freeDrag || a.each(g, a.proxy(function (a, h) {
      return "left" === c && b > h - e && b < h + e ? d = a : "right" === c && b > h - f - e && b < h - f + e ? d = a + 1 : this.op(b, "<", h) && this.op(b, ">", g[a + 1] || h - f) && (d = "left" === c ? a + 1 : a), d === -1;
    }, this)), this.settings.loop || (this.op(b, ">", g[this.minimum()]) ? d = b = this.minimum() : this.op(b, "<", g[this.maximum()]) && (d = b = this.maximum())), d;
  }, e.prototype.animate = function (b) {
    var c = this.speed() > 0;
    this.is("animating") && this.onTransitionEnd(), c && (this.enter("animating"), this.trigger("translate")), a.support.transform3d && a.support.transition ? this.$stage.css({
      transform: "translate3d(" + b + "px,0px,0px)",
      transition: this.speed() / 1e3 + "s"
    }) : c ? this.$stage.animate({
      left: b + "px"
    }, this.speed(), this.settings.fallbackEasing, a.proxy(this.onTransitionEnd, this)) : this.$stage.css({
      left: b + "px"
    });
  }, e.prototype.is = function (a) {
    return this._states.current[a] && this._states.current[a] > 0;
  }, e.prototype.current = function (a) {
    if (a === d) return this._current;
    if (0 === this._items.length) return d;
    if (a = this.normalize(a), this._current !== a) {
      var b = this.trigger("change", {
        property: {
          name: "position",
          value: a
        }
      });
      b.data !== d && (a = this.normalize(b.data)), this._current = a, this.invalidate("position"), this.trigger("changed", {
        property: {
          name: "position",
          value: this._current
        }
      });
    }
    return this._current;
  }, e.prototype.invalidate = function (b) {
    return "string" === a.type(b) && (this._invalidated[b] = !0, this.is("valid") && this.leave("valid")), a.map(this._invalidated, function (a, b) {
      return b;
    });
  }, e.prototype.reset = function (a) {
    a = this.normalize(a), a !== d && (this._speed = 0, this._current = a, this.suppress(["translate", "translated"]), this.animate(this.coordinates(a)), this.release(["translate", "translated"]));
  }, e.prototype.normalize = function (a, b) {
    var c = this._items.length,
      e = b ? 0 : this._clones.length;
    return !this.isNumeric(a) || c < 1 ? a = d : (a < 0 || a >= c + e) && (a = ((a - e / 2) % c + c) % c + e / 2), a;
  }, e.prototype.relative = function (a) {
    return a -= this._clones.length / 2, this.normalize(a, !0);
  }, e.prototype.maximum = function (a) {
    var b,
      c,
      d,
      e = this.settings,
      f = this._coordinates.length;
    if (e.loop) f = this._clones.length / 2 + this._items.length - 1;else if (e.autoWidth || e.merge) {
      for (b = this._items.length, c = this._items[--b].width(), d = this.$element.width(); b-- && (c += this._items[b].width() + this.settings.margin, !(c > d)););
      f = b + 1;
    } else f = e.center ? this._items.length - 1 : this._items.length - e.items;
    return a && (f -= this._clones.length / 2), Math.max(f, 0);
  }, e.prototype.minimum = function (a) {
    return a ? 0 : this._clones.length / 2;
  }, e.prototype.items = function (a) {
    return a === d ? this._items.slice() : (a = this.normalize(a, !0), this._items[a]);
  }, e.prototype.mergers = function (a) {
    return a === d ? this._mergers.slice() : (a = this.normalize(a, !0), this._mergers[a]);
  }, e.prototype.clones = function (b) {
    var c = this._clones.length / 2,
      e = c + this._items.length,
      f = function f(a) {
        return a % 2 === 0 ? e + a / 2 : c - (a + 1) / 2;
      };
    return b === d ? a.map(this._clones, function (a, b) {
      return f(b);
    }) : a.map(this._clones, function (a, c) {
      return a === b ? f(c) : null;
    });
  }, e.prototype.speed = function (a) {
    return a !== d && (this._speed = a), this._speed;
  }, e.prototype.coordinates = function (b) {
    var c,
      e = 1,
      f = b - 1;
    return b === d ? a.map(this._coordinates, a.proxy(function (a, b) {
      return this.coordinates(b);
    }, this)) : (this.settings.center ? (this.settings.rtl && (e = -1, f = b + 1), c = this._coordinates[b], c += (this.width() - c + (this._coordinates[f] || 0)) / 2 * e) : c = this._coordinates[f] || 0, c = Math.ceil(c));
  }, e.prototype.duration = function (a, b, c) {
    return 0 === c ? 0 : Math.min(Math.max(Math.abs(b - a), 1), 6) * Math.abs(c || this.settings.smartSpeed);
  }, e.prototype.to = function (a, b) {
    var c = this.current(),
      d = null,
      e = a - this.relative(c),
      f = (e > 0) - (e < 0),
      g = this._items.length,
      h = this.minimum(),
      i = this.maximum();
    this.settings.loop ? (!this.settings.rewind && Math.abs(e) > g / 2 && (e += f * -1 * g), a = c + e, d = ((a - h) % g + g) % g + h, d !== a && d - e <= i && d - e > 0 && (c = d - e, a = d, this.reset(c))) : this.settings.rewind ? (i += 1, a = (a % i + i) % i) : a = Math.max(h, Math.min(i, a)), this.speed(this.duration(c, a, b)), this.current(a), this.$element.is(":visible") && this.update();
  }, e.prototype.next = function (a) {
    a = a || !1, this.to(this.relative(this.current()) + 1, a);
  }, e.prototype.prev = function (a) {
    a = a || !1, this.to(this.relative(this.current()) - 1, a);
  }, e.prototype.onTransitionEnd = function (a) {
    if (a !== d && (a.stopPropagation(), (a.target || a.srcElement || a.originalTarget) !== this.$stage.get(0))) return !1;
    this.leave("animating"), this.trigger("translated");
  }, e.prototype.viewport = function () {
    var d;
    return this.options.responsiveBaseElement !== b ? d = a(this.options.responsiveBaseElement).width() : b.innerWidth ? d = b.innerWidth : c.documentElement && c.documentElement.clientWidth ? d = c.documentElement.clientWidth : console.warn("Can not detect viewport width."), d;
  }, e.prototype.replace = function (b) {
    this.$stage.empty(), this._items = [], b && (b = b instanceof jQuery ? b : a(b)), this.settings.nestedItemSelector && (b = b.find("." + this.settings.nestedItemSelector)), b.filter(function () {
      return 1 === this.nodeType;
    }).each(a.proxy(function (a, b) {
      b = this.prepare(b), this.$stage.append(b), this._items.push(b), this._mergers.push(1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1);
    }, this)), this.reset(this.isNumeric(this.settings.startPosition) ? this.settings.startPosition : 0), this.invalidate("items");
  }, e.prototype.add = function (b, c) {
    var e = this.relative(this._current);
    c = c === d ? this._items.length : this.normalize(c, !0), b = b instanceof jQuery ? b : a(b), this.trigger("add", {
      content: b,
      position: c
    }), b = this.prepare(b), 0 === this._items.length || c === this._items.length ? (0 === this._items.length && this.$stage.append(b), 0 !== this._items.length && this._items[c - 1].after(b), this._items.push(b), this._mergers.push(1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1)) : (this._items[c].before(b), this._items.splice(c, 0, b), this._mergers.splice(c, 0, 1 * b.find("[data-merge]").addBack("[data-merge]").attr("data-merge") || 1)), this._items[e] && this.reset(this._items[e].index()), this.invalidate("items"), this.trigger("added", {
      content: b,
      position: c
    });
  }, e.prototype.remove = function (a) {
    a = this.normalize(a, !0), a !== d && (this.trigger("remove", {
      content: this._items[a],
      position: a
    }), this._items[a].remove(), this._items.splice(a, 1), this._mergers.splice(a, 1), this.invalidate("items"), this.trigger("removed", {
      content: null,
      position: a
    }));
  }, e.prototype.preloadAutoWidthImages = function (b) {
    b.each(a.proxy(function (b, c) {
      this.enter("pre-loading"), c = a(c), a(new Image()).one("load", a.proxy(function (a) {
        c.attr("src", a.target.src), c.css("opacity", 1), this.leave("pre-loading"), !this.is("pre-loading") && !this.is("initializing") && this.refresh();
      }, this)).attr("src", c.attr("src") || c.attr("data-src") || c.attr("data-src-retina"));
    }, this));
  }, e.prototype.destroy = function () {
    this.$element.off(".owl.core"), this.$stage.off(".owl.core"), a(c).off(".owl.core"), this.settings.responsive !== !1 && (b.clearTimeout(this.resizeTimer), this.off(b, "resize", this._handlers.onThrottledResize));
    for (var d in this._plugins) this._plugins[d].destroy();
    this.$stage.children(".cloned").remove(), this.$stage.unwrap(), this.$stage.children().contents().unwrap(), this.$stage.children().unwrap(), this.$element.removeClass(this.options.refreshClass).removeClass(this.options.loadingClass).removeClass(this.options.loadedClass).removeClass(this.options.rtlClass).removeClass(this.options.dragClass).removeClass(this.options.grabClass).attr("class", this.$element.attr("class").replace(new RegExp(this.options.responsiveClass + "-\\S+\\s", "g"), "")).removeData("owl.carousel");
  }, e.prototype.op = function (a, b, c) {
    var d = this.settings.rtl;
    switch (b) {
      case "<":
        return d ? a > c : a < c;
      case ">":
        return d ? a < c : a > c;
      case ">=":
        return d ? a <= c : a >= c;
      case "<=":
        return d ? a >= c : a <= c;
    }
  }, e.prototype.on = function (a, b, c, d) {
    a.addEventListener ? a.addEventListener(b, c, d) : a.attachEvent && a.attachEvent("on" + b, c);
  }, e.prototype.off = function (a, b, c, d) {
    a.removeEventListener ? a.removeEventListener(b, c, d) : a.detachEvent && a.detachEvent("on" + b, c);
  }, e.prototype.trigger = function (b, c, d, f, g) {
    var h = {
        item: {
          count: this._items.length,
          index: this.current()
        }
      },
      i = a.camelCase(a.grep(["on", b, d], function (a) {
        return a;
      }).join("-").toLowerCase()),
      j = a.Event([b, "owl", d || "carousel"].join(".").toLowerCase(), a.extend({
        relatedTarget: this
      }, h, c));
    return this._supress[b] || (a.each(this._plugins, function (a, b) {
      b.onTrigger && b.onTrigger(j);
    }), this.register({
      type: e.Type.Event,
      name: b
    }), this.$element.trigger(j), this.settings && "function" == typeof this.settings[i] && this.settings[i].call(this, j)), j;
  }, e.prototype.enter = function (b) {
    a.each([b].concat(this._states.tags[b] || []), a.proxy(function (a, b) {
      this._states.current[b] === d && (this._states.current[b] = 0), this._states.current[b]++;
    }, this));
  }, e.prototype.leave = function (b) {
    a.each([b].concat(this._states.tags[b] || []), a.proxy(function (a, b) {
      this._states.current[b]--;
    }, this));
  }, e.prototype.register = function (b) {
    if (b.type === e.Type.Event) {
      if (a.event.special[b.name] || (a.event.special[b.name] = {}), !a.event.special[b.name].owl) {
        var c = a.event.special[b.name]._default;
        a.event.special[b.name]._default = function (a) {
          return !c || !c.apply || a.namespace && a.namespace.indexOf("owl") !== -1 ? a.namespace && a.namespace.indexOf("owl") > -1 : c.apply(this, arguments);
        }, a.event.special[b.name].owl = !0;
      }
    } else b.type === e.Type.State && (this._states.tags[b.name] ? this._states.tags[b.name] = this._states.tags[b.name].concat(b.tags) : this._states.tags[b.name] = b.tags, this._states.tags[b.name] = a.grep(this._states.tags[b.name], a.proxy(function (c, d) {
      return a.inArray(c, this._states.tags[b.name]) === d;
    }, this)));
  }, e.prototype.suppress = function (b) {
    a.each(b, a.proxy(function (a, b) {
      this._supress[b] = !0;
    }, this));
  }, e.prototype.release = function (b) {
    a.each(b, a.proxy(function (a, b) {
      delete this._supress[b];
    }, this));
  }, e.prototype.pointer = function (a) {
    var c = {
      x: null,
      y: null
    };
    return a = a.originalEvent || a || b.event, a = a.touches && a.touches.length ? a.touches[0] : a.changedTouches && a.changedTouches.length ? a.changedTouches[0] : a, a.pageX ? (c.x = a.pageX, c.y = a.pageY) : (c.x = a.clientX, c.y = a.clientY), c;
  }, e.prototype.isNumeric = function (a) {
    return !isNaN(parseFloat(a));
  }, e.prototype.difference = function (a, b) {
    return {
      x: a.x - b.x,
      y: a.y - b.y
    };
  }, a.fn.owlCarousel = function (b) {
    var c = Array.prototype.slice.call(arguments, 1);
    return this.each(function () {
      var d = a(this),
        f = d.data("owl.carousel");
      f || (f = new e(this, "object" == _typeof(b) && b), d.data("owl.carousel", f), a.each(["next", "prev", "to", "destroy", "refresh", "replace", "add", "remove"], function (b, c) {
        f.register({
          type: e.Type.Event,
          name: c
        }), f.$element.on(c + ".owl.carousel.core", a.proxy(function (a) {
          a.namespace && a.relatedTarget !== this && (this.suppress([c]), f[c].apply(this, [].slice.call(arguments, 1)), this.release([c]));
        }, f));
      })), "string" == typeof b && "_" !== b.charAt(0) && f[b].apply(f, c);
    });
  }, a.fn.owlCarousel.Constructor = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this._core = b, this._interval = null, this._visible = null, this._handlers = {
      "initialized.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.autoRefresh && this.watch();
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers);
  };
  e.Defaults = {
    autoRefresh: !0,
    autoRefreshInterval: 500
  }, e.prototype.watch = function () {
    this._interval || (this._visible = this._core.$element.is(":visible"), this._interval = b.setInterval(a.proxy(this.refresh, this), this._core.settings.autoRefreshInterval));
  }, e.prototype.refresh = function () {
    this._core.$element.is(":visible") !== this._visible && (this._visible = !this._visible, this._core.$element.toggleClass("owl-hidden", !this._visible), this._visible && this._core.invalidate("width") && this._core.refresh());
  }, e.prototype.destroy = function () {
    var a, c;
    b.clearInterval(this._interval);
    for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
    for (c in Object.getOwnPropertyNames(this)) "function" != typeof this[c] && (this[c] = null);
  }, a.fn.owlCarousel.Constructor.Plugins.AutoRefresh = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this._core = b, this._loaded = [], this._handlers = {
      "initialized.owl.carousel change.owl.carousel resized.owl.carousel": a.proxy(function (b) {
        if (b.namespace && this._core.settings && this._core.settings.lazyLoad && (b.property && "position" == b.property.name || "initialized" == b.type)) for (var c = this._core.settings, e = c.center && Math.ceil(c.items / 2) || c.items, f = c.center && e * -1 || 0, g = (b.property && b.property.value !== d ? b.property.value : this._core.current()) + f, h = this._core.clones().length, i = a.proxy(function (a, b) {
            this.load(b);
          }, this); f++ < e;) this.load(h / 2 + this._core.relative(g)), h && a.each(this._core.clones(this._core.relative(g)), i), g++;
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers);
  };
  e.Defaults = {
    lazyLoad: !1
  }, e.prototype.load = function (c) {
    var d = this._core.$stage.children().eq(c),
      e = d && d.find(".owl-lazy");
    !e || a.inArray(d.get(0), this._loaded) > -1 || (e.each(a.proxy(function (c, d) {
      var e,
        f = a(d),
        g = b.devicePixelRatio > 1 && f.attr("data-src-retina") || f.attr("data-src");
      this._core.trigger("load", {
        element: f,
        url: g
      }, "lazy"), f.is("img") ? f.one("load.owl.lazy", a.proxy(function () {
        f.css("opacity", 1), this._core.trigger("loaded", {
          element: f,
          url: g
        }, "lazy");
      }, this)).attr("src", g) : (e = new Image(), e.onload = a.proxy(function () {
        f.css({
          "background-image": 'url("' + g + '")',
          opacity: "1"
        }), this._core.trigger("loaded", {
          element: f,
          url: g
        }, "lazy");
      }, this), e.src = g);
    }, this)), this._loaded.push(d.get(0)));
  }, e.prototype.destroy = function () {
    var a, b;
    for (a in this.handlers) this._core.$element.off(a, this.handlers[a]);
    for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
  }, a.fn.owlCarousel.Constructor.Plugins.Lazy = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this._core = b, this._handlers = {
      "initialized.owl.carousel refreshed.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.autoHeight && this.update();
      }, this),
      "changed.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.autoHeight && "position" == a.property.name && this.update();
      }, this),
      "loaded.owl.lazy": a.proxy(function (a) {
        a.namespace && this._core.settings.autoHeight && a.element.closest("." + this._core.settings.itemClass).index() === this._core.current() && this.update();
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers);
  };
  e.Defaults = {
    autoHeight: !1,
    autoHeightClass: "owl-height"
  }, e.prototype.update = function () {
    var b = this._core._current,
      c = b + this._core.settings.items,
      d = this._core.$stage.children().toArray().slice(b, c),
      e = [],
      f = 0;
    a.each(d, function (b, c) {
      e.push(a(c).height());
    }), f = Math.max.apply(null, e), this._core.$stage.parent().height(f).addClass(this._core.settings.autoHeightClass);
  }, e.prototype.destroy = function () {
    var a, b;
    for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
    for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
  }, a.fn.owlCarousel.Constructor.Plugins.AutoHeight = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this._core = b, this._videos = {}, this._playing = null, this._handlers = {
      "initialized.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.register({
          type: "state",
          name: "playing",
          tags: ["interacting"]
        });
      }, this),
      "resize.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.video && this.isInFullScreen() && a.preventDefault();
      }, this),
      "refreshed.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.is("resizing") && this._core.$stage.find(".cloned .owl-video-frame").remove();
      }, this),
      "changed.owl.carousel": a.proxy(function (a) {
        a.namespace && "position" === a.property.name && this._playing && this.stop();
      }, this),
      "prepared.owl.carousel": a.proxy(function (b) {
        if (b.namespace) {
          var c = a(b.content).find(".owl-video");
          c.length && (c.css("display", "none"), this.fetch(c, a(b.content)));
        }
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this._core.$element.on(this._handlers), this._core.$element.on("click.owl.video", ".owl-video-play-icon", a.proxy(function (a) {
      this.play(a);
    }, this));
  };
  e.Defaults = {
    video: !1,
    videoHeight: !1,
    videoWidth: !1
  }, e.prototype.fetch = function (a, b) {
    var c = function () {
        return a.attr("data-vimeo-id") ? "vimeo" : a.attr("data-vzaar-id") ? "vzaar" : "youtube";
      }(),
      d = a.attr("data-vimeo-id") || a.attr("data-youtube-id") || a.attr("data-vzaar-id"),
      e = a.attr("data-width") || this._core.settings.videoWidth,
      f = a.attr("data-height") || this._core.settings.videoHeight,
      g = a.attr("href");
    if (!g) throw new Error("Missing video URL.");
    if (d = g.match(/(http:|https:|)\/\/(player.|www.|app.)?(vimeo\.com|youtu(be\.com|\.be|be\.googleapis\.com)|vzaar\.com)\/(video\/|videos\/|embed\/|channels\/.+\/|groups\/.+\/|watch\?v=|v\/)?([A-Za-z0-9._%-]*)(\&\S+)?/), d[3].indexOf("youtu") > -1) c = "youtube";else if (d[3].indexOf("vimeo") > -1) c = "vimeo";else {
      if (!(d[3].indexOf("vzaar") > -1)) throw new Error("Video URL not supported.");
      c = "vzaar";
    }
    d = d[6], this._videos[g] = {
      type: c,
      id: d,
      width: e,
      height: f
    }, b.attr("data-video", g), this.thumbnail(a, this._videos[g]);
  }, e.prototype.thumbnail = function (b, c) {
    var d,
      e,
      f,
      g = c.width && c.height ? 'style="width:' + c.width + "px;height:" + c.height + 'px;"' : "",
      h = b.find("img"),
      i = "src",
      j = "",
      k = this._core.settings,
      l = function l(a) {
        e = '<div class="owl-video-play-icon"></div>', d = k.lazyLoad ? '<div class="owl-video-tn ' + j + '" ' + i + '="' + a + '"></div>' : '<div class="owl-video-tn" style="opacity:1;background-image:url(' + a + ')"></div>', b.after(d), b.after(e);
      };
    if (b.wrap('<div class="owl-video-wrapper"' + g + "></div>"), this._core.settings.lazyLoad && (i = "data-src", j = "owl-lazy"), h.length) return l(h.attr(i)), h.remove(), !1;
    "youtube" === c.type ? (f = "//img.youtube.com/vi/" + c.id + "/hqdefault.jpg", l(f)) : "vimeo" === c.type ? a.ajax({
      type: "GET",
      url: "//vimeo.com/api/v2/video/" + c.id + ".json",
      jsonp: "callback",
      dataType: "jsonp",
      success: function success(a) {
        f = a[0].thumbnail_large, l(f);
      }
    }) : "vzaar" === c.type && a.ajax({
      type: "GET",
      url: "//vzaar.com/api/videos/" + c.id + ".json",
      jsonp: "callback",
      dataType: "jsonp",
      success: function success(a) {
        f = a.framegrab_url, l(f);
      }
    });
  }, e.prototype.stop = function () {
    this._core.trigger("stop", null, "video"), this._playing.find(".owl-video-frame").remove(), this._playing.removeClass("owl-video-playing"), this._playing = null, this._core.leave("playing"), this._core.trigger("stopped", null, "video");
  }, e.prototype.play = function (b) {
    var c,
      d = a(b.target),
      e = d.closest("." + this._core.settings.itemClass),
      f = this._videos[e.attr("data-video")],
      g = f.width || "100%",
      h = f.height || this._core.$stage.height();
    this._playing || (this._core.enter("playing"), this._core.trigger("play", null, "video"), e = this._core.items(this._core.relative(e.index())), this._core.reset(e.index()), "youtube" === f.type ? c = '<iframe width="' + g + '" height="' + h + '" src="//www.youtube.com/embed/' + f.id + "?autoplay=1&rel=0&v=" + f.id + '" frameborder="0" allowfullscreen></iframe>' : "vimeo" === f.type ? c = '<iframe src="//player.vimeo.com/video/' + f.id + '?autoplay=1" width="' + g + '" height="' + h + '" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>' : "vzaar" === f.type && (c = '<iframe frameborder="0"height="' + h + '"width="' + g + '" allowfullscreen mozallowfullscreen webkitAllowFullScreen src="//view.vzaar.com/' + f.id + '/player?autoplay=true"></iframe>'), a('<div class="owl-video-frame">' + c + "</div>").insertAfter(e.find(".owl-video")), this._playing = e.addClass("owl-video-playing"));
  }, e.prototype.isInFullScreen = function () {
    var b = c.fullscreenElement || c.mozFullScreenElement || c.webkitFullscreenElement;
    return b && a(b).parent().hasClass("owl-video-frame");
  }, e.prototype.destroy = function () {
    var a, b;
    this._core.$element.off("click.owl.video");
    for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
    for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
  }, a.fn.owlCarousel.Constructor.Plugins.Video = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this.core = b, this.core.options = a.extend({}, e.Defaults, this.core.options), this.swapping = !0, this.previous = d, this.next = d, this.handlers = {
      "change.owl.carousel": a.proxy(function (a) {
        a.namespace && "position" == a.property.name && (this.previous = this.core.current(), this.next = a.property.value);
      }, this),
      "drag.owl.carousel dragged.owl.carousel translated.owl.carousel": a.proxy(function (a) {
        a.namespace && (this.swapping = "translated" == a.type);
      }, this),
      "translate.owl.carousel": a.proxy(function (a) {
        a.namespace && this.swapping && (this.core.options.animateOut || this.core.options.animateIn) && this.swap();
      }, this)
    }, this.core.$element.on(this.handlers);
  };
  e.Defaults = {
    animateOut: !1,
    animateIn: !1
  }, e.prototype.swap = function () {
    if (1 === this.core.settings.items && a.support.animation && a.support.transition) {
      this.core.speed(0);
      var b,
        c = a.proxy(this.clear, this),
        d = this.core.$stage.children().eq(this.previous),
        e = this.core.$stage.children().eq(this.next),
        f = this.core.settings.animateIn,
        g = this.core.settings.animateOut;
      this.core.current() !== this.previous && (g && (b = this.core.coordinates(this.previous) - this.core.coordinates(this.next), d.one(a.support.animation.end, c).css({
        left: b + "px"
      }).addClass("animated owl-animated-out").addClass(g)), f && e.one(a.support.animation.end, c).addClass("animated owl-animated-in").addClass(f));
    }
  }, e.prototype.clear = function (b) {
    a(b.target).css({
      left: ""
    }).removeClass("animated owl-animated-out owl-animated-in").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut), this.core.onTransitionEnd();
  }, e.prototype.destroy = function () {
    var a, b;
    for (a in this.handlers) this.core.$element.off(a, this.handlers[a]);
    for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
  }, a.fn.owlCarousel.Constructor.Plugins.Animate = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  var e = function e(b) {
    this._core = b, this._timeout = null, this._paused = !1, this._handlers = {
      "changed.owl.carousel": a.proxy(function (a) {
        a.namespace && "settings" === a.property.name ? this._core.settings.autoplay ? this.play() : this.stop() : a.namespace && "position" === a.property.name && this._core.settings.autoplay && this._setAutoPlayInterval();
      }, this),
      "initialized.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.autoplay && this.play();
      }, this),
      "play.owl.autoplay": a.proxy(function (a, b, c) {
        a.namespace && this.play(b, c);
      }, this),
      "stop.owl.autoplay": a.proxy(function (a) {
        a.namespace && this.stop();
      }, this),
      "mouseover.owl.autoplay": a.proxy(function () {
        this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.pause();
      }, this),
      "mouseleave.owl.autoplay": a.proxy(function () {
        this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.play();
      }, this),
      "touchstart.owl.core": a.proxy(function () {
        this._core.settings.autoplayHoverPause && this._core.is("rotating") && this.pause();
      }, this),
      "touchend.owl.core": a.proxy(function () {
        this._core.settings.autoplayHoverPause && this.play();
      }, this)
    }, this._core.$element.on(this._handlers), this._core.options = a.extend({}, e.Defaults, this._core.options);
  };
  e.Defaults = {
    autoplay: !1,
    autoplayTimeout: 5e3,
    autoplayHoverPause: !1,
    autoplaySpeed: !1
  }, e.prototype.play = function (a, b) {
    this._paused = !1, this._core.is("rotating") || (this._core.enter("rotating"), this._setAutoPlayInterval());
  }, e.prototype._getNextTimeout = function (d, e) {
    return this._timeout && b.clearTimeout(this._timeout), b.setTimeout(a.proxy(function () {
      this._paused || this._core.is("busy") || this._core.is("interacting") || c.hidden || this._core.next(e || this._core.settings.autoplaySpeed);
    }, this), d || this._core.settings.autoplayTimeout);
  }, e.prototype._setAutoPlayInterval = function () {
    this._timeout = this._getNextTimeout();
  }, e.prototype.stop = function () {
    this._core.is("rotating") && (b.clearTimeout(this._timeout), this._core.leave("rotating"));
  }, e.prototype.pause = function () {
    this._core.is("rotating") && (this._paused = !0);
  }, e.prototype.destroy = function () {
    var a, b;
    this.stop();
    for (a in this._handlers) this._core.$element.off(a, this._handlers[a]);
    for (b in Object.getOwnPropertyNames(this)) "function" != typeof this[b] && (this[b] = null);
  }, a.fn.owlCarousel.Constructor.Plugins.autoplay = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  "use strict";

  var e = function e(b) {
    this._core = b, this._initialized = !1, this._pages = [], this._controls = {}, this._templates = [], this.$element = this._core.$element, this._overrides = {
      next: this._core.next,
      prev: this._core.prev,
      to: this._core.to
    }, this._handlers = {
      "prepared.owl.carousel": a.proxy(function (b) {
        b.namespace && this._core.settings.dotsData && this._templates.push('<div class="' + this._core.settings.dotClass + '">' + a(b.content).find("[data-dot]").addBack("[data-dot]").attr("data-dot") + "</div>");
      }, this),
      "added.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.dotsData && this._templates.splice(a.position, 0, this._templates.pop());
      }, this),
      "remove.owl.carousel": a.proxy(function (a) {
        a.namespace && this._core.settings.dotsData && this._templates.splice(a.position, 1);
      }, this),
      "changed.owl.carousel": a.proxy(function (a) {
        a.namespace && "position" == a.property.name && this.draw();
      }, this),
      "initialized.owl.carousel": a.proxy(function (a) {
        a.namespace && !this._initialized && (this._core.trigger("initialize", null, "navigation"), this.initialize(), this.update(), this.draw(), this._initialized = !0, this._core.trigger("initialized", null, "navigation"));
      }, this),
      "refreshed.owl.carousel": a.proxy(function (a) {
        a.namespace && this._initialized && (this._core.trigger("refresh", null, "navigation"), this.update(), this.draw(), this._core.trigger("refreshed", null, "navigation"));
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this.$element.on(this._handlers);
  };
  e.Defaults = {
    nav: !1,
    navText: ["prev", "next"],
    navSpeed: !1,
    navElement: "div",
    navContainer: !1,
    navContainerClass: "owl-nav",
    navClass: ["owl-prev", "owl-next"],
    slideBy: 1,
    dotClass: "owl-dot",
    dotsClass: "owl-dots",
    dots: !0,
    dotsEach: !1,
    dotsData: !1,
    dotsSpeed: !1,
    dotsContainer: !1
  }, e.prototype.initialize = function () {
    var b,
      c = this._core.settings;
    this._controls.$relative = (c.navContainer ? a(c.navContainer) : a("<div>").addClass(c.navContainerClass).appendTo(this.$element)).addClass("disabled"), this._controls.$previous = a("<" + c.navElement + ">").addClass(c.navClass[0]).html(c.navText[0]).prependTo(this._controls.$relative).on("click", a.proxy(function (a) {
      this.prev(c.navSpeed);
    }, this)), this._controls.$next = a("<" + c.navElement + ">").addClass(c.navClass[1]).html(c.navText[1]).appendTo(this._controls.$relative).on("click", a.proxy(function (a) {
      this.next(c.navSpeed);
    }, this)), c.dotsData || (this._templates = [a("<div>").addClass(c.dotClass).append(a("<span>")).prop("outerHTML")]), this._controls.$absolute = (c.dotsContainer ? a(c.dotsContainer) : a("<div>").addClass(c.dotsClass).appendTo(this.$element)).addClass("disabled"), this._controls.$absolute.on("click", "div", a.proxy(function (b) {
      var d = a(b.target).parent().is(this._controls.$absolute) ? a(b.target).index() : a(b.target).parent().index();
      b.preventDefault(), this.to(d, c.dotsSpeed);
    }, this));
    for (b in this._overrides) this._core[b] = a.proxy(this[b], this);
  }, e.prototype.destroy = function () {
    var a, b, c, d;
    for (a in this._handlers) this.$element.off(a, this._handlers[a]);
    for (b in this._controls) this._controls[b].remove();
    for (d in this.overides) this._core[d] = this._overrides[d];
    for (c in Object.getOwnPropertyNames(this)) "function" != typeof this[c] && (this[c] = null);
  }, e.prototype.update = function () {
    var a,
      b,
      c,
      d = this._core.clones().length / 2,
      e = d + this._core.items().length,
      f = this._core.maximum(!0),
      g = this._core.settings,
      h = g.center || g.autoWidth || g.dotsData ? 1 : g.dotsEach || g.items;
    if ("page" !== g.slideBy && (g.slideBy = Math.min(g.slideBy, g.items)), g.dots || "page" == g.slideBy) for (this._pages = [], a = d, b = 0, c = 0; a < e; a++) {
      if (b >= h || 0 === b) {
        if (this._pages.push({
          start: Math.min(f, a - d),
          end: a - d + h - 1
        }), Math.min(f, a - d) === f) break;
        b = 0, ++c;
      }
      b += this._core.mergers(this._core.relative(a));
    }
  }, e.prototype.draw = function () {
    var b,
      c = this._core.settings,
      d = this._core.items().length <= c.items,
      e = this._core.relative(this._core.current()),
      f = c.loop || c.rewind;
    this._controls.$relative.toggleClass("disabled", !c.nav || d), c.nav && (this._controls.$previous.toggleClass("disabled", !f && e <= this._core.minimum(!0)), this._controls.$next.toggleClass("disabled", !f && e >= this._core.maximum(!0))), this._controls.$absolute.toggleClass("disabled", !c.dots || d), c.dots && (b = this._pages.length - this._controls.$absolute.children().length, c.dotsData && 0 !== b ? this._controls.$absolute.html(this._templates.join("")) : b > 0 ? this._controls.$absolute.append(new Array(b + 1).join(this._templates[0])) : b < 0 && this._controls.$absolute.children().slice(b).remove(), this._controls.$absolute.find(".active").removeClass("active"), this._controls.$absolute.children().eq(a.inArray(this.current(), this._pages)).addClass("active"));
  }, e.prototype.onTrigger = function (b) {
    var c = this._core.settings;
    b.page = {
      index: a.inArray(this.current(), this._pages),
      count: this._pages.length,
      size: c && (c.center || c.autoWidth || c.dotsData ? 1 : c.dotsEach || c.items)
    };
  }, e.prototype.current = function () {
    var b = this._core.relative(this._core.current());
    return a.grep(this._pages, a.proxy(function (a, c) {
      return a.start <= b && a.end >= b;
    }, this)).pop();
  }, e.prototype.getPosition = function (b) {
    var c,
      d,
      e = this._core.settings;
    return "page" == e.slideBy ? (c = a.inArray(this.current(), this._pages), d = this._pages.length, b ? ++c : --c, c = this._pages[(c % d + d) % d].start) : (c = this._core.relative(this._core.current()), d = this._core.items().length, b ? c += e.slideBy : c -= e.slideBy), c;
  }, e.prototype.next = function (b) {
    a.proxy(this._overrides.to, this._core)(this.getPosition(!0), b);
  }, e.prototype.prev = function (b) {
    a.proxy(this._overrides.to, this._core)(this.getPosition(!1), b);
  }, e.prototype.to = function (b, c, d) {
    var e;
    !d && this._pages.length ? (e = this._pages.length, a.proxy(this._overrides.to, this._core)(this._pages[(b % e + e) % e].start, c)) : a.proxy(this._overrides.to, this._core)(b, c);
  }, a.fn.owlCarousel.Constructor.Plugins.Navigation = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  "use strict";

  var e = function e(c) {
    this._core = c, this._hashes = {}, this.$element = this._core.$element, this._handlers = {
      "initialized.owl.carousel": a.proxy(function (c) {
        c.namespace && "URLHash" === this._core.settings.startPosition && a(b).trigger("hashchange.owl.navigation");
      }, this),
      "prepared.owl.carousel": a.proxy(function (b) {
        if (b.namespace) {
          var c = a(b.content).find("[data-hash]").addBack("[data-hash]").attr("data-hash");
          if (!c) return;
          this._hashes[c] = b.content;
        }
      }, this),
      "changed.owl.carousel": a.proxy(function (c) {
        if (c.namespace && "position" === c.property.name) {
          var d = this._core.items(this._core.relative(this._core.current())),
            e = a.map(this._hashes, function (a, b) {
              return a === d ? b : null;
            }).join();
          if (!e || b.location.hash.slice(1) === e) return;
          b.location.hash = e;
        }
      }, this)
    }, this._core.options = a.extend({}, e.Defaults, this._core.options), this.$element.on(this._handlers), a(b).on("hashchange.owl.navigation", a.proxy(function (a) {
      var c = b.location.hash.substring(1),
        e = this._core.$stage.children(),
        f = this._hashes[c] && e.index(this._hashes[c]);
      f !== d && f !== this._core.current() && this._core.to(this._core.relative(f), !1, !0);
    }, this));
  };
  e.Defaults = {
    URLhashListener: !1
  }, e.prototype.destroy = function () {
    var c, d;
    a(b).off("hashchange.owl.navigation");
    for (c in this._handlers) this._core.$element.off(c, this._handlers[c]);
    for (d in Object.getOwnPropertyNames(this)) "function" != typeof this[d] && (this[d] = null);
  }, a.fn.owlCarousel.Constructor.Plugins.Hash = e;
}(window.Zepto || window.jQuery, window, document), function (a, b, c, d) {
  function e(b, c) {
    var e = !1,
      f = b.charAt(0).toUpperCase() + b.slice(1);
    return a.each((b + " " + h.join(f + " ") + f).split(" "), function (a, b) {
      if (g[b] !== d) return e = !c || b, !1;
    }), e;
  }
  function f(a) {
    return e(a, !0);
  }
  var g = a("<support>").get(0).style,
    h = "Webkit Moz O ms".split(" "),
    i = {
      transition: {
        end: {
          WebkitTransition: "webkitTransitionEnd",
          MozTransition: "transitionend",
          OTransition: "oTransitionEnd",
          transition: "transitionend"
        }
      },
      animation: {
        end: {
          WebkitAnimation: "webkitAnimationEnd",
          MozAnimation: "animationend",
          OAnimation: "oAnimationEnd",
          animation: "animationend"
        }
      }
    },
    j = {
      csstransforms: function csstransforms() {
        return !!e("transform");
      },
      csstransforms3d: function csstransforms3d() {
        return !!e("perspective");
      },
      csstransitions: function csstransitions() {
        return !!e("transition");
      },
      cssanimations: function cssanimations() {
        return !!e("animation");
      }
    };
  j.csstransitions() && (a.support.transition = new String(f("transition")), a.support.transition.end = i.transition.end[a.support.transition]), j.cssanimations() && (a.support.animation = new String(f("animation")), a.support.animation.end = i.animation.end[a.support.animation]), j.csstransforms() && (a.support.transform = new String(f("transform")), a.support.transform3d = j.csstransforms3d());
}(window.Zepto || window.jQuery, window, document);

/***/ }),

/***/ "./public/frontend/amazy/js/parallax.js":
/*!**********************************************!*\
  !*** ./public/frontend/amazy/js/parallax.js ***!
  \**********************************************/
/***/ (() => {

/**
 * jQuery || Zepto Parallax Plugin
 * @author Matthew Wagerfield - @wagerfield
 * @description Creates a parallax effect between an array of layers,
 *              driving the motion from the gyroscope output of a smartdevice.
 *              If no gyroscope is available, the cursor position is used.
 */
;
(function ($, window, document, undefined) {
  // Strict Mode
  'use strict';

  // Constants
  var NAME = 'parallax';
  var MAGIC_NUMBER = 30;
  var DEFAULTS = {
    relativeInput: false,
    clipRelativeInput: false,
    calibrationThreshold: 100,
    calibrationDelay: 500,
    supportDelay: 500,
    calibrateX: false,
    calibrateY: true,
    invertX: true,
    invertY: true,
    limitX: false,
    limitY: false,
    scalarX: 10.0,
    scalarY: 10.0,
    frictionX: 0.1,
    frictionY: 0.1,
    originX: 0.5,
    originY: 0.5,
    pointerEvents: true,
    precision: 1
  };
  function Plugin(element, options) {
    // DOM Context
    this.element = element;

    // Selections
    this.$context = $(element).data('api', this);
    this.$layers = this.$context.find('.layer');

    // Data Extraction
    var data = {
      calibrateX: this.$context.data('calibrate-x') || null,
      calibrateY: this.$context.data('calibrate-y') || null,
      invertX: this.$context.data('invert-x') || null,
      invertY: this.$context.data('invert-y') || null,
      limitX: parseFloat(this.$context.data('limit-x')) || null,
      limitY: parseFloat(this.$context.data('limit-y')) || null,
      scalarX: parseFloat(this.$context.data('scalar-x')) || null,
      scalarY: parseFloat(this.$context.data('scalar-y')) || null,
      frictionX: parseFloat(this.$context.data('friction-x')) || null,
      frictionY: parseFloat(this.$context.data('friction-y')) || null,
      originX: parseFloat(this.$context.data('origin-x')) || null,
      originY: parseFloat(this.$context.data('origin-y')) || null,
      pointerEvents: this.$context.data('pointer-events') || true,
      precision: parseFloat(this.$context.data('precision')) || 1
    };

    // Delete Null Data Values
    for (var key in data) {
      if (data[key] === null) delete data[key];
    }

    // Compose Settings Object
    $.extend(this, DEFAULTS, options, data);

    // States
    this.calibrationTimer = null;
    this.calibrationFlag = true;
    this.enabled = false;
    this.depthsX = [];
    this.depthsY = [];
    this.raf = null;

    // Element Bounds
    this.bounds = null;
    this.ex = 0;
    this.ey = 0;
    this.ew = 0;
    this.eh = 0;

    // Element Center
    this.ecx = 0;
    this.ecy = 0;

    // Element Range
    this.erx = 0;
    this.ery = 0;

    // Calibration
    this.cx = 0;
    this.cy = 0;

    // Input
    this.ix = 0;
    this.iy = 0;

    // Motion
    this.mx = 0;
    this.my = 0;

    // Velocity
    this.vx = 0;
    this.vy = 0;

    // Callbacks
    this.onMouseMove = this.onMouseMove.bind(this);
    this.onDeviceOrientation = this.onDeviceOrientation.bind(this);
    this.onOrientationTimer = this.onOrientationTimer.bind(this);
    this.onCalibrationTimer = this.onCalibrationTimer.bind(this);
    this.onAnimationFrame = this.onAnimationFrame.bind(this);
    this.onWindowResize = this.onWindowResize.bind(this);

    // Initialise
    this.initialise();
  }
  Plugin.prototype.transformSupport = function (value) {
    var element = document.createElement('div');
    var propertySupport = false;
    var propertyValue = null;
    var featureSupport = false;
    var cssProperty = null;
    var jsProperty = null;
    for (var i = 0, l = this.vendors.length; i < l; i++) {
      if (this.vendors[i] !== null) {
        cssProperty = this.vendors[i][0] + 'transform';
        jsProperty = this.vendors[i][1] + 'Transform';
      } else {
        cssProperty = 'transform';
        jsProperty = 'transform';
      }
      if (element.style[jsProperty] !== undefined) {
        propertySupport = true;
        break;
      }
    }
    switch (value) {
      case '2D':
        featureSupport = propertySupport;
        break;
      case '3D':
        if (propertySupport) {
          var body = document.body || document.createElement('body');
          var documentElement = document.documentElement;
          var documentOverflow = documentElement.style.overflow;
          var isCreatedBody = false;
          if (!document.body) {
            isCreatedBody = true;
            documentElement.style.overflow = 'hidden';
            documentElement.appendChild(body);
            body.style.overflow = 'hidden';
            body.style.background = '';
          }
          body.appendChild(element);
          element.style[jsProperty] = 'translate3d(1px,1px,1px)';
          propertyValue = window.getComputedStyle(element).getPropertyValue(cssProperty);
          featureSupport = propertyValue !== undefined && propertyValue.length > 0 && propertyValue !== "none";
          documentElement.style.overflow = documentOverflow;
          body.removeChild(element);
          if (isCreatedBody) {
            body.removeAttribute('style');
            body.parentNode.removeChild(body);
          }
        }
        break;
    }
    return featureSupport;
  };
  Plugin.prototype.ww = null;
  Plugin.prototype.wh = null;
  Plugin.prototype.wcx = null;
  Plugin.prototype.wcy = null;
  Plugin.prototype.wrx = null;
  Plugin.prototype.wry = null;
  Plugin.prototype.portrait = null;
  Plugin.prototype.desktop = !navigator.userAgent.match(/(iPhone|iPod|iPad|Android|BlackBerry|BB10|mobi|tablet|opera mini|nexus 7)/i);
  Plugin.prototype.vendors = [null, ['-webkit-', 'webkit'], ['-moz-', 'Moz'], ['-o-', 'O'], ['-ms-', 'ms']];
  Plugin.prototype.motionSupport = !!window.DeviceMotionEvent;
  Plugin.prototype.orientationSupport = !!window.DeviceOrientationEvent;
  Plugin.prototype.orientationStatus = 0;
  Plugin.prototype.transform2DSupport = Plugin.prototype.transformSupport('2D');
  Plugin.prototype.transform3DSupport = Plugin.prototype.transformSupport('3D');
  Plugin.prototype.propertyCache = {};
  Plugin.prototype.initialise = function () {
    // Configure Styles
    if (this.$context.css('position') === 'static') {
      this.$context.css({
        position: 'relative'
      });
    }

    // Pointer events
    if (!this.pointerEvents) {
      this.$context.css({
        pointerEvents: 'none'
      });
    }

    // Hardware Accelerate Context
    this.accelerate(this.$context);

    // Setup
    this.updateLayers();
    this.updateDimensions();
    this.enable();
    this.queueCalibration(this.calibrationDelay);
  };
  Plugin.prototype.updateLayers = function () {
    // Cache Layer Elements
    this.$layers = this.$context.find('.layer');
    this.depthsX = [];
    this.depthsY = [];

    // Configure Layer Styles
    this.$layers.css({
      position: 'absolute',
      display: 'block',
      left: 0,
      top: 0
    });
    this.$layers.first().css({
      position: 'relative'
    });

    // Hardware Accelerate Layers
    this.accelerate(this.$layers);

    // Cache Depths
    this.$layers.each($.proxy(function (index, element) {
      //Graceful fallback on depth if depth-x or depth-y is absent
      var depth = $(element).data('depth') || 0;
      this.depthsX.push($(element).data('depth-x') || depth);
      this.depthsY.push($(element).data('depth-y') || depth);
    }, this));
  };
  Plugin.prototype.updateDimensions = function () {
    this.ww = window.innerWidth;
    this.wh = window.innerHeight;
    this.wcx = this.ww * this.originX;
    this.wcy = this.wh * this.originY;
    this.wrx = Math.max(this.wcx, this.ww - this.wcx);
    this.wry = Math.max(this.wcy, this.wh - this.wcy);
  };
  Plugin.prototype.updateBounds = function () {
    this.bounds = this.element.getBoundingClientRect();
    this.ex = this.bounds.left;
    this.ey = this.bounds.top;
    this.ew = this.bounds.width;
    this.eh = this.bounds.height;
    this.ecx = this.ew * this.originX;
    this.ecy = this.eh * this.originY;
    this.erx = Math.max(this.ecx, this.ew - this.ecx);
    this.ery = Math.max(this.ecy, this.eh - this.ecy);
  };
  Plugin.prototype.queueCalibration = function (delay) {
    clearTimeout(this.calibrationTimer);
    this.calibrationTimer = setTimeout(this.onCalibrationTimer, delay);
  };
  Plugin.prototype.enable = function () {
    if (!this.enabled) {
      this.enabled = true;
      if (this.orientationSupport) {
        this.portrait = null;
        window.addEventListener('deviceorientation', this.onDeviceOrientation);
        setTimeout(this.onOrientationTimer, this.supportDelay);
      } else {
        this.cx = 0;
        this.cy = 0;
        this.portrait = false;
        window.addEventListener('mousemove', this.onMouseMove);
      }
      window.addEventListener('resize', this.onWindowResize);
      this.raf = requestAnimationFrame(this.onAnimationFrame);
    }
  };
  Plugin.prototype.disable = function () {
    if (this.enabled) {
      this.enabled = false;
      if (this.orientationSupport) {
        window.removeEventListener('deviceorientation', this.onDeviceOrientation);
      } else {
        window.removeEventListener('mousemove', this.onMouseMove);
      }
      window.removeEventListener('resize', this.onWindowResize);
      cancelAnimationFrame(this.raf);
    }
  };
  Plugin.prototype.calibrate = function (x, y) {
    this.calibrateX = x === undefined ? this.calibrateX : x;
    this.calibrateY = y === undefined ? this.calibrateY : y;
  };
  Plugin.prototype.invert = function (x, y) {
    this.invertX = x === undefined ? this.invertX : x;
    this.invertY = y === undefined ? this.invertY : y;
  };
  Plugin.prototype.friction = function (x, y) {
    this.frictionX = x === undefined ? this.frictionX : x;
    this.frictionY = y === undefined ? this.frictionY : y;
  };
  Plugin.prototype.scalar = function (x, y) {
    this.scalarX = x === undefined ? this.scalarX : x;
    this.scalarY = y === undefined ? this.scalarY : y;
  };
  Plugin.prototype.limit = function (x, y) {
    this.limitX = x === undefined ? this.limitX : x;
    this.limitY = y === undefined ? this.limitY : y;
  };
  Plugin.prototype.origin = function (x, y) {
    this.originX = x === undefined ? this.originX : x;
    this.originY = y === undefined ? this.originY : y;
  };
  Plugin.prototype.clamp = function (value, min, max) {
    value = Math.max(value, min);
    value = Math.min(value, max);
    return value;
  };
  Plugin.prototype.css = function (element, property, value) {
    var jsProperty = this.propertyCache[property];
    if (!jsProperty) {
      for (var i = 0, l = this.vendors.length; i < l; i++) {
        if (this.vendors[i] !== null) {
          jsProperty = $.camelCase(this.vendors[i][1] + '-' + property);
        } else {
          jsProperty = property;
        }
        if (element.style[jsProperty] !== undefined) {
          this.propertyCache[property] = jsProperty;
          break;
        }
      }
    }
    element.style[jsProperty] = value;
  };
  Plugin.prototype.accelerate = function ($element) {
    for (var i = 0, l = $element.length; i < l; i++) {
      var element = $element[i];
      this.css(element, 'transform', 'translate3d(0,0,0)');
      this.css(element, 'transform-style', 'preserve-3d');
      this.css(element, 'backface-visibility', 'hidden');
    }
  };
  Plugin.prototype.setPosition = function (element, x, y) {
    x += 'px';
    y += 'px';
    if (this.transform3DSupport) {
      this.css(element, 'transform', 'translate3d(' + x + ',' + y + ',0)');
    } else if (this.transform2DSupport) {
      this.css(element, 'transform', 'translate(' + x + ',' + y + ')');
    } else {
      element.style.left = x;
      element.style.top = y;
    }
  };
  Plugin.prototype.onOrientationTimer = function (event) {
    if (this.orientationSupport && this.orientationStatus === 0) {
      this.disable();
      this.orientationSupport = false;
      this.enable();
    }
  };
  Plugin.prototype.onCalibrationTimer = function (event) {
    this.calibrationFlag = true;
  };
  Plugin.prototype.onWindowResize = function (event) {
    this.updateDimensions();
  };
  Plugin.prototype.onAnimationFrame = function () {
    this.updateBounds();
    var dx = this.ix - this.cx;
    var dy = this.iy - this.cy;
    if (Math.abs(dx) > this.calibrationThreshold || Math.abs(dy) > this.calibrationThreshold) {
      this.queueCalibration(0);
    }
    if (this.portrait) {
      this.mx = this.calibrateX ? dy : this.iy;
      this.my = this.calibrateY ? dx : this.ix;
    } else {
      this.mx = this.calibrateX ? dx : this.ix;
      this.my = this.calibrateY ? dy : this.iy;
    }
    this.mx *= this.ew * (this.scalarX / 100);
    this.my *= this.eh * (this.scalarY / 100);
    if (!isNaN(parseFloat(this.limitX))) {
      this.mx = this.clamp(this.mx, -this.limitX, this.limitX);
    }
    if (!isNaN(parseFloat(this.limitY))) {
      this.my = this.clamp(this.my, -this.limitY, this.limitY);
    }
    this.vx += (this.mx - this.vx) * this.frictionX;
    this.vy += (this.my - this.vy) * this.frictionY;
    for (var i = 0, l = this.$layers.length; i < l; i++) {
      var depthX = this.depthsX[i];
      var depthY = this.depthsY[i];
      var layer = this.$layers[i];
      var xOffset = this.vx * (depthX * (this.invertX ? -1 : 1));
      var yOffset = this.vy * (depthY * (this.invertY ? -1 : 1));
      this.setPosition(layer, xOffset, yOffset);
    }
    this.raf = requestAnimationFrame(this.onAnimationFrame);
  };
  Plugin.prototype.onDeviceOrientation = function (event) {
    // Validate environment and event properties.
    if (!this.desktop && event.beta !== null && event.gamma !== null) {
      // Set orientation status.
      this.orientationStatus = 1;

      // Extract Rotation
      var x = (event.beta || 0) / MAGIC_NUMBER; //  -90 :: 90
      var y = (event.gamma || 0) / MAGIC_NUMBER; // -180 :: 180

      // Detect Orientation Change
      var portrait = window.innerHeight > window.innerWidth;
      if (this.portrait !== portrait) {
        this.portrait = portrait;
        this.calibrationFlag = true;
      }

      // Set Calibration
      if (this.calibrationFlag) {
        this.calibrationFlag = false;
        this.cx = x;
        this.cy = y;
      }

      // Set Input
      this.ix = x;
      this.iy = y;
    }
  };
  Plugin.prototype.onMouseMove = function (event) {
    // Cache mouse coordinates.
    var clientX = event.clientX;
    var clientY = event.clientY;

    // Calculate Mouse Input
    if (!this.orientationSupport && this.relativeInput) {
      // Clip mouse coordinates inside element bounds.
      if (this.clipRelativeInput) {
        clientX = Math.max(clientX, this.ex);
        clientX = Math.min(clientX, this.ex + this.ew);
        clientY = Math.max(clientY, this.ey);
        clientY = Math.min(clientY, this.ey + this.eh);
      }

      // Calculate input relative to the element.
      this.ix = (clientX - this.ex - this.ecx) / this.erx;
      this.iy = (clientY - this.ey - this.ecy) / this.ery;
    } else {
      // Calculate input relative to the window.
      this.ix = (clientX - this.wcx) / this.wrx;
      this.iy = (clientY - this.wcy) / this.wry;
    }
  };
  var API = {
    enable: Plugin.prototype.enable,
    disable: Plugin.prototype.disable,
    updateLayers: Plugin.prototype.updateLayers,
    calibrate: Plugin.prototype.calibrate,
    friction: Plugin.prototype.friction,
    invert: Plugin.prototype.invert,
    scalar: Plugin.prototype.scalar,
    limit: Plugin.prototype.limit,
    origin: Plugin.prototype.origin
  };
  $.fn[NAME] = function (value) {
    var args = arguments;
    return this.each(function () {
      var $this = $(this);
      var plugin = $this.data(NAME);
      if (!plugin) {
        plugin = new Plugin(this, value);
        $this.data(NAME, plugin);
      }
      if (API[value]) {
        plugin[value].apply(plugin, Array.prototype.slice.call(args, 1));
      }
    });
  };
})(window.jQuery || window.Zepto, window, document);

/***/ }),

/***/ "./public/frontend/amazy/js/perfect-scrollbar.js":
/*!*******************************************************!*\
  !*** ./public/frontend/amazy/js/perfect-scrollbar.js ***!
  \*******************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
/*!
 * perfect-scrollbar v1.5.2
 * Copyright 2021 Hyunje Jun, MDBootstrap and Contributors
 * Licensed under MIT
 */

(function (global, factory) {
  ( false ? 0 : _typeof(exports)) === 'object' && "object" !== 'undefined' ? module.exports = factory() :  true ? !(__WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
		__WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)) : (0);
})(this, function () {
  'use strict';

  function get(element) {
    return getComputedStyle(element);
  }
  function set(element, obj) {
    for (var key in obj) {
      var val = obj[key];
      if (typeof val === 'number') {
        val = val + "px";
      }
      element.style[key] = val;
    }
    return element;
  }
  function div(className) {
    var div = document.createElement('div');
    div.className = className;
    return div;
  }
  var elMatches = typeof Element !== 'undefined' && (Element.prototype.matches || Element.prototype.webkitMatchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector);
  function matches(element, query) {
    if (!elMatches) {
      throw new Error('No element matching method supported');
    }
    return elMatches.call(element, query);
  }
  function remove(element) {
    if (element.remove) {
      element.remove();
    } else {
      if (element.parentNode) {
        element.parentNode.removeChild(element);
      }
    }
  }
  function queryChildren(element, selector) {
    return Array.prototype.filter.call(element.children, function (child) {
      return matches(child, selector);
    });
  }
  var cls = {
    main: 'ps',
    rtl: 'ps__rtl',
    element: {
      thumb: function thumb(x) {
        return "ps__thumb-" + x;
      },
      rail: function rail(x) {
        return "ps__rail-" + x;
      },
      consuming: 'ps__child--consume'
    },
    state: {
      focus: 'ps--focus',
      clicking: 'ps--clicking',
      active: function active(x) {
        return "ps--active-" + x;
      },
      scrolling: function scrolling(x) {
        return "ps--scrolling-" + x;
      }
    }
  };

  /*
   * Helper methods
   */
  var scrollingClassTimeout = {
    x: null,
    y: null
  };
  function addScrollingClass(i, x) {
    var classList = i.element.classList;
    var className = cls.state.scrolling(x);
    if (classList.contains(className)) {
      clearTimeout(scrollingClassTimeout[x]);
    } else {
      classList.add(className);
    }
  }
  function removeScrollingClass(i, x) {
    scrollingClassTimeout[x] = setTimeout(function () {
      return i.isAlive && i.element.classList.remove(cls.state.scrolling(x));
    }, i.settings.scrollingThreshold);
  }
  function setScrollingClassInstantly(i, x) {
    addScrollingClass(i, x);
    removeScrollingClass(i, x);
  }
  var EventElement = function EventElement(element) {
    this.element = element;
    this.handlers = {};
  };
  var prototypeAccessors = {
    isEmpty: {
      configurable: true
    }
  };
  EventElement.prototype.bind = function bind(eventName, handler) {
    if (typeof this.handlers[eventName] === 'undefined') {
      this.handlers[eventName] = [];
    }
    this.handlers[eventName].push(handler);
    this.element.addEventListener(eventName, handler, false);
  };
  EventElement.prototype.unbind = function unbind(eventName, target) {
    var this$1 = this;
    this.handlers[eventName] = this.handlers[eventName].filter(function (handler) {
      if (target && handler !== target) {
        return true;
      }
      this$1.element.removeEventListener(eventName, handler, false);
      return false;
    });
  };
  EventElement.prototype.unbindAll = function unbindAll() {
    for (var name in this.handlers) {
      this.unbind(name);
    }
  };
  prototypeAccessors.isEmpty.get = function () {
    var this$1 = this;
    return Object.keys(this.handlers).every(function (key) {
      return this$1.handlers[key].length === 0;
    });
  };
  Object.defineProperties(EventElement.prototype, prototypeAccessors);
  var EventManager = function EventManager() {
    this.eventElements = [];
  };
  EventManager.prototype.eventElement = function eventElement(element) {
    var ee = this.eventElements.filter(function (ee) {
      return ee.element === element;
    })[0];
    if (!ee) {
      ee = new EventElement(element);
      this.eventElements.push(ee);
    }
    return ee;
  };
  EventManager.prototype.bind = function bind(element, eventName, handler) {
    this.eventElement(element).bind(eventName, handler);
  };
  EventManager.prototype.unbind = function unbind(element, eventName, handler) {
    var ee = this.eventElement(element);
    ee.unbind(eventName, handler);
    if (ee.isEmpty) {
      // remove
      this.eventElements.splice(this.eventElements.indexOf(ee), 1);
    }
  };
  EventManager.prototype.unbindAll = function unbindAll() {
    this.eventElements.forEach(function (e) {
      return e.unbindAll();
    });
    this.eventElements = [];
  };
  EventManager.prototype.once = function once(element, eventName, handler) {
    var ee = this.eventElement(element);
    var onceHandler = function onceHandler(evt) {
      ee.unbind(eventName, onceHandler);
      handler(evt);
    };
    ee.bind(eventName, onceHandler);
  };
  function createEvent(name) {
    if (typeof window.CustomEvent === 'function') {
      return new CustomEvent(name);
    } else {
      var evt = document.createEvent('CustomEvent');
      evt.initCustomEvent(name, false, false, undefined);
      return evt;
    }
  }
  function processScrollDiff(i, axis, diff, useScrollingClass, forceFireReachEvent) {
    if (useScrollingClass === void 0) useScrollingClass = true;
    if (forceFireReachEvent === void 0) forceFireReachEvent = false;
    var fields;
    if (axis === 'top') {
      fields = ['contentHeight', 'containerHeight', 'scrollTop', 'y', 'up', 'down'];
    } else if (axis === 'left') {
      fields = ['contentWidth', 'containerWidth', 'scrollLeft', 'x', 'left', 'right'];
    } else {
      throw new Error('A proper axis should be provided');
    }
    processScrollDiff$1(i, diff, fields, useScrollingClass, forceFireReachEvent);
  }
  function processScrollDiff$1(i, diff, ref, useScrollingClass, forceFireReachEvent) {
    var contentHeight = ref[0];
    var containerHeight = ref[1];
    var scrollTop = ref[2];
    var y = ref[3];
    var up = ref[4];
    var down = ref[5];
    if (useScrollingClass === void 0) useScrollingClass = true;
    if (forceFireReachEvent === void 0) forceFireReachEvent = false;
    var element = i.element;

    // reset reach
    i.reach[y] = null;

    // 1 for subpixel rounding
    if (element[scrollTop] < 1) {
      i.reach[y] = 'start';
    }

    // 1 for subpixel rounding
    if (element[scrollTop] > i[contentHeight] - i[containerHeight] - 1) {
      i.reach[y] = 'end';
    }
    if (diff) {
      element.dispatchEvent(createEvent("ps-scroll-" + y));
      if (diff < 0) {
        element.dispatchEvent(createEvent("ps-scroll-" + up));
      } else if (diff > 0) {
        element.dispatchEvent(createEvent("ps-scroll-" + down));
      }
      if (useScrollingClass) {
        setScrollingClassInstantly(i, y);
      }
    }
    if (i.reach[y] && (diff || forceFireReachEvent)) {
      element.dispatchEvent(createEvent("ps-" + y + "-reach-" + i.reach[y]));
    }
  }
  function toInt(x) {
    return parseInt(x, 10) || 0;
  }
  function isEditable(el) {
    return matches(el, 'input,[contenteditable]') || matches(el, 'select,[contenteditable]') || matches(el, 'textarea,[contenteditable]') || matches(el, 'button,[contenteditable]');
  }
  function outerWidth(element) {
    var styles = get(element);
    return toInt(styles.width) + toInt(styles.paddingLeft) + toInt(styles.paddingRight) + toInt(styles.borderLeftWidth) + toInt(styles.borderRightWidth);
  }
  var env = {
    isWebKit: typeof document !== 'undefined' && 'WebkitAppearance' in document.documentElement.style,
    supportsTouch: typeof window !== 'undefined' && ('ontouchstart' in window || 'maxTouchPoints' in window.navigator && window.navigator.maxTouchPoints > 0 || window.DocumentTouch && document instanceof window.DocumentTouch),
    supportsIePointer: typeof navigator !== 'undefined' && navigator.msMaxTouchPoints,
    isChrome: typeof navigator !== 'undefined' && /Chrome/i.test(navigator && navigator.userAgent)
  };
  function updateGeometry(i) {
    var element = i.element;
    var roundedScrollTop = Math.floor(element.scrollTop);
    var rect = element.getBoundingClientRect();
    i.containerWidth = Math.round(rect.width);
    i.containerHeight = Math.round(rect.height);
    i.contentWidth = element.scrollWidth;
    i.contentHeight = element.scrollHeight;
    if (!element.contains(i.scrollbarXRail)) {
      // clean up and append
      queryChildren(element, cls.element.rail('x')).forEach(function (el) {
        return remove(el);
      });
      element.appendChild(i.scrollbarXRail);
    }
    if (!element.contains(i.scrollbarYRail)) {
      // clean up and append
      queryChildren(element, cls.element.rail('y')).forEach(function (el) {
        return remove(el);
      });
      element.appendChild(i.scrollbarYRail);
    }
    if (!i.settings.suppressScrollX && i.containerWidth + i.settings.scrollXMarginOffset < i.contentWidth) {
      i.scrollbarXActive = true;
      i.railXWidth = i.containerWidth - i.railXMarginWidth;
      i.railXRatio = i.containerWidth / i.railXWidth;
      i.scrollbarXWidth = getThumbSize(i, toInt(i.railXWidth * i.containerWidth / i.contentWidth));
      i.scrollbarXLeft = toInt((i.negativeScrollAdjustment + element.scrollLeft) * (i.railXWidth - i.scrollbarXWidth) / (i.contentWidth - i.containerWidth));
    } else {
      i.scrollbarXActive = false;
    }
    if (!i.settings.suppressScrollY && i.containerHeight + i.settings.scrollYMarginOffset < i.contentHeight) {
      i.scrollbarYActive = true;
      i.railYHeight = i.containerHeight - i.railYMarginHeight;
      i.railYRatio = i.containerHeight / i.railYHeight;
      i.scrollbarYHeight = getThumbSize(i, toInt(i.railYHeight * i.containerHeight / i.contentHeight));
      i.scrollbarYTop = toInt(roundedScrollTop * (i.railYHeight - i.scrollbarYHeight) / (i.contentHeight - i.containerHeight));
    } else {
      i.scrollbarYActive = false;
    }
    if (i.scrollbarXLeft >= i.railXWidth - i.scrollbarXWidth) {
      i.scrollbarXLeft = i.railXWidth - i.scrollbarXWidth;
    }
    if (i.scrollbarYTop >= i.railYHeight - i.scrollbarYHeight) {
      i.scrollbarYTop = i.railYHeight - i.scrollbarYHeight;
    }
    updateCss(element, i);
    if (i.scrollbarXActive) {
      element.classList.add(cls.state.active('x'));
    } else {
      element.classList.remove(cls.state.active('x'));
      i.scrollbarXWidth = 0;
      i.scrollbarXLeft = 0;
      element.scrollLeft = i.isRtl === true ? i.contentWidth : 0;
    }
    if (i.scrollbarYActive) {
      element.classList.add(cls.state.active('y'));
    } else {
      element.classList.remove(cls.state.active('y'));
      i.scrollbarYHeight = 0;
      i.scrollbarYTop = 0;
      element.scrollTop = 0;
    }
  }
  function getThumbSize(i, thumbSize) {
    if (i.settings.minScrollbarLength) {
      thumbSize = Math.max(thumbSize, i.settings.minScrollbarLength);
    }
    if (i.settings.maxScrollbarLength) {
      thumbSize = Math.min(thumbSize, i.settings.maxScrollbarLength);
    }
    return thumbSize;
  }
  function updateCss(element, i) {
    var xRailOffset = {
      width: i.railXWidth
    };
    var roundedScrollTop = Math.floor(element.scrollTop);
    if (i.isRtl) {
      xRailOffset.left = i.negativeScrollAdjustment + element.scrollLeft + i.containerWidth - i.contentWidth;
    } else {
      xRailOffset.left = element.scrollLeft;
    }
    if (i.isScrollbarXUsingBottom) {
      xRailOffset.bottom = i.scrollbarXBottom - roundedScrollTop;
    } else {
      xRailOffset.top = i.scrollbarXTop + roundedScrollTop;
    }
    set(i.scrollbarXRail, xRailOffset);
    var yRailOffset = {
      top: roundedScrollTop,
      height: i.railYHeight
    };
    if (i.isScrollbarYUsingRight) {
      if (i.isRtl) {
        yRailOffset.right = i.contentWidth - (i.negativeScrollAdjustment + element.scrollLeft) - i.scrollbarYRight - i.scrollbarYOuterWidth - 9;
      } else {
        yRailOffset.right = i.scrollbarYRight - element.scrollLeft;
      }
    } else {
      if (i.isRtl) {
        yRailOffset.left = i.negativeScrollAdjustment + element.scrollLeft + i.containerWidth * 2 - i.contentWidth - i.scrollbarYLeft - i.scrollbarYOuterWidth;
      } else {
        yRailOffset.left = i.scrollbarYLeft + element.scrollLeft;
      }
    }
    set(i.scrollbarYRail, yRailOffset);
    set(i.scrollbarX, {
      left: i.scrollbarXLeft,
      width: i.scrollbarXWidth - i.railBorderXWidth
    });
    set(i.scrollbarY, {
      top: i.scrollbarYTop,
      height: i.scrollbarYHeight - i.railBorderYWidth
    });
  }
  function clickRail(i) {
    var element = i.element;
    i.event.bind(i.scrollbarY, 'mousedown', function (e) {
      return e.stopPropagation();
    });
    i.event.bind(i.scrollbarYRail, 'mousedown', function (e) {
      var positionTop = e.pageY - window.pageYOffset - i.scrollbarYRail.getBoundingClientRect().top;
      var direction = positionTop > i.scrollbarYTop ? 1 : -1;
      i.element.scrollTop += direction * i.containerHeight;
      updateGeometry(i);
      e.stopPropagation();
    });
    i.event.bind(i.scrollbarX, 'mousedown', function (e) {
      return e.stopPropagation();
    });
    i.event.bind(i.scrollbarXRail, 'mousedown', function (e) {
      var positionLeft = e.pageX - window.pageXOffset - i.scrollbarXRail.getBoundingClientRect().left;
      var direction = positionLeft > i.scrollbarXLeft ? 1 : -1;
      i.element.scrollLeft += direction * i.containerWidth;
      updateGeometry(i);
      e.stopPropagation();
    });
  }
  function dragThumb(i) {
    bindMouseScrollHandler(i, ['containerWidth', 'contentWidth', 'pageX', 'railXWidth', 'scrollbarX', 'scrollbarXWidth', 'scrollLeft', 'x', 'scrollbarXRail']);
    bindMouseScrollHandler(i, ['containerHeight', 'contentHeight', 'pageY', 'railYHeight', 'scrollbarY', 'scrollbarYHeight', 'scrollTop', 'y', 'scrollbarYRail']);
  }
  function bindMouseScrollHandler(i, ref) {
    var containerHeight = ref[0];
    var contentHeight = ref[1];
    var pageY = ref[2];
    var railYHeight = ref[3];
    var scrollbarY = ref[4];
    var scrollbarYHeight = ref[5];
    var scrollTop = ref[6];
    var y = ref[7];
    var scrollbarYRail = ref[8];
    var element = i.element;
    var startingScrollTop = null;
    var startingMousePageY = null;
    var scrollBy = null;
    function mouseMoveHandler(e) {
      if (e.touches && e.touches[0]) {
        e[pageY] = e.touches[0].pageY;
      }
      element[scrollTop] = startingScrollTop + scrollBy * (e[pageY] - startingMousePageY);
      addScrollingClass(i, y);
      updateGeometry(i);
      e.stopPropagation();
      e.preventDefault();
    }
    function mouseUpHandler() {
      removeScrollingClass(i, y);
      i[scrollbarYRail].classList.remove(cls.state.clicking);
      i.event.unbind(i.ownerDocument, 'mousemove', mouseMoveHandler);
    }
    function bindMoves(e, touchMode) {
      startingScrollTop = element[scrollTop];
      if (touchMode && e.touches) {
        e[pageY] = e.touches[0].pageY;
      }
      startingMousePageY = e[pageY];
      scrollBy = (i[contentHeight] - i[containerHeight]) / (i[railYHeight] - i[scrollbarYHeight]);
      if (!touchMode) {
        i.event.bind(i.ownerDocument, 'mousemove', mouseMoveHandler);
        i.event.once(i.ownerDocument, 'mouseup', mouseUpHandler);
        e.preventDefault();
      } else {
        i.event.bind(i.ownerDocument, 'touchmove', mouseMoveHandler);
      }
      i[scrollbarYRail].classList.add(cls.state.clicking);
      e.stopPropagation();
    }
    i.event.bind(i[scrollbarY], 'mousedown', function (e) {
      bindMoves(e);
    });
    i.event.bind(i[scrollbarY], 'touchstart', function (e) {
      bindMoves(e, true);
    });
  }
  function keyboard(i) {
    var element = i.element;
    var elementHovered = function elementHovered() {
      return matches(element, ':hover');
    };
    var scrollbarFocused = function scrollbarFocused() {
      return matches(i.scrollbarX, ':focus') || matches(i.scrollbarY, ':focus');
    };
    function shouldPreventDefault(deltaX, deltaY) {
      var scrollTop = Math.floor(element.scrollTop);
      if (deltaX === 0) {
        if (!i.scrollbarYActive) {
          return false;
        }
        if (scrollTop === 0 && deltaY > 0 || scrollTop >= i.contentHeight - i.containerHeight && deltaY < 0) {
          return !i.settings.wheelPropagation;
        }
      }
      var scrollLeft = element.scrollLeft;
      if (deltaY === 0) {
        if (!i.scrollbarXActive) {
          return false;
        }
        if (scrollLeft === 0 && deltaX < 0 || scrollLeft >= i.contentWidth - i.containerWidth && deltaX > 0) {
          return !i.settings.wheelPropagation;
        }
      }
      return true;
    }
    i.event.bind(i.ownerDocument, 'keydown', function (e) {
      if (e.isDefaultPrevented && e.isDefaultPrevented() || e.defaultPrevented) {
        return;
      }
      if (!elementHovered() && !scrollbarFocused()) {
        return;
      }
      var activeElement = document.activeElement ? document.activeElement : i.ownerDocument.activeElement;
      if (activeElement) {
        if (activeElement.tagName === 'IFRAME') {
          activeElement = activeElement.contentDocument.activeElement;
        } else {
          // go deeper if element is a webcomponent
          while (activeElement.shadowRoot) {
            activeElement = activeElement.shadowRoot.activeElement;
          }
        }
        if (isEditable(activeElement)) {
          return;
        }
      }
      var deltaX = 0;
      var deltaY = 0;
      switch (e.which) {
        case 37:
          // left
          if (e.metaKey) {
            deltaX = -i.contentWidth;
          } else if (e.altKey) {
            deltaX = -i.containerWidth;
          } else {
            deltaX = -30;
          }
          break;
        case 38:
          // up
          if (e.metaKey) {
            deltaY = i.contentHeight;
          } else if (e.altKey) {
            deltaY = i.containerHeight;
          } else {
            deltaY = 30;
          }
          break;
        case 39:
          // right
          if (e.metaKey) {
            deltaX = i.contentWidth;
          } else if (e.altKey) {
            deltaX = i.containerWidth;
          } else {
            deltaX = 30;
          }
          break;
        case 40:
          // down
          if (e.metaKey) {
            deltaY = -i.contentHeight;
          } else if (e.altKey) {
            deltaY = -i.containerHeight;
          } else {
            deltaY = -30;
          }
          break;
        case 32:
          // space bar
          if (e.shiftKey) {
            deltaY = i.containerHeight;
          } else {
            deltaY = -i.containerHeight;
          }
          break;
        case 33:
          // page up
          deltaY = i.containerHeight;
          break;
        case 34:
          // page down
          deltaY = -i.containerHeight;
          break;
        case 36:
          // home
          deltaY = i.contentHeight;
          break;
        case 35:
          // end
          deltaY = -i.contentHeight;
          break;
        default:
          return;
      }
      if (i.settings.suppressScrollX && deltaX !== 0) {
        return;
      }
      if (i.settings.suppressScrollY && deltaY !== 0) {
        return;
      }
      element.scrollTop -= deltaY;
      element.scrollLeft += deltaX;
      updateGeometry(i);
      if (shouldPreventDefault(deltaX, deltaY)) {
        e.preventDefault();
      }
    });
  }
  function wheel(i) {
    var element = i.element;
    function shouldPreventDefault(deltaX, deltaY) {
      var roundedScrollTop = Math.floor(element.scrollTop);
      var isTop = element.scrollTop === 0;
      var isBottom = roundedScrollTop + element.offsetHeight === element.scrollHeight;
      var isLeft = element.scrollLeft === 0;
      var isRight = element.scrollLeft + element.offsetWidth === element.scrollWidth;
      var hitsBound;

      // pick axis with primary direction
      if (Math.abs(deltaY) > Math.abs(deltaX)) {
        hitsBound = isTop || isBottom;
      } else {
        hitsBound = isLeft || isRight;
      }
      return hitsBound ? !i.settings.wheelPropagation : true;
    }
    function getDeltaFromEvent(e) {
      var deltaX = e.deltaX;
      var deltaY = -1 * e.deltaY;
      if (typeof deltaX === 'undefined' || typeof deltaY === 'undefined') {
        // OS X Safari
        deltaX = -1 * e.wheelDeltaX / 6;
        deltaY = e.wheelDeltaY / 6;
      }
      if (e.deltaMode && e.deltaMode === 1) {
        // Firefox in deltaMode 1: Line scrolling
        deltaX *= 10;
        deltaY *= 10;
      }
      if (deltaX !== deltaX && deltaY !== deltaY /* NaN checks */) {
        // IE in some mouse drivers
        deltaX = 0;
        deltaY = e.wheelDelta;
      }
      if (e.shiftKey) {
        // reverse axis with shift key
        return [-deltaY, -deltaX];
      }
      return [deltaX, deltaY];
    }
    function shouldBeConsumedByChild(target, deltaX, deltaY) {
      // FIXME: this is a workaround for <select> issue in FF and IE #571
      if (!env.isWebKit && element.querySelector('select:focus')) {
        return true;
      }
      if (!element.contains(target)) {
        return false;
      }
      var cursor = target;
      while (cursor && cursor !== element) {
        if (cursor.classList.contains(cls.element.consuming)) {
          return true;
        }
        var style = get(cursor);

        // if deltaY && vertical scrollable
        if (deltaY && style.overflowY.match(/(scroll|auto)/)) {
          var maxScrollTop = cursor.scrollHeight - cursor.clientHeight;
          if (maxScrollTop > 0) {
            if (cursor.scrollTop > 0 && deltaY < 0 || cursor.scrollTop < maxScrollTop && deltaY > 0) {
              return true;
            }
          }
        }
        // if deltaX && horizontal scrollable
        if (deltaX && style.overflowX.match(/(scroll|auto)/)) {
          var maxScrollLeft = cursor.scrollWidth - cursor.clientWidth;
          if (maxScrollLeft > 0) {
            if (cursor.scrollLeft > 0 && deltaX < 0 || cursor.scrollLeft < maxScrollLeft && deltaX > 0) {
              return true;
            }
          }
        }
        cursor = cursor.parentNode;
      }
      return false;
    }
    function mousewheelHandler(e) {
      var ref = getDeltaFromEvent(e);
      var deltaX = ref[0];
      var deltaY = ref[1];
      if (shouldBeConsumedByChild(e.target, deltaX, deltaY)) {
        return;
      }
      var shouldPrevent = false;
      if (!i.settings.useBothWheelAxes) {
        // deltaX will only be used for horizontal scrolling and deltaY will
        // only be used for vertical scrolling - this is the default
        element.scrollTop -= deltaY * i.settings.wheelSpeed;
        element.scrollLeft += deltaX * i.settings.wheelSpeed;
      } else if (i.scrollbarYActive && !i.scrollbarXActive) {
        // only vertical scrollbar is active and useBothWheelAxes option is
        // active, so let's scroll vertical bar using both mouse wheel axes
        if (deltaY) {
          element.scrollTop -= deltaY * i.settings.wheelSpeed;
        } else {
          element.scrollTop += deltaX * i.settings.wheelSpeed;
        }
        shouldPrevent = true;
      } else if (i.scrollbarXActive && !i.scrollbarYActive) {
        // useBothWheelAxes and only horizontal bar is active, so use both
        // wheel axes for horizontal bar
        if (deltaX) {
          element.scrollLeft += deltaX * i.settings.wheelSpeed;
        } else {
          element.scrollLeft -= deltaY * i.settings.wheelSpeed;
        }
        shouldPrevent = true;
      }
      updateGeometry(i);
      shouldPrevent = shouldPrevent || shouldPreventDefault(deltaX, deltaY);
      if (shouldPrevent && !e.ctrlKey) {
        e.stopPropagation();
        e.preventDefault();
      }
    }
    if (typeof window.onwheel !== 'undefined') {
      i.event.bind(element, 'wheel', mousewheelHandler);
    } else if (typeof window.onmousewheel !== 'undefined') {
      i.event.bind(element, 'mousewheel', mousewheelHandler);
    }
  }
  function touch(i) {
    if (!env.supportsTouch && !env.supportsIePointer) {
      return;
    }
    var element = i.element;
    function shouldPrevent(deltaX, deltaY) {
      var scrollTop = Math.floor(element.scrollTop);
      var scrollLeft = element.scrollLeft;
      var magnitudeX = Math.abs(deltaX);
      var magnitudeY = Math.abs(deltaY);
      if (magnitudeY > magnitudeX) {
        // user is perhaps trying to swipe up/down the page

        if (deltaY < 0 && scrollTop === i.contentHeight - i.containerHeight || deltaY > 0 && scrollTop === 0) {
          // set prevent for mobile Chrome refresh
          return window.scrollY === 0 && deltaY > 0 && env.isChrome;
        }
      } else if (magnitudeX > magnitudeY) {
        // user is perhaps trying to swipe left/right across the page

        if (deltaX < 0 && scrollLeft === i.contentWidth - i.containerWidth || deltaX > 0 && scrollLeft === 0) {
          return true;
        }
      }
      return true;
    }
    function applyTouchMove(differenceX, differenceY) {
      element.scrollTop -= differenceY;
      element.scrollLeft -= differenceX;
      updateGeometry(i);
    }
    var startOffset = {};
    var startTime = 0;
    var speed = {};
    var easingLoop = null;
    function getTouch(e) {
      if (e.targetTouches) {
        return e.targetTouches[0];
      } else {
        // Maybe IE pointer
        return e;
      }
    }
    function shouldHandle(e) {
      if (e.pointerType && e.pointerType === 'pen' && e.buttons === 0) {
        return false;
      }
      if (e.targetTouches && e.targetTouches.length === 1) {
        return true;
      }
      if (e.pointerType && e.pointerType !== 'mouse' && e.pointerType !== e.MSPOINTER_TYPE_MOUSE) {
        return true;
      }
      return false;
    }
    function touchStart(e) {
      if (!shouldHandle(e)) {
        return;
      }
      var touch = getTouch(e);
      startOffset.pageX = touch.pageX;
      startOffset.pageY = touch.pageY;
      startTime = new Date().getTime();
      if (easingLoop !== null) {
        clearInterval(easingLoop);
      }
    }
    function shouldBeConsumedByChild(target, deltaX, deltaY) {
      if (!element.contains(target)) {
        return false;
      }
      var cursor = target;
      while (cursor && cursor !== element) {
        if (cursor.classList.contains(cls.element.consuming)) {
          return true;
        }
        var style = get(cursor);

        // if deltaY && vertical scrollable
        if (deltaY && style.overflowY.match(/(scroll|auto)/)) {
          var maxScrollTop = cursor.scrollHeight - cursor.clientHeight;
          if (maxScrollTop > 0) {
            if (cursor.scrollTop > 0 && deltaY < 0 || cursor.scrollTop < maxScrollTop && deltaY > 0) {
              return true;
            }
          }
        }
        // if deltaX && horizontal scrollable
        if (deltaX && style.overflowX.match(/(scroll|auto)/)) {
          var maxScrollLeft = cursor.scrollWidth - cursor.clientWidth;
          if (maxScrollLeft > 0) {
            if (cursor.scrollLeft > 0 && deltaX < 0 || cursor.scrollLeft < maxScrollLeft && deltaX > 0) {
              return true;
            }
          }
        }
        cursor = cursor.parentNode;
      }
      return false;
    }
    function touchMove(e) {
      if (shouldHandle(e)) {
        var touch = getTouch(e);
        var currentOffset = {
          pageX: touch.pageX,
          pageY: touch.pageY
        };
        var differenceX = currentOffset.pageX - startOffset.pageX;
        var differenceY = currentOffset.pageY - startOffset.pageY;
        if (shouldBeConsumedByChild(e.target, differenceX, differenceY)) {
          return;
        }
        applyTouchMove(differenceX, differenceY);
        startOffset = currentOffset;
        var currentTime = new Date().getTime();
        var timeGap = currentTime - startTime;
        if (timeGap > 0) {
          speed.x = differenceX / timeGap;
          speed.y = differenceY / timeGap;
          startTime = currentTime;
        }
        if (shouldPrevent(differenceX, differenceY)) {
          e.preventDefault();
        }
      }
    }
    function touchEnd() {
      if (i.settings.swipeEasing) {
        clearInterval(easingLoop);
        easingLoop = setInterval(function () {
          if (i.isInitialized) {
            clearInterval(easingLoop);
            return;
          }
          if (!speed.x && !speed.y) {
            clearInterval(easingLoop);
            return;
          }
          if (Math.abs(speed.x) < 0.01 && Math.abs(speed.y) < 0.01) {
            clearInterval(easingLoop);
            return;
          }
          if (!i.element) {
            clearInterval(easingLoop);
            return;
          }
          applyTouchMove(speed.x * 30, speed.y * 30);
          speed.x *= 0.8;
          speed.y *= 0.8;
        }, 10);
      }
    }
    if (env.supportsTouch) {
      i.event.bind(element, 'touchstart', touchStart);
      i.event.bind(element, 'touchmove', touchMove);
      i.event.bind(element, 'touchend', touchEnd);
    } else if (env.supportsIePointer) {
      if (window.PointerEvent) {
        i.event.bind(element, 'pointerdown', touchStart);
        i.event.bind(element, 'pointermove', touchMove);
        i.event.bind(element, 'pointerup', touchEnd);
      } else if (window.MSPointerEvent) {
        i.event.bind(element, 'MSPointerDown', touchStart);
        i.event.bind(element, 'MSPointerMove', touchMove);
        i.event.bind(element, 'MSPointerUp', touchEnd);
      }
    }
  }
  var defaultSettings = function defaultSettings() {
    return {
      handlers: ['click-rail', 'drag-thumb', 'keyboard', 'wheel', 'touch'],
      maxScrollbarLength: null,
      minScrollbarLength: null,
      scrollingThreshold: 1000,
      scrollXMarginOffset: 0,
      scrollYMarginOffset: 0,
      suppressScrollX: false,
      suppressScrollY: false,
      swipeEasing: true,
      useBothWheelAxes: false,
      wheelPropagation: true,
      wheelSpeed: 1
    };
  };
  var handlers = {
    'click-rail': clickRail,
    'drag-thumb': dragThumb,
    keyboard: keyboard,
    wheel: wheel,
    touch: touch
  };
  var PerfectScrollbar = function PerfectScrollbar(element, userSettings) {
    var this$1 = this;
    if (userSettings === void 0) userSettings = {};
    if (typeof element === 'string') {
      element = document.querySelector(element);
    }
    if (!element || !element.nodeName) {
      throw new Error('no element is specified to initialize PerfectScrollbar');
    }
    this.element = element;
    element.classList.add(cls.main);
    this.settings = defaultSettings();
    for (var key in userSettings) {
      this.settings[key] = userSettings[key];
    }
    this.containerWidth = null;
    this.containerHeight = null;
    this.contentWidth = null;
    this.contentHeight = null;
    var focus = function focus() {
      return element.classList.add(cls.state.focus);
    };
    var blur = function blur() {
      return element.classList.remove(cls.state.focus);
    };
    this.isRtl = get(element).direction === 'rtl';
    if (this.isRtl === true) {
      element.classList.add(cls.rtl);
    }
    this.isNegativeScroll = function () {
      var originalScrollLeft = element.scrollLeft;
      var result = null;
      element.scrollLeft = -1;
      result = element.scrollLeft < 0;
      element.scrollLeft = originalScrollLeft;
      return result;
    }();
    this.negativeScrollAdjustment = this.isNegativeScroll ? element.scrollWidth - element.clientWidth : 0;
    this.event = new EventManager();
    this.ownerDocument = element.ownerDocument || document;
    this.scrollbarXRail = div(cls.element.rail('x'));
    element.appendChild(this.scrollbarXRail);
    this.scrollbarX = div(cls.element.thumb('x'));
    this.scrollbarXRail.appendChild(this.scrollbarX);
    this.scrollbarX.setAttribute('tabindex', 0);
    this.event.bind(this.scrollbarX, 'focus', focus);
    this.event.bind(this.scrollbarX, 'blur', blur);
    this.scrollbarXActive = null;
    this.scrollbarXWidth = null;
    this.scrollbarXLeft = null;
    var railXStyle = get(this.scrollbarXRail);
    this.scrollbarXBottom = parseInt(railXStyle.bottom, 10);
    if (isNaN(this.scrollbarXBottom)) {
      this.isScrollbarXUsingBottom = false;
      this.scrollbarXTop = toInt(railXStyle.top);
    } else {
      this.isScrollbarXUsingBottom = true;
    }
    this.railBorderXWidth = toInt(railXStyle.borderLeftWidth) + toInt(railXStyle.borderRightWidth);
    // Set rail to display:block to calculate margins
    set(this.scrollbarXRail, {
      display: 'block'
    });
    this.railXMarginWidth = toInt(railXStyle.marginLeft) + toInt(railXStyle.marginRight);
    set(this.scrollbarXRail, {
      display: ''
    });
    this.railXWidth = null;
    this.railXRatio = null;
    this.scrollbarYRail = div(cls.element.rail('y'));
    element.appendChild(this.scrollbarYRail);
    this.scrollbarY = div(cls.element.thumb('y'));
    this.scrollbarYRail.appendChild(this.scrollbarY);
    this.scrollbarY.setAttribute('tabindex', 0);
    this.event.bind(this.scrollbarY, 'focus', focus);
    this.event.bind(this.scrollbarY, 'blur', blur);
    this.scrollbarYActive = null;
    this.scrollbarYHeight = null;
    this.scrollbarYTop = null;
    var railYStyle = get(this.scrollbarYRail);
    this.scrollbarYRight = parseInt(railYStyle.right, 10);
    if (isNaN(this.scrollbarYRight)) {
      this.isScrollbarYUsingRight = false;
      this.scrollbarYLeft = toInt(railYStyle.left);
    } else {
      this.isScrollbarYUsingRight = true;
    }
    this.scrollbarYOuterWidth = this.isRtl ? outerWidth(this.scrollbarY) : null;
    this.railBorderYWidth = toInt(railYStyle.borderTopWidth) + toInt(railYStyle.borderBottomWidth);
    set(this.scrollbarYRail, {
      display: 'block'
    });
    this.railYMarginHeight = toInt(railYStyle.marginTop) + toInt(railYStyle.marginBottom);
    set(this.scrollbarYRail, {
      display: ''
    });
    this.railYHeight = null;
    this.railYRatio = null;
    this.reach = {
      x: element.scrollLeft <= 0 ? 'start' : element.scrollLeft >= this.contentWidth - this.containerWidth ? 'end' : null,
      y: element.scrollTop <= 0 ? 'start' : element.scrollTop >= this.contentHeight - this.containerHeight ? 'end' : null
    };
    this.isAlive = true;
    this.settings.handlers.forEach(function (handlerName) {
      return handlers[handlerName](this$1);
    });
    this.lastScrollTop = Math.floor(element.scrollTop); // for onScroll only
    this.lastScrollLeft = element.scrollLeft; // for onScroll only
    this.event.bind(this.element, 'scroll', function (e) {
      return this$1.onScroll(e);
    });
    updateGeometry(this);
  };
  PerfectScrollbar.prototype.update = function update() {
    if (!this.isAlive) {
      return;
    }

    // Recalcuate negative scrollLeft adjustment
    this.negativeScrollAdjustment = this.isNegativeScroll ? this.element.scrollWidth - this.element.clientWidth : 0;

    // Recalculate rail margins
    set(this.scrollbarXRail, {
      display: 'block'
    });
    set(this.scrollbarYRail, {
      display: 'block'
    });
    this.railXMarginWidth = toInt(get(this.scrollbarXRail).marginLeft) + toInt(get(this.scrollbarXRail).marginRight);
    this.railYMarginHeight = toInt(get(this.scrollbarYRail).marginTop) + toInt(get(this.scrollbarYRail).marginBottom);

    // Hide scrollbars not to affect scrollWidth and scrollHeight
    set(this.scrollbarXRail, {
      display: 'none'
    });
    set(this.scrollbarYRail, {
      display: 'none'
    });
    updateGeometry(this);
    processScrollDiff(this, 'top', 0, false, true);
    processScrollDiff(this, 'left', 0, false, true);
    set(this.scrollbarXRail, {
      display: ''
    });
    set(this.scrollbarYRail, {
      display: ''
    });
  };
  PerfectScrollbar.prototype.onScroll = function onScroll(e) {
    if (!this.isAlive) {
      return;
    }
    updateGeometry(this);
    processScrollDiff(this, 'top', this.element.scrollTop - this.lastScrollTop);
    processScrollDiff(this, 'left', this.element.scrollLeft - this.lastScrollLeft);
    this.lastScrollTop = Math.floor(this.element.scrollTop);
    this.lastScrollLeft = this.element.scrollLeft;
  };
  PerfectScrollbar.prototype.destroy = function destroy() {
    if (!this.isAlive) {
      return;
    }
    this.event.unbindAll();
    remove(this.scrollbarX);
    remove(this.scrollbarY);
    remove(this.scrollbarXRail);
    remove(this.scrollbarYRail);
    this.removePsClasses();

    // unset elements
    this.element = null;
    this.scrollbarX = null;
    this.scrollbarY = null;
    this.scrollbarXRail = null;
    this.scrollbarYRail = null;
    this.isAlive = false;
  };
  PerfectScrollbar.prototype.removePsClasses = function removePsClasses() {
    this.element.className = this.element.className.split(' ').filter(function (name) {
      return !name.match(/^ps([-_].+|)$/);
    }).join(' ');
  };
  return PerfectScrollbar;
});

/***/ }),

/***/ "./public/frontend/amazy/js/query-ui.js":
/*!**********************************************!*\
  !*** ./public/frontend/amazy/js/query-ui.js ***!
  \**********************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}/*! jQuery UI - v1.12.1 - 2016-09-14
* http://jqueryui.com
* Includes: widget.js, position.js, data.js, disable-selection.js, effect.js, effects/effect-blind.js, effects/effect-bounce.js, effects/effect-clip.js, effects/effect-drop.js, effects/effect-explode.js, effects/effect-fade.js, effects/effect-fold.js, effects/effect-highlight.js, effects/effect-puff.js, effects/effect-pulsate.js, effects/effect-scale.js, effects/effect-shake.js, effects/effect-size.js, effects/effect-slide.js, effects/effect-transfer.js, focusable.js, form-reset-mixin.js, jquery-1-7.js, keycode.js, labels.js, scroll-parent.js, tabbable.js, unique-id.js, widgets/accordion.js, widgets/autocomplete.js, widgets/button.js, widgets/checkboxradio.js, widgets/controlgroup.js, widgets/datepicker.js, widgets/dialog.js, widgets/draggable.js, widgets/droppable.js, widgets/menu.js, widgets/mouse.js, widgets/progressbar.js, widgets/resizable.js, widgets/selectable.js, widgets/selectmenu.js, widgets/slider.js, widgets/sortable.js, widgets/spinner.js, widgets/tabs.js, widgets/tooltip.js
* Copyright jQuery Foundation and other contributors; Licensed MIT */(function(factory){if(true){// AMD. Register as an anonymous module.
!(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));}else{}})(function($){$.ui=$.ui||{};var version=$.ui.version="1.12.1";/*!
 * jQuery UI Widget 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Widget
//>>group: Core
//>>description: Provides a factory for creating stateful widgets with a common API.
//>>docs: http://api.jqueryui.com/jQuery.widget/
//>>demos: http://jqueryui.com/widget/
var widgetUuid=0;var widgetSlice=Array.prototype.slice;$.cleanData=function(orig){return function(elems){var events,elem,i;for(i=0;(elem=elems[i])!=null;i++){try{// Only trigger remove when necessary to save time
events=$._data(elem,"events");if(events&&events.remove){$(elem).triggerHandler("remove");}// Http://bugs.jquery.com/ticket/8235
}catch(e){}}orig(elems);};}($.cleanData);$.widget=function(name,base,prototype){var existingConstructor,constructor,basePrototype;// ProxiedPrototype allows the provided prototype to remain unmodified
// so that it can be used as a mixin for multiple widgets (#8876)
var proxiedPrototype={};var namespace=name.split(".")[0];name=name.split(".")[1];var fullName=namespace+"-"+name;if(!prototype){prototype=base;base=$.Widget;}if($.isArray(prototype)){prototype=$.extend.apply(null,[{}].concat(prototype));}// Create selector for plugin
$.expr[":"][fullName.toLowerCase()]=function(elem){return!!$.data(elem,fullName);};$[namespace]=$[namespace]||{};existingConstructor=$[namespace][name];constructor=$[namespace][name]=function(options,element){// Allow instantiation without "new" keyword
if(!this._createWidget){return new constructor(options,element);}// Allow instantiation without initializing for simple inheritance
// must use "new" keyword (the code above always passes args)
if(arguments.length){this._createWidget(options,element);}};// Extend with the existing constructor to carry over any static properties
$.extend(constructor,existingConstructor,{version:prototype.version,// Copy the object used to create the prototype in case we need to
// redefine the widget later
_proto:$.extend({},prototype),// Track widgets that inherit from this widget in case this widget is
// redefined after a widget inherits from it
_childConstructors:[]});basePrototype=new base();// We need to make the options hash a property directly on the new instance
// otherwise we'll modify the options hash on the prototype that we're
// inheriting from
basePrototype.options=$.widget.extend({},basePrototype.options);$.each(prototype,function(prop,value){if(!$.isFunction(value)){proxiedPrototype[prop]=value;return;}proxiedPrototype[prop]=function(){function _super(){return base.prototype[prop].apply(this,arguments);}function _superApply(args){return base.prototype[prop].apply(this,args);}return function(){var __super=this._super;var __superApply=this._superApply;var returnValue;this._super=_super;this._superApply=_superApply;returnValue=value.apply(this,arguments);this._super=__super;this._superApply=__superApply;return returnValue;};}();});constructor.prototype=$.widget.extend(basePrototype,{// TODO: remove support for widgetEventPrefix
// always use the name + a colon as the prefix, e.g., draggable:start
// don't prefix for widgets that aren't DOM-based
widgetEventPrefix:existingConstructor?basePrototype.widgetEventPrefix||name:name},proxiedPrototype,{constructor:constructor,namespace:namespace,widgetName:name,widgetFullName:fullName});// If this widget is being redefined then we need to find all widgets that
// are inheriting from it and redefine all of them so that they inherit from
// the new version of this widget. We're essentially trying to replace one
// level in the prototype chain.
if(existingConstructor){$.each(existingConstructor._childConstructors,function(i,child){var childPrototype=child.prototype;// Redefine the child widget using the same prototype that was
// originally used, but inherit from the new version of the base
$.widget(childPrototype.namespace+"."+childPrototype.widgetName,constructor,child._proto);});// Remove the list of existing child constructors from the old constructor
// so the old child constructors can be garbage collected
delete existingConstructor._childConstructors;}else{base._childConstructors.push(constructor);}$.widget.bridge(name,constructor);return constructor;};$.widget.extend=function(target){var input=widgetSlice.call(arguments,1);var inputIndex=0;var inputLength=input.length;var key;var value;for(;inputIndex<inputLength;inputIndex++){for(key in input[inputIndex]){value=input[inputIndex][key];if(input[inputIndex].hasOwnProperty(key)&&value!==undefined){// Clone objects
if($.isPlainObject(value)){target[key]=$.isPlainObject(target[key])?$.widget.extend({},target[key],value):// Don't extend strings, arrays, etc. with objects
$.widget.extend({},value);// Copy everything else by reference
}else{target[key]=value;}}}}return target;};$.widget.bridge=function(name,object){var fullName=object.prototype.widgetFullName||name;$.fn[name]=function(options){var isMethodCall=typeof options==="string";var args=widgetSlice.call(arguments,1);var returnValue=this;if(isMethodCall){// If this is an empty collection, we need to have the instance method
// return undefined instead of the jQuery instance
if(!this.length&&options==="instance"){returnValue=undefined;}else{this.each(function(){var methodValue;var instance=$.data(this,fullName);if(options==="instance"){returnValue=instance;return false;}if(!instance){return $.error("cannot call methods on "+name+" prior to initialization; "+"attempted to call method '"+options+"'");}if(!$.isFunction(instance[options])||options.charAt(0)==="_"){return $.error("no such method '"+options+"' for "+name+" widget instance");}methodValue=instance[options].apply(instance,args);if(methodValue!==instance&&methodValue!==undefined){returnValue=methodValue&&methodValue.jquery?returnValue.pushStack(methodValue.get()):methodValue;return false;}});}}else{// Allow multiple hashes to be passed on init
if(args.length){options=$.widget.extend.apply(null,[options].concat(args));}this.each(function(){var instance=$.data(this,fullName);if(instance){instance.option(options||{});if(instance._init){instance._init();}}else{$.data(this,fullName,new object(options,this));}});}return returnValue;};};$.Widget=function/* options, element */(){};$.Widget._childConstructors=[];$.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{classes:{},disabled:false,// Callbacks
create:null},_createWidget:function _createWidget(options,element){element=$(element||this.defaultElement||this)[0];this.element=$(element);this.uuid=widgetUuid++;this.eventNamespace="."+this.widgetName+this.uuid;this.bindings=$();this.hoverable=$();this.focusable=$();this.classesElementLookup={};if(element!==this){$.data(element,this.widgetFullName,this);this._on(true,this.element,{remove:function remove(event){if(event.target===element){this.destroy();}}});this.document=$(element.style?// Element within the document
element.ownerDocument:// Element is window or document
element.document||element);this.window=$(this.document[0].defaultView||this.document[0].parentWindow);}this.options=$.widget.extend({},this.options,this._getCreateOptions(),options);this._create();if(this.options.disabled){this._setOptionDisabled(this.options.disabled);}this._trigger("create",null,this._getCreateEventData());this._init();},_getCreateOptions:function _getCreateOptions(){return{};},_getCreateEventData:$.noop,_create:$.noop,_init:$.noop,destroy:function destroy(){var that=this;this._destroy();$.each(this.classesElementLookup,function(key,value){that._removeClass(value,key);});// We can probably remove the unbind calls in 2.0
// all event bindings should go through this._on()
this.element.off(this.eventNamespace).removeData(this.widgetFullName);this.widget().off(this.eventNamespace).removeAttr("aria-disabled");// Clean up events and states
this.bindings.off(this.eventNamespace);},_destroy:$.noop,widget:function widget(){return this.element;},option:function option(key,value){var options=key;var parts;var curOption;var i;if(arguments.length===0){// Don't return a reference to the internal hash
return $.widget.extend({},this.options);}if(typeof key==="string"){// Handle nested keys, e.g., "foo.bar" => { foo: { bar: ___ } }
options={};parts=key.split(".");key=parts.shift();if(parts.length){curOption=options[key]=$.widget.extend({},this.options[key]);for(i=0;i<parts.length-1;i++){curOption[parts[i]]=curOption[parts[i]]||{};curOption=curOption[parts[i]];}key=parts.pop();if(arguments.length===1){return curOption[key]===undefined?null:curOption[key];}curOption[key]=value;}else{if(arguments.length===1){return this.options[key]===undefined?null:this.options[key];}options[key]=value;}}this._setOptions(options);return this;},_setOptions:function _setOptions(options){var key;for(key in options){this._setOption(key,options[key]);}return this;},_setOption:function _setOption(key,value){if(key==="classes"){this._setOptionClasses(value);}this.options[key]=value;if(key==="disabled"){this._setOptionDisabled(value);}return this;},_setOptionClasses:function _setOptionClasses(value){var classKey,elements,currentElements;for(classKey in value){currentElements=this.classesElementLookup[classKey];if(value[classKey]===this.options.classes[classKey]||!currentElements||!currentElements.length){continue;}// We are doing this to create a new jQuery object because the _removeClass() call
// on the next line is going to destroy the reference to the current elements being
// tracked. We need to save a copy of this collection so that we can add the new classes
// below.
elements=$(currentElements.get());this._removeClass(currentElements,classKey);// We don't use _addClass() here, because that uses this.options.classes
// for generating the string of classes. We want to use the value passed in from
// _setOption(), this is the new value of the classes option which was passed to
// _setOption(). We pass this value directly to _classes().
elements.addClass(this._classes({element:elements,keys:classKey,classes:value,add:true}));}},_setOptionDisabled:function _setOptionDisabled(value){this._toggleClass(this.widget(),this.widgetFullName+"-disabled",null,!!value);// If the widget is becoming disabled, then nothing is interactive
if(value){this._removeClass(this.hoverable,null,"ui-state-hover");this._removeClass(this.focusable,null,"ui-state-focus");}},enable:function enable(){return this._setOptions({disabled:false});},disable:function disable(){return this._setOptions({disabled:true});},_classes:function _classes(options){var full=[];var that=this;options=$.extend({element:this.element,classes:this.options.classes||{}},options);function processClassString(classes,checkOption){var current,i;for(i=0;i<classes.length;i++){current=that.classesElementLookup[classes[i]]||$();if(options.add){current=$($.unique(current.get().concat(options.element.get())));}else{current=$(current.not(options.element).get());}that.classesElementLookup[classes[i]]=current;full.push(classes[i]);if(checkOption&&options.classes[classes[i]]){full.push(options.classes[classes[i]]);}}}this._on(options.element,{"remove":"_untrackClassesElement"});if(options.keys){processClassString(options.keys.match(/\S+/g)||[],true);}if(options.extra){processClassString(options.extra.match(/\S+/g)||[]);}return full.join(" ");},_untrackClassesElement:function _untrackClassesElement(event){var that=this;$.each(that.classesElementLookup,function(key,value){if($.inArray(event.target,value)!==-1){that.classesElementLookup[key]=$(value.not(event.target).get());}});},_removeClass:function _removeClass(element,keys,extra){return this._toggleClass(element,keys,extra,false);},_addClass:function _addClass(element,keys,extra){return this._toggleClass(element,keys,extra,true);},_toggleClass:function _toggleClass(element,keys,extra,add){add=typeof add==="boolean"?add:extra;var shift=typeof element==="string"||element===null,options={extra:shift?keys:extra,keys:shift?element:keys,element:shift?this.element:element,add:add};options.element.toggleClass(this._classes(options),add);return this;},_on:function _on(suppressDisabledCheck,element,handlers){var delegateElement;var instance=this;// No suppressDisabledCheck flag, shuffle arguments
if(typeof suppressDisabledCheck!=="boolean"){handlers=element;element=suppressDisabledCheck;suppressDisabledCheck=false;}// No element argument, shuffle and use this.element
if(!handlers){handlers=element;element=this.element;delegateElement=this.widget();}else{element=delegateElement=$(element);this.bindings=this.bindings.add(element);}$.each(handlers,function(event,handler){function handlerProxy(){// Allow widgets to customize the disabled handling
// - disabled as an array instead of boolean
// - disabled class as method for disabling individual parts
if(!suppressDisabledCheck&&(instance.options.disabled===true||$(this).hasClass("ui-state-disabled"))){return;}return(typeof handler==="string"?instance[handler]:handler).apply(instance,arguments);}// Copy the guid so direct unbinding works
if(typeof handler!=="string"){handlerProxy.guid=handler.guid=handler.guid||handlerProxy.guid||$.guid++;}var match=event.match(/^([\w:-]*)\s*(.*)$/);var eventName=match[1]+instance.eventNamespace;var selector=match[2];if(selector){delegateElement.on(eventName,selector,handlerProxy);}else{element.on(eventName,handlerProxy);}});},_off:function _off(element,eventName){eventName=(eventName||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace;element.off(eventName).off(eventName);// Clear the stack to avoid memory leaks (#10056)
this.bindings=$(this.bindings.not(element).get());this.focusable=$(this.focusable.not(element).get());this.hoverable=$(this.hoverable.not(element).get());},_delay:function _delay(handler,delay){function handlerProxy(){return(typeof handler==="string"?instance[handler]:handler).apply(instance,arguments);}var instance=this;return setTimeout(handlerProxy,delay||0);},_hoverable:function _hoverable(element){this.hoverable=this.hoverable.add(element);this._on(element,{mouseenter:function mouseenter(event){this._addClass($(event.currentTarget),null,"ui-state-hover");},mouseleave:function mouseleave(event){this._removeClass($(event.currentTarget),null,"ui-state-hover");}});},_focusable:function _focusable(element){this.focusable=this.focusable.add(element);this._on(element,{focusin:function focusin(event){this._addClass($(event.currentTarget),null,"ui-state-focus");},focusout:function focusout(event){this._removeClass($(event.currentTarget),null,"ui-state-focus");}});},_trigger:function _trigger(type,event,data){var prop,orig;var callback=this.options[type];data=data||{};event=$.Event(event);event.type=(type===this.widgetEventPrefix?type:this.widgetEventPrefix+type).toLowerCase();// The original event may come from any element
// so we need to reset the target on the new event
event.target=this.element[0];// Copy original event properties over to the new event
orig=event.originalEvent;if(orig){for(prop in orig){if(!(prop in event)){event[prop]=orig[prop];}}}this.element.trigger(event,data);return!($.isFunction(callback)&&callback.apply(this.element[0],[event].concat(data))===false||event.isDefaultPrevented());}};$.each({show:"fadeIn",hide:"fadeOut"},function(method,defaultEffect){$.Widget.prototype["_"+method]=function(element,options,callback){if(typeof options==="string"){options={effect:options};}var hasOptions;var effectName=!options?method:options===true||typeof options==="number"?defaultEffect:options.effect||defaultEffect;options=options||{};if(typeof options==="number"){options={duration:options};}hasOptions=!$.isEmptyObject(options);options.complete=callback;if(options.delay){element.delay(options.delay);}if(hasOptions&&$.effects&&$.effects.effect[effectName]){element[method](options);}else if(effectName!==method&&element[effectName]){element[effectName](options.duration,options.easing,callback);}else{element.queue(function(next){$(this)[method]();if(callback){callback.call(element[0]);}next();});}};});var widget=$.widget;/*!
 * jQuery UI Position 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/position/
 */ //>>label: Position
//>>group: Core
//>>description: Positions elements relative to other elements.
//>>docs: http://api.jqueryui.com/position/
//>>demos: http://jqueryui.com/position/
(function(){var cachedScrollbarWidth,max=Math.max,abs=Math.abs,rhorizontal=/left|center|right/,rvertical=/top|center|bottom/,roffset=/[\+\-]\d+(\.[\d]+)?%?/,rposition=/^\w+/,rpercent=/%$/,_position=$.fn.position;function getOffsets(offsets,width,height){return[parseFloat(offsets[0])*(rpercent.test(offsets[0])?width/100:1),parseFloat(offsets[1])*(rpercent.test(offsets[1])?height/100:1)];}function parseCss(element,property){return parseInt($.css(element,property),10)||0;}function getDimensions(elem){var raw=elem[0];if(raw.nodeType===9){return{width:elem.width(),height:elem.height(),offset:{top:0,left:0}};}if($.isWindow(raw)){return{width:elem.width(),height:elem.height(),offset:{top:elem.scrollTop(),left:elem.scrollLeft()}};}if(raw.preventDefault){return{width:0,height:0,offset:{top:raw.pageY,left:raw.pageX}};}return{width:elem.outerWidth(),height:elem.outerHeight(),offset:elem.offset()};}$.position={scrollbarWidth:function scrollbarWidth(){if(cachedScrollbarWidth!==undefined){return cachedScrollbarWidth;}var w1,w2,div=$("<div "+"style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'>"+"<div style='height:100px;width:auto;'></div></div>"),innerDiv=div.children()[0];$("body").append(div);w1=innerDiv.offsetWidth;div.css("overflow","scroll");w2=innerDiv.offsetWidth;if(w1===w2){w2=div[0].clientWidth;}div.remove();return cachedScrollbarWidth=w1-w2;},getScrollInfo:function getScrollInfo(within){var overflowX=within.isWindow||within.isDocument?"":within.element.css("overflow-x"),overflowY=within.isWindow||within.isDocument?"":within.element.css("overflow-y"),hasOverflowX=overflowX==="scroll"||overflowX==="auto"&&within.width<within.element[0].scrollWidth,hasOverflowY=overflowY==="scroll"||overflowY==="auto"&&within.height<within.element[0].scrollHeight;return{width:hasOverflowY?$.position.scrollbarWidth():0,height:hasOverflowX?$.position.scrollbarWidth():0};},getWithinInfo:function getWithinInfo(element){var withinElement=$(element||window),isWindow=$.isWindow(withinElement[0]),isDocument=!!withinElement[0]&&withinElement[0].nodeType===9,hasOffset=!isWindow&&!isDocument;return{element:withinElement,isWindow:isWindow,isDocument:isDocument,offset:hasOffset?$(element).offset():{left:0,top:0},scrollLeft:withinElement.scrollLeft(),scrollTop:withinElement.scrollTop(),width:withinElement.outerWidth(),height:withinElement.outerHeight()};}};$.fn.position=function(options){if(!options||!options.of){return _position.apply(this,arguments);}// Make a copy, we don't want to modify arguments
options=$.extend({},options);var atOffset,targetWidth,targetHeight,targetOffset,basePosition,dimensions,target=$(options.of),within=$.position.getWithinInfo(options.within),scrollInfo=$.position.getScrollInfo(within),collision=(options.collision||"flip").split(" "),offsets={};dimensions=getDimensions(target);if(target[0].preventDefault){// Force left top to allow flipping
options.at="left top";}targetWidth=dimensions.width;targetHeight=dimensions.height;targetOffset=dimensions.offset;// Clone to reuse original targetOffset later
basePosition=$.extend({},targetOffset);// Force my and at to have valid horizontal and vertical positions
// if a value is missing or invalid, it will be converted to center
$.each(["my","at"],function(){var pos=(options[this]||"").split(" "),horizontalOffset,verticalOffset;if(pos.length===1){pos=rhorizontal.test(pos[0])?pos.concat(["center"]):rvertical.test(pos[0])?["center"].concat(pos):["center","center"];}pos[0]=rhorizontal.test(pos[0])?pos[0]:"center";pos[1]=rvertical.test(pos[1])?pos[1]:"center";// Calculate offsets
horizontalOffset=roffset.exec(pos[0]);verticalOffset=roffset.exec(pos[1]);offsets[this]=[horizontalOffset?horizontalOffset[0]:0,verticalOffset?verticalOffset[0]:0];// Reduce to just the positions without the offsets
options[this]=[rposition.exec(pos[0])[0],rposition.exec(pos[1])[0]];});// Normalize collision option
if(collision.length===1){collision[1]=collision[0];}if(options.at[0]==="right"){basePosition.left+=targetWidth;}else if(options.at[0]==="center"){basePosition.left+=targetWidth/2;}if(options.at[1]==="bottom"){basePosition.top+=targetHeight;}else if(options.at[1]==="center"){basePosition.top+=targetHeight/2;}atOffset=getOffsets(offsets.at,targetWidth,targetHeight);basePosition.left+=atOffset[0];basePosition.top+=atOffset[1];return this.each(function(){var collisionPosition,using,elem=$(this),elemWidth=elem.outerWidth(),elemHeight=elem.outerHeight(),marginLeft=parseCss(this,"marginLeft"),marginTop=parseCss(this,"marginTop"),collisionWidth=elemWidth+marginLeft+parseCss(this,"marginRight")+scrollInfo.width,collisionHeight=elemHeight+marginTop+parseCss(this,"marginBottom")+scrollInfo.height,position=$.extend({},basePosition),myOffset=getOffsets(offsets.my,elem.outerWidth(),elem.outerHeight());if(options.my[0]==="right"){position.left-=elemWidth;}else if(options.my[0]==="center"){position.left-=elemWidth/2;}if(options.my[1]==="bottom"){position.top-=elemHeight;}else if(options.my[1]==="center"){position.top-=elemHeight/2;}position.left+=myOffset[0];position.top+=myOffset[1];collisionPosition={marginLeft:marginLeft,marginTop:marginTop};$.each(["left","top"],function(i,dir){if($.ui.position[collision[i]]){$.ui.position[collision[i]][dir](position,{targetWidth:targetWidth,targetHeight:targetHeight,elemWidth:elemWidth,elemHeight:elemHeight,collisionPosition:collisionPosition,collisionWidth:collisionWidth,collisionHeight:collisionHeight,offset:[atOffset[0]+myOffset[0],atOffset[1]+myOffset[1]],my:options.my,at:options.at,within:within,elem:elem});}});if(options.using){// Adds feedback as second argument to using callback, if present
using=function using(props){var left=targetOffset.left-position.left,right=left+targetWidth-elemWidth,top=targetOffset.top-position.top,bottom=top+targetHeight-elemHeight,feedback={target:{element:target,left:targetOffset.left,top:targetOffset.top,width:targetWidth,height:targetHeight},element:{element:elem,left:position.left,top:position.top,width:elemWidth,height:elemHeight},horizontal:right<0?"left":left>0?"right":"center",vertical:bottom<0?"top":top>0?"bottom":"middle"};if(targetWidth<elemWidth&&abs(left+right)<targetWidth){feedback.horizontal="center";}if(targetHeight<elemHeight&&abs(top+bottom)<targetHeight){feedback.vertical="middle";}if(max(abs(left),abs(right))>max(abs(top),abs(bottom))){feedback.important="horizontal";}else{feedback.important="vertical";}options.using.call(this,props,feedback);};}elem.offset($.extend(position,{using:using}));});};$.ui.position={fit:{left:function left(position,data){var within=data.within,withinOffset=within.isWindow?within.scrollLeft:within.offset.left,outerWidth=within.width,collisionPosLeft=position.left-data.collisionPosition.marginLeft,overLeft=withinOffset-collisionPosLeft,overRight=collisionPosLeft+data.collisionWidth-outerWidth-withinOffset,newOverRight;// Element is wider than within
if(data.collisionWidth>outerWidth){// Element is initially over the left side of within
if(overLeft>0&&overRight<=0){newOverRight=position.left+overLeft+data.collisionWidth-outerWidth-withinOffset;position.left+=overLeft-newOverRight;// Element is initially over right side of within
}else if(overRight>0&&overLeft<=0){position.left=withinOffset;// Element is initially over both left and right sides of within
}else{if(overLeft>overRight){position.left=withinOffset+outerWidth-data.collisionWidth;}else{position.left=withinOffset;}}// Too far left -> align with left edge
}else if(overLeft>0){position.left+=overLeft;// Too far right -> align with right edge
}else if(overRight>0){position.left-=overRight;// Adjust based on position and margin
}else{position.left=max(position.left-collisionPosLeft,position.left);}},top:function top(position,data){var within=data.within,withinOffset=within.isWindow?within.scrollTop:within.offset.top,outerHeight=data.within.height,collisionPosTop=position.top-data.collisionPosition.marginTop,overTop=withinOffset-collisionPosTop,overBottom=collisionPosTop+data.collisionHeight-outerHeight-withinOffset,newOverBottom;// Element is taller than within
if(data.collisionHeight>outerHeight){// Element is initially over the top of within
if(overTop>0&&overBottom<=0){newOverBottom=position.top+overTop+data.collisionHeight-outerHeight-withinOffset;position.top+=overTop-newOverBottom;// Element is initially over bottom of within
}else if(overBottom>0&&overTop<=0){position.top=withinOffset;// Element is initially over both top and bottom of within
}else{if(overTop>overBottom){position.top=withinOffset+outerHeight-data.collisionHeight;}else{position.top=withinOffset;}}// Too far up -> align with top
}else if(overTop>0){position.top+=overTop;// Too far down -> align with bottom edge
}else if(overBottom>0){position.top-=overBottom;// Adjust based on position and margin
}else{position.top=max(position.top-collisionPosTop,position.top);}}},flip:{left:function left(position,data){var within=data.within,withinOffset=within.offset.left+within.scrollLeft,outerWidth=within.width,offsetLeft=within.isWindow?within.scrollLeft:within.offset.left,collisionPosLeft=position.left-data.collisionPosition.marginLeft,overLeft=collisionPosLeft-offsetLeft,overRight=collisionPosLeft+data.collisionWidth-outerWidth-offsetLeft,myOffset=data.my[0]==="left"?-data.elemWidth:data.my[0]==="right"?data.elemWidth:0,atOffset=data.at[0]==="left"?data.targetWidth:data.at[0]==="right"?-data.targetWidth:0,offset=-2*data.offset[0],newOverRight,newOverLeft;if(overLeft<0){newOverRight=position.left+myOffset+atOffset+offset+data.collisionWidth-outerWidth-withinOffset;if(newOverRight<0||newOverRight<abs(overLeft)){position.left+=myOffset+atOffset+offset;}}else if(overRight>0){newOverLeft=position.left-data.collisionPosition.marginLeft+myOffset+atOffset+offset-offsetLeft;if(newOverLeft>0||abs(newOverLeft)<overRight){position.left+=myOffset+atOffset+offset;}}},top:function top(position,data){var within=data.within,withinOffset=within.offset.top+within.scrollTop,outerHeight=within.height,offsetTop=within.isWindow?within.scrollTop:within.offset.top,collisionPosTop=position.top-data.collisionPosition.marginTop,overTop=collisionPosTop-offsetTop,overBottom=collisionPosTop+data.collisionHeight-outerHeight-offsetTop,top=data.my[1]==="top",myOffset=top?-data.elemHeight:data.my[1]==="bottom"?data.elemHeight:0,atOffset=data.at[1]==="top"?data.targetHeight:data.at[1]==="bottom"?-data.targetHeight:0,offset=-2*data.offset[1],newOverTop,newOverBottom;if(overTop<0){newOverBottom=position.top+myOffset+atOffset+offset+data.collisionHeight-outerHeight-withinOffset;if(newOverBottom<0||newOverBottom<abs(overTop)){position.top+=myOffset+atOffset+offset;}}else if(overBottom>0){newOverTop=position.top-data.collisionPosition.marginTop+myOffset+atOffset+offset-offsetTop;if(newOverTop>0||abs(newOverTop)<overBottom){position.top+=myOffset+atOffset+offset;}}}},flipfit:{left:function left(){$.ui.position.flip.left.apply(this,arguments);$.ui.position.fit.left.apply(this,arguments);},top:function top(){$.ui.position.flip.top.apply(this,arguments);$.ui.position.fit.top.apply(this,arguments);}}};})();var position=$.ui.position;/*!
 * jQuery UI :data 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: :data Selector
//>>group: Core
//>>description: Selects elements which have data stored under the specified key.
//>>docs: http://api.jqueryui.com/data-selector/
var data=$.extend($.expr[":"],{data:$.expr.createPseudo?$.expr.createPseudo(function(dataName){return function(elem){return!!$.data(elem,dataName);};}):// Support: jQuery <1.8
function(elem,i,match){return!!$.data(elem,match[3]);}});/*!
 * jQuery UI Disable Selection 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: disableSelection
//>>group: Core
//>>description: Disable selection of text content within the set of matched elements.
//>>docs: http://api.jqueryui.com/disableSelection/
// This file is deprecated
var disableSelection=$.fn.extend({disableSelection:function(){var eventType="onselectstart"in document.createElement("div")?"selectstart":"mousedown";return function(){return this.on(eventType+".ui-disableSelection",function(event){event.preventDefault();});};}(),enableSelection:function enableSelection(){return this.off(".ui-disableSelection");}});/*!
 * jQuery UI Effects 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Effects Core
//>>group: Effects
// jscs:disable maximumLineLength
//>>description: Extends the internal jQuery effects. Includes morphing and easing. Required by all other effects.
// jscs:enable maximumLineLength
//>>docs: http://api.jqueryui.com/category/effects-core/
//>>demos: http://jqueryui.com/effect/
var dataSpace="ui-effects-",dataSpaceStyle="ui-effects-style",dataSpaceAnimated="ui-effects-animated",// Create a local jQuery because jQuery Color relies on it and the
// global may not exist with AMD and a custom build (#10199)
jQuery=$;$.effects={effect:{}};/*!
 * jQuery Color Animations v2.1.2
 * https://github.com/jquery/jquery-color
 *
 * Copyright 2014 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * Date: Wed Jan 16 08:47:09 2013 -0600
 */(function(jQuery,undefined){var stepHooks="backgroundColor borderBottomColor borderLeftColor borderRightColor "+"borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor",// Plusequals test for += 100 -= 100
rplusequals=/^([\-+])=\s*(\d+\.?\d*)/,// A set of RE's that can match strings and generate color tuples.
stringParsers=[{re:/rgba?\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function parse(execResult){return[execResult[1],execResult[2],execResult[3],execResult[4]];}},{re:/rgba?\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,parse:function parse(execResult){return[execResult[1]*2.55,execResult[2]*2.55,execResult[3]*2.55,execResult[4]];}},{// This regex ignores A-F because it's compared against an already lowercased string
re:/#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})/,parse:function parse(execResult){return[parseInt(execResult[1],16),parseInt(execResult[2],16),parseInt(execResult[3],16)];}},{// This regex ignores A-F because it's compared against an already lowercased string
re:/#([a-f0-9])([a-f0-9])([a-f0-9])/,parse:function parse(execResult){return[parseInt(execResult[1]+execResult[1],16),parseInt(execResult[2]+execResult[2],16),parseInt(execResult[3]+execResult[3],16)];}},{re:/hsla?\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d?(?:\.\d+)?)\s*)?\)/,space:"hsla",parse:function parse(execResult){return[execResult[1],execResult[2]/100,execResult[3]/100,execResult[4]];}}],// JQuery.Color( )
color=jQuery.Color=function(color,green,blue,alpha){return new jQuery.Color.fn.parse(color,green,blue,alpha);},spaces={rgba:{props:{red:{idx:0,type:"byte"},green:{idx:1,type:"byte"},blue:{idx:2,type:"byte"}}},hsla:{props:{hue:{idx:0,type:"degrees"},saturation:{idx:1,type:"percent"},lightness:{idx:2,type:"percent"}}}},propTypes={"byte":{floor:true,max:255},"percent":{max:1},"degrees":{mod:360,floor:true}},support=color.support={},// Element for support tests
supportElem=jQuery("<p>")[0],// Colors = jQuery.Color.names
colors,// Local aliases of functions called often
each=jQuery.each;// Determine rgba support immediately
supportElem.style.cssText="background-color:rgba(1,1,1,.5)";support.rgba=supportElem.style.backgroundColor.indexOf("rgba")>-1;// Define cache name and alpha properties
// for rgba and hsla spaces
each(spaces,function(spaceName,space){space.cache="_"+spaceName;space.props.alpha={idx:3,type:"percent",def:1};});function clamp(value,prop,allowEmpty){var type=propTypes[prop.type]||{};if(value==null){return allowEmpty||!prop.def?null:prop.def;}// ~~ is an short way of doing floor for positive numbers
value=type.floor?~~value:parseFloat(value);// IE will pass in empty strings as value for alpha,
// which will hit this case
if(isNaN(value)){return prop.def;}if(type.mod){// We add mod before modding to make sure that negatives values
// get converted properly: -10 -> 350
return(value+type.mod)%type.mod;}// For now all property types without mod have min and max
return 0>value?0:type.max<value?type.max:value;}function stringParse(string){var inst=color(),rgba=inst._rgba=[];string=string.toLowerCase();each(stringParsers,function(i,parser){var parsed,match=parser.re.exec(string),values=match&&parser.parse(match),spaceName=parser.space||"rgba";if(values){parsed=inst[spaceName](values);// If this was an rgba parse the assignment might happen twice
// oh well....
inst[spaces[spaceName].cache]=parsed[spaces[spaceName].cache];rgba=inst._rgba=parsed._rgba;// Exit each( stringParsers ) here because we matched
return false;}});// Found a stringParser that handled it
if(rgba.length){// If this came from a parsed string, force "transparent" when alpha is 0
// chrome, (and maybe others) return "transparent" as rgba(0,0,0,0)
if(rgba.join()==="0,0,0,0"){jQuery.extend(rgba,colors.transparent);}return inst;}// Named colors
return colors[string];}color.fn=jQuery.extend(color.prototype,{parse:function parse(red,green,blue,alpha){if(red===undefined){this._rgba=[null,null,null,null];return this;}if(red.jquery||red.nodeType){red=jQuery(red).css(green);green=undefined;}var inst=this,type=jQuery.type(red),rgba=this._rgba=[];// More than 1 argument specified - assume ( red, green, blue, alpha )
if(green!==undefined){red=[red,green,blue,alpha];type="array";}if(type==="string"){return this.parse(stringParse(red)||colors._default);}if(type==="array"){each(spaces.rgba.props,function(key,prop){rgba[prop.idx]=clamp(red[prop.idx],prop);});return this;}if(type==="object"){if(red instanceof color){each(spaces,function(spaceName,space){if(red[space.cache]){inst[space.cache]=red[space.cache].slice();}});}else{each(spaces,function(spaceName,space){var cache=space.cache;each(space.props,function(key,prop){// If the cache doesn't exist, and we know how to convert
if(!inst[cache]&&space.to){// If the value was null, we don't need to copy it
// if the key was alpha, we don't need to copy it either
if(key==="alpha"||red[key]==null){return;}inst[cache]=space.to(inst._rgba);}// This is the only case where we allow nulls for ALL properties.
// call clamp with alwaysAllowEmpty
inst[cache][prop.idx]=clamp(red[key],prop,true);});// Everything defined but alpha?
if(inst[cache]&&jQuery.inArray(null,inst[cache].slice(0,3))<0){// Use the default of 1
inst[cache][3]=1;if(space.from){inst._rgba=space.from(inst[cache]);}}});}return this;}},is:function is(compare){var is=color(compare),same=true,inst=this;each(spaces,function(_,space){var localCache,isCache=is[space.cache];if(isCache){localCache=inst[space.cache]||space.to&&space.to(inst._rgba)||[];each(space.props,function(_,prop){if(isCache[prop.idx]!=null){same=isCache[prop.idx]===localCache[prop.idx];return same;}});}return same;});return same;},_space:function _space(){var used=[],inst=this;each(spaces,function(spaceName,space){if(inst[space.cache]){used.push(spaceName);}});return used.pop();},transition:function transition(other,distance){var end=color(other),spaceName=end._space(),space=spaces[spaceName],startColor=this.alpha()===0?color("transparent"):this,start=startColor[space.cache]||space.to(startColor._rgba),result=start.slice();end=end[space.cache];each(space.props,function(key,prop){var index=prop.idx,startValue=start[index],endValue=end[index],type=propTypes[prop.type]||{};// If null, don't override start value
if(endValue===null){return;}// If null - use end
if(startValue===null){result[index]=endValue;}else{if(type.mod){if(endValue-startValue>type.mod/2){startValue+=type.mod;}else if(startValue-endValue>type.mod/2){startValue-=type.mod;}}result[index]=clamp((endValue-startValue)*distance+startValue,prop);}});return this[spaceName](result);},blend:function blend(opaque){// If we are already opaque - return ourself
if(this._rgba[3]===1){return this;}var rgb=this._rgba.slice(),a=rgb.pop(),blend=color(opaque)._rgba;return color(jQuery.map(rgb,function(v,i){return(1-a)*blend[i]+a*v;}));},toRgbaString:function toRgbaString(){var prefix="rgba(",rgba=jQuery.map(this._rgba,function(v,i){return v==null?i>2?1:0:v;});if(rgba[3]===1){rgba.pop();prefix="rgb(";}return prefix+rgba.join()+")";},toHslaString:function toHslaString(){var prefix="hsla(",hsla=jQuery.map(this.hsla(),function(v,i){if(v==null){v=i>2?1:0;}// Catch 1 and 2
if(i&&i<3){v=Math.round(v*100)+"%";}return v;});if(hsla[3]===1){hsla.pop();prefix="hsl(";}return prefix+hsla.join()+")";},toHexString:function toHexString(includeAlpha){var rgba=this._rgba.slice(),alpha=rgba.pop();if(includeAlpha){rgba.push(~~(alpha*255));}return"#"+jQuery.map(rgba,function(v){// Default to 0 when nulls exist
v=(v||0).toString(16);return v.length===1?"0"+v:v;}).join("");},toString:function toString(){return this._rgba[3]===0?"transparent":this.toRgbaString();}});color.fn.parse.prototype=color.fn;// Hsla conversions adapted from:
// https://code.google.com/p/maashaack/source/browse/packages/graphics/trunk/src/graphics/colors/HUE2RGB.as?r=5021
function hue2rgb(p,q,h){h=(h+1)%1;if(h*6<1){return p+(q-p)*h*6;}if(h*2<1){return q;}if(h*3<2){return p+(q-p)*(2/3-h)*6;}return p;}spaces.hsla.to=function(rgba){if(rgba[0]==null||rgba[1]==null||rgba[2]==null){return[null,null,null,rgba[3]];}var r=rgba[0]/255,g=rgba[1]/255,b=rgba[2]/255,a=rgba[3],max=Math.max(r,g,b),min=Math.min(r,g,b),diff=max-min,add=max+min,l=add*0.5,h,s;if(min===max){h=0;}else if(r===max){h=60*(g-b)/diff+360;}else if(g===max){h=60*(b-r)/diff+120;}else{h=60*(r-g)/diff+240;}// Chroma (diff) == 0 means greyscale which, by definition, saturation = 0%
// otherwise, saturation is based on the ratio of chroma (diff) to lightness (add)
if(diff===0){s=0;}else if(l<=0.5){s=diff/add;}else{s=diff/(2-add);}return[Math.round(h)%360,s,l,a==null?1:a];};spaces.hsla.from=function(hsla){if(hsla[0]==null||hsla[1]==null||hsla[2]==null){return[null,null,null,hsla[3]];}var h=hsla[0]/360,s=hsla[1],l=hsla[2],a=hsla[3],q=l<=0.5?l*(1+s):l+s-l*s,p=2*l-q;return[Math.round(hue2rgb(p,q,h+1/3)*255),Math.round(hue2rgb(p,q,h)*255),Math.round(hue2rgb(p,q,h-1/3)*255),a];};each(spaces,function(spaceName,space){var props=space.props,cache=space.cache,to=space.to,from=space.from;// Makes rgba() and hsla()
color.fn[spaceName]=function(value){// Generate a cache for this space if it doesn't exist
if(to&&!this[cache]){this[cache]=to(this._rgba);}if(value===undefined){return this[cache].slice();}var ret,type=jQuery.type(value),arr=type==="array"||type==="object"?value:arguments,local=this[cache].slice();each(props,function(key,prop){var val=arr[type==="object"?key:prop.idx];if(val==null){val=local[prop.idx];}local[prop.idx]=clamp(val,prop);});if(from){ret=color(from(local));ret[cache]=local;return ret;}else{return color(local);}};// Makes red() green() blue() alpha() hue() saturation() lightness()
each(props,function(key,prop){// Alpha is included in more than one space
if(color.fn[key]){return;}color.fn[key]=function(value){var vtype=jQuery.type(value),fn=key==="alpha"?this._hsla?"hsla":"rgba":spaceName,local=this[fn](),cur=local[prop.idx],match;if(vtype==="undefined"){return cur;}if(vtype==="function"){value=value.call(this,cur);vtype=jQuery.type(value);}if(value==null&&prop.empty){return this;}if(vtype==="string"){match=rplusequals.exec(value);if(match){value=cur+parseFloat(match[2])*(match[1]==="+"?1:-1);}}local[prop.idx]=value;return this[fn](local);};});});// Add cssHook and .fx.step function for each named hook.
// accept a space separated string of properties
color.hook=function(hook){var hooks=hook.split(" ");each(hooks,function(i,hook){jQuery.cssHooks[hook]={set:function set(elem,value){var parsed,curElem,backgroundColor="";if(value!=="transparent"&&(jQuery.type(value)!=="string"||(parsed=stringParse(value)))){value=color(parsed||value);if(!support.rgba&&value._rgba[3]!==1){curElem=hook==="backgroundColor"?elem.parentNode:elem;while((backgroundColor===""||backgroundColor==="transparent")&&curElem&&curElem.style){try{backgroundColor=jQuery.css(curElem,"backgroundColor");curElem=curElem.parentNode;}catch(e){}}value=value.blend(backgroundColor&&backgroundColor!=="transparent"?backgroundColor:"_default");}value=value.toRgbaString();}try{elem.style[hook]=value;}catch(e){// Wrapped to prevent IE from throwing errors on "invalid" values like
// 'auto' or 'inherit'
}}};jQuery.fx.step[hook]=function(fx){if(!fx.colorInit){fx.start=color(fx.elem,hook);fx.end=color(fx.end);fx.colorInit=true;}jQuery.cssHooks[hook].set(fx.elem,fx.start.transition(fx.end,fx.pos));};});};color.hook(stepHooks);jQuery.cssHooks.borderColor={expand:function expand(value){var expanded={};each(["Top","Right","Bottom","Left"],function(i,part){expanded["border"+part+"Color"]=value;});return expanded;}};// Basic color names only.
// Usage of any of the other color names requires adding yourself or including
// jquery.color.svg-names.js.
colors=jQuery.Color.names={// 4.1. Basic color keywords
aqua:"#00ffff",black:"#000000",blue:"#0000ff",fuchsia:"#ff00ff",gray:"#808080",green:"#008000",lime:"#00ff00",maroon:"#800000",navy:"#000080",olive:"#808000",purple:"#800080",red:"#ff0000",silver:"#c0c0c0",teal:"#008080",white:"#ffffff",yellow:"#ffff00",// 4.2.3. "transparent" color keyword
transparent:[null,null,null,0],_default:"#ffffff"};})(jQuery);/******************************************************************************/ /****************************** CLASS ANIMATIONS ******************************/ /******************************************************************************/(function(){var classAnimationActions=["add","remove","toggle"],shorthandStyles={border:1,borderBottom:1,borderColor:1,borderLeft:1,borderRight:1,borderTop:1,borderWidth:1,margin:1,padding:1};$.each(["borderLeftStyle","borderRightStyle","borderBottomStyle","borderTopStyle"],function(_,prop){$.fx.step[prop]=function(fx){if(fx.end!=="none"&&!fx.setAttr||fx.pos===1&&!fx.setAttr){jQuery.style(fx.elem,prop,fx.end);fx.setAttr=true;}};});function getElementStyles(elem){var key,len,style=elem.ownerDocument.defaultView?elem.ownerDocument.defaultView.getComputedStyle(elem,null):elem.currentStyle,styles={};if(style&&style.length&&style[0]&&style[style[0]]){len=style.length;while(len--){key=style[len];if(typeof style[key]==="string"){styles[$.camelCase(key)]=style[key];}}// Support: Opera, IE <9
}else{for(key in style){if(typeof style[key]==="string"){styles[key]=style[key];}}}return styles;}function styleDifference(oldStyle,newStyle){var diff={},name,value;for(name in newStyle){value=newStyle[name];if(oldStyle[name]!==value){if(!shorthandStyles[name]){if($.fx.step[name]||!isNaN(parseFloat(value))){diff[name]=value;}}}}return diff;}// Support: jQuery <1.8
if(!$.fn.addBack){$.fn.addBack=function(selector){return this.add(selector==null?this.prevObject:this.prevObject.filter(selector));};}$.effects.animateClass=function(value,duration,easing,callback){var o=$.speed(duration,easing,callback);return this.queue(function(){var animated=$(this),baseClass=animated.attr("class")||"",applyClassChange,allAnimations=o.children?animated.find("*").addBack():animated;// Map the animated objects to store the original styles.
allAnimations=allAnimations.map(function(){var el=$(this);return{el:el,start:getElementStyles(this)};});// Apply class change
applyClassChange=function applyClassChange(){$.each(classAnimationActions,function(i,action){if(value[action]){animated[action+"Class"](value[action]);}});};applyClassChange();// Map all animated objects again - calculate new styles and diff
allAnimations=allAnimations.map(function(){this.end=getElementStyles(this.el[0]);this.diff=styleDifference(this.start,this.end);return this;});// Apply original class
animated.attr("class",baseClass);// Map all animated objects again - this time collecting a promise
allAnimations=allAnimations.map(function(){var styleInfo=this,dfd=$.Deferred(),opts=$.extend({},o,{queue:false,complete:function complete(){dfd.resolve(styleInfo);}});this.el.animate(this.diff,opts);return dfd.promise();});// Once all animations have completed:
$.when.apply($,allAnimations.get()).done(function(){// Set the final class
applyClassChange();// For each animated element,
// clear all css properties that were animated
$.each(arguments,function(){var el=this.el;$.each(this.diff,function(key){el.css(key,"");});});// This is guarnteed to be there if you use jQuery.speed()
// it also handles dequeuing the next anim...
o.complete.call(animated[0]);});});};$.fn.extend({addClass:function(orig){return function(classNames,speed,easing,callback){return speed?$.effects.animateClass.call(this,{add:classNames},speed,easing,callback):orig.apply(this,arguments);};}($.fn.addClass),removeClass:function(orig){return function(classNames,speed,easing,callback){return arguments.length>1?$.effects.animateClass.call(this,{remove:classNames},speed,easing,callback):orig.apply(this,arguments);};}($.fn.removeClass),toggleClass:function(orig){return function(classNames,force,speed,easing,callback){if(typeof force==="boolean"||force===undefined){if(!speed){// Without speed parameter
return orig.apply(this,arguments);}else{return $.effects.animateClass.call(this,force?{add:classNames}:{remove:classNames},speed,easing,callback);}}else{// Without force parameter
return $.effects.animateClass.call(this,{toggle:classNames},force,speed,easing);}};}($.fn.toggleClass),switchClass:function switchClass(remove,add,speed,easing,callback){return $.effects.animateClass.call(this,{add:add,remove:remove},speed,easing,callback);}});})();/******************************************************************************/ /*********************************** EFFECTS **********************************/ /******************************************************************************/(function(){if($.expr&&$.expr.filters&&$.expr.filters.animated){$.expr.filters.animated=function(orig){return function(elem){return!!$(elem).data(dataSpaceAnimated)||orig(elem);};}($.expr.filters.animated);}if($.uiBackCompat!==false){$.extend($.effects,{// Saves a set of properties in a data storage
save:function save(element,set){var i=0,length=set.length;for(;i<length;i++){if(set[i]!==null){element.data(dataSpace+set[i],element[0].style[set[i]]);}}},// Restores a set of previously saved properties from a data storage
restore:function restore(element,set){var val,i=0,length=set.length;for(;i<length;i++){if(set[i]!==null){val=element.data(dataSpace+set[i]);element.css(set[i],val);}}},setMode:function setMode(el,mode){if(mode==="toggle"){mode=el.is(":hidden")?"show":"hide";}return mode;},// Wraps the element around a wrapper that copies position properties
createWrapper:function createWrapper(element){// If the element is already wrapped, return it
if(element.parent().is(".ui-effects-wrapper")){return element.parent();}// Wrap the element
var props={width:element.outerWidth(true),height:element.outerHeight(true),"float":element.css("float")},wrapper=$("<div></div>").addClass("ui-effects-wrapper").css({fontSize:"100%",background:"transparent",border:"none",margin:0,padding:0}),// Store the size in case width/height are defined in % - Fixes #5245
size={width:element.width(),height:element.height()},active=document.activeElement;// Support: Firefox
// Firefox incorrectly exposes anonymous content
// https://bugzilla.mozilla.org/show_bug.cgi?id=561664
try{active.id;}catch(e){active=document.body;}element.wrap(wrapper);// Fixes #7595 - Elements lose focus when wrapped.
if(element[0]===active||$.contains(element[0],active)){$(active).trigger("focus");}// Hotfix for jQuery 1.4 since some change in wrap() seems to actually
// lose the reference to the wrapped element
wrapper=element.parent();// Transfer positioning properties to the wrapper
if(element.css("position")==="static"){wrapper.css({position:"relative"});element.css({position:"relative"});}else{$.extend(props,{position:element.css("position"),zIndex:element.css("z-index")});$.each(["top","left","bottom","right"],function(i,pos){props[pos]=element.css(pos);if(isNaN(parseInt(props[pos],10))){props[pos]="auto";}});element.css({position:"relative",top:0,left:0,right:"auto",bottom:"auto"});}element.css(size);return wrapper.css(props).show();},removeWrapper:function removeWrapper(element){var active=document.activeElement;if(element.parent().is(".ui-effects-wrapper")){element.parent().replaceWith(element);// Fixes #7595 - Elements lose focus when wrapped.
if(element[0]===active||$.contains(element[0],active)){$(active).trigger("focus");}}return element;}});}$.extend($.effects,{version:"1.12.1",define:function define(name,mode,effect){if(!effect){effect=mode;mode="effect";}$.effects.effect[name]=effect;$.effects.effect[name].mode=mode;return effect;},scaledDimensions:function scaledDimensions(element,percent,direction){if(percent===0){return{height:0,width:0,outerHeight:0,outerWidth:0};}var x=direction!=="horizontal"?(percent||100)/100:1,y=direction!=="vertical"?(percent||100)/100:1;return{height:element.height()*y,width:element.width()*x,outerHeight:element.outerHeight()*y,outerWidth:element.outerWidth()*x};},clipToBox:function clipToBox(animation){return{width:animation.clip.right-animation.clip.left,height:animation.clip.bottom-animation.clip.top,left:animation.clip.left,top:animation.clip.top};},// Injects recently queued functions to be first in line (after "inprogress")
unshift:function unshift(element,queueLength,count){var queue=element.queue();if(queueLength>1){queue.splice.apply(queue,[1,0].concat(queue.splice(queueLength,count)));}element.dequeue();},saveStyle:function saveStyle(element){element.data(dataSpaceStyle,element[0].style.cssText);},restoreStyle:function restoreStyle(element){element[0].style.cssText=element.data(dataSpaceStyle)||"";element.removeData(dataSpaceStyle);},mode:function mode(element,_mode){var hidden=element.is(":hidden");if(_mode==="toggle"){_mode=hidden?"show":"hide";}if(hidden?_mode==="hide":_mode==="show"){_mode="none";}return _mode;},// Translates a [top,left] array into a baseline value
getBaseline:function getBaseline(origin,original){var y,x;switch(origin[0]){case"top":y=0;break;case"middle":y=0.5;break;case"bottom":y=1;break;default:y=origin[0]/original.height;}switch(origin[1]){case"left":x=0;break;case"center":x=0.5;break;case"right":x=1;break;default:x=origin[1]/original.width;}return{x:x,y:y};},// Creates a placeholder element so that the original element can be made absolute
createPlaceholder:function createPlaceholder(element){var placeholder,cssPosition=element.css("position"),position=element.position();// Lock in margins first to account for form elements, which
// will change margin if you explicitly set height
// see: http://jsfiddle.net/JZSMt/3/ https://bugs.webkit.org/show_bug.cgi?id=107380
// Support: Safari
element.css({marginTop:element.css("marginTop"),marginBottom:element.css("marginBottom"),marginLeft:element.css("marginLeft"),marginRight:element.css("marginRight")}).outerWidth(element.outerWidth()).outerHeight(element.outerHeight());if(/^(static|relative)/.test(cssPosition)){cssPosition="absolute";placeholder=$("<"+element[0].nodeName+">").insertAfter(element).css({// Convert inline to inline block to account for inline elements
// that turn to inline block based on content (like img)
display:/^(inline|ruby)/.test(element.css("display"))?"inline-block":"block",visibility:"hidden",// Margins need to be set to account for margin collapse
marginTop:element.css("marginTop"),marginBottom:element.css("marginBottom"),marginLeft:element.css("marginLeft"),marginRight:element.css("marginRight"),"float":element.css("float")}).outerWidth(element.outerWidth()).outerHeight(element.outerHeight()).addClass("ui-effects-placeholder");element.data(dataSpace+"placeholder",placeholder);}element.css({position:cssPosition,left:position.left,top:position.top});return placeholder;},removePlaceholder:function removePlaceholder(element){var dataKey=dataSpace+"placeholder",placeholder=element.data(dataKey);if(placeholder){placeholder.remove();element.removeData(dataKey);}},// Removes a placeholder if it exists and restores
// properties that were modified during placeholder creation
cleanUp:function cleanUp(element){$.effects.restoreStyle(element);$.effects.removePlaceholder(element);},setTransition:function setTransition(element,list,factor,value){value=value||{};$.each(list,function(i,x){var unit=element.cssUnit(x);if(unit[0]>0){value[x]=unit[0]*factor+unit[1];}});return value;}});// Return an effect options object for the given parameters:
function _normalizeArguments(effect,options,speed,callback){// Allow passing all options as the first parameter
if($.isPlainObject(effect)){options=effect;effect=effect.effect;}// Convert to an object
effect={effect:effect};// Catch (effect, null, ...)
if(options==null){options={};}// Catch (effect, callback)
if($.isFunction(options)){callback=options;speed=null;options={};}// Catch (effect, speed, ?)
if(typeof options==="number"||$.fx.speeds[options]){callback=speed;speed=options;options={};}// Catch (effect, options, callback)
if($.isFunction(speed)){callback=speed;speed=null;}// Add options to effect
if(options){$.extend(effect,options);}speed=speed||options.duration;effect.duration=$.fx.off?0:typeof speed==="number"?speed:speed in $.fx.speeds?$.fx.speeds[speed]:$.fx.speeds._default;effect.complete=callback||options.complete;return effect;}function standardAnimationOption(option){// Valid standard speeds (nothing, number, named speed)
if(!option||typeof option==="number"||$.fx.speeds[option]){return true;}// Invalid strings - treat as "normal" speed
if(typeof option==="string"&&!$.effects.effect[option]){return true;}// Complete callback
if($.isFunction(option)){return true;}// Options hash (but not naming an effect)
if(_typeof(option)==="object"&&!option.effect){return true;}// Didn't match any standard API
return false;}$.fn.extend({effect:function effect(/* effect, options, speed, callback */){var args=_normalizeArguments.apply(this,arguments),effectMethod=$.effects.effect[args.effect],defaultMode=effectMethod.mode,queue=args.queue,queueName=queue||"fx",complete=args.complete,mode=args.mode,modes=[],prefilter=function prefilter(next){var el=$(this),normalizedMode=$.effects.mode(el,mode)||defaultMode;// Sentinel for duck-punching the :animated psuedo-selector
el.data(dataSpaceAnimated,true);// Save effect mode for later use,
// we can't just call $.effects.mode again later,
// as the .show() below destroys the initial state
modes.push(normalizedMode);// See $.uiBackCompat inside of run() for removal of defaultMode in 1.13
if(defaultMode&&(normalizedMode==="show"||normalizedMode===defaultMode&&normalizedMode==="hide")){el.show();}if(!defaultMode||normalizedMode!=="none"){$.effects.saveStyle(el);}if($.isFunction(next)){next();}};if($.fx.off||!effectMethod){// Delegate to the original method (e.g., .show()) if possible
if(mode){return this[mode](args.duration,complete);}else{return this.each(function(){if(complete){complete.call(this);}});}}function run(next){var elem=$(this);function cleanup(){elem.removeData(dataSpaceAnimated);$.effects.cleanUp(elem);if(args.mode==="hide"){elem.hide();}done();}function done(){if($.isFunction(complete)){complete.call(elem[0]);}if($.isFunction(next)){next();}}// Override mode option on a per element basis,
// as toggle can be either show or hide depending on element state
args.mode=modes.shift();if($.uiBackCompat!==false&&!defaultMode){if(elem.is(":hidden")?mode==="hide":mode==="show"){// Call the core method to track "olddisplay" properly
elem[mode]();done();}else{effectMethod.call(elem[0],args,done);}}else{if(args.mode==="none"){// Call the core method to track "olddisplay" properly
elem[mode]();done();}else{effectMethod.call(elem[0],args,cleanup);}}}// Run prefilter on all elements first to ensure that
// any showing or hiding happens before placeholder creation,
// which ensures that any layout changes are correctly captured.
return queue===false?this.each(prefilter).each(run):this.queue(queueName,prefilter).queue(queueName,run);},show:function(orig){return function(option){if(standardAnimationOption(option)){return orig.apply(this,arguments);}else{var args=_normalizeArguments.apply(this,arguments);args.mode="show";return this.effect.call(this,args);}};}($.fn.show),hide:function(orig){return function(option){if(standardAnimationOption(option)){return orig.apply(this,arguments);}else{var args=_normalizeArguments.apply(this,arguments);args.mode="hide";return this.effect.call(this,args);}};}($.fn.hide),toggle:function(orig){return function(option){if(standardAnimationOption(option)||typeof option==="boolean"){return orig.apply(this,arguments);}else{var args=_normalizeArguments.apply(this,arguments);args.mode="toggle";return this.effect.call(this,args);}};}($.fn.toggle),cssUnit:function cssUnit(key){var style=this.css(key),val=[];$.each(["em","px","%","pt"],function(i,unit){if(style.indexOf(unit)>0){val=[parseFloat(style),unit];}});return val;},cssClip:function cssClip(clipObj){if(clipObj){return this.css("clip","rect("+clipObj.top+"px "+clipObj.right+"px "+clipObj.bottom+"px "+clipObj.left+"px)");}return parseClip(this.css("clip"),this);},transfer:function transfer(options,done){var element=$(this),target=$(options.to),targetFixed=target.css("position")==="fixed",body=$("body"),fixTop=targetFixed?body.scrollTop():0,fixLeft=targetFixed?body.scrollLeft():0,endPosition=target.offset(),animation={top:endPosition.top-fixTop,left:endPosition.left-fixLeft,height:target.innerHeight(),width:target.innerWidth()},startPosition=element.offset(),transfer=$("<div class='ui-effects-transfer'></div>").appendTo("body").addClass(options.className).css({top:startPosition.top-fixTop,left:startPosition.left-fixLeft,height:element.innerHeight(),width:element.innerWidth(),position:targetFixed?"fixed":"absolute"}).animate(animation,options.duration,options.easing,function(){transfer.remove();if($.isFunction(done)){done();}});}});function parseClip(str,element){var outerWidth=element.outerWidth(),outerHeight=element.outerHeight(),clipRegex=/^rect\((-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto),?\s*(-?\d*\.?\d*px|-?\d+%|auto)\)$/,values=clipRegex.exec(str)||["",0,outerWidth,outerHeight,0];return{top:parseFloat(values[1])||0,right:values[2]==="auto"?outerWidth:parseFloat(values[2]),bottom:values[3]==="auto"?outerHeight:parseFloat(values[3]),left:parseFloat(values[4])||0};}$.fx.step.clip=function(fx){if(!fx.clipInit){fx.start=$(fx.elem).cssClip();if(typeof fx.end==="string"){fx.end=parseClip(fx.end,fx.elem);}fx.clipInit=true;}$(fx.elem).cssClip({top:fx.pos*(fx.end.top-fx.start.top)+fx.start.top,right:fx.pos*(fx.end.right-fx.start.right)+fx.start.right,bottom:fx.pos*(fx.end.bottom-fx.start.bottom)+fx.start.bottom,left:fx.pos*(fx.end.left-fx.start.left)+fx.start.left});};})();/******************************************************************************/ /*********************************** EASING ***********************************/ /******************************************************************************/(function(){// Based on easing equations from Robert Penner (http://www.robertpenner.com/easing)
var baseEasings={};$.each(["Quad","Cubic","Quart","Quint","Expo"],function(i,name){baseEasings[name]=function(p){return Math.pow(p,i+2);};});$.extend(baseEasings,{Sine:function Sine(p){return 1-Math.cos(p*Math.PI/2);},Circ:function Circ(p){return 1-Math.sqrt(1-p*p);},Elastic:function Elastic(p){return p===0||p===1?p:-Math.pow(2,8*(p-1))*Math.sin(((p-1)*80-7.5)*Math.PI/15);},Back:function Back(p){return p*p*(3*p-2);},Bounce:function Bounce(p){var pow2,bounce=4;while(p<((pow2=Math.pow(2,--bounce))-1)/11){}return 1/Math.pow(4,3-bounce)-7.5625*Math.pow((pow2*3-2)/22-p,2);}});$.each(baseEasings,function(name,easeIn){$.easing["easeIn"+name]=easeIn;$.easing["easeOut"+name]=function(p){return 1-easeIn(1-p);};$.easing["easeInOut"+name]=function(p){return p<0.5?easeIn(p*2)/2:1-easeIn(p*-2+2)/2;};});})();var effect=$.effects;/*!
 * jQuery UI Effects Blind 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Blind Effect
//>>group: Effects
//>>description: Blinds the element.
//>>docs: http://api.jqueryui.com/blind-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectBlind=$.effects.define("blind","hide",function(options,done){var map={up:["bottom","top"],vertical:["bottom","top"],down:["top","bottom"],left:["right","left"],horizontal:["right","left"],right:["left","right"]},element=$(this),direction=options.direction||"up",start=element.cssClip(),animate={clip:$.extend({},start)},placeholder=$.effects.createPlaceholder(element);animate.clip[map[direction][0]]=animate.clip[map[direction][1]];if(options.mode==="show"){element.cssClip(animate.clip);if(placeholder){placeholder.css($.effects.clipToBox(animate));}animate.clip=start;}if(placeholder){placeholder.animate($.effects.clipToBox(animate),options.duration,options.easing);}element.animate(animate,{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
 * jQuery UI Effects Bounce 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Bounce Effect
//>>group: Effects
//>>description: Bounces an element horizontally or vertically n times.
//>>docs: http://api.jqueryui.com/bounce-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectBounce=$.effects.define("bounce",function(options,done){var upAnim,downAnim,refValue,element=$(this),// Defaults:
mode=options.mode,hide=mode==="hide",show=mode==="show",direction=options.direction||"up",distance=options.distance,times=options.times||5,// Number of internal animations
anims=times*2+(show||hide?1:0),speed=options.duration/anims,easing=options.easing,// Utility:
ref=direction==="up"||direction==="down"?"top":"left",motion=direction==="up"||direction==="left",i=0,queuelen=element.queue().length;$.effects.createPlaceholder(element);refValue=element.css(ref);// Default distance for the BIGGEST bounce is the outer Distance / 3
if(!distance){distance=element[ref==="top"?"outerHeight":"outerWidth"]()/3;}if(show){downAnim={opacity:1};downAnim[ref]=refValue;// If we are showing, force opacity 0 and set the initial position
// then do the "first" animation
element.css("opacity",0).css(ref,motion?-distance*2:distance*2).animate(downAnim,speed,easing);}// Start at the smallest distance if we are hiding
if(hide){distance=distance/Math.pow(2,times-1);}downAnim={};downAnim[ref]=refValue;// Bounces up/down/left/right then back to 0 -- times * 2 animations happen here
for(;i<times;i++){upAnim={};upAnim[ref]=(motion?"-=":"+=")+distance;element.animate(upAnim,speed,easing).animate(downAnim,speed,easing);distance=hide?distance*2:distance/2;}// Last Bounce when Hiding
if(hide){upAnim={opacity:0};upAnim[ref]=(motion?"-=":"+=")+distance;element.animate(upAnim,speed,easing);}element.queue(done);$.effects.unshift(element,queuelen,anims+1);});/*!
 * jQuery UI Effects Clip 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Clip Effect
//>>group: Effects
//>>description: Clips the element on and off like an old TV.
//>>docs: http://api.jqueryui.com/clip-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectClip=$.effects.define("clip","hide",function(options,done){var start,animate={},element=$(this),direction=options.direction||"vertical",both=direction==="both",horizontal=both||direction==="horizontal",vertical=both||direction==="vertical";start=element.cssClip();animate.clip={top:vertical?(start.bottom-start.top)/2:start.top,right:horizontal?(start.right-start.left)/2:start.right,bottom:vertical?(start.bottom-start.top)/2:start.bottom,left:horizontal?(start.right-start.left)/2:start.left};$.effects.createPlaceholder(element);if(options.mode==="show"){element.cssClip(animate.clip);animate.clip=start;}element.animate(animate,{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
 * jQuery UI Effects Drop 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Drop Effect
//>>group: Effects
//>>description: Moves an element in one direction and hides it at the same time.
//>>docs: http://api.jqueryui.com/drop-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectDrop=$.effects.define("drop","hide",function(options,done){var distance,element=$(this),mode=options.mode,show=mode==="show",direction=options.direction||"left",ref=direction==="up"||direction==="down"?"top":"left",motion=direction==="up"||direction==="left"?"-=":"+=",oppositeMotion=motion==="+="?"-=":"+=",animation={opacity:0};$.effects.createPlaceholder(element);distance=options.distance||element[ref==="top"?"outerHeight":"outerWidth"](true)/2;animation[ref]=motion+distance;if(show){element.css(animation);animation[ref]=oppositeMotion+distance;animation.opacity=1;}// Animate
element.animate(animation,{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
 * jQuery UI Effects Explode 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Explode Effect
//>>group: Effects
// jscs:disable maximumLineLength
//>>description: Explodes an element in all directions into n pieces. Implodes an element to its original wholeness.
// jscs:enable maximumLineLength
//>>docs: http://api.jqueryui.com/explode-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectExplode=$.effects.define("explode","hide",function(options,done){var i,j,left,top,mx,my,rows=options.pieces?Math.round(Math.sqrt(options.pieces)):3,cells=rows,element=$(this),mode=options.mode,show=mode==="show",// Show and then visibility:hidden the element before calculating offset
offset=element.show().css("visibility","hidden").offset(),// Width and height of a piece
width=Math.ceil(element.outerWidth()/cells),height=Math.ceil(element.outerHeight()/rows),pieces=[];// Children animate complete:
function childComplete(){pieces.push(this);if(pieces.length===rows*cells){animComplete();}}// Clone the element for each row and cell.
for(i=0;i<rows;i++){// ===>
top=offset.top+i*height;my=i-(rows-1)/2;for(j=0;j<cells;j++){// |||
left=offset.left+j*width;mx=j-(cells-1)/2;// Create a clone of the now hidden main element that will be absolute positioned
// within a wrapper div off the -left and -top equal to size of our pieces
element.clone().appendTo("body").wrap("<div></div>").css({position:"absolute",visibility:"visible",left:-j*width,top:-i*height})// Select the wrapper - make it overflow: hidden and absolute positioned based on
// where the original was located +left and +top equal to the size of pieces
.parent().addClass("ui-effects-explode").css({position:"absolute",overflow:"hidden",width:width,height:height,left:left+(show?mx*width:0),top:top+(show?my*height:0),opacity:show?0:1}).animate({left:left+(show?0:mx*width),top:top+(show?0:my*height),opacity:show?1:0},options.duration||500,options.easing,childComplete);}}function animComplete(){element.css({visibility:"visible"});$(pieces).remove();done();}});/*!
 * jQuery UI Effects Fade 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Fade Effect
//>>group: Effects
//>>description: Fades the element.
//>>docs: http://api.jqueryui.com/fade-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectFade=$.effects.define("fade","toggle",function(options,done){var show=options.mode==="show";$(this).css("opacity",show?0:1).animate({opacity:show?1:0},{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
 * jQuery UI Effects Fold 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Fold Effect
//>>group: Effects
//>>description: Folds an element first horizontally and then vertically.
//>>docs: http://api.jqueryui.com/fold-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectFold=$.effects.define("fold","hide",function(options,done){// Create element
var element=$(this),mode=options.mode,show=mode==="show",hide=mode==="hide",size=options.size||15,percent=/([0-9]+)%/.exec(size),horizFirst=!!options.horizFirst,ref=horizFirst?["right","bottom"]:["bottom","right"],duration=options.duration/2,placeholder=$.effects.createPlaceholder(element),start=element.cssClip(),animation1={clip:$.extend({},start)},animation2={clip:$.extend({},start)},distance=[start[ref[0]],start[ref[1]]],queuelen=element.queue().length;if(percent){size=parseInt(percent[1],10)/100*distance[hide?0:1];}animation1.clip[ref[0]]=size;animation2.clip[ref[0]]=size;animation2.clip[ref[1]]=0;if(show){element.cssClip(animation2.clip);if(placeholder){placeholder.css($.effects.clipToBox(animation2));}animation2.clip=start;}// Animate
element.queue(function(next){if(placeholder){placeholder.animate($.effects.clipToBox(animation1),duration,options.easing).animate($.effects.clipToBox(animation2),duration,options.easing);}next();}).animate(animation1,duration,options.easing).animate(animation2,duration,options.easing).queue(done);$.effects.unshift(element,queuelen,4);});/*!
 * jQuery UI Effects Highlight 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Highlight Effect
//>>group: Effects
//>>description: Highlights the background of an element in a defined color for a custom duration.
//>>docs: http://api.jqueryui.com/highlight-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectHighlight=$.effects.define("highlight","show",function(options,done){var element=$(this),animation={backgroundColor:element.css("backgroundColor")};if(options.mode==="hide"){animation.opacity=0;}$.effects.saveStyle(element);element.css({backgroundImage:"none",backgroundColor:options.color||"#ffff99"}).animate(animation,{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
 * jQuery UI Effects Size 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Size Effect
//>>group: Effects
//>>description: Resize an element to a specified width and height.
//>>docs: http://api.jqueryui.com/size-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectSize=$.effects.define("size",function(options,done){// Create element
var baseline,factor,temp,element=$(this),// Copy for children
cProps=["fontSize"],vProps=["borderTopWidth","borderBottomWidth","paddingTop","paddingBottom"],hProps=["borderLeftWidth","borderRightWidth","paddingLeft","paddingRight"],// Set options
mode=options.mode,restore=mode!=="effect",scale=options.scale||"both",origin=options.origin||["middle","center"],position=element.css("position"),pos=element.position(),original=$.effects.scaledDimensions(element),from=options.from||original,to=options.to||$.effects.scaledDimensions(element,0);$.effects.createPlaceholder(element);if(mode==="show"){temp=from;from=to;to=temp;}// Set scaling factor
factor={from:{y:from.height/original.height,x:from.width/original.width},to:{y:to.height/original.height,x:to.width/original.width}};// Scale the css box
if(scale==="box"||scale==="both"){// Vertical props scaling
if(factor.from.y!==factor.to.y){from=$.effects.setTransition(element,vProps,factor.from.y,from);to=$.effects.setTransition(element,vProps,factor.to.y,to);}// Horizontal props scaling
if(factor.from.x!==factor.to.x){from=$.effects.setTransition(element,hProps,factor.from.x,from);to=$.effects.setTransition(element,hProps,factor.to.x,to);}}// Scale the content
if(scale==="content"||scale==="both"){// Vertical props scaling
if(factor.from.y!==factor.to.y){from=$.effects.setTransition(element,cProps,factor.from.y,from);to=$.effects.setTransition(element,cProps,factor.to.y,to);}}// Adjust the position properties based on the provided origin points
if(origin){baseline=$.effects.getBaseline(origin,original);from.top=(original.outerHeight-from.outerHeight)*baseline.y+pos.top;from.left=(original.outerWidth-from.outerWidth)*baseline.x+pos.left;to.top=(original.outerHeight-to.outerHeight)*baseline.y+pos.top;to.left=(original.outerWidth-to.outerWidth)*baseline.x+pos.left;}element.css(from);// Animate the children if desired
if(scale==="content"||scale==="both"){vProps=vProps.concat(["marginTop","marginBottom"]).concat(cProps);hProps=hProps.concat(["marginLeft","marginRight"]);// Only animate children with width attributes specified
// TODO: is this right? should we include anything with css width specified as well
element.find("*[width]").each(function(){var child=$(this),childOriginal=$.effects.scaledDimensions(child),childFrom={height:childOriginal.height*factor.from.y,width:childOriginal.width*factor.from.x,outerHeight:childOriginal.outerHeight*factor.from.y,outerWidth:childOriginal.outerWidth*factor.from.x},childTo={height:childOriginal.height*factor.to.y,width:childOriginal.width*factor.to.x,outerHeight:childOriginal.height*factor.to.y,outerWidth:childOriginal.width*factor.to.x};// Vertical props scaling
if(factor.from.y!==factor.to.y){childFrom=$.effects.setTransition(child,vProps,factor.from.y,childFrom);childTo=$.effects.setTransition(child,vProps,factor.to.y,childTo);}// Horizontal props scaling
if(factor.from.x!==factor.to.x){childFrom=$.effects.setTransition(child,hProps,factor.from.x,childFrom);childTo=$.effects.setTransition(child,hProps,factor.to.x,childTo);}if(restore){$.effects.saveStyle(child);}// Animate children
child.css(childFrom);child.animate(childTo,options.duration,options.easing,function(){// Restore children
if(restore){$.effects.restoreStyle(child);}});});}// Animate
element.animate(to,{queue:false,duration:options.duration,easing:options.easing,complete:function complete(){var offset=element.offset();if(to.opacity===0){element.css("opacity",from.opacity);}if(!restore){element.css("position",position==="static"?"relative":position).offset(offset);// Need to save style here so that automatic style restoration
// doesn't restore to the original styles from before the animation.
$.effects.saveStyle(element);}done();}});});/*!
 * jQuery UI Effects Scale 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Scale Effect
//>>group: Effects
//>>description: Grows or shrinks an element and its content.
//>>docs: http://api.jqueryui.com/scale-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectScale=$.effects.define("scale",function(options,done){// Create element
var el=$(this),mode=options.mode,percent=parseInt(options.percent,10)||(parseInt(options.percent,10)===0?0:mode!=="effect"?0:100),newOptions=$.extend(true,{from:$.effects.scaledDimensions(el),to:$.effects.scaledDimensions(el,percent,options.direction||"both"),origin:options.origin||["middle","center"]},options);// Fade option to support puff
if(options.fade){newOptions.from.opacity=1;newOptions.to.opacity=0;}$.effects.effect.size.call(this,newOptions,done);});/*!
 * jQuery UI Effects Puff 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Puff Effect
//>>group: Effects
//>>description: Creates a puff effect by scaling the element up and hiding it at the same time.
//>>docs: http://api.jqueryui.com/puff-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectPuff=$.effects.define("puff","hide",function(options,done){var newOptions=$.extend(true,{},options,{fade:true,percent:parseInt(options.percent,10)||150});$.effects.effect.scale.call(this,newOptions,done);});/*!
 * jQuery UI Effects Pulsate 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Pulsate Effect
//>>group: Effects
//>>description: Pulsates an element n times by changing the opacity to zero and back.
//>>docs: http://api.jqueryui.com/pulsate-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectPulsate=$.effects.define("pulsate","show",function(options,done){var element=$(this),mode=options.mode,show=mode==="show",hide=mode==="hide",showhide=show||hide,// Showing or hiding leaves off the "last" animation
anims=(options.times||5)*2+(showhide?1:0),duration=options.duration/anims,animateTo=0,i=1,queuelen=element.queue().length;if(show||!element.is(":visible")){element.css("opacity",0).show();animateTo=1;}// Anims - 1 opacity "toggles"
for(;i<anims;i++){element.animate({opacity:animateTo},duration,options.easing);animateTo=1-animateTo;}element.animate({opacity:animateTo},duration,options.easing);element.queue(done);$.effects.unshift(element,queuelen,anims+1);});/*!
 * jQuery UI Effects Shake 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Shake Effect
//>>group: Effects
//>>description: Shakes an element horizontally or vertically n times.
//>>docs: http://api.jqueryui.com/shake-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectShake=$.effects.define("shake",function(options,done){var i=1,element=$(this),direction=options.direction||"left",distance=options.distance||20,times=options.times||3,anims=times*2+1,speed=Math.round(options.duration/anims),ref=direction==="up"||direction==="down"?"top":"left",positiveMotion=direction==="up"||direction==="left",animation={},animation1={},animation2={},queuelen=element.queue().length;$.effects.createPlaceholder(element);// Animation
animation[ref]=(positiveMotion?"-=":"+=")+distance;animation1[ref]=(positiveMotion?"+=":"-=")+distance*2;animation2[ref]=(positiveMotion?"-=":"+=")+distance*2;// Animate
element.animate(animation,speed,options.easing);// Shakes
for(;i<times;i++){element.animate(animation1,speed,options.easing).animate(animation2,speed,options.easing);}element.animate(animation1,speed,options.easing).animate(animation,speed/2,options.easing).queue(done);$.effects.unshift(element,queuelen,anims+1);});/*!
 * jQuery UI Effects Slide 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Slide Effect
//>>group: Effects
//>>description: Slides an element in and out of the viewport.
//>>docs: http://api.jqueryui.com/slide-effect/
//>>demos: http://jqueryui.com/effect/
var effectsEffectSlide=$.effects.define("slide","show",function(options,done){var startClip,startRef,element=$(this),map={up:["bottom","top"],down:["top","bottom"],left:["right","left"],right:["left","right"]},mode=options.mode,direction=options.direction||"left",ref=direction==="up"||direction==="down"?"top":"left",positiveMotion=direction==="up"||direction==="left",distance=options.distance||element[ref==="top"?"outerHeight":"outerWidth"](true),animation={};$.effects.createPlaceholder(element);startClip=element.cssClip();startRef=element.position()[ref];// Define hide animation
animation[ref]=(positiveMotion?-1:1)*distance+startRef;animation.clip=element.cssClip();animation.clip[map[direction][1]]=animation.clip[map[direction][0]];// Reverse the animation if we're showing
if(mode==="show"){element.cssClip(animation.clip);element.css(ref,animation[ref]);animation.clip=startClip;animation[ref]=startRef;}// Actually animate
element.animate(animation,{queue:false,duration:options.duration,easing:options.easing,complete:done});});/*!
 * jQuery UI Effects Transfer 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Transfer Effect
//>>group: Effects
//>>description: Displays a transfer effect from one element to another.
//>>docs: http://api.jqueryui.com/transfer-effect/
//>>demos: http://jqueryui.com/effect/
var effect;if($.uiBackCompat!==false){effect=$.effects.define("transfer",function(options,done){$(this).transfer(options,done);});}var effectsEffectTransfer=effect;/*!
 * jQuery UI Focusable 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: :focusable Selector
//>>group: Core
//>>description: Selects elements which can be focused.
//>>docs: http://api.jqueryui.com/focusable-selector/
// Selectors
$.ui.focusable=function(element,hasTabindex){var map,mapName,img,focusableIfVisible,fieldset,nodeName=element.nodeName.toLowerCase();if("area"===nodeName){map=element.parentNode;mapName=map.name;if(!element.href||!mapName||map.nodeName.toLowerCase()!=="map"){return false;}img=$("img[usemap='#"+mapName+"']");return img.length>0&&img.is(":visible");}if(/^(input|select|textarea|button|object)$/.test(nodeName)){focusableIfVisible=!element.disabled;if(focusableIfVisible){// Form controls within a disabled fieldset are disabled.
// However, controls within the fieldset's legend do not get disabled.
// Since controls generally aren't placed inside legends, we skip
// this portion of the check.
fieldset=$(element).closest("fieldset")[0];if(fieldset){focusableIfVisible=!fieldset.disabled;}}}else if("a"===nodeName){focusableIfVisible=element.href||hasTabindex;}else{focusableIfVisible=hasTabindex;}return focusableIfVisible&&$(element).is(":visible")&&visible($(element));};// Support: IE 8 only
// IE 8 doesn't resolve inherit to visible/hidden for computed values
function visible(element){var visibility=element.css("visibility");while(visibility==="inherit"){element=element.parent();visibility=element.css("visibility");}return visibility!=="hidden";}$.extend($.expr[":"],{focusable:function focusable(element){return $.ui.focusable(element,$.attr(element,"tabindex")!=null);}});var focusable=$.ui.focusable;// Support: IE8 Only
// IE8 does not support the form attribute and when it is supplied. It overwrites the form prop
// with a string, so we need to find the proper form.
var form=$.fn.form=function(){return typeof this[0].form==="string"?this.closest("form"):$(this[0].form);};/*!
 * jQuery UI Form Reset Mixin 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Form Reset Mixin
//>>group: Core
//>>description: Refresh input widgets when their form is reset
//>>docs: http://api.jqueryui.com/form-reset-mixin/
var formResetMixin=$.ui.formResetMixin={_formResetHandler:function _formResetHandler(){var form=$(this);// Wait for the form reset to actually happen before refreshing
setTimeout(function(){var instances=form.data("ui-form-reset-instances");$.each(instances,function(){this.refresh();});});},_bindFormResetHandler:function _bindFormResetHandler(){this.form=this.element.form();if(!this.form.length){return;}var instances=this.form.data("ui-form-reset-instances")||[];if(!instances.length){// We don't use _on() here because we use a single event handler per form
this.form.on("reset.ui-form-reset",this._formResetHandler);}instances.push(this);this.form.data("ui-form-reset-instances",instances);},_unbindFormResetHandler:function _unbindFormResetHandler(){if(!this.form.length){return;}var instances=this.form.data("ui-form-reset-instances");instances.splice($.inArray(this,instances),1);if(instances.length){this.form.data("ui-form-reset-instances",instances);}else{this.form.removeData("ui-form-reset-instances").off("reset.ui-form-reset");}}};/*!
 * jQuery UI Support for jQuery core 1.7.x 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 */ //>>label: jQuery 1.7 Support
//>>group: Core
//>>description: Support version 1.7.x of jQuery core
// Support: jQuery 1.7 only
// Not a great way to check versions, but since we only support 1.7+ and only
// need to detect <1.8, this is a simple check that should suffice. Checking
// for "1.7." would be a bit safer, but the version string is 1.7, not 1.7.0
// and we'll never reach 1.70.0 (if we do, we certainly won't be supporting
// 1.7 anymore). See #11197 for why we're not using feature detection.
if($.fn.jquery.substring(0,3)==="1.7"){// Setters for .innerWidth(), .innerHeight(), .outerWidth(), .outerHeight()
// Unlike jQuery Core 1.8+, these only support numeric values to set the
// dimensions in pixels
$.each(["Width","Height"],function(i,name){var side=name==="Width"?["Left","Right"]:["Top","Bottom"],type=name.toLowerCase(),orig={innerWidth:$.fn.innerWidth,innerHeight:$.fn.innerHeight,outerWidth:$.fn.outerWidth,outerHeight:$.fn.outerHeight};function reduce(elem,size,border,margin){$.each(side,function(){size-=parseFloat($.css(elem,"padding"+this))||0;if(border){size-=parseFloat($.css(elem,"border"+this+"Width"))||0;}if(margin){size-=parseFloat($.css(elem,"margin"+this))||0;}});return size;}$.fn["inner"+name]=function(size){if(size===undefined){return orig["inner"+name].call(this);}return this.each(function(){$(this).css(type,reduce(this,size)+"px");});};$.fn["outer"+name]=function(size,margin){if(typeof size!=="number"){return orig["outer"+name].call(this,size);}return this.each(function(){$(this).css(type,reduce(this,size,true,margin)+"px");});};});$.fn.addBack=function(selector){return this.add(selector==null?this.prevObject:this.prevObject.filter(selector));};};/*!
 * jQuery UI Keycode 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Keycode
//>>group: Core
//>>description: Provide keycodes as keynames
//>>docs: http://api.jqueryui.com/jQuery.ui.keyCode/
var keycode=$.ui.keyCode={BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38};// Internal use only
var escapeSelector=$.ui.escapeSelector=function(){var selectorEscape=/([!"#$%&'()*+,./:;<=>?@[\]^`{|}~])/g;return function(selector){return selector.replace(selectorEscape,"\\$1");};}();/*!
 * jQuery UI Labels 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: labels
//>>group: Core
//>>description: Find all the labels associated with a given input
//>>docs: http://api.jqueryui.com/labels/
var labels=$.fn.labels=function(){var ancestor,selector,id,labels,ancestors;// Check control.labels first
if(this[0].labels&&this[0].labels.length){return this.pushStack(this[0].labels);}// Support: IE <= 11, FF <= 37, Android <= 2.3 only
// Above browsers do not support control.labels. Everything below is to support them
// as well as document fragments. control.labels does not work on document fragments
labels=this.eq(0).parents("label");// Look for the label based on the id
id=this.attr("id");if(id){// We don't search against the document in case the element
// is disconnected from the DOM
ancestor=this.eq(0).parents().last();// Get a full set of top level ancestors
ancestors=ancestor.add(ancestor.length?ancestor.siblings():this.siblings());// Create a selector for the label based on the id
selector="label[for='"+$.ui.escapeSelector(id)+"']";labels=labels.add(ancestors.find(selector).addBack(selector));}// Return whatever we have found for labels
return this.pushStack(labels);};/*!
 * jQuery UI Scroll Parent 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: scrollParent
//>>group: Core
//>>description: Get the closest ancestor element that is scrollable.
//>>docs: http://api.jqueryui.com/scrollParent/
var scrollParent=$.fn.scrollParent=function(includeHidden){var position=this.css("position"),excludeStaticParent=position==="absolute",overflowRegex=includeHidden?/(auto|scroll|hidden)/:/(auto|scroll)/,scrollParent=this.parents().filter(function(){var parent=$(this);if(excludeStaticParent&&parent.css("position")==="static"){return false;}return overflowRegex.test(parent.css("overflow")+parent.css("overflow-y")+parent.css("overflow-x"));}).eq(0);return position==="fixed"||!scrollParent.length?$(this[0].ownerDocument||document):scrollParent;};/*!
 * jQuery UI Tabbable 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: :tabbable Selector
//>>group: Core
//>>description: Selects elements which can be tabbed to.
//>>docs: http://api.jqueryui.com/tabbable-selector/
var tabbable=$.extend($.expr[":"],{tabbable:function tabbable(element){var tabIndex=$.attr(element,"tabindex"),hasTabindex=tabIndex!=null;return(!hasTabindex||tabIndex>=0)&&$.ui.focusable(element,hasTabindex);}});/*!
 * jQuery UI Unique ID 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: uniqueId
//>>group: Core
//>>description: Functions to generate and remove uniqueId's
//>>docs: http://api.jqueryui.com/uniqueId/
var uniqueId=$.fn.extend({uniqueId:function(){var uuid=0;return function(){return this.each(function(){if(!this.id){this.id="ui-id-"+ ++uuid;}});};}(),removeUniqueId:function removeUniqueId(){return this.each(function(){if(/^ui-id-\d+$/.test(this.id)){$(this).removeAttr("id");}});}});/*!
 * jQuery UI Accordion 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Accordion
//>>group: Widgets
// jscs:disable maximumLineLength
//>>description: Displays collapsible content panels for presenting information in a limited amount of space.
// jscs:enable maximumLineLength
//>>docs: http://api.jqueryui.com/accordion/
//>>demos: http://jqueryui.com/accordion/
//>>css.structure: ../../themes/base/core.css
//>>css.structure: ../../themes/base/accordion.css
//>>css.theme: ../../themes/base/theme.css
var widgetsAccordion=$.widget("ui.accordion",{version:"1.12.1",options:{active:0,animate:{},classes:{"ui-accordion-header":"ui-corner-top","ui-accordion-header-collapsed":"ui-corner-all","ui-accordion-content":"ui-corner-bottom"},collapsible:false,event:"click",header:"> li > :first-child, > :not(li):even",heightStyle:"auto",icons:{activeHeader:"ui-icon-triangle-1-s",header:"ui-icon-triangle-1-e"},// Callbacks
activate:null,beforeActivate:null},hideProps:{borderTopWidth:"hide",borderBottomWidth:"hide",paddingTop:"hide",paddingBottom:"hide",height:"hide"},showProps:{borderTopWidth:"show",borderBottomWidth:"show",paddingTop:"show",paddingBottom:"show",height:"show"},_create:function _create(){var options=this.options;this.prevShow=this.prevHide=$();this._addClass("ui-accordion","ui-widget ui-helper-reset");this.element.attr("role","tablist");// Don't allow collapsible: false and active: false / null
if(!options.collapsible&&(options.active===false||options.active==null)){options.active=0;}this._processPanels();// handle negative values
if(options.active<0){options.active+=this.headers.length;}this._refresh();},_getCreateEventData:function _getCreateEventData(){return{header:this.active,panel:!this.active.length?$():this.active.next()};},_createIcons:function _createIcons(){var icon,children,icons=this.options.icons;if(icons){icon=$("<span>");this._addClass(icon,"ui-accordion-header-icon","ui-icon "+icons.header);icon.prependTo(this.headers);children=this.active.children(".ui-accordion-header-icon");this._removeClass(children,icons.header)._addClass(children,null,icons.activeHeader)._addClass(this.headers,"ui-accordion-icons");}},_destroyIcons:function _destroyIcons(){this._removeClass(this.headers,"ui-accordion-icons");this.headers.children(".ui-accordion-header-icon").remove();},_destroy:function _destroy(){var contents;// Clean up main element
this.element.removeAttr("role");// Clean up headers
this.headers.removeAttr("role aria-expanded aria-selected aria-controls tabIndex").removeUniqueId();this._destroyIcons();// Clean up content panels
contents=this.headers.next().css("display","").removeAttr("role aria-hidden aria-labelledby").removeUniqueId();if(this.options.heightStyle!=="content"){contents.css("height","");}},_setOption:function _setOption(key,value){if(key==="active"){// _activate() will handle invalid values and update this.options
this._activate(value);return;}if(key==="event"){if(this.options.event){this._off(this.headers,this.options.event);}this._setupEvents(value);}this._super(key,value);// Setting collapsible: false while collapsed; open first panel
if(key==="collapsible"&&!value&&this.options.active===false){this._activate(0);}if(key==="icons"){this._destroyIcons();if(value){this._createIcons();}}},_setOptionDisabled:function _setOptionDisabled(value){this._super(value);this.element.attr("aria-disabled",value);// Support: IE8 Only
// #5332 / #6059 - opacity doesn't cascade to positioned elements in IE
// so we need to add the disabled class to the headers and panels
this._toggleClass(null,"ui-state-disabled",!!value);this._toggleClass(this.headers.add(this.headers.next()),null,"ui-state-disabled",!!value);},_keydown:function _keydown(event){if(event.altKey||event.ctrlKey){return;}var keyCode=$.ui.keyCode,length=this.headers.length,currentIndex=this.headers.index(event.target),toFocus=false;switch(event.keyCode){case keyCode.RIGHT:case keyCode.DOWN:toFocus=this.headers[(currentIndex+1)%length];break;case keyCode.LEFT:case keyCode.UP:toFocus=this.headers[(currentIndex-1+length)%length];break;case keyCode.SPACE:case keyCode.ENTER:this._eventHandler(event);break;case keyCode.HOME:toFocus=this.headers[0];break;case keyCode.END:toFocus=this.headers[length-1];break;}if(toFocus){$(event.target).attr("tabIndex",-1);$(toFocus).attr("tabIndex",0);$(toFocus).trigger("focus");event.preventDefault();}},_panelKeyDown:function _panelKeyDown(event){if(event.keyCode===$.ui.keyCode.UP&&event.ctrlKey){$(event.currentTarget).prev().trigger("focus");}},refresh:function refresh(){var options=this.options;this._processPanels();// Was collapsed or no panel
if(options.active===false&&options.collapsible===true||!this.headers.length){options.active=false;this.active=$();// active false only when collapsible is true
}else if(options.active===false){this._activate(0);// was active, but active panel is gone
}else if(this.active.length&&!$.contains(this.element[0],this.active[0])){// all remaining panel are disabled
if(this.headers.length===this.headers.find(".ui-state-disabled").length){options.active=false;this.active=$();// activate previous panel
}else{this._activate(Math.max(0,options.active-1));}// was active, active panel still exists
}else{// make sure active index is correct
options.active=this.headers.index(this.active);}this._destroyIcons();this._refresh();},_processPanels:function _processPanels(){var prevHeaders=this.headers,prevPanels=this.panels;this.headers=this.element.find(this.options.header);this._addClass(this.headers,"ui-accordion-header ui-accordion-header-collapsed","ui-state-default");this.panels=this.headers.next().filter(":not(.ui-accordion-content-active)").hide();this._addClass(this.panels,"ui-accordion-content","ui-helper-reset ui-widget-content");// Avoid memory leaks (#10056)
if(prevPanels){this._off(prevHeaders.not(this.headers));this._off(prevPanels.not(this.panels));}},_refresh:function _refresh(){var maxHeight,options=this.options,heightStyle=options.heightStyle,parent=this.element.parent();this.active=this._findActive(options.active);this._addClass(this.active,"ui-accordion-header-active","ui-state-active")._removeClass(this.active,"ui-accordion-header-collapsed");this._addClass(this.active.next(),"ui-accordion-content-active");this.active.next().show();this.headers.attr("role","tab").each(function(){var header=$(this),headerId=header.uniqueId().attr("id"),panel=header.next(),panelId=panel.uniqueId().attr("id");header.attr("aria-controls",panelId);panel.attr("aria-labelledby",headerId);}).next().attr("role","tabpanel");this.headers.not(this.active).attr({"aria-selected":"false","aria-expanded":"false",tabIndex:-1}).next().attr({"aria-hidden":"true"}).hide();// Make sure at least one header is in the tab order
if(!this.active.length){this.headers.eq(0).attr("tabIndex",0);}else{this.active.attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0}).next().attr({"aria-hidden":"false"});}this._createIcons();this._setupEvents(options.event);if(heightStyle==="fill"){maxHeight=parent.height();this.element.siblings(":visible").each(function(){var elem=$(this),position=elem.css("position");if(position==="absolute"||position==="fixed"){return;}maxHeight-=elem.outerHeight(true);});this.headers.each(function(){maxHeight-=$(this).outerHeight(true);});this.headers.next().each(function(){$(this).height(Math.max(0,maxHeight-$(this).innerHeight()+$(this).height()));}).css("overflow","auto");}else if(heightStyle==="auto"){maxHeight=0;this.headers.next().each(function(){var isVisible=$(this).is(":visible");if(!isVisible){$(this).show();}maxHeight=Math.max(maxHeight,$(this).css("height","").height());if(!isVisible){$(this).hide();}}).height(maxHeight);}},_activate:function _activate(index){var active=this._findActive(index)[0];// Trying to activate the already active panel
if(active===this.active[0]){return;}// Trying to collapse, simulate a click on the currently active header
active=active||this.active[0];this._eventHandler({target:active,currentTarget:active,preventDefault:$.noop});},_findActive:function _findActive(selector){return typeof selector==="number"?this.headers.eq(selector):$();},_setupEvents:function _setupEvents(event){var events={keydown:"_keydown"};if(event){$.each(event.split(" "),function(index,eventName){events[eventName]="_eventHandler";});}this._off(this.headers.add(this.headers.next()));this._on(this.headers,events);this._on(this.headers.next(),{keydown:"_panelKeyDown"});this._hoverable(this.headers);this._focusable(this.headers);},_eventHandler:function _eventHandler(event){var activeChildren,clickedChildren,options=this.options,active=this.active,clicked=$(event.currentTarget),clickedIsActive=clicked[0]===active[0],collapsing=clickedIsActive&&options.collapsible,toShow=collapsing?$():clicked.next(),toHide=active.next(),eventData={oldHeader:active,oldPanel:toHide,newHeader:collapsing?$():clicked,newPanel:toShow};event.preventDefault();if(// click on active header, but not collapsible
clickedIsActive&&!options.collapsible||// allow canceling activation
this._trigger("beforeActivate",event,eventData)===false){return;}options.active=collapsing?false:this.headers.index(clicked);// When the call to ._toggle() comes after the class changes
// it causes a very odd bug in IE 8 (see #6720)
this.active=clickedIsActive?$():clicked;this._toggle(eventData);// Switch classes
// corner classes on the previously active header stay after the animation
this._removeClass(active,"ui-accordion-header-active","ui-state-active");if(options.icons){activeChildren=active.children(".ui-accordion-header-icon");this._removeClass(activeChildren,null,options.icons.activeHeader)._addClass(activeChildren,null,options.icons.header);}if(!clickedIsActive){this._removeClass(clicked,"ui-accordion-header-collapsed")._addClass(clicked,"ui-accordion-header-active","ui-state-active");if(options.icons){clickedChildren=clicked.children(".ui-accordion-header-icon");this._removeClass(clickedChildren,null,options.icons.header)._addClass(clickedChildren,null,options.icons.activeHeader);}this._addClass(clicked.next(),"ui-accordion-content-active");}},_toggle:function _toggle(data){var toShow=data.newPanel,toHide=this.prevShow.length?this.prevShow:data.oldPanel;// Handle activating a panel during the animation for another activation
this.prevShow.add(this.prevHide).stop(true,true);this.prevShow=toShow;this.prevHide=toHide;if(this.options.animate){this._animate(toShow,toHide,data);}else{toHide.hide();toShow.show();this._toggleComplete(data);}toHide.attr({"aria-hidden":"true"});toHide.prev().attr({"aria-selected":"false","aria-expanded":"false"});// if we're switching panels, remove the old header from the tab order
// if we're opening from collapsed state, remove the previous header from the tab order
// if we're collapsing, then keep the collapsing header in the tab order
if(toShow.length&&toHide.length){toHide.prev().attr({"tabIndex":-1,"aria-expanded":"false"});}else if(toShow.length){this.headers.filter(function(){return parseInt($(this).attr("tabIndex"),10)===0;}).attr("tabIndex",-1);}toShow.attr("aria-hidden","false").prev().attr({"aria-selected":"true","aria-expanded":"true",tabIndex:0});},_animate:function _animate(toShow,toHide,data){var total,easing,duration,that=this,adjust=0,boxSizing=toShow.css("box-sizing"),down=toShow.length&&(!toHide.length||toShow.index()<toHide.index()),animate=this.options.animate||{},options=down&&animate.down||animate,complete=function complete(){that._toggleComplete(data);};if(typeof options==="number"){duration=options;}if(typeof options==="string"){easing=options;}// fall back from options to animation in case of partial down settings
easing=easing||options.easing||animate.easing;duration=duration||options.duration||animate.duration;if(!toHide.length){return toShow.animate(this.showProps,duration,easing,complete);}if(!toShow.length){return toHide.animate(this.hideProps,duration,easing,complete);}total=toShow.show().outerHeight();toHide.animate(this.hideProps,{duration:duration,easing:easing,step:function step(now,fx){fx.now=Math.round(now);}});toShow.hide().animate(this.showProps,{duration:duration,easing:easing,complete:complete,step:function step(now,fx){fx.now=Math.round(now);if(fx.prop!=="height"){if(boxSizing==="content-box"){adjust+=fx.now;}}else if(that.options.heightStyle!=="content"){fx.now=Math.round(total-toHide.outerHeight()-adjust);adjust=0;}}});},_toggleComplete:function _toggleComplete(data){var toHide=data.oldPanel,prev=toHide.prev();this._removeClass(toHide,"ui-accordion-content-active");this._removeClass(prev,"ui-accordion-header-active")._addClass(prev,"ui-accordion-header-collapsed");// Work around for rendering bug in IE (#5421)
if(toHide.length){toHide.parent()[0].className=toHide.parent()[0].className;}this._trigger("activate",null,data);}});var safeActiveElement=$.ui.safeActiveElement=function(document){var activeElement;// Support: IE 9 only
// IE9 throws an "Unspecified error" accessing document.activeElement from an <iframe>
try{activeElement=document.activeElement;}catch(error){activeElement=document.body;}// Support: IE 9 - 11 only
// IE may return null instead of an element
// Interestingly, this only seems to occur when NOT in an iframe
if(!activeElement){activeElement=document.body;}// Support: IE 11 only
// IE11 returns a seemingly empty object in some cases when accessing
// document.activeElement from an <iframe>
if(!activeElement.nodeName){activeElement=document.body;}return activeElement;};/*!
 * jQuery UI Menu 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Menu
//>>group: Widgets
//>>description: Creates nestable menus.
//>>docs: http://api.jqueryui.com/menu/
//>>demos: http://jqueryui.com/menu/
//>>css.structure: ../../themes/base/core.css
//>>css.structure: ../../themes/base/menu.css
//>>css.theme: ../../themes/base/theme.css
var widgetsMenu=$.widget("ui.menu",{version:"1.12.1",defaultElement:"<ul>",delay:300,options:{icons:{submenu:"ui-icon-caret-1-e"},items:"> *",menus:"ul",position:{my:"left top",at:"right top"},role:"menu",// Callbacks
blur:null,focus:null,select:null},_create:function _create(){this.activeMenu=this.element;// Flag used to prevent firing of the click handler
// as the event bubbles up through nested menus
this.mouseHandled=false;this.element.uniqueId().attr({role:this.options.role,tabIndex:0});this._addClass("ui-menu","ui-widget ui-widget-content");this._on({// Prevent focus from sticking to links inside menu after clicking
// them (focus should always stay on UL during navigation).
"mousedown .ui-menu-item":function mousedownUiMenuItem(event){event.preventDefault();},"click .ui-menu-item":function clickUiMenuItem(event){var target=$(event.target);var active=$($.ui.safeActiveElement(this.document[0]));if(!this.mouseHandled&&target.not(".ui-state-disabled").length){this.select(event);// Only set the mouseHandled flag if the event will bubble, see #9469.
if(!event.isPropagationStopped()){this.mouseHandled=true;}// Open submenu on click
if(target.has(".ui-menu").length){this.expand(event);}else if(!this.element.is(":focus")&&active.closest(".ui-menu").length){// Redirect focus to the menu
this.element.trigger("focus",[true]);// If the active item is on the top level, let it stay active.
// Otherwise, blur the active item since it is no longer visible.
if(this.active&&this.active.parents(".ui-menu").length===1){clearTimeout(this.timer);}}}},"mouseenter .ui-menu-item":function mouseenterUiMenuItem(event){// Ignore mouse events while typeahead is active, see #10458.
// Prevents focusing the wrong item when typeahead causes a scroll while the mouse
// is over an item in the menu
if(this.previousFilter){return;}var actualTarget=$(event.target).closest(".ui-menu-item"),target=$(event.currentTarget);// Ignore bubbled events on parent items, see #11641
if(actualTarget[0]!==target[0]){return;}// Remove ui-state-active class from siblings of the newly focused menu item
// to avoid a jump caused by adjacent elements both having a class with a border
this._removeClass(target.siblings().children(".ui-state-active"),null,"ui-state-active");this.focus(event,target);},mouseleave:"collapseAll","mouseleave .ui-menu":"collapseAll",focus:function focus(event,keepActiveItem){// If there's already an active item, keep it active
// If not, activate the first item
var item=this.active||this.element.find(this.options.items).eq(0);if(!keepActiveItem){this.focus(event,item);}},blur:function blur(event){this._delay(function(){var notContained=!$.contains(this.element[0],$.ui.safeActiveElement(this.document[0]));if(notContained){this.collapseAll(event);}});},keydown:"_keydown"});this.refresh();// Clicks outside of a menu collapse any open menus
this._on(this.document,{click:function click(event){if(this._closeOnDocumentClick(event)){this.collapseAll(event);}// Reset the mouseHandled flag
this.mouseHandled=false;}});},_destroy:function _destroy(){var items=this.element.find(".ui-menu-item").removeAttr("role aria-disabled"),submenus=items.children(".ui-menu-item-wrapper").removeUniqueId().removeAttr("tabIndex role aria-haspopup");// Destroy (sub)menus
this.element.removeAttr("aria-activedescendant").find(".ui-menu").addBack().removeAttr("role aria-labelledby aria-expanded aria-hidden aria-disabled "+"tabIndex").removeUniqueId().show();submenus.children().each(function(){var elem=$(this);if(elem.data("ui-menu-submenu-caret")){elem.remove();}});},_keydown:function _keydown(event){var match,prev,character,skip,preventDefault=true;switch(event.keyCode){case $.ui.keyCode.PAGE_UP:this.previousPage(event);break;case $.ui.keyCode.PAGE_DOWN:this.nextPage(event);break;case $.ui.keyCode.HOME:this._move("first","first",event);break;case $.ui.keyCode.END:this._move("last","last",event);break;case $.ui.keyCode.UP:this.previous(event);break;case $.ui.keyCode.DOWN:this.next(event);break;case $.ui.keyCode.LEFT:this.collapse(event);break;case $.ui.keyCode.RIGHT:if(this.active&&!this.active.is(".ui-state-disabled")){this.expand(event);}break;case $.ui.keyCode.ENTER:case $.ui.keyCode.SPACE:this._activate(event);break;case $.ui.keyCode.ESCAPE:this.collapse(event);break;default:preventDefault=false;prev=this.previousFilter||"";skip=false;// Support number pad values
character=event.keyCode>=96&&event.keyCode<=105?(event.keyCode-96).toString():String.fromCharCode(event.keyCode);clearTimeout(this.filterTimer);if(character===prev){skip=true;}else{character=prev+character;}match=this._filterMenuItems(character);match=skip&&match.index(this.active.next())!==-1?this.active.nextAll(".ui-menu-item"):match;// If no matches on the current filter, reset to the last character pressed
// to move down the menu to the first item that starts with that character
if(!match.length){character=String.fromCharCode(event.keyCode);match=this._filterMenuItems(character);}if(match.length){this.focus(event,match);this.previousFilter=character;this.filterTimer=this._delay(function(){delete this.previousFilter;},1000);}else{delete this.previousFilter;}}if(preventDefault){event.preventDefault();}},_activate:function _activate(event){if(this.active&&!this.active.is(".ui-state-disabled")){if(this.active.children("[aria-haspopup='true']").length){this.expand(event);}else{this.select(event);}}},refresh:function refresh(){var menus,items,newSubmenus,newItems,newWrappers,that=this,icon=this.options.icons.submenu,submenus=this.element.find(this.options.menus);this._toggleClass("ui-menu-icons",null,!!this.element.find(".ui-icon").length);// Initialize nested menus
newSubmenus=submenus.filter(":not(.ui-menu)").hide().attr({role:this.options.role,"aria-hidden":"true","aria-expanded":"false"}).each(function(){var menu=$(this),item=menu.prev(),submenuCaret=$("<span>").data("ui-menu-submenu-caret",true);that._addClass(submenuCaret,"ui-menu-icon","ui-icon "+icon);item.attr("aria-haspopup","true").prepend(submenuCaret);menu.attr("aria-labelledby",item.attr("id"));});this._addClass(newSubmenus,"ui-menu","ui-widget ui-widget-content ui-front");menus=submenus.add(this.element);items=menus.find(this.options.items);// Initialize menu-items containing spaces and/or dashes only as dividers
items.not(".ui-menu-item").each(function(){var item=$(this);if(that._isDivider(item)){that._addClass(item,"ui-menu-divider","ui-widget-content");}});// Don't refresh list items that are already adapted
newItems=items.not(".ui-menu-item, .ui-menu-divider");newWrappers=newItems.children().not(".ui-menu").uniqueId().attr({tabIndex:-1,role:this._itemRole()});this._addClass(newItems,"ui-menu-item")._addClass(newWrappers,"ui-menu-item-wrapper");// Add aria-disabled attribute to any disabled menu item
items.filter(".ui-state-disabled").attr("aria-disabled","true");// If the active item has been removed, blur the menu
if(this.active&&!$.contains(this.element[0],this.active[0])){this.blur();}},_itemRole:function _itemRole(){return{menu:"menuitem",listbox:"option"}[this.options.role];},_setOption:function _setOption(key,value){if(key==="icons"){var icons=this.element.find(".ui-menu-icon");this._removeClass(icons,null,this.options.icons.submenu)._addClass(icons,null,value.submenu);}this._super(key,value);},_setOptionDisabled:function _setOptionDisabled(value){this._super(value);this.element.attr("aria-disabled",String(value));this._toggleClass(null,"ui-state-disabled",!!value);},focus:function focus(event,item){var nested,focused,activeParent;this.blur(event,event&&event.type==="focus");this._scrollIntoView(item);this.active=item.first();focused=this.active.children(".ui-menu-item-wrapper");this._addClass(focused,null,"ui-state-active");// Only update aria-activedescendant if there's a role
// otherwise we assume focus is managed elsewhere
if(this.options.role){this.element.attr("aria-activedescendant",focused.attr("id"));}// Highlight active parent menu item, if any
activeParent=this.active.parent().closest(".ui-menu-item").children(".ui-menu-item-wrapper");this._addClass(activeParent,null,"ui-state-active");if(event&&event.type==="keydown"){this._close();}else{this.timer=this._delay(function(){this._close();},this.delay);}nested=item.children(".ui-menu");if(nested.length&&event&&/^mouse/.test(event.type)){this._startOpening(nested);}this.activeMenu=item.parent();this._trigger("focus",event,{item:item});},_scrollIntoView:function _scrollIntoView(item){var borderTop,paddingTop,offset,scroll,elementHeight,itemHeight;if(this._hasScroll()){borderTop=parseFloat($.css(this.activeMenu[0],"borderTopWidth"))||0;paddingTop=parseFloat($.css(this.activeMenu[0],"paddingTop"))||0;offset=item.offset().top-this.activeMenu.offset().top-borderTop-paddingTop;scroll=this.activeMenu.scrollTop();elementHeight=this.activeMenu.height();itemHeight=item.outerHeight();if(offset<0){this.activeMenu.scrollTop(scroll+offset);}else if(offset+itemHeight>elementHeight){this.activeMenu.scrollTop(scroll+offset-elementHeight+itemHeight);}}},blur:function blur(event,fromFocus){if(!fromFocus){clearTimeout(this.timer);}if(!this.active){return;}this._removeClass(this.active.children(".ui-menu-item-wrapper"),null,"ui-state-active");this._trigger("blur",event,{item:this.active});this.active=null;},_startOpening:function _startOpening(submenu){clearTimeout(this.timer);// Don't open if already open fixes a Firefox bug that caused a .5 pixel
// shift in the submenu position when mousing over the caret icon
if(submenu.attr("aria-hidden")!=="true"){return;}this.timer=this._delay(function(){this._close();this._open(submenu);},this.delay);},_open:function _open(submenu){var position=$.extend({of:this.active},this.options.position);clearTimeout(this.timer);this.element.find(".ui-menu").not(submenu.parents(".ui-menu")).hide().attr("aria-hidden","true");submenu.show().removeAttr("aria-hidden").attr("aria-expanded","true").position(position);},collapseAll:function collapseAll(event,all){clearTimeout(this.timer);this.timer=this._delay(function(){// If we were passed an event, look for the submenu that contains the event
var currentMenu=all?this.element:$(event&&event.target).closest(this.element.find(".ui-menu"));// If we found no valid submenu ancestor, use the main menu to close all
// sub menus anyway
if(!currentMenu.length){currentMenu=this.element;}this._close(currentMenu);this.blur(event);// Work around active item staying active after menu is blurred
this._removeClass(currentMenu.find(".ui-state-active"),null,"ui-state-active");this.activeMenu=currentMenu;},this.delay);},// With no arguments, closes the currently active menu - if nothing is active
// it closes all menus.  If passed an argument, it will search for menus BELOW
_close:function _close(startMenu){if(!startMenu){startMenu=this.active?this.active.parent():this.element;}startMenu.find(".ui-menu").hide().attr("aria-hidden","true").attr("aria-expanded","false");},_closeOnDocumentClick:function _closeOnDocumentClick(event){return!$(event.target).closest(".ui-menu").length;},_isDivider:function _isDivider(item){// Match hyphen, em dash, en dash
return!/[^\-\u2014\u2013\s]/.test(item.text());},collapse:function collapse(event){var newItem=this.active&&this.active.parent().closest(".ui-menu-item",this.element);if(newItem&&newItem.length){this._close();this.focus(event,newItem);}},expand:function expand(event){var newItem=this.active&&this.active.children(".ui-menu ").find(this.options.items).first();if(newItem&&newItem.length){this._open(newItem.parent());// Delay so Firefox will not hide activedescendant change in expanding submenu from AT
this._delay(function(){this.focus(event,newItem);});}},next:function next(event){this._move("next","first",event);},previous:function previous(event){this._move("prev","last",event);},isFirstItem:function isFirstItem(){return this.active&&!this.active.prevAll(".ui-menu-item").length;},isLastItem:function isLastItem(){return this.active&&!this.active.nextAll(".ui-menu-item").length;},_move:function _move(direction,filter,event){var next;if(this.active){if(direction==="first"||direction==="last"){next=this.active[direction==="first"?"prevAll":"nextAll"](".ui-menu-item").eq(-1);}else{next=this.active[direction+"All"](".ui-menu-item").eq(0);}}if(!next||!next.length||!this.active){next=this.activeMenu.find(this.options.items)[filter]();}this.focus(event,next);},nextPage:function nextPage(event){var item,base,height;if(!this.active){this.next(event);return;}if(this.isLastItem()){return;}if(this._hasScroll()){base=this.active.offset().top;height=this.element.height();this.active.nextAll(".ui-menu-item").each(function(){item=$(this);return item.offset().top-base-height<0;});this.focus(event,item);}else{this.focus(event,this.activeMenu.find(this.options.items)[!this.active?"first":"last"]());}},previousPage:function previousPage(event){var item,base,height;if(!this.active){this.next(event);return;}if(this.isFirstItem()){return;}if(this._hasScroll()){base=this.active.offset().top;height=this.element.height();this.active.prevAll(".ui-menu-item").each(function(){item=$(this);return item.offset().top-base+height>0;});this.focus(event,item);}else{this.focus(event,this.activeMenu.find(this.options.items).first());}},_hasScroll:function _hasScroll(){return this.element.outerHeight()<this.element.prop("scrollHeight");},select:function select(event){// TODO: It should never be possible to not have an active item at this
// point, but the tests don't trigger mouseenter before click.
this.active=this.active||$(event.target).closest(".ui-menu-item");var ui={item:this.active};if(!this.active.has(".ui-menu").length){this.collapseAll(event,true);}this._trigger("select",event,ui);},_filterMenuItems:function _filterMenuItems(character){var escapedCharacter=character.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&"),regex=new RegExp("^"+escapedCharacter,"i");return this.activeMenu.find(this.options.items)// Only match on items, not dividers or other content (#10571)
.filter(".ui-menu-item").filter(function(){return regex.test($.trim($(this).children(".ui-menu-item-wrapper").text()));});}});/*!
 * jQuery UI Autocomplete 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Autocomplete
//>>group: Widgets
//>>description: Lists suggested words as the user is typing.
//>>docs: http://api.jqueryui.com/autocomplete/
//>>demos: http://jqueryui.com/autocomplete/
//>>css.structure: ../../themes/base/core.css
//>>css.structure: ../../themes/base/autocomplete.css
//>>css.theme: ../../themes/base/theme.css
$.widget("ui.autocomplete",{version:"1.12.1",defaultElement:"<input>",options:{appendTo:null,autoFocus:false,delay:300,minLength:1,position:{my:"left top",at:"left bottom",collision:"none"},source:null,// Callbacks
change:null,close:null,focus:null,open:null,response:null,search:null,select:null},requestIndex:0,pending:0,_create:function _create(){// Some browsers only repeat keydown events, not keypress events,
// so we use the suppressKeyPress flag to determine if we've already
// handled the keydown event. #7269
// Unfortunately the code for & in keypress is the same as the up arrow,
// so we use the suppressKeyPressRepeat flag to avoid handling keypress
// events when we know the keydown event was used to modify the
// search term. #7799
var suppressKeyPress,suppressKeyPressRepeat,suppressInput,nodeName=this.element[0].nodeName.toLowerCase(),isTextarea=nodeName==="textarea",isInput=nodeName==="input";// Textareas are always multi-line
// Inputs are always single-line, even if inside a contentEditable element
// IE also treats inputs as contentEditable
// All other element types are determined by whether or not they're contentEditable
this.isMultiLine=isTextarea||!isInput&&this._isContentEditable(this.element);this.valueMethod=this.element[isTextarea||isInput?"val":"text"];this.isNewMenu=true;this._addClass("ui-autocomplete-input");this.element.attr("autocomplete","off");this._on(this.element,{keydown:function keydown(event){if(this.element.prop("readOnly")){suppressKeyPress=true;suppressInput=true;suppressKeyPressRepeat=true;return;}suppressKeyPress=false;suppressInput=false;suppressKeyPressRepeat=false;var keyCode=$.ui.keyCode;switch(event.keyCode){case keyCode.PAGE_UP:suppressKeyPress=true;this._move("previousPage",event);break;case keyCode.PAGE_DOWN:suppressKeyPress=true;this._move("nextPage",event);break;case keyCode.UP:suppressKeyPress=true;this._keyEvent("previous",event);break;case keyCode.DOWN:suppressKeyPress=true;this._keyEvent("next",event);break;case keyCode.ENTER:// when menu is open and has focus
if(this.menu.active){// #6055 - Opera still allows the keypress to occur
// which causes forms to submit
suppressKeyPress=true;event.preventDefault();this.menu.select(event);}break;case keyCode.TAB:if(this.menu.active){this.menu.select(event);}break;case keyCode.ESCAPE:if(this.menu.element.is(":visible")){if(!this.isMultiLine){this._value(this.term);}this.close(event);// Different browsers have different default behavior for escape
// Single press can mean undo or clear
// Double press in IE means clear the whole form
event.preventDefault();}break;default:suppressKeyPressRepeat=true;// search timeout should be triggered before the input value is changed
this._searchTimeout(event);break;}},keypress:function keypress(event){if(suppressKeyPress){suppressKeyPress=false;if(!this.isMultiLine||this.menu.element.is(":visible")){event.preventDefault();}return;}if(suppressKeyPressRepeat){return;}// Replicate some key handlers to allow them to repeat in Firefox and Opera
var keyCode=$.ui.keyCode;switch(event.keyCode){case keyCode.PAGE_UP:this._move("previousPage",event);break;case keyCode.PAGE_DOWN:this._move("nextPage",event);break;case keyCode.UP:this._keyEvent("previous",event);break;case keyCode.DOWN:this._keyEvent("next",event);break;}},input:function input(event){if(suppressInput){suppressInput=false;event.preventDefault();return;}this._searchTimeout(event);},focus:function focus(){this.selectedItem=null;this.previous=this._value();},blur:function blur(event){if(this.cancelBlur){delete this.cancelBlur;return;}clearTimeout(this.searching);this.close(event);this._change(event);}});this._initSource();this.menu=$("<ul>").appendTo(this._appendTo()).menu({// disable ARIA support, the live region takes care of that
role:null}).hide().menu("instance");this._addClass(this.menu.element,"ui-autocomplete","ui-front");this._on(this.menu.element,{mousedown:function mousedown(event){// prevent moving focus out of the text field
event.preventDefault();// IE doesn't prevent moving focus even with event.preventDefault()
// so we set a flag to know when we should ignore the blur event
this.cancelBlur=true;this._delay(function(){delete this.cancelBlur;// Support: IE 8 only
// Right clicking a menu item or selecting text from the menu items will
// result in focus moving out of the input. However, we've already received
// and ignored the blur event because of the cancelBlur flag set above. So
// we restore focus to ensure that the menu closes properly based on the user's
// next actions.
if(this.element[0]!==$.ui.safeActiveElement(this.document[0])){this.element.trigger("focus");}});},menufocus:function menufocus(event,ui){var label,item;// support: Firefox
// Prevent accidental activation of menu items in Firefox (#7024 #9118)
if(this.isNewMenu){this.isNewMenu=false;if(event.originalEvent&&/^mouse/.test(event.originalEvent.type)){this.menu.blur();this.document.one("mousemove",function(){$(event.target).trigger(event.originalEvent);});return;}}item=ui.item.data("ui-autocomplete-item");if(false!==this._trigger("focus",event,{item:item})){// use value to match what will end up in the input, if it was a key event
if(event.originalEvent&&/^key/.test(event.originalEvent.type)){this._value(item.value);}}// Announce the value in the liveRegion
label=ui.item.attr("aria-label")||item.value;if(label&&$.trim(label).length){this.liveRegion.children().hide();$("<div>").text(label).appendTo(this.liveRegion);}},menuselect:function menuselect(event,ui){var item=ui.item.data("ui-autocomplete-item"),previous=this.previous;// Only trigger when focus was lost (click on menu)
if(this.element[0]!==$.ui.safeActiveElement(this.document[0])){this.element.trigger("focus");this.previous=previous;// #6109 - IE triggers two focus events and the second
// is asynchronous, so we need to reset the previous
// term synchronously and asynchronously :-(
this._delay(function(){this.previous=previous;this.selectedItem=item;});}if(false!==this._trigger("select",event,{item:item})){this._value(item.value);}// reset the term after the select event
// this allows custom select handling to work properly
this.term=this._value();this.close(event);this.selectedItem=item;}});this.liveRegion=$("<div>",{role:"status","aria-live":"assertive","aria-relevant":"additions"}).appendTo(this.document[0].body);this._addClass(this.liveRegion,null,"ui-helper-hidden-accessible");// Turning off autocomplete prevents the browser from remembering the
// value when navigating through history, so we re-enable autocomplete
// if the page is unloaded before the widget is destroyed. #7790
this._on(this.window,{beforeunload:function beforeunload(){this.element.removeAttr("autocomplete");}});},_destroy:function _destroy(){clearTimeout(this.searching);this.element.removeAttr("autocomplete");this.menu.element.remove();this.liveRegion.remove();},_setOption:function _setOption(key,value){this._super(key,value);if(key==="source"){this._initSource();}if(key==="appendTo"){this.menu.element.appendTo(this._appendTo());}if(key==="disabled"&&value&&this.xhr){this.xhr.abort();}},_isEventTargetInWidget:function _isEventTargetInWidget(event){var menuElement=this.menu.element[0];return event.target===this.element[0]||event.target===menuElement||$.contains(menuElement,event.target);},_closeOnClickOutside:function _closeOnClickOutside(event){if(!this._isEventTargetInWidget(event)){this.close();}},_appendTo:function _appendTo(){var element=this.options.appendTo;if(element){element=element.jquery||element.nodeType?$(element):this.document.find(element).eq(0);}if(!element||!element[0]){element=this.element.closest(".ui-front, dialog");}if(!element.length){element=this.document[0].body;}return element;},_initSource:function _initSource(){var array,url,that=this;if($.isArray(this.options.source)){array=this.options.source;this.source=function(request,response){response($.ui.autocomplete.filter(array,request.term));};}else if(typeof this.options.source==="string"){url=this.options.source;this.source=function(request,response){if(that.xhr){that.xhr.abort();}that.xhr=$.ajax({url:url,data:request,dataType:"json",success:function success(data){response(data);},error:function error(){response([]);}});};}else{this.source=this.options.source;}},_searchTimeout:function _searchTimeout(event){clearTimeout(this.searching);this.searching=this._delay(function(){// Search if the value has changed, or if the user retypes the same value (see #7434)
var equalValues=this.term===this._value(),menuVisible=this.menu.element.is(":visible"),modifierKey=event.altKey||event.ctrlKey||event.metaKey||event.shiftKey;if(!equalValues||equalValues&&!menuVisible&&!modifierKey){this.selectedItem=null;this.search(null,event);}},this.options.delay);},search:function search(value,event){value=value!=null?value:this._value();// Always save the actual value, not the one passed as an argument
this.term=this._value();if(value.length<this.options.minLength){return this.close(event);}if(this._trigger("search",event)===false){return;}return this._search(value);},_search:function _search(value){this.pending++;this._addClass("ui-autocomplete-loading");this.cancelSearch=false;this.source({term:value},this._response());},_response:function _response(){var index=++this.requestIndex;return $.proxy(function(content){if(index===this.requestIndex){this.__response(content);}this.pending--;if(!this.pending){this._removeClass("ui-autocomplete-loading");}},this);},__response:function __response(content){if(content){content=this._normalize(content);}this._trigger("response",null,{content:content});if(!this.options.disabled&&content&&content.length&&!this.cancelSearch){this._suggest(content);this._trigger("open");}else{// use ._close() instead of .close() so we don't cancel future searches
this._close();}},close:function close(event){this.cancelSearch=true;this._close(event);},_close:function _close(event){// Remove the handler that closes the menu on outside clicks
this._off(this.document,"mousedown");if(this.menu.element.is(":visible")){this.menu.element.hide();this.menu.blur();this.isNewMenu=true;this._trigger("close",event);}},_change:function _change(event){if(this.previous!==this._value()){this._trigger("change",event,{item:this.selectedItem});}},_normalize:function _normalize(items){// assume all items have the right format when the first item is complete
if(items.length&&items[0].label&&items[0].value){return items;}return $.map(items,function(item){if(typeof item==="string"){return{label:item,value:item};}return $.extend({},item,{label:item.label||item.value,value:item.value||item.label});});},_suggest:function _suggest(items){var ul=this.menu.element.empty();this._renderMenu(ul,items);this.isNewMenu=true;this.menu.refresh();// Size and position menu
ul.show();this._resizeMenu();ul.position($.extend({of:this.element},this.options.position));if(this.options.autoFocus){this.menu.next();}// Listen for interactions outside of the widget (#6642)
this._on(this.document,{mousedown:"_closeOnClickOutside"});},_resizeMenu:function _resizeMenu(){var ul=this.menu.element;ul.outerWidth(Math.max(// Firefox wraps long text (possibly a rounding bug)
// so we add 1px to avoid the wrapping (#7513)
ul.width("").outerWidth()+1,this.element.outerWidth()));},_renderMenu:function _renderMenu(ul,items){var that=this;$.each(items,function(index,item){that._renderItemData(ul,item);});},_renderItemData:function _renderItemData(ul,item){return this._renderItem(ul,item).data("ui-autocomplete-item",item);},_renderItem:function _renderItem(ul,item){return $("<li>").append($("<div>").text(item.label)).appendTo(ul);},_move:function _move(direction,event){if(!this.menu.element.is(":visible")){this.search(null,event);return;}if(this.menu.isFirstItem()&&/^previous/.test(direction)||this.menu.isLastItem()&&/^next/.test(direction)){if(!this.isMultiLine){this._value(this.term);}this.menu.blur();return;}this.menu[direction](event);},widget:function widget(){return this.menu.element;},_value:function _value(){return this.valueMethod.apply(this.element,arguments);},_keyEvent:function _keyEvent(keyEvent,event){if(!this.isMultiLine||this.menu.element.is(":visible")){this._move(keyEvent,event);// Prevents moving cursor to beginning/end of the text field in some browsers
event.preventDefault();}},// Support: Chrome <=50
// We should be able to just use this.element.prop( "isContentEditable" )
// but hidden elements always report false in Chrome.
// https://code.google.com/p/chromium/issues/detail?id=313082
_isContentEditable:function _isContentEditable(element){if(!element.length){return false;}var editable=element.prop("contentEditable");if(editable==="inherit"){return this._isContentEditable(element.parent());}return editable==="true";}});$.extend($.ui.autocomplete,{escapeRegex:function escapeRegex(value){return value.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&");},filter:function filter(array,term){var matcher=new RegExp($.ui.autocomplete.escapeRegex(term),"i");return $.grep(array,function(value){return matcher.test(value.label||value.value||value);});}});// Live region extension, adding a `messages` option
// NOTE: This is an experimental API. We are still investigating
// a full solution for string manipulation and internationalization.
$.widget("ui.autocomplete",$.ui.autocomplete,{options:{messages:{noResults:"No search results.",results:function results(amount){return amount+(amount>1?" results are":" result is")+" available, use up and down arrow keys to navigate.";}}},__response:function __response(content){var message;this._superApply(arguments);if(this.options.disabled||this.cancelSearch){return;}if(content&&content.length){message=this.options.messages.results(content.length);}else{message=this.options.messages.noResults;}this.liveRegion.children().hide();$("<div>").text(message).appendTo(this.liveRegion);}});var widgetsAutocomplete=$.ui.autocomplete;/*!
 * jQuery UI Controlgroup 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Controlgroup
//>>group: Widgets
//>>description: Visually groups form control widgets
//>>docs: http://api.jqueryui.com/controlgroup/
//>>demos: http://jqueryui.com/controlgroup/
//>>css.structure: ../../themes/base/core.css
//>>css.structure: ../../themes/base/controlgroup.css
//>>css.theme: ../../themes/base/theme.css
var controlgroupCornerRegex=/ui-corner-([a-z]){2,6}/g;var widgetsControlgroup=$.widget("ui.controlgroup",{version:"1.12.1",defaultElement:"<div>",options:{direction:"horizontal",disabled:null,onlyVisible:true,items:{"button":"input[type=button], input[type=submit], input[type=reset], button, a","controlgroupLabel":".ui-controlgroup-label","checkboxradio":"input[type='checkbox'], input[type='radio']","selectmenu":"select","spinner":".ui-spinner-input"}},_create:function _create(){this._enhance();},// To support the enhanced option in jQuery Mobile, we isolate DOM manipulation
_enhance:function _enhance(){this.element.attr("role","toolbar");this.refresh();},_destroy:function _destroy(){this._callChildMethod("destroy");this.childWidgets.removeData("ui-controlgroup-data");this.element.removeAttr("role");if(this.options.items.controlgroupLabel){this.element.find(this.options.items.controlgroupLabel).find(".ui-controlgroup-label-contents").contents().unwrap();}},_initWidgets:function _initWidgets(){var that=this,childWidgets=[];// First we iterate over each of the items options
$.each(this.options.items,function(widget,selector){var labels;var options={};// Make sure the widget has a selector set
if(!selector){return;}if(widget==="controlgroupLabel"){labels=that.element.find(selector);labels.each(function(){var element=$(this);if(element.children(".ui-controlgroup-label-contents").length){return;}element.contents().wrapAll("<span class='ui-controlgroup-label-contents'></span>");});that._addClass(labels,null,"ui-widget ui-widget-content ui-state-default");childWidgets=childWidgets.concat(labels.get());return;}// Make sure the widget actually exists
if(!$.fn[widget]){return;}// We assume everything is in the middle to start because we can't determine
// first / last elements until all enhancments are done.
if(that["_"+widget+"Options"]){options=that["_"+widget+"Options"]("middle");}else{options={classes:{}};}// Find instances of this widget inside controlgroup and init them
that.element.find(selector).each(function(){var element=$(this);var instance=element[widget]("instance");// We need to clone the default options for this type of widget to avoid
// polluting the variable options which has a wider scope than a single widget.
var instanceOptions=$.widget.extend({},options);// If the button is the child of a spinner ignore it
// TODO: Find a more generic solution
if(widget==="button"&&element.parent(".ui-spinner").length){return;}// Create the widget if it doesn't exist
if(!instance){instance=element[widget]()[widget]("instance");}if(instance){instanceOptions.classes=that._resolveClassesValues(instanceOptions.classes,instance);}element[widget](instanceOptions);// Store an instance of the controlgroup to be able to reference
// from the outermost element for changing options and refresh
var widgetElement=element[widget]("widget");$.data(widgetElement[0],"ui-controlgroup-data",instance?instance:element[widget]("instance"));childWidgets.push(widgetElement[0]);});});this.childWidgets=$($.unique(childWidgets));this._addClass(this.childWidgets,"ui-controlgroup-item");},_callChildMethod:function _callChildMethod(method){this.childWidgets.each(function(){var element=$(this),data=element.data("ui-controlgroup-data");if(data&&data[method]){data[method]();}});},_updateCornerClass:function _updateCornerClass(element,position){var remove="ui-corner-top ui-corner-bottom ui-corner-left ui-corner-right ui-corner-all";var add=this._buildSimpleOptions(position,"label").classes.label;this._removeClass(element,null,remove);this._addClass(element,null,add);},_buildSimpleOptions:function _buildSimpleOptions(position,key){var direction=this.options.direction==="vertical";var result={classes:{}};result.classes[key]={"middle":"","first":"ui-corner-"+(direction?"top":"left"),"last":"ui-corner-"+(direction?"bottom":"right"),"only":"ui-corner-all"}[position];return result;},_spinnerOptions:function _spinnerOptions(position){var options=this._buildSimpleOptions(position,"ui-spinner");options.classes["ui-spinner-up"]="";options.classes["ui-spinner-down"]="";return options;},_buttonOptions:function _buttonOptions(position){return this._buildSimpleOptions(position,"ui-button");},_checkboxradioOptions:function _checkboxradioOptions(position){return this._buildSimpleOptions(position,"ui-checkboxradio-label");},_selectmenuOptions:function _selectmenuOptions(position){var direction=this.options.direction==="vertical";return{width:direction?"auto":false,classes:{middle:{"ui-selectmenu-button-open":"","ui-selectmenu-button-closed":""},first:{"ui-selectmenu-button-open":"ui-corner-"+(direction?"top":"tl"),"ui-selectmenu-button-closed":"ui-corner-"+(direction?"top":"left")},last:{"ui-selectmenu-button-open":direction?"":"ui-corner-tr","ui-selectmenu-button-closed":"ui-corner-"+(direction?"bottom":"right")},only:{"ui-selectmenu-button-open":"ui-corner-top","ui-selectmenu-button-closed":"ui-corner-all"}}[position]};},_resolveClassesValues:function _resolveClassesValues(classes,instance){var result={};$.each(classes,function(key){var current=instance.options.classes[key]||"";current=$.trim(current.replace(controlgroupCornerRegex,""));result[key]=(current+" "+classes[key]).replace(/\s+/g," ");});return result;},_setOption:function _setOption(key,value){if(key==="direction"){this._removeClass("ui-controlgroup-"+this.options.direction);}this._super(key,value);if(key==="disabled"){this._callChildMethod(value?"disable":"enable");return;}this.refresh();},refresh:function refresh(){var children,that=this;this._addClass("ui-controlgroup ui-controlgroup-"+this.options.direction);if(this.options.direction==="horizontal"){this._addClass(null,"ui-helper-clearfix");}this._initWidgets();children=this.childWidgets;// We filter here because we need to track all childWidgets not just the visible ones
if(this.options.onlyVisible){children=children.filter(":visible");}if(children.length){// We do this last because we need to make sure all enhancment is done
// before determining first and last
$.each(["first","last"],function(index,value){var instance=children[value]().data("ui-controlgroup-data");if(instance&&that["_"+instance.widgetName+"Options"]){var options=that["_"+instance.widgetName+"Options"](children.length===1?"only":value);options.classes=that._resolveClassesValues(options.classes,instance);instance.element[instance.widgetName](options);}else{that._updateCornerClass(children[value](),value);}});// Finally call the refresh method on each of the child widgets.
this._callChildMethod("refresh");}}});/*!
 * jQuery UI Checkboxradio 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Checkboxradio
//>>group: Widgets
//>>description: Enhances a form with multiple themeable checkboxes or radio buttons.
//>>docs: http://api.jqueryui.com/checkboxradio/
//>>demos: http://jqueryui.com/checkboxradio/
//>>css.structure: ../../themes/base/core.css
//>>css.structure: ../../themes/base/button.css
//>>css.structure: ../../themes/base/checkboxradio.css
//>>css.theme: ../../themes/base/theme.css
$.widget("ui.checkboxradio",[$.ui.formResetMixin,{version:"1.12.1",options:{disabled:null,label:null,icon:true,classes:{"ui-checkboxradio-label":"ui-corner-all","ui-checkboxradio-icon":"ui-corner-all"}},_getCreateOptions:function _getCreateOptions(){var disabled,labels;var that=this;var options=this._super()||{};// We read the type here, because it makes more sense to throw a element type error first,
// rather then the error for lack of a label. Often if its the wrong type, it
// won't have a label (e.g. calling on a div, btn, etc)
this._readType();labels=this.element.labels();// If there are multiple labels, use the last one
this.label=$(labels[labels.length-1]);if(!this.label.length){$.error("No label found for checkboxradio widget");}this.originalLabel="";// We need to get the label text but this may also need to make sure it does not contain the
// input itself.
this.label.contents().not(this.element[0]).each(function(){// The label contents could be text, html, or a mix. We concat each element to get a
// string representation of the label, without the input as part of it.
that.originalLabel+=this.nodeType===3?$(this).text():this.outerHTML;});// Set the label option if we found label text
if(this.originalLabel){options.label=this.originalLabel;}disabled=this.element[0].disabled;if(disabled!=null){options.disabled=disabled;}return options;},_create:function _create(){var checked=this.element[0].checked;this._bindFormResetHandler();if(this.options.disabled==null){this.options.disabled=this.element[0].disabled;}this._setOption("disabled",this.options.disabled);this._addClass("ui-checkboxradio","ui-helper-hidden-accessible");this._addClass(this.label,"ui-checkboxradio-label","ui-button ui-widget");if(this.type==="radio"){this._addClass(this.label,"ui-checkboxradio-radio-label");}if(this.options.label&&this.options.label!==this.originalLabel){this._updateLabel();}else if(this.originalLabel){this.options.label=this.originalLabel;}this._enhance();if(checked){this._addClass(this.label,"ui-checkboxradio-checked","ui-state-active");if(this.icon){this._addClass(this.icon,null,"ui-state-hover");}}this._on({change:"_toggleClasses",focus:function focus(){this._addClass(this.label,null,"ui-state-focus ui-visual-focus");},blur:function blur(){this._removeClass(this.label,null,"ui-state-focus ui-visual-focus");}});},_readType:function _readType(){var nodeName=this.element[0].nodeName.toLowerCase();this.type=this.element[0].type;if(nodeName!=="input"||!/radio|checkbox/.test(this.type)){$.error("Can't create checkboxradio on element.nodeName="+nodeName+" and element.type="+this.type);}},// Support jQuery Mobile enhanced option
_enhance:function _enhance(){this._updateIcon(this.element[0].checked);},widget:function widget(){return this.label;},_getRadioGroup:function _getRadioGroup(){var group;var name=this.element[0].name;var nameSelector="input[name='"+$.ui.escapeSelector(name)+"']";if(!name){return $([]);}if(this.form.length){group=$(this.form[0].elements).filter(nameSelector);}else{// Not inside a form, check all inputs that also are not inside a form
group=$(nameSelector).filter(function(){return $(this).form().length===0;});}return group.not(this.element);},_toggleClasses:function _toggleClasses(){var checked=this.element[0].checked;this._toggleClass(this.label,"ui-checkboxradio-checked","ui-state-active",checked);if(this.options.icon&&this.type==="checkbox"){this._toggleClass(this.icon,null,"ui-icon-check ui-state-checked",checked)._toggleClass(this.icon,null,"ui-icon-blank",!checked);}if(this.type==="radio"){this._getRadioGroup().each(function(){var instance=$(this).checkboxradio("instance");if(instance){instance._removeClass(instance.label,"ui-checkboxradio-checked","ui-state-active");}});}},_destroy:function _destroy(){this._unbindFormResetHandler();if(this.icon){this.icon.remove();this.iconSpace.remove();}},_setOption:function _setOption(key,value){// We don't allow the value to be set to nothing
if(key==="label"&&!value){return;}this._super(key,value);if(key==="disabled"){this._toggleClass(this.label,null,"ui-state-disabled",value);this.element[0].disabled=value;// Don't refresh when setting disabled
return;}this.refresh();},_updateIcon:function _updateIcon(checked){var toAdd="ui-icon ui-icon-background ";if(this.options.icon){if(!this.icon){this.icon=$("<span>");this.iconSpace=$("<span> </span>");this._addClass(this.iconSpace,"ui-checkboxradio-icon-space");}if(this.type==="checkbox"){toAdd+=checked?"ui-icon-check ui-state-checked":"ui-icon-blank";this._removeClass(this.icon,null,checked?"ui-icon-blank":"ui-icon-check");}else{toAdd+="ui-icon-blank";}this._addClass(this.icon,"ui-checkboxradio-icon",toAdd);if(!checked){this._removeClass(this.icon,null,"ui-icon-check ui-state-checked");}this.icon.prependTo(this.label).after(this.iconSpace);}else if(this.icon!==undefined){this.icon.remove();this.iconSpace.remove();delete this.icon;}},_updateLabel:function _updateLabel(){// Remove the contents of the label ( minus the icon, icon space, and input )
var contents=this.label.contents().not(this.element[0]);if(this.icon){contents=contents.not(this.icon[0]);}if(this.iconSpace){contents=contents.not(this.iconSpace[0]);}contents.remove();this.label.append(this.options.label);},refresh:function refresh(){var checked=this.element[0].checked,isDisabled=this.element[0].disabled;this._updateIcon(checked);this._toggleClass(this.label,"ui-checkboxradio-checked","ui-state-active",checked);if(this.options.label!==null){this._updateLabel();}if(isDisabled!==this.options.disabled){this._setOptions({"disabled":isDisabled});}}}]);var widgetsCheckboxradio=$.ui.checkboxradio;/*!
 * jQuery UI Button 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Button
//>>group: Widgets
//>>description: Enhances a form with themeable buttons.
//>>docs: http://api.jqueryui.com/button/
//>>demos: http://jqueryui.com/button/
//>>css.structure: ../../themes/base/core.css
//>>css.structure: ../../themes/base/button.css
//>>css.theme: ../../themes/base/theme.css
$.widget("ui.button",{version:"1.12.1",defaultElement:"<button>",options:{classes:{"ui-button":"ui-corner-all"},disabled:null,icon:null,iconPosition:"beginning",label:null,showLabel:true},_getCreateOptions:function _getCreateOptions(){var disabled,// This is to support cases like in jQuery Mobile where the base widget does have
// an implementation of _getCreateOptions
options=this._super()||{};this.isInput=this.element.is("input");disabled=this.element[0].disabled;if(disabled!=null){options.disabled=disabled;}this.originalLabel=this.isInput?this.element.val():this.element.html();if(this.originalLabel){options.label=this.originalLabel;}return options;},_create:function _create(){if(!this.option.showLabel&!this.options.icon){this.options.showLabel=true;}// We have to check the option again here even though we did in _getCreateOptions,
// because null may have been passed on init which would override what was set in
// _getCreateOptions
if(this.options.disabled==null){this.options.disabled=this.element[0].disabled||false;}this.hasTitle=!!this.element.attr("title");// Check to see if the label needs to be set or if its already correct
if(this.options.label&&this.options.label!==this.originalLabel){if(this.isInput){this.element.val(this.options.label);}else{this.element.html(this.options.label);}}this._addClass("ui-button","ui-widget");this._setOption("disabled",this.options.disabled);this._enhance();if(this.element.is("a")){this._on({"keyup":function keyup(event){if(event.keyCode===$.ui.keyCode.SPACE){event.preventDefault();// Support: PhantomJS <= 1.9, IE 8 Only
// If a native click is available use it so we actually cause navigation
// otherwise just trigger a click event
if(this.element[0].click){this.element[0].click();}else{this.element.trigger("click");}}}});}},_enhance:function _enhance(){if(!this.element.is("button")){this.element.attr("role","button");}if(this.options.icon){this._updateIcon("icon",this.options.icon);this._updateTooltip();}},_updateTooltip:function _updateTooltip(){this.title=this.element.attr("title");if(!this.options.showLabel&&!this.title){this.element.attr("title",this.options.label);}},_updateIcon:function _updateIcon(option,value){var icon=option!=="iconPosition",position=icon?this.options.iconPosition:value,displayBlock=position==="top"||position==="bottom";// Create icon
if(!this.icon){this.icon=$("<span>");this._addClass(this.icon,"ui-button-icon","ui-icon");if(!this.options.showLabel){this._addClass("ui-button-icon-only");}}else if(icon){// If we are updating the icon remove the old icon class
this._removeClass(this.icon,null,this.options.icon);}// If we are updating the icon add the new icon class
if(icon){this._addClass(this.icon,null,value);}this._attachIcon(position);// If the icon is on top or bottom we need to add the ui-widget-icon-block class and remove
// the iconSpace if there is one.
if(displayBlock){this._addClass(this.icon,null,"ui-widget-icon-block");if(this.iconSpace){this.iconSpace.remove();}}else{// Position is beginning or end so remove the ui-widget-icon-block class and add the
// space if it does not exist
if(!this.iconSpace){this.iconSpace=$("<span> </span>");this._addClass(this.iconSpace,"ui-button-icon-space");}this._removeClass(this.icon,null,"ui-wiget-icon-block");this._attachIconSpace(position);}},_destroy:function _destroy(){this.element.removeAttr("role");if(this.icon){this.icon.remove();}if(this.iconSpace){this.iconSpace.remove();}if(!this.hasTitle){this.element.removeAttr("title");}},_attachIconSpace:function _attachIconSpace(iconPosition){this.icon[/^(?:end|bottom)/.test(iconPosition)?"before":"after"](this.iconSpace);},_attachIcon:function _attachIcon(iconPosition){this.element[/^(?:end|bottom)/.test(iconPosition)?"append":"prepend"](this.icon);},_setOptions:function _setOptions(options){var newShowLabel=options.showLabel===undefined?this.options.showLabel:options.showLabel,newIcon=options.icon===undefined?this.options.icon:options.icon;if(!newShowLabel&&!newIcon){options.showLabel=true;}this._super(options);},_setOption:function _setOption(key,value){if(key==="icon"){if(value){this._updateIcon(key,value);}else if(this.icon){this.icon.remove();if(this.iconSpace){this.iconSpace.remove();}}}if(key==="iconPosition"){this._updateIcon(key,value);}// Make sure we can't end up with a button that has neither text nor icon
if(key==="showLabel"){this._toggleClass("ui-button-icon-only",null,!value);this._updateTooltip();}if(key==="label"){if(this.isInput){this.element.val(value);}else{// If there is an icon, append it, else nothing then append the value
// this avoids removal of the icon when setting label text
this.element.html(value);if(this.icon){this._attachIcon(this.options.iconPosition);this._attachIconSpace(this.options.iconPosition);}}}this._super(key,value);if(key==="disabled"){this._toggleClass(null,"ui-state-disabled",value);this.element[0].disabled=value;if(value){this.element.blur();}}},refresh:function refresh(){// Make sure to only check disabled if its an element that supports this otherwise
// check for the disabled class to determine state
var isDisabled=this.element.is("input, button")?this.element[0].disabled:this.element.hasClass("ui-button-disabled");if(isDisabled!==this.options.disabled){this._setOptions({disabled:isDisabled});}this._updateTooltip();}});// DEPRECATED
if($.uiBackCompat!==false){// Text and Icons options
$.widget("ui.button",$.ui.button,{options:{text:true,icons:{primary:null,secondary:null}},_create:function _create(){if(this.options.showLabel&&!this.options.text){this.options.showLabel=this.options.text;}if(!this.options.showLabel&&this.options.text){this.options.text=this.options.showLabel;}if(!this.options.icon&&(this.options.icons.primary||this.options.icons.secondary)){if(this.options.icons.primary){this.options.icon=this.options.icons.primary;}else{this.options.icon=this.options.icons.secondary;this.options.iconPosition="end";}}else if(this.options.icon){this.options.icons.primary=this.options.icon;}this._super();},_setOption:function _setOption(key,value){if(key==="text"){this._super("showLabel",value);return;}if(key==="showLabel"){this.options.text=value;}if(key==="icon"){this.options.icons.primary=value;}if(key==="icons"){if(value.primary){this._super("icon",value.primary);this._super("iconPosition","beginning");}else if(value.secondary){this._super("icon",value.secondary);this._super("iconPosition","end");}}this._superApply(arguments);}});$.fn.button=function(orig){return function(){if(!this.length||this.length&&this[0].tagName!=="INPUT"||this.length&&this[0].tagName==="INPUT"&&this.attr("type")!=="checkbox"&&this.attr("type")!=="radio"){return orig.apply(this,arguments);}if(!$.ui.checkboxradio){$.error("Checkboxradio widget missing");}if(arguments.length===0){return this.checkboxradio({"icon":false});}return this.checkboxradio.apply(this,arguments);};}($.fn.button);$.fn.buttonset=function(){if(!$.ui.controlgroup){$.error("Controlgroup widget missing");}if(arguments[0]==="option"&&arguments[1]==="items"&&arguments[2]){return this.controlgroup.apply(this,[arguments[0],"items.button",arguments[2]]);}if(arguments[0]==="option"&&arguments[1]==="items"){return this.controlgroup.apply(this,[arguments[0],"items.button"]);}if(_typeof(arguments[0])==="object"&&arguments[0].items){arguments[0].items={button:arguments[0].items};}return this.controlgroup.apply(this,arguments);};}var widgetsButton=$.ui.button;// jscs:disable maximumLineLength
/* jscs:disable requireCamelCaseOrUpperCaseIdentifiers */ /*!
 * jQuery UI Datepicker 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */ //>>label: Datepicker
//>>group: Widgets
//>>description: Displays a calendar from an input or inline for selecting dates.
//>>docs: http://api.jqueryui.com/datepicker/
//>>demos: http://jqueryui.com/datepicker/
//>>css.structure: ../../themes/base/core.css
//>>css.structure: ../../themes/base/datepicker.css
//>>css.theme: ../../themes/base/theme.css
$.extend($.ui,{datepicker:{version:"1.12.1"}});var datepicker_instActive;function datepicker_getZindex(elem){var position,value;while(elem.length&&elem[0]!==document){// Ignore z-index if position is set to a value where z-index is ignored by the browser
// This makes behavior of this function consistent across browsers
// WebKit always returns auto if the element is positioned
position=elem.css("position");if(position==="absolute"||position==="relative"||position==="fixed"){// IE returns 0 when zIndex is not specified
// other browsers return a string
// we ignore the case of nested elements with an explicit value of 0
// <div style="z-index: -10;"><div style="z-index: 0;"></div></div>
value=parseInt(elem.css("zIndex"),10);if(!isNaN(value)&&value!==0){return value;}}elem=elem.parent();}return 0;}/* Date picker manager.
   Use the singleton instance of this class, $.datepicker, to interact with the date picker.
   Settings for (groups of) date pickers are maintained in an instance object,
   allowing multiple different settings on the same page. */function Datepicker(){this._curInst=null;// The current instance in use
this._keyEvent=false;// If the last event was a key event
this._disabledInputs=[];// List of date picker inputs that have been disabled
this._datepickerShowing=false;// True if the popup picker is showing , false if not
this._inDialog=false;// True if showing within a "dialog", false if not
this._mainDivId="ui-datepicker-div";// The ID of the main datepicker division
this._inlineClass="ui-datepicker-inline";// The name of the inline marker class
this._appendClass="ui-datepicker-append";// The name of the append marker class
this._triggerClass="ui-datepicker-trigger";// The name of the trigger marker class
this._dialogClass="ui-datepicker-dialog";// The name of the dialog marker class
this._disableClass="ui-datepicker-disabled";// The name of the disabled covering marker class
this._unselectableClass="ui-datepicker-unselectable";// The name of the unselectable cell marker class
this._currentClass="ui-datepicker-current-day";// The name of the current day marker class
this._dayOverClass="ui-datepicker-days-cell-over";// The name of the day hover marker class
this.regional=[];// Available regional settings, indexed by language code
this.regional[""]={// Default regional settings
closeText:"Done",// Display text for close link
prevText:"Prev",// Display text for previous month link
nextText:"Next",// Display text for next month link
currentText:"Today",// Display text for current month link
monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],// Names of months for drop-down and formatting
monthNamesShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],// For formatting
dayNames:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],// For formatting
dayNamesShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],// For formatting
dayNamesMin:["Su","Mo","Tu","We","Th","Fr","Sa"],// Column headings for days starting at Sunday
weekHeader:"Wk",// Column header for week of the year
dateFormat:"mm/dd/yy",// See format options on parseDate
firstDay:0,// The first day of the week, Sun = 0, Mon = 1, ...
isRTL:false,// True if right-to-left language, false if left-to-right
showMonthAfterYear:false,// True if the year select precedes month, false for month then year
yearSuffix:""// Additional text to append to the year in the month headers
};this._defaults={// Global defaults for all the date picker instances
showOn:"focus",// "focus" for popup on focus,
// "button" for trigger button, or "both" for either
showAnim:"fadeIn",// Name of jQuery animation for popup
showOptions:{},// Options for enhanced animations
defaultDate:null,// Used when field is blank: actual date,
// +/-number for offset from today, null for today
appendText:"",// Display text following the input box, e.g. showing the format
buttonText:"...",// Text for trigger button
buttonImage:"",// URL for trigger button image
buttonImageOnly:false,// True if the image appears alone, false if it appears on a button
hideIfNoPrevNext:false,// True to hide next/previous month links
// if not applicable, false to just disable them
navigationAsDateFormat:false,// True if date formatting applied to prev/today/next links
gotoCurrent:false,// True if today link goes back to current selection instead
changeMonth:false,// True if month can be selected directly, false if only prev/next
changeYear:false,// True if year can be selected directly, false if only prev/next
yearRange:"c-10:c+10",// Range of years to display in drop-down,
// either relative to today's year (-nn:+nn), relative to currently displayed year
// (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)
showOtherMonths:false,// True to show dates in other months, false to leave blank
selectOtherMonths:false,// True to allow selection of dates in other months, false for unselectable
showWeek:false,// True to show week of the year, false to not show it
calculateWeek:this.iso8601Week,// How to calculate the week of the year,
// takes a Date and returns the number of the week for it
shortYearCutoff:"+10",// Short year values < this are in the current century,
// > this are in the previous century,
// string value starting with "+" for current year + value
minDate:null,// The earliest selectable date, or null for no limit
maxDate:null,// The latest selectable date, or null for no limit
duration:"fast",// Duration of display/closure
beforeShowDay:null,// Function that takes a date and returns an array with
// [0] = true if selectable, false if not, [1] = custom CSS class name(s) or "",
// [2] = cell title (optional), e.g. $.datepicker.noWeekends
beforeShow:null,// Function that takes an input field and
// returns a set of custom settings for the date picker
onSelect:null,// Define a callback function when a date is selected
onChangeMonthYear:null,// Define a callback function when the month or year is changed
onClose:null,// Define a callback function when the datepicker is closed
numberOfMonths:1,// Number of months to show at a time
showCurrentAtPos:0,// The position in multipe months at which to show the current month (starting at 0)
stepMonths:1,// Number of months to step back/forward
stepBigMonths:12,// Number of months to step back/forward for the big links
altField:"",// Selector for an alternate field to store selected dates into
altFormat:"",// The date format to use for the alternate field
constrainInput:true,// The input is constrained by the current date format
showButtonPanel:false,// True to show button panel, false to not show it
autoSize:false,// True to size the input for the date format, false to leave as is
disabled:false// The initial disabled state
};$.extend(this._defaults,this.regional[""]);this.regional.en=$.extend(true,{},this.regional[""]);this.regional["en-US"]=$.extend(true,{},this.regional.en);this.dpDiv=datepicker_bindHover($("<div id='"+this._mainDivId+"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"));}$.extend(Datepicker.prototype,{/* Class name added to elements to indicate already configured with a date picker. */markerClassName:"hasDatepicker",//Keep track of the maximum number of rows displayed (see #7043)
maxRows:4,// TODO rename to "widget" when switching to widget factory
_widgetDatepicker:function _widgetDatepicker(){return this.dpDiv;},/* Override the default settings for all instances of the date picker.
	 * @param  settings  object - the new settings to use as defaults (anonymous object)
	 * @return the manager object
	 */setDefaults:function setDefaults(settings){datepicker_extendRemove(this._defaults,settings||{});return this;},/* Attach the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 * @param  settings  object - the new settings to use for this date picker instance (anonymous)
	 */_attachDatepicker:function _attachDatepicker(target,settings){var nodeName,inline,inst;nodeName=target.nodeName.toLowerCase();inline=nodeName==="div"||nodeName==="span";if(!target.id){this.uuid+=1;target.id="dp"+this.uuid;}inst=this._newInst($(target),inline);inst.settings=$.extend({},settings||{});if(nodeName==="input"){this._connectDatepicker(target,inst);}else if(inline){this._inlineDatepicker(target,inst);}},/* Create a new instance object. */_newInst:function _newInst(target,inline){var id=target[0].id.replace(/([^A-Za-z0-9_\-])/g,"\\\\$1");// escape jQuery meta chars
return{id:id,input:target,// associated target
selectedDay:0,selectedMonth:0,selectedYear:0,// current selection
drawMonth:0,drawYear:0,// month being drawn
inline:inline,// is datepicker inline or not
dpDiv:!inline?this.dpDiv:// presentation div
datepicker_bindHover($("<div class='"+this._inlineClass+" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>"))};},/* Attach the date picker to an input field. */_connectDatepicker:function _connectDatepicker(target,inst){var input=$(target);inst.append=$([]);inst.trigger=$([]);if(input.hasClass(this.markerClassName)){return;}this._attachments(input,inst);input.addClass(this.markerClassName).on("keydown",this._doKeyDown).on("keypress",this._doKeyPress).on("keyup",this._doKeyUp);this._autoSize(inst);$.data(target,"datepicker",inst);//If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)
if(inst.settings.disabled){this._disableDatepicker(target);}},/* Make attachments based on settings. */_attachments:function _attachments(input,inst){var showOn,buttonText,buttonImage,appendText=this._get(inst,"appendText"),isRTL=this._get(inst,"isRTL");if(inst.append){inst.append.remove();}if(appendText){inst.append=$("<span class='"+this._appendClass+"'>"+appendText+"</span>");input[isRTL?"before":"after"](inst.append);}input.off("focus",this._showDatepicker);if(inst.trigger){inst.trigger.remove();}showOn=this._get(inst,"showOn");if(showOn==="focus"||showOn==="both"){// pop-up date picker when in the marked field
input.on("focus",this._showDatepicker);}if(showOn==="button"||showOn==="both"){// pop-up date picker when button clicked
buttonText=this._get(inst,"buttonText");buttonImage=this._get(inst,"buttonImage");inst.trigger=$(this._get(inst,"buttonImageOnly")?$("<img/>").addClass(this._triggerClass).attr({src:buttonImage,alt:buttonText,title:buttonText}):$("<button type='button'></button>").addClass(this._triggerClass).html(!buttonImage?buttonText:$("<img/>").attr({src:buttonImage,alt:buttonText,title:buttonText})));input[isRTL?"before":"after"](inst.trigger);inst.trigger.on("click",function(){if($.datepicker._datepickerShowing&&$.datepicker._lastInput===input[0]){$.datepicker._hideDatepicker();}else if($.datepicker._datepickerShowing&&$.datepicker._lastInput!==input[0]){$.datepicker._hideDatepicker();$.datepicker._showDatepicker(input[0]);}else{$.datepicker._showDatepicker(input[0]);}return false;});}},/* Apply the maximum length for the date format. */_autoSize:function _autoSize(inst){if(this._get(inst,"autoSize")&&!inst.inline){var findMax,max,maxI,i,date=new Date(2009,12-1,20),// Ensure double digits
dateFormat=this._get(inst,"dateFormat");if(dateFormat.match(/[DM]/)){findMax=function findMax(names){max=0;maxI=0;for(i=0;i<names.length;i++){if(names[i].length>max){max=names[i].length;maxI=i;}}return maxI;};date.setMonth(findMax(this._get(inst,dateFormat.match(/MM/)?"monthNames":"monthNamesShort")));date.setDate(findMax(this._get(inst,dateFormat.match(/DD/)?"dayNames":"dayNamesShort"))+20-date.getDay());}inst.input.attr("size",this._formatDate(inst,date).length);}},/* Attach an inline date picker to a div. */_inlineDatepicker:function _inlineDatepicker(target,inst){var divSpan=$(target);if(divSpan.hasClass(this.markerClassName)){return;}divSpan.addClass(this.markerClassName).append(inst.dpDiv);$.data(target,"datepicker",inst);this._setDate(inst,this._getDefaultDate(inst),true);this._updateDatepicker(inst);this._updateAlternate(inst);//If disabled option is true, disable the datepicker before showing it (see ticket #5665)
if(inst.settings.disabled){this._disableDatepicker(target);}// Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements
// http://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height
inst.dpDiv.css("display","block");},/* Pop-up the date picker in a "dialog" box.
	 * @param  input element - ignored
	 * @param  date	string or Date - the initial date to display
	 * @param  onSelect  function - the function to call when a date is selected
	 * @param  settings  object - update the dialog date picker instance's settings (anonymous object)
	 * @param  pos int[2] - coordinates for the dialog's position within the screen or
	 *					event - with x/y coordinates or
	 *					leave empty for default (screen centre)
	 * @return the manager object
	 */_dialogDatepicker:function _dialogDatepicker(input,date,onSelect,settings,pos){var id,browserWidth,browserHeight,scrollX,scrollY,inst=this._dialogInst;// internal instance
if(!inst){this.uuid+=1;id="dp"+this.uuid;this._dialogInput=$("<input type='text' id='"+id+"' style='position: absolute; top: -100px; width: 0px;'/>");this._dialogInput.on("keydown",this._doKeyDown);$("body").append(this._dialogInput);inst=this._dialogInst=this._newInst(this._dialogInput,false);inst.settings={};$.data(this._dialogInput[0],"datepicker",inst);}datepicker_extendRemove(inst.settings,settings||{});date=date&&date.constructor===Date?this._formatDate(inst,date):date;this._dialogInput.val(date);this._pos=pos?pos.length?pos:[pos.pageX,pos.pageY]:null;if(!this._pos){browserWidth=document.documentElement.clientWidth;browserHeight=document.documentElement.clientHeight;scrollX=document.documentElement.scrollLeft||document.body.scrollLeft;scrollY=document.documentElement.scrollTop||document.body.scrollTop;this._pos=// should use actual width/height below
[browserWidth/2-100+scrollX,browserHeight/2-150+scrollY];}// Move input on screen for focus, but hidden behind dialog
this._dialogInput.css("left",this._pos[0]+20+"px").css("top",this._pos[1]+"px");inst.settings.onSelect=onSelect;this._inDialog=true;this.dpDiv.addClass(this._dialogClass);this._showDatepicker(this._dialogInput[0]);if($.blockUI){$.blockUI(this.dpDiv);}$.data(this._dialogInput[0],"datepicker",inst);return this;},/* Detach a datepicker from its control.
	 * @param  target	element - the target input field or division or span
	 */_destroyDatepicker:function _destroyDatepicker(target){var nodeName,$target=$(target),inst=$.data(target,"datepicker");if(!$target.hasClass(this.markerClassName)){return;}nodeName=target.nodeName.toLowerCase();$.removeData(target,"datepicker");if(nodeName==="input"){inst.append.remove();inst.trigger.remove();$target.removeClass(this.markerClassName).off("focus",this._showDatepicker).off("keydown",this._doKeyDown).off("keypress",this._doKeyPress).off("keyup",this._doKeyUp);}else if(nodeName==="div"||nodeName==="span"){$target.removeClass(this.markerClassName).empty();}if(datepicker_instActive===inst){datepicker_instActive=null;}},/* Enable the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 */_enableDatepicker:function _enableDatepicker(target){var nodeName,inline,$target=$(target),inst=$.data(target,"datepicker");if(!$target.hasClass(this.markerClassName)){return;}nodeName=target.nodeName.toLowerCase();if(nodeName==="input"){target.disabled=false;inst.trigger.filter("button").each(function(){this.disabled=false;}).end().filter("img").css({opacity:"1.0",cursor:""});}else if(nodeName==="div"||nodeName==="span"){inline=$target.children("."+this._inlineClass);inline.children().removeClass("ui-state-disabled");inline.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",false);}this._disabledInputs=$.map(this._disabledInputs,function(value){return value===target?null:value;});// delete entry
},/* Disable the date picker to a jQuery selection.
	 * @param  target	element - the target input field or division or span
	 */_disableDatepicker:function _disableDatepicker(target){var nodeName,inline,$target=$(target),inst=$.data(target,"datepicker");if(!$target.hasClass(this.markerClassName)){return;}nodeName=target.nodeName.toLowerCase();if(nodeName==="input"){target.disabled=true;inst.trigger.filter("button").each(function(){this.disabled=true;}).end().filter("img").css({opacity:"0.5",cursor:"default"});}else if(nodeName==="div"||nodeName==="span"){inline=$target.children("."+this._inlineClass);inline.children().addClass("ui-state-disabled");inline.find("select.ui-datepicker-month, select.ui-datepicker-year").prop("disabled",true);}this._disabledInputs=$.map(this._disabledInputs,function(value){return value===target?null:value;});// delete entry
this._disabledInputs[this._disabledInputs.length]=target;},/* Is the first field in a jQuery collection disabled as a datepicker?
	 * @param  target	element - the target input field or division or span
	 * @return boolean - true if disabled, false if enabled
	 */_isDisabledDatepicker:function _isDisabledDatepicker(target){if(!target){return false;}for(var i=0;i<this._disabledInputs.length;i++){if(this._disabledInputs[i]===target){return true;}}return false;},/* Retrieve the instance data for the target control.
	 * @param  target  element - the target input field or division or span
	 * @return  object - the associated instance data
	 * @throws  error if a jQuery problem getting data
	 */_getInst:function _getInst(target){try{return $.data(target,"datepicker");}catch(err){throw"Missing instance data for this datepicker";}},/* Update or retrieve the settings for a date picker attached to an input field or division.
	 * @param  target  element - the target input field or division or span
	 * @param  name	object - the new settings to update or
	 *				string - the name of the setting to change or retrieve,
	 *				when retrieving also "all" for all instance settings or
	 *				"defaults" for all global defaults
	 * @param  value   any - the new value for the setting
	 *				(omit if above is an object or to retrieve a value)
	 */_optionDatepicker:function _optionDatepicker(target,name,value){var settings,date,minDate,maxDate,inst=this._getInst(target);if(arguments.length===2&&typeof name==="string"){return name==="defaults"?$.extend({},$.datepicker._defaults):inst?name==="all"?$.extend({},inst.settings):this._get(inst,name):null;}settings=name||{};if(typeof name==="string"){settings={};settings[name]=value;}if(inst){if(this._curInst===inst){this._hideDatepicker();}date=this._getDateDatepicker(target,true);minDate=this._getMinMaxDate(inst,"min");maxDate=this._getMinMaxDate(inst,"max");datepicker_extendRemove(inst.settings,settings);// reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided
if(minDate!==null&&settings.dateFormat!==undefined&&settings.minDate===undefined){inst.settings.minDate=this._formatDate(inst,minDate);}if(maxDate!==null&&settings.dateFormat!==undefined&&settings.maxDate===undefined){inst.settings.maxDate=this._formatDate(inst,maxDate);}if("disabled"in settings){if(settings.disabled){this._disableDatepicker(target);}else{this._enableDatepicker(target);}}this._attachments($(target),inst);this._autoSize(inst);this._setDate(inst,date);this._updateAlternate(inst);this._updateDatepicker(inst);}},// Change method deprecated
_changeDatepicker:function _changeDatepicker(target,name,value){this._optionDatepicker(target,name,value);},/* Redraw the date picker attached to an input field or division.
	 * @param  target  element - the target input field or division or span
	 */_refreshDatepicker:function _refreshDatepicker(target){var inst=this._getInst(target);if(inst){this._updateDatepicker(inst);}},/* Set the dates for a jQuery selection.
	 * @param  target element - the target input field or division or span
	 * @param  date	Date - the new date
	 */_setDateDatepicker:function _setDateDatepicker(target,date){var inst=this._getInst(target);if(inst){this._setDate(inst,date);this._updateDatepicker(inst);this._updateAlternate(inst);}},/* Get the date(s) for the first entry in a jQuery selection.
	 * @param  target element - the target input field or division or span
	 * @param  noDefault boolean - true if no default date is to be used
	 * @return Date - the current date
	 */_getDateDatepicker:function _getDateDatepicker(target,noDefault){var inst=this._getInst(target);if(inst&&!inst.inline){this._setDateFromField(inst,noDefault);}return inst?this._getDate(inst):null;},/* Handle keystrokes. */_doKeyDown:function _doKeyDown(event){var onSelect,dateStr,sel,inst=$.datepicker._getInst(event.target),handled=true,isRTL=inst.dpDiv.is(".ui-datepicker-rtl");inst._keyEvent=true;if($.datepicker._datepickerShowing){switch(event.keyCode){case 9:$.datepicker._hideDatepicker();handled=false;break;// hide on tab out
case 13:sel=$("td."+$.datepicker._dayOverClass+":not(."+$.datepicker._currentClass+")",inst.dpDiv);if(sel[0]){$.datepicker._selectDay(event.target,inst.selectedMonth,inst.selectedYear,sel[0]);}onSelect=$.datepicker._get(inst,"onSelect");if(onSelect){dateStr=$.datepicker._formatDate(inst);// Trigger custom callback
onSelect.apply(inst.input?inst.input[0]:null,[dateStr,inst]);}else{$.datepicker._hideDatepicker();}return false;// don't submit the form
case 27:$.datepicker._hideDatepicker();break;// hide on escape
case 33:$.datepicker._adjustDate(event.target,event.ctrlKey?-$.datepicker._get(inst,"stepBigMonths"):-$.datepicker._get(inst,"stepMonths"),"M");break;// previous month/year on page up/+ ctrl
case 34:$.datepicker._adjustDate(event.target,event.ctrlKey?+$.datepicker._get(inst,"stepBigMonths"):+$.datepicker._get(inst,"stepMonths"),"M");break;// next month/year on page down/+ ctrl
case 35:if(event.ctrlKey||event.metaKey){$.datepicker._clearDate(event.target);}handled=event.ctrlKey||event.metaKey;break;// clear on ctrl or command +end
case 36:if(event.ctrlKey||event.metaKey){$.datepicker._gotoToday(event.target);}handled=event.ctrlKey||event.metaKey;break;// current on ctrl or command +home
case 37:if(event.ctrlKey||event.metaKey){$.datepicker._adjustDate(event.target,isRTL?+1:-1,"D");}handled=event.ctrlKey||event.metaKey;// -1 day on ctrl or command +left
if(event.originalEvent.altKey){$.datepicker._adjustDate(event.target,event.ctrlKey?-$.datepicker._get(inst,"stepBigMonths"):-$.datepicker._get(inst,"stepMonths"),"M");}// next month/year on alt +left on Mac
break;case 38:if(event.ctrlKey||event.metaKey){$.datepicker._adjustDate(event.target,-7,"D");}handled=event.ctrlKey||event.metaKey;break;// -1 week on ctrl or command +up
case 39:if(event.ctrlKey||event.metaKey){$.datepicker._adjustDate(event.target,isRTL?-1:+1,"D");}handled=event.ctrlKey||event.metaKey;// +1 day on ctrl or command +right
if(event.originalEvent.altKey){$.datepicker._adjustDate(event.target,event.ctrlKey?+$.datepicker._get(inst,"stepBigMonths"):+$.datepicker._get(inst,"stepMonths"),"M");}// next month/year on alt +right
break;case 40:if(event.ctrlKey||event.metaKey){$.datepicker._adjustDate(event.target,+7,"D");}handled=event.ctrlKey||event.metaKey;break;// +1 week on ctrl or command +down
default:handled=false;}}else if(event.keyCode===36&&event.ctrlKey){// display the date picker on ctrl+home
$.datepicker._showDatepicker(this);}else{handled=false;}if(handled){event.preventDefault();event.stopPropagation();}},/* Filter entered characters - based on date format. */_doKeyPress:function _doKeyPress(event){var chars,chr,inst=$.datepicker._getInst(event.target);if($.datepicker._get(inst,"constrainInput")){chars=$.datepicker._possibleChars($.datepicker._get(inst,"dateFormat"));chr=String.fromCharCode(event.charCode==null?event.keyCode:event.charCode);return event.ctrlKey||event.metaKey||chr<" "||!chars||chars.indexOf(chr)>-1;}},/* Synchronise manual entry and field/alternate field. */_doKeyUp:function _doKeyUp(event){var date,inst=$.datepicker._getInst(event.target);if(inst.input.val()!==inst.lastVal){try{date=$.datepicker.parseDate($.datepicker._get(inst,"dateFormat"),inst.input?inst.input.val():null,$.datepicker._getFormatConfig(inst));if(date){// only if valid
$.datepicker._setDateFromField(inst);$.datepicker._updateAlternate(inst);$.datepicker._updateDatepicker(inst);}}catch(err){}}return true;},/* Pop-up the date picker for a given input field.
	 * If false returned from beforeShow event handler do not show.
	 * @param  input  element - the input field attached to the date picker or
	 *					event - if triggered by focus
	 */_showDatepicker:function _showDatepicker(input){input=input.target||input;if(input.nodeName.toLowerCase()!=="input"){// find from button/image trigger
input=$("input",input.parentNode)[0];}if($.datepicker._isDisabledDatepicker(input)||$.datepicker._lastInput===input){// already here
return;}var inst,beforeShow,beforeShowSettings,isFixed,offset,showAnim,duration;inst=$.datepicker._getInst(input);if($.datepicker._curInst&&$.datepicker._curInst!==inst){$.datepicker._curInst.dpDiv.stop(true,true);if(inst&&$.datepicker._datepickerShowing){$.datepicker._hideDatepicker($.datepicker._curInst.input[0]);}}beforeShow=$.datepicker._get(inst,"beforeShow");beforeShowSettings=beforeShow?beforeShow.apply(input,[input,inst]):{};if(beforeShowSettings===false){return;}datepicker_extendRemove(inst.settings,beforeShowSettings);inst.lastVal=null;$.datepicker._lastInput=input;$.datepicker._setDateFromField(inst);if($.datepicker._inDialog){// hide cursor
input.value="";}if(!$.datepicker._pos){// position below input
$.datepicker._pos=$.datepicker._findPos(input);$.datepicker._pos[1]+=input.offsetHeight;// add the height
}isFixed=false;$(input).parents().each(function(){isFixed|=$(this).css("position")==="fixed";return!isFixed;});offset={left:$.datepicker._pos[0],top:$.datepicker._pos[1]};$.datepicker._pos=null;//to avoid flashes on Firefox
inst.dpDiv.empty();// determine sizing offscreen
inst.dpDiv.css({position:"absolute",display:"block",top:"-1000px"});$.datepicker._updateDatepicker(inst);// fix width for dynamic number of date pickers
// and adjust position before showing
offset=$.datepicker._checkOffset(inst,offset,isFixed);inst.dpDiv.css({position:$.datepicker._inDialog&&$.blockUI?"static":isFixed?"fixed":"absolute",display:"none",left:offset.left+"px",top:offset.top+"px"});if(!inst.inline){showAnim=$.datepicker._get(inst,"showAnim");duration=$.datepicker._get(inst,"duration");inst.dpDiv.css("z-index",datepicker_getZindex($(input))+1);$.datepicker._datepickerShowing=true;if($.effects&&$.effects.effect[showAnim]){inst.dpDiv.show(showAnim,$.datepicker._get(inst,"showOptions"),duration);}else{inst.dpDiv[showAnim||"show"](showAnim?duration:null);}if($.datepicker._shouldFocusInput(inst)){inst.input.trigger("focus");}$.datepicker._curInst=inst;}},/* Generate the date picker content. */_updateDatepicker:function _updateDatepicker(inst){this.maxRows=4;//Reset the max number of rows being displayed (see #7043)
datepicker_instActive=inst;// for delegate hover events
inst.dpDiv.empty().append(this._generateHTML(inst));this._attachHandlers(inst);var origyearshtml,numMonths=this._getNumberOfMonths(inst),cols=numMonths[1],width=17,activeCell=inst.dpDiv.find("."+this._dayOverClass+" a");if(activeCell.length>0){datepicker_handleMouseover.apply(activeCell.get(0));}inst.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width("");if(cols>1){inst.dpDiv.addClass("ui-datepicker-multi-"+cols).css("width",width*cols+"em");}inst.dpDiv[(numMonths[0]!==1||numMonths[1]!==1?"add":"remove")+"Class"]("ui-datepicker-multi");inst.dpDiv[(this._get(inst,"isRTL")?"add":"remove")+"Class"]("ui-datepicker-rtl");if(inst===$.datepicker._curInst&&$.datepicker._datepickerShowing&&$.datepicker._shouldFocusInput(inst)){inst.input.trigger("focus");}// Deffered render of the years select (to avoid flashes on Firefox)
if(inst.yearshtml){origyearshtml=inst.yearshtml;setTimeout(function(){//assure that inst.yearshtml didn't change.
if(origyearshtml===inst.yearshtml&&inst.yearshtml){inst.dpDiv.find("select.ui-datepicker-year:first").replaceWith(inst.yearshtml);}origyearshtml=inst.yearshtml=null;},0);}},// #6694 - don't focus the input if it's already focused
// this breaks the change event in IE
// Support: IE and jQuery <1.9
_shouldFocusInput:function _shouldFocusInput(inst){return inst.input&&inst.input.is(":visible")&&!inst.input.is(":disabled")&&!inst.input.is(":focus");},/* Check positioning to remain on screen. */_checkOffset:function _checkOffset(inst,offset,isFixed){var dpWidth=inst.dpDiv.outerWidth(),dpHeight=inst.dpDiv.outerHeight(),inputWidth=inst.input?inst.input.outerWidth():0,inputHeight=inst.input?inst.input.outerHeight():0,viewWidth=document.documentElement.clientWidth+(isFixed?0:$(document).scrollLeft()),viewHeight=document.documentElement.clientHeight+(isFixed?0:$(document).scrollTop());offset.left-=this._get(inst,"isRTL")?dpWidth-inputWidth:0;offset.left-=isFixed&&offset.left===inst.input.offset().left?$(document).scrollLeft():0;offset.top-=isFixed&&offset.top===inst.input.offset().top+inputHeight?$(document).scrollTop():0;// Now check if datepicker is showing outside window viewport - move to a better place if so.
offset.left-=Math.min(offset.left,offset.left+dpWidth>viewWidth&&viewWidth>dpWidth?Math.abs(offset.left+dpWidth-viewWidth):0);offset.top-=Math.min(offset.top,offset.top+dpHeight>viewHeight&&viewHeight>dpHeight?Math.abs(dpHeight+inputHeight):0);return offset;},/* Find an object's position on the screen. */_findPos:function _findPos(obj){var position,inst=this._getInst(obj),isRTL=this._get(inst,"isRTL");while(obj&&(obj.type==="hidden"||obj.nodeType!==1||$.expr.filters.hidden(obj))){obj=obj[isRTL?"previousSibling":"nextSibling"];}position=$(obj).offset();return[position.left,position.top];},/* Hide the date picker from view.
	 * @param  input  element - the input field attached to the date picker
	 */_hideDatepicker:function _hideDatepicker(input){var showAnim,duration,postProcess,onClose,inst=this._curInst;if(!inst||input&&inst!==$.data(input,"datepicker")){return;}if(this._datepickerShowing){showAnim=this._get(inst,"showAnim");duration=this._get(inst,"duration");postProcess=function postProcess(){$.datepicker._tidyDialog(inst);};// DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed
if($.effects&&($.effects.effect[showAnim]||$.effects[showAnim])){inst.dpDiv.hide(showAnim,$.datepicker._get(inst,"showOptions"),duration,postProcess);}else{inst.dpDiv[showAnim==="slideDown"?"slideUp":showAnim==="fadeIn"?"fadeOut":"hide"](showAnim?duration:null,postProcess);}if(!showAnim){postProcess();}this._datepickerShowing=false;onClose=this._get(inst,"onClose");if(onClose){onClose.apply(inst.input?inst.input[0]:null,[inst.input?inst.input.val():"",inst]);}this._lastInput=null;if(this._inDialog){this._dialogInput.css({position:"absolute",left:"0",top:"-100px"});if($.blockUI){$.unblockUI();$("body").append(this.dpDiv);}}this._inDialog=false;}},/* Tidy up after a dialog display. */_tidyDialog:function _tidyDialog(inst){inst.dpDiv.removeClass(this._dialogClass).off(".ui-datepicker-calendar");},/* Close date picker if clicked elsewhere. */_checkExternalClick:function _checkExternalClick(event){if(!$.datepicker._curInst){return;}var $target=$(event.target),inst=$.datepicker._getInst($target[0]);if($target[0].id!==$.datepicker._mainDivId&&$target.parents("#"+$.datepicker._mainDivId).length===0&&!$target.hasClass($.datepicker.markerClassName)&&!$target.closest("."+$.datepicker._triggerClass).length&&$.datepicker._datepickerShowing&&!($.datepicker._inDialog&&$.blockUI)||$target.hasClass($.datepicker.markerClassName)&&$.datepicker._curInst!==inst){$.datepicker._hideDatepicker();}},/* Adjust one of the date sub-fields. */_adjustDate:function _adjustDate(id,offset,period){var target=$(id),inst=this._getInst(target[0]);if(this._isDisabledDatepicker(target[0])){return;}this._adjustInstDate(inst,offset+(period==="M"?this._get(inst,"showCurrentAtPos"):0),// undo positioning
period);this._updateDatepicker(inst);},/* Action for current link. */_gotoToday:function _gotoToday(id){var date,target=$(id),inst=this._getInst(target[0]);if(this._get(inst,"gotoCurrent")&&inst.currentDay){inst.selectedDay=inst.currentDay;inst.drawMonth=inst.selectedMonth=inst.currentMonth;inst.drawYear=inst.selectedYear=inst.currentYear;}else{date=new Date();inst.selectedDay=date.getDate();inst.drawMonth=inst.selectedMonth=date.getMonth();inst.drawYear=inst.selectedYear=date.getFullYear();}this._notifyChange(inst);this._adjustDate(target);},/* Action for selecting a new month/year. */_selectMonthYear:function _selectMonthYear(id,select,period){var target=$(id),inst=this._getInst(target[0]);inst["selected"+(period==="M"?"Month":"Year")]=inst["draw"+(period==="M"?"Month":"Year")]=parseInt(select.options[select.selectedIndex].value,10);this._notifyChange(inst);this._adjustDate(target);},/* Action for selecting a day. */_selectDay:function _selectDay(id,month,year,td){var inst,target=$(id);if($(td).hasClass(this._unselectableClass)||this._isDisabledDatepicker(target[0])){return;}inst=this._getInst(target[0]);inst.selectedDay=inst.currentDay=$("a",td).html();inst.selectedMonth=inst.currentMonth=month;inst.selectedYear=inst.currentYear=year;this._selectDate(id,this._formatDate(inst,inst.currentDay,inst.currentMonth,inst.currentYear));},/* Erase the input field and hide the date picker. */_clearDate:function _clearDate(id){var target=$(id);this._selectDate(target,"");},/* Update the input field with the selected date. */_selectDate:function _selectDate(id,dateStr){var onSelect,target=$(id),inst=this._getInst(target[0]);dateStr=dateStr!=null?dateStr:this._formatDate(inst);if(inst.input){inst.input.val(dateStr);}this._updateAlternate(inst);onSelect=this._get(inst,"onSelect");if(onSelect){onSelect.apply(inst.input?inst.input[0]:null,[dateStr,inst]);// trigger custom callback
}else if(inst.input){inst.input.trigger("change");// fire the change event
}if(inst.inline){this._updateDatepicker(inst);}else{this._hideDatepicker();this._lastInput=inst.input[0];if(_typeof(inst.input[0])!=="object"){inst.input.trigger("focus");// restore focus
}this._lastInput=null;}},/* Update any alternate field to synchronise with the main field. */_updateAlternate:function _updateAlternate(inst){var altFormat,date,dateStr,altField=this._get(inst,"altField");if(altField){// update alternate field too
altFormat=this._get(inst,"altFormat")||this._get(inst,"dateFormat");date=this._getDate(inst);dateStr=this.formatDate(altFormat,date,this._getFormatConfig(inst));$(altField).val(dateStr);}},/* Set as beforeShowDay function to prevent selection of weekends.
	 * @param  date  Date - the date to customise
	 * @return [boolean, string] - is this date selectable?, what is its CSS class?
	 */noWeekends:function noWeekends(date){var day=date.getDay();return[day>0&&day<6,""];},/* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.
	 * @param  date  Date - the date to get the week for
	 * @return  number - the number of the week within the year that contains this date
	 */iso8601Week:function iso8601Week(date){var time,checkDate=new Date(date.getTime());// Find Thursday of this week starting on Monday
checkDate.setDate(checkDate.getDate()+4-(checkDate.getDay()||7));time=checkDate.getTime();checkDate.setMonth(0);// Compare with Jan 1
checkDate.setDate(1);return Math.floor(Math.round((time-checkDate)/86400000)/7)+1;},/* Parse a string value into a date object.
	 * See formatDate below for the possible formats.
	 *
	 * @param  format string - the expected format of the date
	 * @param  value string - the date in the above format
	 * @param  settings Object - attributes include:
	 *					shortYearCutoff  number - the cutoff year for determining the century (optional)
	 *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
	 *					dayNames		string[7] - names of the days from Sunday (optional)
	 *					monthNamesShort string[12] - abbreviated names of the months (optional)
	 *					monthNames		string[12] - names of the months (optional)
	 * @return  Date - the extracted date value or null if value is blank
	 */parseDate:function parseDate(format,value,settings){if(format==null||value==null){throw"Invalid arguments";}value=_typeof(value)==="object"?value.toString():value+"";if(value===""){return null;}var iFormat,dim,extra,iValue=0,shortYearCutoffTemp=(settings?settings.shortYearCutoff:null)||this._defaults.shortYearCutoff,shortYearCutoff=typeof shortYearCutoffTemp!=="string"?shortYearCutoffTemp:new Date().getFullYear()%100+parseInt(shortYearCutoffTemp,10),dayNamesShort=(settings?settings.dayNamesShort:null)||this._defaults.dayNamesShort,dayNames=(settings?settings.dayNames:null)||this._defaults.dayNames,monthNamesShort=(settings?settings.monthNamesShort:null)||this._defaults.monthNamesShort,monthNames=(settings?settings.monthNames:null)||this._defaults.monthNames,year=-1,month=-1,day=-1,doy=-1,literal=false,date,// Check whether a format character is doubled
lookAhead=function lookAhead(match){var matches=iFormat+1<format.length&&format.charAt(iFormat+1)===match;if(matches){iFormat++;}return matches;},// Extract a number from the string value
getNumber=function getNumber(match){var isDoubled=lookAhead(match),size=match==="@"?14:match==="!"?20:match==="y"&&isDoubled?4:match==="o"?3:2,minSize=match==="y"?size:1,digits=new RegExp("^\\d{"+minSize+","+size+"}"),num=value.substring(iValue).match(digits);if(!num){throw"Missing number at position "+iValue;}iValue+=num[0].length;return parseInt(num[0],10);},// Extract a name from the string value and convert to an index
getName=function getName(match,shortNames,longNames){var index=-1,names=$.map(lookAhead(match)?longNames:shortNames,function(v,k){return[[k,v]];}).sort(function(a,b){return-(a[1].length-b[1].length);});$.each(names,function(i,pair){var name=pair[1];if(value.substr(iValue,name.length).toLowerCase()===name.toLowerCase()){index=pair[0];iValue+=name.length;return false;}});if(index!==-1){return index+1;}else{throw"Unknown name at position "+iValue;}},// Confirm that a literal character matches the string value
checkLiteral=function checkLiteral(){if(value.charAt(iValue)!==format.charAt(iFormat)){throw"Unexpected literal at position "+iValue;}iValue++;};for(iFormat=0;iFormat<format.length;iFormat++){if(literal){if(format.charAt(iFormat)==="'"&&!lookAhead("'")){literal=false;}else{checkLiteral();}}else{switch(format.charAt(iFormat)){case"d":day=getNumber("d");break;case"D":getName("D",dayNamesShort,dayNames);break;case"o":doy=getNumber("o");break;case"m":month=getNumber("m");break;case"M":month=getName("M",monthNamesShort,monthNames);break;case"y":year=getNumber("y");break;case"@":date=new Date(getNumber("@"));year=date.getFullYear();month=date.getMonth()+1;day=date.getDate();break;case"!":date=new Date((getNumber("!")-this._ticksTo1970)/10000);year=date.getFullYear();month=date.getMonth()+1;day=date.getDate();break;case"'":if(lookAhead("'")){checkLiteral();}else{literal=true;}break;default:checkLiteral();}}}if(iValue<value.length){extra=value.substr(iValue);if(!/^\s+/.test(extra)){throw"Extra/unparsed characters found in date: "+extra;}}if(year===-1){year=new Date().getFullYear();}else if(year<100){year+=new Date().getFullYear()-new Date().getFullYear()%100+(year<=shortYearCutoff?0:-100);}if(doy>-1){month=1;day=doy;do{dim=this._getDaysInMonth(year,month-1);if(day<=dim){break;}month++;day-=dim;}while(true);}date=this._daylightSavingAdjust(new Date(year,month-1,day));if(date.getFullYear()!==year||date.getMonth()+1!==month||date.getDate()!==day){throw"Invalid date";// E.g. 31/02/00
}return date;},/* Standard date formats. */ATOM:"yy-mm-dd",// RFC 3339 (ISO 8601)
COOKIE:"D, dd M yy",ISO_8601:"yy-mm-dd",RFC_822:"D, d M y",RFC_850:"DD, dd-M-y",RFC_1036:"D, d M y",RFC_1123:"D, d M yy",RFC_2822:"D, d M yy",RSS:"D, d M y",// RFC 822
TICKS:"!",TIMESTAMP:"@",W3C:"yy-mm-dd",// ISO 8601
_ticksTo1970:((1970-1)*365+Math.floor(1970/4)-Math.floor(1970/100)+Math.floor(1970/400))*24*60*60*10000000,/* Format a date object into a string value.
	 * The format can be combinations of the following:
	 * d  - day of month (no leading zero)
	 * dd - day of month (two digit)
	 * o  - day of year (no leading zeros)
	 * oo - day of year (three digit)
	 * D  - day name short
	 * DD - day name long
	 * m  - month of year (no leading zero)
	 * mm - month of year (two digit)
	 * M  - month name short
	 * MM - month name long
	 * y  - year (two digit)
	 * yy - year (four digit)
	 * @ - Unix timestamp (ms since 01/01/1970)
	 * ! - Windows ticks (100ns since 01/01/0001)
	 * "..." - literal text
	 * '' - single quote
	 *
	 * @param  format string - the desired format of the date
	 * @param  date Date - the date value to format
	 * @param  settings Object - attributes include:
	 *					dayNamesShort	string[7] - abbreviated names of the days from Sunday (optional)
	 *					dayNames		string[7] - names of the days from Sunday (optional)
	 *					monthNamesShort string[12] - abbreviated names of the months (optional)
	 *					monthNames		string[12] - names of the months (optional)
	 * @return  string - the date in the above format
	 */formatDate:function formatDate(format,date,settings){if(!date){return"";}var iFormat,dayNamesShort=(settings?settings.dayNamesShort:null)||this._defaults.dayNamesShort,dayNames=(settings?settings.dayNames:null)||this._defaults.dayNames,monthNamesShort=(settings?settings.monthNamesShort:null)||this._defaults.monthNamesShort,monthNames=(settings?settings.monthNames:null)||this._defaults.monthNames,// Check whether a format character is doubled
lookAhead=function lookAhead(match){var matches=iFormat+1<format.length&&format.charAt(iFormat+1)===match;if(matches){iFormat++;}return matches;},// Format a number, with leading zero if necessary
formatNumber=function formatNumber(match,value,len){var num=""+value;if(lookAhead(match)){while(num.length<len){num="0"+num;}}return num;},// Format a name, short or long as requested
formatName=function formatName(match,value,shortNames,longNames){return lookAhead(match)?longNames[value]:shortNames[value];},output="",literal=false;if(date){for(iFormat=0;iFormat<format.length;iFormat++){if(literal){if(format.charAt(iFormat)==="'"&&!lookAhead("'")){literal=false;}else{output+=format.charAt(iFormat);}}else{switch(format.charAt(iFormat)){case"d":output+=formatNumber("d",date.getDate(),2);break;case"D":output+=formatName("D",date.getDay(),dayNamesShort,dayNames);break;case"o":output+=formatNumber("o",Math.round((new Date(date.getFullYear(),date.getMonth(),date.getDate()).getTime()-new Date(date.getFullYear(),0,0).getTime())/86400000),3);break;case"m":output+=formatNumber("m",date.getMonth()+1,2);break;case"M":output+=formatName("M",date.getMonth(),monthNamesShort,monthNames);break;case"y":output+=lookAhead("y")?date.getFullYear():(date.getFullYear()%100<10?"0":"")+date.getFullYear()%100;break;case"@":output+=date.getTime();break;case"!":output+=date.getTime()*10000+this._ticksTo1970;break;case"'":if(lookAhead("'")){output+="'";}else{literal=true;}break;default:output+=format.charAt(iFormat);}}}}return output;},/* Extract all possible characters from the date format. */_possibleChars:function _possibleChars(format){var iFormat,chars="",literal=false,// Check whether a format character is doubled
lookAhead=function lookAhead(match){var matches=iFormat+1<format.length&&format.charAt(iFormat+1)===match;if(matches){iFormat++;}return matches;};for(iFormat=0;iFormat<format.length;iFormat++){if(literal){if(format.charAt(iFormat)==="'"&&!lookAhead("'")){literal=false;}else{chars+=format.charAt(iFormat);}}else{switch(format.charAt(iFormat)){case"d":case"m":case"y":case"@":chars+="0123456789";break;case"D":case"M":return null;// Accept anything
case"'":if(lookAhead("'")){chars+="'";}else{literal=true;}break;default:chars+=format.charAt(iFormat);}}}return chars;},/* Get a setting value, defaulting if necessary. */_get:function _get(inst,name){return inst.settings[name]!==undefined?inst.settings[name]:this._defaults[name];},/* Parse existing date and initialise date picker. */_setDateFromField:function _setDateFromField(inst,noDefault){if(inst.input.val()===inst.lastVal){return;}var dateFormat=this._get(inst,"dateFormat"),dates=inst.lastVal=inst.input?inst.input.val():null,defaultDate=this._getDefaultDate(inst),date=defaultDate,settings=this._getFormatConfig(inst);try{date=this.parseDate(dateFormat,dates,settings)||defaultDate;}catch(event){dates=noDefault?"":dates;}inst.selectedDay=date.getDate();inst.drawMonth=inst.selectedMonth=date.getMonth();inst.drawYear=inst.selectedYear=date.getFullYear();inst.currentDay=dates?date.getDate():0;inst.currentMonth=dates?date.getMonth():0;inst.currentYear=dates?date.getFullYear():0;this._adjustInstDate(inst);},/* Retrieve the default date shown on opening. */_getDefaultDate:function _getDefaultDate(inst){return this._restrictMinMax(inst,this._determineDate(inst,this._get(inst,"defaultDate"),new Date()));},/* A date may be specified as an exact value or a relative one. */_determineDate:function _determineDate(inst,date,defaultDate){var offsetNumeric=function offsetNumeric(offset){var date=new Date();date.setDate(date.getDate()+offset);return date;},offsetString=function offsetString(offset){try{return $.datepicker.parseDate($.datepicker._get(inst,"dateFormat"),offset,$.datepicker._getFormatConfig(inst));}catch(e){// Ignore
}var date=(offset.toLowerCase().match(/^c/)?$.datepicker._getDate(inst):null)||new Date(),year=date.getFullYear(),month=date.getMonth(),day=date.getDate(),pattern=/([+\-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g,matches=pattern.exec(offset);while(matches){switch(matches[2]||"d"){case"d":case"D":day+=parseInt(matches[1],10);break;case"w":case"W":day+=parseInt(matches[1],10)*7;break;case"m":case"M":month+=parseInt(matches[1],10);day=Math.min(day,$.datepicker._getDaysInMonth(year,month));break;case"y":case"Y":year+=parseInt(matches[1],10);day=Math.min(day,$.datepicker._getDaysInMonth(year,month));break;}matches=pattern.exec(offset);}return new Date(year,month,day);},newDate=date==null||date===""?defaultDate:typeof date==="string"?offs