@push('scripts')
    <script>

        $(document).ready(function(){
            $(document).on('submit', '#item_delete_form', function(event) {
                event.preventDefault();
                $('#pre-loader').removeClass('d-none');
                $('#deleteItemModal').modal('hide');
                let formData = new FormData();
                formData.append('_token', "{{ csrf_token() }}");
                formData.append('id', $('#delete_item_id').val());
                let id = $('#delete_item_id').val();
                $.ajax({
                    url: "{{ route('marketing.new-user-zone.delete') }}",
                    type: "POST",
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: formData,
                    success: function(response) {
                        reloadWithData(response);
                        toastr.success('{{__("common.deleted_successfully")}}', '{{__("common.success")}}')
                        $('#pre-loader').addClass('d-none');
                    },
                    error: function(response) {
                            if(response.responseJSON.error){
                                toastr.error(response.responseJSON.error ,"{{__('common.error')}}");
                                $('#pre-loader').addClass('d-none');
                                return false;
                            }
                        toastr.error('{{__("common.error_message")}}')
                        $('#pre-loader').addClass('d-none');
                    }
                });
            });

            $(document).on('change', '.changeStatus', function(event){
                let id = $(this).data('id');
                let status = 0;
                if($(this).prop('checked')){
                    status = 1;
                }
                else{
                    status = 0;
                }
                $('#pre-loader').removeClass('d-none');
                let formData = new FormData();
                formData.append('_token', "{{ csrf_token() }}");
                formData.append('id', id);
                formData.append('status', status);

                $.ajax({
                    url: "{{ route('marketing.new-user-zone.status') }}",
                    type: "POST",
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: formData,
                    success: function(response) {
                        toastr.success("{{__('common.updated_successfully')}}","{{__('common.success')}}");
                        $('#pre-loader').addClass('d-none');
                        reloadWithData(response);
                    },
                    error: function(response) {
                            if(response.responseJSON.error){
                                toastr.error(response.responseJSON.error ,"{{__('common.error')}}");
                                $('#pre-loader').addClass('d-none');
                                return false;
                            }
                        toastr.error("{{__('common.error_message')}}");
                        $('#pre-loader').addClass('d-none');
                    }
                });
            });

            $(document).on('change', '.changeFeatured', function(event){
                let id = $(this).data('id');
                let is_featured = 0;
                if($(this).prop('checked')){
                    is_featured = 1;
                }
                else{
                    is_featured = 0;
                }
                $('#pre-loader').removeClass('d-none');

                let formData = new FormData();
                formData.append('_token', "{{ csrf_token() }}");
                formData.append('id', id);
                formData.append('is_featured', is_featured);

                $.ajax({
                    url: "{{ route('marketing.new-user-zone.featured') }}",
                    type: "POST",
                    cache: false,
                    contentType: false,
                    processData: false,
                    data: formData,
                    success: function(response) {
                        toastr.success("{{__('common.updated_successfully')}}","{{__('common.success')}}");
                        $('#pre-loader').addClass('d-none');
                    },
                    error: function(response) {
                            if(response.responseJSON.error){
                                toastr.error(response.responseJSON.error ,"{{__('common.error')}}");
                                $('#pre-loader').addClass('d-none');
                                return false;
                            }
                        toastr.error("{{__('common.error_message')}}");
                        $('#pre-loader').addClass('d-none');
                    }
                });
            });

            $(document).on('click', '.delete_zone', function(event){
                event.preventDefault();
                let id = $(this).data('id');
                $('#delete_item_id').val(id);
                $('#deleteItemModal').modal('show');

            });

            function reloadWithData(response){
                $('#item_table').empty();
                $('#item_table').html(response);
                CRMTableThreeReactive();
            }

        });
    </script>
@endpush
